
if not screen_print then screen_print = {} end
screen_print.new_print = {}
screen_print.print = {}

-- Draw print messages
function screen_print.update()
	local length = #screen_print.print + #screen_print.new_print
	local line = 0
	for i, str in ipairs(screen_print.print) do
		scene:WriteToScreen(str, VectorF(15, 200 + (length-1)*12 + line*12), false, ColorRGBA(180, 180, 0, 255))
		line = line-1
	end
	if #screen_print.new_print > 0 then
		for i, str in ipairs(screen_print.new_print) do
			scene:WriteToScreen(str, VectorF(15, 200 + (length-1)*12 + line*12), false, ColorRGBA(255, 255, 0, 255))
			line = line-1
			table.insert(screen_print.print, str)
		end
		screen_print.new_print = {}
		
		local max_lines = 30
		max_lines = max_lines -1
		local length = #screen_print.print
		if length > max_lines then 
			screen_print.print = {unpack(screen_print.print, length-max_lines)}
		end
	end
end

-- Print to screen
function print(...)
	local count = select("#", ...)
	local args = { ... }
	local buffer = {}
	for i = 1, count do
		if type(args[i]) == "table" then
			table.insert(buffer, table2string(args[i]))
		else
			table.insert(buffer, tostring(args[i]))
		end
		table.insert(buffer, ", ")
	end
	buffer[#buffer] = nil
	table.insert(screen_print.new_print, table.concat(buffer))
end

-- Print to console
function printc(...)
	local count = select("#", ...)
	local args = { ... }
	local buffer = {}
	for i = 1, count do
		table.insert(buffer, tostring(args[i]))
		table.insert(buffer, "\t")
	end
	buffer[#buffer] = nil
	c2d:AddLuaResultStringToConsole(table.concat(buffer))
end

-- Print the contents of tables
function print_table(t, tabs)
	local tabs_v = tabs or ""
	for key, value in pairs(t) do
		if type(value) == "table" then
			print(tabs_v..tostring(key))
			print_table(value, tabs_v.."\t")
		else
			print(tabs_v..tostring(key)..": "..tostring(value))
		end
	end
end

