
math.fourthpi = math.pi * 0.25
math.halfpi = math.pi * 0.5
math.twopi = math.pi * 2.0

-- Convert the angle "value" to an identical angle in the [min_value..max_value] range. e.g. math.frotate(-math.pi, math.pi, math.twopi) return 0
function math.frotate(min_value, max_value, value)
  local l = max_value-min_value
  if l==0 then return min_value end
  local ret = (value - min_value) % l + min_value
  if ret < min_value then ret = ret + l end
  return ret
end

-- Clamp n to a value between min and max
function math.clamp(n, min, max)
  return n > max and max or n < min and min or n
end

-- Sine ease with values between 0 and 1. fast -> slow
function math.easeOut(time)
  return math.sin(time * math.halfpi)
end

-- Cosine ease with values between 0 and 1. slow -> fast
function math.easeIn(time)
	return 1 - math.cos(time * math.halfpi)
end

-- Ease first in and then out with values between 0 and 1. slow -> fast -> slow
function math.easeInOut(time)
	return -0.5*(math.cos(math.pi * time) - 1)
end
