import xmltodict, types

# TODO: don't list classes with subclasses twice (e.g. Controller & Controller::PlayerInput)

# check that the arguments are the same
def same_argsstring(input_args, target_types, param_len):
  if param_len < 1:
    return True
  args = input_args.replace('const', '')
  args = args.replace('&', '')
  args = args.lstrip()
  args = args.rstrip()
  args = args.split()
  if param_len * 2 != len(args):
    return False
  i = 0
  for j in range(0, param_len):
    if args[i] != target_types[j]:
      return False
    i += 2
  return True
  
  
def find_in_tree(tree, name, member_to_find, param_list):
  type_names = {}
  type_names['void'] = 'nil'
  type_names['STRING'] = 'string'
  type_names['INT'] = 'number'
  type_names['SINGLE'] = 'number'
  type_names['BOOLEAN'] = 'boolean'
  
  param_len = len(param_list)
  
  for dat in tree['doxygen']['compounddef']['sectiondef']:
    for dict in dat['memberdef']:
      if not isinstance(dict, basestring) and isinstance(dict['name'], basestring) and dict['name'] == member_to_find:
        output = {}
        
        """
        # dbg
        if member_to_find == "GetMountedToAssemblyByAT":
          print "\nmember_to_find:"
          print member_to_find
          print param_list
          print dict['argsstring']
        """
        
        if dict["@kind"] == 'function': # functions
          args = dict['argsstring'].replace('\"', '')
          args = args.replace('(', '')
          args = args.replace(')', '')
          # compare dict_args to param_list to make sure we get the right function
          if not same_argsstring(args, param_list, param_len):
            continue
          
          output['type'] = 'function'
          
          if isinstance(dict['type'], basestring):  # is it a string?
            vtype = ((dict['type'].replace('const', '')).replace('&', '')).strip(' ')
            if vtype in type_names:
              vtype = type_names[vtype]
            output['returns'] = vtype
            output['valuetype'] = vtype
            output['args'] = args
          elif isinstance(dict['type'], types.NoneType):
            output['returns'] = 'nil'
            output['valuetype'] = 'nil'
            output['args'] = args
          else: # returns a pointer etc.
            vtype = dict['type']['ref']['#text']
            vtype = ((vtype.replace('const', '')).replace('&', '')).strip(' ')
            if vtype[0] == 'P':
              vtype = vtype[1:] #TODO: look up the typedef in the xml-tree instead
            if vtype in type_names:
              vtype = type_names[vtype]
            output['returns'] = vtype
            output['valuetype'] = vtype
            output['args'] = args
        else: # variables
          output['type'] = 'value'
          output['args'] = ''
          if isinstance(dict['type'], basestring):
            vtype = ((dict['type'].replace('const', '')).replace('&', '')).strip(' ')
            if vtype in type_names:
              vtype = type_names[vtype]
            output['returns'] = vtype
            output['valuetype'] = vtype
          else:
            vtype = dict['type']['ref']['#text']
            vtype = ((vtype.replace('const', '')).replace('&', '')).strip(' ')
            if vtype[0] == 'P':
              vtype = vtype[1:] #TODO: look up the typedef in the xml-tree instead            
            if vtype in type_names:
              vtype = type_names[vtype]
            output['returns'] = vtype
            output['valuetype'] = vtype
        
        # TODO: dict['detaileddescription'] & dict['inbodydescription']
        descr = dict['briefdescription']
        if descr:
          # if there is a type name in the comment descriptions will be wrong
          # because xmltodict strips out that information (a reference to another xml-file)
          if isinstance(descr['para'], basestring):
            output['description'] = descr['para']
          else:
            # descriptions can be stored in two different places
            try:
              output['description'] = descr['para']['#text']+' ('+descr['para']['ref']['#text']+')'
            except:
              output['description'] = descr['para']['#text']
        else:
          output['description'] = ''
        return output
  return False


def find_class_tree(index, class_to_find):
  class_to_find = 'C2D::' + class_to_find
  for d in index['doxygenindex']['compound']:
    if d['@kind'] == 'class':
      class_name = d['name']
      if class_name == class_to_find:
        with open('xml/'+d['@refid']+'.xml') as fd:
          return xmltodict.parse(fd.read())
  return False

  
def get_c2d_type_name(type):
  if type == 'string':
    return 'STRING'
  if type == 'number':
    return 'SINGLE'
  if type == 'boolean':
    return 'BOOLEAN'
  return type
  
  
# find any parameters to this function call for distinguishing
# between multiple functions with the same name
def find_func_parameters(lua_man_def):
  # split the string in to key words
  replace_list = [":", "*", "(", ")", "&", "\"", ","]
  function_line = lua_man_def.replace('const', '')
  for char in replace_list:
    function_line = function_line.replace(char, " ")
  function_line_list = function_line.split()[:-2]
  
  # extract the parameter types
  param_list = []
  look_for_parameters = False
  for str in function_line_list:
    if str == class_name:
      if look_for_parameters:
        break
      look_for_parameters = True
    elif look_for_parameters:
      param_list.append(unicode(str))
  return param_list
  
  
def get_zbs_argument_order(args_info):
  if args_info == "" or args_info == " " or args_info == "void":
    return ""
  
  type_names = {}
  type_names['STRING'] = 'string'
  type_names['INT'] = 'number'
  type_names['SINGLE'] = 'number'
  type_names['BYTE'] = 'number'
  type_names['BOOLEAN'] = 'boolean'
  
  out_str = ""
  args_list = args_info.split()
  for i in xrange(0, len(args_list), 2):
    if len(out_str) > 1:
      out_str += ', '
    out_str += args_list[i+1].replace(',', '') + ': '
    
    arg = args_list[i]
    if arg in type_names:
      out_str += type_names[arg]
    else:
      out_str += arg
  
  return out_str

  
if __name__ == '__main__':
  with open('xml/index.xml') as fd:
    index_tree = xmltodict.parse(fd.read())

  close_brace = False
  output_path = '../ZeroBraneStudio/api/lua/crush2d.lua'
  print "Exporting tool-tips to", output_path
  output_file = open(output_path, 'w')
  output_file.write('return {\n')
  html_docs_name = "LuaManDocs.html"
  html_file = open(html_docs_name, 'w')
  print "Exporting Lua API docs to", html_docs_name
  lua_man_files = ['LuaMan.cpp', 'LuaMan2.cpp', 'LuaMan3.cpp', 'LuaMan4.cpp', 'LuaMan5.cpp', 'LuaMan6.cpp']
  
  class_tree = False
  class_tree_name = ""
  
  html_file.write("<head>")
  html_file.write("<link rel=\"icon\" type=\"image/png\" href=\"favicon-32x32.png\" sizes=\"32x32\" />")
  html_file.write("<link rel=\"icon\" type=\"image/png\" href=\"favicon-16x16.png\" sizes=\"16x16\" />")
  html_file.write("</head>\n")
  html_file.write("<style>")
  html_file.write("body {")
  html_file.write("    background-color: #242526;")
  html_file.write("}")
  html_file.write("h1 {")
  html_file.write("    color: #D0D2E4;")
  html_file.write("}")
  html_file.write("h2 {")
  html_file.write("    color: #D0D2E4;")
  html_file.write("}")
  html_file.write("h3 {")
  html_file.write("    color: #A0BFE4;")
  html_file.write("}")
  html_file.write("p {")
  html_file.write("    color: #E0E2E4;")
  html_file.write("}")
  html_file.write("a:link {")
  html_file.write("    color: #87ACD1; text-decoration: none;")
  html_file.write("}")
  html_file.write("a:visited {")
  html_file.write("    color: #87ACD1; text-decoration: none;")
  html_file.write("}")
  html_file.write("a:hover {")
  html_file.write("    color: #97BCE1; text-decoration: underline;")
  html_file.write("}")
  html_file.write(".columns {")
  html_file.write("    -webkit-column-count: 2;")
  html_file.write("    -moz-column-count: 2;")
  html_file.write("    column-count: 2;")
  html_file.write("}")
  html_file.write("</style>\n")
  html_file.write("<h2>Contents</h2><div class=\"columns\">\n")
  
  
  # for checking if a type should be ignored or not
  ignore_valuetype = {}
  ignore_valuetype['nil'] = True
  ignore_valuetype['number'] = True
  ignore_valuetype['boolean'] = True
  ignore_valuetype['BYTE'] = True
  
  
  # store all function names here, for syntax highlighting
  all_function_names = {}
  
  
  # parse the LuaMan files
  class_toc = []
  function_toc = []
  function_info = []
  class_tree = False
  class_tree_name = ""
  for fl in lua_man_files:
    try:
      lua_man = open('../Geom/'+fl)
    except:
      break
    if lua_man:
      for binding in lua_man:
        line = binding.split()
        if len(line) > 0:
          member_info = False
          member_name = ""
          class_name = ""
          
          # extract the LuaBind commands from LuaMan
          if line[0][0:16] == ".def_readwrite(\"" or line[0][0:6] == ".def(\"":
            tail = (line[-1].split('&')[-1][0:-1]).split('::')
            toc_class_name = tail[0]
            class_name = tail[-2]
            member_name = tail[-1]
            
            # parse the next class tree if the class name has changed
            if class_name != class_tree_name:
              if class_tree_name != "":
                output_file.write('\t\t},\n\t},\n')
              class_tree_name = class_name
              class_tree = find_class_tree(index_tree, class_name)
              str = '\t'+class_name+'={\n\t\ttype=\"class\",\n\t\tchilds={\n'
              output_file.write(str)
              
              # build the class short-cut list
              html_str = "<a href=\"#"+class_name+"\"><span class=\"toctext\">"+toc_class_name+"</span></a><br>\n"
              class_toc.append({'name':toc_class_name, 'str':html_str})
              
              # build the function short-cut list
              if class_tree_name != "":
                function_toc.append("</div>\n")
                
              function_toc.append("<br>\n<h2 id=\""+class_name+"\">"+toc_class_name+"</h2><div class=\"columns\">\n")
              class_tree_name = class_name
              class_tree = find_class_tree(index_tree, class_name)

            if class_tree:
              lua_name = (line[0].split('\"'))[1]
              function_toc.append("<a href=\"#"+class_name+lua_name+"\">"+lua_name+"</a><br>\n")
              param_list = find_func_parameters(binding)
              member_info = find_in_tree(class_tree, class_name, member_name, param_list)
              
              if member_info:
                args_info = member_info['args']
                returns_info = member_info['returns']
                vtype = member_info['valuetype']
                
                if not lua_name in all_function_names:
                  all_function_names[lua_name] = True
                
                str = ''
                if member_info['type'] == "value":
                  str = '\t\t\t'+lua_name+'={type=\"value\", description=\"'+member_info['description'].replace( '"', '\\\"' )+'\"'
                  str += ', valuetype=\"'+vtype+'\"},\n'
                  
                  function_info.append("\n<H3><span id=\""+class_name+lua_name+"\">"+toc_class_name+"."+lua_name+"</span></H3>")
                  function_info.append("<p><b>Type: </b>"+get_c2d_type_name(vtype)+"</p>")
                  if len(member_info['description']) > 1:
                    function_info.append("<p>"+member_info['description']+"</p>")
                  function_info.append("<br>\n")
                else:
                  tmp_args_info = args_info.strip("()")
                  tmp_args_info = tmp_args_info.lstrip()
                  tmp_args_info = tmp_args_info.rstrip()
                  tmp_args_info = tmp_args_info.replace("&", "")
                  tmp_args_info = tmp_args_info.replace("const", "")
                  
                  str = '\t\t\t'+lua_name+'={type=\"method\", description=\"'+member_info['description'].replace( '"', '\\\"' )+'\"'
                  str += ', args=\"('+get_zbs_argument_order(tmp_args_info)+')\"'
                  
                  if returns_info == 'nil':
                    str += ', returns=\"()\"'
                  else:
                    str += ', returns=\"('+returns_info+')\"'
                  
                  if not (returns_info in ignore_valuetype):
                    str += ', valuetype=\"'+vtype+'\"'
                  str += '},\n'
                  
                  function_info.append("<H3><span id=\""+class_name+lua_name+"\">"+toc_class_name+":"+lua_name+"</span></H3>")
                  if len(member_info['description']) > 1:
                    function_info.append("<p>"+member_info['description']+"</p>")
                  
                  if len(tmp_args_info) > 2:
                    function_info.append("<p><b>Arguments: </b>"+tmp_args_info+"</p>")
                  if returns_info != "nil":
                    function_info.append("<p><b>Returns: </b>"+get_c2d_type_name(returns_info)+"</p>")
                  function_info.append("<br>\n")
                  
                output_file.write(str)

  output_file.write('\t\t}\n\t}\n}')
  
  
  # ../Lua/ documentation
  toc_class_name = "Lua functions"
  class_name = "lua"
  html_str = "<a href=\"#"+class_name+"\"><span class=\"toctext\">"+toc_class_name+"</span></a><br>\n"
  class_toc.append({'name':toc_class_name, 'str':html_str})
  function_toc.append("</div><br>\n<h2 id=\"lua\">Lua functions</h2><div class=\"columns\">\n")
  lua_files = open('../Lua/c2d.lua', 'r')
  for file_line in lua_files:
    file_line = file_line.split('"')
    if file_line[0] == 'dofile(':
      input_file = open('../Lua/'+file_line[1], 'r')
      comment_line = ""
      for data_str in input_file:
        data_line = data_str.split()
        if len(data_line) > 1 and data_line[0] == 'function':
          # ignore all functions that belongs to the table 'members'
          if data_line[1].split(':')[0] == 'members':
            continue
          
          # ignore all functions that belong to "self"
          if data_line[1].split('.')[0] == 'self' or data_line[1].split(':')[0] == 'self':
            continue
          
          params = ""
          for p in data_line[1:]:
            params += p+" "
          func_name = data_line[1].split('(')[0]
          function_toc.append("<a href=\"#lua_"+func_name+"\">"+func_name+"</a><br>\n")
          function_info.append("<H3><span id=\"lua_"+func_name+"\">"+params+"</span></H3>")
          if len(comment_line) > 2 and comment_line[0] == '-':
            function_info.append("<p>"+comment_line[:-1].replace('--', '')+"</p>")
          function_info.append("<br>\n")
        comment_line = data_str
      input_file.close()
  lua_files.close()
  
  # sort by name
  class_toc = sorted(class_toc, key=lambda k: k['name'])
  for dict in class_toc:
    html_file.write(dict['str'])
  html_file.write("</div>\n\n")
  
  for str in function_toc:
    html_file.write(str)
  html_file.write("</div><br><br>\n\n")
  
  for str in function_info:
    html_file.write(str)
  html_file.write("</div><br><br>\n\n")
  
  output_file.close()
  html_file.close()
  
  # syntax highlighting
  output_path = '../ZeroBraneStudio/spec/crush2d.lua'
  print "Exporting syntax highlighting to", output_path
  output_file = open(output_path, 'w')
  output_file.write('return [[\n')
  
  for val in all_function_names:
    output_file.write(val+" ")
  
  output_file.write('\n]]')
  output_file.close()
