--[[// glewgl gl | OpenGL Wrapper with GLEW
typedef unsigned int GLenum;
typedef unsigned int GLbitfield;
typedef unsigned int GLuint;
typedef int GLint;
typedef int GLsizei;
typedef unsigned char GLboolean;
typedef signed char GLbyte;
typedef short GLshort;
typedef unsigned char GLubyte;
typedef unsigned short GLushort;
typedef unsigned long GLulong;
typedef float GLfloat;
typedef float GLclampf;
typedef double GLdouble;
typedef double GLclampd;
typedef void GLvoid;
typedef __int64 GLint64EXT;
typedef unsigned __int64 GLuint64EXT;
typedef GLint64EXT  GLint64;
typedef GLuint64EXT GLuint64;
typedef struct __GLsync *GLsync;
typedef char GLchar;
typedef ptrdiff_t GLintptr;
typedef ptrdiff_t GLsizeiptr;
typedef int GLfixed;
typedef struct _cl_context *cl_context;
typedef struct _cl_event *cl_event;
typedef char GLcharARB;
typedef unsigned int GLhandleARB;
typedef ptrdiff_t GLintptrARB;
typedef ptrdiff_t GLsizeiptrARB;
typedef unsigned short GLhalf;
typedef GLintptr GLvdpauSurfaceNV;
typedef void ( *GLDEBUGPROCAMD)(GLuint id, GLenum category, GLenum severity, GLsizei length, const GLchar* message, GLvoid* userParam);
typedef void ( *GLDEBUGPROC)(GLenum source, GLenum type, GLuint id, GLenum severity, GLsizei length, const GLchar* message, GLvoid* userParam);
typedef void ( *GLDEBUGPROCARB)(GLenum source, GLenum type, GLuint id, GLenum severity, GLsizei length, const GLchar* message, GLvoid* userParam);

enum {
GL_ZERO = 0,
GL_FALSE = 0,
GL_LOGIC_OP = 0x0BF1,
GL_NONE = 0,
GL_TEXTURE_COMPONENTS = 0x1003,
GL_NO_ERROR = 0,
GL_POINTS = 0x0000,
GL_CURRENT_BIT = 0x00000001,
GL_TRUE = 1,
GL_ONE = 1,
GL_CLIENT_PIXEL_STORE_BIT = 0x00000001,
GL_LINES = 0x0001,
GL_LINE_LOOP = 0x0002,
GL_POINT_BIT = 0x00000002,
GL_CLIENT_VERTEX_ARRAY_BIT = 0x00000002,
GL_LINE_STRIP = 0x0003,
GL_LINE_BIT = 0x00000004,
GL_TRIANGLES = 0x0004,
GL_TRIANGLE_STRIP = 0x0005,
GL_TRIANGLE_FAN = 0x0006,
GL_QUADS = 0x0007,
GL_QUAD_STRIP = 0x0008,
GL_POLYGON_BIT = 0x00000008,
GL_POLYGON = 0x0009,
GL_POLYGON_STIPPLE_BIT = 0x00000010,
GL_PIXEL_MODE_BIT = 0x00000020,
GL_LIGHTING_BIT = 0x00000040,
GL_FOG_BIT = 0x00000080,
GL_DEPTH_BUFFER_BIT = 0x00000100,
GL_ACCUM = 0x0100,
GL_LOAD = 0x0101,
GL_RETURN = 0x0102,
GL_MULT = 0x0103,
GL_ADD = 0x0104,
GL_NEVER = 0x0200,
GL_ACCUM_BUFFER_BIT = 0x00000200,
GL_LESS = 0x0201,
GL_EQUAL = 0x0202,
GL_LEQUAL = 0x0203,
GL_GREATER = 0x0204,
GL_NOTEQUAL = 0x0205,
GL_GEQUAL = 0x0206,
GL_ALWAYS = 0x0207,
GL_SRC_COLOR = 0x0300,
GL_ONE_MINUS_SRC_COLOR = 0x0301,
GL_SRC_ALPHA = 0x0302,
GL_ONE_MINUS_SRC_ALPHA = 0x0303,
GL_DST_ALPHA = 0x0304,
GL_ONE_MINUS_DST_ALPHA = 0x0305,
GL_DST_COLOR = 0x0306,
GL_ONE_MINUS_DST_COLOR = 0x0307,
GL_SRC_ALPHA_SATURATE = 0x0308,
GL_STENCIL_BUFFER_BIT = 0x00000400,
GL_FRONT_LEFT = 0x0400,
GL_FRONT_RIGHT = 0x0401,
GL_BACK_LEFT = 0x0402,
GL_BACK_RIGHT = 0x0403,
GL_FRONT = 0x0404,
GL_BACK = 0x0405,
GL_LEFT = 0x0406,
GL_RIGHT = 0x0407,
GL_FRONT_AND_BACK = 0x0408,
GL_AUX0 = 0x0409,
GL_AUX1 = 0x040A,
GL_AUX2 = 0x040B,
GL_AUX3 = 0x040C,
GL_INVALID_ENUM = 0x0500,
GL_INVALID_VALUE = 0x0501,
GL_INVALID_OPERATION = 0x0502,
GL_STACK_OVERFLOW = 0x0503,
GL_STACK_UNDERFLOW = 0x0504,
GL_OUT_OF_MEMORY = 0x0505,
GL_2D = 0x0600,
GL_3D = 0x0601,
GL_3D_COLOR = 0x0602,
GL_3D_COLOR_TEXTURE = 0x0603,
GL_4D_COLOR_TEXTURE = 0x0604,
GL_PASS_THROUGH_TOKEN = 0x0700,
GL_POINT_TOKEN = 0x0701,
GL_LINE_TOKEN = 0x0702,
GL_POLYGON_TOKEN = 0x0703,
GL_BITMAP_TOKEN = 0x0704,
GL_DRAW_PIXEL_TOKEN = 0x0705,
GL_COPY_PIXEL_TOKEN = 0x0706,
GL_LINE_RESET_TOKEN = 0x0707,
GL_EXP = 0x0800,
GL_VIEWPORT_BIT = 0x00000800,
GL_EXP2 = 0x0801,
GL_CW = 0x0900,
GL_CCW = 0x0901,
GL_COEFF = 0x0A00,
GL_ORDER = 0x0A01,
GL_DOMAIN = 0x0A02,
GL_CURRENT_COLOR = 0x0B00,
GL_CURRENT_INDEX = 0x0B01,
GL_CURRENT_NORMAL = 0x0B02,
GL_CURRENT_TEXTURE_COORDS = 0x0B03,
GL_CURRENT_RASTER_COLOR = 0x0B04,
GL_CURRENT_RASTER_INDEX = 0x0B05,
GL_CURRENT_RASTER_TEXTURE_COORDS = 0x0B06,
GL_CURRENT_RASTER_POSITION = 0x0B07,
GL_CURRENT_RASTER_POSITION_VALID = 0x0B08,
GL_CURRENT_RASTER_DISTANCE = 0x0B09,
GL_POINT_SMOOTH = 0x0B10,
GL_POINT_SIZE = 0x0B11,
GL_POINT_SIZE_RANGE = 0x0B12,
GL_POINT_SIZE_GRANULARITY = 0x0B13,
GL_LINE_SMOOTH = 0x0B20,
GL_LINE_WIDTH = 0x0B21,
GL_LINE_WIDTH_RANGE = 0x0B22,
GL_LINE_WIDTH_GRANULARITY = 0x0B23,
GL_LINE_STIPPLE = 0x0B24,
GL_LINE_STIPPLE_PATTERN = 0x0B25,
GL_LINE_STIPPLE_REPEAT = 0x0B26,
GL_LIST_MODE = 0x0B30,
GL_MAX_LIST_NESTING = 0x0B31,
GL_LIST_BASE = 0x0B32,
GL_LIST_INDEX = 0x0B33,
GL_POLYGON_MODE = 0x0B40,
GL_POLYGON_SMOOTH = 0x0B41,
GL_POLYGON_STIPPLE = 0x0B42,
GL_EDGE_FLAG = 0x0B43,
GL_CULL_FACE = 0x0B44,
GL_CULL_FACE_MODE = 0x0B45,
GL_FRONT_FACE = 0x0B46,
GL_LIGHTING = 0x0B50,
GL_LIGHT_MODEL_LOCAL_VIEWER = 0x0B51,
GL_LIGHT_MODEL_TWO_SIDE = 0x0B52,
GL_LIGHT_MODEL_AMBIENT = 0x0B53,
GL_SHADE_MODEL = 0x0B54,
GL_COLOR_MATERIAL_FACE = 0x0B55,
GL_COLOR_MATERIAL_PARAMETER = 0x0B56,
GL_COLOR_MATERIAL = 0x0B57,
GL_FOG = 0x0B60,
GL_FOG_INDEX = 0x0B61,
GL_FOG_DENSITY = 0x0B62,
GL_FOG_START = 0x0B63,
GL_FOG_END = 0x0B64,
GL_FOG_MODE = 0x0B65,
GL_FOG_COLOR = 0x0B66,
GL_DEPTH_RANGE = 0x0B70,
GL_DEPTH_TEST = 0x0B71,
GL_DEPTH_WRITEMASK = 0x0B72,
GL_DEPTH_CLEAR_VALUE = 0x0B73,
GL_DEPTH_FUNC = 0x0B74,
GL_ACCUM_CLEAR_VALUE = 0x0B80,
GL_STENCIL_TEST = 0x0B90,
GL_STENCIL_CLEAR_VALUE = 0x0B91,
GL_STENCIL_FUNC = 0x0B92,
GL_STENCIL_VALUE_MASK = 0x0B93,
GL_STENCIL_FAIL = 0x0B94,
GL_STENCIL_PASS_DEPTH_FAIL = 0x0B95,
GL_STENCIL_PASS_DEPTH_PASS = 0x0B96,
GL_STENCIL_REF = 0x0B97,
GL_STENCIL_WRITEMASK = 0x0B98,
GL_MATRIX_MODE = 0x0BA0,
GL_NORMALIZE = 0x0BA1,
GL_VIEWPORT = 0x0BA2,
GL_MODELVIEW_STACK_DEPTH = 0x0BA3,
GL_PROJECTION_STACK_DEPTH = 0x0BA4,
GL_TEXTURE_STACK_DEPTH = 0x0BA5,
GL_MODELVIEW_MATRIX = 0x0BA6,
GL_PROJECTION_MATRIX = 0x0BA7,
GL_TEXTURE_MATRIX = 0x0BA8,
GL_ATTRIB_STACK_DEPTH = 0x0BB0,
GL_CLIENT_ATTRIB_STACK_DEPTH = 0x0BB1,
GL_ALPHA_TEST = 0x0BC0,
GL_ALPHA_TEST_FUNC = 0x0BC1,
GL_ALPHA_TEST_REF = 0x0BC2,
GL_DITHER = 0x0BD0,
GL_BLEND_DST = 0x0BE0,
GL_BLEND_SRC = 0x0BE1,
GL_BLEND = 0x0BE2,
GL_LOGIC_OP_MODE = 0x0BF0,
GL_INDEX_LOGIC_OP = 0x0BF1,
GL_COLOR_LOGIC_OP = 0x0BF2,
GL_AUX_BUFFERS = 0x0C00,
GL_DRAW_BUFFER = 0x0C01,
GL_READ_BUFFER = 0x0C02,
GL_SCISSOR_BOX = 0x0C10,
GL_SCISSOR_TEST = 0x0C11,
GL_INDEX_CLEAR_VALUE = 0x0C20,
GL_INDEX_WRITEMASK = 0x0C21,
GL_COLOR_CLEAR_VALUE = 0x0C22,
GL_COLOR_WRITEMASK = 0x0C23,
GL_INDEX_MODE = 0x0C30,
GL_RGBA_MODE = 0x0C31,
GL_DOUBLEBUFFER = 0x0C32,
GL_STEREO = 0x0C33,
GL_RENDER_MODE = 0x0C40,
GL_PERSPECTIVE_CORRECTION_HINT = 0x0C50,
GL_POINT_SMOOTH_HINT = 0x0C51,
GL_LINE_SMOOTH_HINT = 0x0C52,
GL_POLYGON_SMOOTH_HINT = 0x0C53,
GL_FOG_HINT = 0x0C54,
GL_TEXTURE_GEN_S = 0x0C60,
GL_TEXTURE_GEN_T = 0x0C61,
GL_TEXTURE_GEN_R = 0x0C62,
GL_TEXTURE_GEN_Q = 0x0C63,
GL_PIXEL_MAP_I_TO_I = 0x0C70,
GL_PIXEL_MAP_S_TO_S = 0x0C71,
GL_PIXEL_MAP_I_TO_R = 0x0C72,
GL_PIXEL_MAP_I_TO_G = 0x0C73,
GL_PIXEL_MAP_I_TO_B = 0x0C74,
GL_PIXEL_MAP_I_TO_A = 0x0C75,
GL_PIXEL_MAP_R_TO_R = 0x0C76,
GL_PIXEL_MAP_G_TO_G = 0x0C77,
GL_PIXEL_MAP_B_TO_B = 0x0C78,
GL_PIXEL_MAP_A_TO_A = 0x0C79,
GL_PIXEL_MAP_I_TO_I_SIZE = 0x0CB0,
GL_PIXEL_MAP_S_TO_S_SIZE = 0x0CB1,
GL_PIXEL_MAP_I_TO_R_SIZE = 0x0CB2,
GL_PIXEL_MAP_I_TO_G_SIZE = 0x0CB3,
GL_PIXEL_MAP_I_TO_B_SIZE = 0x0CB4,
GL_PIXEL_MAP_I_TO_A_SIZE = 0x0CB5,
GL_PIXEL_MAP_R_TO_R_SIZE = 0x0CB6,
GL_PIXEL_MAP_G_TO_G_SIZE = 0x0CB7,
GL_PIXEL_MAP_B_TO_B_SIZE = 0x0CB8,
GL_PIXEL_MAP_A_TO_A_SIZE = 0x0CB9,
GL_UNPACK_SWAP_BYTES = 0x0CF0,
GL_UNPACK_LSB_FIRST = 0x0CF1,
GL_UNPACK_ROW_LENGTH = 0x0CF2,
GL_UNPACK_SKIP_ROWS = 0x0CF3,
GL_UNPACK_SKIP_PIXELS = 0x0CF4,
GL_UNPACK_ALIGNMENT = 0x0CF5,
GL_PACK_SWAP_BYTES = 0x0D00,
GL_PACK_LSB_FIRST = 0x0D01,
GL_PACK_ROW_LENGTH = 0x0D02,
GL_PACK_SKIP_ROWS = 0x0D03,
GL_PACK_SKIP_PIXELS = 0x0D04,
GL_PACK_ALIGNMENT = 0x0D05,
GL_MAP_COLOR = 0x0D10,
GL_MAP_STENCIL = 0x0D11,
GL_INDEX_SHIFT = 0x0D12,
GL_INDEX_OFFSET = 0x0D13,
GL_RED_SCALE = 0x0D14,
GL_RED_BIAS = 0x0D15,
GL_ZOOM_X = 0x0D16,
GL_ZOOM_Y = 0x0D17,
GL_GREEN_SCALE = 0x0D18,
GL_GREEN_BIAS = 0x0D19,
GL_BLUE_SCALE = 0x0D1A,
GL_BLUE_BIAS = 0x0D1B,
GL_ALPHA_SCALE = 0x0D1C,
GL_ALPHA_BIAS = 0x0D1D,
GL_DEPTH_SCALE = 0x0D1E,
GL_DEPTH_BIAS = 0x0D1F,
GL_MAX_EVAL_ORDER = 0x0D30,
GL_MAX_LIGHTS = 0x0D31,
GL_MAX_CLIP_PLANES = 0x0D32,
GL_MAX_TEXTURE_SIZE = 0x0D33,
GL_MAX_PIXEL_MAP_TABLE = 0x0D34,
GL_MAX_ATTRIB_STACK_DEPTH = 0x0D35,
GL_MAX_MODELVIEW_STACK_DEPTH = 0x0D36,
GL_MAX_NAME_STACK_DEPTH = 0x0D37,
GL_MAX_PROJECTION_STACK_DEPTH = 0x0D38,
GL_MAX_TEXTURE_STACK_DEPTH = 0x0D39,
GL_MAX_VIEWPORT_DIMS = 0x0D3A,
GL_MAX_CLIENT_ATTRIB_STACK_DEPTH = 0x0D3B,
GL_SUBPIXEL_BITS = 0x0D50,
GL_INDEX_BITS = 0x0D51,
GL_RED_BITS = 0x0D52,
GL_GREEN_BITS = 0x0D53,
GL_BLUE_BITS = 0x0D54,
GL_ALPHA_BITS = 0x0D55,
GL_DEPTH_BITS = 0x0D56,
GL_STENCIL_BITS = 0x0D57,
GL_ACCUM_RED_BITS = 0x0D58,
GL_ACCUM_GREEN_BITS = 0x0D59,
GL_ACCUM_BLUE_BITS = 0x0D5A,
GL_ACCUM_ALPHA_BITS = 0x0D5B,
GL_NAME_STACK_DEPTH = 0x0D70,
GL_AUTO_NORMAL = 0x0D80,
GL_MAP1_COLOR_4 = 0x0D90,
GL_MAP1_INDEX = 0x0D91,
GL_MAP1_NORMAL = 0x0D92,
GL_MAP1_TEXTURE_COORD_1 = 0x0D93,
GL_MAP1_TEXTURE_COORD_2 = 0x0D94,
GL_MAP1_TEXTURE_COORD_3 = 0x0D95,
GL_MAP1_TEXTURE_COORD_4 = 0x0D96,
GL_MAP1_VERTEX_3 = 0x0D97,
GL_MAP1_VERTEX_4 = 0x0D98,
GL_MAP2_COLOR_4 = 0x0DB0,
GL_MAP2_INDEX = 0x0DB1,
GL_MAP2_NORMAL = 0x0DB2,
GL_MAP2_TEXTURE_COORD_1 = 0x0DB3,
GL_MAP2_TEXTURE_COORD_2 = 0x0DB4,
GL_MAP2_TEXTURE_COORD_3 = 0x0DB5,
GL_MAP2_TEXTURE_COORD_4 = 0x0DB6,
GL_MAP2_VERTEX_3 = 0x0DB7,
GL_MAP2_VERTEX_4 = 0x0DB8,
GL_MAP1_GRID_DOMAIN = 0x0DD0,
GL_MAP1_GRID_SEGMENTS = 0x0DD1,
GL_MAP2_GRID_DOMAIN = 0x0DD2,
GL_MAP2_GRID_SEGMENTS = 0x0DD3,
GL_TEXTURE_1D = 0x0DE0,
GL_TEXTURE_2D = 0x0DE1,
GL_FEEDBACK_BUFFER_POINTER = 0x0DF0,
GL_FEEDBACK_BUFFER_SIZE = 0x0DF1,
GL_FEEDBACK_BUFFER_TYPE = 0x0DF2,
GL_SELECTION_BUFFER_POINTER = 0x0DF3,
GL_SELECTION_BUFFER_SIZE = 0x0DF4,
GL_TEXTURE_WIDTH = 0x1000,
GL_TRANSFORM_BIT = 0x00001000,
GL_TEXTURE_HEIGHT = 0x1001,
GL_TEXTURE_INTERNAL_FORMAT = 0x1003,
GL_TEXTURE_BORDER_COLOR = 0x1004,
GL_TEXTURE_BORDER = 0x1005,
GL_DONT_CARE = 0x1100,
GL_FASTEST = 0x1101,
GL_NICEST = 0x1102,
GL_AMBIENT = 0x1200,
GL_DIFFUSE = 0x1201,
GL_SPECULAR = 0x1202,
GL_POSITION = 0x1203,
GL_SPOT_DIRECTION = 0x1204,
GL_SPOT_EXPONENT = 0x1205,
GL_SPOT_CUTOFF = 0x1206,
GL_CONSTANT_ATTENUATION = 0x1207,
GL_LINEAR_ATTENUATION = 0x1208,
GL_QUADRATIC_ATTENUATION = 0x1209,
GL_COMPILE = 0x1300,
GL_COMPILE_AND_EXECUTE = 0x1301,
GL_BYTE = 0x1400,
GL_UNSIGNED_BYTE = 0x1401,
GL_SHORT = 0x1402,
GL_UNSIGNED_SHORT = 0x1403,
GL_INT = 0x1404,
GL_UNSIGNED_INT = 0x1405,
GL_FLOAT = 0x1406,
GL_2_BYTES = 0x1407,
GL_3_BYTES = 0x1408,
GL_4_BYTES = 0x1409,
GL_DOUBLE = 0x140A,
GL_CLEAR = 0x1500,
GL_AND = 0x1501,
GL_AND_REVERSE = 0x1502,
GL_COPY = 0x1503,
GL_AND_INVERTED = 0x1504,
GL_NOOP = 0x1505,
GL_XOR = 0x1506,
GL_OR = 0x1507,
GL_NOR = 0x1508,
GL_EQUIV = 0x1509,
GL_INVERT = 0x150A,
GL_OR_REVERSE = 0x150B,
GL_COPY_INVERTED = 0x150C,
GL_OR_INVERTED = 0x150D,
GL_NAND = 0x150E,
GL_SET = 0x150F,
GL_EMISSION = 0x1600,
GL_SHININESS = 0x1601,
GL_AMBIENT_AND_DIFFUSE = 0x1602,
GL_COLOR_INDEXES = 0x1603,
GL_MODELVIEW = 0x1700,
GL_PROJECTION = 0x1701,
GL_TEXTURE = 0x1702,
GL_COLOR = 0x1800,
GL_DEPTH = 0x1801,
GL_STENCIL = 0x1802,
GL_COLOR_INDEX = 0x1900,
GL_STENCIL_INDEX = 0x1901,
GL_DEPTH_COMPONENT = 0x1902,
GL_RED = 0x1903,
GL_GREEN = 0x1904,
GL_BLUE = 0x1905,
GL_ALPHA = 0x1906,
GL_RGB = 0x1907,
GL_RGBA = 0x1908,
GL_LUMINANCE = 0x1909,
GL_LUMINANCE_ALPHA = 0x190A,
GL_BITMAP = 0x1A00,
GL_POINT = 0x1B00,
GL_LINE = 0x1B01,
GL_FILL = 0x1B02,
GL_RENDER = 0x1C00,
GL_FEEDBACK = 0x1C01,
GL_SELECT = 0x1C02,
GL_FLAT = 0x1D00,
GL_SMOOTH = 0x1D01,
GL_KEEP = 0x1E00,
GL_REPLACE = 0x1E01,
GL_INCR = 0x1E02,
GL_DECR = 0x1E03,
GL_VENDOR = 0x1F00,
GL_RENDERER = 0x1F01,
GL_VERSION = 0x1F02,
GL_EXTENSIONS = 0x1F03,
GL_S = 0x2000,
GL_ENABLE_BIT = 0x00002000,
GL_T = 0x2001,
GL_R = 0x2002,
GL_Q = 0x2003,
GL_MODULATE = 0x2100,
GL_DECAL = 0x2101,
GL_TEXTURE_ENV_MODE = 0x2200,
GL_TEXTURE_ENV_COLOR = 0x2201,
GL_TEXTURE_ENV = 0x2300,
GL_EYE_LINEAR = 0x2400,
GL_OBJECT_LINEAR = 0x2401,
GL_SPHERE_MAP = 0x2402,
GL_TEXTURE_GEN_MODE = 0x2500,
GL_OBJECT_PLANE = 0x2501,
GL_EYE_PLANE = 0x2502,
GL_NEAREST = 0x2600,
GL_LINEAR = 0x2601,
GL_NEAREST_MIPMAP_NEAREST = 0x2700,
GL_LINEAR_MIPMAP_NEAREST = 0x2701,
GL_NEAREST_MIPMAP_LINEAR = 0x2702,
GL_LINEAR_MIPMAP_LINEAR = 0x2703,
GL_TEXTURE_MAG_FILTER = 0x2800,
GL_TEXTURE_MIN_FILTER = 0x2801,
GL_TEXTURE_WRAP_S = 0x2802,
GL_TEXTURE_WRAP_T = 0x2803,
GL_CLAMP = 0x2900,
GL_REPEAT = 0x2901,
GL_POLYGON_OFFSET_UNITS = 0x2A00,
GL_POLYGON_OFFSET_POINT = 0x2A01,
GL_POLYGON_OFFSET_LINE = 0x2A02,
GL_R3_G3_B2 = 0x2A10,
GL_V2F = 0x2A20,
GL_V3F = 0x2A21,
GL_C4UB_V2F = 0x2A22,
GL_C4UB_V3F = 0x2A23,
GL_C3F_V3F = 0x2A24,
GL_N3F_V3F = 0x2A25,
GL_C4F_N3F_V3F = 0x2A26,
GL_T2F_V3F = 0x2A27,
GL_T4F_V4F = 0x2A28,
GL_T2F_C4UB_V3F = 0x2A29,
GL_T2F_C3F_V3F = 0x2A2A,
GL_T2F_N3F_V3F = 0x2A2B,
GL_T2F_C4F_N3F_V3F = 0x2A2C,
GL_T4F_C4F_N3F_V4F = 0x2A2D,
GL_CLIP_PLANE0 = 0x3000,
GL_CLIP_PLANE1 = 0x3001,
GL_CLIP_PLANE2 = 0x3002,
GL_CLIP_PLANE3 = 0x3003,
GL_CLIP_PLANE4 = 0x3004,
GL_CLIP_PLANE5 = 0x3005,
GL_LIGHT0 = 0x4000,
GL_COLOR_BUFFER_BIT = 0x00004000,
GL_LIGHT1 = 0x4001,
GL_LIGHT2 = 0x4002,
GL_LIGHT3 = 0x4003,
GL_LIGHT4 = 0x4004,
GL_LIGHT5 = 0x4005,
GL_LIGHT6 = 0x4006,
GL_LIGHT7 = 0x4007,
GL_HINT_BIT = 0x00008000,
GL_POLYGON_OFFSET_FILL = 0x8037,
GL_POLYGON_OFFSET_FACTOR = 0x8038,
GL_ALPHA4 = 0x803B,
GL_ALPHA8 = 0x803C,
GL_ALPHA12 = 0x803D,
GL_ALPHA16 = 0x803E,
GL_LUMINANCE4 = 0x803F,
GL_LUMINANCE8 = 0x8040,
GL_LUMINANCE12 = 0x8041,
GL_LUMINANCE16 = 0x8042,
GL_LUMINANCE4_ALPHA4 = 0x8043,
GL_LUMINANCE6_ALPHA2 = 0x8044,
GL_LUMINANCE8_ALPHA8 = 0x8045,
GL_LUMINANCE12_ALPHA4 = 0x8046,
GL_LUMINANCE12_ALPHA12 = 0x8047,
GL_LUMINANCE16_ALPHA16 = 0x8048,
GL_INTENSITY = 0x8049,
GL_INTENSITY4 = 0x804A,
GL_INTENSITY8 = 0x804B,
GL_INTENSITY12 = 0x804C,
GL_INTENSITY16 = 0x804D,
GL_RGB4 = 0x804F,
GL_RGB5 = 0x8050,
GL_RGB8 = 0x8051,
GL_RGB10 = 0x8052,
GL_RGB12 = 0x8053,
GL_RGB16 = 0x8054,
GL_RGBA2 = 0x8055,
GL_RGBA4 = 0x8056,
GL_RGB5_A1 = 0x8057,
GL_RGBA8 = 0x8058,
GL_RGB10_A2 = 0x8059,
GL_RGBA12 = 0x805A,
GL_RGBA16 = 0x805B,
GL_TEXTURE_RED_SIZE = 0x805C,
GL_TEXTURE_GREEN_SIZE = 0x805D,
GL_TEXTURE_BLUE_SIZE = 0x805E,
GL_TEXTURE_ALPHA_SIZE = 0x805F,
GL_TEXTURE_LUMINANCE_SIZE = 0x8060,
GL_TEXTURE_INTENSITY_SIZE = 0x8061,
GL_PROXY_TEXTURE_1D = 0x8063,
GL_PROXY_TEXTURE_2D = 0x8064,
GL_TEXTURE_PRIORITY = 0x8066,
GL_TEXTURE_RESIDENT = 0x8067,
GL_TEXTURE_BINDING_1D = 0x8068,
GL_TEXTURE_BINDING_2D = 0x8069,
GL_VERTEX_ARRAY = 0x8074,
GL_NORMAL_ARRAY = 0x8075,
GL_COLOR_ARRAY = 0x8076,
GL_INDEX_ARRAY = 0x8077,
GL_TEXTURE_COORD_ARRAY = 0x8078,
GL_EDGE_FLAG_ARRAY = 0x8079,
GL_VERTEX_ARRAY_SIZE = 0x807A,
GL_VERTEX_ARRAY_TYPE = 0x807B,
GL_VERTEX_ARRAY_STRIDE = 0x807C,
GL_NORMAL_ARRAY_TYPE = 0x807E,
GL_NORMAL_ARRAY_STRIDE = 0x807F,
GL_COLOR_ARRAY_SIZE = 0x8081,
GL_COLOR_ARRAY_TYPE = 0x8082,
GL_COLOR_ARRAY_STRIDE = 0x8083,
GL_INDEX_ARRAY_TYPE = 0x8085,
GL_INDEX_ARRAY_STRIDE = 0x8086,
GL_TEXTURE_COORD_ARRAY_SIZE = 0x8088,
GL_TEXTURE_COORD_ARRAY_TYPE = 0x8089,
GL_TEXTURE_COORD_ARRAY_STRIDE = 0x808A,
GL_EDGE_FLAG_ARRAY_STRIDE = 0x808C,
GL_VERTEX_ARRAY_POINTER = 0x808E,
GL_NORMAL_ARRAY_POINTER = 0x808F,
GL_COLOR_ARRAY_POINTER = 0x8090,
GL_INDEX_ARRAY_POINTER = 0x8091,
GL_TEXTURE_COORD_ARRAY_POINTER = 0x8092,
GL_EDGE_FLAG_ARRAY_POINTER = 0x8093,
GL_COLOR_INDEX1_EXT = 0x80E2,
GL_COLOR_INDEX2_EXT = 0x80E3,
GL_COLOR_INDEX4_EXT = 0x80E4,
GL_COLOR_INDEX8_EXT = 0x80E5,
GL_COLOR_INDEX12_EXT = 0x80E6,
GL_COLOR_INDEX16_EXT = 0x80E7,
GL_EVAL_BIT = 0x00010000,
GL_LIST_BIT = 0x00020000,
GL_TEXTURE_BIT = 0x00040000,
GL_SCISSOR_BIT = 0x00080000,
GL_ALL_ATTRIB_BITS = 0x000fffff,
GL_CLIENT_ALL_ATTRIB_BITS = 0xffffffff,
GL_SMOOTH_POINT_SIZE_RANGE = 0x0B12,
GL_SMOOTH_POINT_SIZE_GRANULARITY = 0x0B13,
GL_SMOOTH_LINE_WIDTH_RANGE = 0x0B22,
GL_SMOOTH_LINE_WIDTH_GRANULARITY = 0x0B23,
GL_UNSIGNED_BYTE_3_3_2 = 0x8032,
GL_UNSIGNED_SHORT_4_4_4_4 = 0x8033,
GL_UNSIGNED_SHORT_5_5_5_1 = 0x8034,
GL_UNSIGNED_INT_8_8_8_8 = 0x8035,
GL_UNSIGNED_INT_10_10_10_2 = 0x8036,
GL_RESCALE_NORMAL = 0x803A,
GL_TEXTURE_BINDING_3D = 0x806A,
GL_PACK_SKIP_IMAGES = 0x806B,
GL_PACK_IMAGE_HEIGHT = 0x806C,
GL_UNPACK_SKIP_IMAGES = 0x806D,
GL_UNPACK_IMAGE_HEIGHT = 0x806E,
GL_TEXTURE_3D = 0x806F,
GL_PROXY_TEXTURE_3D = 0x8070,
GL_TEXTURE_DEPTH = 0x8071,
GL_TEXTURE_WRAP_R = 0x8072,
GL_MAX_3D_TEXTURE_SIZE = 0x8073,
GL_BGR = 0x80E0,
GL_BGRA = 0x80E1,
GL_MAX_ELEMENTS_VERTICES = 0x80E8,
GL_MAX_ELEMENTS_INDICES = 0x80E9,
GL_CLAMP_TO_EDGE = 0x812F,
GL_TEXTURE_MIN_LOD = 0x813A,
GL_TEXTURE_MAX_LOD = 0x813B,
GL_TEXTURE_BASE_LEVEL = 0x813C,
GL_TEXTURE_MAX_LEVEL = 0x813D,
GL_LIGHT_MODEL_COLOR_CONTROL = 0x81F8,
GL_SINGLE_COLOR = 0x81F9,
GL_SEPARATE_SPECULAR_COLOR = 0x81FA,
GL_UNSIGNED_BYTE_2_3_3_REV = 0x8362,
GL_UNSIGNED_SHORT_5_6_5 = 0x8363,
GL_UNSIGNED_SHORT_5_6_5_REV = 0x8364,
GL_UNSIGNED_SHORT_4_4_4_4_REV = 0x8365,
GL_UNSIGNED_SHORT_1_5_5_5_REV = 0x8366,
GL_UNSIGNED_INT_8_8_8_8_REV = 0x8367,
GL_UNSIGNED_INT_2_10_10_10_REV = 0x8368,
GL_ALIASED_POINT_SIZE_RANGE = 0x846D,
GL_ALIASED_LINE_WIDTH_RANGE = 0x846E,
GL_MULTISAMPLE = 0x809D,
GL_SAMPLE_ALPHA_TO_COVERAGE = 0x809E,
GL_SAMPLE_ALPHA_TO_ONE = 0x809F,
GL_SAMPLE_COVERAGE = 0x80A0,
GL_SAMPLE_BUFFERS = 0x80A8,
GL_SAMPLES = 0x80A9,
GL_SAMPLE_COVERAGE_VALUE = 0x80AA,
GL_SAMPLE_COVERAGE_INVERT = 0x80AB,
GL_CLAMP_TO_BORDER = 0x812D,
GL_TEXTURE0 = 0x84C0,
GL_TEXTURE1 = 0x84C1,
GL_TEXTURE2 = 0x84C2,
GL_TEXTURE3 = 0x84C3,
GL_TEXTURE4 = 0x84C4,
GL_TEXTURE5 = 0x84C5,
GL_TEXTURE6 = 0x84C6,
GL_TEXTURE7 = 0x84C7,
GL_TEXTURE8 = 0x84C8,
GL_TEXTURE9 = 0x84C9,
GL_TEXTURE10 = 0x84CA,
GL_TEXTURE11 = 0x84CB,
GL_TEXTURE12 = 0x84CC,
GL_TEXTURE13 = 0x84CD,
GL_TEXTURE14 = 0x84CE,
GL_TEXTURE15 = 0x84CF,
GL_TEXTURE16 = 0x84D0,
GL_TEXTURE17 = 0x84D1,
GL_TEXTURE18 = 0x84D2,
GL_TEXTURE19 = 0x84D3,
GL_TEXTURE20 = 0x84D4,
GL_TEXTURE21 = 0x84D5,
GL_TEXTURE22 = 0x84D6,
GL_TEXTURE23 = 0x84D7,
GL_TEXTURE24 = 0x84D8,
GL_TEXTURE25 = 0x84D9,
GL_TEXTURE26 = 0x84DA,
GL_TEXTURE27 = 0x84DB,
GL_TEXTURE28 = 0x84DC,
GL_TEXTURE29 = 0x84DD,
GL_TEXTURE30 = 0x84DE,
GL_TEXTURE31 = 0x84DF,
GL_ACTIVE_TEXTURE = 0x84E0,
GL_CLIENT_ACTIVE_TEXTURE = 0x84E1,
GL_MAX_TEXTURE_UNITS = 0x84E2,
GL_TRANSPOSE_MODELVIEW_MATRIX = 0x84E3,
GL_TRANSPOSE_PROJECTION_MATRIX = 0x84E4,
GL_TRANSPOSE_TEXTURE_MATRIX = 0x84E5,
GL_TRANSPOSE_COLOR_MATRIX = 0x84E6,
GL_SUBTRACT = 0x84E7,
GL_COMPRESSED_ALPHA = 0x84E9,
GL_COMPRESSED_LUMINANCE = 0x84EA,
GL_COMPRESSED_LUMINANCE_ALPHA = 0x84EB,
GL_COMPRESSED_INTENSITY = 0x84EC,
GL_COMPRESSED_RGB = 0x84ED,
GL_COMPRESSED_RGBA = 0x84EE,
GL_TEXTURE_COMPRESSION_HINT = 0x84EF,
GL_NORMAL_MAP = 0x8511,
GL_REFLECTION_MAP = 0x8512,
GL_TEXTURE_CUBE_MAP = 0x8513,
GL_TEXTURE_BINDING_CUBE_MAP = 0x8514,
GL_TEXTURE_CUBE_MAP_POSITIVE_X = 0x8515,
GL_TEXTURE_CUBE_MAP_NEGATIVE_X = 0x8516,
GL_TEXTURE_CUBE_MAP_POSITIVE_Y = 0x8517,
GL_TEXTURE_CUBE_MAP_NEGATIVE_Y = 0x8518,
GL_TEXTURE_CUBE_MAP_POSITIVE_Z = 0x8519,
GL_TEXTURE_CUBE_MAP_NEGATIVE_Z = 0x851A,
GL_PROXY_TEXTURE_CUBE_MAP = 0x851B,
GL_MAX_CUBE_MAP_TEXTURE_SIZE = 0x851C,
GL_COMBINE = 0x8570,
GL_COMBINE_RGB = 0x8571,
GL_COMBINE_ALPHA = 0x8572,
GL_RGB_SCALE = 0x8573,
GL_ADD_SIGNED = 0x8574,
GL_INTERPOLATE = 0x8575,
GL_CONSTANT = 0x8576,
GL_PRIMARY_COLOR = 0x8577,
GL_PREVIOUS = 0x8578,
GL_SOURCE0_RGB = 0x8580,
GL_SOURCE1_RGB = 0x8581,
GL_SOURCE2_RGB = 0x8582,
GL_SOURCE0_ALPHA = 0x8588,
GL_SOURCE1_ALPHA = 0x8589,
GL_SOURCE2_ALPHA = 0x858A,
GL_OPERAND0_RGB = 0x8590,
GL_OPERAND1_RGB = 0x8591,
GL_OPERAND2_RGB = 0x8592,
GL_OPERAND0_ALPHA = 0x8598,
GL_OPERAND1_ALPHA = 0x8599,
GL_OPERAND2_ALPHA = 0x859A,
GL_TEXTURE_COMPRESSED_IMAGE_SIZE = 0x86A0,
GL_TEXTURE_COMPRESSED = 0x86A1,
GL_NUM_COMPRESSED_TEXTURE_FORMATS = 0x86A2,
GL_COMPRESSED_TEXTURE_FORMATS = 0x86A3,
GL_DOT3_RGB = 0x86AE,
GL_DOT3_RGBA = 0x86AF,
GL_MULTISAMPLE_BIT = 0x20000000,
GL_BLEND_DST_RGB = 0x80C8,
GL_BLEND_SRC_RGB = 0x80C9,
GL_BLEND_DST_ALPHA = 0x80CA,
GL_BLEND_SRC_ALPHA = 0x80CB,
GL_POINT_SIZE_MIN = 0x8126,
GL_POINT_SIZE_MAX = 0x8127,
GL_POINT_FADE_THRESHOLD_SIZE = 0x8128,
GL_POINT_DISTANCE_ATTENUATION = 0x8129,
GL_GENERATE_MIPMAP = 0x8191,
GL_GENERATE_MIPMAP_HINT = 0x8192,
GL_DEPTH_COMPONENT16 = 0x81A5,
GL_DEPTH_COMPONENT24 = 0x81A6,
GL_DEPTH_COMPONENT32 = 0x81A7,
GL_MIRRORED_REPEAT = 0x8370,
GL_FOG_COORDINATE_SOURCE = 0x8450,
GL_FOG_COORDINATE = 0x8451,
GL_FRAGMENT_DEPTH = 0x8452,
GL_CURRENT_FOG_COORDINATE = 0x8453,
GL_FOG_COORDINATE_ARRAY_TYPE = 0x8454,
GL_FOG_COORDINATE_ARRAY_STRIDE = 0x8455,
GL_FOG_COORDINATE_ARRAY_POINTER = 0x8456,
GL_FOG_COORDINATE_ARRAY = 0x8457,
GL_COLOR_SUM = 0x8458,
GL_CURRENT_SECONDARY_COLOR = 0x8459,
GL_SECONDARY_COLOR_ARRAY_SIZE = 0x845A,
GL_SECONDARY_COLOR_ARRAY_TYPE = 0x845B,
GL_SECONDARY_COLOR_ARRAY_STRIDE = 0x845C,
GL_SECONDARY_COLOR_ARRAY_POINTER = 0x845D,
GL_SECONDARY_COLOR_ARRAY = 0x845E,
GL_MAX_TEXTURE_LOD_BIAS = 0x84FD,
GL_TEXTURE_FILTER_CONTROL = 0x8500,
GL_TEXTURE_LOD_BIAS = 0x8501,
GL_INCR_WRAP = 0x8507,
GL_DECR_WRAP = 0x8508,
GL_TEXTURE_DEPTH_SIZE = 0x884A,
GL_DEPTH_TEXTURE_MODE = 0x884B,
GL_TEXTURE_COMPARE_MODE = 0x884C,
GL_TEXTURE_COMPARE_FUNC = 0x884D,
GL_COMPARE_R_TO_TEXTURE = 0x884E,
GL_FOG_COORD_SRC = 0x8450,
GL_FOG_COORD = 0x8451,
GL_FOG_COORD_ARRAY = 0x8457,
GL_SRC0_RGB = 0x8580,
GL_FOG_COORD_ARRAY_POINTER = 0x8456,
GL_FOG_COORD_ARRAY_TYPE = 0x8454,
GL_SRC1_ALPHA = 0x8589,
GL_CURRENT_FOG_COORD = 0x8453,
GL_FOG_COORD_ARRAY_STRIDE = 0x8455,
GL_SRC0_ALPHA = 0x8588,
GL_SRC1_RGB = 0x8581,
GL_FOG_COORD_ARRAY_BUFFER_BINDING = 0x889D,
GL_SRC2_ALPHA = 0x858A,
GL_SRC2_RGB = 0x8582,
GL_BUFFER_SIZE = 0x8764,
GL_BUFFER_USAGE = 0x8765,
GL_QUERY_COUNTER_BITS = 0x8864,
GL_CURRENT_QUERY = 0x8865,
GL_QUERY_RESULT = 0x8866,
GL_QUERY_RESULT_AVAILABLE = 0x8867,
GL_ARRAY_BUFFER = 0x8892,
GL_ELEMENT_ARRAY_BUFFER = 0x8893,
GL_ARRAY_BUFFER_BINDING = 0x8894,
GL_ELEMENT_ARRAY_BUFFER_BINDING = 0x8895,
GL_VERTEX_ARRAY_BUFFER_BINDING = 0x8896,
GL_NORMAL_ARRAY_BUFFER_BINDING = 0x8897,
GL_COLOR_ARRAY_BUFFER_BINDING = 0x8898,
GL_INDEX_ARRAY_BUFFER_BINDING = 0x8899,
GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING = 0x889A,
GL_EDGE_FLAG_ARRAY_BUFFER_BINDING = 0x889B,
GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING = 0x889C,
GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING = 0x889D,
GL_WEIGHT_ARRAY_BUFFER_BINDING = 0x889E,
GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING = 0x889F,
GL_READ_ONLY = 0x88B8,
GL_WRITE_ONLY = 0x88B9,
GL_READ_WRITE = 0x88BA,
GL_BUFFER_ACCESS = 0x88BB,
GL_BUFFER_MAPPED = 0x88BC,
GL_BUFFER_MAP_POINTER = 0x88BD,
GL_STREAM_DRAW = 0x88E0,
GL_STREAM_READ = 0x88E1,
GL_STREAM_COPY = 0x88E2,
GL_STATIC_DRAW = 0x88E4,
GL_STATIC_READ = 0x88E5,
GL_STATIC_COPY = 0x88E6,
GL_DYNAMIC_DRAW = 0x88E8,
GL_DYNAMIC_READ = 0x88E9,
GL_DYNAMIC_COPY = 0x88EA,
GL_SAMPLES_PASSED = 0x8914,
GL_BLEND_EQUATION_RGB = 0x8009,
GL_VERTEX_ATTRIB_ARRAY_ENABLED = 0x8622,
GL_VERTEX_ATTRIB_ARRAY_SIZE = 0x8623,
GL_VERTEX_ATTRIB_ARRAY_STRIDE = 0x8624,
GL_VERTEX_ATTRIB_ARRAY_TYPE = 0x8625,
GL_CURRENT_VERTEX_ATTRIB = 0x8626,
GL_VERTEX_PROGRAM_POINT_SIZE = 0x8642,
GL_VERTEX_PROGRAM_TWO_SIDE = 0x8643,
GL_VERTEX_ATTRIB_ARRAY_POINTER = 0x8645,
GL_STENCIL_BACK_FUNC = 0x8800,
GL_STENCIL_BACK_FAIL = 0x8801,
GL_STENCIL_BACK_PASS_DEPTH_FAIL = 0x8802,
GL_STENCIL_BACK_PASS_DEPTH_PASS = 0x8803,
GL_MAX_DRAW_BUFFERS = 0x8824,
GL_DRAW_BUFFER0 = 0x8825,
GL_DRAW_BUFFER1 = 0x8826,
GL_DRAW_BUFFER2 = 0x8827,
GL_DRAW_BUFFER3 = 0x8828,
GL_DRAW_BUFFER4 = 0x8829,
GL_DRAW_BUFFER5 = 0x882A,
GL_DRAW_BUFFER6 = 0x882B,
GL_DRAW_BUFFER7 = 0x882C,
GL_DRAW_BUFFER8 = 0x882D,
GL_DRAW_BUFFER9 = 0x882E,
GL_DRAW_BUFFER10 = 0x882F,
GL_DRAW_BUFFER11 = 0x8830,
GL_DRAW_BUFFER12 = 0x8831,
GL_DRAW_BUFFER13 = 0x8832,
GL_DRAW_BUFFER14 = 0x8833,
GL_DRAW_BUFFER15 = 0x8834,
GL_BLEND_EQUATION_ALPHA = 0x883D,
GL_POINT_SPRITE = 0x8861,
GL_COORD_REPLACE = 0x8862,
GL_MAX_VERTEX_ATTRIBS = 0x8869,
GL_VERTEX_ATTRIB_ARRAY_NORMALIZED = 0x886A,
GL_MAX_TEXTURE_COORDS = 0x8871,
GL_MAX_TEXTURE_IMAGE_UNITS = 0x8872,
GL_FRAGMENT_SHADER = 0x8B30,
GL_VERTEX_SHADER = 0x8B31,
GL_MAX_FRAGMENT_UNIFORM_COMPONENTS = 0x8B49,
GL_MAX_VERTEX_UNIFORM_COMPONENTS = 0x8B4A,
GL_MAX_VARYING_FLOATS = 0x8B4B,
GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS = 0x8B4C,
GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS = 0x8B4D,
GL_SHADER_TYPE = 0x8B4F,
GL_FLOAT_VEC2 = 0x8B50,
GL_FLOAT_VEC3 = 0x8B51,
GL_FLOAT_VEC4 = 0x8B52,
GL_INT_VEC2 = 0x8B53,
GL_INT_VEC3 = 0x8B54,
GL_INT_VEC4 = 0x8B55,
GL_BOOL = 0x8B56,
GL_BOOL_VEC2 = 0x8B57,
GL_BOOL_VEC3 = 0x8B58,
GL_BOOL_VEC4 = 0x8B59,
GL_FLOAT_MAT2 = 0x8B5A,
GL_FLOAT_MAT3 = 0x8B5B,
GL_FLOAT_MAT4 = 0x8B5C,
GL_SAMPLER_1D = 0x8B5D,
GL_SAMPLER_2D = 0x8B5E,
GL_SAMPLER_3D = 0x8B5F,
GL_SAMPLER_CUBE = 0x8B60,
GL_SAMPLER_1D_SHADOW = 0x8B61,
GL_SAMPLER_2D_SHADOW = 0x8B62,
GL_DELETE_STATUS = 0x8B80,
GL_COMPILE_STATUS = 0x8B81,
GL_LINK_STATUS = 0x8B82,
GL_VALIDATE_STATUS = 0x8B83,
GL_INFO_LOG_LENGTH = 0x8B84,
GL_ATTACHED_SHADERS = 0x8B85,
GL_ACTIVE_UNIFORMS = 0x8B86,
GL_ACTIVE_UNIFORM_MAX_LENGTH = 0x8B87,
GL_SHADER_SOURCE_LENGTH = 0x8B88,
GL_ACTIVE_ATTRIBUTES = 0x8B89,
GL_ACTIVE_ATTRIBUTE_MAX_LENGTH = 0x8B8A,
GL_FRAGMENT_SHADER_DERIVATIVE_HINT = 0x8B8B,
GL_SHADING_LANGUAGE_VERSION = 0x8B8C,
GL_CURRENT_PROGRAM = 0x8B8D,
GL_POINT_SPRITE_COORD_ORIGIN = 0x8CA0,
GL_LOWER_LEFT = 0x8CA1,
GL_UPPER_LEFT = 0x8CA2,
GL_STENCIL_BACK_REF = 0x8CA3,
GL_STENCIL_BACK_VALUE_MASK = 0x8CA4,
GL_STENCIL_BACK_WRITEMASK = 0x8CA5,
GL_CURRENT_RASTER_SECONDARY_COLOR = 0x845F,
GL_PIXEL_PACK_BUFFER = 0x88EB,
GL_PIXEL_UNPACK_BUFFER = 0x88EC,
GL_PIXEL_PACK_BUFFER_BINDING = 0x88ED,
GL_PIXEL_UNPACK_BUFFER_BINDING = 0x88EF,
GL_FLOAT_MAT2x3 = 0x8B65,
GL_FLOAT_MAT2x4 = 0x8B66,
GL_FLOAT_MAT3x2 = 0x8B67,
GL_FLOAT_MAT3x4 = 0x8B68,
GL_FLOAT_MAT4x2 = 0x8B69,
GL_FLOAT_MAT4x3 = 0x8B6A,
GL_SRGB = 0x8C40,
GL_SRGB8 = 0x8C41,
GL_SRGB_ALPHA = 0x8C42,
GL_SRGB8_ALPHA8 = 0x8C43,
GL_SLUMINANCE_ALPHA = 0x8C44,
GL_SLUMINANCE8_ALPHA8 = 0x8C45,
GL_SLUMINANCE = 0x8C46,
GL_SLUMINANCE8 = 0x8C47,
GL_COMPRESSED_SRGB = 0x8C48,
GL_COMPRESSED_SRGB_ALPHA = 0x8C49,
GL_COMPRESSED_SLUMINANCE = 0x8C4A,
GL_COMPRESSED_SLUMINANCE_ALPHA = 0x8C4B,
GL_MAX_CLIP_DISTANCES = 0x0D32,
GL_CLIP_DISTANCE5 = 0x3005,
GL_CLIP_DISTANCE1 = 0x3001,
GL_CLIP_DISTANCE3 = 0x3003,
GL_COMPARE_REF_TO_TEXTURE = 0x884E,
GL_CLIP_DISTANCE0 = 0x3000,
GL_CLIP_DISTANCE4 = 0x3004,
GL_CLIP_DISTANCE2 = 0x3002,
GL_MAX_VARYING_COMPONENTS = 0x8B4B,
GL_CONTEXT_FLAG_FORWARD_COMPATIBLE_BIT = 0x0001,
GL_MAJOR_VERSION = 0x821B,
GL_MINOR_VERSION = 0x821C,
GL_NUM_EXTENSIONS = 0x821D,
GL_CONTEXT_FLAGS = 0x821E,
GL_DEPTH_BUFFER = 0x8223,
GL_STENCIL_BUFFER = 0x8224,
GL_COMPRESSED_RED = 0x8225,
GL_COMPRESSED_RG = 0x8226,
GL_RGBA32F = 0x8814,
GL_RGB32F = 0x8815,
GL_RGBA16F = 0x881A,
GL_RGB16F = 0x881B,
GL_VERTEX_ATTRIB_ARRAY_INTEGER = 0x88FD,
GL_MAX_ARRAY_TEXTURE_LAYERS = 0x88FF,
GL_MIN_PROGRAM_TEXEL_OFFSET = 0x8904,
GL_MAX_PROGRAM_TEXEL_OFFSET = 0x8905,
GL_CLAMP_VERTEX_COLOR = 0x891A,
GL_CLAMP_FRAGMENT_COLOR = 0x891B,
GL_CLAMP_READ_COLOR = 0x891C,
GL_FIXED_ONLY = 0x891D,
GL_TEXTURE_RED_TYPE = 0x8C10,
GL_TEXTURE_GREEN_TYPE = 0x8C11,
GL_TEXTURE_BLUE_TYPE = 0x8C12,
GL_TEXTURE_ALPHA_TYPE = 0x8C13,
GL_TEXTURE_LUMINANCE_TYPE = 0x8C14,
GL_TEXTURE_INTENSITY_TYPE = 0x8C15,
GL_TEXTURE_DEPTH_TYPE = 0x8C16,
GL_TEXTURE_1D_ARRAY = 0x8C18,
GL_PROXY_TEXTURE_1D_ARRAY = 0x8C19,
GL_TEXTURE_2D_ARRAY = 0x8C1A,
GL_PROXY_TEXTURE_2D_ARRAY = 0x8C1B,
GL_TEXTURE_BINDING_1D_ARRAY = 0x8C1C,
GL_TEXTURE_BINDING_2D_ARRAY = 0x8C1D,
GL_R11F_G11F_B10F = 0x8C3A,
GL_UNSIGNED_INT_10F_11F_11F_REV = 0x8C3B,
GL_RGB9_E5 = 0x8C3D,
GL_UNSIGNED_INT_5_9_9_9_REV = 0x8C3E,
GL_TEXTURE_SHARED_SIZE = 0x8C3F,
GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH = 0x8C76,
GL_TRANSFORM_FEEDBACK_BUFFER_MODE = 0x8C7F,
GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS = 0x8C80,
GL_TRANSFORM_FEEDBACK_VARYINGS = 0x8C83,
GL_TRANSFORM_FEEDBACK_BUFFER_START = 0x8C84,
GL_TRANSFORM_FEEDBACK_BUFFER_SIZE = 0x8C85,
GL_PRIMITIVES_GENERATED = 0x8C87,
GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN = 0x8C88,
GL_RASTERIZER_DISCARD = 0x8C89,
GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS = 0x8C8A,
GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS = 0x8C8B,
GL_INTERLEAVED_ATTRIBS = 0x8C8C,
GL_SEPARATE_ATTRIBS = 0x8C8D,
GL_TRANSFORM_FEEDBACK_BUFFER = 0x8C8E,
GL_TRANSFORM_FEEDBACK_BUFFER_BINDING = 0x8C8F,
GL_RGBA32UI = 0x8D70,
GL_RGB32UI = 0x8D71,
GL_RGBA16UI = 0x8D76,
GL_RGB16UI = 0x8D77,
GL_RGBA8UI = 0x8D7C,
GL_RGB8UI = 0x8D7D,
GL_RGBA32I = 0x8D82,
GL_RGB32I = 0x8D83,
GL_RGBA16I = 0x8D88,
GL_RGB16I = 0x8D89,
GL_RGBA8I = 0x8D8E,
GL_RGB8I = 0x8D8F,
GL_RED_INTEGER = 0x8D94,
GL_GREEN_INTEGER = 0x8D95,
GL_BLUE_INTEGER = 0x8D96,
GL_ALPHA_INTEGER = 0x8D97,
GL_RGB_INTEGER = 0x8D98,
GL_RGBA_INTEGER = 0x8D99,
GL_BGR_INTEGER = 0x8D9A,
GL_BGRA_INTEGER = 0x8D9B,
GL_SAMPLER_1D_ARRAY = 0x8DC0,
GL_SAMPLER_2D_ARRAY = 0x8DC1,
GL_SAMPLER_1D_ARRAY_SHADOW = 0x8DC3,
GL_SAMPLER_2D_ARRAY_SHADOW = 0x8DC4,
GL_SAMPLER_CUBE_SHADOW = 0x8DC5,
GL_UNSIGNED_INT_VEC2 = 0x8DC6,
GL_UNSIGNED_INT_VEC3 = 0x8DC7,
GL_UNSIGNED_INT_VEC4 = 0x8DC8,
GL_INT_SAMPLER_1D = 0x8DC9,
GL_INT_SAMPLER_2D = 0x8DCA,
GL_INT_SAMPLER_3D = 0x8DCB,
GL_INT_SAMPLER_CUBE = 0x8DCC,
GL_INT_SAMPLER_1D_ARRAY = 0x8DCE,
GL_INT_SAMPLER_2D_ARRAY = 0x8DCF,
GL_UNSIGNED_INT_SAMPLER_1D = 0x8DD1,
GL_UNSIGNED_INT_SAMPLER_2D = 0x8DD2,
GL_UNSIGNED_INT_SAMPLER_3D = 0x8DD3,
GL_UNSIGNED_INT_SAMPLER_CUBE = 0x8DD4,
GL_UNSIGNED_INT_SAMPLER_1D_ARRAY = 0x8DD6,
GL_UNSIGNED_INT_SAMPLER_2D_ARRAY = 0x8DD7,
GL_QUERY_WAIT = 0x8E13,
GL_QUERY_NO_WAIT = 0x8E14,
GL_QUERY_BY_REGION_WAIT = 0x8E15,
GL_QUERY_BY_REGION_NO_WAIT = 0x8E16,
GL_TEXTURE_RECTANGLE = 0x84F5,
GL_TEXTURE_BINDING_RECTANGLE = 0x84F6,
GL_PROXY_TEXTURE_RECTANGLE = 0x84F7,
GL_MAX_RECTANGLE_TEXTURE_SIZE = 0x84F8,
GL_SAMPLER_2D_RECT = 0x8B63,
GL_SAMPLER_2D_RECT_SHADOW = 0x8B64,
GL_TEXTURE_BUFFER = 0x8C2A,
GL_MAX_TEXTURE_BUFFER_SIZE = 0x8C2B,
GL_TEXTURE_BINDING_BUFFER = 0x8C2C,
GL_TEXTURE_BUFFER_DATA_STORE_BINDING = 0x8C2D,
GL_TEXTURE_BUFFER_FORMAT = 0x8C2E,
GL_SAMPLER_BUFFER = 0x8DC2,
GL_INT_SAMPLER_2D_RECT = 0x8DCD,
GL_INT_SAMPLER_BUFFER = 0x8DD0,
GL_UNSIGNED_INT_SAMPLER_2D_RECT = 0x8DD5,
GL_UNSIGNED_INT_SAMPLER_BUFFER = 0x8DD8,
GL_RED_SNORM = 0x8F90,
GL_RG_SNORM = 0x8F91,
GL_RGB_SNORM = 0x8F92,
GL_RGBA_SNORM = 0x8F93,
GL_R8_SNORM = 0x8F94,
GL_RG8_SNORM = 0x8F95,
GL_RGB8_SNORM = 0x8F96,
GL_RGBA8_SNORM = 0x8F97,
GL_R16_SNORM = 0x8F98,
GL_RG16_SNORM = 0x8F99,
GL_RGB16_SNORM = 0x8F9A,
GL_RGBA16_SNORM = 0x8F9B,
GL_SIGNED_NORMALIZED = 0x8F9C,
GL_PRIMITIVE_RESTART = 0x8F9D,
GL_PRIMITIVE_RESTART_INDEX = 0x8F9E,
GL_BUFFER_ACCESS_FLAGS = 0x911F,
GL_BUFFER_MAP_LENGTH = 0x9120,
GL_BUFFER_MAP_OFFSET = 0x9121,
GL_CONTEXT_CORE_PROFILE_BIT = 0x00000001,
GL_CONTEXT_COMPATIBILITY_PROFILE_BIT = 0x00000002,
GL_LINES_ADJACENCY = 0x000A,
GL_LINE_STRIP_ADJACENCY = 0x000B,
GL_TRIANGLES_ADJACENCY = 0x000C,
GL_TRIANGLE_STRIP_ADJACENCY = 0x000D,
GL_PROGRAM_POINT_SIZE = 0x8642,
GL_GEOMETRY_VERTICES_OUT = 0x8916,
GL_GEOMETRY_INPUT_TYPE = 0x8917,
GL_GEOMETRY_OUTPUT_TYPE = 0x8918,
GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS = 0x8C29,
GL_FRAMEBUFFER_ATTACHMENT_LAYERED = 0x8DA7,
GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS = 0x8DA8,
GL_GEOMETRY_SHADER = 0x8DD9,
GL_MAX_GEOMETRY_UNIFORM_COMPONENTS = 0x8DDF,
GL_MAX_GEOMETRY_OUTPUT_VERTICES = 0x8DE0,
GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS = 0x8DE1,
GL_MAX_VERTEX_OUTPUT_COMPONENTS = 0x9122,
GL_MAX_GEOMETRY_INPUT_COMPONENTS = 0x9123,
GL_MAX_GEOMETRY_OUTPUT_COMPONENTS = 0x9124,
GL_MAX_FRAGMENT_INPUT_COMPONENTS = 0x9125,
GL_CONTEXT_PROFILE_MASK = 0x9126,
GL_VERTEX_ATTRIB_ARRAY_DIVISOR = 0x88FE,
GL_TEXTURE_SWIZZLE_R = 0x8E42,
GL_TEXTURE_SWIZZLE_G = 0x8E43,
GL_TEXTURE_SWIZZLE_B = 0x8E44,
GL_TEXTURE_SWIZZLE_A = 0x8E45,
GL_TEXTURE_SWIZZLE_RGBA = 0x8E46,
GL_RGB10_A2UI = 0x906F,
GL_GEOMETRY_SHADER_INVOCATIONS = 0x887F,
GL_SAMPLE_SHADING = 0x8C36,
GL_MIN_SAMPLE_SHADING_VALUE = 0x8C37,
GL_MAX_GEOMETRY_SHADER_INVOCATIONS = 0x8E5A,
GL_MIN_FRAGMENT_INTERPOLATION_OFFSET = 0x8E5B,
GL_MAX_FRAGMENT_INTERPOLATION_OFFSET = 0x8E5C,
GL_FRAGMENT_INTERPOLATION_OFFSET_BITS = 0x8E5D,
GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET = 0x8E5E,
GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET = 0x8E5F,
GL_MAX_PROGRAM_TEXTURE_GATHER_COMPONENTS = 0x8F9F,
GL_TEXTURE_CUBE_MAP_ARRAY = 0x9009,
GL_TEXTURE_BINDING_CUBE_MAP_ARRAY = 0x900A,
GL_PROXY_TEXTURE_CUBE_MAP_ARRAY = 0x900B,
GL_SAMPLER_CUBE_MAP_ARRAY = 0x900C,
GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW = 0x900D,
GL_INT_SAMPLER_CUBE_MAP_ARRAY = 0x900E,
GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY = 0x900F,
GL_COMPRESSED_RGBA_BPTC_UNORM = 0x8E8C,
GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM = 0x8E8D,
GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT = 0x8E8E,
GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT = 0x8E8F,
GL_NUM_SHADING_LANGUAGE_VERSIONS = 0x82E9,
GL_VERTEX_ATTRIB_ARRAY_LONG = 0x874E,
GL_MAX_VERTEX_ATTRIB_STRIDE = 0x82E5,
GL_FACTOR_MIN_AMD = 0x901C,
GL_FACTOR_MAX_AMD = 0x901D,
GL_DEBUG_CATEGORY_API_ERROR_AMD = 0x9149,
GL_DEBUG_CATEGORY_WINDOW_SYSTEM_AMD = 0x914A,
GL_DEBUG_CATEGORY_DEPRECATION_AMD = 0x914B,
GL_DEBUG_CATEGORY_UNDEFINED_BEHAVIOR_AMD = 0x914C,
GL_DEBUG_CATEGORY_PERFORMANCE_AMD = 0x914D,
GL_DEBUG_CATEGORY_SHADER_COMPILER_AMD = 0x914E,
GL_DEBUG_CATEGORY_APPLICATION_AMD = 0x914F,
GL_DEBUG_CATEGORY_OTHER_AMD = 0x9150,
GL_DEPTH_CLAMP_NEAR_AMD = 0x901E,
GL_DEPTH_CLAMP_FAR_AMD = 0x901F,
//GL_RED = 0x1903,
//GL_GREEN = 0x1904,
//GL_BLUE = 0x1905,
//GL_ALPHA = 0x1906,
GL_RG8UI = 0x8238,
GL_RG16UI = 0x823A,
//GL_RGBA8UI = 0x8D7C,
GL_VERTEX_ELEMENT_SWIZZLE_AMD = 0x91A4,
GL_VERTEX_ID_SWIZZLE_AMD = 0x91A5,
GL_DATA_BUFFER_AMD = 0x9151,
GL_PERFORMANCE_MONITOR_AMD = 0x9152,
GL_QUERY_OBJECT_AMD = 0x9153,
GL_VERTEX_ARRAY_OBJECT_AMD = 0x9154,
GL_SAMPLER_OBJECT_AMD = 0x9155,
GL_COUNTER_TYPE_AMD = 0x8BC0,
GL_COUNTER_RANGE_AMD = 0x8BC1,
GL_UNSIGNED_INT64_AMD = 0x8BC2,
GL_PERCENTAGE_AMD = 0x8BC3,
GL_PERFMON_RESULT_AVAILABLE_AMD = 0x8BC4,
GL_PERFMON_RESULT_SIZE_AMD = 0x8BC5,
GL_PERFMON_RESULT_AMD = 0x8BC6,
GL_EXTERNAL_VIRTUAL_MEMORY_BUFFER_AMD = 0x9160,
GL_SUBSAMPLE_DISTANCE_AMD = 0x883F,
GL_TEXTURE_STORAGE_SPARSE_BIT_AMD = 0x00000001,
GL_VIRTUAL_PAGE_SIZE_X_AMD = 0x9195,
GL_VIRTUAL_PAGE_SIZE_Y_AMD = 0x9196,
GL_VIRTUAL_PAGE_SIZE_Z_AMD = 0x9197,
GL_MAX_SPARSE_TEXTURE_SIZE_AMD = 0x9198,
GL_MAX_SPARSE_3D_TEXTURE_SIZE_AMD = 0x9199,
GL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS = 0x919A,
GL_MIN_SPARSE_LEVEL_AMD = 0x919B,
GL_MIN_LOD_WARNING_AMD = 0x919C,
GL_REPLACE_VALUE_AMD = 0x874B,
GL_STENCIL_OP_VALUE_AMD = 0x874C,
GL_STENCIL_BACK_OP_VALUE_AMD = 0x874D,
GL_TESSELLATION_MODE_AMD = 0x9004,
GL_TESSELLATION_FACTOR_AMD = 0x9005,
GL_DISCRETE_AMD = 0x9006,
GL_CONTINUOUS_AMD = 0x9007,
GL_FIXED = 0x140C,
GL_IMPLEMENTATION_COLOR_READ_TYPE = 0x8B9A,
GL_IMPLEMENTATION_COLOR_READ_FORMAT = 0x8B9B,
GL_RGB565 = 0x8D62,
GL_LOW_FLOAT = 0x8DF0,
GL_MEDIUM_FLOAT = 0x8DF1,
GL_HIGH_FLOAT = 0x8DF2,
GL_LOW_INT = 0x8DF3,
GL_MEDIUM_INT = 0x8DF4,
GL_HIGH_INT = 0x8DF5,
GL_SHADER_BINARY_FORMATS = 0x8DF8,
GL_NUM_SHADER_BINARY_FORMATS = 0x8DF9,
GL_SHADER_COMPILER = 0x8DFA,
GL_MAX_VERTEX_UNIFORM_VECTORS = 0x8DFB,
GL_MAX_VARYING_VECTORS = 0x8DFC,
GL_MAX_FRAGMENT_UNIFORM_VECTORS = 0x8DFD,
GL_TEXTURE_IMMUTABLE_LEVELS = 0x82DF,
GL_PRIMITIVE_RESTART_FIXED_INDEX = 0x8D69,
GL_ANY_SAMPLES_PASSED_CONSERVATIVE = 0x8D6A,
GL_MAX_ELEMENT_INDEX = 0x8D6B,
GL_COMPRESSED_R11_EAC = 0x9270,
GL_COMPRESSED_SIGNED_R11_EAC = 0x9271,
GL_COMPRESSED_RG11_EAC = 0x9272,
GL_COMPRESSED_SIGNED_RG11_EAC = 0x9273,
GL_COMPRESSED_RGB8_ETC2 = 0x9274,
GL_COMPRESSED_SRGB8_ETC2 = 0x9275,
GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2 = 0x9276,
GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2 = 0x9277,
GL_COMPRESSED_RGBA8_ETC2_EAC = 0x9278,
GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC = 0x9279,
GL_UNSIGNED_INT64_ARB = 0x140F,
GL_SRC1_COLOR = 0x88F9,
GL_ONE_MINUS_SRC1_COLOR = 0x88FA,
GL_ONE_MINUS_SRC1_ALPHA = 0x88FB,
GL_MAX_DUAL_SOURCE_DRAW_BUFFERS = 0x88FC,
GL_MAP_READ_BIT = 0x0001,
GL_MAP_WRITE_BIT = 0x0002,
GL_MAP_PERSISTENT_BIT = 0x00000040,
GL_MAP_COHERENT_BIT = 0x00000080,
GL_DYNAMIC_STORAGE_BIT = 0x0100,
GL_CLIENT_STORAGE_BIT = 0x0200,
GL_CLIENT_MAPPED_BUFFER_BARRIER_BIT = 0x00004000,
GL_BUFFER_IMMUTABLE_STORAGE = 0x821F,
GL_BUFFER_STORAGE_FLAGS = 0x8220,
GL_SYNC_CL_EVENT_ARB = 0x8240,
GL_SYNC_CL_EVENT_COMPLETE_ARB = 0x8241,
GL_CLEAR_TEXTURE = 0x9365,
GL_RGBA_FLOAT_MODE_ARB = 0x8820,
GL_UNPACK_COMPRESSED_BLOCK_WIDTH = 0x9127,
GL_UNPACK_COMPRESSED_BLOCK_HEIGHT = 0x9128,
GL_UNPACK_COMPRESSED_BLOCK_DEPTH = 0x9129,
GL_UNPACK_COMPRESSED_BLOCK_SIZE = 0x912A,
GL_PACK_COMPRESSED_BLOCK_WIDTH = 0x912B,
GL_PACK_COMPRESSED_BLOCK_HEIGHT = 0x912C,
GL_PACK_COMPRESSED_BLOCK_DEPTH = 0x912D,
GL_PACK_COMPRESSED_BLOCK_SIZE = 0x912E,
GL_COMPUTE_SHADER_BIT = 0x00000020,
GL_MAX_COMPUTE_SHARED_MEMORY_SIZE = 0x8262,
GL_MAX_COMPUTE_UNIFORM_COMPONENTS = 0x8263,
GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS = 0x8264,
GL_MAX_COMPUTE_ATOMIC_COUNTERS = 0x8265,
GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS = 0x8266,
GL_COMPUTE_WORK_GROUP_SIZE = 0x8267,
GL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS = 0x90EB,
GL_UNIFORM_BLOCK_REFERENCED_BY_COMPUTE_SHADER = 0x90EC,
GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_COMPUTE_SHADER = 0x90ED,
GL_DISPATCH_INDIRECT_BUFFER = 0x90EE,
GL_DISPATCH_INDIRECT_BUFFER_BINDING = 0x90EF,
GL_COMPUTE_SHADER = 0x91B9,
GL_MAX_COMPUTE_UNIFORM_BLOCKS = 0x91BB,
GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS = 0x91BC,
GL_MAX_COMPUTE_IMAGE_UNIFORMS = 0x91BD,
GL_MAX_COMPUTE_WORK_GROUP_COUNT = 0x91BE,
GL_MAX_COMPUTE_WORK_GROUP_SIZE = 0x91BF,
GL_MAX_COMPUTE_FIXED_GROUP_INVOCATIONS_ARB = 0x90EB,
GL_MAX_COMPUTE_FIXED_GROUP_SIZE_ARB = 0x91BF,
GL_MAX_COMPUTE_VARIABLE_GROUP_INVOCATIONS_ARB = 0x9344,
GL_MAX_COMPUTE_VARIABLE_GROUP_SIZE_ARB = 0x9345,
GL_COPY_READ_BUFFER = 0x8F36,
GL_COPY_WRITE_BUFFER = 0x8F37,
GL_DEPTH_COMPONENT32F = 0x8CAC,
GL_DEPTH32F_STENCIL8 = 0x8CAD,
GL_FLOAT_32_UNSIGNED_INT_24_8_REV = 0x8DAD,
GL_DEPTH_CLAMP = 0x864F,
GL_DRAW_INDIRECT_BUFFER = 0x8F3F,
GL_DRAW_INDIRECT_BUFFER_BINDING = 0x8F43,
GL_LOCATION_COMPONENT = 0x934A,
GL_TRANSFORM_FEEDBACK_BUFFER_INDEX = 0x934B,
GL_TRANSFORM_FEEDBACK_BUFFER_STRIDE = 0x934C,
GL_MAX_UNIFORM_LOCATIONS = 0x826E,
GL_FRAGMENT_PROGRAM_ARB = 0x8804,
GL_PROGRAM_ALU_INSTRUCTIONS_ARB = 0x8805,
GL_PROGRAM_TEX_INSTRUCTIONS_ARB = 0x8806,
GL_PROGRAM_TEX_INDIRECTIONS_ARB = 0x8807,
GL_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB = 0x8808,
GL_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB = 0x8809,
GL_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB = 0x880A,
GL_MAX_PROGRAM_ALU_INSTRUCTIONS_ARB = 0x880B,
GL_MAX_PROGRAM_TEX_INSTRUCTIONS_ARB = 0x880C,
GL_MAX_PROGRAM_TEX_INDIRECTIONS_ARB = 0x880D,
GL_MAX_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB = 0x880E,
GL_MAX_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB = 0x880F,
GL_MAX_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB = 0x8810,
GL_FRAMEBUFFER_DEFAULT_WIDTH = 0x9310,
GL_FRAMEBUFFER_DEFAULT_HEIGHT = 0x9311,
GL_FRAMEBUFFER_DEFAULT_LAYERS = 0x9312,
GL_FRAMEBUFFER_DEFAULT_SAMPLES = 0x9313,
GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS = 0x9314,
GL_MAX_FRAMEBUFFER_WIDTH = 0x9315,
GL_MAX_FRAMEBUFFER_HEIGHT = 0x9316,
GL_MAX_FRAMEBUFFER_LAYERS = 0x9317,
GL_MAX_FRAMEBUFFER_SAMPLES = 0x9318,
GL_INVALID_FRAMEBUFFER_OPERATION = 0x0506,
GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING = 0x8210,
GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE = 0x8211,
GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE = 0x8212,
GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE = 0x8213,
GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE = 0x8214,
GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE = 0x8215,
GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE = 0x8216,
GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE = 0x8217,
GL_FRAMEBUFFER_DEFAULT = 0x8218,
GL_FRAMEBUFFER_UNDEFINED = 0x8219,
GL_DEPTH_STENCIL_ATTACHMENT = 0x821A,
GL_INDEX = 0x8222,
GL_MAX_RENDERBUFFER_SIZE = 0x84E8,
GL_DEPTH_STENCIL = 0x84F9,
GL_UNSIGNED_INT_24_8 = 0x84FA,
GL_DEPTH24_STENCIL8 = 0x88F0,
GL_TEXTURE_STENCIL_SIZE = 0x88F1,
GL_UNSIGNED_NORMALIZED = 0x8C17,
//GL_SRGB = 0x8C40,
GL_DRAW_FRAMEBUFFER_BINDING = 0x8CA6,
GL_FRAMEBUFFER_BINDING = 0x8CA6,
GL_RENDERBUFFER_BINDING = 0x8CA7,
GL_READ_FRAMEBUFFER = 0x8CA8,
GL_DRAW_FRAMEBUFFER = 0x8CA9,
GL_READ_FRAMEBUFFER_BINDING = 0x8CAA,
GL_RENDERBUFFER_SAMPLES = 0x8CAB,
GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE = 0x8CD0,
GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME = 0x8CD1,
GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL = 0x8CD2,
GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE = 0x8CD3,
GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER = 0x8CD4,
GL_FRAMEBUFFER_COMPLETE = 0x8CD5,
GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT = 0x8CD6,
GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT = 0x8CD7,
GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER = 0x8CDB,
GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER = 0x8CDC,
GL_FRAMEBUFFER_UNSUPPORTED = 0x8CDD,
GL_MAX_COLOR_ATTACHMENTS = 0x8CDF,
GL_COLOR_ATTACHMENT0 = 0x8CE0,
GL_COLOR_ATTACHMENT1 = 0x8CE1,
GL_COLOR_ATTACHMENT2 = 0x8CE2,
GL_COLOR_ATTACHMENT3 = 0x8CE3,
GL_COLOR_ATTACHMENT4 = 0x8CE4,
GL_COLOR_ATTACHMENT5 = 0x8CE5,
GL_COLOR_ATTACHMENT6 = 0x8CE6,
GL_COLOR_ATTACHMENT7 = 0x8CE7,
GL_COLOR_ATTACHMENT8 = 0x8CE8,
GL_COLOR_ATTACHMENT9 = 0x8CE9,
GL_COLOR_ATTACHMENT10 = 0x8CEA,
GL_COLOR_ATTACHMENT11 = 0x8CEB,
GL_COLOR_ATTACHMENT12 = 0x8CEC,
GL_COLOR_ATTACHMENT13 = 0x8CED,
GL_COLOR_ATTACHMENT14 = 0x8CEE,
GL_COLOR_ATTACHMENT15 = 0x8CEF,
GL_DEPTH_ATTACHMENT = 0x8D00,
GL_STENCIL_ATTACHMENT = 0x8D20,
GL_FRAMEBUFFER = 0x8D40,
GL_RENDERBUFFER = 0x8D41,
GL_RENDERBUFFER_WIDTH = 0x8D42,
GL_RENDERBUFFER_HEIGHT = 0x8D43,
GL_RENDERBUFFER_INTERNAL_FORMAT = 0x8D44,
GL_STENCIL_INDEX1 = 0x8D46,
GL_STENCIL_INDEX4 = 0x8D47,
GL_STENCIL_INDEX8 = 0x8D48,
GL_STENCIL_INDEX16 = 0x8D49,
GL_RENDERBUFFER_RED_SIZE = 0x8D50,
GL_RENDERBUFFER_GREEN_SIZE = 0x8D51,
GL_RENDERBUFFER_BLUE_SIZE = 0x8D52,
GL_RENDERBUFFER_ALPHA_SIZE = 0x8D53,
GL_RENDERBUFFER_DEPTH_SIZE = 0x8D54,
GL_RENDERBUFFER_STENCIL_SIZE = 0x8D55,
GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE = 0x8D56,
GL_MAX_SAMPLES = 0x8D57,
GL_FRAMEBUFFER_SRGB = 0x8DB9,
//GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER = 0x8CD4,
GL_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_ARB = 0x8DA9,
GL_MAX_GEOMETRY_VARYING_COMPONENTS_ARB = 0x8DDD,
GL_MAX_VERTEX_VARYING_COMPONENTS_ARB = 0x8DDE,
GL_PROGRAM_BINARY_RETRIEVABLE_HINT = 0x8257,
GL_PROGRAM_BINARY_LENGTH = 0x8741,
GL_NUM_PROGRAM_BINARY_FORMATS = 0x87FE,
GL_PROGRAM_BINARY_FORMATS = 0x87FF,
//GL_GEOMETRY_SHADER_INVOCATIONS = 0x887F,
//GL_MAX_GEOMETRY_SHADER_INVOCATIONS = 0x8E5A,
//GL_MIN_FRAGMENT_INTERPOLATION_OFFSET = 0x8E5B,
//GL_MAX_FRAGMENT_INTERPOLATION_OFFSET = 0x8E5C,
//GL_FRAGMENT_INTERPOLATION_OFFSET_BITS = 0x8E5D,
GL_MAX_VERTEX_STREAMS = 0x8E71,
GL_DOUBLE_MAT2 = 0x8F46,
GL_DOUBLE_MAT3 = 0x8F47,
GL_DOUBLE_MAT4 = 0x8F48,
GL_DOUBLE_MAT2x3 = 0x8F49,
GL_DOUBLE_MAT2x4 = 0x8F4A,
GL_DOUBLE_MAT3x2 = 0x8F4B,
GL_DOUBLE_MAT3x4 = 0x8F4C,
GL_DOUBLE_MAT4x2 = 0x8F4D,
GL_DOUBLE_MAT4x3 = 0x8F4E,
GL_DOUBLE_VEC2 = 0x8FFC,
GL_DOUBLE_VEC3 = 0x8FFD,
GL_DOUBLE_VEC4 = 0x8FFE,
GL_HALF_FLOAT = 0x140B,
GL_CONSTANT_COLOR = 0x8001,
GL_ONE_MINUS_CONSTANT_COLOR = 0x8002,
GL_CONSTANT_ALPHA = 0x8003,
GL_ONE_MINUS_CONSTANT_ALPHA = 0x8004,
GL_BLEND_COLOR = 0x8005,
GL_FUNC_ADD = 0x8006,
GL_MIN = 0x8007,
GL_MAX = 0x8008,
GL_BLEND_EQUATION = 0x8009,
GL_FUNC_SUBTRACT = 0x800A,
GL_FUNC_REVERSE_SUBTRACT = 0x800B,
GL_CONVOLUTION_1D = 0x8010,
GL_CONVOLUTION_2D = 0x8011,
GL_SEPARABLE_2D = 0x8012,
GL_CONVOLUTION_BORDER_MODE = 0x8013,
GL_CONVOLUTION_FILTER_SCALE = 0x8014,
GL_CONVOLUTION_FILTER_BIAS = 0x8015,
GL_REDUCE = 0x8016,
GL_CONVOLUTION_FORMAT = 0x8017,
GL_CONVOLUTION_WIDTH = 0x8018,
GL_CONVOLUTION_HEIGHT = 0x8019,
GL_MAX_CONVOLUTION_WIDTH = 0x801A,
GL_MAX_CONVOLUTION_HEIGHT = 0x801B,
GL_POST_CONVOLUTION_RED_SCALE = 0x801C,
GL_POST_CONVOLUTION_GREEN_SCALE = 0x801D,
GL_POST_CONVOLUTION_BLUE_SCALE = 0x801E,
GL_POST_CONVOLUTION_ALPHA_SCALE = 0x801F,
GL_POST_CONVOLUTION_RED_BIAS = 0x8020,
GL_POST_CONVOLUTION_GREEN_BIAS = 0x8021,
GL_POST_CONVOLUTION_BLUE_BIAS = 0x8022,
GL_POST_CONVOLUTION_ALPHA_BIAS = 0x8023,
GL_HISTOGRAM = 0x8024,
GL_PROXY_HISTOGRAM = 0x8025,
GL_HISTOGRAM_WIDTH = 0x8026,
GL_HISTOGRAM_FORMAT = 0x8027,
GL_HISTOGRAM_RED_SIZE = 0x8028,
GL_HISTOGRAM_GREEN_SIZE = 0x8029,
GL_HISTOGRAM_BLUE_SIZE = 0x802A,
GL_HISTOGRAM_ALPHA_SIZE = 0x802B,
GL_HISTOGRAM_LUMINANCE_SIZE = 0x802C,
GL_HISTOGRAM_SINK = 0x802D,
GL_MINMAX = 0x802E,
GL_MINMAX_FORMAT = 0x802F,
GL_MINMAX_SINK = 0x8030,
GL_TABLE_TOO_LARGE = 0x8031,
GL_COLOR_MATRIX = 0x80B1,
GL_COLOR_MATRIX_STACK_DEPTH = 0x80B2,
GL_MAX_COLOR_MATRIX_STACK_DEPTH = 0x80B3,
GL_POST_COLOR_MATRIX_RED_SCALE = 0x80B4,
GL_POST_COLOR_MATRIX_GREEN_SCALE = 0x80B5,
GL_POST_COLOR_MATRIX_BLUE_SCALE = 0x80B6,
GL_POST_COLOR_MATRIX_ALPHA_SCALE = 0x80B7,
GL_POST_COLOR_MATRIX_RED_BIAS = 0x80B8,
GL_POST_COLOR_MATRIX_GREEN_BIAS = 0x80B9,
GL_POST_COLOR_MATRIX_BLUE_BIAS = 0x80BA,
GL_POST_COLOR_MATRIX_ALPHA_BIAS = 0x80BB,
GL_COLOR_TABLE = 0x80D0,
GL_POST_CONVOLUTION_COLOR_TABLE = 0x80D1,
GL_POST_COLOR_MATRIX_COLOR_TABLE = 0x80D2,
GL_PROXY_COLOR_TABLE = 0x80D3,
GL_PROXY_POST_CONVOLUTION_COLOR_TABLE = 0x80D4,
GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE = 0x80D5,
GL_COLOR_TABLE_SCALE = 0x80D6,
GL_COLOR_TABLE_BIAS = 0x80D7,
GL_COLOR_TABLE_FORMAT = 0x80D8,
GL_COLOR_TABLE_WIDTH = 0x80D9,
GL_COLOR_TABLE_RED_SIZE = 0x80DA,
GL_COLOR_TABLE_GREEN_SIZE = 0x80DB,
GL_COLOR_TABLE_BLUE_SIZE = 0x80DC,
GL_COLOR_TABLE_ALPHA_SIZE = 0x80DD,
GL_COLOR_TABLE_LUMINANCE_SIZE = 0x80DE,
GL_COLOR_TABLE_INTENSITY_SIZE = 0x80DF,
GL_IGNORE_BORDER = 0x8150,
GL_CONSTANT_BORDER = 0x8151,
GL_WRAP_BORDER = 0x8152,
GL_REPLICATE_BORDER = 0x8153,
GL_CONVOLUTION_BORDER_COLOR = 0x8154,
GL_PARAMETER_BUFFER_ARB = 0x80EE,
GL_PARAMETER_BUFFER_BINDING_ARB = 0x80EF,
GL_NUM_SAMPLE_COUNTS = 0x9380,
GL_INTERNALFORMAT_SUPPORTED = 0x826F,
GL_INTERNALFORMAT_PREFERRED = 0x8270,
GL_INTERNALFORMAT_RED_SIZE = 0x8271,
GL_INTERNALFORMAT_GREEN_SIZE = 0x8272,
GL_INTERNALFORMAT_BLUE_SIZE = 0x8273,
GL_INTERNALFORMAT_ALPHA_SIZE = 0x8274,
GL_INTERNALFORMAT_DEPTH_SIZE = 0x8275,
GL_INTERNALFORMAT_STENCIL_SIZE = 0x8276,
GL_INTERNALFORMAT_SHARED_SIZE = 0x8277,
GL_INTERNALFORMAT_RED_TYPE = 0x8278,
GL_INTERNALFORMAT_GREEN_TYPE = 0x8279,
GL_INTERNALFORMAT_BLUE_TYPE = 0x827A,
GL_INTERNALFORMAT_ALPHA_TYPE = 0x827B,
GL_INTERNALFORMAT_DEPTH_TYPE = 0x827C,
GL_INTERNALFORMAT_STENCIL_TYPE = 0x827D,
GL_MAX_WIDTH = 0x827E,
GL_MAX_HEIGHT = 0x827F,
GL_MAX_DEPTH = 0x8280,
GL_MAX_LAYERS = 0x8281,
GL_MAX_COMBINED_DIMENSIONS = 0x8282,
GL_COLOR_COMPONENTS = 0x8283,
GL_DEPTH_COMPONENTS = 0x8284,
GL_STENCIL_COMPONENTS = 0x8285,
GL_COLOR_RENDERABLE = 0x8286,
GL_DEPTH_RENDERABLE = 0x8287,
GL_STENCIL_RENDERABLE = 0x8288,
GL_FRAMEBUFFER_RENDERABLE = 0x8289,
GL_FRAMEBUFFER_RENDERABLE_LAYERED = 0x828A,
GL_FRAMEBUFFER_BLEND = 0x828B,
GL_READ_PIXELS = 0x828C,
GL_READ_PIXELS_FORMAT = 0x828D,
GL_READ_PIXELS_TYPE = 0x828E,
GL_TEXTURE_IMAGE_FORMAT = 0x828F,
GL_TEXTURE_IMAGE_TYPE = 0x8290,
GL_GET_TEXTURE_IMAGE_FORMAT = 0x8291,
GL_GET_TEXTURE_IMAGE_TYPE = 0x8292,
GL_MIPMAP = 0x8293,
GL_MANUAL_GENERATE_MIPMAP = 0x8294,
GL_AUTO_GENERATE_MIPMAP = 0x8295,
GL_COLOR_ENCODING = 0x8296,
GL_SRGB_READ = 0x8297,
GL_SRGB_WRITE = 0x8298,
GL_SRGB_DECODE_ARB = 0x8299,
GL_FILTER = 0x829A,
GL_VERTEX_TEXTURE = 0x829B,
GL_TESS_CONTROL_TEXTURE = 0x829C,
GL_TESS_EVALUATION_TEXTURE = 0x829D,
GL_GEOMETRY_TEXTURE = 0x829E,
GL_FRAGMENT_TEXTURE = 0x829F,
GL_COMPUTE_TEXTURE = 0x82A0,
GL_TEXTURE_SHADOW = 0x82A1,
GL_TEXTURE_GATHER = 0x82A2,
GL_TEXTURE_GATHER_SHADOW = 0x82A3,
GL_SHADER_IMAGE_LOAD = 0x82A4,
GL_SHADER_IMAGE_STORE = 0x82A5,
GL_SHADER_IMAGE_ATOMIC = 0x82A6,
GL_IMAGE_TEXEL_SIZE = 0x82A7,
GL_IMAGE_COMPATIBILITY_CLASS = 0x82A8,
GL_IMAGE_PIXEL_FORMAT = 0x82A9,
GL_IMAGE_PIXEL_TYPE = 0x82AA,
GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_TEST = 0x82AC,
GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_TEST = 0x82AD,
GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_WRITE = 0x82AE,
GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_WRITE = 0x82AF,
GL_TEXTURE_COMPRESSED_BLOCK_WIDTH = 0x82B1,
GL_TEXTURE_COMPRESSED_BLOCK_HEIGHT = 0x82B2,
GL_TEXTURE_COMPRESSED_BLOCK_SIZE = 0x82B3,
GL_CLEAR_BUFFER = 0x82B4,
GL_TEXTURE_VIEW = 0x82B5,
GL_VIEW_COMPATIBILITY_CLASS = 0x82B6,
GL_FULL_SUPPORT = 0x82B7,
GL_CAVEAT_SUPPORT = 0x82B8,
GL_IMAGE_CLASS_4_X_32 = 0x82B9,
GL_IMAGE_CLASS_2_X_32 = 0x82BA,
GL_IMAGE_CLASS_1_X_32 = 0x82BB,
GL_IMAGE_CLASS_4_X_16 = 0x82BC,
GL_IMAGE_CLASS_2_X_16 = 0x82BD,
GL_IMAGE_CLASS_1_X_16 = 0x82BE,
GL_IMAGE_CLASS_4_X_8 = 0x82BF,
GL_IMAGE_CLASS_2_X_8 = 0x82C0,
GL_IMAGE_CLASS_1_X_8 = 0x82C1,
GL_IMAGE_CLASS_11_11_10 = 0x82C2,
GL_IMAGE_CLASS_10_10_10_2 = 0x82C3,
GL_VIEW_CLASS_128_BITS = 0x82C4,
GL_VIEW_CLASS_96_BITS = 0x82C5,
GL_VIEW_CLASS_64_BITS = 0x82C6,
GL_VIEW_CLASS_48_BITS = 0x82C7,
GL_VIEW_CLASS_32_BITS = 0x82C8,
GL_VIEW_CLASS_24_BITS = 0x82C9,
GL_VIEW_CLASS_16_BITS = 0x82CA,
GL_VIEW_CLASS_8_BITS = 0x82CB,
GL_VIEW_CLASS_S3TC_DXT1_RGB = 0x82CC,
GL_VIEW_CLASS_S3TC_DXT1_RGBA = 0x82CD,
GL_VIEW_CLASS_S3TC_DXT3_RGBA = 0x82CE,
GL_VIEW_CLASS_S3TC_DXT5_RGBA = 0x82CF,
GL_VIEW_CLASS_RGTC1_RED = 0x82D0,
GL_VIEW_CLASS_RGTC2_RG = 0x82D1,
GL_VIEW_CLASS_BPTC_UNORM = 0x82D2,
GL_VIEW_CLASS_BPTC_FLOAT = 0x82D3,
GL_MIN_MAP_BUFFER_ALIGNMENT = 0x90BC,
//GL_MAP_READ_BIT = 0x0001,
//GL_MAP_WRITE_BIT = 0x0002,
GL_MAP_INVALIDATE_RANGE_BIT = 0x0004,
GL_MAP_INVALIDATE_BUFFER_BIT = 0x0008,
GL_MAP_FLUSH_EXPLICIT_BIT = 0x0010,
GL_MAP_UNSYNCHRONIZED_BIT = 0x0020,
GL_MATRIX_PALETTE_ARB = 0x8840,
GL_MAX_MATRIX_PALETTE_STACK_DEPTH_ARB = 0x8841,
GL_MAX_PALETTE_MATRICES_ARB = 0x8842,
GL_CURRENT_PALETTE_MATRIX_ARB = 0x8843,
GL_MATRIX_INDEX_ARRAY_ARB = 0x8844,
GL_CURRENT_MATRIX_INDEX_ARB = 0x8845,
GL_MATRIX_INDEX_ARRAY_SIZE_ARB = 0x8846,
GL_MATRIX_INDEX_ARRAY_TYPE_ARB = 0x8847,
GL_MATRIX_INDEX_ARRAY_STRIDE_ARB = 0x8848,
GL_MATRIX_INDEX_ARRAY_POINTER_ARB = 0x8849,
GL_ANY_SAMPLES_PASSED = 0x8C2F,
GL_UNIFORM = 0x92E1,
GL_UNIFORM_BLOCK = 0x92E2,
GL_PROGRAM_INPUT = 0x92E3,
GL_PROGRAM_OUTPUT = 0x92E4,
GL_BUFFER_VARIABLE = 0x92E5,
GL_SHADER_STORAGE_BLOCK = 0x92E6,
GL_IS_PER_PATCH = 0x92E7,
GL_VERTEX_SUBROUTINE = 0x92E8,
GL_TESS_CONTROL_SUBROUTINE = 0x92E9,
GL_TESS_EVALUATION_SUBROUTINE = 0x92EA,
GL_GEOMETRY_SUBROUTINE = 0x92EB,
GL_FRAGMENT_SUBROUTINE = 0x92EC,
GL_COMPUTE_SUBROUTINE = 0x92ED,
GL_VERTEX_SUBROUTINE_UNIFORM = 0x92EE,
GL_TESS_CONTROL_SUBROUTINE_UNIFORM = 0x92EF,
GL_TESS_EVALUATION_SUBROUTINE_UNIFORM = 0x92F0,
GL_GEOMETRY_SUBROUTINE_UNIFORM = 0x92F1,
GL_FRAGMENT_SUBROUTINE_UNIFORM = 0x92F2,
GL_COMPUTE_SUBROUTINE_UNIFORM = 0x92F3,
GL_TRANSFORM_FEEDBACK_VARYING = 0x92F4,
GL_ACTIVE_RESOURCES = 0x92F5,
GL_MAX_NAME_LENGTH = 0x92F6,
GL_MAX_NUM_ACTIVE_VARIABLES = 0x92F7,
GL_MAX_NUM_COMPATIBLE_SUBROUTINES = 0x92F8,
GL_NAME_LENGTH = 0x92F9,
GL_TYPE = 0x92FA,
GL_ARRAY_SIZE = 0x92FB,
GL_OFFSET = 0x92FC,
GL_BLOCK_INDEX = 0x92FD,
GL_ARRAY_STRIDE = 0x92FE,
GL_MATRIX_STRIDE = 0x92FF,
GL_IS_ROW_MAJOR = 0x9300,
GL_ATOMIC_COUNTER_BUFFER_INDEX = 0x9301,
GL_BUFFER_BINDING = 0x9302,
GL_BUFFER_DATA_SIZE = 0x9303,
GL_NUM_ACTIVE_VARIABLES = 0x9304,
GL_ACTIVE_VARIABLES = 0x9305,
GL_REFERENCED_BY_VERTEX_SHADER = 0x9306,
GL_REFERENCED_BY_TESS_CONTROL_SHADER = 0x9307,
GL_REFERENCED_BY_TESS_EVALUATION_SHADER = 0x9308,
GL_REFERENCED_BY_GEOMETRY_SHADER = 0x9309,
GL_REFERENCED_BY_FRAGMENT_SHADER = 0x930A,
GL_REFERENCED_BY_COMPUTE_SHADER = 0x930B,
GL_TOP_LEVEL_ARRAY_SIZE = 0x930C,
GL_TOP_LEVEL_ARRAY_STRIDE = 0x930D,
GL_LOCATION = 0x930E,
GL_LOCATION_INDEX = 0x930F,
GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION = 0x8E4C,
GL_FIRST_VERTEX_CONVENTION = 0x8E4D,
GL_LAST_VERTEX_CONVENTION = 0x8E4E,
GL_PROVOKING_VERTEX = 0x8E4F,
GL_QUERY_BUFFER_BARRIER_BIT = 0x00008000,
GL_QUERY_BUFFER = 0x9192,
GL_QUERY_BUFFER_BINDING = 0x9193,
GL_QUERY_RESULT_NO_WAIT = 0x9194,
GL_CONTEXT_FLAG_ROBUST_ACCESS_BIT_ARB = 0x00000004,
GL_LOSE_CONTEXT_ON_RESET_ARB = 0x8252,
GL_GUILTY_CONTEXT_RESET_ARB = 0x8253,
GL_INNOCENT_CONTEXT_RESET_ARB = 0x8254,
GL_UNKNOWN_CONTEXT_RESET_ARB = 0x8255,
GL_RESET_NOTIFICATION_STRATEGY_ARB = 0x8256,
GL_NO_RESET_NOTIFICATION_ARB = 0x8261,
GL_SAMPLER_BINDING = 0x8919,
GL_TEXTURE_CUBE_MAP_SEAMLESS = 0x884F,
//GL_TEXTURE_CUBE_MAP_SEAMLESS = 0x884F,
GL_VERTEX_SHADER_BIT = 0x00000001,
GL_FRAGMENT_SHADER_BIT = 0x00000002,
GL_GEOMETRY_SHADER_BIT = 0x00000004,
GL_TESS_CONTROL_SHADER_BIT = 0x00000008,
GL_TESS_EVALUATION_SHADER_BIT = 0x00000010,
GL_PROGRAM_SEPARABLE = 0x8258,
GL_ACTIVE_PROGRAM = 0x8259,
GL_PROGRAM_PIPELINE_BINDING = 0x825A,
GL_ALL_SHADER_BITS = 0xFFFFFFFF,
GL_ATOMIC_COUNTER_BUFFER = 0x92C0,
GL_ATOMIC_COUNTER_BUFFER_BINDING = 0x92C1,
GL_ATOMIC_COUNTER_BUFFER_START = 0x92C2,
GL_ATOMIC_COUNTER_BUFFER_SIZE = 0x92C3,
GL_ATOMIC_COUNTER_BUFFER_DATA_SIZE = 0x92C4,
GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTERS = 0x92C5,
GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTER_INDICES = 0x92C6,
GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_VERTEX_SHADER = 0x92C7,
GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_CONTROL_SHADER = 0x92C8,
GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_EVALUATION_SHADER = 0x92C9,
GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_GEOMETRY_SHADER = 0x92CA,
GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_FRAGMENT_SHADER = 0x92CB,
GL_MAX_VERTEX_ATOMIC_COUNTER_BUFFERS = 0x92CC,
GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS = 0x92CD,
GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS = 0x92CE,
GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS = 0x92CF,
GL_MAX_FRAGMENT_ATOMIC_COUNTER_BUFFERS = 0x92D0,
GL_MAX_COMBINED_ATOMIC_COUNTER_BUFFERS = 0x92D1,
GL_MAX_VERTEX_ATOMIC_COUNTERS = 0x92D2,
GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS = 0x92D3,
GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS = 0x92D4,
GL_MAX_GEOMETRY_ATOMIC_COUNTERS = 0x92D5,
GL_MAX_FRAGMENT_ATOMIC_COUNTERS = 0x92D6,
GL_MAX_COMBINED_ATOMIC_COUNTERS = 0x92D7,
GL_MAX_ATOMIC_COUNTER_BUFFER_SIZE = 0x92D8,
GL_ACTIVE_ATOMIC_COUNTER_BUFFERS = 0x92D9,
GL_UNIFORM_ATOMIC_COUNTER_BUFFER_INDEX = 0x92DA,
GL_UNSIGNED_INT_ATOMIC_COUNTER = 0x92DB,
GL_MAX_ATOMIC_COUNTER_BUFFER_BINDINGS = 0x92DC,
GL_VERTEX_ATTRIB_ARRAY_BARRIER_BIT = 0x00000001,
GL_ELEMENT_ARRAY_BARRIER_BIT = 0x00000002,
GL_UNIFORM_BARRIER_BIT = 0x00000004,
GL_TEXTURE_FETCH_BARRIER_BIT = 0x00000008,
GL_SHADER_IMAGE_ACCESS_BARRIER_BIT = 0x00000020,
GL_COMMAND_BARRIER_BIT = 0x00000040,
GL_PIXEL_BUFFER_BARRIER_BIT = 0x00000080,
GL_TEXTURE_UPDATE_BARRIER_BIT = 0x00000100,
GL_BUFFER_UPDATE_BARRIER_BIT = 0x00000200,
GL_FRAMEBUFFER_BARRIER_BIT = 0x00000400,
GL_TRANSFORM_FEEDBACK_BARRIER_BIT = 0x00000800,
GL_ATOMIC_COUNTER_BARRIER_BIT = 0x00001000,
GL_MAX_IMAGE_UNITS = 0x8F38,
GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS = 0x8F39,
GL_IMAGE_BINDING_NAME = 0x8F3A,
GL_IMAGE_BINDING_LEVEL = 0x8F3B,
GL_IMAGE_BINDING_LAYERED = 0x8F3C,
GL_IMAGE_BINDING_LAYER = 0x8F3D,
GL_IMAGE_BINDING_ACCESS = 0x8F3E,
GL_IMAGE_1D = 0x904C,
GL_IMAGE_2D = 0x904D,
GL_IMAGE_3D = 0x904E,
GL_IMAGE_2D_RECT = 0x904F,
GL_IMAGE_CUBE = 0x9050,
GL_IMAGE_BUFFER = 0x9051,
GL_IMAGE_1D_ARRAY = 0x9052,
GL_IMAGE_2D_ARRAY = 0x9053,
GL_IMAGE_CUBE_MAP_ARRAY = 0x9054,
GL_IMAGE_2D_MULTISAMPLE = 0x9055,
GL_IMAGE_2D_MULTISAMPLE_ARRAY = 0x9056,
GL_INT_IMAGE_1D = 0x9057,
GL_INT_IMAGE_2D = 0x9058,
GL_INT_IMAGE_3D = 0x9059,
GL_INT_IMAGE_2D_RECT = 0x905A,
GL_INT_IMAGE_CUBE = 0x905B,
GL_INT_IMAGE_BUFFER = 0x905C,
GL_INT_IMAGE_1D_ARRAY = 0x905D,
GL_INT_IMAGE_2D_ARRAY = 0x905E,
GL_INT_IMAGE_CUBE_MAP_ARRAY = 0x905F,
GL_INT_IMAGE_2D_MULTISAMPLE = 0x9060,
GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY = 0x9061,
GL_UNSIGNED_INT_IMAGE_1D = 0x9062,
GL_UNSIGNED_INT_IMAGE_2D = 0x9063,
GL_UNSIGNED_INT_IMAGE_3D = 0x9064,
GL_UNSIGNED_INT_IMAGE_2D_RECT = 0x9065,
GL_UNSIGNED_INT_IMAGE_CUBE = 0x9066,
GL_UNSIGNED_INT_IMAGE_BUFFER = 0x9067,
GL_UNSIGNED_INT_IMAGE_1D_ARRAY = 0x9068,
GL_UNSIGNED_INT_IMAGE_2D_ARRAY = 0x9069,
GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY = 0x906A,
GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE = 0x906B,
GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY = 0x906C,
GL_MAX_IMAGE_SAMPLES = 0x906D,
GL_IMAGE_BINDING_FORMAT = 0x906E,
GL_IMAGE_FORMAT_COMPATIBILITY_TYPE = 0x90C7,
GL_IMAGE_FORMAT_COMPATIBILITY_BY_SIZE = 0x90C8,
GL_IMAGE_FORMAT_COMPATIBILITY_BY_CLASS = 0x90C9,
GL_MAX_VERTEX_IMAGE_UNIFORMS = 0x90CA,
GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS = 0x90CB,
GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS = 0x90CC,
GL_MAX_GEOMETRY_IMAGE_UNIFORMS = 0x90CD,
GL_MAX_FRAGMENT_IMAGE_UNIFORMS = 0x90CE,
GL_MAX_COMBINED_IMAGE_UNIFORMS = 0x90CF,
GL_ALL_BARRIER_BITS = 0xFFFFFFFF,
GL_PROGRAM_OBJECT_ARB = 0x8B40,
GL_SHADER_OBJECT_ARB = 0x8B48,
GL_OBJECT_SUBTYPE_ARB = 0x8B4F,
GL_OBJECT_DELETE_STATUS_ARB = 0x8B80,
GL_OBJECT_COMPILE_STATUS_ARB = 0x8B81,
GL_OBJECT_LINK_STATUS_ARB = 0x8B82,
GL_OBJECT_VALIDATE_STATUS_ARB = 0x8B83,
GL_OBJECT_INFO_LOG_LENGTH_ARB = 0x8B84,
GL_OBJECT_ATTACHED_OBJECTS_ARB = 0x8B85,
GL_OBJECT_ACTIVE_UNIFORMS_ARB = 0x8B86,
GL_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH_ARB = 0x8B87,
GL_OBJECT_SHADER_SOURCE_LENGTH_ARB = 0x8B88,
GL_SHADER_STORAGE_BARRIER_BIT = 0x2000,
GL_MAX_COMBINED_SHADER_OUTPUT_RESOURCES = 0x8F39,
GL_SHADER_STORAGE_BUFFER = 0x90D2,
GL_SHADER_STORAGE_BUFFER_BINDING = 0x90D3,
GL_SHADER_STORAGE_BUFFER_START = 0x90D4,
GL_SHADER_STORAGE_BUFFER_SIZE = 0x90D5,
GL_MAX_VERTEX_SHADER_STORAGE_BLOCKS = 0x90D6,
GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS = 0x90D7,
GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS = 0x90D8,
GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS = 0x90D9,
GL_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS = 0x90DA,
GL_MAX_COMPUTE_SHADER_STORAGE_BLOCKS = 0x90DB,
GL_MAX_COMBINED_SHADER_STORAGE_BLOCKS = 0x90DC,
GL_MAX_SHADER_STORAGE_BUFFER_BINDINGS = 0x90DD,
GL_MAX_SHADER_STORAGE_BLOCK_SIZE = 0x90DE,
GL_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT = 0x90DF,
GL_ACTIVE_SUBROUTINES = 0x8DE5,
GL_ACTIVE_SUBROUTINE_UNIFORMS = 0x8DE6,
GL_MAX_SUBROUTINES = 0x8DE7,
GL_MAX_SUBROUTINE_UNIFORM_LOCATIONS = 0x8DE8,
GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS = 0x8E47,
GL_ACTIVE_SUBROUTINE_MAX_LENGTH = 0x8E48,
GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH = 0x8E49,
GL_NUM_COMPATIBLE_SUBROUTINES = 0x8E4A,
GL_COMPATIBLE_SUBROUTINES = 0x8E4B,
GL_SHADER_INCLUDE_ARB = 0x8DAE,
GL_NAMED_STRING_LENGTH_ARB = 0x8DE9,
GL_NAMED_STRING_TYPE_ARB = 0x8DEA,
GL_TEXTURE_COMPARE_FAIL_VALUE_ARB = 0x80BF,
GL_VIRTUAL_PAGE_SIZE_X_ARB = 0x9195,
GL_VIRTUAL_PAGE_SIZE_Y_ARB = 0x9196,
GL_VIRTUAL_PAGE_SIZE_Z_ARB = 0x9197,
GL_MAX_SPARSE_TEXTURE_SIZE_ARB = 0x9198,
GL_MAX_SPARSE_3D_TEXTURE_SIZE_ARB = 0x9199,
GL_TEXTURE_SPARSE_ARB = 0x91A6,
GL_VIRTUAL_PAGE_SIZE_INDEX_ARB = 0x91A7,
GL_NUM_VIRTUAL_PAGE_SIZES_ARB = 0x91A8,
GL_SPARSE_TEXTURE_FULL_ARRAY_CUBE_MIPMAPS_ARB = 0x91A9,
GL_NUM_SPARSE_LEVELS_ARB = 0x91AA,
GL_DEPTH_STENCIL_TEXTURE_MODE = 0x90EA,
GL_SYNC_FLUSH_COMMANDS_BIT = 0x00000001,
GL_MAX_SERVER_WAIT_TIMEOUT = 0x9111,
GL_OBJECT_TYPE = 0x9112,
GL_SYNC_CONDITION = 0x9113,
GL_SYNC_STATUS = 0x9114,
GL_SYNC_FLAGS = 0x9115,
GL_SYNC_FENCE = 0x9116,
GL_SYNC_GPU_COMMANDS_COMPLETE = 0x9117,
GL_UNSIGNALED = 0x9118,
GL_SIGNALED = 0x9119,
GL_ALREADY_SIGNALED = 0x911A,
GL_TIMEOUT_EXPIRED = 0x911B,
GL_CONDITION_SATISFIED = 0x911C,
GL_WAIT_FAILED = 0x911D,
GL_TIMEOUT_IGNORED = 0xFFFFFFFFFFFFFFFF,
GL_PATCHES = 0xE,
GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_CONTROL_SHADER = 0x84F0,
GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_EVALUATION_SHADER = 0x84F1,
GL_MAX_TESS_CONTROL_INPUT_COMPONENTS = 0x886C,
GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS = 0x886D,
GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS = 0x8E1E,
GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS = 0x8E1F,
GL_PATCH_VERTICES = 0x8E72,
GL_PATCH_DEFAULT_INNER_LEVEL = 0x8E73,
GL_PATCH_DEFAULT_OUTER_LEVEL = 0x8E74,
GL_TESS_CONTROL_OUTPUT_VERTICES = 0x8E75,
GL_TESS_GEN_MODE = 0x8E76,
GL_TESS_GEN_SPACING = 0x8E77,
GL_TESS_GEN_VERTEX_ORDER = 0x8E78,
GL_TESS_GEN_POINT_MODE = 0x8E79,
GL_ISOLINES = 0x8E7A,
GL_FRACTIONAL_ODD = 0x8E7B,
GL_FRACTIONAL_EVEN = 0x8E7C,
GL_MAX_PATCH_VERTICES = 0x8E7D,
GL_MAX_TESS_GEN_LEVEL = 0x8E7E,
GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS = 0x8E7F,
GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS = 0x8E80,
GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS = 0x8E81,
GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS = 0x8E82,
GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS = 0x8E83,
GL_MAX_TESS_PATCH_COMPONENTS = 0x8E84,
GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS = 0x8E85,
GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS = 0x8E86,
GL_TESS_EVALUATION_SHADER = 0x8E87,
GL_TESS_CONTROL_SHADER = 0x8E88,
GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS = 0x8E89,
GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS = 0x8E8A,
GL_TEXTURE_BUFFER_OFFSET = 0x919D,
GL_TEXTURE_BUFFER_SIZE = 0x919E,
GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT = 0x919F,
GL_COMPRESSED_RED_RGTC1 = 0x8DBB,
GL_COMPRESSED_SIGNED_RED_RGTC1 = 0x8DBC,
GL_COMPRESSED_RG_RGTC2 = 0x8DBD,
GL_COMPRESSED_SIGNED_RG_RGTC2 = 0x8DBE,
GL_ALPHA32F_ARB = 0x8816,
GL_INTENSITY32F_ARB = 0x8817,
GL_LUMINANCE32F_ARB = 0x8818,
GL_LUMINANCE_ALPHA32F_ARB = 0x8819,
GL_ALPHA16F_ARB = 0x881C,
GL_INTENSITY16F_ARB = 0x881D,
GL_LUMINANCE16F_ARB = 0x881E,
GL_LUMINANCE_ALPHA16F_ARB = 0x881F,
GL_MIRROR_CLAMP_TO_EDGE = 0x8743,
GL_SAMPLE_POSITION = 0x8E50,
GL_SAMPLE_MASK = 0x8E51,
GL_SAMPLE_MASK_VALUE = 0x8E52,
GL_MAX_SAMPLE_MASK_WORDS = 0x8E59,
GL_TEXTURE_2D_MULTISAMPLE = 0x9100,
GL_PROXY_TEXTURE_2D_MULTISAMPLE = 0x9101,
GL_TEXTURE_2D_MULTISAMPLE_ARRAY = 0x9102,
GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY = 0x9103,
GL_TEXTURE_BINDING_2D_MULTISAMPLE = 0x9104,
GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY = 0x9105,
GL_TEXTURE_SAMPLES = 0x9106,
GL_TEXTURE_FIXED_SAMPLE_LOCATIONS = 0x9107,
GL_SAMPLER_2D_MULTISAMPLE = 0x9108,
GL_INT_SAMPLER_2D_MULTISAMPLE = 0x9109,
GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE = 0x910A,
GL_SAMPLER_2D_MULTISAMPLE_ARRAY = 0x910B,
GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY = 0x910C,
GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY = 0x910D,
GL_MAX_COLOR_TEXTURE_SAMPLES = 0x910E,
GL_MAX_DEPTH_TEXTURE_SAMPLES = 0x910F,
GL_MAX_INTEGER_SAMPLES = 0x9110,
//GL_COMPRESSED_RED = 0x8225,
//GL_COMPRESSED_RG = 0x8226,
GL_RG = 0x8227,
GL_RG_INTEGER = 0x8228,
GL_R8 = 0x8229,
GL_R16 = 0x822A,
GL_RG8 = 0x822B,
GL_RG16 = 0x822C,
GL_R16F = 0x822D,
GL_R32F = 0x822E,
GL_RG16F = 0x822F,
GL_RG32F = 0x8230,
GL_R8I = 0x8231,
GL_R8UI = 0x8232,
GL_R16I = 0x8233,
GL_R16UI = 0x8234,
GL_R32I = 0x8235,
GL_R32UI = 0x8236,
GL_RG8I = 0x8237,
//GL_RG8UI = 0x8238,
GL_RG16I = 0x8239,
//GL_RG16UI = 0x823A,
GL_RG32I = 0x823B,
GL_RG32UI = 0x823C,
//GL_RGB10_A2UI = 0x906F,
//GL_STENCIL_INDEX = 0x1901,
//GL_STENCIL_INDEX8 = 0x8D48,
GL_TEXTURE_IMMUTABLE_FORMAT = 0x912F,
//GL_TEXTURE_SWIZZLE_R = 0x8E42,
//GL_TEXTURE_SWIZZLE_G = 0x8E43,
//GL_TEXTURE_SWIZZLE_B = 0x8E44,
//GL_TEXTURE_SWIZZLE_A = 0x8E45,
//GL_TEXTURE_SWIZZLE_RGBA = 0x8E46,
GL_TEXTURE_VIEW_MIN_LEVEL = 0x82DB,
GL_TEXTURE_VIEW_NUM_LEVELS = 0x82DC,
GL_TEXTURE_VIEW_MIN_LAYER = 0x82DD,
GL_TEXTURE_VIEW_NUM_LAYERS = 0x82DE,
//GL_TEXTURE_IMMUTABLE_LEVELS = 0x82DF,
GL_TIME_ELAPSED = 0x88BF,
GL_TIMESTAMP = 0x8E28,
GL_TRANSFORM_FEEDBACK = 0x8E22,
GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED = 0x8E23,
GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE = 0x8E24,
GL_TRANSFORM_FEEDBACK_BINDING = 0x8E25,
GL_MAX_TRANSFORM_FEEDBACK_BUFFERS = 0x8E70,
//GL_MAX_VERTEX_STREAMS = 0x8E71,
GL_UNIFORM_BUFFER = 0x8A11,
GL_UNIFORM_BUFFER_BINDING = 0x8A28,
GL_UNIFORM_BUFFER_START = 0x8A29,
GL_UNIFORM_BUFFER_SIZE = 0x8A2A,
GL_MAX_VERTEX_UNIFORM_BLOCKS = 0x8A2B,
GL_MAX_GEOMETRY_UNIFORM_BLOCKS = 0x8A2C,
GL_MAX_FRAGMENT_UNIFORM_BLOCKS = 0x8A2D,
GL_MAX_COMBINED_UNIFORM_BLOCKS = 0x8A2E,
GL_MAX_UNIFORM_BUFFER_BINDINGS = 0x8A2F,
GL_MAX_UNIFORM_BLOCK_SIZE = 0x8A30,
GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS = 0x8A31,
GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS = 0x8A32,
GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS = 0x8A33,
GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT = 0x8A34,
GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH = 0x8A35,
GL_ACTIVE_UNIFORM_BLOCKS = 0x8A36,
GL_UNIFORM_TYPE = 0x8A37,
GL_UNIFORM_SIZE = 0x8A38,
GL_UNIFORM_NAME_LENGTH = 0x8A39,
GL_UNIFORM_BLOCK_INDEX = 0x8A3A,
GL_UNIFORM_OFFSET = 0x8A3B,
GL_UNIFORM_ARRAY_STRIDE = 0x8A3C,
GL_UNIFORM_MATRIX_STRIDE = 0x8A3D,
GL_UNIFORM_IS_ROW_MAJOR = 0x8A3E,
GL_UNIFORM_BLOCK_BINDING = 0x8A3F,
GL_UNIFORM_BLOCK_DATA_SIZE = 0x8A40,
GL_UNIFORM_BLOCK_NAME_LENGTH = 0x8A41,
GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS = 0x8A42,
GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES = 0x8A43,
GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER = 0x8A44,
GL_UNIFORM_BLOCK_REFERENCED_BY_GEOMETRY_SHADER = 0x8A45,
GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER = 0x8A46,
GL_INVALID_INDEX = 0xFFFFFFFF,
//GL_BGRA = 0x80E1,
GL_VERTEX_ARRAY_BINDING = 0x85B5,
GL_VERTEX_ATTRIB_BINDING = 0x82D4,
GL_VERTEX_ATTRIB_RELATIVE_OFFSET = 0x82D5,
GL_VERTEX_BINDING_DIVISOR = 0x82D6,
GL_VERTEX_BINDING_OFFSET = 0x82D7,
GL_VERTEX_BINDING_STRIDE = 0x82D8,
GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET = 0x82D9,
GL_MAX_VERTEX_ATTRIB_BINDINGS = 0x82DA,
GL_MODELVIEW0_ARB = 0x1700,
GL_MODELVIEW1_ARB = 0x850A,
GL_MAX_VERTEX_UNITS_ARB = 0x86A4,
GL_ACTIVE_VERTEX_UNITS_ARB = 0x86A5,
GL_WEIGHT_SUM_UNITY_ARB = 0x86A6,
GL_VERTEX_BLEND_ARB = 0x86A7,
GL_CURRENT_WEIGHT_ARB = 0x86A8,
GL_WEIGHT_ARRAY_TYPE_ARB = 0x86A9,
GL_WEIGHT_ARRAY_STRIDE_ARB = 0x86AA,
GL_WEIGHT_ARRAY_SIZE_ARB = 0x86AB,
GL_WEIGHT_ARRAY_POINTER_ARB = 0x86AC,
GL_WEIGHT_ARRAY_ARB = 0x86AD,
GL_MODELVIEW2_ARB = 0x8722,
GL_MODELVIEW3_ARB = 0x8723,
GL_MODELVIEW4_ARB = 0x8724,
GL_MODELVIEW5_ARB = 0x8725,
GL_MODELVIEW6_ARB = 0x8726,
GL_MODELVIEW7_ARB = 0x8727,
GL_MODELVIEW8_ARB = 0x8728,
GL_MODELVIEW9_ARB = 0x8729,
GL_MODELVIEW10_ARB = 0x872A,
GL_MODELVIEW11_ARB = 0x872B,
GL_MODELVIEW12_ARB = 0x872C,
GL_MODELVIEW13_ARB = 0x872D,
GL_MODELVIEW14_ARB = 0x872E,
GL_MODELVIEW15_ARB = 0x872F,
GL_MODELVIEW16_ARB = 0x8730,
GL_MODELVIEW17_ARB = 0x8731,
GL_MODELVIEW18_ARB = 0x8732,
GL_MODELVIEW19_ARB = 0x8733,
GL_MODELVIEW20_ARB = 0x8734,
GL_MODELVIEW21_ARB = 0x8735,
GL_MODELVIEW22_ARB = 0x8736,
GL_MODELVIEW23_ARB = 0x8737,
GL_MODELVIEW24_ARB = 0x8738,
GL_MODELVIEW25_ARB = 0x8739,
GL_MODELVIEW26_ARB = 0x873A,
GL_MODELVIEW27_ARB = 0x873B,
GL_MODELVIEW28_ARB = 0x873C,
GL_MODELVIEW29_ARB = 0x873D,
GL_MODELVIEW30_ARB = 0x873E,
GL_MODELVIEW31_ARB = 0x873F,
GL_VERTEX_PROGRAM_ARB = 0x8620,
GL_PROGRAM_LENGTH_ARB = 0x8627,
GL_PROGRAM_STRING_ARB = 0x8628,
GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB = 0x862E,
GL_MAX_PROGRAM_MATRICES_ARB = 0x862F,
GL_CURRENT_MATRIX_STACK_DEPTH_ARB = 0x8640,
GL_CURRENT_MATRIX_ARB = 0x8641,
GL_PROGRAM_ERROR_POSITION_ARB = 0x864B,
GL_PROGRAM_BINDING_ARB = 0x8677,
GL_PROGRAM_ERROR_STRING_ARB = 0x8874,
GL_PROGRAM_FORMAT_ASCII_ARB = 0x8875,
GL_PROGRAM_FORMAT_ARB = 0x8876,
GL_PROGRAM_INSTRUCTIONS_ARB = 0x88A0,
GL_MAX_PROGRAM_INSTRUCTIONS_ARB = 0x88A1,
GL_PROGRAM_NATIVE_INSTRUCTIONS_ARB = 0x88A2,
GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB = 0x88A3,
GL_PROGRAM_TEMPORARIES_ARB = 0x88A4,
GL_MAX_PROGRAM_TEMPORARIES_ARB = 0x88A5,
GL_PROGRAM_NATIVE_TEMPORARIES_ARB = 0x88A6,
GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB = 0x88A7,
GL_PROGRAM_PARAMETERS_ARB = 0x88A8,
GL_MAX_PROGRAM_PARAMETERS_ARB = 0x88A9,
GL_PROGRAM_NATIVE_PARAMETERS_ARB = 0x88AA,
GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB = 0x88AB,
GL_PROGRAM_ATTRIBS_ARB = 0x88AC,
GL_MAX_PROGRAM_ATTRIBS_ARB = 0x88AD,
GL_PROGRAM_NATIVE_ATTRIBS_ARB = 0x88AE,
GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB = 0x88AF,
GL_PROGRAM_ADDRESS_REGISTERS_ARB = 0x88B0,
GL_MAX_PROGRAM_ADDRESS_REGISTERS_ARB = 0x88B1,
GL_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB = 0x88B2,
GL_MAX_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB = 0x88B3,
GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB = 0x88B4,
GL_MAX_PROGRAM_ENV_PARAMETERS_ARB = 0x88B5,
GL_PROGRAM_UNDER_NATIVE_LIMITS_ARB = 0x88B6,
GL_TRANSPOSE_CURRENT_MATRIX_ARB = 0x88B7,
GL_MATRIX0_ARB = 0x88C0,
GL_MATRIX1_ARB = 0x88C1,
GL_MATRIX2_ARB = 0x88C2,
GL_MATRIX3_ARB = 0x88C3,
GL_MATRIX4_ARB = 0x88C4,
GL_MATRIX5_ARB = 0x88C5,
GL_MATRIX6_ARB = 0x88C6,
GL_MATRIX7_ARB = 0x88C7,
GL_MATRIX8_ARB = 0x88C8,
GL_MATRIX9_ARB = 0x88C9,
GL_MATRIX10_ARB = 0x88CA,
GL_MATRIX11_ARB = 0x88CB,
GL_MATRIX12_ARB = 0x88CC,
GL_MATRIX13_ARB = 0x88CD,
GL_MATRIX14_ARB = 0x88CE,
GL_MATRIX15_ARB = 0x88CF,
GL_MATRIX16_ARB = 0x88D0,
GL_MATRIX17_ARB = 0x88D1,
GL_MATRIX18_ARB = 0x88D2,
GL_MATRIX19_ARB = 0x88D3,
GL_MATRIX20_ARB = 0x88D4,
GL_MATRIX21_ARB = 0x88D5,
GL_MATRIX22_ARB = 0x88D6,
GL_MATRIX23_ARB = 0x88D7,
GL_MATRIX24_ARB = 0x88D8,
GL_MATRIX25_ARB = 0x88D9,
GL_MATRIX26_ARB = 0x88DA,
GL_MATRIX27_ARB = 0x88DB,
GL_MATRIX28_ARB = 0x88DC,
GL_MATRIX29_ARB = 0x88DD,
GL_MATRIX30_ARB = 0x88DE,
GL_MATRIX31_ARB = 0x88DF,
GL_OBJECT_ACTIVE_ATTRIBUTES_ARB = 0x8B89,
GL_OBJECT_ACTIVE_ATTRIBUTE_MAX_LENGTH_ARB = 0x8B8A,
//GL_UNSIGNED_INT_10F_11F_11F_REV = 0x8C3B,
//GL_UNSIGNED_INT_2_10_10_10_REV = 0x8368,
GL_INT_2_10_10_10_REV = 0x8D9F,
//GL_DEPTH_RANGE = 0x0B70,
//GL_VIEWPORT = 0x0BA2,
//GL_SCISSOR_BOX = 0x0C10,
//GL_SCISSOR_TEST = 0x0C11,
GL_MAX_VIEWPORTS = 0x825B,
GL_VIEWPORT_SUBPIXEL_BITS = 0x825C,
GL_VIEWPORT_BOUNDS_RANGE = 0x825D,
GL_LAYER_PROVOKING_VERTEX = 0x825E,
GL_VIEWPORT_INDEX_PROVOKING_VERTEX = 0x825F,
GL_UNDEFINED_VERTEX = 0x8260,
//GL_FIRST_VERTEX_CONVENTION = 0x8E4D,
//GL_LAST_VERTEX_CONVENTION = 0x8E4E,
//GL_PROVOKING_VERTEX = 0x8E4F,
GL_PROGRAM_MATRIX_EXT = 0x8E2D,
GL_TRANSPOSE_PROGRAM_MATRIX_EXT = 0x8E2E,
GL_PROGRAM_MATRIX_STACK_DEPTH_EXT = 0x8E2F,
GL_CONTEXT_FLAG_DEBUG_BIT = 0x00000002,
//GL_STACK_OVERFLOW = 0x0503,
//GL_STACK_UNDERFLOW = 0x0504,
GL_DEBUG_OUTPUT_SYNCHRONOUS = 0x8242,
GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH = 0x8243,
GL_DEBUG_CALLBACK_FUNCTION = 0x8244,
GL_DEBUG_CALLBACK_USER_PARAM = 0x8245,
GL_DEBUG_SOURCE_API = 0x8246,
GL_DEBUG_SOURCE_WINDOW_SYSTEM = 0x8247,
GL_DEBUG_SOURCE_SHADER_COMPILER = 0x8248,
GL_DEBUG_SOURCE_THIRD_PARTY = 0x8249,
GL_DEBUG_SOURCE_APPLICATION = 0x824A,
GL_DEBUG_SOURCE_OTHER = 0x824B,
GL_DEBUG_TYPE_ERROR = 0x824C,
GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR = 0x824D,
GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR = 0x824E,
GL_DEBUG_TYPE_PORTABILITY = 0x824F,
GL_DEBUG_TYPE_PERFORMANCE = 0x8250,
GL_DEBUG_TYPE_OTHER = 0x8251,
GL_DEBUG_TYPE_MARKER = 0x8268,
GL_DEBUG_TYPE_PUSH_GROUP = 0x8269,
GL_DEBUG_TYPE_POP_GROUP = 0x826A,
GL_DEBUG_SEVERITY_NOTIFICATION = 0x826B,
GL_MAX_DEBUG_GROUP_STACK_DEPTH = 0x826C,
GL_DEBUG_GROUP_STACK_DEPTH = 0x826D,
GL_BUFFER = 0x82E0,
GL_SHADER = 0x82E1,
GL_PROGRAM = 0x82E2,
GL_QUERY = 0x82E3,
GL_PROGRAM_PIPELINE = 0x82E4,
GL_SAMPLER = 0x82E6,
GL_DISPLAY_LIST = 0x82E7,
GL_MAX_LABEL_LENGTH = 0x82E8,
GL_MAX_DEBUG_MESSAGE_LENGTH = 0x9143,
GL_MAX_DEBUG_LOGGED_MESSAGES = 0x9144,
GL_DEBUG_LOGGED_MESSAGES = 0x9145,
GL_DEBUG_SEVERITY_HIGH = 0x9146,
GL_DEBUG_SEVERITY_MEDIUM = 0x9147,
GL_DEBUG_SEVERITY_LOW = 0x9148,
GL_DEBUG_OUTPUT = 0x92E0,
GL_COMPRESSED_RGBA_ASTC_4x4_KHR = 0x93B0,
GL_COMPRESSED_RGBA_ASTC_5x4_KHR = 0x93B1,
GL_COMPRESSED_RGBA_ASTC_5x5_KHR = 0x93B2,
GL_COMPRESSED_RGBA_ASTC_6x5_KHR = 0x93B3,
GL_COMPRESSED_RGBA_ASTC_6x6_KHR = 0x93B4,
GL_COMPRESSED_RGBA_ASTC_8x5_KHR = 0x93B5,
GL_COMPRESSED_RGBA_ASTC_8x6_KHR = 0x93B6,
GL_COMPRESSED_RGBA_ASTC_8x8_KHR = 0x93B7,
GL_COMPRESSED_RGBA_ASTC_10x5_KHR = 0x93B8,
GL_COMPRESSED_RGBA_ASTC_10x6_KHR = 0x93B9,
GL_COMPRESSED_RGBA_ASTC_10x8_KHR = 0x93BA,
GL_COMPRESSED_RGBA_ASTC_10x10_KHR = 0x93BB,
GL_COMPRESSED_RGBA_ASTC_12x10_KHR = 0x93BC,
GL_COMPRESSED_RGBA_ASTC_12x12_KHR = 0x93BD,
GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR = 0x93D0,
GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR = 0x93D1,
GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR = 0x93D2,
GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR = 0x93D3,
GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR = 0x93D4,
GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR = 0x93D5,
GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR = 0x93D6,
GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR = 0x93D7,
GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR = 0x93D8,
GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR = 0x93D9,
GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR = 0x93DA,
GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR = 0x93DB,
GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR = 0x93DC,
GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR = 0x93DD,
GL_GPU_MEMORY_INFO_DEDICATED_VIDMEM_NVX = 0x9047,
GL_GPU_MEMORY_INFO_TOTAL_AVAILABLE_MEMORY_NVX = 0x9048,
GL_GPU_MEMORY_INFO_CURRENT_AVAILABLE_VIDMEM_NVX = 0x9049,
GL_GPU_MEMORY_INFO_EVICTION_COUNT_NVX = 0x904A,
GL_GPU_MEMORY_INFO_EVICTED_MEMORY_NVX = 0x904B,
GL_BLEND_PREMULTIPLIED_SRC_NV = 0x9280,
GL_BLEND_OVERLAP_NV = 0x9281,
GL_UNCORRELATED_NV = 0x9282,
GL_DISJOINT_NV = 0x9283,
GL_CONJOINT_NV = 0x9284,
GL_BLEND_ADVANCED_COHERENT_NV = 0x9285,
GL_SRC_NV = 0x9286,
GL_DST_NV = 0x9287,
GL_SRC_OVER_NV = 0x9288,
GL_DST_OVER_NV = 0x9289,
GL_SRC_IN_NV = 0x928A,
GL_DST_IN_NV = 0x928B,
GL_SRC_OUT_NV = 0x928C,
GL_DST_OUT_NV = 0x928D,
GL_SRC_ATOP_NV = 0x928E,
GL_DST_ATOP_NV = 0x928F,
GL_PLUS_NV = 0x9291,
GL_PLUS_DARKER_NV = 0x9292,
GL_MULTIPLY_NV = 0x9294,
GL_SCREEN_NV = 0x9295,
GL_OVERLAY_NV = 0x9296,
GL_DARKEN_NV = 0x9297,
GL_LIGHTEN_NV = 0x9298,
GL_COLORDODGE_NV = 0x9299,
GL_COLORBURN_NV = 0x929A,
GL_HARDLIGHT_NV = 0x929B,
GL_SOFTLIGHT_NV = 0x929C,
GL_DIFFERENCE_NV = 0x929E,
GL_MINUS_NV = 0x929F,
GL_EXCLUSION_NV = 0x92A0,
GL_CONTRAST_NV = 0x92A1,
GL_INVERT_RGB_NV = 0x92A3,
GL_LINEARDODGE_NV = 0x92A4,
GL_LINEARBURN_NV = 0x92A5,
GL_VIVIDLIGHT_NV = 0x92A6,
GL_LINEARLIGHT_NV = 0x92A7,
GL_PINLIGHT_NV = 0x92A8,
GL_HARDMIX_NV = 0x92A9,
GL_HSL_HUE_NV = 0x92AD,
GL_HSL_SATURATION_NV = 0x92AE,
GL_HSL_COLOR_NV = 0x92AF,
GL_HSL_LUMINOSITY_NV = 0x92B0,
GL_PLUS_CLAMPED_NV = 0x92B1,
GL_PLUS_CLAMPED_ALPHA_NV = 0x92B2,
GL_MINUS_CLAMPED_NV = 0x92B3,
GL_INVERT_OVG_NV = 0x92B4,
GL_COMPUTE_PROGRAM_NV = 0x90FB,
GL_COMPUTE_PROGRAM_PARAMETER_BUFFER_NV = 0x90FC,
GL_DEPTH_STENCIL_TO_RGBA_NV = 0x886E,
GL_DEPTH_STENCIL_TO_BGRA_NV = 0x886F,
GL_MAX_DEEP_3D_TEXTURE_WIDTH_HEIGHT_NV = 0x90D0,
GL_MAX_DEEP_3D_TEXTURE_DEPTH_NV = 0x90D1,
GL_DEPTH_BUFFER_FLOAT_MODE_NV = 0x8DAF,
GL_SAMPLE_COUNT_BITS_NV = 0x8864,
GL_CURRENT_SAMPLE_COUNT_QUERY_NV = 0x8865,
GL_SAMPLE_COUNT_NV = 0x8914,
GL_EVAL_2D_NV = 0x86C0,
GL_EVAL_TRIANGULAR_2D_NV = 0x86C1,
GL_MAP_TESSELLATION_NV = 0x86C2,
GL_MAP_ATTRIB_U_ORDER_NV = 0x86C3,
GL_MAP_ATTRIB_V_ORDER_NV = 0x86C4,
GL_EVAL_FRACTIONAL_TESSELLATION_NV = 0x86C5,
GL_EVAL_VERTEX_ATTRIB0_NV = 0x86C6,
GL_EVAL_VERTEX_ATTRIB1_NV = 0x86C7,
GL_EVAL_VERTEX_ATTRIB2_NV = 0x86C8,
GL_EVAL_VERTEX_ATTRIB3_NV = 0x86C9,
GL_EVAL_VERTEX_ATTRIB4_NV = 0x86CA,
GL_EVAL_VERTEX_ATTRIB5_NV = 0x86CB,
GL_EVAL_VERTEX_ATTRIB6_NV = 0x86CC,
GL_EVAL_VERTEX_ATTRIB7_NV = 0x86CD,
GL_EVAL_VERTEX_ATTRIB8_NV = 0x86CE,
GL_EVAL_VERTEX_ATTRIB9_NV = 0x86CF,
GL_EVAL_VERTEX_ATTRIB10_NV = 0x86D0,
GL_EVAL_VERTEX_ATTRIB11_NV = 0x86D1,
GL_EVAL_VERTEX_ATTRIB12_NV = 0x86D2,
GL_EVAL_VERTEX_ATTRIB13_NV = 0x86D3,
GL_EVAL_VERTEX_ATTRIB14_NV = 0x86D4,
GL_EVAL_VERTEX_ATTRIB15_NV = 0x86D5,
GL_MAX_MAP_TESSELLATION_NV = 0x86D6,
GL_MAX_RATIONAL_EVAL_ORDER_NV = 0x86D7,
GL_TEXTURE_BINDING_RENDERBUFFER_NV = 0x8E53,
GL_TEXTURE_RENDERBUFFER_DATA_STORE_BINDING_NV = 0x8E54,
GL_TEXTURE_RENDERBUFFER_NV = 0x8E55,
GL_SAMPLER_RENDERBUFFER_NV = 0x8E56,
GL_INT_SAMPLER_RENDERBUFFER_NV = 0x8E57,
GL_UNSIGNED_INT_SAMPLER_RENDERBUFFER_NV = 0x8E58,
GL_ALL_COMPLETED_NV = 0x84F2,
GL_FENCE_STATUS_NV = 0x84F3,
GL_FENCE_CONDITION_NV = 0x84F4,
GL_FLOAT_R_NV = 0x8880,
GL_FLOAT_RG_NV = 0x8881,
GL_FLOAT_RGB_NV = 0x8882,
GL_FLOAT_RGBA_NV = 0x8883,
GL_FLOAT_R16_NV = 0x8884,
GL_FLOAT_R32_NV = 0x8885,
GL_FLOAT_RG16_NV = 0x8886,
GL_FLOAT_RG32_NV = 0x8887,
GL_FLOAT_RGB16_NV = 0x8888,
GL_FLOAT_RGB32_NV = 0x8889,
GL_FLOAT_RGBA16_NV = 0x888A,
GL_FLOAT_RGBA32_NV = 0x888B,
GL_TEXTURE_FLOAT_COMPONENTS_NV = 0x888C,
GL_FLOAT_CLEAR_COLOR_VALUE_NV = 0x888D,
GL_FLOAT_RGBA_MODE_NV = 0x888E,
GL_FOG_DISTANCE_MODE_NV = 0x855A,
GL_EYE_RADIAL_NV = 0x855B,
GL_EYE_PLANE_ABSOLUTE_NV = 0x855C,
GL_MAX_FRAGMENT_PROGRAM_LOCAL_PARAMETERS_NV = 0x8868,
GL_FRAGMENT_PROGRAM_NV = 0x8870,
GL_FRAGMENT_PROGRAM_BINDING_NV = 0x8873,
GL_PROGRAM_ERROR_STRING_NV = 0x8874,
GL_MAX_PROGRAM_EXEC_INSTRUCTIONS_NV = 0x88F4,
GL_MAX_PROGRAM_CALL_DEPTH_NV = 0x88F5,
GL_MAX_PROGRAM_IF_DEPTH_NV = 0x88F6,
GL_MAX_PROGRAM_LOOP_DEPTH_NV = 0x88F7,
GL_MAX_PROGRAM_LOOP_COUNT_NV = 0x88F8,
GL_RENDERBUFFER_COVERAGE_SAMPLES_NV = 0x8CAB,
GL_RENDERBUFFER_COLOR_SAMPLES_NV = 0x8E10,
GL_MAX_MULTISAMPLE_COVERAGE_MODES_NV = 0x8E11,
GL_MULTISAMPLE_COVERAGE_MODES_NV = 0x8E12,
GL_GEOMETRY_PROGRAM_NV = 0x8C26,
GL_MAX_PROGRAM_OUTPUT_VERTICES_NV = 0x8C27,
GL_MAX_PROGRAM_TOTAL_OUTPUT_COMPONENTS_NV = 0x8C28,
GL_PROGRAM_ATTRIB_COMPONENTS_NV = 0x8906,
GL_PROGRAM_RESULT_COMPONENTS_NV = 0x8907,
GL_MAX_PROGRAM_ATTRIB_COMPONENTS_NV = 0x8908,
GL_MAX_PROGRAM_RESULT_COMPONENTS_NV = 0x8909,
GL_MAX_PROGRAM_GENERIC_ATTRIBS_NV = 0x8DA5,
GL_MAX_PROGRAM_GENERIC_RESULTS_NV = 0x8DA6,
GL_MAX_GEOMETRY_PROGRAM_INVOCATIONS_NV = 0x8E5A,
GL_FRAGMENT_PROGRAM_INTERPOLATION_OFFSET_BITS_NV = 0x8E5D,
GL_INT64_NV = 0x140E,
GL_UNSIGNED_INT64_NV = 0x140F,
GL_INT8_NV = 0x8FE0,
GL_INT8_VEC2_NV = 0x8FE1,
GL_INT8_VEC3_NV = 0x8FE2,
GL_INT8_VEC4_NV = 0x8FE3,
GL_INT16_NV = 0x8FE4,
GL_INT16_VEC2_NV = 0x8FE5,
GL_INT16_VEC3_NV = 0x8FE6,
GL_INT16_VEC4_NV = 0x8FE7,
GL_INT64_VEC2_NV = 0x8FE9,
GL_INT64_VEC3_NV = 0x8FEA,
GL_INT64_VEC4_NV = 0x8FEB,
GL_UNSIGNED_INT8_NV = 0x8FEC,
GL_UNSIGNED_INT8_VEC2_NV = 0x8FED,
GL_UNSIGNED_INT8_VEC3_NV = 0x8FEE,
GL_UNSIGNED_INT8_VEC4_NV = 0x8FEF,
GL_UNSIGNED_INT16_NV = 0x8FF0,
GL_UNSIGNED_INT16_VEC2_NV = 0x8FF1,
GL_UNSIGNED_INT16_VEC3_NV = 0x8FF2,
GL_UNSIGNED_INT16_VEC4_NV = 0x8FF3,
GL_UNSIGNED_INT64_VEC2_NV = 0x8FF5,
GL_UNSIGNED_INT64_VEC3_NV = 0x8FF6,
GL_UNSIGNED_INT64_VEC4_NV = 0x8FF7,
GL_FLOAT16_NV = 0x8FF8,
GL_FLOAT16_VEC2_NV = 0x8FF9,
GL_FLOAT16_VEC3_NV = 0x8FFA,
GL_FLOAT16_VEC4_NV = 0x8FFB,
GL_MAX_SHININESS_NV = 0x8504,
GL_MAX_SPOT_EXPONENT_NV = 0x8505,
GL_COLOR_SAMPLES_NV = 0x8E20,
GL_MULTISAMPLE_FILTER_HINT_NV = 0x8534,
GL_PIXEL_COUNTER_BITS_NV = 0x8864,
GL_CURRENT_OCCLUSION_QUERY_ID_NV = 0x8865,
GL_PIXEL_COUNT_NV = 0x8866,
GL_PIXEL_COUNT_AVAILABLE_NV = 0x8867,
GL_MAX_PROGRAM_PARAMETER_BUFFER_BINDINGS_NV = 0x8DA0,
GL_MAX_PROGRAM_PARAMETER_BUFFER_SIZE_NV = 0x8DA1,
GL_VERTEX_PROGRAM_PARAMETER_BUFFER_NV = 0x8DA2,
GL_GEOMETRY_PROGRAM_PARAMETER_BUFFER_NV = 0x8DA3,
GL_FRAGMENT_PROGRAM_PARAMETER_BUFFER_NV = 0x8DA4,
GL_CLOSE_PATH_NV = 0x00,
GL_BOLD_BIT_NV = 0x01,
GL_GLYPH_WIDTH_BIT_NV = 0x01,
GL_GLYPH_HEIGHT_BIT_NV = 0x02,
GL_ITALIC_BIT_NV = 0x02,
GL_MOVE_TO_NV = 0x02,
GL_RELATIVE_MOVE_TO_NV = 0x03,
GL_LINE_TO_NV = 0x04,
GL_GLYPH_HORIZONTAL_BEARING_X_BIT_NV = 0x04,
GL_RELATIVE_LINE_TO_NV = 0x05,
GL_HORIZONTAL_LINE_TO_NV = 0x06,
GL_RELATIVE_HORIZONTAL_LINE_TO_NV = 0x07,
GL_GLYPH_HORIZONTAL_BEARING_Y_BIT_NV = 0x08,
GL_VERTICAL_LINE_TO_NV = 0x08,
GL_RELATIVE_VERTICAL_LINE_TO_NV = 0x09,
GL_QUADRATIC_CURVE_TO_NV = 0x0A,
GL_RELATIVE_QUADRATIC_CURVE_TO_NV = 0x0B,
GL_CUBIC_CURVE_TO_NV = 0x0C,
GL_RELATIVE_CUBIC_CURVE_TO_NV = 0x0D,
GL_SMOOTH_QUADRATIC_CURVE_TO_NV = 0x0E,
GL_RELATIVE_SMOOTH_QUADRATIC_CURVE_TO_NV = 0x0F,
GL_GLYPH_HORIZONTAL_BEARING_ADVANCE_BIT_NV = 0x10,
GL_SMOOTH_CUBIC_CURVE_TO_NV = 0x10,
GL_RELATIVE_SMOOTH_CUBIC_CURVE_TO_NV = 0x11,
GL_SMALL_CCW_ARC_TO_NV = 0x12,
GL_RELATIVE_SMALL_CCW_ARC_TO_NV = 0x13,
GL_SMALL_CW_ARC_TO_NV = 0x14,
GL_RELATIVE_SMALL_CW_ARC_TO_NV = 0x15,
GL_LARGE_CCW_ARC_TO_NV = 0x16,
GL_RELATIVE_LARGE_CCW_ARC_TO_NV = 0x17,
GL_LARGE_CW_ARC_TO_NV = 0x18,
GL_RELATIVE_LARGE_CW_ARC_TO_NV = 0x19,
GL_GLYPH_VERTICAL_BEARING_X_BIT_NV = 0x20,
GL_GLYPH_VERTICAL_BEARING_Y_BIT_NV = 0x40,
GL_GLYPH_VERTICAL_BEARING_ADVANCE_BIT_NV = 0x80,
GL_RESTART_PATH_NV = 0xF0,
GL_DUP_FIRST_CUBIC_CURVE_TO_NV = 0xF2,
GL_DUP_LAST_CUBIC_CURVE_TO_NV = 0xF4,
GL_RECT_NV = 0xF6,
GL_CIRCULAR_CCW_ARC_TO_NV = 0xF8,
GL_CIRCULAR_CW_ARC_TO_NV = 0xFA,
GL_CIRCULAR_TANGENT_ARC_TO_NV = 0xFC,
GL_ARC_TO_NV = 0xFE,
GL_RELATIVE_ARC_TO_NV = 0xFF,
GL_GLYPH_HAS_KERNING_BIT_NV = 0x100,
//GL_PRIMARY_COLOR = 0x8577,
GL_PATH_FORMAT_SVG_NV = 0x9070,
GL_PATH_FORMAT_PS_NV = 0x9071,
GL_STANDARD_FONT_NAME_NV = 0x9072,
GL_SYSTEM_FONT_NAME_NV = 0x9073,
GL_FILE_NAME_NV = 0x9074,
GL_PATH_STROKE_WIDTH_NV = 0x9075,
GL_PATH_END_CAPS_NV = 0x9076,
GL_PATH_INITIAL_END_CAP_NV = 0x9077,
GL_PATH_TERMINAL_END_CAP_NV = 0x9078,
GL_PATH_JOIN_STYLE_NV = 0x9079,
GL_PATH_MITER_LIMIT_NV = 0x907A,
GL_PATH_DASH_CAPS_NV = 0x907B,
GL_PATH_INITIAL_DASH_CAP_NV = 0x907C,
GL_PATH_TERMINAL_DASH_CAP_NV = 0x907D,
GL_PATH_DASH_OFFSET_NV = 0x907E,
GL_PATH_CLIENT_LENGTH_NV = 0x907F,
GL_PATH_FILL_MODE_NV = 0x9080,
GL_PATH_FILL_MASK_NV = 0x9081,
GL_PATH_FILL_COVER_MODE_NV = 0x9082,
GL_PATH_STROKE_COVER_MODE_NV = 0x9083,
GL_PATH_STROKE_MASK_NV = 0x9084,
GL_COUNT_UP_NV = 0x9088,
GL_COUNT_DOWN_NV = 0x9089,
GL_PATH_OBJECT_BOUNDING_BOX_NV = 0x908A,
GL_CONVEX_HULL_NV = 0x908B,
GL_BOUNDING_BOX_NV = 0x908D,
GL_TRANSLATE_X_NV = 0x908E,
GL_TRANSLATE_Y_NV = 0x908F,
GL_TRANSLATE_2D_NV = 0x9090,
GL_TRANSLATE_3D_NV = 0x9091,
GL_AFFINE_2D_NV = 0x9092,
GL_AFFINE_3D_NV = 0x9094,
GL_TRANSPOSE_AFFINE_2D_NV = 0x9096,
GL_TRANSPOSE_AFFINE_3D_NV = 0x9098,
GL_UTF8_NV = 0x909A,
GL_UTF16_NV = 0x909B,
GL_BOUNDING_BOX_OF_BOUNDING_BOXES_NV = 0x909C,
GL_PATH_COMMAND_COUNT_NV = 0x909D,
GL_PATH_COORD_COUNT_NV = 0x909E,
GL_PATH_DASH_ARRAY_COUNT_NV = 0x909F,
GL_PATH_COMPUTED_LENGTH_NV = 0x90A0,
GL_PATH_FILL_BOUNDING_BOX_NV = 0x90A1,
GL_PATH_STROKE_BOUNDING_BOX_NV = 0x90A2,
GL_SQUARE_NV = 0x90A3,
GL_ROUND_NV = 0x90A4,
GL_TRIANGULAR_NV = 0x90A5,
GL_BEVEL_NV = 0x90A6,
GL_MITER_REVERT_NV = 0x90A7,
GL_MITER_TRUNCATE_NV = 0x90A8,
GL_SKIP_MISSING_GLYPH_NV = 0x90A9,
GL_USE_MISSING_GLYPH_NV = 0x90AA,
GL_PATH_ERROR_POSITION_NV = 0x90AB,
GL_PATH_FOG_GEN_MODE_NV = 0x90AC,
GL_ACCUM_ADJACENT_PAIRS_NV = 0x90AD,
GL_ADJACENT_PAIRS_NV = 0x90AE,
GL_FIRST_TO_REST_NV = 0x90AF,
GL_PATH_GEN_MODE_NV = 0x90B0,
GL_PATH_GEN_COEFF_NV = 0x90B1,
GL_PATH_GEN_COLOR_FORMAT_NV = 0x90B2,
GL_PATH_GEN_COMPONENTS_NV = 0x90B3,
GL_PATH_DASH_OFFSET_RESET_NV = 0x90B4,
GL_MOVE_TO_RESETS_NV = 0x90B5,
GL_MOVE_TO_CONTINUES_NV = 0x90B6,
GL_PATH_STENCIL_FUNC_NV = 0x90B7,
GL_PATH_STENCIL_REF_NV = 0x90B8,
GL_PATH_STENCIL_VALUE_MASK_NV = 0x90B9,
GL_PATH_STENCIL_DEPTH_OFFSET_FACTOR_NV = 0x90BD,
GL_PATH_STENCIL_DEPTH_OFFSET_UNITS_NV = 0x90BE,
GL_PATH_COVER_DEPTH_FUNC_NV = 0x90BF,
GL_FONT_X_MIN_BOUNDS_BIT_NV = 0x00010000,
GL_FONT_Y_MIN_BOUNDS_BIT_NV = 0x00020000,
GL_FONT_X_MAX_BOUNDS_BIT_NV = 0x00040000,
GL_FONT_Y_MAX_BOUNDS_BIT_NV = 0x00080000,
GL_FONT_UNITS_PER_EM_BIT_NV = 0x00100000,
GL_FONT_ASCENDER_BIT_NV = 0x00200000,
GL_FONT_DESCENDER_BIT_NV = 0x00400000,
GL_FONT_HEIGHT_BIT_NV = 0x00800000,
GL_FONT_MAX_ADVANCE_WIDTH_BIT_NV = 0x01000000,
GL_FONT_MAX_ADVANCE_HEIGHT_BIT_NV = 0x02000000,
GL_FONT_UNDERLINE_POSITION_BIT_NV = 0x04000000,
GL_FONT_UNDERLINE_THICKNESS_BIT_NV = 0x08000000,
GL_FONT_HAS_KERNING_BIT_NV = 0x10000000,
GL_WRITE_PIXEL_DATA_RANGE_NV = 0x8878,
GL_READ_PIXEL_DATA_RANGE_NV = 0x8879,
GL_WRITE_PIXEL_DATA_RANGE_LENGTH_NV = 0x887A,
GL_READ_PIXEL_DATA_RANGE_LENGTH_NV = 0x887B,
GL_WRITE_PIXEL_DATA_RANGE_POINTER_NV = 0x887C,
GL_READ_PIXEL_DATA_RANGE_POINTER_NV = 0x887D,
GL_POINT_SPRITE_R_MODE_NV = 0x8863,
GL_FRAME_NV = 0x8E26,
GL_FIELDS_NV = 0x8E27,
GL_CURRENT_TIME_NV = 0x8E28,
GL_NUM_FILL_STREAMS_NV = 0x8E29,
GL_PRESENT_TIME_NV = 0x8E2A,
GL_PRESENT_DURATION_NV = 0x8E2B,
GL_REGISTER_COMBINERS_NV = 0x8522,
GL_VARIABLE_A_NV = 0x8523,
GL_VARIABLE_B_NV = 0x8524,
GL_VARIABLE_C_NV = 0x8525,
GL_VARIABLE_D_NV = 0x8526,
GL_VARIABLE_E_NV = 0x8527,
GL_VARIABLE_F_NV = 0x8528,
GL_VARIABLE_G_NV = 0x8529,
GL_CONSTANT_COLOR0_NV = 0x852A,
GL_CONSTANT_COLOR1_NV = 0x852B,
GL_SECONDARY_COLOR_NV = 0x852D,
GL_SPARE0_NV = 0x852E,
GL_SPARE1_NV = 0x852F,
GL_DISCARD_NV = 0x8530,
GL_E_TIMES_F_NV = 0x8531,
GL_SPARE0_PLUS_SECONDARY_COLOR_NV = 0x8532,
GL_UNSIGNED_IDENTITY_NV = 0x8536,
GL_UNSIGNED_INVERT_NV = 0x8537,
GL_EXPAND_NORMAL_NV = 0x8538,
GL_EXPAND_NEGATE_NV = 0x8539,
GL_HALF_BIAS_NORMAL_NV = 0x853A,
GL_HALF_BIAS_NEGATE_NV = 0x853B,
GL_SIGNED_IDENTITY_NV = 0x853C,
GL_SIGNED_NEGATE_NV = 0x853D,
GL_SCALE_BY_TWO_NV = 0x853E,
GL_SCALE_BY_FOUR_NV = 0x853F,
GL_SCALE_BY_ONE_HALF_NV = 0x8540,
GL_BIAS_BY_NEGATIVE_ONE_HALF_NV = 0x8541,
GL_COMBINER_INPUT_NV = 0x8542,
GL_COMBINER_MAPPING_NV = 0x8543,
GL_COMBINER_COMPONENT_USAGE_NV = 0x8544,
GL_COMBINER_AB_DOT_PRODUCT_NV = 0x8545,
GL_COMBINER_CD_DOT_PRODUCT_NV = 0x8546,
GL_COMBINER_MUX_SUM_NV = 0x8547,
GL_COMBINER_SCALE_NV = 0x8548,
GL_COMBINER_BIAS_NV = 0x8549,
GL_COMBINER_AB_OUTPUT_NV = 0x854A,
GL_COMBINER_CD_OUTPUT_NV = 0x854B,
GL_COMBINER_SUM_OUTPUT_NV = 0x854C,
GL_MAX_GENERAL_COMBINERS_NV = 0x854D,
GL_NUM_GENERAL_COMBINERS_NV = 0x854E,
GL_COLOR_SUM_CLAMP_NV = 0x854F,
GL_COMBINER0_NV = 0x8550,
GL_COMBINER1_NV = 0x8551,
GL_COMBINER2_NV = 0x8552,
GL_COMBINER3_NV = 0x8553,
GL_COMBINER4_NV = 0x8554,
GL_COMBINER5_NV = 0x8555,
GL_COMBINER6_NV = 0x8556,
GL_COMBINER7_NV = 0x8557,
GL_PER_STAGE_CONSTANTS_NV = 0x8535,
GL_BUFFER_GPU_ADDRESS_NV = 0x8F1D,
GL_GPU_ADDRESS_NV = 0x8F34,
GL_MAX_SHADER_BUFFER_ADDRESS_NV = 0x8F35,
GL_MAX_PROGRAM_PATCH_ATTRIBS_NV = 0x86D8,
GL_TESS_CONTROL_PROGRAM_NV = 0x891E,
GL_TESS_EVALUATION_PROGRAM_NV = 0x891F,
GL_TESS_CONTROL_PROGRAM_PARAMETER_BUFFER_NV = 0x8C74,
GL_TESS_EVALUATION_PROGRAM_PARAMETER_BUFFER_NV = 0x8C75,
GL_EMBOSS_LIGHT_NV = 0x855D,
GL_EMBOSS_CONSTANT_NV = 0x855E,
GL_EMBOSS_MAP_NV = 0x855F,
GL_COMBINE4_NV = 0x8503,
GL_SOURCE3_RGB_NV = 0x8583,
GL_SOURCE3_ALPHA_NV = 0x858B,
GL_OPERAND3_RGB_NV = 0x8593,
GL_OPERAND3_ALPHA_NV = 0x859B,
GL_TEXTURE_UNSIGNED_REMAP_MODE_NV = 0x888F,
GL_TEXTURE_COVERAGE_SAMPLES_NV = 0x9045,
GL_TEXTURE_COLOR_SAMPLES_NV = 0x9046,
GL_OFFSET_TEXTURE_RECTANGLE_NV = 0x864C,
GL_OFFSET_TEXTURE_RECTANGLE_SCALE_NV = 0x864D,
GL_DOT_PRODUCT_TEXTURE_RECTANGLE_NV = 0x864E,
GL_RGBA_UNSIGNED_DOT_PRODUCT_MAPPING_NV = 0x86D9,
GL_UNSIGNED_INT_S8_S8_8_8_NV = 0x86DA,
GL_UNSIGNED_INT_8_8_S8_S8_REV_NV = 0x86DB,
GL_DSDT_MAG_INTENSITY_NV = 0x86DC,
GL_SHADER_CONSISTENT_NV = 0x86DD,
GL_TEXTURE_SHADER_NV = 0x86DE,
GL_SHADER_OPERATION_NV = 0x86DF,
GL_CULL_MODES_NV = 0x86E0,
GL_OFFSET_TEXTURE_2D_MATRIX_NV = 0x86E1,
GL_OFFSET_TEXTURE_MATRIX_NV = 0x86E1,
GL_OFFSET_TEXTURE_2D_SCALE_NV = 0x86E2,
GL_OFFSET_TEXTURE_SCALE_NV = 0x86E2,
GL_OFFSET_TEXTURE_BIAS_NV = 0x86E3,
GL_OFFSET_TEXTURE_2D_BIAS_NV = 0x86E3,
GL_PREVIOUS_TEXTURE_INPUT_NV = 0x86E4,
GL_CONST_EYE_NV = 0x86E5,
GL_PASS_THROUGH_NV = 0x86E6,
GL_CULL_FRAGMENT_NV = 0x86E7,
GL_OFFSET_TEXTURE_2D_NV = 0x86E8,
GL_DEPENDENT_AR_TEXTURE_2D_NV = 0x86E9,
GL_DEPENDENT_GB_TEXTURE_2D_NV = 0x86EA,
GL_DOT_PRODUCT_NV = 0x86EC,
GL_DOT_PRODUCT_DEPTH_REPLACE_NV = 0x86ED,
GL_DOT_PRODUCT_TEXTURE_2D_NV = 0x86EE,
GL_DOT_PRODUCT_TEXTURE_CUBE_MAP_NV = 0x86F0,
GL_DOT_PRODUCT_DIFFUSE_CUBE_MAP_NV = 0x86F1,
GL_DOT_PRODUCT_REFLECT_CUBE_MAP_NV = 0x86F2,
GL_DOT_PRODUCT_CONST_EYE_REFLECT_CUBE_MAP_NV = 0x86F3,
GL_HILO_NV = 0x86F4,
GL_DSDT_NV = 0x86F5,
GL_DSDT_MAG_NV = 0x86F6,
GL_DSDT_MAG_VIB_NV = 0x86F7,
GL_HILO16_NV = 0x86F8,
GL_SIGNED_HILO_NV = 0x86F9,
GL_SIGNED_HILO16_NV = 0x86FA,
GL_SIGNED_RGBA_NV = 0x86FB,
GL_SIGNED_RGBA8_NV = 0x86FC,
GL_SIGNED_RGB_NV = 0x86FE,
GL_SIGNED_RGB8_NV = 0x86FF,
GL_SIGNED_LUMINANCE_NV = 0x8701,
GL_SIGNED_LUMINANCE8_NV = 0x8702,
GL_SIGNED_LUMINANCE_ALPHA_NV = 0x8703,
GL_SIGNED_LUMINANCE8_ALPHA8_NV = 0x8704,
GL_SIGNED_ALPHA_NV = 0x8705,
GL_SIGNED_ALPHA8_NV = 0x8706,
GL_SIGNED_INTENSITY_NV = 0x8707,
GL_SIGNED_INTENSITY8_NV = 0x8708,
GL_DSDT8_NV = 0x8709,
GL_DSDT8_MAG8_NV = 0x870A,
GL_DSDT8_MAG8_INTENSITY8_NV = 0x870B,
GL_SIGNED_RGB_UNSIGNED_ALPHA_NV = 0x870C,
GL_SIGNED_RGB8_UNSIGNED_ALPHA8_NV = 0x870D,
GL_HI_SCALE_NV = 0x870E,
GL_LO_SCALE_NV = 0x870F,
GL_DS_SCALE_NV = 0x8710,
GL_DT_SCALE_NV = 0x8711,
GL_MAGNITUDE_SCALE_NV = 0x8712,
GL_VIBRANCE_SCALE_NV = 0x8713,
GL_HI_BIAS_NV = 0x8714,
GL_LO_BIAS_NV = 0x8715,
GL_DS_BIAS_NV = 0x8716,
GL_DT_BIAS_NV = 0x8717,
GL_MAGNITUDE_BIAS_NV = 0x8718,
GL_VIBRANCE_BIAS_NV = 0x8719,
GL_TEXTURE_BORDER_VALUES_NV = 0x871A,
GL_TEXTURE_HI_SIZE_NV = 0x871B,
GL_TEXTURE_LO_SIZE_NV = 0x871C,
GL_TEXTURE_DS_SIZE_NV = 0x871D,
GL_TEXTURE_DT_SIZE_NV = 0x871E,
GL_TEXTURE_MAG_SIZE_NV = 0x871F,
//GL_UNSIGNED_INT_S8_S8_8_8_NV = 0x86DA,
//GL_UNSIGNED_INT_8_8_S8_S8_REV_NV = 0x86DB,
//GL_DSDT_MAG_INTENSITY_NV = 0x86DC,
GL_DOT_PRODUCT_TEXTURE_3D_NV = 0x86EF,
//GL_HILO_NV = 0x86F4,
//GL_DSDT_NV = 0x86F5,
//GL_DSDT_MAG_NV = 0x86F6,
//GL_DSDT_MAG_VIB_NV = 0x86F7,
//GL_HILO16_NV = 0x86F8,
//GL_SIGNED_HILO_NV = 0x86F9,
//GL_SIGNED_HILO16_NV = 0x86FA,
//GL_SIGNED_RGBA_NV = 0x86FB,
//GL_SIGNED_RGBA8_NV = 0x86FC,
//GL_SIGNED_RGB_NV = 0x86FE,
//GL_SIGNED_RGB8_NV = 0x86FF,
//GL_SIGNED_LUMINANCE_NV = 0x8701,
//GL_SIGNED_LUMINANCE8_NV = 0x8702,
//GL_SIGNED_LUMINANCE_ALPHA_NV = 0x8703,
//GL_SIGNED_LUMINANCE8_ALPHA8_NV = 0x8704,
//GL_SIGNED_ALPHA_NV = 0x8705,
//GL_SIGNED_ALPHA8_NV = 0x8706,
//GL_SIGNED_INTENSITY_NV = 0x8707,
//GL_SIGNED_INTENSITY8_NV = 0x8708,
//GL_DSDT8_NV = 0x8709,
//GL_DSDT8_MAG8_NV = 0x870A,
//GL_DSDT8_MAG8_INTENSITY8_NV = 0x870B,
//GL_SIGNED_RGB_UNSIGNED_ALPHA_NV = 0x870C,
//GL_SIGNED_RGB8_UNSIGNED_ALPHA8_NV = 0x870D,
GL_OFFSET_PROJECTIVE_TEXTURE_2D_NV = 0x8850,
GL_OFFSET_PROJECTIVE_TEXTURE_2D_SCALE_NV = 0x8851,
GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_NV = 0x8852,
GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_SCALE_NV = 0x8853,
GL_OFFSET_HILO_TEXTURE_2D_NV = 0x8854,
GL_OFFSET_HILO_TEXTURE_RECTANGLE_NV = 0x8855,
GL_OFFSET_HILO_PROJECTIVE_TEXTURE_2D_NV = 0x8856,
GL_OFFSET_HILO_PROJECTIVE_TEXTURE_RECTANGLE_NV = 0x8857,
GL_DEPENDENT_HILO_TEXTURE_2D_NV = 0x8858,
GL_DEPENDENT_RGB_TEXTURE_3D_NV = 0x8859,
GL_DEPENDENT_RGB_TEXTURE_CUBE_MAP_NV = 0x885A,
GL_DOT_PRODUCT_PASS_THROUGH_NV = 0x885B,
GL_DOT_PRODUCT_TEXTURE_1D_NV = 0x885C,
GL_DOT_PRODUCT_AFFINE_DEPTH_REPLACE_NV = 0x885D,
GL_HILO8_NV = 0x885E,
GL_SIGNED_HILO8_NV = 0x885F,
GL_FORCE_BLUE_TO_ONE_NV = 0x8860,
GL_BACK_PRIMARY_COLOR_NV = 0x8C77,
GL_BACK_SECONDARY_COLOR_NV = 0x8C78,
GL_TEXTURE_COORD_NV = 0x8C79,
GL_CLIP_DISTANCE_NV = 0x8C7A,
GL_VERTEX_ID_NV = 0x8C7B,
GL_PRIMITIVE_ID_NV = 0x8C7C,
GL_GENERIC_ATTRIB_NV = 0x8C7D,
GL_TRANSFORM_FEEDBACK_ATTRIBS_NV = 0x8C7E,
GL_ACTIVE_VARYINGS_NV = 0x8C81,
GL_ACTIVE_VARYING_MAX_LENGTH_NV = 0x8C82,
GL_TRANSFORM_FEEDBACK_RECORD_NV = 0x8C86,
GL_SURFACE_STATE_NV = 0x86EB,
GL_SURFACE_REGISTERED_NV = 0x86FD,
GL_SURFACE_MAPPED_NV = 0x8700,
GL_WRITE_DISCARD_NV = 0x88BE,
GL_VERTEX_ARRAY_RANGE_NV = 0x851D,
GL_VERTEX_ARRAY_RANGE_LENGTH_NV = 0x851E,
GL_VERTEX_ARRAY_RANGE_VALID_NV = 0x851F,
GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_NV = 0x8520,
GL_VERTEX_ARRAY_RANGE_POINTER_NV = 0x8521,
GL_VERTEX_ARRAY_RANGE_WITHOUT_FLUSH_NV = 0x8533,
//GL_INT64_NV = 0x140E,
//GL_UNSIGNED_INT64_NV = 0x140F,
GL_VERTEX_ATTRIB_ARRAY_UNIFIED_NV = 0x8F1E,
GL_ELEMENT_ARRAY_UNIFIED_NV = 0x8F1F,
GL_VERTEX_ATTRIB_ARRAY_ADDRESS_NV = 0x8F20,
GL_VERTEX_ARRAY_ADDRESS_NV = 0x8F21,
GL_NORMAL_ARRAY_ADDRESS_NV = 0x8F22,
GL_COLOR_ARRAY_ADDRESS_NV = 0x8F23,
GL_INDEX_ARRAY_ADDRESS_NV = 0x8F24,
GL_TEXTURE_COORD_ARRAY_ADDRESS_NV = 0x8F25,
GL_EDGE_FLAG_ARRAY_ADDRESS_NV = 0x8F26,
GL_SECONDARY_COLOR_ARRAY_ADDRESS_NV = 0x8F27,
GL_FOG_COORD_ARRAY_ADDRESS_NV = 0x8F28,
GL_ELEMENT_ARRAY_ADDRESS_NV = 0x8F29,
GL_VERTEX_ATTRIB_ARRAY_LENGTH_NV = 0x8F2A,
GL_VERTEX_ARRAY_LENGTH_NV = 0x8F2B,
GL_NORMAL_ARRAY_LENGTH_NV = 0x8F2C,
GL_COLOR_ARRAY_LENGTH_NV = 0x8F2D,
GL_INDEX_ARRAY_LENGTH_NV = 0x8F2E,
GL_TEXTURE_COORD_ARRAY_LENGTH_NV = 0x8F2F,
GL_EDGE_FLAG_ARRAY_LENGTH_NV = 0x8F30,
GL_SECONDARY_COLOR_ARRAY_LENGTH_NV = 0x8F31,
GL_FOG_COORD_ARRAY_LENGTH_NV = 0x8F32,
GL_ELEMENT_ARRAY_LENGTH_NV = 0x8F33,
GL_DRAW_INDIRECT_UNIFIED_NV = 0x8F40,
GL_DRAW_INDIRECT_ADDRESS_NV = 0x8F41,
GL_DRAW_INDIRECT_LENGTH_NV = 0x8F42,
GL_VERTEX_PROGRAM_NV = 0x8620,
GL_VERTEX_STATE_PROGRAM_NV = 0x8621,
GL_ATTRIB_ARRAY_SIZE_NV = 0x8623,
GL_ATTRIB_ARRAY_STRIDE_NV = 0x8624,
GL_ATTRIB_ARRAY_TYPE_NV = 0x8625,
GL_CURRENT_ATTRIB_NV = 0x8626,
GL_PROGRAM_LENGTH_NV = 0x8627,
GL_PROGRAM_STRING_NV = 0x8628,
GL_MODELVIEW_PROJECTION_NV = 0x8629,
GL_IDENTITY_NV = 0x862A,
GL_INVERSE_NV = 0x862B,
GL_TRANSPOSE_NV = 0x862C,
GL_INVERSE_TRANSPOSE_NV = 0x862D,
GL_MAX_TRACK_MATRIX_STACK_DEPTH_NV = 0x862E,
GL_MAX_TRACK_MATRICES_NV = 0x862F,
GL_MATRIX0_NV = 0x8630,
GL_MATRIX1_NV = 0x8631,
GL_MATRIX2_NV = 0x8632,
GL_MATRIX3_NV = 0x8633,
GL_MATRIX4_NV = 0x8634,
GL_MATRIX5_NV = 0x8635,
GL_MATRIX6_NV = 0x8636,
GL_MATRIX7_NV = 0x8637,
GL_CURRENT_MATRIX_STACK_DEPTH_NV = 0x8640,
GL_CURRENT_MATRIX_NV = 0x8641,
GL_PROGRAM_PARAMETER_NV = 0x8644,
GL_ATTRIB_ARRAY_POINTER_NV = 0x8645,
GL_PROGRAM_TARGET_NV = 0x8646,
GL_PROGRAM_RESIDENT_NV = 0x8647,
GL_TRACK_MATRIX_NV = 0x8648,
GL_TRACK_MATRIX_TRANSFORM_NV = 0x8649,
GL_VERTEX_PROGRAM_BINDING_NV = 0x864A,
GL_PROGRAM_ERROR_POSITION_NV = 0x864B,
GL_VERTEX_ATTRIB_ARRAY0_NV = 0x8650,
GL_VERTEX_ATTRIB_ARRAY1_NV = 0x8651,
GL_VERTEX_ATTRIB_ARRAY2_NV = 0x8652,
GL_VERTEX_ATTRIB_ARRAY3_NV = 0x8653,
GL_VERTEX_ATTRIB_ARRAY4_NV = 0x8654,
GL_VERTEX_ATTRIB_ARRAY5_NV = 0x8655,
GL_VERTEX_ATTRIB_ARRAY6_NV = 0x8656,
GL_VERTEX_ATTRIB_ARRAY7_NV = 0x8657,
GL_VERTEX_ATTRIB_ARRAY8_NV = 0x8658,
GL_VERTEX_ATTRIB_ARRAY9_NV = 0x8659,
GL_VERTEX_ATTRIB_ARRAY10_NV = 0x865A,
GL_VERTEX_ATTRIB_ARRAY11_NV = 0x865B,
GL_VERTEX_ATTRIB_ARRAY12_NV = 0x865C,
GL_VERTEX_ATTRIB_ARRAY13_NV = 0x865D,
GL_VERTEX_ATTRIB_ARRAY14_NV = 0x865E,
GL_VERTEX_ATTRIB_ARRAY15_NV = 0x865F,
GL_MAP1_VERTEX_ATTRIB0_4_NV = 0x8660,
GL_MAP1_VERTEX_ATTRIB1_4_NV = 0x8661,
GL_MAP1_VERTEX_ATTRIB2_4_NV = 0x8662,
GL_MAP1_VERTEX_ATTRIB3_4_NV = 0x8663,
GL_MAP1_VERTEX_ATTRIB4_4_NV = 0x8664,
GL_MAP1_VERTEX_ATTRIB5_4_NV = 0x8665,
GL_MAP1_VERTEX_ATTRIB6_4_NV = 0x8666,
GL_MAP1_VERTEX_ATTRIB7_4_NV = 0x8667,
GL_MAP1_VERTEX_ATTRIB8_4_NV = 0x8668,
GL_MAP1_VERTEX_ATTRIB9_4_NV = 0x8669,
GL_MAP1_VERTEX_ATTRIB10_4_NV = 0x866A,
GL_MAP1_VERTEX_ATTRIB11_4_NV = 0x866B,
GL_MAP1_VERTEX_ATTRIB12_4_NV = 0x866C,
GL_MAP1_VERTEX_ATTRIB13_4_NV = 0x866D,
GL_MAP1_VERTEX_ATTRIB14_4_NV = 0x866E,
GL_MAP1_VERTEX_ATTRIB15_4_NV = 0x866F,
GL_MAP2_VERTEX_ATTRIB0_4_NV = 0x8670,
GL_MAP2_VERTEX_ATTRIB1_4_NV = 0x8671,
GL_MAP2_VERTEX_ATTRIB2_4_NV = 0x8672,
GL_MAP2_VERTEX_ATTRIB3_4_NV = 0x8673,
GL_MAP2_VERTEX_ATTRIB4_4_NV = 0x8674,
GL_MAP2_VERTEX_ATTRIB5_4_NV = 0x8675,
GL_MAP2_VERTEX_ATTRIB6_4_NV = 0x8676,
GL_MAP2_VERTEX_ATTRIB7_4_NV = 0x8677,
GL_MAP2_VERTEX_ATTRIB8_4_NV = 0x8678,
GL_MAP2_VERTEX_ATTRIB9_4_NV = 0x8679,
GL_MAP2_VERTEX_ATTRIB10_4_NV = 0x867A,
GL_MAP2_VERTEX_ATTRIB11_4_NV = 0x867B,
GL_MAP2_VERTEX_ATTRIB12_4_NV = 0x867C,
GL_MAP2_VERTEX_ATTRIB13_4_NV = 0x867D,
GL_MAP2_VERTEX_ATTRIB14_4_NV = 0x867E,
GL_MAP2_VERTEX_ATTRIB15_4_NV = 0x867F,
//GL_MAX_PROGRAM_EXEC_INSTRUCTIONS_NV = 0x88F4,
//GL_MAX_PROGRAM_CALL_DEPTH_NV = 0x88F5,
MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB = 0x8B4C,
GL_VIDEO_BUFFER_NV = 0x9020,
GL_VIDEO_BUFFER_BINDING_NV = 0x9021,
GL_FIELD_UPPER_NV = 0x9022,
GL_FIELD_LOWER_NV = 0x9023,
GL_NUM_VIDEO_CAPTURE_STREAMS_NV = 0x9024,
GL_NEXT_VIDEO_CAPTURE_BUFFER_STATUS_NV = 0x9025,
GL_VIDEO_CAPTURE_TO_422_SUPPORTED_NV = 0x9026,
GL_LAST_VIDEO_CAPTURE_STATUS_NV = 0x9027,
GL_VIDEO_BUFFER_PITCH_NV = 0x9028,
GL_VIDEO_COLOR_CONVERSION_MATRIX_NV = 0x9029,
GL_VIDEO_COLOR_CONVERSION_MAX_NV = 0x902A,
GL_VIDEO_COLOR_CONVERSION_MIN_NV = 0x902B,
GL_VIDEO_COLOR_CONVERSION_OFFSET_NV = 0x902C,
GL_VIDEO_BUFFER_INTERNAL_FORMAT_NV = 0x902D,
GL_PARTIAL_SUCCESS_NV = 0x902E,
GL_SUCCESS_NV = 0x902F,
GL_FAILURE_NV = 0x9030,
GL_YCBYCR8_422_NV = 0x9031,
GL_YCBAYCR8A_4224_NV = 0x9032,
GL_Z6Y10Z6CB10Z6Y10Z6CR10_422_NV = 0x9033,
GL_Z6Y10Z6CB10Z6A10Z6Y10Z6CR10Z6A10_4224_NV = 0x9034,
GL_Z4Y12Z4CB12Z4Y12Z4CR12_422_NV = 0x9035,
GL_Z4Y12Z4CB12Z4A12Z4Y12Z4CR12Z4A12_4224_NV = 0x9036,
GL_Z4Y12Z4CB12Z4CR12_444_NV = 0x9037,
GL_VIDEO_CAPTURE_FRAME_WIDTH_NV = 0x9038,
GL_VIDEO_CAPTURE_FRAME_HEIGHT_NV = 0x9039,
GL_VIDEO_CAPTURE_FIELD_UPPER_HEIGHT_NV = 0x903A,
GL_VIDEO_CAPTURE_FIELD_LOWER_HEIGHT_NV = 0x903B,
GL_VIDEO_CAPTURE_SURFACE_ORIGIN_NV = 0x903C,
};

extern void glAccum(GLenum op, GLfloat value);
extern void glAlphaFunc(GLenum func, GLclampf ref);
extern GLboolean glAreTexturesResident(GLsizei n, const GLuint *textures, GLboolean *residences);
extern void glArrayElement(GLint i);
extern void glBegin(GLenum mode);
extern void glBindTexture(GLenum target, GLuint texture);
extern void glBitmap(GLsizei width, GLsizei height, GLfloat xorig, GLfloat yorig, GLfloat xmove, GLfloat ymove, const GLubyte *bitmap);
extern void glBlendFunc(GLenum sfactor, GLenum dfactor);
extern void glCallList(GLuint list);
extern void glCallLists(GLsizei n, GLenum type, const GLvoid *lists);
extern void glClear(GLbitfield mask);
extern void glClearAccum(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
extern void glClearColor(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha);
extern void glClearDepth(GLclampd depth);
extern void glClearIndex(GLfloat c);
extern void glClearStencil(GLint s);
extern void glClipPlane(GLenum plane, const GLdouble *equation);
extern void glColor3b(GLbyte red, GLbyte green, GLbyte blue);
extern void glColor3bv(const GLbyte *v);
extern void glColor3d(GLdouble red, GLdouble green, GLdouble blue);
extern void glColor3dv(const GLdouble *v);
extern void glColor3f(GLfloat red, GLfloat green, GLfloat blue);
extern void glColor3fv(const GLfloat *v);
extern void glColor3i(GLint red, GLint green, GLint blue);
extern void glColor3iv(const GLint *v);
extern void glColor3s(GLshort red, GLshort green, GLshort blue);
extern void glColor3sv(const GLshort *v);
extern void glColor3ub(GLubyte red, GLubyte green, GLubyte blue);
extern void glColor3ubv(const GLubyte *v);
extern void glColor3ui(GLuint red, GLuint green, GLuint blue);
extern void glColor3uiv(const GLuint *v);
extern void glColor3us(GLushort red, GLushort green, GLushort blue);
extern void glColor3usv(const GLushort *v);
extern void glColor4b(GLbyte red, GLbyte green, GLbyte blue, GLbyte alpha);
extern void glColor4bv(const GLbyte *v);
extern void glColor4d(GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha);
extern void glColor4dv(const GLdouble *v);
extern void glColor4f(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
extern void glColor4fv(const GLfloat *v);
extern void glColor4i(GLint red, GLint green, GLint blue, GLint alpha);
extern void glColor4iv(const GLint *v);
extern void glColor4s(GLshort red, GLshort green, GLshort blue, GLshort alpha);
extern void glColor4sv(const GLshort *v);
extern void glColor4ub(GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha);
extern void glColor4ubv(const GLubyte *v);
extern void glColor4ui(GLuint red, GLuint green, GLuint blue, GLuint alpha);
extern void glColor4uiv(const GLuint *v);
extern void glColor4us(GLushort red, GLushort green, GLushort blue, GLushort alpha);
extern void glColor4usv(const GLushort *v);
extern void glColorMask(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha);
extern void glColorMaterial(GLenum face, GLenum mode);
extern void glColorPointer(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
extern void glCopyPixels(GLint x, GLint y, GLsizei width, GLsizei height, GLenum type);
extern void glCopyTexImage1D(GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLint border);
extern void glCopyTexImage2D(GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border);
extern void glCopyTexSubImage1D(GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width);
extern void glCopyTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height);
extern void glCullFace(GLenum mode);
extern void glDeleteLists(GLuint list, GLsizei range);
extern void glDeleteTextures(GLsizei n, const GLuint *textures);
extern void glDepthFunc(GLenum func);
extern void glDepthMask(GLboolean flag);
extern void glDepthRange(GLclampd zNear, GLclampd zFar);
extern void glDisable(GLenum cap);
extern void glDisableClientState(GLenum array);
extern void glDrawArrays(GLenum mode, GLint first, GLsizei count);
extern void glDrawBuffer(GLenum mode);
extern void glDrawElements(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices);
extern void glDrawPixels(GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels);
extern void glEdgeFlag(GLboolean flag);
extern void glEdgeFlagPointer(GLsizei stride, const GLvoid *pointer);
extern void glEdgeFlagv(const GLboolean *flag);
extern void glEnable(GLenum cap);
extern void glEnableClientState(GLenum array);
extern void glEnd(void);
extern void glEndList(void);
extern void glEvalCoord1d(GLdouble u);
extern void glEvalCoord1dv(const GLdouble *u);
extern void glEvalCoord1f(GLfloat u);
extern void glEvalCoord1fv(const GLfloat *u);
extern void glEvalCoord2d(GLdouble u, GLdouble v);
extern void glEvalCoord2dv(const GLdouble *u);
extern void glEvalCoord2f(GLfloat u, GLfloat v);
extern void glEvalCoord2fv(const GLfloat *u);
extern void glEvalMesh1(GLenum mode, GLint i1, GLint i2);
extern void glEvalMesh2(GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2);
extern void glEvalPoint1(GLint i);
extern void glEvalPoint2(GLint i, GLint j);
extern void glFeedbackBuffer(GLsizei size, GLenum type, GLfloat *buffer);
extern void glFinish(void);
extern void glFlush(void);
extern void glFogf(GLenum pname, GLfloat param);
extern void glFogfv(GLenum pname, const GLfloat *params);
extern void glFogi(GLenum pname, GLint param);
extern void glFogiv(GLenum pname, const GLint *params);
extern void glFrontFace(GLenum mode);
extern void glFrustum(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar);
extern GLuint glGenLists(GLsizei range);
extern void glGenTextures(GLsizei n, GLuint *textures);
extern void glGetBooleanv(GLenum pname, GLboolean *params);
extern void glGetClipPlane(GLenum plane, GLdouble *equation);
extern void glGetDoublev(GLenum pname, GLdouble *params);
extern GLenum glGetError(void);
extern void glGetFloatv(GLenum pname, GLfloat *params);
extern void glGetIntegerv(GLenum pname, GLint *params);
extern void glGetLightfv(GLenum light, GLenum pname, GLfloat *params);
extern void glGetLightiv(GLenum light, GLenum pname, GLint *params);
extern void glGetMapdv(GLenum target, GLenum query, GLdouble *v);
extern void glGetMapfv(GLenum target, GLenum query, GLfloat *v);
extern void glGetMapiv(GLenum target, GLenum query, GLint *v);
extern void glGetMaterialfv(GLenum face, GLenum pname, GLfloat *params);
extern void glGetMaterialiv(GLenum face, GLenum pname, GLint *params);
extern void glGetPixelMapfv(GLenum map, GLfloat *values);
extern void glGetPixelMapuiv(GLenum map, GLuint *values);
extern void glGetPixelMapusv(GLenum map, GLushort *values);
extern void glGetPointerv(GLenum pname, GLvoid* *params);
extern void glGetPolygonStipple(GLubyte *mask);
extern GLubyte* glGetString(GLenum s);
extern void glGetTexEnvfv(GLenum target, GLenum pname, GLfloat *params);
extern void glGetTexEnviv(GLenum target, GLenum pname, GLint *params);
extern void glGetTexGendv(GLenum coord, GLenum pname, GLdouble *params);
extern void glGetTexGenfv(GLenum coord, GLenum pname, GLfloat *params);
extern void glGetTexGeniv(GLenum coord, GLenum pname, GLint *params);
extern void glGetTexImage(GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels);
extern void glGetTexLevelParameterfv(GLenum target, GLint level, GLenum pname, GLfloat *params);
extern void glGetTexLevelParameteriv(GLenum target, GLint level, GLenum pname, GLint *params);
extern void glGetTexParameterfv(GLenum target, GLenum pname, GLfloat *params);
extern void glGetTexParameteriv(GLenum target, GLenum pname, GLint *params);
extern void glHint(GLenum target, GLenum mode);
extern void glIndexMask(GLuint mask);
extern void glIndexPointer(GLenum type, GLsizei stride, const GLvoid *pointer);
extern void glIndexd(GLdouble c);
extern void glIndexdv(const GLdouble *c);
extern void glIndexf(GLfloat c);
extern void glIndexfv(const GLfloat *c);
extern void glIndexi(GLint c);
extern void glIndexiv(const GLint *c);
extern void glIndexs(GLshort c);
extern void glIndexsv(const GLshort *c);
extern void glIndexub(GLubyte c);
extern void glIndexubv(const GLubyte *c);
extern void glInitNames(void);
extern void glInterleavedArrays(GLenum format, GLsizei stride, const GLvoid *pointer);
extern GLboolean glIsEnabled(GLenum cap);
extern GLboolean glIsList(GLuint list);
extern GLboolean glIsTexture(GLuint texture);
extern void glLightModelf(GLenum pname, GLfloat param);
extern void glLightModelfv(GLenum pname, const GLfloat *params);
extern void glLightModeli(GLenum pname, GLint param);
extern void glLightModeliv(GLenum pname, const GLint *params);
extern void glLightf(GLenum light, GLenum pname, GLfloat param);
extern void glLightfv(GLenum light, GLenum pname, const GLfloat *params);
extern void glLighti(GLenum light, GLenum pname, GLint param);
extern void glLightiv(GLenum light, GLenum pname, const GLint *params);
extern void glLineStipple(GLint factor, GLushort pattern);
extern void glLineWidth(GLfloat width);
extern void glListBase(GLuint base);
extern void glLoadIdentity(void);
extern void glLoadMatrixd(const GLdouble *m);
extern void glLoadMatrixf(const GLfloat *m);
extern void glLoadName(GLuint name);
extern void glLogicOp(GLenum opcode);
extern void glMap1d(GLenum target, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points);
extern void glMap1f(GLenum target, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points);
extern void glMap2d(GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points);
extern void glMap2f(GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points);
extern void glMapGrid1d(GLint un, GLdouble u1, GLdouble u2);
extern void glMapGrid1f(GLint un, GLfloat u1, GLfloat u2);
extern void glMapGrid2d(GLint un, GLdouble u1, GLdouble u2, GLint vn, GLdouble v1, GLdouble v2);
extern void glMapGrid2f(GLint un, GLfloat u1, GLfloat u2, GLint vn, GLfloat v1, GLfloat v2);
extern void glMaterialf(GLenum face, GLenum pname, GLfloat param);
extern void glMaterialfv(GLenum face, GLenum pname, const GLfloat *params);
extern void glMateriali(GLenum face, GLenum pname, GLint param);
extern void glMaterialiv(GLenum face, GLenum pname, const GLint *params);
extern void glMatrixMode(GLenum mode);
extern void glMultMatrixd(const GLdouble *m);
extern void glMultMatrixf(const GLfloat *m);
extern void glNewList(GLuint list, GLenum mode);
extern void glNormal3b(GLbyte nx, GLbyte ny, GLbyte nz);
extern void glNormal3bv(const GLbyte *v);
extern void glNormal3d(GLdouble nx, GLdouble ny, GLdouble nz);
extern void glNormal3dv(const GLdouble *v);
extern void glNormal3f(GLfloat nx, GLfloat ny, GLfloat nz);
extern void glNormal3fv(const GLfloat *v);
extern void glNormal3i(GLint nx, GLint ny, GLint nz);
extern void glNormal3iv(const GLint *v);
extern void glNormal3s(GLshort nx, GLshort ny, GLshort nz);
extern void glNormal3sv(const GLshort *v);
extern void glNormalPointer(GLenum type, GLsizei stride, const GLvoid *pointer);
extern void glOrtho(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar);
extern void glPassThrough(GLfloat token);
extern void glPixelMapfv(GLenum map, GLsizei mapsize, const GLfloat *values);
extern void glPixelMapuiv(GLenum map, GLsizei mapsize, const GLuint *values);
extern void glPixelMapusv(GLenum map, GLsizei mapsize, const GLushort *values);
extern void glPixelStoref(GLenum pname, GLfloat param);
extern void glPixelStorei(GLenum pname, GLint param);
extern void glPixelTransferf(GLenum pname, GLfloat param);
extern void glPixelTransferi(GLenum pname, GLint param);
extern void glPixelZoom(GLfloat xfactor, GLfloat yfactor);
extern void glPointSize(GLfloat size);
extern void glPolygonMode(GLenum face, GLenum mode);
extern void glPolygonOffset(GLfloat factor, GLfloat units);
extern void glPolygonStipple(const GLubyte *mask);
extern void glPopAttrib(void);
extern void glPopClientAttrib(void);
extern void glPopMatrix(void);
extern void glPopName(void);
extern void glPrioritizeTextures(GLsizei n, const GLuint *textures, const GLclampf *priorities);
extern void glPushAttrib(GLbitfield mask);
extern void glPushClientAttrib(GLbitfield mask);
extern void glPushMatrix(void);
extern void glPushName(GLuint name);
extern void glRasterPos2d(GLdouble x, GLdouble y);
extern void glRasterPos2dv(const GLdouble *v);
extern void glRasterPos2f(GLfloat x, GLfloat y);
extern void glRasterPos2fv(const GLfloat *v);
extern void glRasterPos2i(GLint x, GLint y);
extern void glRasterPos2iv(const GLint *v);
extern void glRasterPos2s(GLshort x, GLshort y);
extern void glRasterPos2sv(const GLshort *v);
extern void glRasterPos3d(GLdouble x, GLdouble y, GLdouble z);
extern void glRasterPos3dv(const GLdouble *v);
extern void glRasterPos3f(GLfloat x, GLfloat y, GLfloat z);
extern void glRasterPos3fv(const GLfloat *v);
extern void glRasterPos3i(GLint x, GLint y, GLint z);
extern void glRasterPos3iv(const GLint *v);
extern void glRasterPos3s(GLshort x, GLshort y, GLshort z);
extern void glRasterPos3sv(const GLshort *v);
extern void glRasterPos4d(GLdouble x, GLdouble y, GLdouble z, GLdouble w);
extern void glRasterPos4dv(const GLdouble *v);
extern void glRasterPos4f(GLfloat x, GLfloat y, GLfloat z, GLfloat w);
extern void glRasterPos4fv(const GLfloat *v);
extern void glRasterPos4i(GLint x, GLint y, GLint z, GLint w);
extern void glRasterPos4iv(const GLint *v);
extern void glRasterPos4s(GLshort x, GLshort y, GLshort z, GLshort w);
extern void glRasterPos4sv(const GLshort *v);
extern void glReadBuffer(GLenum mode);
extern void glReadPixels(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels);
extern void glRectd(GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2);
extern void glRectdv(const GLdouble *v1, const GLdouble *v2);
extern void glRectf(GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2);
extern void glRectfv(const GLfloat *v1, const GLfloat *v2);
extern void glRecti(GLint x1, GLint y1, GLint x2, GLint y2);
extern void glRectiv(const GLint *v1, const GLint *v2);
extern void glRects(GLshort x1, GLshort y1, GLshort x2, GLshort y2);
extern void glRectsv(const GLshort *v1, const GLshort *v2);
extern GLint glRenderMode(GLenum mode);
extern void glRotated(GLdouble angle, GLdouble x, GLdouble y, GLdouble z);
extern void glRotatef(GLfloat angle, GLfloat x, GLfloat y, GLfloat z);
extern void glScaled(GLdouble x, GLdouble y, GLdouble z);
extern void glScalef(GLfloat x, GLfloat y, GLfloat z);
extern void glScissor(GLint x, GLint y, GLsizei width, GLsizei height);
extern void glSelectBuffer(GLsizei size, GLuint *buffer);
extern void glShadeModel(GLenum mode);
extern void glStencilFunc(GLenum func, GLint ref, GLuint mask);
extern void glStencilMask(GLuint mask);
extern void glStencilOp(GLenum fail, GLenum zfail, GLenum zpass);
extern void glTexCoord1d(GLdouble s);
extern void glTexCoord1dv(const GLdouble *v);
extern void glTexCoord1f(GLfloat s);
extern void glTexCoord1fv(const GLfloat *v);
extern void glTexCoord1i(GLint s);
extern void glTexCoord1iv(const GLint *v);
extern void glTexCoord1s(GLshort s);
extern void glTexCoord1sv(const GLshort *v);
extern void glTexCoord2d(GLdouble s, GLdouble t);
extern void glTexCoord2dv(const GLdouble *v);
extern void glTexCoord2f(GLfloat s, GLfloat t);
extern void glTexCoord2fv(const GLfloat *v);
extern void glTexCoord2i(GLint s, GLint t);
extern void glTexCoord2iv(const GLint *v);
extern void glTexCoord2s(GLshort s, GLshort t);
extern void glTexCoord2sv(const GLshort *v);
extern void glTexCoord3d(GLdouble s, GLdouble t, GLdouble r);
extern void glTexCoord3dv(const GLdouble *v);
extern void glTexCoord3f(GLfloat s, GLfloat t, GLfloat r);
extern void glTexCoord3fv(const GLfloat *v);
extern void glTexCoord3i(GLint s, GLint t, GLint r);
extern void glTexCoord3iv(const GLint *v);
extern void glTexCoord3s(GLshort s, GLshort t, GLshort r);
extern void glTexCoord3sv(const GLshort *v);
extern void glTexCoord4d(GLdouble s, GLdouble t, GLdouble r, GLdouble q);
extern void glTexCoord4dv(const GLdouble *v);
extern void glTexCoord4f(GLfloat s, GLfloat t, GLfloat r, GLfloat q);
extern void glTexCoord4fv(const GLfloat *v);
extern void glTexCoord4i(GLint s, GLint t, GLint r, GLint q);
extern void glTexCoord4iv(const GLint *v);
extern void glTexCoord4s(GLshort s, GLshort t, GLshort r, GLshort q);
extern void glTexCoord4sv(const GLshort *v);
extern void glTexCoordPointer(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
extern void glTexEnvf(GLenum target, GLenum pname, GLfloat param);
extern void glTexEnvfv(GLenum target, GLenum pname, const GLfloat *params);
extern void glTexEnvi(GLenum target, GLenum pname, GLint param);
extern void glTexEnviv(GLenum target, GLenum pname, const GLint *params);
extern void glTexGend(GLenum coord, GLenum pname, GLdouble param);
extern void glTexGendv(GLenum coord, GLenum pname, const GLdouble *params);
extern void glTexGenf(GLenum coord, GLenum pname, GLfloat param);
extern void glTexGenfv(GLenum coord, GLenum pname, const GLfloat *params);
extern void glTexGeni(GLenum coord, GLenum pname, GLint param);
extern void glTexGeniv(GLenum coord, GLenum pname, const GLint *params);
extern void glTexImage1D(GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
extern void glTexImage2D(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
extern void glTexParameterf(GLenum target, GLenum pname, GLfloat param);
extern void glTexParameterfv(GLenum target, GLenum pname, const GLfloat *params);
extern void glTexParameteri(GLenum target, GLenum pname, GLint param);
extern void glTexParameteriv(GLenum target, GLenum pname, const GLint *params);
extern void glTexSubImage1D(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels);
extern void glTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels);
extern void glTranslated(GLdouble x, GLdouble y, GLdouble z);
extern void glTranslatef(GLfloat x, GLfloat y, GLfloat z);
extern void glVertex2d(GLdouble x, GLdouble y);
extern void glVertex2dv(const GLdouble *v);
extern void glVertex2f(GLfloat x, GLfloat y);
extern void glVertex2fv(const GLfloat *v);
extern void glVertex2i(GLint x, GLint y);
extern void glVertex2iv(const GLint *v);
extern void glVertex2s(GLshort x, GLshort y);
extern void glVertex2sv(const GLshort *v);
extern void glVertex3d(GLdouble x, GLdouble y, GLdouble z);
extern void glVertex3dv(const GLdouble *v);
extern void glVertex3f(GLfloat x, GLfloat y, GLfloat z);
extern void glVertex3fv(const GLfloat *v);
extern void glVertex3i(GLint x, GLint y, GLint z);
extern void glVertex3iv(const GLint *v);
extern void glVertex3s(GLshort x, GLshort y, GLshort z);
extern void glVertex3sv(const GLshort *v);
extern void glVertex4d(GLdouble x, GLdouble y, GLdouble z, GLdouble w);
extern void glVertex4dv(const GLdouble *v);
extern void glVertex4f(GLfloat x, GLfloat y, GLfloat z, GLfloat w);
extern void glVertex4fv(const GLfloat *v);
extern void glVertex4i(GLint x, GLint y, GLint z, GLint w);
extern void glVertex4iv(const GLint *v);
extern void glVertex4s(GLshort x, GLshort y, GLshort z, GLshort w);
extern void glVertex4sv(const GLshort *v);
extern void glVertexPointer(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
extern void glViewport(GLint x, GLint y, GLsizei width, GLsizei height);
extern void glCopyTexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height);
extern void glDrawRangeElements(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid *indices);
extern void glTexImage3D(GLenum target, GLint level, GLint internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
extern void glTexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid *pixels);
extern void glActiveTexture(GLenum texture);
extern void glClientActiveTexture(GLenum texture);
extern void glCompressedTexImage1D(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const GLvoid *data);
extern void glCompressedTexImage2D(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid *data);
extern void glCompressedTexImage3D(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid *data);
extern void glCompressedTexSubImage1D(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid *data);
extern void glCompressedTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid *data);
extern void glCompressedTexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid *data);
extern void glGetCompressedTexImage(GLenum target, GLint lod, GLvoid *img);
extern void glLoadTransposeMatrixd(const GLdouble m[16]);
extern void glLoadTransposeMatrixf(const GLfloat m[16]);
extern void glMultTransposeMatrixd(const GLdouble m[16]);
extern void glMultTransposeMatrixf(const GLfloat m[16]);
extern void glMultiTexCoord1d(GLenum target, GLdouble s);
extern void glMultiTexCoord1dv(GLenum target, const GLdouble *v);
extern void glMultiTexCoord1f(GLenum target, GLfloat s);
extern void glMultiTexCoord1fv(GLenum target, const GLfloat *v);
extern void glMultiTexCoord1i(GLenum target, GLint s);
extern void glMultiTexCoord1iv(GLenum target, const GLint *v);
extern void glMultiTexCoord1s(GLenum target, GLshort s);
extern void glMultiTexCoord1sv(GLenum target, const GLshort *v);
extern void glMultiTexCoord2d(GLenum target, GLdouble s, GLdouble t);
extern void glMultiTexCoord2dv(GLenum target, const GLdouble *v);
extern void glMultiTexCoord2f(GLenum target, GLfloat s, GLfloat t);
extern void glMultiTexCoord2fv(GLenum target, const GLfloat *v);
extern void glMultiTexCoord2i(GLenum target, GLint s, GLint t);
extern void glMultiTexCoord2iv(GLenum target, const GLint *v);
extern void glMultiTexCoord2s(GLenum target, GLshort s, GLshort t);
extern void glMultiTexCoord2sv(GLenum target, const GLshort *v);
extern void glMultiTexCoord3d(GLenum target, GLdouble s, GLdouble t, GLdouble r);
extern void glMultiTexCoord3dv(GLenum target, const GLdouble *v);
extern void glMultiTexCoord3f(GLenum target, GLfloat s, GLfloat t, GLfloat r);
extern void glMultiTexCoord3fv(GLenum target, const GLfloat *v);
extern void glMultiTexCoord3i(GLenum target, GLint s, GLint t, GLint r);
extern void glMultiTexCoord3iv(GLenum target, const GLint *v);
extern void glMultiTexCoord3s(GLenum target, GLshort s, GLshort t, GLshort r);
extern void glMultiTexCoord3sv(GLenum target, const GLshort *v);
extern void glMultiTexCoord4d(GLenum target, GLdouble s, GLdouble t, GLdouble r, GLdouble q);
extern void glMultiTexCoord4dv(GLenum target, const GLdouble *v);
extern void glMultiTexCoord4f(GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q);
extern void glMultiTexCoord4fv(GLenum target, const GLfloat *v);
extern void glMultiTexCoord4i(GLenum target, GLint s, GLint t, GLint r, GLint q);
extern void glMultiTexCoord4iv(GLenum target, const GLint *v);
extern void glMultiTexCoord4s(GLenum target, GLshort s, GLshort t, GLshort r, GLshort q);
extern void glMultiTexCoord4sv(GLenum target, const GLshort *v);
extern void glSampleCoverage(GLclampf value, GLboolean invert);
extern void glBlendColor(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha);
extern void glBlendEquation(GLenum mode);
extern void glBlendFuncSeparate(GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha);
extern void glFogCoordPointer(GLenum type, GLsizei stride, const GLvoid *pointer);
extern void glFogCoordd(GLdouble coord);
extern void glFogCoorddv(const GLdouble *coord);
extern void glFogCoordf(GLfloat coord);
extern void glFogCoordfv(const GLfloat *coord);
extern void glMultiDrawArrays(GLenum mode, const GLint *first, const GLsizei *count, GLsizei drawcount);
extern void glMultiDrawElements(GLenum mode, const GLsizei *count, GLenum type, const GLvoid **indices, GLsizei drawcount);
extern void glPointParameterf(GLenum pname, GLfloat param);
extern void glPointParameterfv(GLenum pname, const GLfloat *params);
extern void glPointParameteri(GLenum pname, GLint param);
extern void glPointParameteriv(GLenum pname, const GLint *params);
extern void glSecondaryColor3b(GLbyte red, GLbyte green, GLbyte blue);
extern void glSecondaryColor3bv(const GLbyte *v);
extern void glSecondaryColor3d(GLdouble red, GLdouble green, GLdouble blue);
extern void glSecondaryColor3dv(const GLdouble *v);
extern void glSecondaryColor3f(GLfloat red, GLfloat green, GLfloat blue);
extern void glSecondaryColor3fv(const GLfloat *v);
extern void glSecondaryColor3i(GLint red, GLint green, GLint blue);
extern void glSecondaryColor3iv(const GLint *v);
extern void glSecondaryColor3s(GLshort red, GLshort green, GLshort blue);
extern void glSecondaryColor3sv(const GLshort *v);
extern void glSecondaryColor3ub(GLubyte red, GLubyte green, GLubyte blue);
extern void glSecondaryColor3ubv(const GLubyte *v);
extern void glSecondaryColor3ui(GLuint red, GLuint green, GLuint blue);
extern void glSecondaryColor3uiv(const GLuint *v);
extern void glSecondaryColor3us(GLushort red, GLushort green, GLushort blue);
extern void glSecondaryColor3usv(const GLushort *v);
extern void glSecondaryColorPointer(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
extern void glWindowPos2d(GLdouble x, GLdouble y);
extern void glWindowPos2dv(const GLdouble *p);
extern void glWindowPos2f(GLfloat x, GLfloat y);
extern void glWindowPos2fv(const GLfloat *p);
extern void glWindowPos2i(GLint x, GLint y);
extern void glWindowPos2iv(const GLint *p);
extern void glWindowPos2s(GLshort x, GLshort y);
extern void glWindowPos2sv(const GLshort *p);
extern void glWindowPos3d(GLdouble x, GLdouble y, GLdouble z);
extern void glWindowPos3dv(const GLdouble *p);
extern void glWindowPos3f(GLfloat x, GLfloat y, GLfloat z);
extern void glWindowPos3fv(const GLfloat *p);
extern void glWindowPos3i(GLint x, GLint y, GLint z);
extern void glWindowPos3iv(const GLint *p);
extern void glWindowPos3s(GLshort x, GLshort y, GLshort z);
extern void glWindowPos3sv(const GLshort *p);
extern void glBeginQuery(GLenum target, GLuint id);
extern void glBindBuffer(GLenum target, GLuint buffer);
extern void glBufferData(GLenum target, GLsizeiptr size, const GLvoid* data, GLenum usage);
extern void glBufferSubData(GLenum target, GLintptr offset, GLsizeiptr size, const GLvoid* data);
extern void glDeleteBuffers(GLsizei n, const GLuint* buffers);
extern void glDeleteQueries(GLsizei n, const GLuint* ids);
extern void glEndQuery(GLenum target);
extern void glGenBuffers(GLsizei n, GLuint* buffers);
extern void glGenQueries(GLsizei n, GLuint* ids);
extern void glGetBufferParameteriv(GLenum target, GLenum pname, GLint* params);
extern void glGetBufferPointerv(GLenum target, GLenum pname, GLvoid** params);
extern void glGetBufferSubData(GLenum target, GLintptr offset, GLsizeiptr size, GLvoid* data);
extern void glGetQueryObjectiv(GLuint id, GLenum pname, GLint* params);
extern void glGetQueryObjectuiv(GLuint id, GLenum pname, GLuint* params);
extern void glGetQueryiv(GLenum target, GLenum pname, GLint* params);
extern GLboolean glIsBuffer(GLuint buffer);
extern GLboolean glIsQuery(GLuint id);
extern GLvoid* glMapBuffer(GLenum target, GLenum access);
extern GLboolean glUnmapBuffer(GLenum target);
extern void glAttachShader(GLuint program, GLuint shader);
extern void glBindAttribLocation(GLuint program, GLuint index, const GLchar* name);
extern void glBlendEquationSeparate(GLenum, GLenum);
extern void glCompileShader(GLuint shader);
extern GLuint glCreateProgram(void);
extern GLuint glCreateShader(GLenum type);
extern void glDeleteProgram(GLuint program);
extern void glDeleteShader(GLuint shader);
extern void glDetachShader(GLuint program, GLuint shader);
extern void glDisableVertexAttribArray(GLuint);
extern void glDrawBuffers(GLsizei n, const GLenum* bufs);
extern void glEnableVertexAttribArray(GLuint);
extern void glGetActiveAttrib(GLuint program, GLuint index, GLsizei maxLength, GLsizei* length, GLint* size, GLenum* type, GLchar* name);
extern void glGetActiveUniform(GLuint program, GLuint index, GLsizei maxLength, GLsizei* length, GLint* size, GLenum* type, GLchar* name);
extern void glGetAttachedShaders(GLuint program, GLsizei maxCount, GLsizei* count, GLuint* shaders);
extern GLint glGetAttribLocation(GLuint program, const GLchar* name);
extern void glGetProgramInfoLog(GLuint program, GLsizei bufSize, GLsizei* length, GLchar* infoLog);
extern void glGetProgramiv(GLuint program, GLenum pname, GLint* param);
extern void glGetShaderInfoLog(GLuint shader, GLsizei bufSize, GLsizei* length, GLchar* infoLog);
extern void glGetShaderSource(GLuint obj, GLsizei maxLength, GLsizei* length, GLchar* source);
extern void glGetShaderiv(GLuint shader, GLenum pname, GLint* param);
extern GLint glGetUniformLocation(GLuint program, const GLchar* name);
extern void glGetUniformfv(GLuint program, GLint location, GLfloat* params);
extern void glGetUniformiv(GLuint program, GLint location, GLint* params);
extern void glGetVertexAttribPointerv(GLuint, GLenum, GLvoid**);
extern void glGetVertexAttribdv(GLuint, GLenum, GLdouble*);
extern void glGetVertexAttribfv(GLuint, GLenum, GLfloat*);
extern void glGetVertexAttribiv(GLuint, GLenum, GLint*);
extern GLboolean glIsProgram(GLuint program);
extern GLboolean glIsShader(GLuint shader);
extern void glLinkProgram(GLuint program);
extern void glShaderSource(GLuint shader, GLsizei count, const GLchar** strings, const GLint* lengths);
extern void glStencilFuncSeparate(GLenum frontfunc, GLenum backfunc, GLint ref, GLuint mask);
extern void glStencilMaskSeparate(GLenum, GLuint);
extern void glStencilOpSeparate(GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass);
extern void glUniform1f(GLint location, GLfloat v0);
extern void glUniform1fv(GLint location, GLsizei count, const GLfloat* value);
extern void glUniform1i(GLint location, GLint v0);
extern void glUniform1iv(GLint location, GLsizei count, const GLint* value);
extern void glUniform2f(GLint location, GLfloat v0, GLfloat v1);
extern void glUniform2fv(GLint location, GLsizei count, const GLfloat* value);
extern void glUniform2i(GLint location, GLint v0, GLint v1);
extern void glUniform2iv(GLint location, GLsizei count, const GLint* value);
extern void glUniform3f(GLint location, GLfloat v0, GLfloat v1, GLfloat v2);
extern void glUniform3fv(GLint location, GLsizei count, const GLfloat* value);
extern void glUniform3i(GLint location, GLint v0, GLint v1, GLint v2);
extern void glUniform3iv(GLint location, GLsizei count, const GLint* value);
extern void glUniform4f(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3);
extern void glUniform4fv(GLint location, GLsizei count, const GLfloat* value);
extern void glUniform4i(GLint location, GLint v0, GLint v1, GLint v2, GLint v3);
extern void glUniform4iv(GLint location, GLsizei count, const GLint* value);
extern void glUniformMatrix2fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat* value);
extern void glUniformMatrix3fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat* value);
extern void glUniformMatrix4fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat* value);
extern void glUseProgram(GLuint program);
extern void glValidateProgram(GLuint program);
extern void glVertexAttrib1d(GLuint index, GLdouble x);
extern void glVertexAttrib1dv(GLuint index, const GLdouble* v);
extern void glVertexAttrib1f(GLuint index, GLfloat x);
extern void glVertexAttrib1fv(GLuint index, const GLfloat* v);
extern void glVertexAttrib1s(GLuint index, GLshort x);
extern void glVertexAttrib1sv(GLuint index, const GLshort* v);
extern void glVertexAttrib2d(GLuint index, GLdouble x, GLdouble y);
extern void glVertexAttrib2dv(GLuint index, const GLdouble* v);
extern void glVertexAttrib2f(GLuint index, GLfloat x, GLfloat y);
extern void glVertexAttrib2fv(GLuint index, const GLfloat* v);
extern void glVertexAttrib2s(GLuint index, GLshort x, GLshort y);
extern void glVertexAttrib2sv(GLuint index, const GLshort* v);
extern void glVertexAttrib3d(GLuint index, GLdouble x, GLdouble y, GLdouble z);
extern void glVertexAttrib3dv(GLuint index, const GLdouble* v);
extern void glVertexAttrib3f(GLuint index, GLfloat x, GLfloat y, GLfloat z);
extern void glVertexAttrib3fv(GLuint index, const GLfloat* v);
extern void glVertexAttrib3s(GLuint index, GLshort x, GLshort y, GLshort z);
extern void glVertexAttrib3sv(GLuint index, const GLshort* v);
extern void glVertexAttrib4Nbv(GLuint index, const GLbyte* v);
extern void glVertexAttrib4Niv(GLuint index, const GLint* v);
extern void glVertexAttrib4Nsv(GLuint index, const GLshort* v);
extern void glVertexAttrib4Nub(GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w);
extern void glVertexAttrib4Nubv(GLuint index, const GLubyte* v);
extern void glVertexAttrib4Nuiv(GLuint index, const GLuint* v);
extern void glVertexAttrib4Nusv(GLuint index, const GLushort* v);
extern void glVertexAttrib4bv(GLuint index, const GLbyte* v);
extern void glVertexAttrib4d(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
extern void glVertexAttrib4dv(GLuint index, const GLdouble* v);
extern void glVertexAttrib4f(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
extern void glVertexAttrib4fv(GLuint index, const GLfloat* v);
extern void glVertexAttrib4iv(GLuint index, const GLint* v);
extern void glVertexAttrib4s(GLuint index, GLshort x, GLshort y, GLshort z, GLshort w);
extern void glVertexAttrib4sv(GLuint index, const GLshort* v);
extern void glVertexAttrib4ubv(GLuint index, const GLubyte* v);
extern void glVertexAttrib4uiv(GLuint index, const GLuint* v);
extern void glVertexAttrib4usv(GLuint index, const GLushort* v);
extern void glVertexAttribPointer(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const GLvoid* pointer);
extern void glUniformMatrix2x3fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
extern void glUniformMatrix2x4fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
extern void glUniformMatrix3x2fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
extern void glUniformMatrix3x4fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
extern void glUniformMatrix4x2fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
extern void glUniformMatrix4x3fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
extern void glBeginConditionalRender(GLuint, GLenum);
extern void glBeginTransformFeedback(GLenum);
extern void glBindFragDataLocation(GLuint, GLuint, const GLchar*);
extern void glClampColor(GLenum, GLenum);
extern void glClearBufferfi(GLenum, GLint, GLfloat, GLint);
extern void glClearBufferfv(GLenum, GLint, const GLfloat*);
extern void glClearBufferiv(GLenum, GLint, const GLint*);
extern void glClearBufferuiv(GLenum, GLint, const GLuint*);
extern void glColorMaski(GLuint, GLboolean, GLboolean, GLboolean, GLboolean);
extern void glDisablei(GLenum, GLuint);
extern void glEnablei(GLenum, GLuint);
extern void glEndConditionalRender(void);
extern void glEndTransformFeedback(void);
extern void glGetBooleani_v(GLenum, GLuint, GLboolean*);
extern GLint glGetFragDataLocation(GLuint, const GLchar*);
extern const GLubyte* glGetStringi(GLenum, GLuint);
extern void glGetTexParameterIiv(GLenum, GLenum, GLint*);
extern void glGetTexParameterIuiv(GLenum, GLenum, GLuint*);
extern void glGetTransformFeedbackVarying(GLuint, GLuint, GLsizei, GLsizei *, GLsizei *, GLenum *, GLchar *);
extern void glGetUniformuiv(GLuint, GLint, GLuint*);
extern void glGetVertexAttribIiv(GLuint, GLenum, GLint*);
extern void glGetVertexAttribIuiv(GLuint, GLenum, GLuint*);
extern GLboolean glIsEnabledi(GLenum, GLuint);
extern void glTexParameterIiv(GLenum, GLenum, const GLint*);
extern void glTexParameterIuiv(GLenum, GLenum, const GLuint*);
extern void glTransformFeedbackVaryings(GLuint, GLsizei, const GLchar **, GLenum);
extern void glUniform1ui(GLint, GLuint);
extern void glUniform1uiv(GLint, GLsizei, const GLuint*);
extern void glUniform2ui(GLint, GLuint, GLuint);
extern void glUniform2uiv(GLint, GLsizei, const GLuint*);
extern void glUniform3ui(GLint, GLuint, GLuint, GLuint);
extern void glUniform3uiv(GLint, GLsizei, const GLuint*);
extern void glUniform4ui(GLint, GLuint, GLuint, GLuint, GLuint);
extern void glUniform4uiv(GLint, GLsizei, const GLuint*);
extern void glVertexAttribI1i(GLuint, GLint);
extern void glVertexAttribI1iv(GLuint, const GLint*);
extern void glVertexAttribI1ui(GLuint, GLuint);
extern void glVertexAttribI1uiv(GLuint, const GLuint*);
extern void glVertexAttribI2i(GLuint, GLint, GLint);
extern void glVertexAttribI2iv(GLuint, const GLint*);
extern void glVertexAttribI2ui(GLuint, GLuint, GLuint);
extern void glVertexAttribI2uiv(GLuint, const GLuint*);
extern void glVertexAttribI3i(GLuint, GLint, GLint, GLint);
extern void glVertexAttribI3iv(GLuint, const GLint*);
extern void glVertexAttribI3ui(GLuint, GLuint, GLuint, GLuint);
extern void glVertexAttribI3uiv(GLuint, const GLuint*);
extern void glVertexAttribI4bv(GLuint, const GLbyte*);
extern void glVertexAttribI4i(GLuint, GLint, GLint, GLint, GLint);
extern void glVertexAttribI4iv(GLuint, const GLint*);
extern void glVertexAttribI4sv(GLuint, const GLshort*);
extern void glVertexAttribI4ubv(GLuint, const GLubyte*);
extern void glVertexAttribI4ui(GLuint, GLuint, GLuint, GLuint, GLuint);
extern void glVertexAttribI4uiv(GLuint, const GLuint*);
extern void glVertexAttribI4usv(GLuint, const GLushort*);
extern void glVertexAttribIPointer(GLuint, GLint, GLenum, GLsizei, const GLvoid*);
extern void glDrawArraysInstanced(GLenum, GLint, GLsizei, GLsizei);
extern void glDrawElementsInstanced(GLenum, GLsizei, GLenum, const GLvoid*, GLsizei);
extern void glPrimitiveRestartIndex(GLuint);
extern void glTexBuffer(GLenum, GLenum, GLuint);
extern void glFramebufferTexture(GLenum, GLenum, GLuint, GLint);
extern void glGetBufferParameteri64v(GLenum, GLenum, GLint64 *);
extern void glGetInteger64i_v(GLenum, GLuint, GLint64 *);
extern void glVertexAttribDivisor(GLuint index, GLuint divisor);
extern void glBlendEquationSeparatei(GLuint buf, GLenum modeRGB, GLenum modeAlpha);
extern void glBlendEquationi(GLuint buf, GLenum mode);
extern void glBlendFuncSeparatei(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha);
extern void glBlendFunci(GLuint buf, GLenum src, GLenum dst);
extern void glMinSampleShading(GLclampf value);
extern void glDebugMessageEnableAMD(GLenum category, GLenum severity, GLsizei count, const GLuint* ids, GLboolean enabled);
extern void glBlendEquationIndexedAMD(GLuint buf, GLenum mode);
extern void glBlendEquationSeparateIndexedAMD(GLuint buf, GLenum modeRGB, GLenum modeAlpha);
extern void glBlendFuncIndexedAMD(GLuint buf, GLenum src, GLenum dst);
extern void glBlendFuncSeparateIndexedAMD(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha);
extern void glVertexAttribParameteriAMD(GLuint index, GLenum pname, GLint param);
extern void glDeleteNamesAMD(GLenum identifier, GLuint num, const GLuint* names);
extern void glGenNamesAMD(GLenum identifier, GLuint num, GLuint* names);
extern GLboolean glIsNameAMD(GLenum identifier, GLuint name);
extern void glBeginPerfMonitorAMD(GLuint monitor);
extern void glDeletePerfMonitorsAMD(GLsizei n, GLuint* monitors);
extern void glEndPerfMonitorAMD(GLuint monitor);
extern void glGenPerfMonitorsAMD(GLsizei n, GLuint* monitors);
extern void glGetPerfMonitorCounterDataAMD(GLuint monitor, GLenum pname, GLsizei dataSize, GLuint* data, GLint *bytesWritten);
extern void glGetPerfMonitorCounterInfoAMD(GLuint group, GLuint counter, GLenum pname, void* data);
extern void glGetPerfMonitorCounterStringAMD(GLuint group, GLuint counter, GLsizei bufSize, GLsizei* length, GLchar *counterString);
extern void glGetPerfMonitorCountersAMD(GLuint group, GLint* numCounters, GLint *maxActiveCounters, GLsizei countersSize, GLuint *counters);
extern void glGetPerfMonitorGroupStringAMD(GLuint group, GLsizei bufSize, GLsizei* length, GLchar *groupString);
extern void glGetPerfMonitorGroupsAMD(GLint* numGroups, GLsizei groupsSize, GLuint *groups);
extern void glSelectPerfMonitorCountersAMD(GLuint monitor, GLboolean enable, GLuint group, GLint numCounters, GLuint* counterList);
extern void glSetMultisamplefvAMD(GLenum pname, GLuint index, const GLfloat* val);
extern void glTexStorageSparseAMD(GLenum target, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLsizei layers, GLbitfield flags);
extern void glTextureStorageSparseAMD(GLuint texture, GLenum target, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLsizei layers, GLbitfield flags);
extern void glStencilOpValueAMD(GLenum face, GLuint value);
extern void glTessellationFactorAMD(GLfloat factor);
extern void glTessellationModeAMD(GLenum mode);
extern void glClearDepthf(GLclampf d);
extern void glDepthRangef(GLclampf n, GLclampf f);
extern void glGetShaderPrecisionFormat(GLenum shadertype, GLenum precisiontype, GLint* range, GLint *precision);
extern void glReleaseShaderCompiler(void);
extern void glShaderBinary(GLsizei count, const GLuint* shaders, GLenum binaryformat, const GLvoid*binary, GLsizei length);
extern void glDrawArraysInstancedBaseInstance(GLenum mode, GLint first, GLsizei count, GLsizei primcount, GLuint baseinstance);
extern void glDrawElementsInstancedBaseInstance(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices, GLsizei primcount, GLuint baseinstance);
extern void glDrawElementsInstancedBaseVertexBaseInstance(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices, GLsizei primcount, GLint basevertex, GLuint baseinstance);
extern GLuint64 glGetImageHandleARB(GLuint texture, GLint level, GLboolean layered, GLint layer, GLenum format);
extern GLuint64 glGetTextureHandleARB(GLuint texture);
extern GLuint64 glGetTextureSamplerHandleARB(GLuint texture, GLuint sampler);
extern void glGetVertexAttribLui64vARB(GLuint index, GLenum pname, GLuint64EXT* params);
extern GLboolean glIsImageHandleResidentARB(GLuint64 handle);
extern GLboolean glIsTextureHandleResidentARB(GLuint64 handle);
extern void glMakeImageHandleNonResidentARB(GLuint64 handle);
extern void glMakeImageHandleResidentARB(GLuint64 handle, GLenum access);
extern void glMakeTextureHandleNonResidentARB(GLuint64 handle);
extern void glMakeTextureHandleResidentARB(GLuint64 handle);
extern void glProgramUniformHandleui64ARB(GLuint program, GLint location, GLuint64 value);
extern void glProgramUniformHandleui64vARB(GLuint program, GLint location, GLsizei count, const GLuint64* values);
extern void glUniformHandleui64ARB(GLint location, GLuint64 value);
extern void glUniformHandleui64vARB(GLint location, GLsizei count, const GLuint64* value);
extern void glVertexAttribL1ui64ARB(GLuint index, GLuint64EXT x);
extern void glVertexAttribL1ui64vARB(GLuint index, const GLuint64EXT* v);
extern void glBindFragDataLocationIndexed(GLuint program, GLuint colorNumber, GLuint index, const GLchar * name);
extern GLint glGetFragDataIndex(GLuint program, const GLchar * name);
extern void glBufferStorage(GLenum target, GLsizeiptr size, const GLvoid* data, GLbitfield flags);
extern void glNamedBufferStorageEXT(GLuint buffer, GLsizeiptr size, const GLvoid* data, GLbitfield flags);
extern GLsync glCreateSyncFromCLeventARB(cl_context context, cl_event event, GLbitfield flags);
extern void glClearBufferData(GLenum target, GLenum internalformat, GLenum format, GLenum type, const GLvoid* data);
extern void glClearBufferSubData(GLenum target, GLenum internalformat, GLintptr offset, GLsizeiptr size, GLenum format, GLenum type, const GLvoid* data);
extern void glClearNamedBufferDataEXT(GLuint buffer, GLenum internalformat, GLenum format, GLenum type, const GLvoid* data);
extern void glClearNamedBufferSubDataEXT(GLuint buffer, GLenum internalformat, GLintptr offset, GLsizeiptr size, GLenum format, GLenum type, const GLvoid* data);
extern void glClearTexImage(GLuint texture, GLint level, GLenum format, GLenum type, const GLvoid* data);
extern void glClearTexSubImage(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid* data);
extern void glDispatchCompute(GLuint num_groups_x, GLuint num_groups_y, GLuint num_groups_z);
extern void glDispatchComputeIndirect(GLintptr indirect);
extern void glDispatchComputeGroupSizeARB(GLuint num_groups_x, GLuint num_groups_y, GLuint num_groups_z, GLuint group_size_x, GLuint group_size_y, GLuint group_size_z);
extern void glCopyBufferSubData(GLenum readtarget, GLenum writetarget, GLintptr readoffset, GLintptr writeoffset, GLsizeiptr size);
extern void glCopyImageSubData(GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei srcWidth, GLsizei srcHeight, GLsizei srcDepth);
extern void glDrawElementsBaseVertex(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices, GLint basevertex);
extern void glDrawElementsInstancedBaseVertex(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices, GLsizei primcount, GLint basevertex);
extern void glDrawRangeElementsBaseVertex(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid *indices, GLint basevertex);
extern void glMultiDrawElementsBaseVertex(GLenum mode, const GLsizei* count, GLenum type, const GLvoid* const *indices, GLsizei primcount, const GLint *basevertex);
extern void glDrawArraysIndirect(GLenum mode, const GLvoid *indirect);
extern void glDrawElementsIndirect(GLenum mode, GLenum type, const GLvoid *indirect);
extern void glFramebufferParameteri(GLenum target, GLenum pname, GLint param);
extern void glGetFramebufferParameteriv(GLenum target, GLenum pname, GLint* params);
extern void glGetNamedFramebufferParameterivEXT(GLuint framebuffer, GLenum pname, GLint* params);
extern void glNamedFramebufferParameteriEXT(GLuint framebuffer, GLenum pname, GLint param);
extern void glBindFramebuffer(GLenum target, GLuint framebuffer);
extern void glBindRenderbuffer(GLenum target, GLuint renderbuffer);
extern void glBlitFramebuffer(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter);
extern GLenum glCheckFramebufferStatus(GLenum target);
extern void glDeleteFramebuffers(GLsizei n, const GLuint* framebuffers);
extern void glDeleteRenderbuffers(GLsizei n, const GLuint* renderbuffers);
extern void glFramebufferRenderbuffer(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer);
extern void glFramebufferTexture1D(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level);
extern void glFramebufferTexture2D(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level);
extern void glFramebufferTexture3D(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint layer);
extern void glFramebufferTextureLayer(GLenum target,GLenum attachment, GLuint texture,GLint level,GLint layer);
extern void glGenFramebuffers(GLsizei n, GLuint* framebuffers);
extern void glGenRenderbuffers(GLsizei n, GLuint* renderbuffers);
extern void glGenerateMipmap(GLenum target);
extern void glGetFramebufferAttachmentParameteriv(GLenum target, GLenum attachment, GLenum pname, GLint* params);
extern void glGetRenderbufferParameteriv(GLenum target, GLenum pname, GLint* params);
extern GLboolean glIsFramebuffer(GLuint framebuffer);
extern GLboolean glIsRenderbuffer(GLuint renderbuffer);
extern void glRenderbufferStorage(GLenum target, GLenum internalformat, GLsizei width, GLsizei height);
extern void glRenderbufferStorageMultisample(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height);
extern void glFramebufferTextureFaceARB(GLenum target, GLenum attachment, GLuint texture, GLint level, GLenum face);
extern void glGetProgramBinary(GLuint program, GLsizei bufSize, GLsizei* length, GLenum *binaryFormat, GLvoid*binary);
extern void glProgramBinary(GLuint program, GLenum binaryFormat, const GLvoid *binary, GLsizei length);
extern void glProgramParameteri(GLuint program, GLenum pname, GLint value);
extern void glGetUniformdv(GLuint program, GLint location, GLdouble* params);
extern void glUniform1d(GLint location, GLdouble x);
extern void glUniform1dv(GLint location, GLsizei count, const GLdouble* value);
extern void glUniform2d(GLint location, GLdouble x, GLdouble y);
extern void glUniform2dv(GLint location, GLsizei count, const GLdouble* value);
extern void glUniform3d(GLint location, GLdouble x, GLdouble y, GLdouble z);
extern void glUniform3dv(GLint location, GLsizei count, const GLdouble* value);
extern void glUniform4d(GLint location, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
extern void glUniform4dv(GLint location, GLsizei count, const GLdouble* value);
extern void glUniformMatrix2dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble* value);
extern void glUniformMatrix2x3dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble* value);
extern void glUniformMatrix2x4dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble* value);
extern void glUniformMatrix3dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble* value);
extern void glUniformMatrix3x2dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble* value);
extern void glUniformMatrix3x4dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble* value);
extern void glUniformMatrix4dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble* value);
extern void glUniformMatrix4x2dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble* value);
extern void glUniformMatrix4x3dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble* value);
extern void glColorSubTable(GLenum target, GLsizei start, GLsizei count, GLenum format, GLenum type, const GLvoid *data);
extern void glColorTable(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid *table);
extern void glColorTableParameterfv(GLenum target, GLenum pname, const GLfloat *params);
extern void glColorTableParameteriv(GLenum target, GLenum pname, const GLint *params);
extern void glConvolutionFilter1D(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid *image);
extern void glConvolutionFilter2D(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *image);
extern void glConvolutionParameterf(GLenum target, GLenum pname, GLfloat params);
extern void glConvolutionParameterfv(GLenum target, GLenum pname, const GLfloat *params);
extern void glConvolutionParameteri(GLenum target, GLenum pname, GLint params);
extern void glConvolutionParameteriv(GLenum target, GLenum pname, const GLint *params);
extern void glCopyColorSubTable(GLenum target, GLsizei start, GLint x, GLint y, GLsizei width);
extern void glCopyColorTable(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width);
extern void glCopyConvolutionFilter1D(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width);
extern void glCopyConvolutionFilter2D(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height);
extern void glGetColorTable(GLenum target, GLenum format, GLenum type, GLvoid *table);
extern void glGetColorTableParameterfv(GLenum target, GLenum pname, GLfloat *params);
extern void glGetColorTableParameteriv(GLenum target, GLenum pname, GLint *params);
extern void glGetConvolutionFilter(GLenum target, GLenum format, GLenum type, GLvoid *image);
extern void glGetConvolutionParameterfv(GLenum target, GLenum pname, GLfloat *params);
extern void glGetConvolutionParameteriv(GLenum target, GLenum pname, GLint *params);
extern void glGetHistogram(GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid *values);
extern void glGetHistogramParameterfv(GLenum target, GLenum pname, GLfloat *params);
extern void glGetHistogramParameteriv(GLenum target, GLenum pname, GLint *params);
extern void glGetMinmax(GLenum target, GLboolean reset, GLenum format, GLenum types, GLvoid *values);
extern void glGetMinmaxParameterfv(GLenum target, GLenum pname, GLfloat *params);
extern void glGetMinmaxParameteriv(GLenum target, GLenum pname, GLint *params);
extern void glGetSeparableFilter(GLenum target, GLenum format, GLenum type, GLvoid *row, GLvoid *column, GLvoid *span);
extern void glHistogram(GLenum target, GLsizei width, GLenum internalformat, GLboolean sink);
extern void glMinmax(GLenum target, GLenum internalformat, GLboolean sink);
extern void glResetHistogram(GLenum target);
extern void glResetMinmax(GLenum target);
extern void glSeparableFilter2D(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *row, const GLvoid *column);
extern void glMultiDrawArraysIndirectCountARB(GLenum mode, const GLvoid *indirect, GLintptr drawcount, GLsizei maxdrawcount, GLsizei stride);
extern void glMultiDrawElementsIndirectCountARB(GLenum mode, GLenum type, const GLvoid *indirect, GLintptr drawcount, GLsizei maxdrawcount, GLsizei stride);
extern void glGetInternalformativ(GLenum target, GLenum internalformat, GLenum pname, GLsizei bufSize, GLint* params);
extern void glGetInternalformati64v(GLenum target, GLenum internalformat, GLenum pname, GLsizei bufSize, GLint64* params);
extern void glInvalidateBufferData(GLuint buffer);
extern void glInvalidateBufferSubData(GLuint buffer, GLintptr offset, GLsizeiptr length);
extern void glInvalidateFramebuffer(GLenum target, GLsizei numAttachments, const GLenum* attachments);
extern void glInvalidateSubFramebuffer(GLenum target, GLsizei numAttachments, const GLenum* attachments, GLint x, GLint y, GLsizei width, GLsizei height);
extern void glInvalidateTexImage(GLuint texture, GLint level);
extern void glInvalidateTexSubImage(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth);
extern void glFlushMappedBufferRange(GLenum target, GLintptr offset, GLsizeiptr length);
extern GLvoid * glMapBufferRange(GLenum target, GLintptr offset, GLsizeiptr length, GLbitfield access);
extern void glCurrentPaletteMatrixARB(GLint index);
extern void glMatrixIndexPointerARB(GLint size, GLenum type, GLsizei stride, GLvoid *pointer);
extern void glMatrixIndexubvARB(GLint size, GLubyte *indices);
extern void glMatrixIndexuivARB(GLint size, GLuint *indices);
extern void glMatrixIndexusvARB(GLint size, GLushort *indices);
extern void glBindBuffersBase(GLenum target, GLuint first, GLsizei count, const GLuint* buffers);
extern void glBindBuffersRange(GLenum target, GLuint first, GLsizei count, const GLuint* buffers, const GLintptr *offsets, const GLsizeiptr *sizes);
extern void glBindImageTextures(GLuint first, GLsizei count, const GLuint* textures);
extern void glBindSamplers(GLuint first, GLsizei count, const GLuint* samplers);
extern void glBindTextures(GLuint first, GLsizei count, const GLuint* textures);
extern void glBindVertexBuffers(GLuint first, GLsizei count, const GLuint* buffers, const GLintptr *offsets, const GLsizei *strides);
extern void glMultiDrawArraysIndirect(GLenum mode, const GLvoid *indirect, GLsizei primcount, GLsizei stride);
extern void glMultiDrawElementsIndirect(GLenum mode, GLenum type, const GLvoid *indirect, GLsizei primcount, GLsizei stride);
extern void glGetProgramInterfaceiv(GLuint program, GLenum programInterface, GLenum pname, GLint* params);
extern GLuint glGetProgramResourceIndex(GLuint program, GLenum programInterface, const GLchar* name);
extern GLint glGetProgramResourceLocation(GLuint program, GLenum programInterface, const GLchar* name);
extern GLint glGetProgramResourceLocationIndex(GLuint program, GLenum programInterface, const GLchar* name);
extern void glGetProgramResourceName(GLuint program, GLenum programInterface, GLuint index, GLsizei bufSize, GLsizei* length, GLchar *name);
extern void glGetProgramResourceiv(GLuint program, GLenum programInterface, GLuint index, GLsizei propCount, const GLenum* props, GLsizei bufSize, GLsizei *length, GLint *params);
extern void glProvokingVertex(GLenum mode);
extern GLenum glGetGraphicsResetStatusARB(void);
extern void glGetnColorTableARB(GLenum target, GLenum format, GLenum type, GLsizei bufSize, void* table);
extern void glGetnCompressedTexImageARB(GLenum target, GLint lod, GLsizei bufSize, void* img);
extern void glGetnConvolutionFilterARB(GLenum target, GLenum format, GLenum type, GLsizei bufSize, void* image);
extern void glGetnHistogramARB(GLenum target, GLboolean reset, GLenum format, GLenum type, GLsizei bufSize, void* values);
extern void glGetnMapdvARB(GLenum target, GLenum query, GLsizei bufSize, GLdouble* v);
extern void glGetnMapfvARB(GLenum target, GLenum query, GLsizei bufSize, GLfloat* v);
extern void glGetnMapivARB(GLenum target, GLenum query, GLsizei bufSize, GLint* v);
extern void glGetnMinmaxARB(GLenum target, GLboolean reset, GLenum format, GLenum type, GLsizei bufSize, void* values);
extern void glGetnPixelMapfvARB(GLenum map, GLsizei bufSize, GLfloat* values);
extern void glGetnPixelMapuivARB(GLenum map, GLsizei bufSize, GLuint* values);
extern void glGetnPixelMapusvARB(GLenum map, GLsizei bufSize, GLushort* values);
extern void glGetnPolygonStippleARB(GLsizei bufSize, GLubyte* pattern);
extern void glGetnSeparableFilterARB(GLenum target, GLenum format, GLenum type, GLsizei rowBufSize, void* row, GLsizei columnBufSize, GLvoid*column, GLvoid*span);
extern void glGetnTexImageARB(GLenum target, GLint level, GLenum format, GLenum type, GLsizei bufSize, void* img);
extern void glGetnUniformdvARB(GLuint program, GLint location, GLsizei bufSize, GLdouble* params);
extern void glGetnUniformfvARB(GLuint program, GLint location, GLsizei bufSize, GLfloat* params);
extern void glGetnUniformivARB(GLuint program, GLint location, GLsizei bufSize, GLint* params);
extern void glGetnUniformuivARB(GLuint program, GLint location, GLsizei bufSize, GLuint* params);
extern void glReadnPixelsARB(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLsizei bufSize, void* data);
extern void glBindSampler(GLuint unit, GLuint sampler);
extern void glDeleteSamplers(GLsizei count, const GLuint * samplers);
extern void glGenSamplers(GLsizei count, GLuint* samplers);
extern void glGetSamplerParameterIiv(GLuint sampler, GLenum pname, GLint* params);
extern void glGetSamplerParameterIuiv(GLuint sampler, GLenum pname, GLuint* params);
extern void glGetSamplerParameterfv(GLuint sampler, GLenum pname, GLfloat* params);
extern void glGetSamplerParameteriv(GLuint sampler, GLenum pname, GLint* params);
extern GLboolean glIsSampler(GLuint sampler);
extern void glSamplerParameterIiv(GLuint sampler, GLenum pname, const GLint* params);
extern void glSamplerParameterIuiv(GLuint sampler, GLenum pname, const GLuint* params);
extern void glSamplerParameterf(GLuint sampler, GLenum pname, GLfloat param);
extern void glSamplerParameterfv(GLuint sampler, GLenum pname, const GLfloat* params);
extern void glSamplerParameteri(GLuint sampler, GLenum pname, GLint param);
extern void glSamplerParameteriv(GLuint sampler, GLenum pname, const GLint* params);
extern void glActiveShaderProgram(GLuint pipeline, GLuint program);
extern void glBindProgramPipeline(GLuint pipeline);
extern GLuint glCreateShaderProgramv(GLenum type, GLsizei count, const GLchar ** strings);
extern void glDeleteProgramPipelines(GLsizei n, const GLuint* pipelines);
extern void glGenProgramPipelines(GLsizei n, GLuint* pipelines);
extern void glGetProgramPipelineInfoLog(GLuint pipeline, GLsizei bufSize, GLsizei* length, GLchar *infoLog);
extern void glGetProgramPipelineiv(GLuint pipeline, GLenum pname, GLint* params);
extern GLboolean glIsProgramPipeline(GLuint pipeline);
extern void glProgramUniform1d(GLuint program, GLint location, GLdouble x);
extern void glProgramUniform1dv(GLuint program, GLint location, GLsizei count, const GLdouble* value);
extern void glProgramUniform1f(GLuint program, GLint location, GLfloat x);
extern void glProgramUniform1fv(GLuint program, GLint location, GLsizei count, const GLfloat* value);
extern void glProgramUniform1i(GLuint program, GLint location, GLint x);
extern void glProgramUniform1iv(GLuint program, GLint location, GLsizei count, const GLint* value);
extern void glProgramUniform1ui(GLuint program, GLint location, GLuint x);
extern void glProgramUniform1uiv(GLuint program, GLint location, GLsizei count, const GLuint* value);
extern void glProgramUniform2d(GLuint program, GLint location, GLdouble x, GLdouble y);
extern void glProgramUniform2dv(GLuint program, GLint location, GLsizei count, const GLdouble* value);
extern void glProgramUniform2f(GLuint program, GLint location, GLfloat x, GLfloat y);
extern void glProgramUniform2fv(GLuint program, GLint location, GLsizei count, const GLfloat* value);
extern void glProgramUniform2i(GLuint program, GLint location, GLint x, GLint y);
extern void glProgramUniform2iv(GLuint program, GLint location, GLsizei count, const GLint* value);
extern void glProgramUniform2ui(GLuint program, GLint location, GLuint x, GLuint y);
extern void glProgramUniform2uiv(GLuint program, GLint location, GLsizei count, const GLuint* value);
extern void glProgramUniform3d(GLuint program, GLint location, GLdouble x, GLdouble y, GLdouble z);
extern void glProgramUniform3dv(GLuint program, GLint location, GLsizei count, const GLdouble* value);
extern void glProgramUniform3f(GLuint program, GLint location, GLfloat x, GLfloat y, GLfloat z);
extern void glProgramUniform3fv(GLuint program, GLint location, GLsizei count, const GLfloat* value);
extern void glProgramUniform3i(GLuint program, GLint location, GLint x, GLint y, GLint z);
extern void glProgramUniform3iv(GLuint program, GLint location, GLsizei count, const GLint* value);
extern void glProgramUniform3ui(GLuint program, GLint location, GLuint x, GLuint y, GLuint z);
extern void glProgramUniform3uiv(GLuint program, GLint location, GLsizei count, const GLuint* value);
extern void glProgramUniform4d(GLuint program, GLint location, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
extern void glProgramUniform4dv(GLuint program, GLint location, GLsizei count, const GLdouble* value);
extern void glProgramUniform4f(GLuint program, GLint location, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
extern void glProgramUniform4fv(GLuint program, GLint location, GLsizei count, const GLfloat* value);
extern void glProgramUniform4i(GLuint program, GLint location, GLint x, GLint y, GLint z, GLint w);
extern void glProgramUniform4iv(GLuint program, GLint location, GLsizei count, const GLint* value);
extern void glProgramUniform4ui(GLuint program, GLint location, GLuint x, GLuint y, GLuint z, GLuint w);
extern void glProgramUniform4uiv(GLuint program, GLint location, GLsizei count, const GLuint* value);
extern void glProgramUniformMatrix2dv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble* value);
extern void glProgramUniformMatrix2fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat* value);
extern void glProgramUniformMatrix2x3dv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble* value);
extern void glProgramUniformMatrix2x3fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat* value);
extern void glProgramUniformMatrix2x4dv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble* value);
extern void glProgramUniformMatrix2x4fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat* value);
extern void glProgramUniformMatrix3dv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble* value);
extern void glProgramUniformMatrix3fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat* value);
extern void glProgramUniformMatrix3x2dv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble* value);
extern void glProgramUniformMatrix3x2fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat* value);
extern void glProgramUniformMatrix3x4dv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble* value);
extern void glProgramUniformMatrix3x4fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat* value);
extern void glProgramUniformMatrix4dv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble* value);
extern void glProgramUniformMatrix4fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat* value);
extern void glProgramUniformMatrix4x2dv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble* value);
extern void glProgramUniformMatrix4x2fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat* value);
extern void glProgramUniformMatrix4x3dv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble* value);
extern void glProgramUniformMatrix4x3fv(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat* value);
extern void glUseProgramStages(GLuint pipeline, GLbitfield stages, GLuint program);
extern void glValidateProgramPipeline(GLuint pipeline);
extern void glGetActiveAtomicCounterBufferiv(GLuint program, GLuint bufferIndex, GLenum pname, GLint* params);
extern void glBindImageTexture(GLuint unit, GLuint texture, GLint level, GLboolean layered, GLint layer, GLenum access, GLenum format);
extern void glMemoryBarrier(GLbitfield barriers);
extern void glAttachObjectARB(GLhandleARB containerObj, GLhandleARB obj);
extern GLhandleARB glCreateProgramObjectARB(void);
extern GLhandleARB glCreateShaderObjectARB(GLenum shaderType);
extern void glDeleteObjectARB(GLhandleARB obj);
extern void glDetachObjectARB(GLhandleARB containerObj, GLhandleARB attachedObj);
extern void glGetAttachedObjectsARB(GLhandleARB containerObj, GLsizei maxCount, GLsizei* count, GLhandleARB *obj);
extern GLhandleARB glGetHandleARB(GLenum pname);
extern void glGetInfoLogARB(GLhandleARB obj, GLsizei maxLength, GLsizei* length, GLcharARB *infoLog);
extern void glGetObjectParameterfvARB(GLhandleARB obj, GLenum pname, GLfloat* params);
extern void glGetObjectParameterivARB(GLhandleARB obj, GLenum pname, GLint* params);
extern void glUseProgramObjectARB(GLhandleARB programObj);
extern void glShaderStorageBlockBinding(GLuint program, GLuint storageBlockIndex, GLuint storageBlockBinding);
extern void glGetActiveSubroutineName(GLuint program, GLenum shadertype, GLuint index, GLsizei bufsize, GLsizei* length, GLchar *name);
extern void glGetActiveSubroutineUniformName(GLuint program, GLenum shadertype, GLuint index, GLsizei bufsize, GLsizei* length, GLchar *name);
extern void glGetActiveSubroutineUniformiv(GLuint program, GLenum shadertype, GLuint index, GLenum pname, GLint* values);
extern void glGetProgramStageiv(GLuint program, GLenum shadertype, GLenum pname, GLint* values);
extern GLuint glGetSubroutineIndex(GLuint program, GLenum shadertype, const GLchar* name);
extern GLint glGetSubroutineUniformLocation(GLuint program, GLenum shadertype, const GLchar* name);
extern void glGetUniformSubroutineuiv(GLenum shadertype, GLint location, GLuint* params);
extern void glUniformSubroutinesuiv(GLenum shadertype, GLsizei count, const GLuint* indices);
extern void glCompileShaderIncludeARB(GLuint shader, GLsizei count, const GLchar* const *path, const GLint *length);
extern void glDeleteNamedStringARB(GLint namelen, const GLchar* name);
extern void glGetNamedStringARB(GLint namelen, const GLchar* name, GLsizei bufSize, GLint *stringlen, GLchar *string);
extern void glGetNamedStringivARB(GLint namelen, const GLchar* name, GLenum pname, GLint *params);
extern GLboolean glIsNamedStringARB(GLint namelen, const GLchar* name);
extern void glNamedStringARB(GLenum type, GLint namelen, const GLchar* name, GLint stringlen, const GLchar *string);
extern void glTexPageCommitmentARB(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLboolean commit);
extern void glTexturePageCommitmentEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLboolean commit);
extern GLenum glClientWaitSync(GLsync GLsync,GLbitfield flags,GLuint64 timeout);
extern void glDeleteSync(GLsync GLsync);
extern GLsync glFenceSync(GLenum condition,GLbitfield flags);
extern void glGetInteger64v(GLenum pname, GLint64* params);
extern void glGetSynciv(GLsync GLsync,GLenum pname,GLsizei bufSize,GLsizei* length, GLint *values);
extern GLboolean glIsSync(GLsync GLsync);
extern void glWaitSync(GLsync GLsync,GLbitfield flags,GLuint64 timeout);
extern void glPatchParameterfv(GLenum pname, const GLfloat* values);
extern void glPatchParameteri(GLenum pname, GLint value);
extern void glTexBufferRange(GLenum target, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size);
extern void glTextureBufferRangeEXT(GLuint texture, GLenum target, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size);
extern void glGetMultisamplefv(GLenum pname, GLuint index, GLfloat* val);
extern void glSampleMaski(GLuint index, GLbitfield mask);
extern void glTexImage2DMultisample(GLenum target, GLsizei samples, GLint internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations);
extern void glTexImage3DMultisample(GLenum target, GLsizei samples, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations);
extern void glTexStorage1D(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width);
extern void glTexStorage2D(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height);
extern void glTexStorage3D(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth);
extern void glTextureStorage1DEXT(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width);
extern void glTextureStorage2DEXT(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height);
extern void glTextureStorage3DEXT(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth);
extern void glTexStorage2DMultisample(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations);
extern void glTexStorage3DMultisample(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations);
extern void glTextureStorage2DMultisampleEXT(GLuint texture, GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations);
extern void glTextureStorage3DMultisampleEXT(GLuint texture, GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations);
extern void glTextureView(GLuint texture, GLenum target, GLuint origtexture, GLenum internalformat, GLuint minlevel, GLuint numlevels, GLuint minlayer, GLuint numlayers);
extern void glGetQueryObjecti64v(GLuint id, GLenum pname, GLint64* params);
extern void glGetQueryObjectui64v(GLuint id, GLenum pname, GLuint64* params);
extern void glQueryCounter(GLuint id, GLenum target);
extern void glBindTransformFeedback(GLenum target, GLuint id);
extern void glDeleteTransformFeedbacks(GLsizei n, const GLuint* ids);
extern void glDrawTransformFeedback(GLenum mode, GLuint id);
extern void glGenTransformFeedbacks(GLsizei n, GLuint* ids);
extern GLboolean glIsTransformFeedback(GLuint id);
extern void glPauseTransformFeedback(void);
extern void glResumeTransformFeedback(void);
extern void glBeginQueryIndexed(GLenum target, GLuint index, GLuint id);
extern void glDrawTransformFeedbackStream(GLenum mode, GLuint id, GLuint stream);
extern void glEndQueryIndexed(GLenum target, GLuint index);
extern void glGetQueryIndexediv(GLenum target, GLuint index, GLenum pname, GLint* params);
extern void glDrawTransformFeedbackInstanced(GLenum mode, GLuint id, GLsizei primcount);
extern void glDrawTransformFeedbackStreamInstanced(GLenum mode, GLuint id, GLuint stream, GLsizei primcount);
extern void glBindBufferBase(GLenum target, GLuint index, GLuint buffer);
extern void glBindBufferRange(GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size);
extern void glGetActiveUniformBlockName(GLuint program, GLuint uniformBlockIndex, GLsizei bufSize, GLsizei* length, GLchar* uniformBlockName);
extern void glGetActiveUniformBlockiv(GLuint program, GLuint uniformBlockIndex, GLenum pname, GLint* params);
extern void glGetActiveUniformName(GLuint program, GLuint uniformIndex, GLsizei bufSize, GLsizei* length, GLchar* uniformName);
extern void glGetActiveUniformsiv(GLuint program, GLsizei uniformCount, const GLuint* uniformIndices, GLenum pname, GLint* params);
extern void glGetIntegeri_v(GLenum target, GLuint index, GLint* data);
extern GLuint glGetUniformBlockIndex(GLuint program, const GLchar* uniformBlockName);
extern void glGetUniformIndices(GLuint program, GLsizei uniformCount, const GLchar** uniformNames, GLuint* uniformIndices);
extern void glUniformBlockBinding(GLuint program, GLuint uniformBlockIndex, GLuint uniformBlockBinding);
extern void glBindVertexArray(GLuint array);
extern void glDeleteVertexArrays(GLsizei n, const GLuint* arrays);
extern void glGenVertexArrays(GLsizei n, GLuint* arrays);
extern GLboolean glIsVertexArray(GLuint array);
extern void glGetVertexAttribLdv(GLuint index, GLenum pname, GLdouble* params);
extern void glVertexAttribL1d(GLuint index, GLdouble x);
extern void glVertexAttribL1dv(GLuint index, const GLdouble* v);
extern void glVertexAttribL2d(GLuint index, GLdouble x, GLdouble y);
extern void glVertexAttribL2dv(GLuint index, const GLdouble* v);
extern void glVertexAttribL3d(GLuint index, GLdouble x, GLdouble y, GLdouble z);
extern void glVertexAttribL3dv(GLuint index, const GLdouble* v);
extern void glVertexAttribL4d(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
extern void glVertexAttribL4dv(GLuint index, const GLdouble* v);
extern void glVertexAttribLPointer(GLuint index, GLint size, GLenum type, GLsizei stride, const void* pointer);
extern void glBindVertexBuffer(GLuint bindingindex, GLuint buffer, GLintptr offset, GLsizei stride);
extern void glVertexAttribBinding(GLuint attribindex, GLuint bindingindex);
extern void glVertexAttribFormat(GLuint attribindex, GLint size, GLenum type, GLboolean normalized, GLuint relativeoffset);
extern void glVertexAttribIFormat(GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset);
extern void glVertexAttribLFormat(GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset);
extern void glVertexBindingDivisor(GLuint bindingindex, GLuint divisor);
extern void glVertexBlendARB(GLint count);
extern void glWeightPointerARB(GLint size, GLenum type, GLsizei stride, GLvoid *pointer);
extern void glWeightbvARB(GLint size, GLbyte *weights);
extern void glWeightdvARB(GLint size, GLdouble *weights);
extern void glWeightfvARB(GLint size, GLfloat *weights);
extern void glWeightivARB(GLint size, GLint *weights);
extern void glWeightsvARB(GLint size, GLshort *weights);
extern void glWeightubvARB(GLint size, GLubyte *weights);
extern void glWeightuivARB(GLint size, GLuint *weights);
extern void glWeightusvARB(GLint size, GLushort *weights);
extern void glBindProgramARB(GLenum target, GLuint program);
extern void glDeleteProgramsARB(GLsizei n, const GLuint* programs);
extern void glGenProgramsARB(GLsizei n, GLuint* programs);
extern void glGetProgramEnvParameterdvARB(GLenum target, GLuint index, GLdouble* params);
extern void glGetProgramEnvParameterfvARB(GLenum target, GLuint index, GLfloat* params);
extern void glGetProgramLocalParameterdvARB(GLenum target, GLuint index, GLdouble* params);
extern void glGetProgramLocalParameterfvARB(GLenum target, GLuint index, GLfloat* params);
extern void glGetProgramStringARB(GLenum target, GLenum pname, GLvoid *string);
extern void glProgramEnvParameter4dARB(GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
extern void glProgramEnvParameter4dvARB(GLenum target, GLuint index, const GLdouble* params);
extern void glProgramEnvParameter4fARB(GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
extern void glProgramEnvParameter4fvARB(GLenum target, GLuint index, const GLfloat* params);
extern void glProgramLocalParameter4dARB(GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
extern void glProgramLocalParameter4dvARB(GLenum target, GLuint index, const GLdouble* params);
extern void glProgramLocalParameter4fARB(GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
extern void glProgramLocalParameter4fvARB(GLenum target, GLuint index, const GLfloat* params);
extern void glProgramStringARB(GLenum target, GLenum format, GLsizei len, const GLvoid *string);
extern void glColorP3ui(GLenum type, GLuint color);
extern void glColorP3uiv(GLenum type, const GLuint* color);
extern void glColorP4ui(GLenum type, GLuint color);
extern void glColorP4uiv(GLenum type, const GLuint* color);
extern void glMultiTexCoordP1ui(GLenum texture, GLenum type, GLuint coords);
extern void glMultiTexCoordP1uiv(GLenum texture, GLenum type, const GLuint* coords);
extern void glMultiTexCoordP2ui(GLenum texture, GLenum type, GLuint coords);
extern void glMultiTexCoordP2uiv(GLenum texture, GLenum type, const GLuint* coords);
extern void glMultiTexCoordP3ui(GLenum texture, GLenum type, GLuint coords);
extern void glMultiTexCoordP3uiv(GLenum texture, GLenum type, const GLuint* coords);
extern void glMultiTexCoordP4ui(GLenum texture, GLenum type, GLuint coords);
extern void glMultiTexCoordP4uiv(GLenum texture, GLenum type, const GLuint* coords);
extern void glNormalP3ui(GLenum type, GLuint coords);
extern void glNormalP3uiv(GLenum type, const GLuint* coords);
extern void glSecondaryColorP3ui(GLenum type, GLuint color);
extern void glSecondaryColorP3uiv(GLenum type, const GLuint* color);
extern void glTexCoordP1ui(GLenum type, GLuint coords);
extern void glTexCoordP1uiv(GLenum type, const GLuint* coords);
extern void glTexCoordP2ui(GLenum type, GLuint coords);
extern void glTexCoordP2uiv(GLenum type, const GLuint* coords);
extern void glTexCoordP3ui(GLenum type, GLuint coords);
extern void glTexCoordP3uiv(GLenum type, const GLuint* coords);
extern void glTexCoordP4ui(GLenum type, GLuint coords);
extern void glTexCoordP4uiv(GLenum type, const GLuint* coords);
extern void glVertexAttribP1ui(GLuint index, GLenum type, GLboolean normalized, GLuint value);
extern void glVertexAttribP1uiv(GLuint index, GLenum type, GLboolean normalized, const GLuint* value);
extern void glVertexAttribP2ui(GLuint index, GLenum type, GLboolean normalized, GLuint value);
extern void glVertexAttribP2uiv(GLuint index, GLenum type, GLboolean normalized, const GLuint* value);
extern void glVertexAttribP3ui(GLuint index, GLenum type, GLboolean normalized, GLuint value);
extern void glVertexAttribP3uiv(GLuint index, GLenum type, GLboolean normalized, const GLuint* value);
extern void glVertexAttribP4ui(GLuint index, GLenum type, GLboolean normalized, GLuint value);
extern void glVertexAttribP4uiv(GLuint index, GLenum type, GLboolean normalized, const GLuint* value);
extern void glVertexP2ui(GLenum type, GLuint value);
extern void glVertexP2uiv(GLenum type, const GLuint* value);
extern void glVertexP3ui(GLenum type, GLuint value);
extern void glVertexP3uiv(GLenum type, const GLuint* value);
extern void glVertexP4ui(GLenum type, GLuint value);
extern void glVertexP4uiv(GLenum type, const GLuint* value);
extern void glDepthRangeArrayv(GLuint first, GLsizei count, const GLclampd * v);
extern void glDepthRangeIndexed(GLuint index, GLclampd n, GLclampd f);
extern void glGetDoublei_v(GLenum target, GLuint index, GLdouble* data);
extern void glGetFloati_v(GLenum target, GLuint index, GLfloat* data);
extern void glScissorArrayv(GLuint first, GLsizei count, const GLint * v);
extern void glScissorIndexed(GLuint index, GLint left, GLint bottom, GLsizei width, GLsizei height);
extern void glScissorIndexedv(GLuint index, const GLint * v);
extern void glViewportArrayv(GLuint first, GLsizei count, const GLfloat * v);
extern void glViewportIndexedf(GLuint index, GLfloat x, GLfloat y, GLfloat w, GLfloat h);
extern void glViewportIndexedfv(GLuint index, const GLfloat * v);
extern void glBindMultiTextureEXT(GLenum texunit, GLenum target, GLuint texture);
extern GLenum glCheckNamedFramebufferStatusEXT(GLuint framebuffer, GLenum target);
extern void glClientAttribDefaultEXT(GLbitfield mask);
extern void glCompressedMultiTexImage1DEXT(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const GLvoid *data);
extern void glCompressedMultiTexImage2DEXT(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid *data);
extern void glCompressedMultiTexImage3DEXT(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid *data);
extern void glCompressedMultiTexSubImage1DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid *data);
extern void glCompressedMultiTexSubImage2DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid *data);
extern void glCompressedMultiTexSubImage3DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid *data);
extern void glCompressedTextureImage1DEXT(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const GLvoid *data);
extern void glCompressedTextureImage2DEXT(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid *data);
extern void glCompressedTextureImage3DEXT(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid *data);
extern void glCompressedTextureSubImage1DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid *data);
extern void glCompressedTextureSubImage2DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid *data);
extern void glCompressedTextureSubImage3DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid *data);
extern void glCopyMultiTexImage1DEXT(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border);
extern void glCopyMultiTexImage2DEXT(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border);
extern void glCopyMultiTexSubImage1DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width);
extern void glCopyMultiTexSubImage2DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height);
extern void glCopyMultiTexSubImage3DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height);
extern void glCopyTextureImage1DEXT(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border);
extern void glCopyTextureImage2DEXT(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border);
extern void glCopyTextureSubImage1DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width);
extern void glCopyTextureSubImage2DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height);
extern void glCopyTextureSubImage3DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height);
extern void glDisableClientStateIndexedEXT(GLenum array, GLuint index);
extern void glDisableClientStateiEXT(GLenum array, GLuint index);
extern void glDisableVertexArrayAttribEXT(GLuint vaobj, GLuint index);
extern void glDisableVertexArrayEXT(GLuint vaobj, GLenum array);
extern void glEnableClientStateIndexedEXT(GLenum array, GLuint index);
extern void glEnableClientStateiEXT(GLenum array, GLuint index);
extern void glEnableVertexArrayAttribEXT(GLuint vaobj, GLuint index);
extern void glEnableVertexArrayEXT(GLuint vaobj, GLenum array);
extern void glFlushMappedNamedBufferRangeEXT(GLuint buffer, GLintptr offset, GLsizeiptr length);
extern void glFramebufferDrawBufferEXT(GLuint framebuffer, GLenum mode);
extern void glFramebufferDrawBuffersEXT(GLuint framebuffer, GLsizei n, const GLenum* bufs);
extern void glFramebufferReadBufferEXT(GLuint framebuffer, GLenum mode);
extern void glGenerateMultiTexMipmapEXT(GLenum texunit, GLenum target);
extern void glGenerateTextureMipmapEXT(GLuint texture, GLenum target);
extern void glGetCompressedMultiTexImageEXT(GLenum texunit, GLenum target, GLint level, GLvoid *img);
extern void glGetCompressedTextureImageEXT(GLuint texture, GLenum target, GLint level, GLvoid *img);
extern void glGetDoubleIndexedvEXT(GLenum target, GLuint index, GLdouble* params);
extern void glGetFloatIndexedvEXT(GLenum target, GLuint index, GLfloat* params);
extern void glGetMultiTexEnvfvEXT(GLenum texunit, GLenum target, GLenum pname, GLfloat* params);
extern void glGetMultiTexEnvivEXT(GLenum texunit, GLenum target, GLenum pname, GLint* params);
extern void glGetMultiTexGendvEXT(GLenum texunit, GLenum coord, GLenum pname, GLdouble* params);
extern void glGetMultiTexGenfvEXT(GLenum texunit, GLenum coord, GLenum pname, GLfloat* params);
extern void glGetMultiTexGenivEXT(GLenum texunit, GLenum coord, GLenum pname, GLint* params);
extern void glGetMultiTexImageEXT(GLenum texunit, GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels);
extern void glGetMultiTexLevelParameterfvEXT(GLenum texunit, GLenum target, GLint level, GLenum pname, GLfloat* params);
extern void glGetMultiTexLevelParameterivEXT(GLenum texunit, GLenum target, GLint level, GLenum pname, GLint* params);
extern void glGetMultiTexParameterIivEXT(GLenum texunit, GLenum target, GLenum pname, GLint* params);
extern void glGetMultiTexParameterIuivEXT(GLenum texunit, GLenum target, GLenum pname, GLuint* params);
extern void glGetMultiTexParameterfvEXT(GLenum texunit, GLenum target, GLenum pname, GLfloat* params);
extern void glGetMultiTexParameterivEXT(GLenum texunit, GLenum target, GLenum pname, GLint* params);
extern void glGetNamedBufferParameterivEXT(GLuint buffer, GLenum pname, GLint* params);
extern void glGetNamedBufferPointervEXT(GLuint buffer, GLenum pname, void** params);
extern void glGetNamedBufferSubDataEXT(GLuint buffer, GLintptr offset, GLsizeiptr size, GLvoid *data);
extern void glGetNamedFramebufferAttachmentParameterivEXT(GLuint framebuffer, GLenum attachment, GLenum pname, GLint* params);
extern void glGetNamedProgramLocalParameterIivEXT(GLuint program, GLenum target, GLuint index, GLint* params);
extern void glGetNamedProgramLocalParameterIuivEXT(GLuint program, GLenum target, GLuint index, GLuint* params);
extern void glGetNamedProgramLocalParameterdvEXT(GLuint program, GLenum target, GLuint index, GLdouble* params);
extern void glGetNamedProgramLocalParameterfvEXT(GLuint program, GLenum target, GLuint index, GLfloat* params);
extern void glGetNamedProgramStringEXT(GLuint program, GLenum target, GLenum pname, GLvoid *string);
extern void glGetNamedProgramivEXT(GLuint program, GLenum target, GLenum pname, GLint* params);
extern void glGetNamedRenderbufferParameterivEXT(GLuint renderbuffer, GLenum pname, GLint* params);
extern void glGetPointerIndexedvEXT(GLenum target, GLuint index, GLvoid** params);
extern void glGetPointeri_vEXT(GLenum pname, GLuint index, GLvoid** params);
extern void glGetTextureImageEXT(GLuint texture, GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels);
extern void glGetTextureLevelParameterfvEXT(GLuint texture, GLenum target, GLint level, GLenum pname, GLfloat* params);
extern void glGetTextureLevelParameterivEXT(GLuint texture, GLenum target, GLint level, GLenum pname, GLint* params);
extern void glGetTextureParameterIivEXT(GLuint texture, GLenum target, GLenum pname, GLint* params);
extern void glGetTextureParameterIuivEXT(GLuint texture, GLenum target, GLenum pname, GLuint* params);
extern void glGetTextureParameterfvEXT(GLuint texture, GLenum target, GLenum pname, GLfloat* params);
extern void glGetTextureParameterivEXT(GLuint texture, GLenum target, GLenum pname, GLint* params);
extern void glGetVertexArrayIntegeri_vEXT(GLuint vaobj, GLuint index, GLenum pname, GLint* param);
extern void glGetVertexArrayIntegervEXT(GLuint vaobj, GLenum pname, GLint* param);
extern void glGetVertexArrayPointeri_vEXT(GLuint vaobj, GLuint index, GLenum pname, GLvoid** param);
extern void glGetVertexArrayPointervEXT(GLuint vaobj, GLenum pname, GLvoid** param);
extern GLvoid * glMapNamedBufferEXT(GLuint buffer, GLenum access);
extern GLvoid * glMapNamedBufferRangeEXT(GLuint buffer, GLintptr offset, GLsizeiptr length, GLbitfield access);
extern void glMatrixFrustumEXT(GLenum matrixMode, GLdouble l, GLdouble r, GLdouble b, GLdouble t, GLdouble n, GLdouble f);
extern void glMatrixLoadIdentityEXT(GLenum matrixMode);
extern void glMatrixLoadTransposedEXT(GLenum matrixMode, const GLdouble* m);
extern void glMatrixLoadTransposefEXT(GLenum matrixMode, const GLfloat* m);
extern void glMatrixLoaddEXT(GLenum matrixMode, const GLdouble* m);
extern void glMatrixLoadfEXT(GLenum matrixMode, const GLfloat* m);
extern void glMatrixMultTransposedEXT(GLenum matrixMode, const GLdouble* m);
extern void glMatrixMultTransposefEXT(GLenum matrixMode, const GLfloat* m);
extern void glMatrixMultdEXT(GLenum matrixMode, const GLdouble* m);
extern void glMatrixMultfEXT(GLenum matrixMode, const GLfloat* m);
extern void glMatrixOrthoEXT(GLenum matrixMode, GLdouble l, GLdouble r, GLdouble b, GLdouble t, GLdouble n, GLdouble f);
extern void glMatrixPopEXT(GLenum matrixMode);
extern void glMatrixPushEXT(GLenum matrixMode);
extern void glMatrixRotatedEXT(GLenum matrixMode, GLdouble angle, GLdouble x, GLdouble y, GLdouble z);
extern void glMatrixRotatefEXT(GLenum matrixMode, GLfloat angle, GLfloat x, GLfloat y, GLfloat z);
extern void glMatrixScaledEXT(GLenum matrixMode, GLdouble x, GLdouble y, GLdouble z);
extern void glMatrixScalefEXT(GLenum matrixMode, GLfloat x, GLfloat y, GLfloat z);
extern void glMatrixTranslatedEXT(GLenum matrixMode, GLdouble x, GLdouble y, GLdouble z);
extern void glMatrixTranslatefEXT(GLenum matrixMode, GLfloat x, GLfloat y, GLfloat z);
extern void glMultiTexBufferEXT(GLenum texunit, GLenum target, GLenum internalformat, GLuint buffer);
extern void glMultiTexCoordPointerEXT(GLenum texunit, GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
extern void glMultiTexEnvfEXT(GLenum texunit, GLenum target, GLenum pname, GLfloat param);
extern void glMultiTexEnvfvEXT(GLenum texunit, GLenum target, GLenum pname, const GLfloat* params);
extern void glMultiTexEnviEXT(GLenum texunit, GLenum target, GLenum pname, GLint param);
extern void glMultiTexEnvivEXT(GLenum texunit, GLenum target, GLenum pname, const GLint* params);
extern void glMultiTexGendEXT(GLenum texunit, GLenum coord, GLenum pname, GLdouble param);
extern void glMultiTexGendvEXT(GLenum texunit, GLenum coord, GLenum pname, const GLdouble* params);
extern void glMultiTexGenfEXT(GLenum texunit, GLenum coord, GLenum pname, GLfloat param);
extern void glMultiTexGenfvEXT(GLenum texunit, GLenum coord, GLenum pname, const GLfloat* params);
extern void glMultiTexGeniEXT(GLenum texunit, GLenum coord, GLenum pname, GLint param);
extern void glMultiTexGenivEXT(GLenum texunit, GLenum coord, GLenum pname, const GLint* params);
extern void glMultiTexImage1DEXT(GLenum texunit, GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
extern void glMultiTexImage2DEXT(GLenum texunit, GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
extern void glMultiTexImage3DEXT(GLenum texunit, GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
extern void glMultiTexParameterIivEXT(GLenum texunit, GLenum target, GLenum pname, const GLint* params);
extern void glMultiTexParameterIuivEXT(GLenum texunit, GLenum target, GLenum pname, const GLuint* params);
extern void glMultiTexParameterfEXT(GLenum texunit, GLenum target, GLenum pname, GLfloat param);
extern void glMultiTexParameterfvEXT(GLenum texunit, GLenum target, GLenum pname, const GLfloat* param);
extern void glMultiTexParameteriEXT(GLenum texunit, GLenum target, GLenum pname, GLint param);
extern void glMultiTexParameterivEXT(GLenum texunit, GLenum target, GLenum pname, const GLint* param);
extern void glMultiTexRenderbufferEXT(GLenum texunit, GLenum target, GLuint renderbuffer);
extern void glMultiTexSubImage1DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels);
extern void glMultiTexSubImage2DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels);
extern void glMultiTexSubImage3DEXT(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid *pixels);
extern void glNamedBufferDataEXT(GLuint buffer, GLsizeiptr size, const GLvoid *data, GLenum usage);
extern void glNamedBufferSubDataEXT(GLuint buffer, GLintptr offset, GLsizeiptr size, const GLvoid *data);
extern void glNamedCopyBufferSubDataEXT(GLuint readBuffer, GLuint writeBuffer, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size);
extern void glNamedFramebufferRenderbufferEXT(GLuint framebuffer, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer);
extern void glNamedFramebufferTexture1DEXT(GLuint framebuffer, GLenum attachment, GLenum textarget, GLuint texture, GLint level);
extern void glNamedFramebufferTexture2DEXT(GLuint framebuffer, GLenum attachment, GLenum textarget, GLuint texture, GLint level);
extern void glNamedFramebufferTexture3DEXT(GLuint framebuffer, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset);
extern void glNamedFramebufferTextureEXT(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level);
extern void glNamedFramebufferTextureFaceEXT(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level, GLenum face);
extern void glNamedFramebufferTextureLayerEXT(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level, GLint layer);
extern void glNamedProgramLocalParameter4dEXT(GLuint program, GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
extern void glNamedProgramLocalParameter4dvEXT(GLuint program, GLenum target, GLuint index, const GLdouble* params);
extern void glNamedProgramLocalParameter4fEXT(GLuint program, GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
extern void glNamedProgramLocalParameter4fvEXT(GLuint program, GLenum target, GLuint index, const GLfloat* params);
extern void glNamedProgramLocalParameterI4iEXT(GLuint program, GLenum target, GLuint index, GLint x, GLint y, GLint z, GLint w);
extern void glNamedProgramLocalParameterI4ivEXT(GLuint program, GLenum target, GLuint index, const GLint* params);
extern void glNamedProgramLocalParameterI4uiEXT(GLuint program, GLenum target, GLuint index, GLuint x, GLuint y, GLuint z, GLuint w);
extern void glNamedProgramLocalParameterI4uivEXT(GLuint program, GLenum target, GLuint index, const GLuint* params);
extern void glNamedProgramLocalParameters4fvEXT(GLuint program, GLenum target, GLuint index, GLsizei count, const GLfloat* params);
extern void glNamedProgramLocalParametersI4ivEXT(GLuint program, GLenum target, GLuint index, GLsizei count, const GLint* params);
extern void glNamedProgramLocalParametersI4uivEXT(GLuint program, GLenum target, GLuint index, GLsizei count, const GLuint* params);
extern void glNamedProgramStringEXT(GLuint program, GLenum target, GLenum format, GLsizei len, const GLvoid *string);
extern void glNamedRenderbufferStorageEXT(GLuint renderbuffer, GLenum internalformat, GLsizei width, GLsizei height);
extern void glNamedRenderbufferStorageMultisampleCoverageEXT(GLuint renderbuffer, GLsizei coverageSamples, GLsizei colorSamples, GLenum internalformat, GLsizei width, GLsizei height);
extern void glNamedRenderbufferStorageMultisampleEXT(GLuint renderbuffer, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height);
extern void glPushClientAttribDefaultEXT(GLbitfield mask);
extern void glTextureBufferEXT(GLuint texture, GLenum target, GLenum internalformat, GLuint buffer);
extern void glTextureImage1DEXT(GLuint texture, GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
extern void glTextureImage2DEXT(GLuint texture, GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
extern void glTextureImage3DEXT(GLuint texture, GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
extern void glTextureParameterIivEXT(GLuint texture, GLenum target, GLenum pname, const GLint* params);
extern void glTextureParameterIuivEXT(GLuint texture, GLenum target, GLenum pname, const GLuint* params);
extern void glTextureParameterfEXT(GLuint texture, GLenum target, GLenum pname, GLfloat param);
extern void glTextureParameterfvEXT(GLuint texture, GLenum target, GLenum pname, const GLfloat* param);
extern void glTextureParameteriEXT(GLuint texture, GLenum target, GLenum pname, GLint param);
extern void glTextureParameterivEXT(GLuint texture, GLenum target, GLenum pname, const GLint* param);
extern void glTextureRenderbufferEXT(GLuint texture, GLenum target, GLuint renderbuffer);
extern void glTextureSubImage1DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels);
extern void glTextureSubImage2DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels);
extern void glTextureSubImage3DEXT(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid *pixels);
extern GLboolean glUnmapNamedBufferEXT(GLuint buffer);
extern void glVertexArrayColorOffsetEXT(GLuint vaobj, GLuint buffer, GLint size, GLenum type, GLsizei stride, GLintptr offset);
extern void glVertexArrayEdgeFlagOffsetEXT(GLuint vaobj, GLuint buffer, GLsizei stride, GLintptr offset);
extern void glVertexArrayFogCoordOffsetEXT(GLuint vaobj, GLuint buffer, GLenum type, GLsizei stride, GLintptr offset);
extern void glVertexArrayIndexOffsetEXT(GLuint vaobj, GLuint buffer, GLenum type, GLsizei stride, GLintptr offset);
extern void glVertexArrayMultiTexCoordOffsetEXT(GLuint vaobj, GLuint buffer, GLenum texunit, GLint size, GLenum type, GLsizei stride, GLintptr offset);
extern void glVertexArrayNormalOffsetEXT(GLuint vaobj, GLuint buffer, GLenum type, GLsizei stride, GLintptr offset);
extern void glVertexArraySecondaryColorOffsetEXT(GLuint vaobj, GLuint buffer, GLint size, GLenum type, GLsizei stride, GLintptr offset);
extern void glVertexArrayTexCoordOffsetEXT(GLuint vaobj, GLuint buffer, GLint size, GLenum type, GLsizei stride, GLintptr offset);
extern void glVertexArrayVertexAttribIOffsetEXT(GLuint vaobj, GLuint buffer, GLuint index, GLint size, GLenum type, GLsizei stride, GLintptr offset);
extern void glVertexArrayVertexAttribOffsetEXT(GLuint vaobj, GLuint buffer, GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, GLintptr offset);
extern void glVertexArrayVertexOffsetEXT(GLuint vaobj, GLuint buffer, GLint size, GLenum type, GLsizei stride, GLintptr offset);
extern void glDebugMessageCallback(GLDEBUGPROC callback, const GLvoid *userParam);
extern void glDebugMessageControl(GLenum source, GLenum type, GLenum severity, GLsizei count, const GLuint* ids, GLboolean enabled);
extern void glDebugMessageInsert(GLenum source, GLenum type, GLuint id, GLenum severity, GLsizei length, const GLchar* buf);
extern GLuint glGetDebugMessageLog(GLuint count, GLsizei bufsize, GLenum* sources, GLenum* types, GLuint* ids, GLenum* severities, GLsizei* lengths, GLchar* messageLog);
extern void glGetObjectLabel(GLenum identifier, GLuint name, GLsizei bufSize, GLsizei* length, GLchar *label);
extern void glGetObjectPtrLabel(void* ptr, GLsizei bufSize, GLsizei* length, GLchar *label);
extern void glObjectLabel(GLenum identifier, GLuint name, GLsizei length, const GLchar* label);
extern void glObjectPtrLabel(void* ptr, GLsizei length, const GLchar* label);
extern void glPopDebugGroup(void);
extern void glPushDebugGroup(GLenum source, GLuint id, GLsizei length, const GLchar * message);
extern void glMultiDrawArraysIndirectBindlessNV(GLenum mode, const GLvoid *indirect, GLsizei drawCount, GLsizei stride, GLint vertexBufferCount);
extern void glMultiDrawElementsIndirectBindlessNV(GLenum mode, GLenum type, const GLvoid *indirect, GLsizei drawCount, GLsizei stride, GLint vertexBufferCount);
extern GLuint64 glGetImageHandleNV(GLuint texture, GLint level, GLboolean layered, GLint layer, GLenum format);
extern GLuint64 glGetTextureHandleNV(GLuint texture);
extern GLuint64 glGetTextureSamplerHandleNV(GLuint texture, GLuint sampler);
extern GLboolean glIsImageHandleResidentNV(GLuint64 handle);
extern GLboolean glIsTextureHandleResidentNV(GLuint64 handle);
extern void glMakeImageHandleNonResidentNV(GLuint64 handle);
extern void glMakeImageHandleResidentNV(GLuint64 handle, GLenum access);
extern void glMakeTextureHandleNonResidentNV(GLuint64 handle);
extern void glMakeTextureHandleResidentNV(GLuint64 handle);
extern void glProgramUniformHandleui64NV(GLuint program, GLint location, GLuint64 value);
extern void glProgramUniformHandleui64vNV(GLuint program, GLint location, GLsizei count, const GLuint64* values);
extern void glUniformHandleui64NV(GLint location, GLuint64 value);
extern void glUniformHandleui64vNV(GLint location, GLsizei count, const GLuint64* value);
extern void glBlendBarrierNV(void);
extern void glBlendParameteriNV(GLenum pname, GLint value);
extern void glClearDepthdNV(GLdouble depth);
extern void glDepthBoundsdNV(GLdouble zmin, GLdouble zmax);
extern void glDepthRangedNV(GLdouble zNear, GLdouble zFar);
extern void glDrawTextureNV(GLuint texture, GLuint sampler, GLfloat x0, GLfloat y0, GLfloat x1, GLfloat y1, GLfloat z, GLfloat s0, GLfloat t0, GLfloat s1, GLfloat t1);
extern void glEvalMapsNV(GLenum target, GLenum mode);
extern void glGetMapAttribParameterfvNV(GLenum target, GLuint index, GLenum pname, GLfloat* params);
extern void glGetMapAttribParameterivNV(GLenum target, GLuint index, GLenum pname, GLint* params);
extern void glGetMapControlPointsNV(GLenum target, GLuint index, GLenum type, GLsizei ustride, GLsizei vstride, GLboolean packed, GLvoid *points);
extern void glGetMapParameterfvNV(GLenum target, GLenum pname, GLfloat* params);
extern void glGetMapParameterivNV(GLenum target, GLenum pname, GLint* params);
extern void glMapControlPointsNV(GLenum target, GLuint index, GLenum type, GLsizei ustride, GLsizei vstride, GLint uorder, GLint vorder, GLboolean packed, const GLvoid *points);
extern void glMapParameterfvNV(GLenum target, GLenum pname, const GLfloat* params);
extern void glMapParameterivNV(GLenum target, GLenum pname, const GLint* params);
extern void glSampleMaskIndexedNV(GLuint index, GLbitfield mask);
extern void glTexRenderbufferNV(GLenum target, GLuint renderbuffer);
extern void glDeleteFencesNV(GLsizei n, const GLuint* fences);
extern void glFinishFenceNV(GLuint fence);
extern void glGenFencesNV(GLsizei n, GLuint* fences);
extern void glGetFenceivNV(GLuint fence, GLenum pname, GLint* params);
extern GLboolean glIsFenceNV(GLuint fence);
extern void glSetFenceNV(GLuint fence, GLenum condition);
extern GLboolean glTestFenceNV(GLuint fence);
extern void glGetProgramNamedParameterdvNV(GLuint id, GLsizei len, const GLubyte* name, GLdouble *params);
extern void glGetProgramNamedParameterfvNV(GLuint id, GLsizei len, const GLubyte* name, GLfloat *params);
extern void glProgramNamedParameter4dNV(GLuint id, GLsizei len, const GLubyte* name, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
extern void glProgramNamedParameter4dvNV(GLuint id, GLsizei len, const GLubyte* name, const GLdouble v[]);
extern void glProgramNamedParameter4fNV(GLuint id, GLsizei len, const GLubyte* name, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
extern void glProgramNamedParameter4fvNV(GLuint id, GLsizei len, const GLubyte* name, const GLfloat v[]);
extern void glRenderbufferStorageMultisampleCoverageNV(GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLenum internalformat, GLsizei width, GLsizei height);
extern void glProgramVertexLimitNV(GLenum target, GLint limit);
extern void glProgramEnvParameterI4iNV(GLenum target, GLuint index, GLint x, GLint y, GLint z, GLint w);
extern void glProgramEnvParameterI4ivNV(GLenum target, GLuint index, const GLint *params);
extern void glProgramEnvParameterI4uiNV(GLenum target, GLuint index, GLuint x, GLuint y, GLuint z, GLuint w);
extern void glProgramEnvParameterI4uivNV(GLenum target, GLuint index, const GLuint *params);
extern void glProgramEnvParametersI4ivNV(GLenum target, GLuint index, GLsizei count, const GLint *params);
extern void glProgramEnvParametersI4uivNV(GLenum target, GLuint index, GLsizei count, const GLuint *params);
extern void glProgramLocalParameterI4iNV(GLenum target, GLuint index, GLint x, GLint y, GLint z, GLint w);
extern void glProgramLocalParameterI4ivNV(GLenum target, GLuint index, const GLint *params);
extern void glProgramLocalParameterI4uiNV(GLenum target, GLuint index, GLuint x, GLuint y, GLuint z, GLuint w);
extern void glProgramLocalParameterI4uivNV(GLenum target, GLuint index, const GLuint *params);
extern void glProgramLocalParametersI4ivNV(GLenum target, GLuint index, GLsizei count, const GLint *params);
extern void glProgramLocalParametersI4uivNV(GLenum target, GLuint index, GLsizei count, const GLuint *params);
extern void glGetUniformi64vNV(GLuint program, GLint location, GLint64EXT* params);
extern void glGetUniformui64vNV(GLuint program, GLint location, GLuint64EXT* params);
extern void glProgramUniform1i64NV(GLuint program, GLint location, GLint64EXT x);
extern void glProgramUniform1i64vNV(GLuint program, GLint location, GLsizei count, const GLint64EXT* value);
extern void glProgramUniform1ui64NV(GLuint program, GLint location, GLuint64EXT x);
extern void glProgramUniform1ui64vNV(GLuint program, GLint location, GLsizei count, const GLuint64EXT* value);
extern void glProgramUniform2i64NV(GLuint program, GLint location, GLint64EXT x, GLint64EXT y);
extern void glProgramUniform2i64vNV(GLuint program, GLint location, GLsizei count, const GLint64EXT* value);
extern void glProgramUniform2ui64NV(GLuint program, GLint location, GLuint64EXT x, GLuint64EXT y);
extern void glProgramUniform2ui64vNV(GLuint program, GLint location, GLsizei count, const GLuint64EXT* value);
extern void glProgramUniform3i64NV(GLuint program, GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z);
extern void glProgramUniform3i64vNV(GLuint program, GLint location, GLsizei count, const GLint64EXT* value);
extern void glProgramUniform3ui64NV(GLuint program, GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z);
extern void glProgramUniform3ui64vNV(GLuint program, GLint location, GLsizei count, const GLuint64EXT* value);
extern void glProgramUniform4i64NV(GLuint program, GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z, GLint64EXT w);
extern void glProgramUniform4i64vNV(GLuint program, GLint location, GLsizei count, const GLint64EXT* value);
extern void glProgramUniform4ui64NV(GLuint program, GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, GLuint64EXT w);
extern void glProgramUniform4ui64vNV(GLuint program, GLint location, GLsizei count, const GLuint64EXT* value);
extern void glUniform1i64NV(GLint location, GLint64EXT x);
extern void glUniform1i64vNV(GLint location, GLsizei count, const GLint64EXT* value);
extern void glUniform1ui64NV(GLint location, GLuint64EXT x);
extern void glUniform1ui64vNV(GLint location, GLsizei count, const GLuint64EXT* value);
extern void glUniform2i64NV(GLint location, GLint64EXT x, GLint64EXT y);
extern void glUniform2i64vNV(GLint location, GLsizei count, const GLint64EXT* value);
extern void glUniform2ui64NV(GLint location, GLuint64EXT x, GLuint64EXT y);
extern void glUniform2ui64vNV(GLint location, GLsizei count, const GLuint64EXT* value);
extern void glUniform3i64NV(GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z);
extern void glUniform3i64vNV(GLint location, GLsizei count, const GLint64EXT* value);
extern void glUniform3ui64NV(GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z);
extern void glUniform3ui64vNV(GLint location, GLsizei count, const GLuint64EXT* value);
extern void glUniform4i64NV(GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z, GLint64EXT w);
extern void glUniform4i64vNV(GLint location, GLsizei count, const GLint64EXT* value);
extern void glUniform4ui64NV(GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, GLuint64EXT w);
extern void glUniform4ui64vNV(GLint location, GLsizei count, const GLuint64EXT* value);
extern void glColor3hNV(GLhalf red, GLhalf green, GLhalf blue);
extern void glColor3hvNV(const GLhalf* v);
extern void glColor4hNV(GLhalf red, GLhalf green, GLhalf blue, GLhalf alpha);
extern void glColor4hvNV(const GLhalf* v);
extern void glFogCoordhNV(GLhalf fog);
extern void glFogCoordhvNV(const GLhalf* fog);
extern void glMultiTexCoord1hNV(GLenum target, GLhalf s);
extern void glMultiTexCoord1hvNV(GLenum target, const GLhalf* v);
extern void glMultiTexCoord2hNV(GLenum target, GLhalf s, GLhalf t);
extern void glMultiTexCoord2hvNV(GLenum target, const GLhalf* v);
extern void glMultiTexCoord3hNV(GLenum target, GLhalf s, GLhalf t, GLhalf r);
extern void glMultiTexCoord3hvNV(GLenum target, const GLhalf* v);
extern void glMultiTexCoord4hNV(GLenum target, GLhalf s, GLhalf t, GLhalf r, GLhalf q);
extern void glMultiTexCoord4hvNV(GLenum target, const GLhalf* v);
extern void glNormal3hNV(GLhalf nx, GLhalf ny, GLhalf nz);
extern void glNormal3hvNV(const GLhalf* v);
extern void glSecondaryColor3hNV(GLhalf red, GLhalf green, GLhalf blue);
extern void glSecondaryColor3hvNV(const GLhalf* v);
extern void glTexCoord1hNV(GLhalf s);
extern void glTexCoord1hvNV(const GLhalf* v);
extern void glTexCoord2hNV(GLhalf s, GLhalf t);
extern void glTexCoord2hvNV(const GLhalf* v);
extern void glTexCoord3hNV(GLhalf s, GLhalf t, GLhalf r);
extern void glTexCoord3hvNV(const GLhalf* v);
extern void glTexCoord4hNV(GLhalf s, GLhalf t, GLhalf r, GLhalf q);
extern void glTexCoord4hvNV(const GLhalf* v);
extern void glVertex2hNV(GLhalf x, GLhalf y);
extern void glVertex2hvNV(const GLhalf* v);
extern void glVertex3hNV(GLhalf x, GLhalf y, GLhalf z);
extern void glVertex3hvNV(const GLhalf* v);
extern void glVertex4hNV(GLhalf x, GLhalf y, GLhalf z, GLhalf w);
extern void glVertex4hvNV(const GLhalf* v);
extern void glVertexAttrib1hNV(GLuint index, GLhalf x);
extern void glVertexAttrib1hvNV(GLuint index, const GLhalf* v);
extern void glVertexAttrib2hNV(GLuint index, GLhalf x, GLhalf y);
extern void glVertexAttrib2hvNV(GLuint index, const GLhalf* v);
extern void glVertexAttrib3hNV(GLuint index, GLhalf x, GLhalf y, GLhalf z);
extern void glVertexAttrib3hvNV(GLuint index, const GLhalf* v);
extern void glVertexAttrib4hNV(GLuint index, GLhalf x, GLhalf y, GLhalf z, GLhalf w);
extern void glVertexAttrib4hvNV(GLuint index, const GLhalf* v);
extern void glVertexAttribs1hvNV(GLuint index, GLsizei n, const GLhalf* v);
extern void glVertexAttribs2hvNV(GLuint index, GLsizei n, const GLhalf* v);
extern void glVertexAttribs3hvNV(GLuint index, GLsizei n, const GLhalf* v);
extern void glVertexAttribs4hvNV(GLuint index, GLsizei n, const GLhalf* v);
extern void glVertexWeighthNV(GLhalf weight);
extern void glVertexWeighthvNV(const GLhalf* weight);
extern void glBeginOcclusionQueryNV(GLuint id);
extern void glDeleteOcclusionQueriesNV(GLsizei n, const GLuint* ids);
extern void glEndOcclusionQueryNV(void);
extern void glGenOcclusionQueriesNV(GLsizei n, GLuint* ids);
extern void glGetOcclusionQueryivNV(GLuint id, GLenum pname, GLint* params);
extern void glGetOcclusionQueryuivNV(GLuint id, GLenum pname, GLuint* params);
extern GLboolean glIsOcclusionQueryNV(GLuint id);
extern void glProgramBufferParametersIivNV(GLenum target, GLuint buffer, GLuint index, GLsizei count, const GLint *params);
extern void glProgramBufferParametersIuivNV(GLenum target, GLuint buffer, GLuint index, GLsizei count, const GLuint *params);
extern void glProgramBufferParametersfvNV(GLenum target, GLuint buffer, GLuint index, GLsizei count, const GLfloat *params);
extern void glCopyPathNV(GLuint resultPath, GLuint srcPath);
extern void glCoverFillPathInstancedNV(GLsizei numPaths, GLenum pathNameType, const void* paths, GLuint pathBase, GLenum coverMode, GLenum transformType, const GLfloat *transformValues);
extern void glCoverFillPathNV(GLuint path, GLenum coverMode);
extern void glCoverStrokePathInstancedNV(GLsizei numPaths, GLenum pathNameType, const void* paths, GLuint pathBase, GLenum coverMode, GLenum transformType, const GLfloat *transformValues);
extern void glCoverStrokePathNV(GLuint name, GLenum coverMode);
extern void glDeletePathsNV(GLuint path, GLsizei range);
extern GLuint glGenPathsNV(GLsizei range);
extern void glGetPathColorGenfvNV(GLenum color, GLenum pname, GLfloat* value);
extern void glGetPathColorGenivNV(GLenum color, GLenum pname, GLint* value);
extern void glGetPathCommandsNV(GLuint name, GLubyte* commands);
extern void glGetPathCoordsNV(GLuint name, GLfloat* coords);
extern void glGetPathDashArrayNV(GLuint name, GLfloat* dashArray);
extern GLfloat glGetPathLengthNV(GLuint path, GLsizei startSegment, GLsizei numSegments);
extern void glGetPathMetricRangeNV(GLbitfield metricQueryMask, GLuint fistPathName, GLsizei numPaths, GLsizei stride, GLfloat* metrics);
extern void glGetPathMetricsNV(GLbitfield metricQueryMask, GLsizei numPaths, GLenum pathNameType, const void* paths, GLuint pathBase, GLsizei stride, GLfloat *metrics);
extern void glGetPathParameterfvNV(GLuint name, GLenum param, GLfloat* value);
extern void glGetPathParameterivNV(GLuint name, GLenum param, GLint* value);
extern void glGetPathSpacingNV(GLenum pathListMode, GLsizei numPaths, GLenum pathNameType, const void* paths, GLuint pathBase, GLfloat advanceScale, GLfloat kerningScale, GLenum transformType, GLfloat *returnedSpacing);
extern void glGetPathTexGenfvNV(GLenum texCoordSet, GLenum pname, GLfloat* value);
extern void glGetPathTexGenivNV(GLenum texCoordSet, GLenum pname, GLint* value);
extern void glInterpolatePathsNV(GLuint resultPath, GLuint pathA, GLuint pathB, GLfloat weight);
extern GLboolean glIsPathNV(GLuint path);
extern GLboolean glIsPointInFillPathNV(GLuint path, GLuint mask, GLfloat x, GLfloat y);
extern GLboolean glIsPointInStrokePathNV(GLuint path, GLfloat x, GLfloat y);
extern void glPathColorGenNV(GLenum color, GLenum genMode, GLenum colorFormat, const GLfloat* coeffs);
extern void glPathCommandsNV(GLuint path, GLsizei numCommands, const GLubyte* commands, GLsizei numCoords, GLenum coordType, const GLvoid*coords);
extern void glPathCoordsNV(GLuint path, GLsizei numCoords, GLenum coordType, const void* coords);
extern void glPathCoverDepthFuncNV(GLenum zfunc);
extern void glPathDashArrayNV(GLuint path, GLsizei dashCount, const GLfloat* dashArray);
extern void glPathFogGenNV(GLenum genMode);
extern void glPathGlyphRangeNV(GLuint firstPathName, GLenum fontTarget, const void* fontName, GLbitfield fontStyle, GLuint firstGlyph, GLsizei numGlyphs, GLenum handleMissingGlyphs, GLuint pathParameterTemplate, GLfloat emScale);
extern void glPathGlyphsNV(GLuint firstPathName, GLenum fontTarget, const void* fontName, GLbitfield fontStyle, GLsizei numGlyphs, GLenum type, const GLvoid*charcodes, GLenum handleMissingGlyphs, GLuint pathParameterTemplate, GLfloat emScale);
extern void glPathParameterfNV(GLuint path, GLenum pname, GLfloat value);
extern void glPathParameterfvNV(GLuint path, GLenum pname, const GLfloat* value);
extern void glPathParameteriNV(GLuint path, GLenum pname, GLint value);
extern void glPathParameterivNV(GLuint path, GLenum pname, const GLint* value);
extern void glPathStencilDepthOffsetNV(GLfloat factor, GLfloat units);
extern void glPathStencilFuncNV(GLenum func, GLint ref, GLuint mask);
extern void glPathStringNV(GLuint path, GLenum format, GLsizei length, const void* pathString);
extern void glPathSubCommandsNV(GLuint path, GLsizei commandStart, GLsizei commandsToDelete, GLsizei numCommands, const GLubyte* commands, GLsizei numCoords, GLenum coordType, const GLvoid*coords);
extern void glPathSubCoordsNV(GLuint path, GLsizei coordStart, GLsizei numCoords, GLenum coordType, const void* coords);
extern void glPathTexGenNV(GLenum texCoordSet, GLenum genMode, GLint components, const GLfloat* coeffs);
extern GLboolean glPointAlongPathNV(GLuint path, GLsizei startSegment, GLsizei numSegments, GLfloat distance, GLfloat* x, GLfloat *y, GLfloat *tangentX, GLfloat *tangentY);
extern void glStencilFillPathInstancedNV(GLsizei numPaths, GLenum pathNameType, const void* paths, GLuint pathBase, GLenum fillMode, GLuint mask, GLenum transformType, const GLfloat *transformValues);
extern void glStencilFillPathNV(GLuint path, GLenum fillMode, GLuint mask);
extern void glStencilStrokePathInstancedNV(GLsizei numPaths, GLenum pathNameType, const void* paths, GLuint pathBase, GLint reference, GLuint mask, GLenum transformType, const GLfloat *transformValues);
extern void glStencilStrokePathNV(GLuint path, GLint reference, GLuint mask);
extern void glTransformPathNV(GLuint resultPath, GLuint srcPath, GLenum transformType, const GLfloat* transformValues);
extern void glWeightPathsNV(GLuint resultPath, GLsizei numPaths, const GLuint paths[], const GLfloat weights[]);
extern void glFlushPixelDataRangeNV(GLenum target);
extern void glPixelDataRangeNV(GLenum target, GLsizei length, GLvoid *pointer);
extern void glGetVideoi64vNV(GLuint video_slot, GLenum pname, GLint64EXT* params);
extern void glGetVideoivNV(GLuint video_slot, GLenum pname, GLint* params);
extern void glGetVideoui64vNV(GLuint video_slot, GLenum pname, GLuint64EXT* params);
extern void glGetVideouivNV(GLuint video_slot, GLenum pname, GLuint* params);
extern void glPresentFrameDualFillNV(GLuint video_slot, GLuint64EXT minPresentTime, GLuint beginPresentTimeId, GLuint presentDurationId, GLenum type, GLenum target0, GLuint fill0, GLenum target1, GLuint fill1, GLenum target2, GLuint fill2, GLenum target3, GLuint fill3);
extern void glPresentFrameKeyedNV(GLuint video_slot, GLuint64EXT minPresentTime, GLuint beginPresentTimeId, GLuint presentDurationId, GLenum type, GLenum target0, GLuint fill0, GLuint key0, GLenum target1, GLuint fill1, GLuint key1);
extern void glPrimitiveRestartNV(void);
extern void glCombinerInputNV(GLenum stage, GLenum portion, GLenum variable, GLenum input, GLenum mapping, GLenum componentUsage);
extern void glCombinerOutputNV(GLenum stage, GLenum portion, GLenum abOutput, GLenum cdOutput, GLenum sumOutput, GLenum scale, GLenum bias, GLboolean abDotProduct, GLboolean cdDotProduct, GLboolean muxSum);
extern void glCombinerParameterfNV(GLenum pname, GLfloat param);
extern void glCombinerParameterfvNV(GLenum pname, const GLfloat* params);
extern void glCombinerParameteriNV(GLenum pname, GLint param);
extern void glCombinerParameterivNV(GLenum pname, const GLint* params);
extern void glFinalCombinerInputNV(GLenum variable, GLenum input, GLenum mapping, GLenum componentUsage);
extern void glGetCombinerInputParameterfvNV(GLenum stage, GLenum portion, GLenum variable, GLenum pname, GLfloat* params);
extern void glGetCombinerInputParameterivNV(GLenum stage, GLenum portion, GLenum variable, GLenum pname, GLint* params);
extern void glGetCombinerOutputParameterfvNV(GLenum stage, GLenum portion, GLenum pname, GLfloat* params);
extern void glGetCombinerOutputParameterivNV(GLenum stage, GLenum portion, GLenum pname, GLint* params);
extern void glGetFinalCombinerInputParameterfvNV(GLenum variable, GLenum pname, GLfloat* params);
extern void glGetFinalCombinerInputParameterivNV(GLenum variable, GLenum pname, GLint* params);
extern void glCombinerStageParameterfvNV(GLenum stage, GLenum pname, const GLfloat* params);
extern void glGetCombinerStageParameterfvNV(GLenum stage, GLenum pname, GLfloat* params);
extern void glGetBufferParameterui64vNV(GLenum target, GLenum pname, GLuint64EXT* params);
extern void glGetIntegerui64vNV(GLenum value, GLuint64EXT* result);
extern void glGetNamedBufferParameterui64vNV(GLuint buffer, GLenum pname, GLuint64EXT* params);
extern GLboolean glIsBufferResidentNV(GLenum target);
extern GLboolean glIsNamedBufferResidentNV(GLuint buffer);
extern void glMakeBufferNonResidentNV(GLenum target);
extern void glMakeBufferResidentNV(GLenum target, GLenum access);
extern void glMakeNamedBufferNonResidentNV(GLuint buffer);
extern void glMakeNamedBufferResidentNV(GLuint buffer, GLenum access);
extern void glProgramUniformui64NV(GLuint program, GLint location, GLuint64EXT value);
extern void glProgramUniformui64vNV(GLuint program, GLint location, GLsizei count, const GLuint64EXT* value);
extern void glUniformui64NV(GLint location, GLuint64EXT value);
extern void glUniformui64vNV(GLint location, GLsizei count, const GLuint64EXT* value);
extern void glTextureBarrierNV(void);
extern void glTexImage2DMultisampleCoverageNV(GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLint internalFormat, GLsizei width, GLsizei height, GLboolean fixedSampleLocations);
extern void glTexImage3DMultisampleCoverageNV(GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLint internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedSampleLocations);
extern void glTextureImage2DMultisampleCoverageNV(GLuint texture, GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLint internalFormat, GLsizei width, GLsizei height, GLboolean fixedSampleLocations);
extern void glTextureImage2DMultisampleNV(GLuint texture, GLenum target, GLsizei samples, GLint internalFormat, GLsizei width, GLsizei height, GLboolean fixedSampleLocations);
extern void glTextureImage3DMultisampleCoverageNV(GLuint texture, GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLint internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedSampleLocations);
extern void glTextureImage3DMultisampleNV(GLuint texture, GLenum target, GLsizei samples, GLint internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedSampleLocations);
extern void glActiveVaryingNV(GLuint program, const GLchar *name);
extern void glBindBufferOffsetNV(GLenum target, GLuint index, GLuint buffer, GLintptr offset);
extern void glGetActiveVaryingNV(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLsizei *size, GLenum *type, GLchar *name);
extern GLint glGetVaryingLocationNV(GLuint program, const GLchar *name);
extern void glTransformFeedbackAttribsNV(GLuint count, const GLint *attribs, GLenum bufferMode);
extern void glVDPAUFiniNV(void);
extern void glVDPAUGetSurfaceivNV(GLvdpauSurfaceNV surface, GLenum pname, GLsizei bufSize, GLsizei* length, GLint *values);
extern void glVDPAUInitNV(const void* vdpDevice, const GLvoid*getProcAddress);
extern void glVDPAUIsSurfaceNV(GLvdpauSurfaceNV surface);
extern void glVDPAUMapSurfacesNV(GLsizei numSurfaces, const GLvdpauSurfaceNV* surfaces);
extern GLvdpauSurfaceNV glVDPAURegisterOutputSurfaceNV(const void* vdpSurface, GLenum target, GLsizei numTextureNames, const GLuint *textureNames);
extern GLvdpauSurfaceNV glVDPAURegisterVideoSurfaceNV(const void* vdpSurface, GLenum target, GLsizei numTextureNames, const GLuint *textureNames);
extern void glVDPAUSurfaceAccessNV(GLvdpauSurfaceNV surface, GLenum access);
extern void glVDPAUUnmapSurfacesNV(GLsizei numSurface, const GLvdpauSurfaceNV* surfaces);
extern void glVDPAUUnregisterSurfaceNV(GLvdpauSurfaceNV surface);
extern void glFlushVertexArrayRangeNV(void);
extern void glVertexArrayRangeNV(GLsizei length, GLvoid *pointer);
extern void glGetVertexAttribLi64vNV(GLuint index, GLenum pname, GLint64EXT* params);
extern void glGetVertexAttribLui64vNV(GLuint index, GLenum pname, GLuint64EXT* params);
extern void glVertexAttribL1i64NV(GLuint index, GLint64EXT x);
extern void glVertexAttribL1i64vNV(GLuint index, const GLint64EXT* v);
extern void glVertexAttribL1ui64NV(GLuint index, GLuint64EXT x);
extern void glVertexAttribL1ui64vNV(GLuint index, const GLuint64EXT* v);
extern void glVertexAttribL2i64NV(GLuint index, GLint64EXT x, GLint64EXT y);
extern void glVertexAttribL2i64vNV(GLuint index, const GLint64EXT* v);
extern void glVertexAttribL2ui64NV(GLuint index, GLuint64EXT x, GLuint64EXT y);
extern void glVertexAttribL2ui64vNV(GLuint index, const GLuint64EXT* v);
extern void glVertexAttribL3i64NV(GLuint index, GLint64EXT x, GLint64EXT y, GLint64EXT z);
extern void glVertexAttribL3i64vNV(GLuint index, const GLint64EXT* v);
extern void glVertexAttribL3ui64NV(GLuint index, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z);
extern void glVertexAttribL3ui64vNV(GLuint index, const GLuint64EXT* v);
extern void glVertexAttribL4i64NV(GLuint index, GLint64EXT x, GLint64EXT y, GLint64EXT z, GLint64EXT w);
extern void glVertexAttribL4i64vNV(GLuint index, const GLint64EXT* v);
extern void glVertexAttribL4ui64NV(GLuint index, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, GLuint64EXT w);
extern void glVertexAttribL4ui64vNV(GLuint index, const GLuint64EXT* v);
extern void glVertexAttribLFormatNV(GLuint index, GLint size, GLenum type, GLsizei stride);
extern void glBufferAddressRangeNV(GLenum pname, GLuint index, GLuint64EXT address, GLsizeiptr length);
extern void glColorFormatNV(GLint size, GLenum type, GLsizei stride);
extern void glEdgeFlagFormatNV(GLsizei stride);
extern void glFogCoordFormatNV(GLenum type, GLsizei stride);
extern void glGetIntegerui64i_vNV(GLenum value, GLuint index, GLuint64EXT result[]);
extern void glIndexFormatNV(GLenum type, GLsizei stride);
extern void glNormalFormatNV(GLenum type, GLsizei stride);
extern void glSecondaryColorFormatNV(GLint size, GLenum type, GLsizei stride);
extern void glTexCoordFormatNV(GLint size, GLenum type, GLsizei stride);
extern void glVertexAttribFormatNV(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride);
extern void glVertexAttribIFormatNV(GLuint index, GLint size, GLenum type, GLsizei stride);
extern void glVertexFormatNV(GLint size, GLenum type, GLsizei stride);
extern GLboolean glAreProgramsResidentNV(GLsizei n, const GLuint* ids, GLboolean *residences);
extern void glBindProgramNV(GLenum target, GLuint id);
extern void glDeleteProgramsNV(GLsizei n, const GLuint* ids);
extern void glExecuteProgramNV(GLenum target, GLuint id, const GLfloat* params);
extern void glGenProgramsNV(GLsizei n, GLuint* ids);
extern void glGetProgramParameterdvNV(GLenum target, GLuint index, GLenum pname, GLdouble* params);
extern void glGetProgramParameterfvNV(GLenum target, GLuint index, GLenum pname, GLfloat* params);
extern void glGetProgramStringNV(GLuint id, GLenum pname, GLubyte* program);
extern void glGetTrackMatrixivNV(GLenum target, GLuint address, GLenum pname, GLint* params);
extern void glLoadProgramNV(GLenum target, GLuint id, GLsizei len, const GLubyte* program);
extern void glProgramParameter4dNV(GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
extern void glProgramParameter4dvNV(GLenum target, GLuint index, const GLdouble* params);
extern void glProgramParameter4fNV(GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
extern void glProgramParameter4fvNV(GLenum target, GLuint index, const GLfloat* params);
extern void glProgramParameters4dvNV(GLenum target, GLuint index, GLsizei num, const GLdouble* params);
extern void glProgramParameters4fvNV(GLenum target, GLuint index, GLsizei num, const GLfloat* params);
extern void glRequestResidentProgramsNV(GLsizei n, GLuint* ids);
extern void glTrackMatrixNV(GLenum target, GLuint address, GLenum matrix, GLenum transform);
extern void glVertexAttrib4ubNV(GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w);
extern void glVertexAttribs1dvNV(GLuint index, GLsizei n, const GLdouble* v);
extern void glVertexAttribs1fvNV(GLuint index, GLsizei n, const GLfloat* v);
extern void glVertexAttribs1svNV(GLuint index, GLsizei n, const GLshort* v);
extern void glVertexAttribs2dvNV(GLuint index, GLsizei n, const GLdouble* v);
extern void glVertexAttribs2fvNV(GLuint index, GLsizei n, const GLfloat* v);
extern void glVertexAttribs2svNV(GLuint index, GLsizei n, const GLshort* v);
extern void glVertexAttribs3dvNV(GLuint index, GLsizei n, const GLdouble* v);
extern void glVertexAttribs3fvNV(GLuint index, GLsizei n, const GLfloat* v);
extern void glVertexAttribs3svNV(GLuint index, GLsizei n, const GLshort* v);
extern void glVertexAttribs4dvNV(GLuint index, GLsizei n, const GLdouble* v);
extern void glVertexAttribs4fvNV(GLuint index, GLsizei n, const GLfloat* v);
extern void glVertexAttribs4svNV(GLuint index, GLsizei n, const GLshort* v);
extern void glVertexAttribs4ubvNV(GLuint index, GLsizei n, const GLubyte* v);
extern void glBeginVideoCaptureNV(GLuint video_capture_slot);
extern void glBindVideoCaptureStreamBufferNV(GLuint video_capture_slot, GLuint stream, GLenum frame_region, GLintptrARB offset);
extern void glBindVideoCaptureStreamTextureNV(GLuint video_capture_slot, GLuint stream, GLenum frame_region, GLenum target, GLuint texture);
extern void glEndVideoCaptureNV(GLuint video_capture_slot);
extern void glGetVideoCaptureStreamdvNV(GLuint video_capture_slot, GLuint stream, GLenum pname, GLdouble* params);
extern void glGetVideoCaptureStreamfvNV(GLuint video_capture_slot, GLuint stream, GLenum pname, GLfloat* params);
extern void glGetVideoCaptureStreamivNV(GLuint video_capture_slot, GLuint stream, GLenum pname, GLint* params);
extern void glGetVideoCaptureivNV(GLuint video_capture_slot, GLenum pname, GLint* params);
extern GLenum glVideoCaptureNV(GLuint video_capture_slot, GLuint* sequence_num, GLuint64EXT *capture_time);
extern void glVideoCaptureStreamParameterdvNV(GLuint video_capture_slot, GLuint stream, GLenum pname, const GLdouble* params);
extern void glVideoCaptureStreamParameterfvNV(GLuint video_capture_slot, GLuint stream, GLenum pname, const GLfloat* params);
extern void glVideoCaptureStreamParameterivNV(GLuint video_capture_slot, GLuint stream, GLenum pname, const GLint* params);
extern GLenum glewInit ();
extern GLboolean glewIsSupported (const char* name);

extern GLboolean __GLEW_VERSION_1_1;
extern GLboolean __GLEW_VERSION_1_2;
extern GLboolean __GLEW_VERSION_1_2_1;
extern GLboolean __GLEW_VERSION_1_3;
extern GLboolean __GLEW_VERSION_1_4;
extern GLboolean __GLEW_VERSION_1_5;
extern GLboolean __GLEW_VERSION_2_0;
extern GLboolean __GLEW_VERSION_2_1;
extern GLboolean __GLEW_VERSION_3_0;
extern GLboolean __GLEW_VERSION_3_1;
extern GLboolean __GLEW_VERSION_3_2;
extern GLboolean __GLEW_VERSION_3_3;
extern GLboolean __GLEW_VERSION_4_0;
extern GLboolean __GLEW_VERSION_4_1;
extern GLboolean __GLEW_VERSION_4_2;
extern GLboolean __GLEW_VERSION_4_3;
extern GLboolean __GLEW_VERSION_4_4;
extern GLboolean __GLEW_3DFX_multisample;
extern GLboolean __GLEW_3DFX_tbuffer;
extern GLboolean __GLEW_3DFX_texture_compression_FXT1;
extern GLboolean __GLEW_AMD_blend_minmax_factor;
extern GLboolean __GLEW_AMD_conservative_depth;
extern GLboolean __GLEW_AMD_debug_output;
extern GLboolean __GLEW_AMD_depth_clamp_separate;
extern GLboolean __GLEW_AMD_draw_buffers_blend;
extern GLboolean __GLEW_AMD_interleaved_elements;
extern GLboolean __GLEW_AMD_multi_draw_indirect;
extern GLboolean __GLEW_AMD_name_gen_delete;
extern GLboolean __GLEW_AMD_performance_monitor;
extern GLboolean __GLEW_AMD_pinned_memory;
extern GLboolean __GLEW_AMD_query_buffer_object;
extern GLboolean __GLEW_AMD_sample_positions;
extern GLboolean __GLEW_AMD_seamless_cubemap_per_texture;
extern GLboolean __GLEW_AMD_shader_stencil_export;
extern GLboolean __GLEW_AMD_shader_trinary_minmax;
extern GLboolean __GLEW_AMD_sparse_texture;
extern GLboolean __GLEW_AMD_stencil_operation_extended;
extern GLboolean __GLEW_AMD_texture_texture4;
extern GLboolean __GLEW_AMD_transform_feedback3_lines_triangles;
extern GLboolean __GLEW_AMD_vertex_shader_layer;
extern GLboolean __GLEW_AMD_vertex_shader_tessellator;
extern GLboolean __GLEW_AMD_vertex_shader_viewport_index;
extern GLboolean __GLEW_ANGLE_depth_texture;
extern GLboolean __GLEW_ANGLE_framebuffer_blit;
extern GLboolean __GLEW_ANGLE_framebuffer_multisample;
extern GLboolean __GLEW_ANGLE_instanced_arrays;
extern GLboolean __GLEW_ANGLE_pack_reverse_row_order;
extern GLboolean __GLEW_ANGLE_program_binary;
extern GLboolean __GLEW_ANGLE_texture_compression_dxt1;
extern GLboolean __GLEW_ANGLE_texture_compression_dxt3;
extern GLboolean __GLEW_ANGLE_texture_compression_dxt5;
extern GLboolean __GLEW_ANGLE_texture_usage;
extern GLboolean __GLEW_ANGLE_timer_query;
extern GLboolean __GLEW_ANGLE_translated_shader_source;
extern GLboolean __GLEW_APPLE_aux_depth_stencil;
extern GLboolean __GLEW_APPLE_client_storage;
extern GLboolean __GLEW_APPLE_element_array;
extern GLboolean __GLEW_APPLE_fence;
extern GLboolean __GLEW_APPLE_float_pixels;
extern GLboolean __GLEW_APPLE_flush_buffer_range;
extern GLboolean __GLEW_APPLE_object_purgeable;
extern GLboolean __GLEW_APPLE_pixel_buffer;
extern GLboolean __GLEW_APPLE_rgb_422;
extern GLboolean __GLEW_APPLE_row_bytes;
extern GLboolean __GLEW_APPLE_specular_vector;
extern GLboolean __GLEW_APPLE_texture_range;
extern GLboolean __GLEW_APPLE_transform_hint;
extern GLboolean __GLEW_APPLE_vertex_array_object;
extern GLboolean __GLEW_APPLE_vertex_array_range;
extern GLboolean __GLEW_APPLE_vertex_program_evaluators;
extern GLboolean __GLEW_APPLE_ycbcr_422;
extern GLboolean __GLEW_ARB_ES2_compatibility;
extern GLboolean __GLEW_ARB_ES3_compatibility;
extern GLboolean __GLEW_ARB_arrays_of_arrays;
extern GLboolean __GLEW_ARB_base_instance;
extern GLboolean __GLEW_ARB_bindless_texture;
extern GLboolean __GLEW_ARB_blend_func_extended;
extern GLboolean __GLEW_ARB_buffer_storage;
extern GLboolean __GLEW_ARB_cl_event;
extern GLboolean __GLEW_ARB_clear_buffer_object;
extern GLboolean __GLEW_ARB_clear_texture;
extern GLboolean __GLEW_ARB_color_buffer_float;
extern GLboolean __GLEW_ARB_compatibility;
extern GLboolean __GLEW_ARB_compressed_texture_pixel_storage;
extern GLboolean __GLEW_ARB_compute_shader;
extern GLboolean __GLEW_ARB_compute_variable_group_size;
extern GLboolean __GLEW_ARB_conservative_depth;
extern GLboolean __GLEW_ARB_copy_buffer;
extern GLboolean __GLEW_ARB_copy_image;
extern GLboolean __GLEW_ARB_debug_output;
extern GLboolean __GLEW_ARB_depth_buffer_float;
extern GLboolean __GLEW_ARB_depth_clamp;
extern GLboolean __GLEW_ARB_depth_texture;
extern GLboolean __GLEW_ARB_draw_buffers;
extern GLboolean __GLEW_ARB_draw_buffers_blend;
extern GLboolean __GLEW_ARB_draw_elements_base_vertex;
extern GLboolean __GLEW_ARB_draw_indirect;
extern GLboolean __GLEW_ARB_draw_instanced;
extern GLboolean __GLEW_ARB_enhanced_layouts;
extern GLboolean __GLEW_ARB_explicit_attrib_location;
extern GLboolean __GLEW_ARB_explicit_uniform_location;
extern GLboolean __GLEW_ARB_fragment_coord_conventions;
extern GLboolean __GLEW_ARB_fragment_layer_viewport;
extern GLboolean __GLEW_ARB_fragment_program;
extern GLboolean __GLEW_ARB_fragment_program_shadow;
extern GLboolean __GLEW_ARB_fragment_shader;
extern GLboolean __GLEW_ARB_framebuffer_no_attachments;
extern GLboolean __GLEW_ARB_framebuffer_object;
extern GLboolean __GLEW_ARB_framebuffer_sRGB;
extern GLboolean __GLEW_ARB_geometry_shader4;
extern GLboolean __GLEW_ARB_get_program_binary;
extern GLboolean __GLEW_ARB_gpu_shader5;
extern GLboolean __GLEW_ARB_gpu_shader_fp64;
extern GLboolean __GLEW_ARB_half_float_pixel;
extern GLboolean __GLEW_ARB_half_float_vertex;
extern GLboolean __GLEW_ARB_imaging;
extern GLboolean __GLEW_ARB_indirect_parameters;
extern GLboolean __GLEW_ARB_instanced_arrays;
extern GLboolean __GLEW_ARB_internalformat_query;
extern GLboolean __GLEW_ARB_internalformat_query2;
extern GLboolean __GLEW_ARB_invalidate_subdata;
extern GLboolean __GLEW_ARB_map_buffer_alignment;
extern GLboolean __GLEW_ARB_map_buffer_range;
extern GLboolean __GLEW_ARB_matrix_palette;
extern GLboolean __GLEW_ARB_multi_bind;
extern GLboolean __GLEW_ARB_multi_draw_indirect;
extern GLboolean __GLEW_ARB_multisample;
extern GLboolean __GLEW_ARB_multitexture;
extern GLboolean __GLEW_ARB_occlusion_query;
extern GLboolean __GLEW_ARB_occlusion_query2;
extern GLboolean __GLEW_ARB_pixel_buffer_object;
extern GLboolean __GLEW_ARB_point_parameters;
extern GLboolean __GLEW_ARB_point_sprite;
extern GLboolean __GLEW_ARB_program_interface_query;
extern GLboolean __GLEW_ARB_provoking_vertex;
extern GLboolean __GLEW_ARB_query_buffer_object;
extern GLboolean __GLEW_ARB_robust_buffer_access_behavior;
extern GLboolean __GLEW_ARB_robustness;
extern GLboolean __GLEW_ARB_robustness_application_isolation;
extern GLboolean __GLEW_ARB_robustness_share_group_isolation;
extern GLboolean __GLEW_ARB_sample_shading;
extern GLboolean __GLEW_ARB_sampler_objects;
extern GLboolean __GLEW_ARB_seamless_cube_map;
extern GLboolean __GLEW_ARB_seamless_cubemap_per_texture;
extern GLboolean __GLEW_ARB_separate_shader_objects;
extern GLboolean __GLEW_ARB_shader_atomic_counters;
extern GLboolean __GLEW_ARB_shader_bit_encoding;
extern GLboolean __GLEW_ARB_shader_draw_parameters;
extern GLboolean __GLEW_ARB_shader_group_vote;
extern GLboolean __GLEW_ARB_shader_image_load_store;
extern GLboolean __GLEW_ARB_shader_image_size;
extern GLboolean __GLEW_ARB_shader_objects;
extern GLboolean __GLEW_ARB_shader_precision;
extern GLboolean __GLEW_ARB_shader_stencil_export;
extern GLboolean __GLEW_ARB_shader_storage_buffer_object;
extern GLboolean __GLEW_ARB_shader_subroutine;
extern GLboolean __GLEW_ARB_shader_texture_lod;
extern GLboolean __GLEW_ARB_shading_language_100;
extern GLboolean __GLEW_ARB_shading_language_420pack;
extern GLboolean __GLEW_ARB_shading_language_include;
extern GLboolean __GLEW_ARB_shading_language_packing;
extern GLboolean __GLEW_ARB_shadow;
extern GLboolean __GLEW_ARB_shadow_ambient;
extern GLboolean __GLEW_ARB_sparse_texture;
extern GLboolean __GLEW_ARB_stencil_texturing;
extern GLboolean __GLEW_ARB_sync;
extern GLboolean __GLEW_ARB_tessellation_shader;
extern GLboolean __GLEW_ARB_texture_border_clamp;
extern GLboolean __GLEW_ARB_texture_buffer_object;
extern GLboolean __GLEW_ARB_texture_buffer_object_rgb32;
extern GLboolean __GLEW_ARB_texture_buffer_range;
extern GLboolean __GLEW_ARB_texture_compression;
extern GLboolean __GLEW_ARB_texture_compression_bptc;
extern GLboolean __GLEW_ARB_texture_compression_rgtc;
extern GLboolean __GLEW_ARB_texture_cube_map;
extern GLboolean __GLEW_ARB_texture_cube_map_array;
extern GLboolean __GLEW_ARB_texture_env_add;
extern GLboolean __GLEW_ARB_texture_env_combine;
extern GLboolean __GLEW_ARB_texture_env_crossbar;
extern GLboolean __GLEW_ARB_texture_env_dot3;
extern GLboolean __GLEW_ARB_texture_float;
extern GLboolean __GLEW_ARB_texture_gather;
extern GLboolean __GLEW_ARB_texture_mirror_clamp_to_edge;
extern GLboolean __GLEW_ARB_texture_mirrored_repeat;
extern GLboolean __GLEW_ARB_texture_multisample;
extern GLboolean __GLEW_ARB_texture_non_power_of_two;
extern GLboolean __GLEW_ARB_texture_query_levels;
extern GLboolean __GLEW_ARB_texture_query_lod;
extern GLboolean __GLEW_ARB_texture_rectangle;
extern GLboolean __GLEW_ARB_texture_rg;
extern GLboolean __GLEW_ARB_texture_rgb10_a2ui;
extern GLboolean __GLEW_ARB_texture_stencil8;
extern GLboolean __GLEW_ARB_texture_storage;
extern GLboolean __GLEW_ARB_texture_storage_multisample;
extern GLboolean __GLEW_ARB_texture_swizzle;
extern GLboolean __GLEW_ARB_texture_view;
extern GLboolean __GLEW_ARB_timer_query;
extern GLboolean __GLEW_ARB_transform_feedback2;
extern GLboolean __GLEW_ARB_transform_feedback3;
extern GLboolean __GLEW_ARB_transform_feedback_instanced;
extern GLboolean __GLEW_ARB_transpose_matrix;
extern GLboolean __GLEW_ARB_uniform_buffer_object;
extern GLboolean __GLEW_ARB_vertex_array_bgra;
extern GLboolean __GLEW_ARB_vertex_array_object;
extern GLboolean __GLEW_ARB_vertex_attrib_64bit;
extern GLboolean __GLEW_ARB_vertex_attrib_binding;
extern GLboolean __GLEW_ARB_vertex_blend;
extern GLboolean __GLEW_ARB_vertex_buffer_object;
extern GLboolean __GLEW_ARB_vertex_program;
extern GLboolean __GLEW_ARB_vertex_shader;
extern GLboolean __GLEW_ARB_vertex_type_10f_11f_11f_rev;
extern GLboolean __GLEW_ARB_vertex_type_2_10_10_10_rev;
extern GLboolean __GLEW_ARB_viewport_array;
extern GLboolean __GLEW_ARB_window_pos;
extern GLboolean __GLEW_ATIX_point_sprites;
extern GLboolean __GLEW_ATIX_texture_env_combine3;
extern GLboolean __GLEW_ATIX_texture_env_route;
extern GLboolean __GLEW_ATIX_vertex_shader_output_point_size;
extern GLboolean __GLEW_ATI_draw_buffers;
extern GLboolean __GLEW_ATI_element_array;
extern GLboolean __GLEW_ATI_envmap_bumpmap;
extern GLboolean __GLEW_ATI_fragment_shader;
extern GLboolean __GLEW_ATI_map_object_buffer;
extern GLboolean __GLEW_ATI_meminfo;
extern GLboolean __GLEW_ATI_pn_triangles;
extern GLboolean __GLEW_ATI_separate_stencil;
extern GLboolean __GLEW_ATI_shader_texture_lod;
extern GLboolean __GLEW_ATI_text_fragment_shader;
extern GLboolean __GLEW_ATI_texture_compression_3dc;
extern GLboolean __GLEW_ATI_texture_env_combine3;
extern GLboolean __GLEW_ATI_texture_float;
extern GLboolean __GLEW_ATI_texture_mirror_once;
extern GLboolean __GLEW_ATI_vertex_array_object;
extern GLboolean __GLEW_ATI_vertex_attrib_array_object;
extern GLboolean __GLEW_ATI_vertex_streams;
extern GLboolean __GLEW_EXT_422_pixels;
extern GLboolean __GLEW_EXT_Cg_shader;
extern GLboolean __GLEW_EXT_abgr;
extern GLboolean __GLEW_EXT_bgra;
extern GLboolean __GLEW_EXT_bindable_uniform;
extern GLboolean __GLEW_EXT_blend_color;
extern GLboolean __GLEW_EXT_blend_equation_separate;
extern GLboolean __GLEW_EXT_blend_func_separate;
extern GLboolean __GLEW_EXT_blend_logic_op;
extern GLboolean __GLEW_EXT_blend_minmax;
extern GLboolean __GLEW_EXT_blend_subtract;
extern GLboolean __GLEW_EXT_clip_volume_hint;
extern GLboolean __GLEW_EXT_cmyka;
extern GLboolean __GLEW_EXT_color_subtable;
extern GLboolean __GLEW_EXT_compiled_vertex_array;
extern GLboolean __GLEW_EXT_convolution;
extern GLboolean __GLEW_EXT_coordinate_frame;
extern GLboolean __GLEW_EXT_copy_texture;
extern GLboolean __GLEW_EXT_cull_vertex;
extern GLboolean __GLEW_EXT_debug_marker;
extern GLboolean __GLEW_EXT_depth_bounds_test;
extern GLboolean __GLEW_EXT_direct_state_access;
extern GLboolean __GLEW_EXT_draw_buffers2;
extern GLboolean __GLEW_EXT_draw_instanced;
extern GLboolean __GLEW_EXT_draw_range_elements;
extern GLboolean __GLEW_EXT_fog_coord;
extern GLboolean __GLEW_EXT_fragment_lighting;
extern GLboolean __GLEW_EXT_framebuffer_blit;
extern GLboolean __GLEW_EXT_framebuffer_multisample;
extern GLboolean __GLEW_EXT_framebuffer_multisample_blit_scaled;
extern GLboolean __GLEW_EXT_framebuffer_object;
extern GLboolean __GLEW_EXT_framebuffer_sRGB;
extern GLboolean __GLEW_EXT_geometry_shader4;
extern GLboolean __GLEW_EXT_gpu_program_parameters;
extern GLboolean __GLEW_EXT_gpu_shader4;
extern GLboolean __GLEW_EXT_histogram;
extern GLboolean __GLEW_EXT_index_array_formats;
extern GLboolean __GLEW_EXT_index_func;
extern GLboolean __GLEW_EXT_index_material;
extern GLboolean __GLEW_EXT_index_texture;
extern GLboolean __GLEW_EXT_light_texture;
extern GLboolean __GLEW_EXT_misc_attribute;
extern GLboolean __GLEW_EXT_multi_draw_arrays;
extern GLboolean __GLEW_EXT_multisample;
extern GLboolean __GLEW_EXT_packed_depth_stencil;
extern GLboolean __GLEW_EXT_packed_float;
extern GLboolean __GLEW_EXT_packed_pixels;
extern GLboolean __GLEW_EXT_paletted_texture;
extern GLboolean __GLEW_EXT_pixel_buffer_object;
extern GLboolean __GLEW_EXT_pixel_transform;
extern GLboolean __GLEW_EXT_pixel_transform_color_table;
extern GLboolean __GLEW_EXT_point_parameters;
extern GLboolean __GLEW_EXT_polygon_offset;
extern GLboolean __GLEW_EXT_provoking_vertex;
extern GLboolean __GLEW_EXT_rescale_normal;
extern GLboolean __GLEW_EXT_scene_marker;
extern GLboolean __GLEW_EXT_secondary_color;
extern GLboolean __GLEW_EXT_separate_shader_objects;
extern GLboolean __GLEW_EXT_separate_specular_color;
extern GLboolean __GLEW_EXT_shader_image_load_store;
extern GLboolean __GLEW_EXT_shadow_funcs;
extern GLboolean __GLEW_EXT_shared_texture_palette;
extern GLboolean __GLEW_EXT_stencil_clear_tag;
extern GLboolean __GLEW_EXT_stencil_two_side;
extern GLboolean __GLEW_EXT_stencil_wrap;
extern GLboolean __GLEW_EXT_subtexture;
extern GLboolean __GLEW_EXT_texture;
extern GLboolean __GLEW_EXT_texture3D;
extern GLboolean __GLEW_EXT_texture_array;
extern GLboolean __GLEW_EXT_texture_buffer_object;
extern GLboolean __GLEW_EXT_texture_compression_dxt1;
extern GLboolean __GLEW_EXT_texture_compression_latc;
extern GLboolean __GLEW_EXT_texture_compression_rgtc;
extern GLboolean __GLEW_EXT_texture_compression_s3tc;
extern GLboolean __GLEW_EXT_texture_cube_map;
extern GLboolean __GLEW_EXT_texture_edge_clamp;
extern GLboolean __GLEW_EXT_texture_env;
extern GLboolean __GLEW_EXT_texture_env_add;
extern GLboolean __GLEW_EXT_texture_env_combine;
extern GLboolean __GLEW_EXT_texture_env_dot3;
extern GLboolean __GLEW_EXT_texture_filter_anisotropic;
extern GLboolean __GLEW_EXT_texture_integer;
extern GLboolean __GLEW_EXT_texture_lod_bias;
extern GLboolean __GLEW_EXT_texture_mirror_clamp;
extern GLboolean __GLEW_EXT_texture_object;
extern GLboolean __GLEW_EXT_texture_perturb_normal;
extern GLboolean __GLEW_EXT_texture_rectangle;
extern GLboolean __GLEW_EXT_texture_sRGB;
extern GLboolean __GLEW_EXT_texture_sRGB_decode;
extern GLboolean __GLEW_EXT_texture_shared_exponent;
extern GLboolean __GLEW_EXT_texture_snorm;
extern GLboolean __GLEW_EXT_texture_swizzle;
extern GLboolean __GLEW_EXT_timer_query;
extern GLboolean __GLEW_EXT_transform_feedback;
extern GLboolean __GLEW_EXT_vertex_array;
extern GLboolean __GLEW_EXT_vertex_array_bgra;
extern GLboolean __GLEW_EXT_vertex_attrib_64bit;
extern GLboolean __GLEW_EXT_vertex_shader;
extern GLboolean __GLEW_EXT_vertex_weighting;
extern GLboolean __GLEW_EXT_x11_sync_object;
extern GLboolean __GLEW_GREMEDY_frame_terminator;
extern GLboolean __GLEW_GREMEDY_string_marker;
extern GLboolean __GLEW_HP_convolution_border_modes;
extern GLboolean __GLEW_HP_image_transform;
extern GLboolean __GLEW_HP_occlusion_test;
extern GLboolean __GLEW_HP_texture_lighting;
extern GLboolean __GLEW_IBM_cull_vertex;
extern GLboolean __GLEW_IBM_multimode_draw_arrays;
extern GLboolean __GLEW_IBM_rasterpos_clip;
extern GLboolean __GLEW_IBM_static_data;
extern GLboolean __GLEW_IBM_texture_mirrored_repeat;
extern GLboolean __GLEW_IBM_vertex_array_lists;
extern GLboolean __GLEW_INGR_color_clamp;
extern GLboolean __GLEW_INGR_interlace_read;
extern GLboolean __GLEW_INTEL_map_texture;
extern GLboolean __GLEW_INTEL_parallel_arrays;
extern GLboolean __GLEW_INTEL_texture_scissor;
extern GLboolean __GLEW_KHR_debug;
extern GLboolean __GLEW_KHR_texture_compression_astc_ldr;
extern GLboolean __GLEW_KTX_buffer_region;
extern GLboolean __GLEW_MESAX_texture_stack;
extern GLboolean __GLEW_MESA_pack_invert;
extern GLboolean __GLEW_MESA_resize_buffers;
extern GLboolean __GLEW_MESA_window_pos;
extern GLboolean __GLEW_MESA_ycbcr_texture;
extern GLboolean __GLEW_NVX_conditional_render;
extern GLboolean __GLEW_NVX_gpu_memory_info;
extern GLboolean __GLEW_NV_bindless_multi_draw_indirect;
extern GLboolean __GLEW_NV_bindless_texture;
extern GLboolean __GLEW_NV_blend_equation_advanced;
extern GLboolean __GLEW_NV_blend_equation_advanced_coherent;
extern GLboolean __GLEW_NV_blend_square;
extern GLboolean __GLEW_NV_compute_program5;
extern GLboolean __GLEW_NV_conditional_render;
extern GLboolean __GLEW_NV_copy_depth_to_color;
extern GLboolean __GLEW_NV_copy_image;
extern GLboolean __GLEW_NV_deep_texture3D;
extern GLboolean __GLEW_NV_depth_buffer_float;
extern GLboolean __GLEW_NV_depth_clamp;
extern GLboolean __GLEW_NV_depth_range_unclamped;
extern GLboolean __GLEW_NV_draw_texture;
extern GLboolean __GLEW_NV_evaluators;
extern GLboolean __GLEW_NV_explicit_multisample;
extern GLboolean __GLEW_NV_fence;
extern GLboolean __GLEW_NV_float_buffer;
extern GLboolean __GLEW_NV_fog_distance;
extern GLboolean __GLEW_NV_fragment_program;
extern GLboolean __GLEW_NV_fragment_program2;
extern GLboolean __GLEW_NV_fragment_program4;
extern GLboolean __GLEW_NV_fragment_program_option;
extern GLboolean __GLEW_NV_framebuffer_multisample_coverage;
extern GLboolean __GLEW_NV_geometry_program4;
extern GLboolean __GLEW_NV_geometry_shader4;
extern GLboolean __GLEW_NV_gpu_program4;
extern GLboolean __GLEW_NV_gpu_program5;
extern GLboolean __GLEW_NV_gpu_program5_mem_extended;
extern GLboolean __GLEW_NV_gpu_program_fp64;
extern GLboolean __GLEW_NV_gpu_shader5;
extern GLboolean __GLEW_NV_half_float;
extern GLboolean __GLEW_NV_light_max_exponent;
extern GLboolean __GLEW_NV_multisample_coverage;
extern GLboolean __GLEW_NV_multisample_filter_hint;
extern GLboolean __GLEW_NV_occlusion_query;
extern GLboolean __GLEW_NV_packed_depth_stencil;
extern GLboolean __GLEW_NV_parameter_buffer_object;
extern GLboolean __GLEW_NV_parameter_buffer_object2;
extern GLboolean __GLEW_NV_path_rendering;
extern GLboolean __GLEW_NV_pixel_data_range;
extern GLboolean __GLEW_NV_point_sprite;
extern GLboolean __GLEW_NV_present_video;
extern GLboolean __GLEW_NV_primitive_restart;
extern GLboolean __GLEW_NV_register_combiners;
extern GLboolean __GLEW_NV_register_combiners2;
extern GLboolean __GLEW_NV_shader_atomic_counters;
extern GLboolean __GLEW_NV_shader_atomic_float;
extern GLboolean __GLEW_NV_shader_buffer_load;
extern GLboolean __GLEW_NV_shader_storage_buffer_object;
extern GLboolean __GLEW_NV_tessellation_program5;
extern GLboolean __GLEW_NV_texgen_emboss;
extern GLboolean __GLEW_NV_texgen_reflection;
extern GLboolean __GLEW_NV_texture_barrier;
extern GLboolean __GLEW_NV_texture_compression_vtc;
extern GLboolean __GLEW_NV_texture_env_combine4;
extern GLboolean __GLEW_NV_texture_expand_normal;
extern GLboolean __GLEW_NV_texture_multisample;
extern GLboolean __GLEW_NV_texture_rectangle;
extern GLboolean __GLEW_NV_texture_shader;
extern GLboolean __GLEW_NV_texture_shader2;
extern GLboolean __GLEW_NV_texture_shader3;
extern GLboolean __GLEW_NV_transform_feedback;
extern GLboolean __GLEW_NV_transform_feedback2;
extern GLboolean __GLEW_NV_vdpau_interop;
extern GLboolean __GLEW_NV_vertex_array_range;
extern GLboolean __GLEW_NV_vertex_array_range2;
extern GLboolean __GLEW_NV_vertex_attrib_integer_64bit;
extern GLboolean __GLEW_NV_vertex_buffer_unified_memory;
extern GLboolean __GLEW_NV_vertex_program;
extern GLboolean __GLEW_NV_vertex_program1_1;
extern GLboolean __GLEW_NV_vertex_program2;
extern GLboolean __GLEW_NV_vertex_program2_option;
extern GLboolean __GLEW_NV_vertex_program3;
extern GLboolean __GLEW_NV_vertex_program4;
extern GLboolean __GLEW_NV_video_capture;
extern GLboolean __GLEW_OES_byte_coordinates;
extern GLboolean __GLEW_OES_compressed_paletted_texture;
extern GLboolean __GLEW_OES_read_format;
extern GLboolean __GLEW_OES_single_precision;
extern GLboolean __GLEW_OML_interlace;
extern GLboolean __GLEW_OML_resample;
extern GLboolean __GLEW_OML_subsample;
extern GLboolean __GLEW_PGI_misc_hints;
extern GLboolean __GLEW_PGI_vertex_hints;
extern GLboolean __GLEW_REGAL_ES1_0_compatibility;
extern GLboolean __GLEW_REGAL_ES1_1_compatibility;
extern GLboolean __GLEW_REGAL_enable;
extern GLboolean __GLEW_REGAL_error_string;
extern GLboolean __GLEW_REGAL_extension_query;
extern GLboolean __GLEW_REGAL_log;
extern GLboolean __GLEW_REND_screen_coordinates;
extern GLboolean __GLEW_S3_s3tc;
extern GLboolean __GLEW_SGIS_color_range;
extern GLboolean __GLEW_SGIS_detail_texture;
extern GLboolean __GLEW_SGIS_fog_function;
extern GLboolean __GLEW_SGIS_generate_mipmap;
extern GLboolean __GLEW_SGIS_multisample;
extern GLboolean __GLEW_SGIS_pixel_texture;
extern GLboolean __GLEW_SGIS_point_line_texgen;
extern GLboolean __GLEW_SGIS_sharpen_texture;
extern GLboolean __GLEW_SGIS_texture4D;
extern GLboolean __GLEW_SGIS_texture_border_clamp;
extern GLboolean __GLEW_SGIS_texture_edge_clamp;
extern GLboolean __GLEW_SGIS_texture_filter4;
extern GLboolean __GLEW_SGIS_texture_lod;
extern GLboolean __GLEW_SGIS_texture_select;
extern GLboolean __GLEW_SGIX_async;
extern GLboolean __GLEW_SGIX_async_histogram;
extern GLboolean __GLEW_SGIX_async_pixel;
extern GLboolean __GLEW_SGIX_blend_alpha_minmax;
extern GLboolean __GLEW_SGIX_clipmap;
extern GLboolean __GLEW_SGIX_convolution_accuracy;
extern GLboolean __GLEW_SGIX_depth_texture;
extern GLboolean __GLEW_SGIX_flush_raster;
extern GLboolean __GLEW_SGIX_fog_offset;
extern GLboolean __GLEW_SGIX_fog_texture;
extern GLboolean __GLEW_SGIX_fragment_specular_lighting;
extern GLboolean __GLEW_SGIX_framezoom;
extern GLboolean __GLEW_SGIX_interlace;
extern GLboolean __GLEW_SGIX_ir_instrument1;
extern GLboolean __GLEW_SGIX_list_priority;
extern GLboolean __GLEW_SGIX_pixel_texture;
extern GLboolean __GLEW_SGIX_pixel_texture_bits;
extern GLboolean __GLEW_SGIX_reference_plane;
extern GLboolean __GLEW_SGIX_resample;
extern GLboolean __GLEW_SGIX_shadow;
extern GLboolean __GLEW_SGIX_shadow_ambient;
extern GLboolean __GLEW_SGIX_sprite;
extern GLboolean __GLEW_SGIX_tag_sample_buffer;
extern GLboolean __GLEW_SGIX_texture_add_env;
extern GLboolean __GLEW_SGIX_texture_coordinate_clamp;
extern GLboolean __GLEW_SGIX_texture_lod_bias;
extern GLboolean __GLEW_SGIX_texture_multi_buffer;
extern GLboolean __GLEW_SGIX_texture_range;
extern GLboolean __GLEW_SGIX_texture_scale_bias;
extern GLboolean __GLEW_SGIX_vertex_preclip;
extern GLboolean __GLEW_SGIX_vertex_preclip_hint;
extern GLboolean __GLEW_SGIX_ycrcb;
extern GLboolean __GLEW_SGI_color_matrix;
extern GLboolean __GLEW_SGI_color_table;
extern GLboolean __GLEW_SGI_texture_color_table;
extern GLboolean __GLEW_SUNX_constant_data;
extern GLboolean __GLEW_SUN_convolution_border_modes;
extern GLboolean __GLEW_SUN_global_alpha;
extern GLboolean __GLEW_SUN_mesh_array;
extern GLboolean __GLEW_SUN_read_video_pixels;
extern GLboolean __GLEW_SUN_slice_accum;
extern GLboolean __GLEW_SUN_triangle_list;
extern GLboolean __GLEW_SUN_vertex;
extern GLboolean __GLEW_WIN_phong_shading;
extern GLboolean __GLEW_WIN_specular_fog;
extern GLboolean __GLEW_WIN_swap_hint;
]]
  --auto-generated api from ffi headers
  local api =
         {
         ["__GLEW_VERSION_1_1"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_VERSION_1_2"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_VERSION_1_2_1"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_VERSION_1_3"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_VERSION_1_4"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_VERSION_1_5"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_VERSION_2_0"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_VERSION_2_1"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_VERSION_3_0"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_VERSION_3_1"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_VERSION_3_2"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_VERSION_3_3"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_VERSION_4_0"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_VERSION_4_1"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_VERSION_4_2"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_VERSION_4_3"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_VERSION_4_4"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_3DFX_multisample"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_3DFX_tbuffer"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_3DFX_texture_compression_FXT1"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_AMD_blend_minmax_factor"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_AMD_conservative_depth"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_AMD_debug_output"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_AMD_depth_clamp_separate"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_AMD_draw_buffers_blend"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_AMD_interleaved_elements"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_AMD_multi_draw_indirect"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_AMD_name_gen_delete"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_AMD_performance_monitor"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_AMD_pinned_memory"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_AMD_query_buffer_object"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_AMD_sample_positions"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_AMD_seamless_cubemap_per_texture"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_AMD_shader_stencil_export"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_AMD_shader_trinary_minmax"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_AMD_sparse_texture"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_AMD_stencil_operation_extended"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_AMD_texture_texture4"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_AMD_transform_feedback3_lines_triangles"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_AMD_vertex_shader_layer"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_AMD_vertex_shader_tessellator"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_AMD_vertex_shader_viewport_index"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ANGLE_depth_texture"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ANGLE_framebuffer_blit"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ANGLE_framebuffer_multisample"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ANGLE_instanced_arrays"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ANGLE_pack_reverse_row_order"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ANGLE_program_binary"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ANGLE_texture_compression_dxt1"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ANGLE_texture_compression_dxt3"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ANGLE_texture_compression_dxt5"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ANGLE_texture_usage"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ANGLE_timer_query"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ANGLE_translated_shader_source"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_APPLE_aux_depth_stencil"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_APPLE_client_storage"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_APPLE_element_array"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_APPLE_fence"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_APPLE_float_pixels"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_APPLE_flush_buffer_range"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_APPLE_object_purgeable"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_APPLE_pixel_buffer"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_APPLE_rgb_422"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_APPLE_row_bytes"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_APPLE_specular_vector"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_APPLE_texture_range"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_APPLE_transform_hint"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_APPLE_vertex_array_object"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_APPLE_vertex_array_range"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_APPLE_vertex_program_evaluators"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_APPLE_ycbcr_422"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_ES2_compatibility"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_ES3_compatibility"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_arrays_of_arrays"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_base_instance"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_bindless_texture"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_blend_func_extended"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_buffer_storage"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_cl_event"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_clear_buffer_object"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_clear_texture"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_color_buffer_float"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_compatibility"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_compressed_texture_pixel_storage"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_compute_shader"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_compute_variable_group_size"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_conservative_depth"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_copy_buffer"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_copy_image"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_debug_output"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_depth_buffer_float"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_depth_clamp"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_depth_texture"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_draw_buffers"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_draw_buffers_blend"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_draw_elements_base_vertex"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_draw_indirect"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_draw_instanced"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_enhanced_layouts"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_explicit_attrib_location"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_explicit_uniform_location"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_fragment_coord_conventions"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_fragment_layer_viewport"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_fragment_program"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_fragment_program_shadow"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_fragment_shader"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_framebuffer_no_attachments"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_framebuffer_object"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_framebuffer_sRGB"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_geometry_shader4"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_get_program_binary"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_gpu_shader5"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_gpu_shader_fp64"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_half_float_pixel"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_half_float_vertex"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_imaging"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_indirect_parameters"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_instanced_arrays"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_internalformat_query"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_internalformat_query2"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_invalidate_subdata"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_map_buffer_alignment"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_map_buffer_range"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_matrix_palette"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_multi_bind"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_multi_draw_indirect"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_multisample"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_multitexture"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_occlusion_query"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_occlusion_query2"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_pixel_buffer_object"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_point_parameters"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_point_sprite"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_program_interface_query"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_provoking_vertex"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_query_buffer_object"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_robust_buffer_access_behavior"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_robustness"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_robustness_application_isolation"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_robustness_share_group_isolation"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_sample_shading"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_sampler_objects"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_seamless_cube_map"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_seamless_cubemap_per_texture"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_separate_shader_objects"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_shader_atomic_counters"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_shader_bit_encoding"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_shader_draw_parameters"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_shader_group_vote"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_shader_image_load_store"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_shader_image_size"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_shader_objects"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_shader_precision"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_shader_stencil_export"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_shader_storage_buffer_object"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_shader_subroutine"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_shader_texture_lod"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_shading_language_100"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_shading_language_420pack"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_shading_language_include"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_shading_language_packing"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_shadow"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_shadow_ambient"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_sparse_texture"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_stencil_texturing"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_sync"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_tessellation_shader"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_texture_border_clamp"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_texture_buffer_object"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_texture_buffer_object_rgb32"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_texture_buffer_range"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_texture_compression"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_texture_compression_bptc"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_texture_compression_rgtc"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_texture_cube_map"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_texture_cube_map_array"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_texture_env_add"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_texture_env_combine"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_texture_env_crossbar"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_texture_env_dot3"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_texture_float"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_texture_gather"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_texture_mirror_clamp_to_edge"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_texture_mirrored_repeat"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_texture_multisample"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_texture_non_power_of_two"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_texture_query_levels"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_texture_query_lod"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_texture_rectangle"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_texture_rg"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_texture_rgb10_a2ui"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_texture_stencil8"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_texture_storage"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_texture_storage_multisample"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_texture_swizzle"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_texture_view"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_timer_query"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_transform_feedback2"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_transform_feedback3"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_transform_feedback_instanced"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_transpose_matrix"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_uniform_buffer_object"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_vertex_array_bgra"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_vertex_array_object"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_vertex_attrib_64bit"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_vertex_attrib_binding"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_vertex_blend"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_vertex_buffer_object"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_vertex_program"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_vertex_shader"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_vertex_type_10f_11f_11f_rev"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_vertex_type_2_10_10_10_rev"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_viewport_array"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ARB_window_pos"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ATIX_point_sprites"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ATIX_texture_env_combine3"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ATIX_texture_env_route"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ATIX_vertex_shader_output_point_size"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ATI_draw_buffers"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ATI_element_array"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ATI_envmap_bumpmap"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ATI_fragment_shader"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ATI_map_object_buffer"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ATI_meminfo"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ATI_pn_triangles"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ATI_separate_stencil"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ATI_shader_texture_lod"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ATI_text_fragment_shader"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ATI_texture_compression_3dc"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ATI_texture_env_combine3"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ATI_texture_float"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ATI_texture_mirror_once"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ATI_vertex_array_object"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ATI_vertex_attrib_array_object"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_ATI_vertex_streams"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_422_pixels"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_Cg_shader"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_abgr"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_bgra"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_bindable_uniform"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_blend_color"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_blend_equation_separate"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_blend_func_separate"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_blend_logic_op"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_blend_minmax"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_blend_subtract"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_clip_volume_hint"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_cmyka"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_color_subtable"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_compiled_vertex_array"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_convolution"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_coordinate_frame"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_copy_texture"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_cull_vertex"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_debug_marker"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_depth_bounds_test"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_direct_state_access"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_draw_buffers2"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_draw_instanced"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_draw_range_elements"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_fog_coord"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_fragment_lighting"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_framebuffer_blit"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_framebuffer_multisample"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_framebuffer_multisample_blit_scaled"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_framebuffer_object"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_framebuffer_sRGB"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_geometry_shader4"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_gpu_program_parameters"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_gpu_shader4"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_histogram"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_index_array_formats"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_index_func"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_index_material"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_index_texture"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_light_texture"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_misc_attribute"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_multi_draw_arrays"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_multisample"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_packed_depth_stencil"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_packed_float"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_packed_pixels"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_paletted_texture"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_pixel_buffer_object"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_pixel_transform"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_pixel_transform_color_table"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_point_parameters"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_polygon_offset"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_provoking_vertex"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_rescale_normal"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_scene_marker"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_secondary_color"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_separate_shader_objects"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_separate_specular_color"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_shader_image_load_store"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_shadow_funcs"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_shared_texture_palette"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_stencil_clear_tag"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_stencil_two_side"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_stencil_wrap"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_subtexture"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_texture"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_texture3D"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_texture_array"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_texture_buffer_object"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_texture_compression_dxt1"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_texture_compression_latc"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_texture_compression_rgtc"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_texture_compression_s3tc"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_texture_cube_map"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_texture_edge_clamp"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_texture_env"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_texture_env_add"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_texture_env_combine"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_texture_env_dot3"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_texture_filter_anisotropic"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_texture_integer"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_texture_lod_bias"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_texture_mirror_clamp"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_texture_object"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_texture_perturb_normal"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_texture_rectangle"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_texture_sRGB"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_texture_sRGB_decode"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_texture_shared_exponent"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_texture_snorm"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_texture_swizzle"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_timer_query"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_transform_feedback"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_vertex_array"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_vertex_array_bgra"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_vertex_attrib_64bit"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_vertex_shader"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_vertex_weighting"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_EXT_x11_sync_object"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_GREMEDY_frame_terminator"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_GREMEDY_string_marker"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_HP_convolution_border_modes"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_HP_image_transform"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_HP_occlusion_test"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_HP_texture_lighting"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_IBM_cull_vertex"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_IBM_multimode_draw_arrays"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_IBM_rasterpos_clip"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_IBM_static_data"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_IBM_texture_mirrored_repeat"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_IBM_vertex_array_lists"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_INGR_color_clamp"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_INGR_interlace_read"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_INTEL_map_texture"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_INTEL_parallel_arrays"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_INTEL_texture_scissor"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_KHR_debug"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_KHR_texture_compression_astc_ldr"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_KTX_buffer_region"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_MESAX_texture_stack"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_MESA_pack_invert"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_MESA_resize_buffers"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_MESA_window_pos"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_MESA_ycbcr_texture"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NVX_conditional_render"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NVX_gpu_memory_info"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_bindless_multi_draw_indirect"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_bindless_texture"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_blend_equation_advanced"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_blend_equation_advanced_coherent"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_blend_square"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_compute_program5"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_conditional_render"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_copy_depth_to_color"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_copy_image"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_deep_texture3D"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_depth_buffer_float"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_depth_clamp"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_depth_range_unclamped"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_draw_texture"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_evaluators"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_explicit_multisample"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_fence"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_float_buffer"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_fog_distance"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_fragment_program"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_fragment_program2"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_fragment_program4"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_fragment_program_option"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_framebuffer_multisample_coverage"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_geometry_program4"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_geometry_shader4"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_gpu_program4"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_gpu_program5"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_gpu_program5_mem_extended"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_gpu_program_fp64"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_gpu_shader5"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_half_float"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_light_max_exponent"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_multisample_coverage"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_multisample_filter_hint"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_occlusion_query"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_packed_depth_stencil"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_parameter_buffer_object"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_parameter_buffer_object2"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_path_rendering"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_pixel_data_range"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_point_sprite"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_present_video"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_primitive_restart"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_register_combiners"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_register_combiners2"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_shader_atomic_counters"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_shader_atomic_float"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_shader_buffer_load"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_shader_storage_buffer_object"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_tessellation_program5"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_texgen_emboss"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_texgen_reflection"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_texture_barrier"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_texture_compression_vtc"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_texture_env_combine4"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_texture_expand_normal"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_texture_multisample"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_texture_rectangle"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_texture_shader"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_texture_shader2"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_texture_shader3"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_transform_feedback"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_transform_feedback2"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_vdpau_interop"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_vertex_array_range"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_vertex_array_range2"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_vertex_attrib_integer_64bit"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_vertex_buffer_unified_memory"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_vertex_program"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_vertex_program1_1"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_vertex_program2"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_vertex_program2_option"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_vertex_program3"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_vertex_program4"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_NV_video_capture"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_OES_byte_coordinates"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_OES_compressed_paletted_texture"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_OES_read_format"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_OES_single_precision"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_OML_interlace"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_OML_resample"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_OML_subsample"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_PGI_misc_hints"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_PGI_vertex_hints"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_REGAL_ES1_0_compatibility"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_REGAL_ES1_1_compatibility"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_REGAL_enable"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_REGAL_error_string"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_REGAL_extension_query"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_REGAL_log"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_REND_screen_coordinates"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_S3_s3tc"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGIS_color_range"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGIS_detail_texture"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGIS_fog_function"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGIS_generate_mipmap"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGIS_multisample"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGIS_pixel_texture"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGIS_point_line_texgen"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGIS_sharpen_texture"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGIS_texture4D"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGIS_texture_border_clamp"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGIS_texture_edge_clamp"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGIS_texture_filter4"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGIS_texture_lod"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGIS_texture_select"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGIX_async"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGIX_async_histogram"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGIX_async_pixel"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGIX_blend_alpha_minmax"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGIX_clipmap"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGIX_convolution_accuracy"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGIX_depth_texture"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGIX_flush_raster"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGIX_fog_offset"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGIX_fog_texture"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGIX_fragment_specular_lighting"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGIX_framezoom"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGIX_interlace"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGIX_ir_instrument1"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGIX_list_priority"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGIX_pixel_texture"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGIX_pixel_texture_bits"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGIX_reference_plane"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGIX_resample"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGIX_shadow"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGIX_shadow_ambient"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGIX_sprite"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGIX_tag_sample_buffer"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGIX_texture_add_env"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGIX_texture_coordinate_clamp"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGIX_texture_lod_bias"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGIX_texture_multi_buffer"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGIX_texture_range"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGIX_texture_scale_bias"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGIX_vertex_preclip"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGIX_vertex_preclip_hint"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGIX_ycrcb"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGI_color_matrix"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGI_color_table"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SGI_texture_color_table"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SUNX_constant_data"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SUN_convolution_border_modes"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SUN_global_alpha"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SUN_mesh_array"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SUN_read_video_pixels"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SUN_slice_accum"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SUN_triangle_list"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_SUN_vertex"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_WIN_phong_shading"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_WIN_specular_fog"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["__GLEW_WIN_swap_hint"] = { type ='value', description = "extern GLboolean", valuetype = nil, },
       ["GL_ZERO"] = { type ='value', },
       ["GL_FALSE"] = { type ='value', },
       ["GL_LOGIC_OP"] = { type ='value', },
       ["GL_NONE"] = { type ='value', },
       ["GL_TEXTURE_COMPONENTS"] = { type ='value', },
       ["GL_NO_ERROR"] = { type ='value', },
       ["GL_POINTS"] = { type ='value', },
       ["GL_CURRENT_BIT"] = { type ='value', },
       ["GL_TRUE"] = { type ='value', },
       ["GL_ONE"] = { type ='value', },
       ["GL_CLIENT_PIXEL_STORE_BIT"] = { type ='value', },
       ["GL_LINES"] = { type ='value', },
       ["GL_LINE_LOOP"] = { type ='value', },
       ["GL_POINT_BIT"] = { type ='value', },
       ["GL_CLIENT_VERTEX_ARRAY_BIT"] = { type ='value', },
       ["GL_LINE_STRIP"] = { type ='value', },
       ["GL_LINE_BIT"] = { type ='value', },
       ["GL_TRIANGLES"] = { type ='value', },
       ["GL_TRIANGLE_STRIP"] = { type ='value', },
       ["GL_TRIANGLE_FAN"] = { type ='value', },
       ["GL_QUADS"] = { type ='value', },
       ["GL_QUAD_STRIP"] = { type ='value', },
       ["GL_POLYGON_BIT"] = { type ='value', },
       ["GL_POLYGON"] = { type ='value', },
       ["GL_POLYGON_STIPPLE_BIT"] = { type ='value', },
       ["GL_PIXEL_MODE_BIT"] = { type ='value', },
       ["GL_LIGHTING_BIT"] = { type ='value', },
       ["GL_FOG_BIT"] = { type ='value', },
       ["GL_DEPTH_BUFFER_BIT"] = { type ='value', },
       ["GL_ACCUM"] = { type ='value', },
       ["GL_LOAD"] = { type ='value', },
       ["GL_RETURN"] = { type ='value', },
       ["GL_MULT"] = { type ='value', },
       ["GL_ADD"] = { type ='value', },
       ["GL_NEVER"] = { type ='value', },
       ["GL_ACCUM_BUFFER_BIT"] = { type ='value', },
       ["GL_LESS"] = { type ='value', },
       ["GL_EQUAL"] = { type ='value', },
       ["GL_LEQUAL"] = { type ='value', },
       ["GL_GREATER"] = { type ='value', },
       ["GL_NOTEQUAL"] = { type ='value', },
       ["GL_GEQUAL"] = { type ='value', },
       ["GL_ALWAYS"] = { type ='value', },
       ["GL_SRC_COLOR"] = { type ='value', },
       ["GL_ONE_MINUS_SRC_COLOR"] = { type ='value', },
       ["GL_SRC_ALPHA"] = { type ='value', },
       ["GL_ONE_MINUS_SRC_ALPHA"] = { type ='value', },
       ["GL_DST_ALPHA"] = { type ='value', },
       ["GL_ONE_MINUS_DST_ALPHA"] = { type ='value', },
       ["GL_DST_COLOR"] = { type ='value', },
       ["GL_ONE_MINUS_DST_COLOR"] = { type ='value', },
       ["GL_SRC_ALPHA_SATURATE"] = { type ='value', },
       ["GL_STENCIL_BUFFER_BIT"] = { type ='value', },
       ["GL_FRONT_LEFT"] = { type ='value', },
       ["GL_FRONT_RIGHT"] = { type ='value', },
       ["GL_BACK_LEFT"] = { type ='value', },
       ["GL_BACK_RIGHT"] = { type ='value', },
       ["GL_FRONT"] = { type ='value', },
       ["GL_BACK"] = { type ='value', },
       ["GL_LEFT"] = { type ='value', },
       ["GL_RIGHT"] = { type ='value', },
       ["GL_FRONT_AND_BACK"] = { type ='value', },
       ["GL_AUX0"] = { type ='value', },
       ["GL_AUX1"] = { type ='value', },
       ["GL_AUX2"] = { type ='value', },
       ["GL_AUX3"] = { type ='value', },
       ["GL_INVALID_ENUM"] = { type ='value', },
       ["GL_INVALID_VALUE"] = { type ='value', },
       ["GL_INVALID_OPERATION"] = { type ='value', },
       ["GL_STACK_OVERFLOW"] = { type ='value', },
       ["GL_STACK_UNDERFLOW"] = { type ='value', },
       ["GL_OUT_OF_MEMORY"] = { type ='value', },
       ["GL_2D"] = { type ='value', },
       ["GL_3D"] = { type ='value', },
       ["GL_3D_COLOR"] = { type ='value', },
       ["GL_3D_COLOR_TEXTURE"] = { type ='value', },
       ["GL_4D_COLOR_TEXTURE"] = { type ='value', },
       ["GL_PASS_THROUGH_TOKEN"] = { type ='value', },
       ["GL_POINT_TOKEN"] = { type ='value', },
       ["GL_LINE_TOKEN"] = { type ='value', },
       ["GL_POLYGON_TOKEN"] = { type ='value', },
       ["GL_BITMAP_TOKEN"] = { type ='value', },
       ["GL_DRAW_PIXEL_TOKEN"] = { type ='value', },
       ["GL_COPY_PIXEL_TOKEN"] = { type ='value', },
       ["GL_LINE_RESET_TOKEN"] = { type ='value', },
       ["GL_EXP"] = { type ='value', },
       ["GL_VIEWPORT_BIT"] = { type ='value', },
       ["GL_EXP2"] = { type ='value', },
       ["GL_CW"] = { type ='value', },
       ["GL_CCW"] = { type ='value', },
       ["GL_COEFF"] = { type ='value', },
       ["GL_ORDER"] = { type ='value', },
       ["GL_DOMAIN"] = { type ='value', },
       ["GL_CURRENT_COLOR"] = { type ='value', },
       ["GL_CURRENT_INDEX"] = { type ='value', },
       ["GL_CURRENT_NORMAL"] = { type ='value', },
       ["GL_CURRENT_TEXTURE_COORDS"] = { type ='value', },
       ["GL_CURRENT_RASTER_COLOR"] = { type ='value', },
       ["GL_CURRENT_RASTER_INDEX"] = { type ='value', },
       ["GL_CURRENT_RASTER_TEXTURE_COORDS"] = { type ='value', },
       ["GL_CURRENT_RASTER_POSITION"] = { type ='value', },
       ["GL_CURRENT_RASTER_POSITION_VALID"] = { type ='value', },
       ["GL_CURRENT_RASTER_DISTANCE"] = { type ='value', },
       ["GL_POINT_SMOOTH"] = { type ='value', },
       ["GL_POINT_SIZE"] = { type ='value', },
       ["GL_POINT_SIZE_RANGE"] = { type ='value', },
       ["GL_POINT_SIZE_GRANULARITY"] = { type ='value', },
       ["GL_LINE_SMOOTH"] = { type ='value', },
       ["GL_LINE_WIDTH"] = { type ='value', },
       ["GL_LINE_WIDTH_RANGE"] = { type ='value', },
       ["GL_LINE_WIDTH_GRANULARITY"] = { type ='value', },
       ["GL_LINE_STIPPLE"] = { type ='value', },
       ["GL_LINE_STIPPLE_PATTERN"] = { type ='value', },
       ["GL_LINE_STIPPLE_REPEAT"] = { type ='value', },
       ["GL_LIST_MODE"] = { type ='value', },
       ["GL_MAX_LIST_NESTING"] = { type ='value', },
       ["GL_LIST_BASE"] = { type ='value', },
       ["GL_LIST_INDEX"] = { type ='value', },
       ["GL_POLYGON_MODE"] = { type ='value', },
       ["GL_POLYGON_SMOOTH"] = { type ='value', },
       ["GL_POLYGON_STIPPLE"] = { type ='value', },
       ["GL_EDGE_FLAG"] = { type ='value', },
       ["GL_CULL_FACE"] = { type ='value', },
       ["GL_CULL_FACE_MODE"] = { type ='value', },
       ["GL_FRONT_FACE"] = { type ='value', },
       ["GL_LIGHTING"] = { type ='value', },
       ["GL_LIGHT_MODEL_LOCAL_VIEWER"] = { type ='value', },
       ["GL_LIGHT_MODEL_TWO_SIDE"] = { type ='value', },
       ["GL_LIGHT_MODEL_AMBIENT"] = { type ='value', },
       ["GL_SHADE_MODEL"] = { type ='value', },
       ["GL_COLOR_MATERIAL_FACE"] = { type ='value', },
       ["GL_COLOR_MATERIAL_PARAMETER"] = { type ='value', },
       ["GL_COLOR_MATERIAL"] = { type ='value', },
       ["GL_FOG"] = { type ='value', },
       ["GL_FOG_INDEX"] = { type ='value', },
       ["GL_FOG_DENSITY"] = { type ='value', },
       ["GL_FOG_START"] = { type ='value', },
       ["GL_FOG_END"] = { type ='value', },
       ["GL_FOG_MODE"] = { type ='value', },
       ["GL_FOG_COLOR"] = { type ='value', },
       ["GL_DEPTH_RANGE"] = { type ='value', },
       ["GL_DEPTH_TEST"] = { type ='value', },
       ["GL_DEPTH_WRITEMASK"] = { type ='value', },
       ["GL_DEPTH_CLEAR_VALUE"] = { type ='value', },
       ["GL_DEPTH_FUNC"] = { type ='value', },
       ["GL_ACCUM_CLEAR_VALUE"] = { type ='value', },
       ["GL_STENCIL_TEST"] = { type ='value', },
       ["GL_STENCIL_CLEAR_VALUE"] = { type ='value', },
       ["GL_STENCIL_FUNC"] = { type ='value', },
       ["GL_STENCIL_VALUE_MASK"] = { type ='value', },
       ["GL_STENCIL_FAIL"] = { type ='value', },
       ["GL_STENCIL_PASS_DEPTH_FAIL"] = { type ='value', },
       ["GL_STENCIL_PASS_DEPTH_PASS"] = { type ='value', },
       ["GL_STENCIL_REF"] = { type ='value', },
       ["GL_STENCIL_WRITEMASK"] = { type ='value', },
       ["GL_MATRIX_MODE"] = { type ='value', },
       ["GL_NORMALIZE"] = { type ='value', },
       ["GL_VIEWPORT"] = { type ='value', },
       ["GL_MODELVIEW_STACK_DEPTH"] = { type ='value', },
       ["GL_PROJECTION_STACK_DEPTH"] = { type ='value', },
       ["GL_TEXTURE_STACK_DEPTH"] = { type ='value', },
       ["GL_MODELVIEW_MATRIX"] = { type ='value', },
       ["GL_PROJECTION_MATRIX"] = { type ='value', },
       ["GL_TEXTURE_MATRIX"] = { type ='value', },
       ["GL_ATTRIB_STACK_DEPTH"] = { type ='value', },
       ["GL_CLIENT_ATTRIB_STACK_DEPTH"] = { type ='value', },
       ["GL_ALPHA_TEST"] = { type ='value', },
       ["GL_ALPHA_TEST_FUNC"] = { type ='value', },
       ["GL_ALPHA_TEST_REF"] = { type ='value', },
       ["GL_DITHER"] = { type ='value', },
       ["GL_BLEND_DST"] = { type ='value', },
       ["GL_BLEND_SRC"] = { type ='value', },
       ["GL_BLEND"] = { type ='value', },
       ["GL_LOGIC_OP_MODE"] = { type ='value', },
       ["GL_INDEX_LOGIC_OP"] = { type ='value', },
       ["GL_COLOR_LOGIC_OP"] = { type ='value', },
       ["GL_AUX_BUFFERS"] = { type ='value', },
       ["GL_DRAW_BUFFER"] = { type ='value', },
       ["GL_READ_BUFFER"] = { type ='value', },
       ["GL_SCISSOR_BOX"] = { type ='value', },
       ["GL_SCISSOR_TEST"] = { type ='value', },
       ["GL_INDEX_CLEAR_VALUE"] = { type ='value', },
       ["GL_INDEX_WRITEMASK"] = { type ='value', },
       ["GL_COLOR_CLEAR_VALUE"] = { type ='value', },
       ["GL_COLOR_WRITEMASK"] = { type ='value', },
       ["GL_INDEX_MODE"] = { type ='value', },
       ["GL_RGBA_MODE"] = { type ='value', },
       ["GL_DOUBLEBUFFER"] = { type ='value', },
       ["GL_STEREO"] = { type ='value', },
       ["GL_RENDER_MODE"] = { type ='value', },
       ["GL_PERSPECTIVE_CORRECTION_HINT"] = { type ='value', },
       ["GL_POINT_SMOOTH_HINT"] = { type ='value', },
       ["GL_LINE_SMOOTH_HINT"] = { type ='value', },
       ["GL_POLYGON_SMOOTH_HINT"] = { type ='value', },
       ["GL_FOG_HINT"] = { type ='value', },
       ["GL_TEXTURE_GEN_S"] = { type ='value', },
       ["GL_TEXTURE_GEN_T"] = { type ='value', },
       ["GL_TEXTURE_GEN_R"] = { type ='value', },
       ["GL_TEXTURE_GEN_Q"] = { type ='value', },
       ["GL_PIXEL_MAP_I_TO_I"] = { type ='value', },
       ["GL_PIXEL_MAP_S_TO_S"] = { type ='value', },
       ["GL_PIXEL_MAP_I_TO_R"] = { type ='value', },
       ["GL_PIXEL_MAP_I_TO_G"] = { type ='value', },
       ["GL_PIXEL_MAP_I_TO_B"] = { type ='value', },
       ["GL_PIXEL_MAP_I_TO_A"] = { type ='value', },
       ["GL_PIXEL_MAP_R_TO_R"] = { type ='value', },
       ["GL_PIXEL_MAP_G_TO_G"] = { type ='value', },
       ["GL_PIXEL_MAP_B_TO_B"] = { type ='value', },
       ["GL_PIXEL_MAP_A_TO_A"] = { type ='value', },
       ["GL_PIXEL_MAP_I_TO_I_SIZE"] = { type ='value', },
       ["GL_PIXEL_MAP_S_TO_S_SIZE"] = { type ='value', },
       ["GL_PIXEL_MAP_I_TO_R_SIZE"] = { type ='value', },
       ["GL_PIXEL_MAP_I_TO_G_SIZE"] = { type ='value', },
       ["GL_PIXEL_MAP_I_TO_B_SIZE"] = { type ='value', },
       ["GL_PIXEL_MAP_I_TO_A_SIZE"] = { type ='value', },
       ["GL_PIXEL_MAP_R_TO_R_SIZE"] = { type ='value', },
       ["GL_PIXEL_MAP_G_TO_G_SIZE"] = { type ='value', },
       ["GL_PIXEL_MAP_B_TO_B_SIZE"] = { type ='value', },
       ["GL_PIXEL_MAP_A_TO_A_SIZE"] = { type ='value', },
       ["GL_UNPACK_SWAP_BYTES"] = { type ='value', },
       ["GL_UNPACK_LSB_FIRST"] = { type ='value', },
       ["GL_UNPACK_ROW_LENGTH"] = { type ='value', },
       ["GL_UNPACK_SKIP_ROWS"] = { type ='value', },
       ["GL_UNPACK_SKIP_PIXELS"] = { type ='value', },
       ["GL_UNPACK_ALIGNMENT"] = { type ='value', },
       ["GL_PACK_SWAP_BYTES"] = { type ='value', },
       ["GL_PACK_LSB_FIRST"] = { type ='value', },
       ["GL_PACK_ROW_LENGTH"] = { type ='value', },
       ["GL_PACK_SKIP_ROWS"] = { type ='value', },
       ["GL_PACK_SKIP_PIXELS"] = { type ='value', },
       ["GL_PACK_ALIGNMENT"] = { type ='value', },
       ["GL_MAP_COLOR"] = { type ='value', },
       ["GL_MAP_STENCIL"] = { type ='value', },
       ["GL_INDEX_SHIFT"] = { type ='value', },
       ["GL_INDEX_OFFSET"] = { type ='value', },
       ["GL_RED_SCALE"] = { type ='value', },
       ["GL_RED_BIAS"] = { type ='value', },
       ["GL_ZOOM_X"] = { type ='value', },
       ["GL_ZOOM_Y"] = { type ='value', },
       ["GL_GREEN_SCALE"] = { type ='value', },
       ["GL_GREEN_BIAS"] = { type ='value', },
       ["GL_BLUE_SCALE"] = { type ='value', },
       ["GL_BLUE_BIAS"] = { type ='value', },
       ["GL_ALPHA_SCALE"] = { type ='value', },
       ["GL_ALPHA_BIAS"] = { type ='value', },
       ["GL_DEPTH_SCALE"] = { type ='value', },
       ["GL_DEPTH_BIAS"] = { type ='value', },
       ["GL_MAX_EVAL_ORDER"] = { type ='value', },
       ["GL_MAX_LIGHTS"] = { type ='value', },
       ["GL_MAX_CLIP_PLANES"] = { type ='value', },
       ["GL_MAX_TEXTURE_SIZE"] = { type ='value', },
       ["GL_MAX_PIXEL_MAP_TABLE"] = { type ='value', },
       ["GL_MAX_ATTRIB_STACK_DEPTH"] = { type ='value', },
       ["GL_MAX_MODELVIEW_STACK_DEPTH"] = { type ='value', },
       ["GL_MAX_NAME_STACK_DEPTH"] = { type ='value', },
       ["GL_MAX_PROJECTION_STACK_DEPTH"] = { type ='value', },
       ["GL_MAX_TEXTURE_STACK_DEPTH"] = { type ='value', },
       ["GL_MAX_VIEWPORT_DIMS"] = { type ='value', },
       ["GL_MAX_CLIENT_ATTRIB_STACK_DEPTH"] = { type ='value', },
       ["GL_SUBPIXEL_BITS"] = { type ='value', },
       ["GL_INDEX_BITS"] = { type ='value', },
       ["GL_RED_BITS"] = { type ='value', },
       ["GL_GREEN_BITS"] = { type ='value', },
       ["GL_BLUE_BITS"] = { type ='value', },
       ["GL_ALPHA_BITS"] = { type ='value', },
       ["GL_DEPTH_BITS"] = { type ='value', },
       ["GL_STENCIL_BITS"] = { type ='value', },
       ["GL_ACCUM_RED_BITS"] = { type ='value', },
       ["GL_ACCUM_GREEN_BITS"] = { type ='value', },
       ["GL_ACCUM_BLUE_BITS"] = { type ='value', },
       ["GL_ACCUM_ALPHA_BITS"] = { type ='value', },
       ["GL_NAME_STACK_DEPTH"] = { type ='value', },
       ["GL_AUTO_NORMAL"] = { type ='value', },
       ["GL_MAP1_COLOR_4"] = { type ='value', },
       ["GL_MAP1_INDEX"] = { type ='value', },
       ["GL_MAP1_NORMAL"] = { type ='value', },
       ["GL_MAP1_TEXTURE_COORD_1"] = { type ='value', },
       ["GL_MAP1_TEXTURE_COORD_2"] = { type ='value', },
       ["GL_MAP1_TEXTURE_COORD_3"] = { type ='value', },
       ["GL_MAP1_TEXTURE_COORD_4"] = { type ='value', },
       ["GL_MAP1_VERTEX_3"] = { type ='value', },
       ["GL_MAP1_VERTEX_4"] = { type ='value', },
       ["GL_MAP2_COLOR_4"] = { type ='value', },
       ["GL_MAP2_INDEX"] = { type ='value', },
       ["GL_MAP2_NORMAL"] = { type ='value', },
       ["GL_MAP2_TEXTURE_COORD_1"] = { type ='value', },
       ["GL_MAP2_TEXTURE_COORD_2"] = { type ='value', },
       ["GL_MAP2_TEXTURE_COORD_3"] = { type ='value', },
       ["GL_MAP2_TEXTURE_COORD_4"] = { type ='value', },
       ["GL_MAP2_VERTEX_3"] = { type ='value', },
       ["GL_MAP2_VERTEX_4"] = { type ='value', },
       ["GL_MAP1_GRID_DOMAIN"] = { type ='value', },
       ["GL_MAP1_GRID_SEGMENTS"] = { type ='value', },
       ["GL_MAP2_GRID_DOMAIN"] = { type ='value', },
       ["GL_MAP2_GRID_SEGMENTS"] = { type ='value', },
       ["GL_TEXTURE_1D"] = { type ='value', },
       ["GL_TEXTURE_2D"] = { type ='value', },
       ["GL_FEEDBACK_BUFFER_POINTER"] = { type ='value', },
       ["GL_FEEDBACK_BUFFER_SIZE"] = { type ='value', },
       ["GL_FEEDBACK_BUFFER_TYPE"] = { type ='value', },
       ["GL_SELECTION_BUFFER_POINTER"] = { type ='value', },
       ["GL_SELECTION_BUFFER_SIZE"] = { type ='value', },
       ["GL_TEXTURE_WIDTH"] = { type ='value', },
       ["GL_TRANSFORM_BIT"] = { type ='value', },
       ["GL_TEXTURE_HEIGHT"] = { type ='value', },
       ["GL_TEXTURE_INTERNAL_FORMAT"] = { type ='value', },
       ["GL_TEXTURE_BORDER_COLOR"] = { type ='value', },
       ["GL_TEXTURE_BORDER"] = { type ='value', },
       ["GL_DONT_CARE"] = { type ='value', },
       ["GL_FASTEST"] = { type ='value', },
       ["GL_NICEST"] = { type ='value', },
       ["GL_AMBIENT"] = { type ='value', },
       ["GL_DIFFUSE"] = { type ='value', },
       ["GL_SPECULAR"] = { type ='value', },
       ["GL_POSITION"] = { type ='value', },
       ["GL_SPOT_DIRECTION"] = { type ='value', },
       ["GL_SPOT_EXPONENT"] = { type ='value', },
       ["GL_SPOT_CUTOFF"] = { type ='value', },
       ["GL_CONSTANT_ATTENUATION"] = { type ='value', },
       ["GL_LINEAR_ATTENUATION"] = { type ='value', },
       ["GL_QUADRATIC_ATTENUATION"] = { type ='value', },
       ["GL_COMPILE"] = { type ='value', },
       ["GL_COMPILE_AND_EXECUTE"] = { type ='value', },
       ["GL_BYTE"] = { type ='value', },
       ["GL_UNSIGNED_BYTE"] = { type ='value', },
       ["GL_SHORT"] = { type ='value', },
       ["GL_UNSIGNED_SHORT"] = { type ='value', },
       ["GL_INT"] = { type ='value', },
       ["GL_UNSIGNED_INT"] = { type ='value', },
       ["GL_FLOAT"] = { type ='value', },
       ["GL_2_BYTES"] = { type ='value', },
       ["GL_3_BYTES"] = { type ='value', },
       ["GL_4_BYTES"] = { type ='value', },
       ["GL_DOUBLE"] = { type ='value', },
       ["GL_CLEAR"] = { type ='value', },
       ["GL_AND"] = { type ='value', },
       ["GL_AND_REVERSE"] = { type ='value', },
       ["GL_COPY"] = { type ='value', },
       ["GL_AND_INVERTED"] = { type ='value', },
       ["GL_NOOP"] = { type ='value', },
       ["GL_XOR"] = { type ='value', },
       ["GL_OR"] = { type ='value', },
       ["GL_NOR"] = { type ='value', },
       ["GL_EQUIV"] = { type ='value', },
       ["GL_INVERT"] = { type ='value', },
       ["GL_OR_REVERSE"] = { type ='value', },
       ["GL_COPY_INVERTED"] = { type ='value', },
       ["GL_OR_INVERTED"] = { type ='value', },
       ["GL_NAND"] = { type ='value', },
       ["GL_SET"] = { type ='value', },
       ["GL_EMISSION"] = { type ='value', },
       ["GL_SHININESS"] = { type ='value', },
       ["GL_AMBIENT_AND_DIFFUSE"] = { type ='value', },
       ["GL_COLOR_INDEXES"] = { type ='value', },
       ["GL_MODELVIEW"] = { type ='value', },
       ["GL_PROJECTION"] = { type ='value', },
       ["GL_TEXTURE"] = { type ='value', },
       ["GL_COLOR"] = { type ='value', },
       ["GL_DEPTH"] = { type ='value', },
       ["GL_STENCIL"] = { type ='value', },
       ["GL_COLOR_INDEX"] = { type ='value', },
       ["GL_STENCIL_INDEX"] = { type ='value', },
       ["GL_DEPTH_COMPONENT"] = { type ='value', },
       ["GL_RED"] = { type ='value', },
       ["GL_GREEN"] = { type ='value', },
       ["GL_BLUE"] = { type ='value', },
       ["GL_ALPHA"] = { type ='value', },
       ["GL_RGB"] = { type ='value', },
       ["GL_RGBA"] = { type ='value', },
       ["GL_LUMINANCE"] = { type ='value', },
       ["GL_LUMINANCE_ALPHA"] = { type ='value', },
       ["GL_BITMAP"] = { type ='value', },
       ["GL_POINT"] = { type ='value', },
       ["GL_LINE"] = { type ='value', },
       ["GL_FILL"] = { type ='value', },
       ["GL_RENDER"] = { type ='value', },
       ["GL_FEEDBACK"] = { type ='value', },
       ["GL_SELECT"] = { type ='value', },
       ["GL_FLAT"] = { type ='value', },
       ["GL_SMOOTH"] = { type ='value', },
       ["GL_KEEP"] = { type ='value', },
       ["GL_REPLACE"] = { type ='value', },
       ["GL_INCR"] = { type ='value', },
       ["GL_DECR"] = { type ='value', },
       ["GL_VENDOR"] = { type ='value', },
       ["GL_RENDERER"] = { type ='value', },
       ["GL_VERSION"] = { type ='value', },
       ["GL_EXTENSIONS"] = { type ='value', },
       ["GL_S"] = { type ='value', },
       ["GL_ENABLE_BIT"] = { type ='value', },
       ["GL_T"] = { type ='value', },
       ["GL_R"] = { type ='value', },
       ["GL_Q"] = { type ='value', },
       ["GL_MODULATE"] = { type ='value', },
       ["GL_DECAL"] = { type ='value', },
       ["GL_TEXTURE_ENV_MODE"] = { type ='value', },
       ["GL_TEXTURE_ENV_COLOR"] = { type ='value', },
       ["GL_TEXTURE_ENV"] = { type ='value', },
       ["GL_EYE_LINEAR"] = { type ='value', },
       ["GL_OBJECT_LINEAR"] = { type ='value', },
       ["GL_SPHERE_MAP"] = { type ='value', },
       ["GL_TEXTURE_GEN_MODE"] = { type ='value', },
       ["GL_OBJECT_PLANE"] = { type ='value', },
       ["GL_EYE_PLANE"] = { type ='value', },
       ["GL_NEAREST"] = { type ='value', },
       ["GL_LINEAR"] = { type ='value', },
       ["GL_NEAREST_MIPMAP_NEAREST"] = { type ='value', },
       ["GL_LINEAR_MIPMAP_NEAREST"] = { type ='value', },
       ["GL_NEAREST_MIPMAP_LINEAR"] = { type ='value', },
       ["GL_LINEAR_MIPMAP_LINEAR"] = { type ='value', },
       ["GL_TEXTURE_MAG_FILTER"] = { type ='value', },
       ["GL_TEXTURE_MIN_FILTER"] = { type ='value', },
       ["GL_TEXTURE_WRAP_S"] = { type ='value', },
       ["GL_TEXTURE_WRAP_T"] = { type ='value', },
       ["GL_CLAMP"] = { type ='value', },
       ["GL_REPEAT"] = { type ='value', },
       ["GL_POLYGON_OFFSET_UNITS"] = { type ='value', },
       ["GL_POLYGON_OFFSET_POINT"] = { type ='value', },
       ["GL_POLYGON_OFFSET_LINE"] = { type ='value', },
       ["GL_R3_G3_B2"] = { type ='value', },
       ["GL_V2F"] = { type ='value', },
       ["GL_V3F"] = { type ='value', },
       ["GL_C4UB_V2F"] = { type ='value', },
       ["GL_C4UB_V3F"] = { type ='value', },
       ["GL_C3F_V3F"] = { type ='value', },
       ["GL_N3F_V3F"] = { type ='value', },
       ["GL_C4F_N3F_V3F"] = { type ='value', },
       ["GL_T2F_V3F"] = { type ='value', },
       ["GL_T4F_V4F"] = { type ='value', },
       ["GL_T2F_C4UB_V3F"] = { type ='value', },
       ["GL_T2F_C3F_V3F"] = { type ='value', },
       ["GL_T2F_N3F_V3F"] = { type ='value', },
       ["GL_T2F_C4F_N3F_V3F"] = { type ='value', },
       ["GL_T4F_C4F_N3F_V4F"] = { type ='value', },
       ["GL_CLIP_PLANE0"] = { type ='value', },
       ["GL_CLIP_PLANE1"] = { type ='value', },
       ["GL_CLIP_PLANE2"] = { type ='value', },
       ["GL_CLIP_PLANE3"] = { type ='value', },
       ["GL_CLIP_PLANE4"] = { type ='value', },
       ["GL_CLIP_PLANE5"] = { type ='value', },
       ["GL_LIGHT0"] = { type ='value', },
       ["GL_COLOR_BUFFER_BIT"] = { type ='value', },
       ["GL_LIGHT1"] = { type ='value', },
       ["GL_LIGHT2"] = { type ='value', },
       ["GL_LIGHT3"] = { type ='value', },
       ["GL_LIGHT4"] = { type ='value', },
       ["GL_LIGHT5"] = { type ='value', },
       ["GL_LIGHT6"] = { type ='value', },
       ["GL_LIGHT7"] = { type ='value', },
       ["GL_HINT_BIT"] = { type ='value', },
       ["GL_POLYGON_OFFSET_FILL"] = { type ='value', },
       ["GL_POLYGON_OFFSET_FACTOR"] = { type ='value', },
       ["GL_ALPHA4"] = { type ='value', },
       ["GL_ALPHA8"] = { type ='value', },
       ["GL_ALPHA12"] = { type ='value', },
       ["GL_ALPHA16"] = { type ='value', },
       ["GL_LUMINANCE4"] = { type ='value', },
       ["GL_LUMINANCE8"] = { type ='value', },
       ["GL_LUMINANCE12"] = { type ='value', },
       ["GL_LUMINANCE16"] = { type ='value', },
       ["GL_LUMINANCE4_ALPHA4"] = { type ='value', },
       ["GL_LUMINANCE6_ALPHA2"] = { type ='value', },
       ["GL_LUMINANCE8_ALPHA8"] = { type ='value', },
       ["GL_LUMINANCE12_ALPHA4"] = { type ='value', },
       ["GL_LUMINANCE12_ALPHA12"] = { type ='value', },
       ["GL_LUMINANCE16_ALPHA16"] = { type ='value', },
       ["GL_INTENSITY"] = { type ='value', },
       ["GL_INTENSITY4"] = { type ='value', },
       ["GL_INTENSITY8"] = { type ='value', },
       ["GL_INTENSITY12"] = { type ='value', },
       ["GL_INTENSITY16"] = { type ='value', },
       ["GL_RGB4"] = { type ='value', },
       ["GL_RGB5"] = { type ='value', },
       ["GL_RGB8"] = { type ='value', },
       ["GL_RGB10"] = { type ='value', },
       ["GL_RGB12"] = { type ='value', },
       ["GL_RGB16"] = { type ='value', },
       ["GL_RGBA2"] = { type ='value', },
       ["GL_RGBA4"] = { type ='value', },
       ["GL_RGB5_A1"] = { type ='value', },
       ["GL_RGBA8"] = { type ='value', },
       ["GL_RGB10_A2"] = { type ='value', },
       ["GL_RGBA12"] = { type ='value', },
       ["GL_RGBA16"] = { type ='value', },
       ["GL_TEXTURE_RED_SIZE"] = { type ='value', },
       ["GL_TEXTURE_GREEN_SIZE"] = { type ='value', },
       ["GL_TEXTURE_BLUE_SIZE"] = { type ='value', },
       ["GL_TEXTURE_ALPHA_SIZE"] = { type ='value', },
       ["GL_TEXTURE_LUMINANCE_SIZE"] = { type ='value', },
       ["GL_TEXTURE_INTENSITY_SIZE"] = { type ='value', },
       ["GL_PROXY_TEXTURE_1D"] = { type ='value', },
       ["GL_PROXY_TEXTURE_2D"] = { type ='value', },
       ["GL_TEXTURE_PRIORITY"] = { type ='value', },
       ["GL_TEXTURE_RESIDENT"] = { type ='value', },
       ["GL_TEXTURE_BINDING_1D"] = { type ='value', },
       ["GL_TEXTURE_BINDING_2D"] = { type ='value', },
       ["GL_VERTEX_ARRAY"] = { type ='value', },
       ["GL_NORMAL_ARRAY"] = { type ='value', },
       ["GL_COLOR_ARRAY"] = { type ='value', },
       ["GL_INDEX_ARRAY"] = { type ='value', },
       ["GL_TEXTURE_COORD_ARRAY"] = { type ='value', },
       ["GL_EDGE_FLAG_ARRAY"] = { type ='value', },
       ["GL_VERTEX_ARRAY_SIZE"] = { type ='value', },
       ["GL_VERTEX_ARRAY_TYPE"] = { type ='value', },
       ["GL_VERTEX_ARRAY_STRIDE"] = { type ='value', },
       ["GL_NORMAL_ARRAY_TYPE"] = { type ='value', },
       ["GL_NORMAL_ARRAY_STRIDE"] = { type ='value', },
       ["GL_COLOR_ARRAY_SIZE"] = { type ='value', },
       ["GL_COLOR_ARRAY_TYPE"] = { type ='value', },
       ["GL_COLOR_ARRAY_STRIDE"] = { type ='value', },
       ["GL_INDEX_ARRAY_TYPE"] = { type ='value', },
       ["GL_INDEX_ARRAY_STRIDE"] = { type ='value', },
       ["GL_TEXTURE_COORD_ARRAY_SIZE"] = { type ='value', },
       ["GL_TEXTURE_COORD_ARRAY_TYPE"] = { type ='value', },
       ["GL_TEXTURE_COORD_ARRAY_STRIDE"] = { type ='value', },
       ["GL_EDGE_FLAG_ARRAY_STRIDE"] = { type ='value', },
       ["GL_VERTEX_ARRAY_POINTER"] = { type ='value', },
       ["GL_NORMAL_ARRAY_POINTER"] = { type ='value', },
       ["GL_COLOR_ARRAY_POINTER"] = { type ='value', },
       ["GL_INDEX_ARRAY_POINTER"] = { type ='value', },
       ["GL_TEXTURE_COORD_ARRAY_POINTER"] = { type ='value', },
       ["GL_EDGE_FLAG_ARRAY_POINTER"] = { type ='value', },
       ["GL_COLOR_INDEX1_EXT"] = { type ='value', },
       ["GL_COLOR_INDEX2_EXT"] = { type ='value', },
       ["GL_COLOR_INDEX4_EXT"] = { type ='value', },
       ["GL_COLOR_INDEX8_EXT"] = { type ='value', },
       ["GL_COLOR_INDEX12_EXT"] = { type ='value', },
       ["GL_COLOR_INDEX16_EXT"] = { type ='value', },
       ["GL_EVAL_BIT"] = { type ='value', },
       ["GL_LIST_BIT"] = { type ='value', },
       ["GL_TEXTURE_BIT"] = { type ='value', },
       ["GL_SCISSOR_BIT"] = { type ='value', },
       ["GL_ALL_ATTRIB_BITS"] = { type ='value', },
       ["GL_CLIENT_ALL_ATTRIB_BITS"] = { type ='value', },
       ["GL_SMOOTH_POINT_SIZE_RANGE"] = { type ='value', },
       ["GL_SMOOTH_POINT_SIZE_GRANULARITY"] = { type ='value', },
       ["GL_SMOOTH_LINE_WIDTH_RANGE"] = { type ='value', },
       ["GL_SMOOTH_LINE_WIDTH_GRANULARITY"] = { type ='value', },
       ["GL_UNSIGNED_BYTE_3_3_2"] = { type ='value', },
       ["GL_UNSIGNED_SHORT_4_4_4_4"] = { type ='value', },
       ["GL_UNSIGNED_SHORT_5_5_5_1"] = { type ='value', },
       ["GL_UNSIGNED_INT_8_8_8_8"] = { type ='value', },
       ["GL_UNSIGNED_INT_10_10_10_2"] = { type ='value', },
       ["GL_RESCALE_NORMAL"] = { type ='value', },
       ["GL_TEXTURE_BINDING_3D"] = { type ='value', },
       ["GL_PACK_SKIP_IMAGES"] = { type ='value', },
       ["GL_PACK_IMAGE_HEIGHT"] = { type ='value', },
       ["GL_UNPACK_SKIP_IMAGES"] = { type ='value', },
       ["GL_UNPACK_IMAGE_HEIGHT"] = { type ='value', },
       ["GL_TEXTURE_3D"] = { type ='value', },
       ["GL_PROXY_TEXTURE_3D"] = { type ='value', },
       ["GL_TEXTURE_DEPTH"] = { type ='value', },
       ["GL_TEXTURE_WRAP_R"] = { type ='value', },
       ["GL_MAX_3D_TEXTURE_SIZE"] = { type ='value', },
       ["GL_BGR"] = { type ='value', },
       ["GL_BGRA"] = { type ='value', },
       ["GL_MAX_ELEMENTS_VERTICES"] = { type ='value', },
       ["GL_MAX_ELEMENTS_INDICES"] = { type ='value', },
       ["GL_CLAMP_TO_EDGE"] = { type ='value', },
       ["GL_TEXTURE_MIN_LOD"] = { type ='value', },
       ["GL_TEXTURE_MAX_LOD"] = { type ='value', },
       ["GL_TEXTURE_BASE_LEVEL"] = { type ='value', },
       ["GL_TEXTURE_MAX_LEVEL"] = { type ='value', },
       ["GL_LIGHT_MODEL_COLOR_CONTROL"] = { type ='value', },
       ["GL_SINGLE_COLOR"] = { type ='value', },
       ["GL_SEPARATE_SPECULAR_COLOR"] = { type ='value', },
       ["GL_UNSIGNED_BYTE_2_3_3_REV"] = { type ='value', },
       ["GL_UNSIGNED_SHORT_5_6_5"] = { type ='value', },
       ["GL_UNSIGNED_SHORT_5_6_5_REV"] = { type ='value', },
       ["GL_UNSIGNED_SHORT_4_4_4_4_REV"] = { type ='value', },
       ["GL_UNSIGNED_SHORT_1_5_5_5_REV"] = { type ='value', },
       ["GL_UNSIGNED_INT_8_8_8_8_REV"] = { type ='value', },
       ["GL_UNSIGNED_INT_2_10_10_10_REV"] = { type ='value', },
       ["GL_ALIASED_POINT_SIZE_RANGE"] = { type ='value', },
       ["GL_ALIASED_LINE_WIDTH_RANGE"] = { type ='value', },
       ["GL_MULTISAMPLE"] = { type ='value', },
       ["GL_SAMPLE_ALPHA_TO_COVERAGE"] = { type ='value', },
       ["GL_SAMPLE_ALPHA_TO_ONE"] = { type ='value', },
       ["GL_SAMPLE_COVERAGE"] = { type ='value', },
       ["GL_SAMPLE_BUFFERS"] = { type ='value', },
       ["GL_SAMPLES"] = { type ='value', },
       ["GL_SAMPLE_COVERAGE_VALUE"] = { type ='value', },
       ["GL_SAMPLE_COVERAGE_INVERT"] = { type ='value', },
       ["GL_CLAMP_TO_BORDER"] = { type ='value', },
       ["GL_TEXTURE0"] = { type ='value', },
       ["GL_TEXTURE1"] = { type ='value', },
       ["GL_TEXTURE2"] = { type ='value', },
       ["GL_TEXTURE3"] = { type ='value', },
       ["GL_TEXTURE4"] = { type ='value', },
       ["GL_TEXTURE5"] = { type ='value', },
       ["GL_TEXTURE6"] = { type ='value', },
       ["GL_TEXTURE7"] = { type ='value', },
       ["GL_TEXTURE8"] = { type ='value', },
       ["GL_TEXTURE9"] = { type ='value', },
       ["GL_TEXTURE10"] = { type ='value', },
       ["GL_TEXTURE11"] = { type ='value', },
       ["GL_TEXTURE12"] = { type ='value', },
       ["GL_TEXTURE13"] = { type ='value', },
       ["GL_TEXTURE14"] = { type ='value', },
       ["GL_TEXTURE15"] = { type ='value', },
       ["GL_TEXTURE16"] = { type ='value', },
       ["GL_TEXTURE17"] = { type ='value', },
       ["GL_TEXTURE18"] = { type ='value', },
       ["GL_TEXTURE19"] = { type ='value', },
       ["GL_TEXTURE20"] = { type ='value', },
       ["GL_TEXTURE21"] = { type ='value', },
       ["GL_TEXTURE22"] = { type ='value', },
       ["GL_TEXTURE23"] = { type ='value', },
       ["GL_TEXTURE24"] = { type ='value', },
       ["GL_TEXTURE25"] = { type ='value', },
       ["GL_TEXTURE26"] = { type ='value', },
       ["GL_TEXTURE27"] = { type ='value', },
       ["GL_TEXTURE28"] = { type ='value', },
       ["GL_TEXTURE29"] = { type ='value', },
       ["GL_TEXTURE30"] = { type ='value', },
       ["GL_TEXTURE31"] = { type ='value', },
       ["GL_ACTIVE_TEXTURE"] = { type ='value', },
       ["GL_CLIENT_ACTIVE_TEXTURE"] = { type ='value', },
       ["GL_MAX_TEXTURE_UNITS"] = { type ='value', },
       ["GL_TRANSPOSE_MODELVIEW_MATRIX"] = { type ='value', },
       ["GL_TRANSPOSE_PROJECTION_MATRIX"] = { type ='value', },
       ["GL_TRANSPOSE_TEXTURE_MATRIX"] = { type ='value', },
       ["GL_TRANSPOSE_COLOR_MATRIX"] = { type ='value', },
       ["GL_SUBTRACT"] = { type ='value', },
       ["GL_COMPRESSED_ALPHA"] = { type ='value', },
       ["GL_COMPRESSED_LUMINANCE"] = { type ='value', },
       ["GL_COMPRESSED_LUMINANCE_ALPHA"] = { type ='value', },
       ["GL_COMPRESSED_INTENSITY"] = { type ='value', },
       ["GL_COMPRESSED_RGB"] = { type ='value', },
       ["GL_COMPRESSED_RGBA"] = { type ='value', },
       ["GL_TEXTURE_COMPRESSION_HINT"] = { type ='value', },
       ["GL_NORMAL_MAP"] = { type ='value', },
       ["GL_REFLECTION_MAP"] = { type ='value', },
       ["GL_TEXTURE_CUBE_MAP"] = { type ='value', },
       ["GL_TEXTURE_BINDING_CUBE_MAP"] = { type ='value', },
       ["GL_TEXTURE_CUBE_MAP_POSITIVE_X"] = { type ='value', },
       ["GL_TEXTURE_CUBE_MAP_NEGATIVE_X"] = { type ='value', },
       ["GL_TEXTURE_CUBE_MAP_POSITIVE_Y"] = { type ='value', },
       ["GL_TEXTURE_CUBE_MAP_NEGATIVE_Y"] = { type ='value', },
       ["GL_TEXTURE_CUBE_MAP_POSITIVE_Z"] = { type ='value', },
       ["GL_TEXTURE_CUBE_MAP_NEGATIVE_Z"] = { type ='value', },
       ["GL_PROXY_TEXTURE_CUBE_MAP"] = { type ='value', },
       ["GL_MAX_CUBE_MAP_TEXTURE_SIZE"] = { type ='value', },
       ["GL_COMBINE"] = { type ='value', },
       ["GL_COMBINE_RGB"] = { type ='value', },
       ["GL_COMBINE_ALPHA"] = { type ='value', },
       ["GL_RGB_SCALE"] = { type ='value', },
       ["GL_ADD_SIGNED"] = { type ='value', },
       ["GL_INTERPOLATE"] = { type ='value', },
       ["GL_CONSTANT"] = { type ='value', },
       ["GL_PRIMARY_COLOR"] = { type ='value', },
       ["GL_PREVIOUS"] = { type ='value', },
       ["GL_SOURCE0_RGB"] = { type ='value', },
       ["GL_SOURCE1_RGB"] = { type ='value', },
       ["GL_SOURCE2_RGB"] = { type ='value', },
       ["GL_SOURCE0_ALPHA"] = { type ='value', },
       ["GL_SOURCE1_ALPHA"] = { type ='value', },
       ["GL_SOURCE2_ALPHA"] = { type ='value', },
       ["GL_OPERAND0_RGB"] = { type ='value', },
       ["GL_OPERAND1_RGB"] = { type ='value', },
       ["GL_OPERAND2_RGB"] = { type ='value', },
       ["GL_OPERAND0_ALPHA"] = { type ='value', },
       ["GL_OPERAND1_ALPHA"] = { type ='value', },
       ["GL_OPERAND2_ALPHA"] = { type ='value', },
       ["GL_TEXTURE_COMPRESSED_IMAGE_SIZE"] = { type ='value', },
       ["GL_TEXTURE_COMPRESSED"] = { type ='value', },
       ["GL_NUM_COMPRESSED_TEXTURE_FORMATS"] = { type ='value', },
       ["GL_COMPRESSED_TEXTURE_FORMATS"] = { type ='value', },
       ["GL_DOT3_RGB"] = { type ='value', },
       ["GL_DOT3_RGBA"] = { type ='value', },
       ["GL_MULTISAMPLE_BIT"] = { type ='value', },
       ["GL_BLEND_DST_RGB"] = { type ='value', },
       ["GL_BLEND_SRC_RGB"] = { type ='value', },
       ["GL_BLEND_DST_ALPHA"] = { type ='value', },
       ["GL_BLEND_SRC_ALPHA"] = { type ='value', },
       ["GL_POINT_SIZE_MIN"] = { type ='value', },
       ["GL_POINT_SIZE_MAX"] = { type ='value', },
       ["GL_POINT_FADE_THRESHOLD_SIZE"] = { type ='value', },
       ["GL_POINT_DISTANCE_ATTENUATION"] = { type ='value', },
       ["GL_GENERATE_MIPMAP"] = { type ='value', },
       ["GL_GENERATE_MIPMAP_HINT"] = { type ='value', },
       ["GL_DEPTH_COMPONENT16"] = { type ='value', },
       ["GL_DEPTH_COMPONENT24"] = { type ='value', },
       ["GL_DEPTH_COMPONENT32"] = { type ='value', },
       ["GL_MIRRORED_REPEAT"] = { type ='value', },
       ["GL_FOG_COORDINATE_SOURCE"] = { type ='value', },
       ["GL_FOG_COORDINATE"] = { type ='value', },
       ["GL_FRAGMENT_DEPTH"] = { type ='value', },
       ["GL_CURRENT_FOG_COORDINATE"] = { type ='value', },
       ["GL_FOG_COORDINATE_ARRAY_TYPE"] = { type ='value', },
       ["GL_FOG_COORDINATE_ARRAY_STRIDE"] = { type ='value', },
       ["GL_FOG_COORDINATE_ARRAY_POINTER"] = { type ='value', },
       ["GL_FOG_COORDINATE_ARRAY"] = { type ='value', },
       ["GL_COLOR_SUM"] = { type ='value', },
       ["GL_CURRENT_SECONDARY_COLOR"] = { type ='value', },
       ["GL_SECONDARY_COLOR_ARRAY_SIZE"] = { type ='value', },
       ["GL_SECONDARY_COLOR_ARRAY_TYPE"] = { type ='value', },
       ["GL_SECONDARY_COLOR_ARRAY_STRIDE"] = { type ='value', },
       ["GL_SECONDARY_COLOR_ARRAY_POINTER"] = { type ='value', },
       ["GL_SECONDARY_COLOR_ARRAY"] = { type ='value', },
       ["GL_MAX_TEXTURE_LOD_BIAS"] = { type ='value', },
       ["GL_TEXTURE_FILTER_CONTROL"] = { type ='value', },
       ["GL_TEXTURE_LOD_BIAS"] = { type ='value', },
       ["GL_INCR_WRAP"] = { type ='value', },
       ["GL_DECR_WRAP"] = { type ='value', },
       ["GL_TEXTURE_DEPTH_SIZE"] = { type ='value', },
       ["GL_DEPTH_TEXTURE_MODE"] = { type ='value', },
       ["GL_TEXTURE_COMPARE_MODE"] = { type ='value', },
       ["GL_TEXTURE_COMPARE_FUNC"] = { type ='value', },
       ["GL_COMPARE_R_TO_TEXTURE"] = { type ='value', },
       ["GL_FOG_COORD_SRC"] = { type ='value', },
       ["GL_FOG_COORD"] = { type ='value', },
       ["GL_FOG_COORD_ARRAY"] = { type ='value', },
       ["GL_SRC0_RGB"] = { type ='value', },
       ["GL_FOG_COORD_ARRAY_POINTER"] = { type ='value', },
       ["GL_FOG_COORD_ARRAY_TYPE"] = { type ='value', },
       ["GL_SRC1_ALPHA"] = { type ='value', },
       ["GL_CURRENT_FOG_COORD"] = { type ='value', },
       ["GL_FOG_COORD_ARRAY_STRIDE"] = { type ='value', },
       ["GL_SRC0_ALPHA"] = { type ='value', },
       ["GL_SRC1_RGB"] = { type ='value', },
       ["GL_FOG_COORD_ARRAY_BUFFER_BINDING"] = { type ='value', },
       ["GL_SRC2_ALPHA"] = { type ='value', },
       ["GL_SRC2_RGB"] = { type ='value', },
       ["GL_BUFFER_SIZE"] = { type ='value', },
       ["GL_BUFFER_USAGE"] = { type ='value', },
       ["GL_QUERY_COUNTER_BITS"] = { type ='value', },
       ["GL_CURRENT_QUERY"] = { type ='value', },
       ["GL_QUERY_RESULT"] = { type ='value', },
       ["GL_QUERY_RESULT_AVAILABLE"] = { type ='value', },
       ["GL_ARRAY_BUFFER"] = { type ='value', },
       ["GL_ELEMENT_ARRAY_BUFFER"] = { type ='value', },
       ["GL_ARRAY_BUFFER_BINDING"] = { type ='value', },
       ["GL_ELEMENT_ARRAY_BUFFER_BINDING"] = { type ='value', },
       ["GL_VERTEX_ARRAY_BUFFER_BINDING"] = { type ='value', },
       ["GL_NORMAL_ARRAY_BUFFER_BINDING"] = { type ='value', },
       ["GL_COLOR_ARRAY_BUFFER_BINDING"] = { type ='value', },
       ["GL_INDEX_ARRAY_BUFFER_BINDING"] = { type ='value', },
       ["GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING"] = { type ='value', },
       ["GL_EDGE_FLAG_ARRAY_BUFFER_BINDING"] = { type ='value', },
       ["GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING"] = { type ='value', },
       ["GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING"] = { type ='value', },
       ["GL_WEIGHT_ARRAY_BUFFER_BINDING"] = { type ='value', },
       ["GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING"] = { type ='value', },
       ["GL_READ_ONLY"] = { type ='value', },
       ["GL_WRITE_ONLY"] = { type ='value', },
       ["GL_READ_WRITE"] = { type ='value', },
       ["GL_BUFFER_ACCESS"] = { type ='value', },
       ["GL_BUFFER_MAPPED"] = { type ='value', },
       ["GL_BUFFER_MAP_POINTER"] = { type ='value', },
       ["GL_STREAM_DRAW"] = { type ='value', },
       ["GL_STREAM_READ"] = { type ='value', },
       ["GL_STREAM_COPY"] = { type ='value', },
       ["GL_STATIC_DRAW"] = { type ='value', },
       ["GL_STATIC_READ"] = { type ='value', },
       ["GL_STATIC_COPY"] = { type ='value', },
       ["GL_DYNAMIC_DRAW"] = { type ='value', },
       ["GL_DYNAMIC_READ"] = { type ='value', },
       ["GL_DYNAMIC_COPY"] = { type ='value', },
       ["GL_SAMPLES_PASSED"] = { type ='value', },
       ["GL_BLEND_EQUATION_RGB"] = { type ='value', },
       ["GL_VERTEX_ATTRIB_ARRAY_ENABLED"] = { type ='value', },
       ["GL_VERTEX_ATTRIB_ARRAY_SIZE"] = { type ='value', },
       ["GL_VERTEX_ATTRIB_ARRAY_STRIDE"] = { type ='value', },
       ["GL_VERTEX_ATTRIB_ARRAY_TYPE"] = { type ='value', },
       ["GL_CURRENT_VERTEX_ATTRIB"] = { type ='value', },
       ["GL_VERTEX_PROGRAM_POINT_SIZE"] = { type ='value', },
       ["GL_VERTEX_PROGRAM_TWO_SIDE"] = { type ='value', },
       ["GL_VERTEX_ATTRIB_ARRAY_POINTER"] = { type ='value', },
       ["GL_STENCIL_BACK_FUNC"] = { type ='value', },
       ["GL_STENCIL_BACK_FAIL"] = { type ='value', },
       ["GL_STENCIL_BACK_PASS_DEPTH_FAIL"] = { type ='value', },
       ["GL_STENCIL_BACK_PASS_DEPTH_PASS"] = { type ='value', },
       ["GL_MAX_DRAW_BUFFERS"] = { type ='value', },
       ["GL_DRAW_BUFFER0"] = { type ='value', },
       ["GL_DRAW_BUFFER1"] = { type ='value', },
       ["GL_DRAW_BUFFER2"] = { type ='value', },
       ["GL_DRAW_BUFFER3"] = { type ='value', },
       ["GL_DRAW_BUFFER4"] = { type ='value', },
       ["GL_DRAW_BUFFER5"] = { type ='value', },
       ["GL_DRAW_BUFFER6"] = { type ='value', },
       ["GL_DRAW_BUFFER7"] = { type ='value', },
       ["GL_DRAW_BUFFER8"] = { type ='value', },
       ["GL_DRAW_BUFFER9"] = { type ='value', },
       ["GL_DRAW_BUFFER10"] = { type ='value', },
       ["GL_DRAW_BUFFER11"] = { type ='value', },
       ["GL_DRAW_BUFFER12"] = { type ='value', },
       ["GL_DRAW_BUFFER13"] = { type ='value', },
       ["GL_DRAW_BUFFER14"] = { type ='value', },
       ["GL_DRAW_BUFFER15"] = { type ='value', },
       ["GL_BLEND_EQUATION_ALPHA"] = { type ='value', },
       ["GL_POINT_SPRITE"] = { type ='value', },
       ["GL_COORD_REPLACE"] = { type ='value', },
       ["GL_MAX_VERTEX_ATTRIBS"] = { type ='value', },
       ["GL_VERTEX_ATTRIB_ARRAY_NORMALIZED"] = { type ='value', },
       ["GL_MAX_TEXTURE_COORDS"] = { type ='value', },
       ["GL_MAX_TEXTURE_IMAGE_UNITS"] = { type ='value', },
       ["GL_FRAGMENT_SHADER"] = { type ='value', },
       ["GL_VERTEX_SHADER"] = { type ='value', },
       ["GL_MAX_FRAGMENT_UNIFORM_COMPONENTS"] = { type ='value', },
       ["GL_MAX_VERTEX_UNIFORM_COMPONENTS"] = { type ='value', },
       ["GL_MAX_VARYING_FLOATS"] = { type ='value', },
       ["GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS"] = { type ='value', },
       ["GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS"] = { type ='value', },
       ["GL_SHADER_TYPE"] = { type ='value', },
       ["GL_FLOAT_VEC2"] = { type ='value', },
       ["GL_FLOAT_VEC3"] = { type ='value', },
       ["GL_FLOAT_VEC4"] = { type ='value', },
       ["GL_INT_VEC2"] = { type ='value', },
       ["GL_INT_VEC3"] = { type ='value', },
       ["GL_INT_VEC4"] = { type ='value', },
       ["GL_BOOL"] = { type ='value', },
       ["GL_BOOL_VEC2"] = { type ='value', },
       ["GL_BOOL_VEC3"] = { type ='value', },
       ["GL_BOOL_VEC4"] = { type ='value', },
       ["GL_FLOAT_MAT2"] = { type ='value', },
       ["GL_FLOAT_MAT3"] = { type ='value', },
       ["GL_FLOAT_MAT4"] = { type ='value', },
       ["GL_SAMPLER_1D"] = { type ='value', },
       ["GL_SAMPLER_2D"] = { type ='value', },
       ["GL_SAMPLER_3D"] = { type ='value', },
       ["GL_SAMPLER_CUBE"] = { type ='value', },
       ["GL_SAMPLER_1D_SHADOW"] = { type ='value', },
       ["GL_SAMPLER_2D_SHADOW"] = { type ='value', },
       ["GL_DELETE_STATUS"] = { type ='value', },
       ["GL_COMPILE_STATUS"] = { type ='value', },
       ["GL_LINK_STATUS"] = { type ='value', },
       ["GL_VALIDATE_STATUS"] = { type ='value', },
       ["GL_INFO_LOG_LENGTH"] = { type ='value', },
       ["GL_ATTACHED_SHADERS"] = { type ='value', },
       ["GL_ACTIVE_UNIFORMS"] = { type ='value', },
       ["GL_ACTIVE_UNIFORM_MAX_LENGTH"] = { type ='value', },
       ["GL_SHADER_SOURCE_LENGTH"] = { type ='value', },
       ["GL_ACTIVE_ATTRIBUTES"] = { type ='value', },
       ["GL_ACTIVE_ATTRIBUTE_MAX_LENGTH"] = { type ='value', },
       ["GL_FRAGMENT_SHADER_DERIVATIVE_HINT"] = { type ='value', },
       ["GL_SHADING_LANGUAGE_VERSION"] = { type ='value', },
       ["GL_CURRENT_PROGRAM"] = { type ='value', },
       ["GL_POINT_SPRITE_COORD_ORIGIN"] = { type ='value', },
       ["GL_LOWER_LEFT"] = { type ='value', },
       ["GL_UPPER_LEFT"] = { type ='value', },
       ["GL_STENCIL_BACK_REF"] = { type ='value', },
       ["GL_STENCIL_BACK_VALUE_MASK"] = { type ='value', },
       ["GL_STENCIL_BACK_WRITEMASK"] = { type ='value', },
       ["GL_CURRENT_RASTER_SECONDARY_COLOR"] = { type ='value', },
       ["GL_PIXEL_PACK_BUFFER"] = { type ='value', },
       ["GL_PIXEL_UNPACK_BUFFER"] = { type ='value', },
       ["GL_PIXEL_PACK_BUFFER_BINDING"] = { type ='value', },
       ["GL_PIXEL_UNPACK_BUFFER_BINDING"] = { type ='value', },
       ["GL_FLOAT_MAT2x3"] = { type ='value', },
       ["GL_FLOAT_MAT2x4"] = { type ='value', },
       ["GL_FLOAT_MAT3x2"] = { type ='value', },
       ["GL_FLOAT_MAT3x4"] = { type ='value', },
       ["GL_FLOAT_MAT4x2"] = { type ='value', },
       ["GL_FLOAT_MAT4x3"] = { type ='value', },
       ["GL_SRGB"] = { type ='value', },
       ["GL_SRGB8"] = { type ='value', },
       ["GL_SRGB_ALPHA"] = { type ='value', },
       ["GL_SRGB8_ALPHA8"] = { type ='value', },
       ["GL_SLUMINANCE_ALPHA"] = { type ='value', },
       ["GL_SLUMINANCE8_ALPHA8"] = { type ='value', },
       ["GL_SLUMINANCE"] = { type ='value', },
       ["GL_SLUMINANCE8"] = { type ='value', },
       ["GL_COMPRESSED_SRGB"] = { type ='value', },
       ["GL_COMPRESSED_SRGB_ALPHA"] = { type ='value', },
       ["GL_COMPRESSED_SLUMINANCE"] = { type ='value', },
       ["GL_COMPRESSED_SLUMINANCE_ALPHA"] = { type ='value', },
       ["GL_MAX_CLIP_DISTANCES"] = { type ='value', },
       ["GL_CLIP_DISTANCE5"] = { type ='value', },
       ["GL_CLIP_DISTANCE1"] = { type ='value', },
       ["GL_CLIP_DISTANCE3"] = { type ='value', },
       ["GL_COMPARE_REF_TO_TEXTURE"] = { type ='value', },
       ["GL_CLIP_DISTANCE0"] = { type ='value', },
       ["GL_CLIP_DISTANCE4"] = { type ='value', },
       ["GL_CLIP_DISTANCE2"] = { type ='value', },
       ["GL_MAX_VARYING_COMPONENTS"] = { type ='value', },
       ["GL_CONTEXT_FLAG_FORWARD_COMPATIBLE_BIT"] = { type ='value', },
       ["GL_MAJOR_VERSION"] = { type ='value', },
       ["GL_MINOR_VERSION"] = { type ='value', },
       ["GL_NUM_EXTENSIONS"] = { type ='value', },
       ["GL_CONTEXT_FLAGS"] = { type ='value', },
       ["GL_DEPTH_BUFFER"] = { type ='value', },
       ["GL_STENCIL_BUFFER"] = { type ='value', },
       ["GL_COMPRESSED_RED"] = { type ='value', },
       ["GL_COMPRESSED_RG"] = { type ='value', },
       ["GL_RGBA32F"] = { type ='value', },
       ["GL_RGB32F"] = { type ='value', },
       ["GL_RGBA16F"] = { type ='value', },
       ["GL_RGB16F"] = { type ='value', },
       ["GL_VERTEX_ATTRIB_ARRAY_INTEGER"] = { type ='value', },
       ["GL_MAX_ARRAY_TEXTURE_LAYERS"] = { type ='value', },
       ["GL_MIN_PROGRAM_TEXEL_OFFSET"] = { type ='value', },
       ["GL_MAX_PROGRAM_TEXEL_OFFSET"] = { type ='value', },
       ["GL_CLAMP_VERTEX_COLOR"] = { type ='value', },
       ["GL_CLAMP_FRAGMENT_COLOR"] = { type ='value', },
       ["GL_CLAMP_READ_COLOR"] = { type ='value', },
       ["GL_FIXED_ONLY"] = { type ='value', },
       ["GL_TEXTURE_RED_TYPE"] = { type ='value', },
       ["GL_TEXTURE_GREEN_TYPE"] = { type ='value', },
       ["GL_TEXTURE_BLUE_TYPE"] = { type ='value', },
       ["GL_TEXTURE_ALPHA_TYPE"] = { type ='value', },
       ["GL_TEXTURE_LUMINANCE_TYPE"] = { type ='value', },
       ["GL_TEXTURE_INTENSITY_TYPE"] = { type ='value', },
       ["GL_TEXTURE_DEPTH_TYPE"] = { type ='value', },
       ["GL_TEXTURE_1D_ARRAY"] = { type ='value', },
       ["GL_PROXY_TEXTURE_1D_ARRAY"] = { type ='value', },
       ["GL_TEXTURE_2D_ARRAY"] = { type ='value', },
       ["GL_PROXY_TEXTURE_2D_ARRAY"] = { type ='value', },
       ["GL_TEXTURE_BINDING_1D_ARRAY"] = { type ='value', },
       ["GL_TEXTURE_BINDING_2D_ARRAY"] = { type ='value', },
       ["GL_R11F_G11F_B10F"] = { type ='value', },
       ["GL_UNSIGNED_INT_10F_11F_11F_REV"] = { type ='value', },
       ["GL_RGB9_E5"] = { type ='value', },
       ["GL_UNSIGNED_INT_5_9_9_9_REV"] = { type ='value', },
       ["GL_TEXTURE_SHARED_SIZE"] = { type ='value', },
       ["GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH"] = { type ='value', },
       ["GL_TRANSFORM_FEEDBACK_BUFFER_MODE"] = { type ='value', },
       ["GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS"] = { type ='value', },
       ["GL_TRANSFORM_FEEDBACK_VARYINGS"] = { type ='value', },
       ["GL_TRANSFORM_FEEDBACK_BUFFER_START"] = { type ='value', },
       ["GL_TRANSFORM_FEEDBACK_BUFFER_SIZE"] = { type ='value', },
       ["GL_PRIMITIVES_GENERATED"] = { type ='value', },
       ["GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN"] = { type ='value', },
       ["GL_RASTERIZER_DISCARD"] = { type ='value', },
       ["GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS"] = { type ='value', },
       ["GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS"] = { type ='value', },
       ["GL_INTERLEAVED_ATTRIBS"] = { type ='value', },
       ["GL_SEPARATE_ATTRIBS"] = { type ='value', },
       ["GL_TRANSFORM_FEEDBACK_BUFFER"] = { type ='value', },
       ["GL_TRANSFORM_FEEDBACK_BUFFER_BINDING"] = { type ='value', },
       ["GL_RGBA32UI"] = { type ='value', },
       ["GL_RGB32UI"] = { type ='value', },
       ["GL_RGBA16UI"] = { type ='value', },
       ["GL_RGB16UI"] = { type ='value', },
       ["GL_RGBA8UI"] = { type ='value', },
       ["GL_RGB8UI"] = { type ='value', },
       ["GL_RGBA32I"] = { type ='value', },
       ["GL_RGB32I"] = { type ='value', },
       ["GL_RGBA16I"] = { type ='value', },
       ["GL_RGB16I"] = { type ='value', },
       ["GL_RGBA8I"] = { type ='value', },
       ["GL_RGB8I"] = { type ='value', },
       ["GL_RED_INTEGER"] = { type ='value', },
       ["GL_GREEN_INTEGER"] = { type ='value', },
       ["GL_BLUE_INTEGER"] = { type ='value', },
       ["GL_ALPHA_INTEGER"] = { type ='value', },
       ["GL_RGB_INTEGER"] = { type ='value', },
       ["GL_RGBA_INTEGER"] = { type ='value', },
       ["GL_BGR_INTEGER"] = { type ='value', },
       ["GL_BGRA_INTEGER"] = { type ='value', },
       ["GL_SAMPLER_1D_ARRAY"] = { type ='value', },
       ["GL_SAMPLER_2D_ARRAY"] = { type ='value', },
       ["GL_SAMPLER_1D_ARRAY_SHADOW"] = { type ='value', },
       ["GL_SAMPLER_2D_ARRAY_SHADOW"] = { type ='value', },
       ["GL_SAMPLER_CUBE_SHADOW"] = { type ='value', },
       ["GL_UNSIGNED_INT_VEC2"] = { type ='value', },
       ["GL_UNSIGNED_INT_VEC3"] = { type ='value', },
       ["GL_UNSIGNED_INT_VEC4"] = { type ='value', },
       ["GL_INT_SAMPLER_1D"] = { type ='value', },
       ["GL_INT_SAMPLER_2D"] = { type ='value', },
       ["GL_INT_SAMPLER_3D"] = { type ='value', },
       ["GL_INT_SAMPLER_CUBE"] = { type ='value', },
       ["GL_INT_SAMPLER_1D_ARRAY"] = { type ='value', },
       ["GL_INT_SAMPLER_2D_ARRAY"] = { type ='value', },
       ["GL_UNSIGNED_INT_SAMPLER_1D"] = { type ='value', },
       ["GL_UNSIGNED_INT_SAMPLER_2D"] = { type ='value', },
       ["GL_UNSIGNED_INT_SAMPLER_3D"] = { type ='value', },
       ["GL_UNSIGNED_INT_SAMPLER_CUBE"] = { type ='value', },
       ["GL_UNSIGNED_INT_SAMPLER_1D_ARRAY"] = { type ='value', },
       ["GL_UNSIGNED_INT_SAMPLER_2D_ARRAY"] = { type ='value', },
       ["GL_QUERY_WAIT"] = { type ='value', },
       ["GL_QUERY_NO_WAIT"] = { type ='value', },
       ["GL_QUERY_BY_REGION_WAIT"] = { type ='value', },
       ["GL_QUERY_BY_REGION_NO_WAIT"] = { type ='value', },
       ["GL_TEXTURE_RECTANGLE"] = { type ='value', },
       ["GL_TEXTURE_BINDING_RECTANGLE"] = { type ='value', },
       ["GL_PROXY_TEXTURE_RECTANGLE"] = { type ='value', },
       ["GL_MAX_RECTANGLE_TEXTURE_SIZE"] = { type ='value', },
       ["GL_SAMPLER_2D_RECT"] = { type ='value', },
       ["GL_SAMPLER_2D_RECT_SHADOW"] = { type ='value', },
       ["GL_TEXTURE_BUFFER"] = { type ='value', },
       ["GL_MAX_TEXTURE_BUFFER_SIZE"] = { type ='value', },
       ["GL_TEXTURE_BINDING_BUFFER"] = { type ='value', },
       ["GL_TEXTURE_BUFFER_DATA_STORE_BINDING"] = { type ='value', },
       ["GL_TEXTURE_BUFFER_FORMAT"] = { type ='value', },
       ["GL_SAMPLER_BUFFER"] = { type ='value', },
       ["GL_INT_SAMPLER_2D_RECT"] = { type ='value', },
       ["GL_INT_SAMPLER_BUFFER"] = { type ='value', },
       ["GL_UNSIGNED_INT_SAMPLER_2D_RECT"] = { type ='value', },
       ["GL_UNSIGNED_INT_SAMPLER_BUFFER"] = { type ='value', },
       ["GL_RED_SNORM"] = { type ='value', },
       ["GL_RG_SNORM"] = { type ='value', },
       ["GL_RGB_SNORM"] = { type ='value', },
       ["GL_RGBA_SNORM"] = { type ='value', },
       ["GL_R8_SNORM"] = { type ='value', },
       ["GL_RG8_SNORM"] = { type ='value', },
       ["GL_RGB8_SNORM"] = { type ='value', },
       ["GL_RGBA8_SNORM"] = { type ='value', },
       ["GL_R16_SNORM"] = { type ='value', },
       ["GL_RG16_SNORM"] = { type ='value', },
       ["GL_RGB16_SNORM"] = { type ='value', },
       ["GL_RGBA16_SNORM"] = { type ='value', },
       ["GL_SIGNED_NORMALIZED"] = { type ='value', },
       ["GL_PRIMITIVE_RESTART"] = { type ='value', },
       ["GL_PRIMITIVE_RESTART_INDEX"] = { type ='value', },
       ["GL_BUFFER_ACCESS_FLAGS"] = { type ='value', },
       ["GL_BUFFER_MAP_LENGTH"] = { type ='value', },
       ["GL_BUFFER_MAP_OFFSET"] = { type ='value', },
       ["GL_CONTEXT_CORE_PROFILE_BIT"] = { type ='value', },
       ["GL_CONTEXT_COMPATIBILITY_PROFILE_BIT"] = { type ='value', },
       ["GL_LINES_ADJACENCY"] = { type ='value', },
       ["GL_LINE_STRIP_ADJACENCY"] = { type ='value', },
       ["GL_TRIANGLES_ADJACENCY"] = { type ='value', },
       ["GL_TRIANGLE_STRIP_ADJACENCY"] = { type ='value', },
       ["GL_PROGRAM_POINT_SIZE"] = { type ='value', },
       ["GL_GEOMETRY_VERTICES_OUT"] = { type ='value', },
       ["GL_GEOMETRY_INPUT_TYPE"] = { type ='value', },
       ["GL_GEOMETRY_OUTPUT_TYPE"] = { type ='value', },
       ["GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS"] = { type ='value', },
       ["GL_FRAMEBUFFER_ATTACHMENT_LAYERED"] = { type ='value', },
       ["GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS"] = { type ='value', },
       ["GL_GEOMETRY_SHADER"] = { type ='value', },
       ["GL_MAX_GEOMETRY_UNIFORM_COMPONENTS"] = { type ='value', },
       ["GL_MAX_GEOMETRY_OUTPUT_VERTICES"] = { type ='value', },
       ["GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS"] = { type ='value', },
       ["GL_MAX_VERTEX_OUTPUT_COMPONENTS"] = { type ='value', },
       ["GL_MAX_GEOMETRY_INPUT_COMPONENTS"] = { type ='value', },
       ["GL_MAX_GEOMETRY_OUTPUT_COMPONENTS"] = { type ='value', },
       ["GL_MAX_FRAGMENT_INPUT_COMPONENTS"] = { type ='value', },
       ["GL_CONTEXT_PROFILE_MASK"] = { type ='value', },
       ["GL_VERTEX_ATTRIB_ARRAY_DIVISOR"] = { type ='value', },
       ["GL_TEXTURE_SWIZZLE_R"] = { type ='value', },
       ["GL_TEXTURE_SWIZZLE_G"] = { type ='value', },
       ["GL_TEXTURE_SWIZZLE_B"] = { type ='value', },
       ["GL_TEXTURE_SWIZZLE_A"] = { type ='value', },
       ["GL_TEXTURE_SWIZZLE_RGBA"] = { type ='value', },
       ["GL_RGB10_A2UI"] = { type ='value', },
       ["GL_GEOMETRY_SHADER_INVOCATIONS"] = { type ='value', },
       ["GL_SAMPLE_SHADING"] = { type ='value', },
       ["GL_MIN_SAMPLE_SHADING_VALUE"] = { type ='value', },
       ["GL_MAX_GEOMETRY_SHADER_INVOCATIONS"] = { type ='value', },
       ["GL_MIN_FRAGMENT_INTERPOLATION_OFFSET"] = { type ='value', },
       ["GL_MAX_FRAGMENT_INTERPOLATION_OFFSET"] = { type ='value', },
       ["GL_FRAGMENT_INTERPOLATION_OFFSET_BITS"] = { type ='value', },
       ["GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET"] = { type ='value', },
       ["GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET"] = { type ='value', },
       ["GL_MAX_PROGRAM_TEXTURE_GATHER_COMPONENTS"] = { type ='value', },
       ["GL_TEXTURE_CUBE_MAP_ARRAY"] = { type ='value', },
       ["GL_TEXTURE_BINDING_CUBE_MAP_ARRAY"] = { type ='value', },
       ["GL_PROXY_TEXTURE_CUBE_MAP_ARRAY"] = { type ='value', },
       ["GL_SAMPLER_CUBE_MAP_ARRAY"] = { type ='value', },
       ["GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW"] = { type ='value', },
       ["GL_INT_SAMPLER_CUBE_MAP_ARRAY"] = { type ='value', },
       ["GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY"] = { type ='value', },
       ["GL_COMPRESSED_RGBA_BPTC_UNORM"] = { type ='value', },
       ["GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM"] = { type ='value', },
       ["GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT"] = { type ='value', },
       ["GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT"] = { type ='value', },
       ["GL_NUM_SHADING_LANGUAGE_VERSIONS"] = { type ='value', },
       ["GL_VERTEX_ATTRIB_ARRAY_LONG"] = { type ='value', },
       ["GL_MAX_VERTEX_ATTRIB_STRIDE"] = { type ='value', },
       ["GL_FACTOR_MIN_AMD"] = { type ='value', },
       ["GL_FACTOR_MAX_AMD"] = { type ='value', },
       ["GL_DEBUG_CATEGORY_API_ERROR_AMD"] = { type ='value', },
       ["GL_DEBUG_CATEGORY_WINDOW_SYSTEM_AMD"] = { type ='value', },
       ["GL_DEBUG_CATEGORY_DEPRECATION_AMD"] = { type ='value', },
       ["GL_DEBUG_CATEGORY_UNDEFINED_BEHAVIOR_AMD"] = { type ='value', },
       ["GL_DEBUG_CATEGORY_PERFORMANCE_AMD"] = { type ='value', },
       ["GL_DEBUG_CATEGORY_SHADER_COMPILER_AMD"] = { type ='value', },
       ["GL_DEBUG_CATEGORY_APPLICATION_AMD"] = { type ='value', },
       ["GL_DEBUG_CATEGORY_OTHER_AMD"] = { type ='value', },
       ["GL_DEPTH_CLAMP_NEAR_AMD"] = { type ='value', },
       ["GL_DEPTH_CLAMP_FAR_AMD"] = { type ='value', },
       ["GL_RG8UI"] = { type ='value', },
       ["GL_RG16UI"] = { type ='value', },
       ["GL_VERTEX_ELEMENT_SWIZZLE_AMD"] = { type ='value', },
       ["GL_VERTEX_ID_SWIZZLE_AMD"] = { type ='value', },
       ["GL_DATA_BUFFER_AMD"] = { type ='value', },
       ["GL_PERFORMANCE_MONITOR_AMD"] = { type ='value', },
       ["GL_QUERY_OBJECT_AMD"] = { type ='value', },
       ["GL_VERTEX_ARRAY_OBJECT_AMD"] = { type ='value', },
       ["GL_SAMPLER_OBJECT_AMD"] = { type ='value', },
       ["GL_COUNTER_TYPE_AMD"] = { type ='value', },
       ["GL_COUNTER_RANGE_AMD"] = { type ='value', },
       ["GL_UNSIGNED_INT64_AMD"] = { type ='value', },
       ["GL_PERCENTAGE_AMD"] = { type ='value', },
       ["GL_PERFMON_RESULT_AVAILABLE_AMD"] = { type ='value', },
       ["GL_PERFMON_RESULT_SIZE_AMD"] = { type ='value', },
       ["GL_PERFMON_RESULT_AMD"] = { type ='value', },
       ["GL_EXTERNAL_VIRTUAL_MEMORY_BUFFER_AMD"] = { type ='value', },
       ["GL_SUBSAMPLE_DISTANCE_AMD"] = { type ='value', },
       ["GL_TEXTURE_STORAGE_SPARSE_BIT_AMD"] = { type ='value', },
       ["GL_VIRTUAL_PAGE_SIZE_X_AMD"] = { type ='value', },
       ["GL_VIRTUAL_PAGE_SIZE_Y_AMD"] = { type ='value', },
       ["GL_VIRTUAL_PAGE_SIZE_Z_AMD"] = { type ='value', },
       ["GL_MAX_SPARSE_TEXTURE_SIZE_AMD"] = { type ='value', },
       ["GL_MAX_SPARSE_3D_TEXTURE_SIZE_AMD"] = { type ='value', },
       ["GL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS"] = { type ='value', },
       ["GL_MIN_SPARSE_LEVEL_AMD"] = { type ='value', },
       ["GL_MIN_LOD_WARNING_AMD"] = { type ='value', },
       ["GL_REPLACE_VALUE_AMD"] = { type ='value', },
       ["GL_STENCIL_OP_VALUE_AMD"] = { type ='value', },
       ["GL_STENCIL_BACK_OP_VALUE_AMD"] = { type ='value', },
       ["GL_TESSELLATION_MODE_AMD"] = { type ='value', },
       ["GL_TESSELLATION_FACTOR_AMD"] = { type ='value', },
       ["GL_DISCRETE_AMD"] = { type ='value', },
       ["GL_CONTINUOUS_AMD"] = { type ='value', },
       ["GL_FIXED"] = { type ='value', },
       ["GL_IMPLEMENTATION_COLOR_READ_TYPE"] = { type ='value', },
       ["GL_IMPLEMENTATION_COLOR_READ_FORMAT"] = { type ='value', },
       ["GL_RGB565"] = { type ='value', },
       ["GL_LOW_FLOAT"] = { type ='value', },
       ["GL_MEDIUM_FLOAT"] = { type ='value', },
       ["GL_HIGH_FLOAT"] = { type ='value', },
       ["GL_LOW_INT"] = { type ='value', },
       ["GL_MEDIUM_INT"] = { type ='value', },
       ["GL_HIGH_INT"] = { type ='value', },
       ["GL_SHADER_BINARY_FORMATS"] = { type ='value', },
       ["GL_NUM_SHADER_BINARY_FORMATS"] = { type ='value', },
       ["GL_SHADER_COMPILER"] = { type ='value', },
       ["GL_MAX_VERTEX_UNIFORM_VECTORS"] = { type ='value', },
       ["GL_MAX_VARYING_VECTORS"] = { type ='value', },
       ["GL_MAX_FRAGMENT_UNIFORM_VECTORS"] = { type ='value', },
       ["GL_TEXTURE_IMMUTABLE_LEVELS"] = { type ='value', },
       ["GL_PRIMITIVE_RESTART_FIXED_INDEX"] = { type ='value', },
       ["GL_ANY_SAMPLES_PASSED_CONSERVATIVE"] = { type ='value', },
       ["GL_MAX_ELEMENT_INDEX"] = { type ='value', },
       ["GL_COMPRESSED_R11_EAC"] = { type ='value', },
       ["GL_COMPRESSED_SIGNED_R11_EAC"] = { type ='value', },
       ["GL_COMPRESSED_RG11_EAC"] = { type ='value', },
       ["GL_COMPRESSED_SIGNED_RG11_EAC"] = { type ='value', },
       ["GL_COMPRESSED_RGB8_ETC2"] = { type ='value', },
       ["GL_COMPRESSED_SRGB8_ETC2"] = { type ='value', },
       ["GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2"] = { type ='value', },
       ["GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2"] = { type ='value', },
       ["GL_COMPRESSED_RGBA8_ETC2_EAC"] = { type ='value', },
       ["GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC"] = { type ='value', },
       ["GL_UNSIGNED_INT64_ARB"] = { type ='value', },
       ["GL_SRC1_COLOR"] = { type ='value', },
       ["GL_ONE_MINUS_SRC1_COLOR"] = { type ='value', },
       ["GL_ONE_MINUS_SRC1_ALPHA"] = { type ='value', },
       ["GL_MAX_DUAL_SOURCE_DRAW_BUFFERS"] = { type ='value', },
       ["GL_MAP_READ_BIT"] = { type ='value', },
       ["GL_MAP_WRITE_BIT"] = { type ='value', },
       ["GL_MAP_PERSISTENT_BIT"] = { type ='value', },
       ["GL_MAP_COHERENT_BIT"] = { type ='value', },
       ["GL_DYNAMIC_STORAGE_BIT"] = { type ='value', },
       ["GL_CLIENT_STORAGE_BIT"] = { type ='value', },
       ["GL_CLIENT_MAPPED_BUFFER_BARRIER_BIT"] = { type ='value', },
       ["GL_BUFFER_IMMUTABLE_STORAGE"] = { type ='value', },
       ["GL_BUFFER_STORAGE_FLAGS"] = { type ='value', },
       ["GL_SYNC_CL_EVENT_ARB"] = { type ='value', },
       ["GL_SYNC_CL_EVENT_COMPLETE_ARB"] = { type ='value', },
       ["GL_CLEAR_TEXTURE"] = { type ='value', },
       ["GL_RGBA_FLOAT_MODE_ARB"] = { type ='value', },
       ["GL_UNPACK_COMPRESSED_BLOCK_WIDTH"] = { type ='value', },
       ["GL_UNPACK_COMPRESSED_BLOCK_HEIGHT"] = { type ='value', },
       ["GL_UNPACK_COMPRESSED_BLOCK_DEPTH"] = { type ='value', },
       ["GL_UNPACK_COMPRESSED_BLOCK_SIZE"] = { type ='value', },
       ["GL_PACK_COMPRESSED_BLOCK_WIDTH"] = { type ='value', },
       ["GL_PACK_COMPRESSED_BLOCK_HEIGHT"] = { type ='value', },
       ["GL_PACK_COMPRESSED_BLOCK_DEPTH"] = { type ='value', },
       ["GL_PACK_COMPRESSED_BLOCK_SIZE"] = { type ='value', },
       ["GL_COMPUTE_SHADER_BIT"] = { type ='value', },
       ["GL_MAX_COMPUTE_SHARED_MEMORY_SIZE"] = { type ='value', },
       ["GL_MAX_COMPUTE_UNIFORM_COMPONENTS"] = { type ='value', },
       ["GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS"] = { type ='value', },
       ["GL_MAX_COMPUTE_ATOMIC_COUNTERS"] = { type ='value', },
       ["GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS"] = { type ='value', },
       ["GL_COMPUTE_WORK_GROUP_SIZE"] = { type ='value', },
       ["GL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS"] = { type ='value', },
       ["GL_UNIFORM_BLOCK_REFERENCED_BY_COMPUTE_SHADER"] = { type ='value', },
       ["GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_COMPUTE_SHADER"] = { type ='value', },
       ["GL_DISPATCH_INDIRECT_BUFFER"] = { type ='value', },
       ["GL_DISPATCH_INDIRECT_BUFFER_BINDING"] = { type ='value', },
       ["GL_COMPUTE_SHADER"] = { type ='value', },
       ["GL_MAX_COMPUTE_UNIFORM_BLOCKS"] = { type ='value', },
       ["GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS"] = { type ='value', },
       ["GL_MAX_COMPUTE_IMAGE_UNIFORMS"] = { type ='value', },
       ["GL_MAX_COMPUTE_WORK_GROUP_COUNT"] = { type ='value', },
       ["GL_MAX_COMPUTE_WORK_GROUP_SIZE"] = { type ='value', },
       ["GL_MAX_COMPUTE_FIXED_GROUP_INVOCATIONS_ARB"] = { type ='value', },
       ["GL_MAX_COMPUTE_FIXED_GROUP_SIZE_ARB"] = { type ='value', },
       ["GL_MAX_COMPUTE_VARIABLE_GROUP_INVOCATIONS_ARB"] = { type ='value', },
       ["GL_MAX_COMPUTE_VARIABLE_GROUP_SIZE_ARB"] = { type ='value', },
       ["GL_COPY_READ_BUFFER"] = { type ='value', },
       ["GL_COPY_WRITE_BUFFER"] = { type ='value', },
       ["GL_DEPTH_COMPONENT32F"] = { type ='value', },
       ["GL_DEPTH32F_STENCIL8"] = { type ='value', },
       ["GL_FLOAT_32_UNSIGNED_INT_24_8_REV"] = { type ='value', },
       ["GL_DEPTH_CLAMP"] = { type ='value', },
       ["GL_DRAW_INDIRECT_BUFFER"] = { type ='value', },
       ["GL_DRAW_INDIRECT_BUFFER_BINDING"] = { type ='value', },
       ["GL_LOCATION_COMPONENT"] = { type ='value', },
       ["GL_TRANSFORM_FEEDBACK_BUFFER_INDEX"] = { type ='value', },
       ["GL_TRANSFORM_FEEDBACK_BUFFER_STRIDE"] = { type ='value', },
       ["GL_MAX_UNIFORM_LOCATIONS"] = { type ='value', },
       ["GL_FRAGMENT_PROGRAM_ARB"] = { type ='value', },
       ["GL_PROGRAM_ALU_INSTRUCTIONS_ARB"] = { type ='value', },
       ["GL_PROGRAM_TEX_INSTRUCTIONS_ARB"] = { type ='value', },
       ["GL_PROGRAM_TEX_INDIRECTIONS_ARB"] = { type ='value', },
       ["GL_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB"] = { type ='value', },
       ["GL_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB"] = { type ='value', },
       ["GL_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB"] = { type ='value', },
       ["GL_MAX_PROGRAM_ALU_INSTRUCTIONS_ARB"] = { type ='value', },
       ["GL_MAX_PROGRAM_TEX_INSTRUCTIONS_ARB"] = { type ='value', },
       ["GL_MAX_PROGRAM_TEX_INDIRECTIONS_ARB"] = { type ='value', },
       ["GL_MAX_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB"] = { type ='value', },
       ["GL_MAX_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB"] = { type ='value', },
       ["GL_MAX_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB"] = { type ='value', },
       ["GL_FRAMEBUFFER_DEFAULT_WIDTH"] = { type ='value', },
       ["GL_FRAMEBUFFER_DEFAULT_HEIGHT"] = { type ='value', },
       ["GL_FRAMEBUFFER_DEFAULT_LAYERS"] = { type ='value', },
       ["GL_FRAMEBUFFER_DEFAULT_SAMPLES"] = { type ='value', },
       ["GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS"] = { type ='value', },
       ["GL_MAX_FRAMEBUFFER_WIDTH"] = { type ='value', },
       ["GL_MAX_FRAMEBUFFER_HEIGHT"] = { type ='value', },
       ["GL_MAX_FRAMEBUFFER_LAYERS"] = { type ='value', },
       ["GL_MAX_FRAMEBUFFER_SAMPLES"] = { type ='value', },
       ["GL_INVALID_FRAMEBUFFER_OPERATION"] = { type ='value', },
       ["GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING"] = { type ='value', },
       ["GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE"] = { type ='value', },
       ["GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE"] = { type ='value', },
       ["GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE"] = { type ='value', },
       ["GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE"] = { type ='value', },
       ["GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE"] = { type ='value', },
       ["GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE"] = { type ='value', },
       ["GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE"] = { type ='value', },
       ["GL_FRAMEBUFFER_DEFAULT"] = { type ='value', },
       ["GL_FRAMEBUFFER_UNDEFINED"] = { type ='value', },
       ["GL_DEPTH_STENCIL_ATTACHMENT"] = { type ='value', },
       ["GL_INDEX"] = { type ='value', },
       ["GL_MAX_RENDERBUFFER_SIZE"] = { type ='value', },
       ["GL_DEPTH_STENCIL"] = { type ='value', },
       ["GL_UNSIGNED_INT_24_8"] = { type ='value', },
       ["GL_DEPTH24_STENCIL8"] = { type ='value', },
       ["GL_TEXTURE_STENCIL_SIZE"] = { type ='value', },
       ["GL_UNSIGNED_NORMALIZED"] = { type ='value', },
       ["GL_DRAW_FRAMEBUFFER_BINDING"] = { type ='value', },
       ["GL_FRAMEBUFFER_BINDING"] = { type ='value', },
       ["GL_RENDERBUFFER_BINDING"] = { type ='value', },
       ["GL_READ_FRAMEBUFFER"] = { type ='value', },
       ["GL_DRAW_FRAMEBUFFER"] = { type ='value', },
       ["GL_READ_FRAMEBUFFER_BINDING"] = { type ='value', },
       ["GL_RENDERBUFFER_SAMPLES"] = { type ='value', },
       ["GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE"] = { type ='value', },
       ["GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME"] = { type ='value', },
       ["GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL"] = { type ='value', },
       ["GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE"] = { type ='value', },
       ["GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER"] = { type ='value', },
       ["GL_FRAMEBUFFER_COMPLETE"] = { type ='value', },
       ["GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT"] = { type ='value', },
       ["GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT"] = { type ='value', },
       ["GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER"] = { type ='value', },
       ["GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER"] = { type ='value', },
       ["GL_FRAMEBUFFER_UNSUPPORTED"] = { type ='value', },
       ["GL_MAX_COLOR_ATTACHMENTS"] = { type ='value', },
       ["GL_COLOR_ATTACHMENT0"] = { type ='value', },
       ["GL_COLOR_ATTACHMENT1"] = { type ='value', },
       ["GL_COLOR_ATTACHMENT2"] = { type ='value', },
       ["GL_COLOR_ATTACHMENT3"] = { type ='value', },
       ["GL_COLOR_ATTACHMENT4"] = { type ='value', },
       ["GL_COLOR_ATTACHMENT5"] = { type ='value', },
       ["GL_COLOR_ATTACHMENT6"] = { type ='value', },
       ["GL_COLOR_ATTACHMENT7"] = { type ='value', },
       ["GL_COLOR_ATTACHMENT8"] = { type ='value', },
       ["GL_COLOR_ATTACHMENT9"] = { type ='value', },
       ["GL_COLOR_ATTACHMENT10"] = { type ='value', },
       ["GL_COLOR_ATTACHMENT11"] = { type ='value', },
       ["GL_COLOR_ATTACHMENT12"] = { type ='value', },
       ["GL_COLOR_ATTACHMENT13"] = { type ='value', },
       ["GL_COLOR_ATTACHMENT14"] = { type ='value', },
       ["GL_COLOR_ATTACHMENT15"] = { type ='value', },
       ["GL_DEPTH_ATTACHMENT"] = { type ='value', },
       ["GL_STENCIL_ATTACHMENT"] = { type ='value', },
       ["GL_FRAMEBUFFER"] = { type ='value', },
       ["GL_RENDERBUFFER"] = { type ='value', },
       ["GL_RENDERBUFFER_WIDTH"] = { type ='value', },
       ["GL_RENDERBUFFER_HEIGHT"] = { type ='value', },
       ["GL_RENDERBUFFER_INTERNAL_FORMAT"] = { type ='value', },
       ["GL_STENCIL_INDEX1"] = { type ='value', },
       ["GL_STENCIL_INDEX4"] = { type ='value', },
       ["GL_STENCIL_INDEX8"] = { type ='value', },
       ["GL_STENCIL_INDEX16"] = { type ='value', },
       ["GL_RENDERBUFFER_RED_SIZE"] = { type ='value', },
       ["GL_RENDERBUFFER_GREEN_SIZE"] = { type ='value', },
       ["GL_RENDERBUFFER_BLUE_SIZE"] = { type ='value', },
       ["GL_RENDERBUFFER_ALPHA_SIZE"] = { type ='value', },
       ["GL_RENDERBUFFER_DEPTH_SIZE"] = { type ='value', },
       ["GL_RENDERBUFFER_STENCIL_SIZE"] = { type ='value', },
       ["GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE"] = { type ='value', },
       ["GL_MAX_SAMPLES"] = { type ='value', },
       ["GL_FRAMEBUFFER_SRGB"] = { type ='value', },
       ["GL_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_ARB"] = { type ='value', },
       ["GL_MAX_GEOMETRY_VARYING_COMPONENTS_ARB"] = { type ='value', },
       ["GL_MAX_VERTEX_VARYING_COMPONENTS_ARB"] = { type ='value', },
       ["GL_PROGRAM_BINARY_RETRIEVABLE_HINT"] = { type ='value', },
       ["GL_PROGRAM_BINARY_LENGTH"] = { type ='value', },
       ["GL_NUM_PROGRAM_BINARY_FORMATS"] = { type ='value', },
       ["GL_PROGRAM_BINARY_FORMATS"] = { type ='value', },
       ["GL_MAX_VERTEX_STREAMS"] = { type ='value', },
       ["GL_DOUBLE_MAT2"] = { type ='value', },
       ["GL_DOUBLE_MAT3"] = { type ='value', },
       ["GL_DOUBLE_MAT4"] = { type ='value', },
       ["GL_DOUBLE_MAT2x3"] = { type ='value', },
       ["GL_DOUBLE_MAT2x4"] = { type ='value', },
       ["GL_DOUBLE_MAT3x2"] = { type ='value', },
       ["GL_DOUBLE_MAT3x4"] = { type ='value', },
       ["GL_DOUBLE_MAT4x2"] = { type ='value', },
       ["GL_DOUBLE_MAT4x3"] = { type ='value', },
       ["GL_DOUBLE_VEC2"] = { type ='value', },
       ["GL_DOUBLE_VEC3"] = { type ='value', },
       ["GL_DOUBLE_VEC4"] = { type ='value', },
       ["GL_HALF_FLOAT"] = { type ='value', },
       ["GL_CONSTANT_COLOR"] = { type ='value', },
       ["GL_ONE_MINUS_CONSTANT_COLOR"] = { type ='value', },
       ["GL_CONSTANT_ALPHA"] = { type ='value', },
       ["GL_ONE_MINUS_CONSTANT_ALPHA"] = { type ='value', },
       ["GL_BLEND_COLOR"] = { type ='value', },
       ["GL_FUNC_ADD"] = { type ='value', },
       ["GL_MIN"] = { type ='value', },
       ["GL_MAX"] = { type ='value', },
       ["GL_BLEND_EQUATION"] = { type ='value', },
       ["GL_FUNC_SUBTRACT"] = { type ='value', },
       ["GL_FUNC_REVERSE_SUBTRACT"] = { type ='value', },
       ["GL_CONVOLUTION_1D"] = { type ='value', },
       ["GL_CONVOLUTION_2D"] = { type ='value', },
       ["GL_SEPARABLE_2D"] = { type ='value', },
       ["GL_CONVOLUTION_BORDER_MODE"] = { type ='value', },
       ["GL_CONVOLUTION_FILTER_SCALE"] = { type ='value', },
       ["GL_CONVOLUTION_FILTER_BIAS"] = { type ='value', },
       ["GL_REDUCE"] = { type ='value', },
       ["GL_CONVOLUTION_FORMAT"] = { type ='value', },
       ["GL_CONVOLUTION_WIDTH"] = { type ='value', },
       ["GL_CONVOLUTION_HEIGHT"] = { type ='value', },
       ["GL_MAX_CONVOLUTION_WIDTH"] = { type ='value', },
       ["GL_MAX_CONVOLUTION_HEIGHT"] = { type ='value', },
       ["GL_POST_CONVOLUTION_RED_SCALE"] = { type ='value', },
       ["GL_POST_CONVOLUTION_GREEN_SCALE"] = { type ='value', },
       ["GL_POST_CONVOLUTION_BLUE_SCALE"] = { type ='value', },
       ["GL_POST_CONVOLUTION_ALPHA_SCALE"] = { type ='value', },
       ["GL_POST_CONVOLUTION_RED_BIAS"] = { type ='value', },
       ["GL_POST_CONVOLUTION_GREEN_BIAS"] = { type ='value', },
       ["GL_POST_CONVOLUTION_BLUE_BIAS"] = { type ='value', },
       ["GL_POST_CONVOLUTION_ALPHA_BIAS"] = { type ='value', },
       ["GL_HISTOGRAM"] = { type ='value', },
       ["GL_PROXY_HISTOGRAM"] = { type ='value', },
       ["GL_HISTOGRAM_WIDTH"] = { type ='value', },
       ["GL_HISTOGRAM_FORMAT"] = { type ='value', },
       ["GL_HISTOGRAM_RED_SIZE"] = { type ='value', },
       ["GL_HISTOGRAM_GREEN_SIZE"] = { type ='value', },
       ["GL_HISTOGRAM_BLUE_SIZE"] = { type ='value', },
       ["GL_HISTOGRAM_ALPHA_SIZE"] = { type ='value', },
       ["GL_HISTOGRAM_LUMINANCE_SIZE"] = { type ='value', },
       ["GL_HISTOGRAM_SINK"] = { type ='value', },
       ["GL_MINMAX"] = { type ='value', },
       ["GL_MINMAX_FORMAT"] = { type ='value', },
       ["GL_MINMAX_SINK"] = { type ='value', },
       ["GL_TABLE_TOO_LARGE"] = { type ='value', },
       ["GL_COLOR_MATRIX"] = { type ='value', },
       ["GL_COLOR_MATRIX_STACK_DEPTH"] = { type ='value', },
       ["GL_MAX_COLOR_MATRIX_STACK_DEPTH"] = { type ='value', },
       ["GL_POST_COLOR_MATRIX_RED_SCALE"] = { type ='value', },
       ["GL_POST_COLOR_MATRIX_GREEN_SCALE"] = { type ='value', },
       ["GL_POST_COLOR_MATRIX_BLUE_SCALE"] = { type ='value', },
       ["GL_POST_COLOR_MATRIX_ALPHA_SCALE"] = { type ='value', },
       ["GL_POST_COLOR_MATRIX_RED_BIAS"] = { type ='value', },
       ["GL_POST_COLOR_MATRIX_GREEN_BIAS"] = { type ='value', },
       ["GL_POST_COLOR_MATRIX_BLUE_BIAS"] = { type ='value', },
       ["GL_POST_COLOR_MATRIX_ALPHA_BIAS"] = { type ='value', },
       ["GL_COLOR_TABLE"] = { type ='value', },
       ["GL_POST_CONVOLUTION_COLOR_TABLE"] = { type ='value', },
       ["GL_POST_COLOR_MATRIX_COLOR_TABLE"] = { type ='value', },
       ["GL_PROXY_COLOR_TABLE"] = { type ='value', },
       ["GL_PROXY_POST_CONVOLUTION_COLOR_TABLE"] = { type ='value', },
       ["GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE"] = { type ='value', },
       ["GL_COLOR_TABLE_SCALE"] = { type ='value', },
       ["GL_COLOR_TABLE_BIAS"] = { type ='value', },
       ["GL_COLOR_TABLE_FORMAT"] = { type ='value', },
       ["GL_COLOR_TABLE_WIDTH"] = { type ='value', },
       ["GL_COLOR_TABLE_RED_SIZE"] = { type ='value', },
       ["GL_COLOR_TABLE_GREEN_SIZE"] = { type ='value', },
       ["GL_COLOR_TABLE_BLUE_SIZE"] = { type ='value', },
       ["GL_COLOR_TABLE_ALPHA_SIZE"] = { type ='value', },
       ["GL_COLOR_TABLE_LUMINANCE_SIZE"] = { type ='value', },
       ["GL_COLOR_TABLE_INTENSITY_SIZE"] = { type ='value', },
       ["GL_IGNORE_BORDER"] = { type ='value', },
       ["GL_CONSTANT_BORDER"] = { type ='value', },
       ["GL_WRAP_BORDER"] = { type ='value', },
       ["GL_REPLICATE_BORDER"] = { type ='value', },
       ["GL_CONVOLUTION_BORDER_COLOR"] = { type ='value', },
       ["GL_PARAMETER_BUFFER_ARB"] = { type ='value', },
       ["GL_PARAMETER_BUFFER_BINDING_ARB"] = { type ='value', },
       ["GL_NUM_SAMPLE_COUNTS"] = { type ='value', },
       ["GL_INTERNALFORMAT_SUPPORTED"] = { type ='value', },
       ["GL_INTERNALFORMAT_PREFERRED"] = { type ='value', },
       ["GL_INTERNALFORMAT_RED_SIZE"] = { type ='value', },
       ["GL_INTERNALFORMAT_GREEN_SIZE"] = { type ='value', },
       ["GL_INTERNALFORMAT_BLUE_SIZE"] = { type ='value', },
       ["GL_INTERNALFORMAT_ALPHA_SIZE"] = { type ='value', },
       ["GL_INTERNALFORMAT_DEPTH_SIZE"] = { type ='value', },
       ["GL_INTERNALFORMAT_STENCIL_SIZE"] = { type ='value', },
       ["GL_INTERNALFORMAT_SHARED_SIZE"] = { type ='value', },
       ["GL_INTERNALFORMAT_RED_TYPE"] = { type ='value', },
       ["GL_INTERNALFORMAT_GREEN_TYPE"] = { type ='value', },
       ["GL_INTERNALFORMAT_BLUE_TYPE"] = { type ='value', },
       ["GL_INTERNALFORMAT_ALPHA_TYPE"] = { type ='value', },
       ["GL_INTERNALFORMAT_DEPTH_TYPE"] = { type ='value', },
       ["GL_INTERNALFORMAT_STENCIL_TYPE"] = { type ='value', },
       ["GL_MAX_WIDTH"] = { type ='value', },
       ["GL_MAX_HEIGHT"] = { type ='value', },
       ["GL_MAX_DEPTH"] = { type ='value', },
       ["GL_MAX_LAYERS"] = { type ='value', },
       ["GL_MAX_COMBINED_DIMENSIONS"] = { type ='value', },
       ["GL_COLOR_COMPONENTS"] = { type ='value', },
       ["GL_DEPTH_COMPONENTS"] = { type ='value', },
       ["GL_STENCIL_COMPONENTS"] = { type ='value', },
       ["GL_COLOR_RENDERABLE"] = { type ='value', },
       ["GL_DEPTH_RENDERABLE"] = { type ='value', },
       ["GL_STENCIL_RENDERABLE"] = { type ='value', },
       ["GL_FRAMEBUFFER_RENDERABLE"] = { type ='value', },
       ["GL_FRAMEBUFFER_RENDERABLE_LAYERED"] = { type ='value', },
       ["GL_FRAMEBUFFER_BLEND"] = { type ='value', },
       ["GL_READ_PIXELS"] = { type ='value', },
       ["GL_READ_PIXELS_FORMAT"] = { type ='value', },
       ["GL_READ_PIXELS_TYPE"] = { type ='value', },
       ["GL_TEXTURE_IMAGE_FORMAT"] = { type ='value', },
       ["GL_TEXTURE_IMAGE_TYPE"] = { type ='value', },
       ["GL_GET_TEXTURE_IMAGE_FORMAT"] = { type ='value', },
       ["GL_GET_TEXTURE_IMAGE_TYPE"] = { type ='value', },
       ["GL_MIPMAP"] = { type ='value', },
       ["GL_MANUAL_GENERATE_MIPMAP"] = { type ='value', },
       ["GL_AUTO_GENERATE_MIPMAP"] = { type ='value', },
       ["GL_COLOR_ENCODING"] = { type ='value', },
       ["GL_SRGB_READ"] = { type ='value', },
       ["GL_SRGB_WRITE"] = { type ='value', },
       ["GL_SRGB_DECODE_ARB"] = { type ='value', },
       ["GL_FILTER"] = { type ='value', },
       ["GL_VERTEX_TEXTURE"] = { type ='value', },
       ["GL_TESS_CONTROL_TEXTURE"] = { type ='value', },
       ["GL_TESS_EVALUATION_TEXTURE"] = { type ='value', },
       ["GL_GEOMETRY_TEXTURE"] = { type ='value', },
       ["GL_FRAGMENT_TEXTURE"] = { type ='value', },
       ["GL_COMPUTE_TEXTURE"] = { type ='value', },
       ["GL_TEXTURE_SHADOW"] = { type ='value', },
       ["GL_TEXTURE_GATHER"] = { type ='value', },
       ["GL_TEXTURE_GATHER_SHADOW"] = { type ='value', },
       ["GL_SHADER_IMAGE_LOAD"] = { type ='value', },
       ["GL_SHADER_IMAGE_STORE"] = { type ='value', },
       ["GL_SHADER_IMAGE_ATOMIC"] = { type ='value', },
       ["GL_IMAGE_TEXEL_SIZE"] = { type ='value', },
       ["GL_IMAGE_COMPATIBILITY_CLASS"] = { type ='value', },
       ["GL_IMAGE_PIXEL_FORMAT"] = { type ='value', },
       ["GL_IMAGE_PIXEL_TYPE"] = { type ='value', },
       ["GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_TEST"] = { type ='value', },
       ["GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_TEST"] = { type ='value', },
       ["GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_WRITE"] = { type ='value', },
       ["GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_WRITE"] = { type ='value', },
       ["GL_TEXTURE_COMPRESSED_BLOCK_WIDTH"] = { type ='value', },
       ["GL_TEXTURE_COMPRESSED_BLOCK_HEIGHT"] = { type ='value', },
       ["GL_TEXTURE_COMPRESSED_BLOCK_SIZE"] = { type ='value', },
       ["GL_CLEAR_BUFFER"] = { type ='value', },
       ["GL_TEXTURE_VIEW"] = { type ='value', },
       ["GL_VIEW_COMPATIBILITY_CLASS"] = { type ='value', },
       ["GL_FULL_SUPPORT"] = { type ='value', },
       ["GL_CAVEAT_SUPPORT"] = { type ='value', },
       ["GL_IMAGE_CLASS_4_X_32"] = { type ='value', },
       ["GL_IMAGE_CLASS_2_X_32"] = { type ='value', },
       ["GL_IMAGE_CLASS_1_X_32"] = { type ='value', },
       ["GL_IMAGE_CLASS_4_X_16"] = { type ='value', },
       ["GL_IMAGE_CLASS_2_X_16"] = { type ='value', },
       ["GL_IMAGE_CLASS_1_X_16"] = { type ='value', },
       ["GL_IMAGE_CLASS_4_X_8"] = { type ='value', },
       ["GL_IMAGE_CLASS_2_X_8"] = { type ='value', },
       ["GL_IMAGE_CLASS_1_X_8"] = { type ='value', },
       ["GL_IMAGE_CLASS_11_11_10"] = { type ='value', },
       ["GL_IMAGE_CLASS_10_10_10_2"] = { type ='value', },
       ["GL_VIEW_CLASS_128_BITS"] = { type ='value', },
       ["GL_VIEW_CLASS_96_BITS"] = { type ='value', },
       ["GL_VIEW_CLASS_64_BITS"] = { type ='value', },
       ["GL_VIEW_CLASS_48_BITS"] = { type ='value', },
       ["GL_VIEW_CLASS_32_BITS"] = { type ='value', },
       ["GL_VIEW_CLASS_24_BITS"] = { type ='value', },
       ["GL_VIEW_CLASS_16_BITS"] = { type ='value', },
       ["GL_VIEW_CLASS_8_BITS"] = { type ='value', },
       ["GL_VIEW_CLASS_S3TC_DXT1_RGB"] = { type ='value', },
       ["GL_VIEW_CLASS_S3TC_DXT1_RGBA"] = { type ='value', },
       ["GL_VIEW_CLASS_S3TC_DXT3_RGBA"] = { type ='value', },
       ["GL_VIEW_CLASS_S3TC_DXT5_RGBA"] = { type ='value', },
       ["GL_VIEW_CLASS_RGTC1_RED"] = { type ='value', },
       ["GL_VIEW_CLASS_RGTC2_RG"] = { type ='value', },
       ["GL_VIEW_CLASS_BPTC_UNORM"] = { type ='value', },
       ["GL_VIEW_CLASS_BPTC_FLOAT"] = { type ='value', },
       ["GL_MIN_MAP_BUFFER_ALIGNMENT"] = { type ='value', },
       ["GL_MAP_INVALIDATE_RANGE_BIT"] = { type ='value', },
       ["GL_MAP_INVALIDATE_BUFFER_BIT"] = { type ='value', },
       ["GL_MAP_FLUSH_EXPLICIT_BIT"] = { type ='value', },
       ["GL_MAP_UNSYNCHRONIZED_BIT"] = { type ='value', },
       ["GL_MATRIX_PALETTE_ARB"] = { type ='value', },
       ["GL_MAX_MATRIX_PALETTE_STACK_DEPTH_ARB"] = { type ='value', },
       ["GL_MAX_PALETTE_MATRICES_ARB"] = { type ='value', },
       ["GL_CURRENT_PALETTE_MATRIX_ARB"] = { type ='value', },
       ["GL_MATRIX_INDEX_ARRAY_ARB"] = { type ='value', },
       ["GL_CURRENT_MATRIX_INDEX_ARB"] = { type ='value', },
       ["GL_MATRIX_INDEX_ARRAY_SIZE_ARB"] = { type ='value', },
       ["GL_MATRIX_INDEX_ARRAY_TYPE_ARB"] = { type ='value', },
       ["GL_MATRIX_INDEX_ARRAY_STRIDE_ARB"] = { type ='value', },
       ["GL_MATRIX_INDEX_ARRAY_POINTER_ARB"] = { type ='value', },
       ["GL_ANY_SAMPLES_PASSED"] = { type ='value', },
       ["GL_UNIFORM"] = { type ='value', },
       ["GL_UNIFORM_BLOCK"] = { type ='value', },
       ["GL_PROGRAM_INPUT"] = { type ='value', },
       ["GL_PROGRAM_OUTPUT"] = { type ='value', },
       ["GL_BUFFER_VARIABLE"] = { type ='value', },
       ["GL_SHADER_STORAGE_BLOCK"] = { type ='value', },
       ["GL_IS_PER_PATCH"] = { type ='value', },
       ["GL_VERTEX_SUBROUTINE"] = { type ='value', },
       ["GL_TESS_CONTROL_SUBROUTINE"] = { type ='value', },
       ["GL_TESS_EVALUATION_SUBROUTINE"] = { type ='value', },
       ["GL_GEOMETRY_SUBROUTINE"] = { type ='value', },
       ["GL_FRAGMENT_SUBROUTINE"] = { type ='value', },
       ["GL_COMPUTE_SUBROUTINE"] = { type ='value', },
       ["GL_VERTEX_SUBROUTINE_UNIFORM"] = { type ='value', },
       ["GL_TESS_CONTROL_SUBROUTINE_UNIFORM"] = { type ='value', },
       ["GL_TESS_EVALUATION_SUBROUTINE_UNIFORM"] = { type ='value', },
       ["GL_GEOMETRY_SUBROUTINE_UNIFORM"] = { type ='value', },
       ["GL_FRAGMENT_SUBROUTINE_UNIFORM"] = { type ='value', },
       ["GL_COMPUTE_SUBROUTINE_UNIFORM"] = { type ='value', },
       ["GL_TRANSFORM_FEEDBACK_VARYING"] = { type ='value', },
       ["GL_ACTIVE_RESOURCES"] = { type ='value', },
       ["GL_MAX_NAME_LENGTH"] = { type ='value', },
       ["GL_MAX_NUM_ACTIVE_VARIABLES"] = { type ='value', },
       ["GL_MAX_NUM_COMPATIBLE_SUBROUTINES"] = { type ='value', },
       ["GL_NAME_LENGTH"] = { type ='value', },
       ["GL_TYPE"] = { type ='value', },
       ["GL_ARRAY_SIZE"] = { type ='value', },
       ["GL_OFFSET"] = { type ='value', },
       ["GL_BLOCK_INDEX"] = { type ='value', },
       ["GL_ARRAY_STRIDE"] = { type ='value', },
       ["GL_MATRIX_STRIDE"] = { type ='value', },
       ["GL_IS_ROW_MAJOR"] = { type ='value', },
       ["GL_ATOMIC_COUNTER_BUFFER_INDEX"] = { type ='value', },
       ["GL_BUFFER_BINDING"] = { type ='value', },
       ["GL_BUFFER_DATA_SIZE"] = { type ='value', },
       ["GL_NUM_ACTIVE_VARIABLES"] = { type ='value', },
       ["GL_ACTIVE_VARIABLES"] = { type ='value', },
       ["GL_REFERENCED_BY_VERTEX_SHADER"] = { type ='value', },
       ["GL_REFERENCED_BY_TESS_CONTROL_SHADER"] = { type ='value', },
       ["GL_REFERENCED_BY_TESS_EVALUATION_SHADER"] = { type ='value', },
       ["GL_REFERENCED_BY_GEOMETRY_SHADER"] = { type ='value', },
       ["GL_REFERENCED_BY_FRAGMENT_SHADER"] = { type ='value', },
       ["GL_REFERENCED_BY_COMPUTE_SHADER"] = { type ='value', },
       ["GL_TOP_LEVEL_ARRAY_SIZE"] = { type ='value', },
       ["GL_TOP_LEVEL_ARRAY_STRIDE"] = { type ='value', },
       ["GL_LOCATION"] = { type ='value', },
       ["GL_LOCATION_INDEX"] = { type ='value', },
       ["GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION"] = { type ='value', },
       ["GL_FIRST_VERTEX_CONVENTION"] = { type ='value', },
       ["GL_LAST_VERTEX_CONVENTION"] = { type ='value', },
       ["GL_PROVOKING_VERTEX"] = { type ='value', },
       ["GL_QUERY_BUFFER_BARRIER_BIT"] = { type ='value', },
       ["GL_QUERY_BUFFER"] = { type ='value', },
       ["GL_QUERY_BUFFER_BINDING"] = { type ='value', },
       ["GL_QUERY_RESULT_NO_WAIT"] = { type ='value', },
       ["GL_CONTEXT_FLAG_ROBUST_ACCESS_BIT_ARB"] = { type ='value', },
       ["GL_LOSE_CONTEXT_ON_RESET_ARB"] = { type ='value', },
       ["GL_GUILTY_CONTEXT_RESET_ARB"] = { type ='value', },
       ["GL_INNOCENT_CONTEXT_RESET_ARB"] = { type ='value', },
       ["GL_UNKNOWN_CONTEXT_RESET_ARB"] = { type ='value', },
       ["GL_RESET_NOTIFICATION_STRATEGY_ARB"] = { type ='value', },
       ["GL_NO_RESET_NOTIFICATION_ARB"] = { type ='value', },
       ["GL_SAMPLER_BINDING"] = { type ='value', },
       ["GL_TEXTURE_CUBE_MAP_SEAMLESS"] = { type ='value', },
       ["GL_VERTEX_SHADER_BIT"] = { type ='value', },
       ["GL_FRAGMENT_SHADER_BIT"] = { type ='value', },
       ["GL_GEOMETRY_SHADER_BIT"] = { type ='value', },
       ["GL_TESS_CONTROL_SHADER_BIT"] = { type ='value', },
       ["GL_TESS_EVALUATION_SHADER_BIT"] = { type ='value', },
       ["GL_PROGRAM_SEPARABLE"] = { type ='value', },
       ["GL_ACTIVE_PROGRAM"] = { type ='value', },
       ["GL_PROGRAM_PIPELINE_BINDING"] = { type ='value', },
       ["GL_ALL_SHADER_BITS"] = { type ='value', },
       ["GL_ATOMIC_COUNTER_BUFFER"] = { type ='value', },
       ["GL_ATOMIC_COUNTER_BUFFER_BINDING"] = { type ='value', },
       ["GL_ATOMIC_COUNTER_BUFFER_START"] = { type ='value', },
       ["GL_ATOMIC_COUNTER_BUFFER_SIZE"] = { type ='value', },
       ["GL_ATOMIC_COUNTER_BUFFER_DATA_SIZE"] = { type ='value', },
       ["GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTERS"] = { type ='value', },
       ["GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTER_INDICES"] = { type ='value', },
       ["GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_VERTEX_SHADER"] = { type ='value', },
       ["GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_CONTROL_SHADER"] = { type ='value', },
       ["GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_EVALUATION_SHADER"] = { type ='value', },
       ["GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_GEOMETRY_SHADER"] = { type ='value', },
       ["GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_FRAGMENT_SHADER"] = { type ='value', },
       ["GL_MAX_VERTEX_ATOMIC_COUNTER_BUFFERS"] = { type ='value', },
       ["GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS"] = { type ='value', },
       ["GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS"] = { type ='value', },
       ["GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS"] = { type ='value', },
       ["GL_MAX_FRAGMENT_ATOMIC_COUNTER_BUFFERS"] = { type ='value', },
       ["GL_MAX_COMBINED_ATOMIC_COUNTER_BUFFERS"] = { type ='value', },
       ["GL_MAX_VERTEX_ATOMIC_COUNTERS"] = { type ='value', },
       ["GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS"] = { type ='value', },
       ["GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS"] = { type ='value', },
       ["GL_MAX_GEOMETRY_ATOMIC_COUNTERS"] = { type ='value', },
       ["GL_MAX_FRAGMENT_ATOMIC_COUNTERS"] = { type ='value', },
       ["GL_MAX_COMBINED_ATOMIC_COUNTERS"] = { type ='value', },
       ["GL_MAX_ATOMIC_COUNTER_BUFFER_SIZE"] = { type ='value', },
       ["GL_ACTIVE_ATOMIC_COUNTER_BUFFERS"] = { type ='value', },
       ["GL_UNIFORM_ATOMIC_COUNTER_BUFFER_INDEX"] = { type ='value', },
       ["GL_UNSIGNED_INT_ATOMIC_COUNTER"] = { type ='value', },
       ["GL_MAX_ATOMIC_COUNTER_BUFFER_BINDINGS"] = { type ='value', },
       ["GL_VERTEX_ATTRIB_ARRAY_BARRIER_BIT"] = { type ='value', },
       ["GL_ELEMENT_ARRAY_BARRIER_BIT"] = { type ='value', },
       ["GL_UNIFORM_BARRIER_BIT"] = { type ='value', },
       ["GL_TEXTURE_FETCH_BARRIER_BIT"] = { type ='value', },
       ["GL_SHADER_IMAGE_ACCESS_BARRIER_BIT"] = { type ='value', },
       ["GL_COMMAND_BARRIER_BIT"] = { type ='value', },
       ["GL_PIXEL_BUFFER_BARRIER_BIT"] = { type ='value', },
       ["GL_TEXTURE_UPDATE_BARRIER_BIT"] = { type ='value', },
       ["GL_BUFFER_UPDATE_BARRIER_BIT"] = { type ='value', },
       ["GL_FRAMEBUFFER_BARRIER_BIT"] = { type ='value', },
       ["GL_TRANSFORM_FEEDBACK_BARRIER_BIT"] = { type ='value', },
       ["GL_ATOMIC_COUNTER_BARRIER_BIT"] = { type ='value', },
       ["GL_MAX_IMAGE_UNITS"] = { type ='value', },
       ["GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS"] = { type ='value', },
       ["GL_IMAGE_BINDING_NAME"] = { type ='value', },
       ["GL_IMAGE_BINDING_LEVEL"] = { type ='value', },
       ["GL_IMAGE_BINDING_LAYERED"] = { type ='value', },
       ["GL_IMAGE_BINDING_LAYER"] = { type ='value', },
       ["GL_IMAGE_BINDING_ACCESS"] = { type ='value', },
       ["GL_IMAGE_1D"] = { type ='value', },
       ["GL_IMAGE_2D"] = { type ='value', },
       ["GL_IMAGE_3D"] = { type ='value', },
       ["GL_IMAGE_2D_RECT"] = { type ='value', },
       ["GL_IMAGE_CUBE"] = { type ='value', },
       ["GL_IMAGE_BUFFER"] = { type ='value', },
       ["GL_IMAGE_1D_ARRAY"] = { type ='value', },
       ["GL_IMAGE_2D_ARRAY"] = { type ='value', },
       ["GL_IMAGE_CUBE_MAP_ARRAY"] = { type ='value', },
       ["GL_IMAGE_2D_MULTISAMPLE"] = { type ='value', },
       ["GL_IMAGE_2D_MULTISAMPLE_ARRAY"] = { type ='value', },
       ["GL_INT_IMAGE_1D"] = { type ='value', },
       ["GL_INT_IMAGE_2D"] = { type ='value', },
       ["GL_INT_IMAGE_3D"] = { type ='value', },
       ["GL_INT_IMAGE_2D_RECT"] = { type ='value', },
       ["GL_INT_IMAGE_CUBE"] = { type ='value', },
       ["GL_INT_IMAGE_BUFFER"] = { type ='value', },
       ["GL_INT_IMAGE_1D_ARRAY"] = { type ='value', },
       ["GL_INT_IMAGE_2D_ARRAY"] = { type ='value', },
       ["GL_INT_IMAGE_CUBE_MAP_ARRAY"] = { type ='value', },
       ["GL_INT_IMAGE_2D_MULTISAMPLE"] = { type ='value', },
       ["GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY"] = { type ='value', },
       ["GL_UNSIGNED_INT_IMAGE_1D"] = { type ='value', },
       ["GL_UNSIGNED_INT_IMAGE_2D"] = { type ='value', },
       ["GL_UNSIGNED_INT_IMAGE_3D"] = { type ='value', },
       ["GL_UNSIGNED_INT_IMAGE_2D_RECT"] = { type ='value', },
       ["GL_UNSIGNED_INT_IMAGE_CUBE"] = { type ='value', },
       ["GL_UNSIGNED_INT_IMAGE_BUFFER"] = { type ='value', },
       ["GL_UNSIGNED_INT_IMAGE_1D_ARRAY"] = { type ='value', },
       ["GL_UNSIGNED_INT_IMAGE_2D_ARRAY"] = { type ='value', },
       ["GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY"] = { type ='value', },
       ["GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE"] = { type ='value', },
       ["GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY"] = { type ='value', },
       ["GL_MAX_IMAGE_SAMPLES"] = { type ='value', },
       ["GL_IMAGE_BINDING_FORMAT"] = { type ='value', },
       ["GL_IMAGE_FORMAT_COMPATIBILITY_TYPE"] = { type ='value', },
       ["GL_IMAGE_FORMAT_COMPATIBILITY_BY_SIZE"] = { type ='value', },
       ["GL_IMAGE_FORMAT_COMPATIBILITY_BY_CLASS"] = { type ='value', },
       ["GL_MAX_VERTEX_IMAGE_UNIFORMS"] = { type ='value', },
       ["GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS"] = { type ='value', },
       ["GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS"] = { type ='value', },
       ["GL_MAX_GEOMETRY_IMAGE_UNIFORMS"] = { type ='value', },
       ["GL_MAX_FRAGMENT_IMAGE_UNIFORMS"] = { type ='value', },
       ["GL_MAX_COMBINED_IMAGE_UNIFORMS"] = { type ='value', },
       ["GL_ALL_BARRIER_BITS"] = { type ='value', },
       ["GL_PROGRAM_OBJECT_ARB"] = { type ='value', },
       ["GL_SHADER_OBJECT_ARB"] = { type ='value', },
       ["GL_OBJECT_SUBTYPE_ARB"] = { type ='value', },
       ["GL_OBJECT_DELETE_STATUS_ARB"] = { type ='value', },
       ["GL_OBJECT_COMPILE_STATUS_ARB"] = { type ='value', },
       ["GL_OBJECT_LINK_STATUS_ARB"] = { type ='value', },
       ["GL_OBJECT_VALIDATE_STATUS_ARB"] = { type ='value', },
       ["GL_OBJECT_INFO_LOG_LENGTH_ARB"] = { type ='value', },
       ["GL_OBJECT_ATTACHED_OBJECTS_ARB"] = { type ='value', },
       ["GL_OBJECT_ACTIVE_UNIFORMS_ARB"] = { type ='value', },
       ["GL_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH_ARB"] = { type ='value', },
       ["GL_OBJECT_SHADER_SOURCE_LENGTH_ARB"] = { type ='value', },
       ["GL_SHADER_STORAGE_BARRIER_BIT"] = { type ='value', },
       ["GL_MAX_COMBINED_SHADER_OUTPUT_RESOURCES"] = { type ='value', },
       ["GL_SHADER_STORAGE_BUFFER"] = { type ='value', },
       ["GL_SHADER_STORAGE_BUFFER_BINDING"] = { type ='value', },
       ["GL_SHADER_STORAGE_BUFFER_START"] = { type ='value', },
       ["GL_SHADER_STORAGE_BUFFER_SIZE"] = { type ='value', },
       ["GL_MAX_VERTEX_SHADER_STORAGE_BLOCKS"] = { type ='value', },
       ["GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS"] = { type ='value', },
       ["GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS"] = { type ='value', },
       ["GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS"] = { type ='value', },
       ["GL_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS"] = { type ='value', },
       ["GL_MAX_COMPUTE_SHADER_STORAGE_BLOCKS"] = { type ='value', },
       ["GL_MAX_COMBINED_SHADER_STORAGE_BLOCKS"] = { type ='value', },
       ["GL_MAX_SHADER_STORAGE_BUFFER_BINDINGS"] = { type ='value', },
       ["GL_MAX_SHADER_STORAGE_BLOCK_SIZE"] = { type ='value', },
       ["GL_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT"] = { type ='value', },
       ["GL_ACTIVE_SUBROUTINES"] = { type ='value', },
       ["GL_ACTIVE_SUBROUTINE_UNIFORMS"] = { type ='value', },
       ["GL_MAX_SUBROUTINES"] = { type ='value', },
       ["GL_MAX_SUBROUTINE_UNIFORM_LOCATIONS"] = { type ='value', },
       ["GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS"] = { type ='value', },
       ["GL_ACTIVE_SUBROUTINE_MAX_LENGTH"] = { type ='value', },
       ["GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH"] = { type ='value', },
       ["GL_NUM_COMPATIBLE_SUBROUTINES"] = { type ='value', },
       ["GL_COMPATIBLE_SUBROUTINES"] = { type ='value', },
       ["GL_SHADER_INCLUDE_ARB"] = { type ='value', },
       ["GL_NAMED_STRING_LENGTH_ARB"] = { type ='value', },
       ["GL_NAMED_STRING_TYPE_ARB"] = { type ='value', },
       ["GL_TEXTURE_COMPARE_FAIL_VALUE_ARB"] = { type ='value', },
       ["GL_VIRTUAL_PAGE_SIZE_X_ARB"] = { type ='value', },
       ["GL_VIRTUAL_PAGE_SIZE_Y_ARB"] = { type ='value', },
       ["GL_VIRTUAL_PAGE_SIZE_Z_ARB"] = { type ='value', },
       ["GL_MAX_SPARSE_TEXTURE_SIZE_ARB"] = { type ='value', },
       ["GL_MAX_SPARSE_3D_TEXTURE_SIZE_ARB"] = { type ='value', },
       ["GL_TEXTURE_SPARSE_ARB"] = { type ='value', },
       ["GL_VIRTUAL_PAGE_SIZE_INDEX_ARB"] = { type ='value', },
       ["GL_NUM_VIRTUAL_PAGE_SIZES_ARB"] = { type ='value', },
       ["GL_SPARSE_TEXTURE_FULL_ARRAY_CUBE_MIPMAPS_ARB"] = { type ='value', },
       ["GL_NUM_SPARSE_LEVELS_ARB"] = { type ='value', },
       ["GL_DEPTH_STENCIL_TEXTURE_MODE"] = { type ='value', },
       ["GL_SYNC_FLUSH_COMMANDS_BIT"] = { type ='value', },
       ["GL_MAX_SERVER_WAIT_TIMEOUT"] = { type ='value', },
       ["GL_OBJECT_TYPE"] = { type ='value', },
       ["GL_SYNC_CONDITION"] = { type ='value', },
       ["GL_SYNC_STATUS"] = { type ='value', },
       ["GL_SYNC_FLAGS"] = { type ='value', },
       ["GL_SYNC_FENCE"] = { type ='value', },
       ["GL_SYNC_GPU_COMMANDS_COMPLETE"] = { type ='value', },
       ["GL_UNSIGNALED"] = { type ='value', },
       ["GL_SIGNALED"] = { type ='value', },
       ["GL_ALREADY_SIGNALED"] = { type ='value', },
       ["GL_TIMEOUT_EXPIRED"] = { type ='value', },
       ["GL_CONDITION_SATISFIED"] = { type ='value', },
       ["GL_WAIT_FAILED"] = { type ='value', },
       ["GL_TIMEOUT_IGNORED"] = { type ='value', },
       ["GL_PATCHES"] = { type ='value', },
       ["GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_CONTROL_SHADER"] = { type ='value', },
       ["GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_EVALUATION_SHADER"] = { type ='value', },
       ["GL_MAX_TESS_CONTROL_INPUT_COMPONENTS"] = { type ='value', },
       ["GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS"] = { type ='value', },
       ["GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS"] = { type ='value', },
       ["GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS"] = { type ='value', },
       ["GL_PATCH_VERTICES"] = { type ='value', },
       ["GL_PATCH_DEFAULT_INNER_LEVEL"] = { type ='value', },
       ["GL_PATCH_DEFAULT_OUTER_LEVEL"] = { type ='value', },
       ["GL_TESS_CONTROL_OUTPUT_VERTICES"] = { type ='value', },
       ["GL_TESS_GEN_MODE"] = { type ='value', },
       ["GL_TESS_GEN_SPACING"] = { type ='value', },
       ["GL_TESS_GEN_VERTEX_ORDER"] = { type ='value', },
       ["GL_TESS_GEN_POINT_MODE"] = { type ='value', },
       ["GL_ISOLINES"] = { type ='value', },
       ["GL_FRACTIONAL_ODD"] = { type ='value', },
       ["GL_FRACTIONAL_EVEN"] = { type ='value', },
       ["GL_MAX_PATCH_VERTICES"] = { type ='value', },
       ["GL_MAX_TESS_GEN_LEVEL"] = { type ='value', },
       ["GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS"] = { type ='value', },
       ["GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS"] = { type ='value', },
       ["GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS"] = { type ='value', },
       ["GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS"] = { type ='value', },
       ["GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS"] = { type ='value', },
       ["GL_MAX_TESS_PATCH_COMPONENTS"] = { type ='value', },
       ["GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS"] = { type ='value', },
       ["GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS"] = { type ='value', },
       ["GL_TESS_EVALUATION_SHADER"] = { type ='value', },
       ["GL_TESS_CONTROL_SHADER"] = { type ='value', },
       ["GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS"] = { type ='value', },
       ["GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS"] = { type ='value', },
       ["GL_TEXTURE_BUFFER_OFFSET"] = { type ='value', },
       ["GL_TEXTURE_BUFFER_SIZE"] = { type ='value', },
       ["GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT"] = { type ='value', },
       ["GL_COMPRESSED_RED_RGTC1"] = { type ='value', },
       ["GL_COMPRESSED_SIGNED_RED_RGTC1"] = { type ='value', },
       ["GL_COMPRESSED_RG_RGTC2"] = { type ='value', },
       ["GL_COMPRESSED_SIGNED_RG_RGTC2"] = { type ='value', },
       ["GL_ALPHA32F_ARB"] = { type ='value', },
       ["GL_INTENSITY32F_ARB"] = { type ='value', },
       ["GL_LUMINANCE32F_ARB"] = { type ='value', },
       ["GL_LUMINANCE_ALPHA32F_ARB"] = { type ='value', },
       ["GL_ALPHA16F_ARB"] = { type ='value', },
       ["GL_INTENSITY16F_ARB"] = { type ='value', },
       ["GL_LUMINANCE16F_ARB"] = { type ='value', },
       ["GL_LUMINANCE_ALPHA16F_ARB"] = { type ='value', },
       ["GL_MIRROR_CLAMP_TO_EDGE"] = { type ='value', },
       ["GL_SAMPLE_POSITION"] = { type ='value', },
       ["GL_SAMPLE_MASK"] = { type ='value', },
       ["GL_SAMPLE_MASK_VALUE"] = { type ='value', },
       ["GL_MAX_SAMPLE_MASK_WORDS"] = { type ='value', },
       ["GL_TEXTURE_2D_MULTISAMPLE"] = { type ='value', },
       ["GL_PROXY_TEXTURE_2D_MULTISAMPLE"] = { type ='value', },
       ["GL_TEXTURE_2D_MULTISAMPLE_ARRAY"] = { type ='value', },
       ["GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY"] = { type ='value', },
       ["GL_TEXTURE_BINDING_2D_MULTISAMPLE"] = { type ='value', },
       ["GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY"] = { type ='value', },
       ["GL_TEXTURE_SAMPLES"] = { type ='value', },
       ["GL_TEXTURE_FIXED_SAMPLE_LOCATIONS"] = { type ='value', },
       ["GL_SAMPLER_2D_MULTISAMPLE"] = { type ='value', },
       ["GL_INT_SAMPLER_2D_MULTISAMPLE"] = { type ='value', },
       ["GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE"] = { type ='value', },
       ["GL_SAMPLER_2D_MULTISAMPLE_ARRAY"] = { type ='value', },
       ["GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY"] = { type ='value', },
       ["GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY"] = { type ='value', },
       ["GL_MAX_COLOR_TEXTURE_SAMPLES"] = { type ='value', },
       ["GL_MAX_DEPTH_TEXTURE_SAMPLES"] = { type ='value', },
       ["GL_MAX_INTEGER_SAMPLES"] = { type ='value', },
       ["GL_RG"] = { type ='value', },
       ["GL_RG_INTEGER"] = { type ='value', },
       ["GL_R8"] = { type ='value', },
       ["GL_R16"] = { type ='value', },
       ["GL_RG8"] = { type ='value', },
       ["GL_RG16"] = { type ='value', },
       ["GL_R16F"] = { type ='value', },
       ["GL_R32F"] = { type ='value', },
       ["GL_RG16F"] = { type ='value', },
       ["GL_RG32F"] = { type ='value', },
       ["GL_R8I"] = { type ='value', },
       ["GL_R8UI"] = { type ='value', },
       ["GL_R16I"] = { type ='value', },
       ["GL_R16UI"] = { type ='value', },
       ["GL_R32I"] = { type ='value', },
       ["GL_R32UI"] = { type ='value', },
       ["GL_RG8I"] = { type ='value', },
       ["GL_RG16I"] = { type ='value', },
       ["GL_RG32I"] = { type ='value', },
       ["GL_RG32UI"] = { type ='value', },
       ["GL_TEXTURE_IMMUTABLE_FORMAT"] = { type ='value', },
       ["GL_TEXTURE_VIEW_MIN_LEVEL"] = { type ='value', },
       ["GL_TEXTURE_VIEW_NUM_LEVELS"] = { type ='value', },
       ["GL_TEXTURE_VIEW_MIN_LAYER"] = { type ='value', },
       ["GL_TEXTURE_VIEW_NUM_LAYERS"] = { type ='value', },
       ["GL_TIME_ELAPSED"] = { type ='value', },
       ["GL_TIMESTAMP"] = { type ='value', },
       ["GL_TRANSFORM_FEEDBACK"] = { type ='value', },
       ["GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED"] = { type ='value', },
       ["GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE"] = { type ='value', },
       ["GL_TRANSFORM_FEEDBACK_BINDING"] = { type ='value', },
       ["GL_MAX_TRANSFORM_FEEDBACK_BUFFERS"] = { type ='value', },
       ["GL_UNIFORM_BUFFER"] = { type ='value', },
       ["GL_UNIFORM_BUFFER_BINDING"] = { type ='value', },
       ["GL_UNIFORM_BUFFER_START"] = { type ='value', },
       ["GL_UNIFORM_BUFFER_SIZE"] = { type ='value', },
       ["GL_MAX_VERTEX_UNIFORM_BLOCKS"] = { type ='value', },
       ["GL_MAX_GEOMETRY_UNIFORM_BLOCKS"] = { type ='value', },
       ["GL_MAX_FRAGMENT_UNIFORM_BLOCKS"] = { type ='value', },
       ["GL_MAX_COMBINED_UNIFORM_BLOCKS"] = { type ='value', },
       ["GL_MAX_UNIFORM_BUFFER_BINDINGS"] = { type ='value', },
       ["GL_MAX_UNIFORM_BLOCK_SIZE"] = { type ='value', },
       ["GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS"] = { type ='value', },
       ["GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS"] = { type ='value', },
       ["GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS"] = { type ='value', },
       ["GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT"] = { type ='value', },
       ["GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH"] = { type ='value', },
       ["GL_ACTIVE_UNIFORM_BLOCKS"] = { type ='value', },
       ["GL_UNIFORM_TYPE"] = { type ='value', },
       ["GL_UNIFORM_SIZE"] = { type ='value', },
       ["GL_UNIFORM_NAME_LENGTH"] = { type ='value', },
       ["GL_UNIFORM_BLOCK_INDEX"] = { type ='value', },
       ["GL_UNIFORM_OFFSET"] = { type ='value', },
       ["GL_UNIFORM_ARRAY_STRIDE"] = { type ='value', },
       ["GL_UNIFORM_MATRIX_STRIDE"] = { type ='value', },
       ["GL_UNIFORM_IS_ROW_MAJOR"] = { type ='value', },
       ["GL_UNIFORM_BLOCK_BINDING"] = { type ='value', },
       ["GL_UNIFORM_BLOCK_DATA_SIZE"] = { type ='value', },
       ["GL_UNIFORM_BLOCK_NAME_LENGTH"] = { type ='value', },
       ["GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS"] = { type ='value', },
       ["GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES"] = { type ='value', },
       ["GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER"] = { type ='value', },
       ["GL_UNIFORM_BLOCK_REFERENCED_BY_GEOMETRY_SHADER"] = { type ='value', },
       ["GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER"] = { type ='value', },
       ["GL_INVALID_INDEX"] = { type ='value', },
       ["GL_VERTEX_ARRAY_BINDING"] = { type ='value', },
       ["GL_VERTEX_ATTRIB_BINDING"] = { type ='value', },
       ["GL_VERTEX_ATTRIB_RELATIVE_OFFSET"] = { type ='value', },
       ["GL_VERTEX_BINDING_DIVISOR"] = { type ='value', },
       ["GL_VERTEX_BINDING_OFFSET"] = { type ='value', },
       ["GL_VERTEX_BINDING_STRIDE"] = { type ='value', },
       ["GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET"] = { type ='value', },
       ["GL_MAX_VERTEX_ATTRIB_BINDINGS"] = { type ='value', },
       ["GL_MODELVIEW0_ARB"] = { type ='value', },
       ["GL_MODELVIEW1_ARB"] = { type ='value', },
       ["GL_MAX_VERTEX_UNITS_ARB"] = { type ='value', },
       ["GL_ACTIVE_VERTEX_UNITS_ARB"] = { type ='value', },
       ["GL_WEIGHT_SUM_UNITY_ARB"] = { type ='value', },
       ["GL_VERTEX_BLEND_ARB"] = { type ='value', },
       ["GL_CURRENT_WEIGHT_ARB"] = { type ='value', },
       ["GL_WEIGHT_ARRAY_TYPE_ARB"] = { type ='value', },
       ["GL_WEIGHT_ARRAY_STRIDE_ARB"] = { type ='value', },
       ["GL_WEIGHT_ARRAY_SIZE_ARB"] = { type ='value', },
       ["GL_WEIGHT_ARRAY_POINTER_ARB"] = { type ='value', },
       ["GL_WEIGHT_ARRAY_ARB"] = { type ='value', },
       ["GL_MODELVIEW2_ARB"] = { type ='value', },
       ["GL_MODELVIEW3_ARB"] = { type ='value', },
       ["GL_MODELVIEW4_ARB"] = { type ='value', },
       ["GL_MODELVIEW5_ARB"] = { type ='value', },
       ["GL_MODELVIEW6_ARB"] = { type ='value', },
       ["GL_MODELVIEW7_ARB"] = { type ='value', },
       ["GL_MODELVIEW8_ARB"] = { type ='value', },
       ["GL_MODELVIEW9_ARB"] = { type ='value', },
       ["GL_MODELVIEW10_ARB"] = { type ='value', },
       ["GL_MODELVIEW11_ARB"] = { type ='value', },
       ["GL_MODELVIEW12_ARB"] = { type ='value', },
       ["GL_MODELVIEW13_ARB"] = { type ='value', },
       ["GL_MODELVIEW14_ARB"] = { type ='value', },
       ["GL_MODELVIEW15_ARB"] = { type ='value', },
       ["GL_MODELVIEW16_ARB"] = { type ='value', },
       ["GL_MODELVIEW17_ARB"] = { type ='value', },
       ["GL_MODELVIEW18_ARB"] = { type ='value', },
       ["GL_MODELVIEW19_ARB"] = { type ='value', },
       ["GL_MODELVIEW20_ARB"] = { type ='value', },
       ["GL_MODELVIEW21_ARB"] = { type ='value', },
       ["GL_MODELVIEW22_ARB"] = { type ='value', },
       ["GL_MODELVIEW23_ARB"] = { type ='value', },
       ["GL_MODELVIEW24_ARB"] = { type ='value', },
       ["GL_MODELVIEW25_ARB"] = { type ='value', },
       ["GL_MODELVIEW26_ARB"] = { type ='value', },
       ["GL_MODELVIEW27_ARB"] = { type ='value', },
       ["GL_MODELVIEW28_ARB"] = { type ='value', },
       ["GL_MODELVIEW29_ARB"] = { type ='value', },
       ["GL_MODELVIEW30_ARB"] = { type ='value', },
       ["GL_MODELVIEW31_ARB"] = { type ='value', },
       ["GL_VERTEX_PROGRAM_ARB"] = { type ='value', },
       ["GL_PROGRAM_LENGTH_ARB"] = { type ='value', },
       ["GL_PROGRAM_STRING_ARB"] = { type ='value', },
       ["GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB"] = { type ='value', },
       ["GL_MAX_PROGRAM_MATRICES_ARB"] = { type ='value', },
       ["GL_CURRENT_MATRIX_STACK_DEPTH_ARB"] = { type ='value', },
       ["GL_CURRENT_MATRIX_ARB"] = { type ='value', },
       ["GL_PROGRAM_ERROR_POSITION_ARB"] = { type ='value', },
       ["GL_PROGRAM_BINDING_ARB"] = { type ='value', },
       ["GL_PROGRAM_ERROR_STRING_ARB"] = { type ='value', },
       ["GL_PROGRAM_FORMAT_ASCII_ARB"] = { type ='value', },
       ["GL_PROGRAM_FORMAT_ARB"] = { type ='value', },
       ["GL_PROGRAM_INSTRUCTIONS_ARB"] = { type ='value', },
       ["GL_MAX_PROGRAM_INSTRUCTIONS_ARB"] = { type ='value', },
       ["GL_PROGRAM_NATIVE_INSTRUCTIONS_ARB"] = { type ='value', },
       ["GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB"] = { type ='value', },
       ["GL_PROGRAM_TEMPORARIES_ARB"] = { type ='value', },
       ["GL_MAX_PROGRAM_TEMPORARIES_ARB"] = { type ='value', },
       ["GL_PROGRAM_NATIVE_TEMPORARIES_ARB"] = { type ='value', },
       ["GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB"] = { type ='value', },
       ["GL_PROGRAM_PARAMETERS_ARB"] = { type ='value', },
       ["GL_MAX_PROGRAM_PARAMETERS_ARB"] = { type ='value', },
       ["GL_PROGRAM_NATIVE_PARAMETERS_ARB"] = { type ='value', },
       ["GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB"] = { type ='value', },
       ["GL_PROGRAM_ATTRIBS_ARB"] = { type ='value', },
       ["GL_MAX_PROGRAM_ATTRIBS_ARB"] = { type ='value', },
       ["GL_PROGRAM_NATIVE_ATTRIBS_ARB"] = { type ='value', },
       ["GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB"] = { type ='value', },
       ["GL_PROGRAM_ADDRESS_REGISTERS_ARB"] = { type ='value', },
       ["GL_MAX_PROGRAM_ADDRESS_REGISTERS_ARB"] = { type ='value', },
       ["GL_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB"] = { type ='value', },
       ["GL_MAX_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB"] = { type ='value', },
       ["GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB"] = { type ='value', },
       ["GL_MAX_PROGRAM_ENV_PARAMETERS_ARB"] = { type ='value', },
       ["GL_PROGRAM_UNDER_NATIVE_LIMITS_ARB"] = { type ='value', },
       ["GL_TRANSPOSE_CURRENT_MATRIX_ARB"] = { type ='value', },
       ["GL_MATRIX0_ARB"] = { type ='value', },
       ["GL_MATRIX1_ARB"] = { type ='value', },
       ["GL_MATRIX2_ARB"] = { type ='value', },
       ["GL_MATRIX3_ARB"] = { type ='value', },
       ["GL_MATRIX4_ARB"] = { type ='value', },
       ["GL_MATRIX5_ARB"] = { type ='value', },
       ["GL_MATRIX6_ARB"] = { type ='value', },
       ["GL_MATRIX7_ARB"] = { type ='value', },
       ["GL_MATRIX8_ARB"] = { type ='value', },
       ["GL_MATRIX9_ARB"] = { type ='value', },
       ["GL_MATRIX10_ARB"] = { type ='value', },
       ["GL_MATRIX11_ARB"] = { type ='value', },
       ["GL_MATRIX12_ARB"] = { type ='value', },
       ["GL_MATRIX13_ARB"] = { type ='value', },
       ["GL_MATRIX14_ARB"] = { type ='value', },
       ["GL_MATRIX15_ARB"] = { type ='value', },
       ["GL_MATRIX16_ARB"] = { type ='value', },
       ["GL_MATRIX17_ARB"] = { type ='value', },
       ["GL_MATRIX18_ARB"] = { type ='value', },
       ["GL_MATRIX19_ARB"] = { type ='value', },
       ["GL_MATRIX20_ARB"] = { type ='value', },
       ["GL_MATRIX21_ARB"] = { type ='value', },
       ["GL_MATRIX22_ARB"] = { type ='value', },
       ["GL_MATRIX23_ARB"] = { type ='value', },
       ["GL_MATRIX24_ARB"] = { type ='value', },
       ["GL_MATRIX25_ARB"] = { type ='value', },
       ["GL_MATRIX26_ARB"] = { type ='value', },
       ["GL_MATRIX27_ARB"] = { type ='value', },
       ["GL_MATRIX28_ARB"] = { type ='value', },
       ["GL_MATRIX29_ARB"] = { type ='value', },
       ["GL_MATRIX30_ARB"] = { type ='value', },
       ["GL_MATRIX31_ARB"] = { type ='value', },
       ["GL_OBJECT_ACTIVE_ATTRIBUTES_ARB"] = { type ='value', },
       ["GL_OBJECT_ACTIVE_ATTRIBUTE_MAX_LENGTH_ARB"] = { type ='value', },
       ["GL_INT_2_10_10_10_REV"] = { type ='value', },
       ["GL_MAX_VIEWPORTS"] = { type ='value', },
       ["GL_VIEWPORT_SUBPIXEL_BITS"] = { type ='value', },
       ["GL_VIEWPORT_BOUNDS_RANGE"] = { type ='value', },
       ["GL_LAYER_PROVOKING_VERTEX"] = { type ='value', },
       ["GL_VIEWPORT_INDEX_PROVOKING_VERTEX"] = { type ='value', },
       ["GL_UNDEFINED_VERTEX"] = { type ='value', },
       ["GL_PROGRAM_MATRIX_EXT"] = { type ='value', },
       ["GL_TRANSPOSE_PROGRAM_MATRIX_EXT"] = { type ='value', },
       ["GL_PROGRAM_MATRIX_STACK_DEPTH_EXT"] = { type ='value', },
       ["GL_CONTEXT_FLAG_DEBUG_BIT"] = { type ='value', },
       ["GL_DEBUG_OUTPUT_SYNCHRONOUS"] = { type ='value', },
       ["GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH"] = { type ='value', },
       ["GL_DEBUG_CALLBACK_FUNCTION"] = { type ='value', },
       ["GL_DEBUG_CALLBACK_USER_PARAM"] = { type ='value', },
       ["GL_DEBUG_SOURCE_API"] = { type ='value', },
       ["GL_DEBUG_SOURCE_WINDOW_SYSTEM"] = { type ='value', },
       ["GL_DEBUG_SOURCE_SHADER_COMPILER"] = { type ='value', },
       ["GL_DEBUG_SOURCE_THIRD_PARTY"] = { type ='value', },
       ["GL_DEBUG_SOURCE_APPLICATION"] = { type ='value', },
       ["GL_DEBUG_SOURCE_OTHER"] = { type ='value', },
       ["GL_DEBUG_TYPE_ERROR"] = { type ='value', },
       ["GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR"] = { type ='value', },
       ["GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR"] = { type ='value', },
       ["GL_DEBUG_TYPE_PORTABILITY"] = { type ='value', },
       ["GL_DEBUG_TYPE_PERFORMANCE"] = { type ='value', },
       ["GL_DEBUG_TYPE_OTHER"] = { type ='value', },
       ["GL_DEBUG_TYPE_MARKER"] = { type ='value', },
       ["GL_DEBUG_TYPE_PUSH_GROUP"] = { type ='value', },
       ["GL_DEBUG_TYPE_POP_GROUP"] = { type ='value', },
       ["GL_DEBUG_SEVERITY_NOTIFICATION"] = { type ='value', },
       ["GL_MAX_DEBUG_GROUP_STACK_DEPTH"] = { type ='value', },
       ["GL_DEBUG_GROUP_STACK_DEPTH"] = { type ='value', },
       ["GL_BUFFER"] = { type ='value', },
       ["GL_SHADER"] = { type ='value', },
       ["GL_PROGRAM"] = { type ='value', },
       ["GL_QUERY"] = { type ='value', },
       ["GL_PROGRAM_PIPELINE"] = { type ='value', },
       ["GL_SAMPLER"] = { type ='value', },
       ["GL_DISPLAY_LIST"] = { type ='value', },
       ["GL_MAX_LABEL_LENGTH"] = { type ='value', },
       ["GL_MAX_DEBUG_MESSAGE_LENGTH"] = { type ='value', },
       ["GL_MAX_DEBUG_LOGGED_MESSAGES"] = { type ='value', },
       ["GL_DEBUG_LOGGED_MESSAGES"] = { type ='value', },
       ["GL_DEBUG_SEVERITY_HIGH"] = { type ='value', },
       ["GL_DEBUG_SEVERITY_MEDIUM"] = { type ='value', },
       ["GL_DEBUG_SEVERITY_LOW"] = { type ='value', },
       ["GL_DEBUG_OUTPUT"] = { type ='value', },
       ["GL_COMPRESSED_RGBA_ASTC_4x4_KHR"] = { type ='value', },
       ["GL_COMPRESSED_RGBA_ASTC_5x4_KHR"] = { type ='value', },
       ["GL_COMPRESSED_RGBA_ASTC_5x5_KHR"] = { type ='value', },
       ["GL_COMPRESSED_RGBA_ASTC_6x5_KHR"] = { type ='value', },
       ["GL_COMPRESSED_RGBA_ASTC_6x6_KHR"] = { type ='value', },
       ["GL_COMPRESSED_RGBA_ASTC_8x5_KHR"] = { type ='value', },
       ["GL_COMPRESSED_RGBA_ASTC_8x6_KHR"] = { type ='value', },
       ["GL_COMPRESSED_RGBA_ASTC_8x8_KHR"] = { type ='value', },
       ["GL_COMPRESSED_RGBA_ASTC_10x5_KHR"] = { type ='value', },
       ["GL_COMPRESSED_RGBA_ASTC_10x6_KHR"] = { type ='value', },
       ["GL_COMPRESSED_RGBA_ASTC_10x8_KHR"] = { type ='value', },
       ["GL_COMPRESSED_RGBA_ASTC_10x10_KHR"] = { type ='value', },
       ["GL_COMPRESSED_RGBA_ASTC_12x10_KHR"] = { type ='value', },
       ["GL_COMPRESSED_RGBA_ASTC_12x12_KHR"] = { type ='value', },
       ["GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR"] = { type ='value', },
       ["GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR"] = { type ='value', },
       ["GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR"] = { type ='value', },
       ["GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR"] = { type ='value', },
       ["GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR"] = { type ='value', },
       ["GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR"] = { type ='value', },
       ["GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR"] = { type ='value', },
       ["GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR"] = { type ='value', },
       ["GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR"] = { type ='value', },
       ["GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR"] = { type ='value', },
       ["GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR"] = { type ='value', },
       ["GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR"] = { type ='value', },
       ["GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR"] = { type ='value', },
       ["GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR"] = { type ='value', },
       ["GL_GPU_MEMORY_INFO_DEDICATED_VIDMEM_NVX"] = { type ='value', },
       ["GL_GPU_MEMORY_INFO_TOTAL_AVAILABLE_MEMORY_NVX"] = { type ='value', },
       ["GL_GPU_MEMORY_INFO_CURRENT_AVAILABLE_VIDMEM_NVX"] = { type ='value', },
       ["GL_GPU_MEMORY_INFO_EVICTION_COUNT_NVX"] = { type ='value', },
       ["GL_GPU_MEMORY_INFO_EVICTED_MEMORY_NVX"] = { type ='value', },
       ["GL_BLEND_PREMULTIPLIED_SRC_NV"] = { type ='value', },
       ["GL_BLEND_OVERLAP_NV"] = { type ='value', },
       ["GL_UNCORRELATED_NV"] = { type ='value', },
       ["GL_DISJOINT_NV"] = { type ='value', },
       ["GL_CONJOINT_NV"] = { type ='value', },
       ["GL_BLEND_ADVANCED_COHERENT_NV"] = { type ='value', },
       ["GL_SRC_NV"] = { type ='value', },
       ["GL_DST_NV"] = { type ='value', },
       ["GL_SRC_OVER_NV"] = { type ='value', },
       ["GL_DST_OVER_NV"] = { type ='value', },
       ["GL_SRC_IN_NV"] = { type ='value', },
       ["GL_DST_IN_NV"] = { type ='value', },
       ["GL_SRC_OUT_NV"] = { type ='value', },
       ["GL_DST_OUT_NV"] = { type ='value', },
       ["GL_SRC_ATOP_NV"] = { type ='value', },
       ["GL_DST_ATOP_NV"] = { type ='value', },
       ["GL_PLUS_NV"] = { type ='value', },
       ["GL_PLUS_DARKER_NV"] = { type ='value', },
       ["GL_MULTIPLY_NV"] = { type ='value', },
       ["GL_SCREEN_NV"] = { type ='value', },
       ["GL_OVERLAY_NV"] = { type ='value', },
       ["GL_DARKEN_NV"] = { type ='value', },
       ["GL_LIGHTEN_NV"] = { type ='value', },
       ["GL_COLORDODGE_NV"] = { type ='value', },
       ["GL_COLORBURN_NV"] = { type ='value', },
       ["GL_HARDLIGHT_NV"] = { type ='value', },
       ["GL_SOFTLIGHT_NV"] = { type ='value', },
       ["GL_DIFFERENCE_NV"] = { type ='value', },
       ["GL_MINUS_NV"] = { type ='value', },
       ["GL_EXCLUSION_NV"] = { type ='value', },
       ["GL_CONTRAST_NV"] = { type ='value', },
       ["GL_INVERT_RGB_NV"] = { type ='value', },
       ["GL_LINEARDODGE_NV"] = { type ='value', },
       ["GL_LINEARBURN_NV"] = { type ='value', },
       ["GL_VIVIDLIGHT_NV"] = { type ='value', },
       ["GL_LINEARLIGHT_NV"] = { type ='value', },
       ["GL_PINLIGHT_NV"] = { type ='value', },
       ["GL_HARDMIX_NV"] = { type ='value', },
       ["GL_HSL_HUE_NV"] = { type ='value', },
       ["GL_HSL_SATURATION_NV"] = { type ='value', },
       ["GL_HSL_COLOR_NV"] = { type ='value', },
       ["GL_HSL_LUMINOSITY_NV"] = { type ='value', },
       ["GL_PLUS_CLAMPED_NV"] = { type ='value', },
       ["GL_PLUS_CLAMPED_ALPHA_NV"] = { type ='value', },
       ["GL_MINUS_CLAMPED_NV"] = { type ='value', },
       ["GL_INVERT_OVG_NV"] = { type ='value', },
       ["GL_COMPUTE_PROGRAM_NV"] = { type ='value', },
       ["GL_COMPUTE_PROGRAM_PARAMETER_BUFFER_NV"] = { type ='value', },
       ["GL_DEPTH_STENCIL_TO_RGBA_NV"] = { type ='value', },
       ["GL_DEPTH_STENCIL_TO_BGRA_NV"] = { type ='value', },
       ["GL_MAX_DEEP_3D_TEXTURE_WIDTH_HEIGHT_NV"] = { type ='value', },
       ["GL_MAX_DEEP_3D_TEXTURE_DEPTH_NV"] = { type ='value', },
       ["GL_DEPTH_BUFFER_FLOAT_MODE_NV"] = { type ='value', },
       ["GL_SAMPLE_COUNT_BITS_NV"] = { type ='value', },
       ["GL_CURRENT_SAMPLE_COUNT_QUERY_NV"] = { type ='value', },
       ["GL_SAMPLE_COUNT_NV"] = { type ='value', },
       ["GL_EVAL_2D_NV"] = { type ='value', },
       ["GL_EVAL_TRIANGULAR_2D_NV"] = { type ='value', },
       ["GL_MAP_TESSELLATION_NV"] = { type ='value', },
       ["GL_MAP_ATTRIB_U_ORDER_NV"] = { type ='value', },
       ["GL_MAP_ATTRIB_V_ORDER_NV"] = { type ='value', },
       ["GL_EVAL_FRACTIONAL_TESSELLATION_NV"] = { type ='value', },
       ["GL_EVAL_VERTEX_ATTRIB0_NV"] = { type ='value', },
       ["GL_EVAL_VERTEX_ATTRIB1_NV"] = { type ='value', },
       ["GL_EVAL_VERTEX_ATTRIB2_NV"] = { type ='value', },
       ["GL_EVAL_VERTEX_ATTRIB3_NV"] = { type ='value', },
       ["GL_EVAL_VERTEX_ATTRIB4_NV"] = { type ='value', },
       ["GL_EVAL_VERTEX_ATTRIB5_NV"] = { type ='value', },
       ["GL_EVAL_VERTEX_ATTRIB6_NV"] = { type ='value', },
       ["GL_EVAL_VERTEX_ATTRIB7_NV"] = { type ='value', },
       ["GL_EVAL_VERTEX_ATTRIB8_NV"] = { type ='value', },
       ["GL_EVAL_VERTEX_ATTRIB9_NV"] = { type ='value', },
       ["GL_EVAL_VERTEX_ATTRIB10_NV"] = { type ='value', },
       ["GL_EVAL_VERTEX_ATTRIB11_NV"] = { type ='value', },
       ["GL_EVAL_VERTEX_ATTRIB12_NV"] = { type ='value', },
       ["GL_EVAL_VERTEX_ATTRIB13_NV"] = { type ='value', },
       ["GL_EVAL_VERTEX_ATTRIB14_NV"] = { type ='value', },
       ["GL_EVAL_VERTEX_ATTRIB15_NV"] = { type ='value', },
       ["GL_MAX_MAP_TESSELLATION_NV"] = { type ='value', },
       ["GL_MAX_RATIONAL_EVAL_ORDER_NV"] = { type ='value', },
       ["GL_TEXTURE_BINDING_RENDERBUFFER_NV"] = { type ='value', },
       ["GL_TEXTURE_RENDERBUFFER_DATA_STORE_BINDING_NV"] = { type ='value', },
       ["GL_TEXTURE_RENDERBUFFER_NV"] = { type ='value', },
       ["GL_SAMPLER_RENDERBUFFER_NV"] = { type ='value', },
       ["GL_INT_SAMPLER_RENDERBUFFER_NV"] = { type ='value', },
       ["GL_UNSIGNED_INT_SAMPLER_RENDERBUFFER_NV"] = { type ='value', },
       ["GL_ALL_COMPLETED_NV"] = { type ='value', },
       ["GL_FENCE_STATUS_NV"] = { type ='value', },
       ["GL_FENCE_CONDITION_NV"] = { type ='value', },
       ["GL_FLOAT_R_NV"] = { type ='value', },
       ["GL_FLOAT_RG_NV"] = { type ='value', },
       ["GL_FLOAT_RGB_NV"] = { type ='value', },
       ["GL_FLOAT_RGBA_NV"] = { type ='value', },
       ["GL_FLOAT_R16_NV"] = { type ='value', },
       ["GL_FLOAT_R32_NV"] = { type ='value', },
       ["GL_FLOAT_RG16_NV"] = { type ='value', },
       ["GL_FLOAT_RG32_NV"] = { type ='value', },
       ["GL_FLOAT_RGB16_NV"] = { type ='value', },
       ["GL_FLOAT_RGB32_NV"] = { type ='value', },
       ["GL_FLOAT_RGBA16_NV"] = { type ='value', },
       ["GL_FLOAT_RGBA32_NV"] = { type ='value', },
       ["GL_TEXTURE_FLOAT_COMPONENTS_NV"] = { type ='value', },
       ["GL_FLOAT_CLEAR_COLOR_VALUE_NV"] = { type ='value', },
       ["GL_FLOAT_RGBA_MODE_NV"] = { type ='value', },
       ["GL_FOG_DISTANCE_MODE_NV"] = { type ='value', },
       ["GL_EYE_RADIAL_NV"] = { type ='value', },
       ["GL_EYE_PLANE_ABSOLUTE_NV"] = { type ='value', },
       ["GL_MAX_FRAGMENT_PROGRAM_LOCAL_PARAMETERS_NV"] = { type ='value', },
       ["GL_FRAGMENT_PROGRAM_NV"] = { type ='value', },
       ["GL_FRAGMENT_PROGRAM_BINDING_NV"] = { type ='value', },
       ["GL_PROGRAM_ERROR_STRING_NV"] = { type ='value', },
       ["GL_MAX_PROGRAM_EXEC_INSTRUCTIONS_NV"] = { type ='value', },
       ["GL_MAX_PROGRAM_CALL_DEPTH_NV"] = { type ='value', },
       ["GL_MAX_PROGRAM_IF_DEPTH_NV"] = { type ='value', },
       ["GL_MAX_PROGRAM_LOOP_DEPTH_NV"] = { type ='value', },
       ["GL_MAX_PROGRAM_LOOP_COUNT_NV"] = { type ='value', },
       ["GL_RENDERBUFFER_COVERAGE_SAMPLES_NV"] = { type ='value', },
       ["GL_RENDERBUFFER_COLOR_SAMPLES_NV"] = { type ='value', },
       ["GL_MAX_MULTISAMPLE_COVERAGE_MODES_NV"] = { type ='value', },
       ["GL_MULTISAMPLE_COVERAGE_MODES_NV"] = { type ='value', },
       ["GL_GEOMETRY_PROGRAM_NV"] = { type ='value', },
       ["GL_MAX_PROGRAM_OUTPUT_VERTICES_NV"] = { type ='value', },
       ["GL_MAX_PROGRAM_TOTAL_OUTPUT_COMPONENTS_NV"] = { type ='value', },
       ["GL_PROGRAM_ATTRIB_COMPONENTS_NV"] = { type ='value', },
       ["GL_PROGRAM_RESULT_COMPONENTS_NV"] = { type ='value', },
       ["GL_MAX_PROGRAM_ATTRIB_COMPONENTS_NV"] = { type ='value', },
       ["GL_MAX_PROGRAM_RESULT_COMPONENTS_NV"] = { type ='value', },
       ["GL_MAX_PROGRAM_GENERIC_ATTRIBS_NV"] = { type ='value', },
       ["GL_MAX_PROGRAM_GENERIC_RESULTS_NV"] = { type ='value', },
       ["GL_MAX_GEOMETRY_PROGRAM_INVOCATIONS_NV"] = { type ='value', },
       ["GL_FRAGMENT_PROGRAM_INTERPOLATION_OFFSET_BITS_NV"] = { type ='value', },
       ["GL_INT64_NV"] = { type ='value', },
       ["GL_UNSIGNED_INT64_NV"] = { type ='value', },
       ["GL_INT8_NV"] = { type ='value', },
       ["GL_INT8_VEC2_NV"] = { type ='value', },
       ["GL_INT8_VEC3_NV"] = { type ='value', },
       ["GL_INT8_VEC4_NV"] = { type ='value', },
       ["GL_INT16_NV"] = { type ='value', },
       ["GL_INT16_VEC2_NV"] = { type ='value', },
       ["GL_INT16_VEC3_NV"] = { type ='value', },
       ["GL_INT16_VEC4_NV"] = { type ='value', },
       ["GL_INT64_VEC2_NV"] = { type ='value', },
       ["GL_INT64_VEC3_NV"] = { type ='value', },
       ["GL_INT64_VEC4_NV"] = { type ='value', },
       ["GL_UNSIGNED_INT8_NV"] = { type ='value', },
       ["GL_UNSIGNED_INT8_VEC2_NV"] = { type ='value', },
       ["GL_UNSIGNED_INT8_VEC3_NV"] = { type ='value', },
       ["GL_UNSIGNED_INT8_VEC4_NV"] = { type ='value', },
       ["GL_UNSIGNED_INT16_NV"] = { type ='value', },
       ["GL_UNSIGNED_INT16_VEC2_NV"] = { type ='value', },
       ["GL_UNSIGNED_INT16_VEC3_NV"] = { type ='value', },
       ["GL_UNSIGNED_INT16_VEC4_NV"] = { type ='value', },
       ["GL_UNSIGNED_INT64_VEC2_NV"] = { type ='value', },
       ["GL_UNSIGNED_INT64_VEC3_NV"] = { type ='value', },
       ["GL_UNSIGNED_INT64_VEC4_NV"] = { type ='value', },
       ["GL_FLOAT16_NV"] = { type ='value', },
       ["GL_FLOAT16_VEC2_NV"] = { type ='value', },
       ["GL_FLOAT16_VEC3_NV"] = { type ='value', },
       ["GL_FLOAT16_VEC4_NV"] = { type ='value', },
       ["GL_MAX_SHININESS_NV"] = { type ='value', },
       ["GL_MAX_SPOT_EXPONENT_NV"] = { type ='value', },
       ["GL_COLOR_SAMPLES_NV"] = { type ='value', },
       ["GL_MULTISAMPLE_FILTER_HINT_NV"] = { type ='value', },
       ["GL_PIXEL_COUNTER_BITS_NV"] = { type ='value', },
       ["GL_CURRENT_OCCLUSION_QUERY_ID_NV"] = { type ='value', },
       ["GL_PIXEL_COUNT_NV"] = { type ='value', },
       ["GL_PIXEL_COUNT_AVAILABLE_NV"] = { type ='value', },
       ["GL_MAX_PROGRAM_PARAMETER_BUFFER_BINDINGS_NV"] = { type ='value', },
       ["GL_MAX_PROGRAM_PARAMETER_BUFFER_SIZE_NV"] = { type ='value', },
       ["GL_VERTEX_PROGRAM_PARAMETER_BUFFER_NV"] = { type ='value', },
       ["GL_GEOMETRY_PROGRAM_PARAMETER_BUFFER_NV"] = { type ='value', },
       ["GL_FRAGMENT_PROGRAM_PARAMETER_BUFFER_NV"] = { type ='value', },
       ["GL_CLOSE_PATH_NV"] = { type ='value', },
       ["GL_BOLD_BIT_NV"] = { type ='value', },
       ["GL_GLYPH_WIDTH_BIT_NV"] = { type ='value', },
       ["GL_GLYPH_HEIGHT_BIT_NV"] = { type ='value', },
       ["GL_ITALIC_BIT_NV"] = { type ='value', },
       ["GL_MOVE_TO_NV"] = { type ='value', },
       ["GL_RELATIVE_MOVE_TO_NV"] = { type ='value', },
       ["GL_LINE_TO_NV"] = { type ='value', },
       ["GL_GLYPH_HORIZONTAL_BEARING_X_BIT_NV"] = { type ='value', },
       ["GL_RELATIVE_LINE_TO_NV"] = { type ='value', },
       ["GL_HORIZONTAL_LINE_TO_NV"] = { type ='value', },
       ["GL_RELATIVE_HORIZONTAL_LINE_TO_NV"] = { type ='value', },
       ["GL_GLYPH_HORIZONTAL_BEARING_Y_BIT_NV"] = { type ='value', },
       ["GL_VERTICAL_LINE_TO_NV"] = { type ='value', },
       ["GL_RELATIVE_VERTICAL_LINE_TO_NV"] = { type ='value', },
       ["GL_QUADRATIC_CURVE_TO_NV"] = { type ='value', },
       ["GL_RELATIVE_QUADRATIC_CURVE_TO_NV"] = { type ='value', },
       ["GL_CUBIC_CURVE_TO_NV"] = { type ='value', },
       ["GL_RELATIVE_CUBIC_CURVE_TO_NV"] = { type ='value', },
       ["GL_SMOOTH_QUADRATIC_CURVE_TO_NV"] = { type ='value', },
       ["GL_RELATIVE_SMOOTH_QUADRATIC_CURVE_TO_NV"] = { type ='value', },
       ["GL_GLYPH_HORIZONTAL_BEARING_ADVANCE_BIT_NV"] = { type ='value', },
       ["GL_SMOOTH_CUBIC_CURVE_TO_NV"] = { type ='value', },
       ["GL_RELATIVE_SMOOTH_CUBIC_CURVE_TO_NV"] = { type ='value', },
       ["GL_SMALL_CCW_ARC_TO_NV"] = { type ='value', },
       ["GL_RELATIVE_SMALL_CCW_ARC_TO_NV"] = { type ='value', },
       ["GL_SMALL_CW_ARC_TO_NV"] = { type ='value', },
       ["GL_RELATIVE_SMALL_CW_ARC_TO_NV"] = { type ='value', },
       ["GL_LARGE_CCW_ARC_TO_NV"] = { type ='value', },
       ["GL_RELATIVE_LARGE_CCW_ARC_TO_NV"] = { type ='value', },
       ["GL_LARGE_CW_ARC_TO_NV"] = { type ='value', },
       ["GL_RELATIVE_LARGE_CW_ARC_TO_NV"] = { type ='value', },
       ["GL_GLYPH_VERTICAL_BEARING_X_BIT_NV"] = { type ='value', },
       ["GL_GLYPH_VERTICAL_BEARING_Y_BIT_NV"] = { type ='value', },
       ["GL_GLYPH_VERTICAL_BEARING_ADVANCE_BIT_NV"] = { type ='value', },
       ["GL_RESTART_PATH_NV"] = { type ='value', },
       ["GL_DUP_FIRST_CUBIC_CURVE_TO_NV"] = { type ='value', },
       ["GL_DUP_LAST_CUBIC_CURVE_TO_NV"] = { type ='value', },
       ["GL_RECT_NV"] = { type ='value', },
       ["GL_CIRCULAR_CCW_ARC_TO_NV"] = { type ='value', },
       ["GL_CIRCULAR_CW_ARC_TO_NV"] = { type ='value', },
       ["GL_CIRCULAR_TANGENT_ARC_TO_NV"] = { type ='value', },
       ["GL_ARC_TO_NV"] = { type ='value', },
       ["GL_RELATIVE_ARC_TO_NV"] = { type ='value', },
       ["GL_GLYPH_HAS_KERNING_BIT_NV"] = { type ='value', },
       ["GL_PATH_FORMAT_SVG_NV"] = { type ='value', },
       ["GL_PATH_FORMAT_PS_NV"] = { type ='value', },
       ["GL_STANDARD_FONT_NAME_NV"] = { type ='value', },
       ["GL_SYSTEM_FONT_NAME_NV"] = { type ='value', },
       ["GL_FILE_NAME_NV"] = { type ='value', },
       ["GL_PATH_STROKE_WIDTH_NV"] = { type ='value', },
       ["GL_PATH_END_CAPS_NV"] = { type ='value', },
       ["GL_PATH_INITIAL_END_CAP_NV"] = { type ='value', },
       ["GL_PATH_TERMINAL_END_CAP_NV"] = { type ='value', },
       ["GL_PATH_JOIN_STYLE_NV"] = { type ='value', },
       ["GL_PATH_MITER_LIMIT_NV"] = { type ='value', },
       ["GL_PATH_DASH_CAPS_NV"] = { type ='value', },
       ["GL_PATH_INITIAL_DASH_CAP_NV"] = { type ='value', },
       ["GL_PATH_TERMINAL_DASH_CAP_NV"] = { type ='value', },
       ["GL_PATH_DASH_OFFSET_NV"] = { type ='value', },
       ["GL_PATH_CLIENT_LENGTH_NV"] = { type ='value', },
       ["GL_PATH_FILL_MODE_NV"] = { type ='value', },
       ["GL_PATH_FILL_MASK_NV"] = { type ='value', },
       ["GL_PATH_FILL_COVER_MODE_NV"] = { type ='value', },
       ["GL_PATH_STROKE_COVER_MODE_NV"] = { type ='value', },
       ["GL_PATH_STROKE_MASK_NV"] = { type ='value', },
       ["GL_COUNT_UP_NV"] = { type ='value', },
       ["GL_COUNT_DOWN_NV"] = { type ='value', },
       ["GL_PATH_OBJECT_BOUNDING_BOX_NV"] = { type ='value', },
       ["GL_CONVEX_HULL_NV"] = { type ='value', },
       ["GL_BOUNDING_BOX_NV"] = { type ='value', },
       ["GL_TRANSLATE_X_NV"] = { type ='value', },
       ["GL_TRANSLATE_Y_NV"] = { type ='value', },
       ["GL_TRANSLATE_2D_NV"] = { type ='value', },
       ["GL_TRANSLATE_3D_NV"] = { type ='value', },
       ["GL_AFFINE_2D_NV"] = { type ='value', },
       ["GL_AFFINE_3D_NV"] = { type ='value', },
       ["GL_TRANSPOSE_AFFINE_2D_NV"] = { type ='value', },
       ["GL_TRANSPOSE_AFFINE_3D_NV"] = { type ='value', },
       ["GL_UTF8_NV"] = { type ='value', },
       ["GL_UTF16_NV"] = { type ='value', },
       ["GL_BOUNDING_BOX_OF_BOUNDING_BOXES_NV"] = { type ='value', },
       ["GL_PATH_COMMAND_COUNT_NV"] = { type ='value', },
       ["GL_PATH_COORD_COUNT_NV"] = { type ='value', },
       ["GL_PATH_DASH_ARRAY_COUNT_NV"] = { type ='value', },
       ["GL_PATH_COMPUTED_LENGTH_NV"] = { type ='value', },
       ["GL_PATH_FILL_BOUNDING_BOX_NV"] = { type ='value', },
       ["GL_PATH_STROKE_BOUNDING_BOX_NV"] = { type ='value', },
       ["GL_SQUARE_NV"] = { type ='value', },
       ["GL_ROUND_NV"] = { type ='value', },
       ["GL_TRIANGULAR_NV"] = { type ='value', },
       ["GL_BEVEL_NV"] = { type ='value', },
       ["GL_MITER_REVERT_NV"] = { type ='value', },
       ["GL_MITER_TRUNCATE_NV"] = { type ='value', },
       ["GL_SKIP_MISSING_GLYPH_NV"] = { type ='value', },
       ["GL_USE_MISSING_GLYPH_NV"] = { type ='value', },
       ["GL_PATH_ERROR_POSITION_NV"] = { type ='value', },
       ["GL_PATH_FOG_GEN_MODE_NV"] = { type ='value', },
       ["GL_ACCUM_ADJACENT_PAIRS_NV"] = { type ='value', },
       ["GL_ADJACENT_PAIRS_NV"] = { type ='value', },
       ["GL_FIRST_TO_REST_NV"] = { type ='value', },
       ["GL_PATH_GEN_MODE_NV"] = { type ='value', },
       ["GL_PATH_GEN_COEFF_NV"] = { type ='value', },
       ["GL_PATH_GEN_COLOR_FORMAT_NV"] = { type ='value', },
       ["GL_PATH_GEN_COMPONENTS_NV"] = { type ='value', },
       ["GL_PATH_DASH_OFFSET_RESET_NV"] = { type ='value', },
       ["GL_MOVE_TO_RESETS_NV"] = { type ='value', },
       ["GL_MOVE_TO_CONTINUES_NV"] = { type ='value', },
       ["GL_PATH_STENCIL_FUNC_NV"] = { type ='value', },
       ["GL_PATH_STENCIL_REF_NV"] = { type ='value', },
       ["GL_PATH_STENCIL_VALUE_MASK_NV"] = { type ='value', },
       ["GL_PATH_STENCIL_DEPTH_OFFSET_FACTOR_NV"] = { type ='value', },
       ["GL_PATH_STENCIL_DEPTH_OFFSET_UNITS_NV"] = { type ='value', },
       ["GL_PATH_COVER_DEPTH_FUNC_NV"] = { type ='value', },
       ["GL_FONT_X_MIN_BOUNDS_BIT_NV"] = { type ='value', },
       ["GL_FONT_Y_MIN_BOUNDS_BIT_NV"] = { type ='value', },
       ["GL_FONT_X_MAX_BOUNDS_BIT_NV"] = { type ='value', },
       ["GL_FONT_Y_MAX_BOUNDS_BIT_NV"] = { type ='value', },
       ["GL_FONT_UNITS_PER_EM_BIT_NV"] = { type ='value', },
       ["GL_FONT_ASCENDER_BIT_NV"] = { type ='value', },
       ["GL_FONT_DESCENDER_BIT_NV"] = { type ='value', },
       ["GL_FONT_HEIGHT_BIT_NV"] = { type ='value', },
       ["GL_FONT_MAX_ADVANCE_WIDTH_BIT_NV"] = { type ='value', },
       ["GL_FONT_MAX_ADVANCE_HEIGHT_BIT_NV"] = { type ='value', },
       ["GL_FONT_UNDERLINE_POSITION_BIT_NV"] = { type ='value', },
       ["GL_FONT_UNDERLINE_THICKNESS_BIT_NV"] = { type ='value', },
       ["GL_FONT_HAS_KERNING_BIT_NV"] = { type ='value', },
       ["GL_WRITE_PIXEL_DATA_RANGE_NV"] = { type ='value', },
       ["GL_READ_PIXEL_DATA_RANGE_NV"] = { type ='value', },
       ["GL_WRITE_PIXEL_DATA_RANGE_LENGTH_NV"] = { type ='value', },
       ["GL_READ_PIXEL_DATA_RANGE_LENGTH_NV"] = { type ='value', },
       ["GL_WRITE_PIXEL_DATA_RANGE_POINTER_NV"] = { type ='value', },
       ["GL_READ_PIXEL_DATA_RANGE_POINTER_NV"] = { type ='value', },
       ["GL_POINT_SPRITE_R_MODE_NV"] = { type ='value', },
       ["GL_FRAME_NV"] = { type ='value', },
       ["GL_FIELDS_NV"] = { type ='value', },
       ["GL_CURRENT_TIME_NV"] = { type ='value', },
       ["GL_NUM_FILL_STREAMS_NV"] = { type ='value', },
       ["GL_PRESENT_TIME_NV"] = { type ='value', },
       ["GL_PRESENT_DURATION_NV"] = { type ='value', },
       ["GL_REGISTER_COMBINERS_NV"] = { type ='value', },
       ["GL_VARIABLE_A_NV"] = { type ='value', },
       ["GL_VARIABLE_B_NV"] = { type ='value', },
       ["GL_VARIABLE_C_NV"] = { type ='value', },
       ["GL_VARIABLE_D_NV"] = { type ='value', },
       ["GL_VARIABLE_E_NV"] = { type ='value', },
       ["GL_VARIABLE_F_NV"] = { type ='value', },
       ["GL_VARIABLE_G_NV"] = { type ='value', },
       ["GL_CONSTANT_COLOR0_NV"] = { type ='value', },
       ["GL_CONSTANT_COLOR1_NV"] = { type ='value', },
       ["GL_SECONDARY_COLOR_NV"] = { type ='value', },
       ["GL_SPARE0_NV"] = { type ='value', },
       ["GL_SPARE1_NV"] = { type ='value', },
       ["GL_DISCARD_NV"] = { type ='value', },
       ["GL_E_TIMES_F_NV"] = { type ='value', },
       ["GL_SPARE0_PLUS_SECONDARY_COLOR_NV"] = { type ='value', },
       ["GL_UNSIGNED_IDENTITY_NV"] = { type ='value', },
       ["GL_UNSIGNED_INVERT_NV"] = { type ='value', },
       ["GL_EXPAND_NORMAL_NV"] = { type ='value', },
       ["GL_EXPAND_NEGATE_NV"] = { type ='value', },
       ["GL_HALF_BIAS_NORMAL_NV"] = { type ='value', },
       ["GL_HALF_BIAS_NEGATE_NV"] = { type ='value', },
       ["GL_SIGNED_IDENTITY_NV"] = { type ='value', },
       ["GL_SIGNED_NEGATE_NV"] = { type ='value', },
       ["GL_SCALE_BY_TWO_NV"] = { type ='value', },
       ["GL_SCALE_BY_FOUR_NV"] = { type ='value', },
       ["GL_SCALE_BY_ONE_HALF_NV"] = { type ='value', },
       ["GL_BIAS_BY_NEGATIVE_ONE_HALF_NV"] = { type ='value', },
       ["GL_COMBINER_INPUT_NV"] = { type ='value', },
       ["GL_COMBINER_MAPPING_NV"] = { type ='value', },
       ["GL_COMBINER_COMPONENT_USAGE_NV"] = { type ='value', },
       ["GL_COMBINER_AB_DOT_PRODUCT_NV"] = { type ='value', },
       ["GL_COMBINER_CD_DOT_PRODUCT_NV"] = { type ='value', },
       ["GL_COMBINER_MUX_SUM_NV"] = { type ='value', },
       ["GL_COMBINER_SCALE_NV"] = { type ='value', },
       ["GL_COMBINER_BIAS_NV"] = { type ='value', },
       ["GL_COMBINER_AB_OUTPUT_NV"] = { type ='value', },
       ["GL_COMBINER_CD_OUTPUT_NV"] = { type ='value', },
       ["GL_COMBINER_SUM_OUTPUT_NV"] = { type ='value', },
       ["GL_MAX_GENERAL_COMBINERS_NV"] = { type ='value', },
       ["GL_NUM_GENERAL_COMBINERS_NV"] = { type ='value', },
       ["GL_COLOR_SUM_CLAMP_NV"] = { type ='value', },
       ["GL_COMBINER0_NV"] = { type ='value', },
       ["GL_COMBINER1_NV"] = { type ='value', },
       ["GL_COMBINER2_NV"] = { type ='value', },
       ["GL_COMBINER3_NV"] = { type ='value', },
       ["GL_COMBINER4_NV"] = { type ='value', },
       ["GL_COMBINER5_NV"] = { type ='value', },
       ["GL_COMBINER6_NV"] = { type ='value', },
       ["GL_COMBINER7_NV"] = { type ='value', },
       ["GL_PER_STAGE_CONSTANTS_NV"] = { type ='value', },
       ["GL_BUFFER_GPU_ADDRESS_NV"] = { type ='value', },
       ["GL_GPU_ADDRESS_NV"] = { type ='value', },
       ["GL_MAX_SHADER_BUFFER_ADDRESS_NV"] = { type ='value', },
       ["GL_MAX_PROGRAM_PATCH_ATTRIBS_NV"] = { type ='value', },
       ["GL_TESS_CONTROL_PROGRAM_NV"] = { type ='value', },
       ["GL_TESS_EVALUATION_PROGRAM_NV"] = { type ='value', },
       ["GL_TESS_CONTROL_PROGRAM_PARAMETER_BUFFER_NV"] = { type ='value', },
       ["GL_TESS_EVALUATION_PROGRAM_PARAMETER_BUFFER_NV"] = { type ='value', },
       ["GL_EMBOSS_LIGHT_NV"] = { type ='value', },
       ["GL_EMBOSS_CONSTANT_NV"] = { type ='value', },
       ["GL_EMBOSS_MAP_NV"] = { type ='value', },
       ["GL_COMBINE4_NV"] = { type ='value', },
       ["GL_SOURCE3_RGB_NV"] = { type ='value', },
       ["GL_SOURCE3_ALPHA_NV"] = { type ='value', },
       ["GL_OPERAND3_RGB_NV"] = { type ='value', },
       ["GL_OPERAND3_ALPHA_NV"] = { type ='value', },
       ["GL_TEXTURE_UNSIGNED_REMAP_MODE_NV"] = { type ='value', },
       ["GL_TEXTURE_COVERAGE_SAMPLES_NV"] = { type ='value', },
       ["GL_TEXTURE_COLOR_SAMPLES_NV"] = { type ='value', },
       ["GL_OFFSET_TEXTURE_RECTANGLE_NV"] = { type ='value', },
       ["GL_OFFSET_TEXTURE_RECTANGLE_SCALE_NV"] = { type ='value', },
       ["GL_DOT_PRODUCT_TEXTURE_RECTANGLE_NV"] = { type ='value', },
       ["GL_RGBA_UNSIGNED_DOT_PRODUCT_MAPPING_NV"] = { type ='value', },
       ["GL_UNSIGNED_INT_S8_S8_8_8_NV"] = { type ='value', },
       ["GL_UNSIGNED_INT_8_8_S8_S8_REV_NV"] = { type ='value', },
       ["GL_DSDT_MAG_INTENSITY_NV"] = { type ='value', },
       ["GL_SHADER_CONSISTENT_NV"] = { type ='value', },
       ["GL_TEXTURE_SHADER_NV"] = { type ='value', },
       ["GL_SHADER_OPERATION_NV"] = { type ='value', },
       ["GL_CULL_MODES_NV"] = { type ='value', },
       ["GL_OFFSET_TEXTURE_2D_MATRIX_NV"] = { type ='value', },
       ["GL_OFFSET_TEXTURE_MATRIX_NV"] = { type ='value', },
       ["GL_OFFSET_TEXTURE_2D_SCALE_NV"] = { type ='value', },
       ["GL_OFFSET_TEXTURE_SCALE_NV"] = { type ='value', },
       ["GL_OFFSET_TEXTURE_BIAS_NV"] = { type ='value', },
       ["GL_OFFSET_TEXTURE_2D_BIAS_NV"] = { type ='value', },
       ["GL_PREVIOUS_TEXTURE_INPUT_NV"] = { type ='value', },
       ["GL_CONST_EYE_NV"] = { type ='value', },
       ["GL_PASS_THROUGH_NV"] = { type ='value', },
       ["GL_CULL_FRAGMENT_NV"] = { type ='value', },
       ["GL_OFFSET_TEXTURE_2D_NV"] = { type ='value', },
       ["GL_DEPENDENT_AR_TEXTURE_2D_NV"] = { type ='value', },
       ["GL_DEPENDENT_GB_TEXTURE_2D_NV"] = { type ='value', },
       ["GL_DOT_PRODUCT_NV"] = { type ='value', },
       ["GL_DOT_PRODUCT_DEPTH_REPLACE_NV"] = { type ='value', },
       ["GL_DOT_PRODUCT_TEXTURE_2D_NV"] = { type ='value', },
       ["GL_DOT_PRODUCT_TEXTURE_CUBE_MAP_NV"] = { type ='value', },
       ["GL_DOT_PRODUCT_DIFFUSE_CUBE_MAP_NV"] = { type ='value', },
       ["GL_DOT_PRODUCT_REFLECT_CUBE_MAP_NV"] = { type ='value', },
       ["GL_DOT_PRODUCT_CONST_EYE_REFLECT_CUBE_MAP_NV"] = { type ='value', },
       ["GL_HILO_NV"] = { type ='value', },
       ["GL_DSDT_NV"] = { type ='value', },
       ["GL_DSDT_MAG_NV"] = { type ='value', },
       ["GL_DSDT_MAG_VIB_NV"] = { type ='value', },
       ["GL_HILO16_NV"] = { type ='value', },
       ["GL_SIGNED_HILO_NV"] = { type ='value', },
       ["GL_SIGNED_HILO16_NV"] = { type ='value', },
       ["GL_SIGNED_RGBA_NV"] = { type ='value', },
       ["GL_SIGNED_RGBA8_NV"] = { type ='value', },
       ["GL_SIGNED_RGB_NV"] = { type ='value', },
       ["GL_SIGNED_RGB8_NV"] = { type ='value', },
       ["GL_SIGNED_LUMINANCE_NV"] = { type ='value', },
       ["GL_SIGNED_LUMINANCE8_NV"] = { type ='value', },
       ["GL_SIGNED_LUMINANCE_ALPHA_NV"] = { type ='value', },
       ["GL_SIGNED_LUMINANCE8_ALPHA8_NV"] = { type ='value', },
       ["GL_SIGNED_ALPHA_NV"] = { type ='value', },
       ["GL_SIGNED_ALPHA8_NV"] = { type ='value', },
       ["GL_SIGNED_INTENSITY_NV"] = { type ='value', },
       ["GL_SIGNED_INTENSITY8_NV"] = { type ='value', },
       ["GL_DSDT8_NV"] = { type ='value', },
       ["GL_DSDT8_MAG8_NV"] = { type ='value', },
       ["GL_DSDT8_MAG8_INTENSITY8_NV"] = { type ='value', },
       ["GL_SIGNED_RGB_UNSIGNED_ALPHA_NV"] = { type ='value', },
       ["GL_SIGNED_RGB8_UNSIGNED_ALPHA8_NV"] = { type ='value', },
       ["GL_HI_SCALE_NV"] = { type ='value', },
       ["GL_LO_SCALE_NV"] = { type ='value', },
       ["GL_DS_SCALE_NV"] = { type ='value', },
       ["GL_DT_SCALE_NV"] = { type ='value', },
       ["GL_MAGNITUDE_SCALE_NV"] = { type ='value', },
       ["GL_VIBRANCE_SCALE_NV"] = { type ='value', },
       ["GL_HI_BIAS_NV"] = { type ='value', },
       ["GL_LO_BIAS_NV"] = { type ='value', },
       ["GL_DS_BIAS_NV"] = { type ='value', },
       ["GL_DT_BIAS_NV"] = { type ='value', },
       ["GL_MAGNITUDE_BIAS_NV"] = { type ='value', },
       ["GL_VIBRANCE_BIAS_NV"] = { type ='value', },
       ["GL_TEXTURE_BORDER_VALUES_NV"] = { type ='value', },
       ["GL_TEXTURE_HI_SIZE_NV"] = { type ='value', },
       ["GL_TEXTURE_LO_SIZE_NV"] = { type ='value', },
       ["GL_TEXTURE_DS_SIZE_NV"] = { type ='value', },
       ["GL_TEXTURE_DT_SIZE_NV"] = { type ='value', },
       ["GL_TEXTURE_MAG_SIZE_NV"] = { type ='value', },
       ["GL_DOT_PRODUCT_TEXTURE_3D_NV"] = { type ='value', },
       ["GL_OFFSET_PROJECTIVE_TEXTURE_2D_NV"] = { type ='value', },
       ["GL_OFFSET_PROJECTIVE_TEXTURE_2D_SCALE_NV"] = { type ='value', },
       ["GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_NV"] = { type ='value', },
       ["GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_SCALE_NV"] = { type ='value', },
       ["GL_OFFSET_HILO_TEXTURE_2D_NV"] = { type ='value', },
       ["GL_OFFSET_HILO_TEXTURE_RECTANGLE_NV"] = { type ='value', },
       ["GL_OFFSET_HILO_PROJECTIVE_TEXTURE_2D_NV"] = { type ='value', },
       ["GL_OFFSET_HILO_PROJECTIVE_TEXTURE_RECTANGLE_NV"] = { type ='value', },
       ["GL_DEPENDENT_HILO_TEXTURE_2D_NV"] = { type ='value', },
       ["GL_DEPENDENT_RGB_TEXTURE_3D_NV"] = { type ='value', },
       ["GL_DEPENDENT_RGB_TEXTURE_CUBE_MAP_NV"] = { type ='value', },
       ["GL_DOT_PRODUCT_PASS_THROUGH_NV"] = { type ='value', },
       ["GL_DOT_PRODUCT_TEXTURE_1D_NV"] = { type ='value', },
       ["GL_DOT_PRODUCT_AFFINE_DEPTH_REPLACE_NV"] = { type ='value', },
       ["GL_HILO8_NV"] = { type ='value', },
       ["GL_SIGNED_HILO8_NV"] = { type ='value', },
       ["GL_FORCE_BLUE_TO_ONE_NV"] = { type ='value', },
       ["GL_BACK_PRIMARY_COLOR_NV"] = { type ='value', },
       ["GL_BACK_SECONDARY_COLOR_NV"] = { type ='value', },
       ["GL_TEXTURE_COORD_NV"] = { type ='value', },
       ["GL_CLIP_DISTANCE_NV"] = { type ='value', },
       ["GL_VERTEX_ID_NV"] = { type ='value', },
       ["GL_PRIMITIVE_ID_NV"] = { type ='value', },
       ["GL_GENERIC_ATTRIB_NV"] = { type ='value', },
       ["GL_TRANSFORM_FEEDBACK_ATTRIBS_NV"] = { type ='value', },
       ["GL_ACTIVE_VARYINGS_NV"] = { type ='value', },
       ["GL_ACTIVE_VARYING_MAX_LENGTH_NV"] = { type ='value', },
       ["GL_TRANSFORM_FEEDBACK_RECORD_NV"] = { type ='value', },
       ["GL_SURFACE_STATE_NV"] = { type ='value', },
       ["GL_SURFACE_REGISTERED_NV"] = { type ='value', },
       ["GL_SURFACE_MAPPED_NV"] = { type ='value', },
       ["GL_WRITE_DISCARD_NV"] = { type ='value', },
       ["GL_VERTEX_ARRAY_RANGE_NV"] = { type ='value', },
       ["GL_VERTEX_ARRAY_RANGE_LENGTH_NV"] = { type ='value', },
       ["GL_VERTEX_ARRAY_RANGE_VALID_NV"] = { type ='value', },
       ["GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_NV"] = { type ='value', },
       ["GL_VERTEX_ARRAY_RANGE_POINTER_NV"] = { type ='value', },
       ["GL_VERTEX_ARRAY_RANGE_WITHOUT_FLUSH_NV"] = { type ='value', },
       ["GL_VERTEX_ATTRIB_ARRAY_UNIFIED_NV"] = { type ='value', },
       ["GL_ELEMENT_ARRAY_UNIFIED_NV"] = { type ='value', },
       ["GL_VERTEX_ATTRIB_ARRAY_ADDRESS_NV"] = { type ='value', },
       ["GL_VERTEX_ARRAY_ADDRESS_NV"] = { type ='value', },
       ["GL_NORMAL_ARRAY_ADDRESS_NV"] = { type ='value', },
       ["GL_COLOR_ARRAY_ADDRESS_NV"] = { type ='value', },
       ["GL_INDEX_ARRAY_ADDRESS_NV"] = { type ='value', },
       ["GL_TEXTURE_COORD_ARRAY_ADDRESS_NV"] = { type ='value', },
       ["GL_EDGE_FLAG_ARRAY_ADDRESS_NV"] = { type ='value', },
       ["GL_SECONDARY_COLOR_ARRAY_ADDRESS_NV"] = { type ='value', },
       ["GL_FOG_COORD_ARRAY_ADDRESS_NV"] = { type ='value', },
       ["GL_ELEMENT_ARRAY_ADDRESS_NV"] = { type ='value', },
       ["GL_VERTEX_ATTRIB_ARRAY_LENGTH_NV"] = { type ='value', },
       ["GL_VERTEX_ARRAY_LENGTH_NV"] = { type ='value', },
       ["GL_NORMAL_ARRAY_LENGTH_NV"] = { type ='value', },
       ["GL_COLOR_ARRAY_LENGTH_NV"] = { type ='value', },
       ["GL_INDEX_ARRAY_LENGTH_NV"] = { type ='value', },
       ["GL_TEXTURE_COORD_ARRAY_LENGTH_NV"] = { type ='value', },
       ["GL_EDGE_FLAG_ARRAY_LENGTH_NV"] = { type ='value', },
       ["GL_SECONDARY_COLOR_ARRAY_LENGTH_NV"] = { type ='value', },
       ["GL_FOG_COORD_ARRAY_LENGTH_NV"] = { type ='value', },
       ["GL_ELEMENT_ARRAY_LENGTH_NV"] = { type ='value', },
       ["GL_DRAW_INDIRECT_UNIFIED_NV"] = { type ='value', },
       ["GL_DRAW_INDIRECT_ADDRESS_NV"] = { type ='value', },
       ["GL_DRAW_INDIRECT_LENGTH_NV"] = { type ='value', },
       ["GL_VERTEX_PROGRAM_NV"] = { type ='value', },
       ["GL_VERTEX_STATE_PROGRAM_NV"] = { type ='value', },
       ["GL_ATTRIB_ARRAY_SIZE_NV"] = { type ='value', },
       ["GL_ATTRIB_ARRAY_STRIDE_NV"] = { type ='value', },
       ["GL_ATTRIB_ARRAY_TYPE_NV"] = { type ='value', },
       ["GL_CURRENT_ATTRIB_NV"] = { type ='value', },
       ["GL_PROGRAM_LENGTH_NV"] = { type ='value', },
       ["GL_PROGRAM_STRING_NV"] = { type ='value', },
       ["GL_MODELVIEW_PROJECTION_NV"] = { type ='value', },
       ["GL_IDENTITY_NV"] = { type ='value', },
       ["GL_INVERSE_NV"] = { type ='value', },
       ["GL_TRANSPOSE_NV"] = { type ='value', },
       ["GL_INVERSE_TRANSPOSE_NV"] = { type ='value', },
       ["GL_MAX_TRACK_MATRIX_STACK_DEPTH_NV"] = { type ='value', },
       ["GL_MAX_TRACK_MATRICES_NV"] = { type ='value', },
       ["GL_MATRIX0_NV"] = { type ='value', },
       ["GL_MATRIX1_NV"] = { type ='value', },
       ["GL_MATRIX2_NV"] = { type ='value', },
       ["GL_MATRIX3_NV"] = { type ='value', },
       ["GL_MATRIX4_NV"] = { type ='value', },
       ["GL_MATRIX5_NV"] = { type ='value', },
       ["GL_MATRIX6_NV"] = { type ='value', },
       ["GL_MATRIX7_NV"] = { type ='value', },
       ["GL_CURRENT_MATRIX_STACK_DEPTH_NV"] = { type ='value', },
       ["GL_CURRENT_MATRIX_NV"] = { type ='value', },
       ["GL_PROGRAM_PARAMETER_NV"] = { type ='value', },
       ["GL_ATTRIB_ARRAY_POINTER_NV"] = { type ='value', },
       ["GL_PROGRAM_TARGET_NV"] = { type ='value', },
       ["GL_PROGRAM_RESIDENT_NV"] = { type ='value', },
       ["GL_TRACK_MATRIX_NV"] = { type ='value', },
       ["GL_TRACK_MATRIX_TRANSFORM_NV"] = { type ='value', },
       ["GL_VERTEX_PROGRAM_BINDING_NV"] = { type ='value', },
       ["GL_PROGRAM_ERROR_POSITION_NV"] = { type ='value', },
       ["GL_VERTEX_ATTRIB_ARRAY0_NV"] = { type ='value', },
       ["GL_VERTEX_ATTRIB_ARRAY1_NV"] = { type ='value', },
       ["GL_VERTEX_ATTRIB_ARRAY2_NV"] = { type ='value', },
       ["GL_VERTEX_ATTRIB_ARRAY3_NV"] = { type ='value', },
       ["GL_VERTEX_ATTRIB_ARRAY4_NV"] = { type ='value', },
       ["GL_VERTEX_ATTRIB_ARRAY5_NV"] = { type ='value', },
       ["GL_VERTEX_ATTRIB_ARRAY6_NV"] = { type ='value', },
       ["GL_VERTEX_ATTRIB_ARRAY7_NV"] = { type ='value', },
       ["GL_VERTEX_ATTRIB_ARRAY8_NV"] = { type ='value', },
       ["GL_VERTEX_ATTRIB_ARRAY9_NV"] = { type ='value', },
       ["GL_VERTEX_ATTRIB_ARRAY10_NV"] = { type ='value', },
       ["GL_VERTEX_ATTRIB_ARRAY11_NV"] = { type ='value', },
       ["GL_VERTEX_ATTRIB_ARRAY12_NV"] = { type ='value', },
       ["GL_VERTEX_ATTRIB_ARRAY13_NV"] = { type ='value', },
       ["GL_VERTEX_ATTRIB_ARRAY14_NV"] = { type ='value', },
       ["GL_VERTEX_ATTRIB_ARRAY15_NV"] = { type ='value', },
       ["GL_MAP1_VERTEX_ATTRIB0_4_NV"] = { type ='value', },
       ["GL_MAP1_VERTEX_ATTRIB1_4_NV"] = { type ='value', },
       ["GL_MAP1_VERTEX_ATTRIB2_4_NV"] = { type ='value', },
       ["GL_MAP1_VERTEX_ATTRIB3_4_NV"] = { type ='value', },
       ["GL_MAP1_VERTEX_ATTRIB4_4_NV"] = { type ='value', },
       ["GL_MAP1_VERTEX_ATTRIB5_4_NV"] = { type ='value', },
       ["GL_MAP1_VERTEX_ATTRIB6_4_NV"] = { type ='value', },
       ["GL_MAP1_VERTEX_ATTRIB7_4_NV"] = { type ='value', },
       ["GL_MAP1_VERTEX_ATTRIB8_4_NV"] = { type ='value', },
       ["GL_MAP1_VERTEX_ATTRIB9_4_NV"] = { type ='value', },
       ["GL_MAP1_VERTEX_ATTRIB10_4_NV"] = { type ='value', },
       ["GL_MAP1_VERTEX_ATTRIB11_4_NV"] = { type ='value', },
       ["GL_MAP1_VERTEX_ATTRIB12_4_NV"] = { type ='value', },
       ["GL_MAP1_VERTEX_ATTRIB13_4_NV"] = { type ='value', },
       ["GL_MAP1_VERTEX_ATTRIB14_4_NV"] = { type ='value', },
       ["GL_MAP1_VERTEX_ATTRIB15_4_NV"] = { type ='value', },
       ["GL_MAP2_VERTEX_ATTRIB0_4_NV"] = { type ='value', },
       ["GL_MAP2_VERTEX_ATTRIB1_4_NV"] = { type ='value', },
       ["GL_MAP2_VERTEX_ATTRIB2_4_NV"] = { type ='value', },
       ["GL_MAP2_VERTEX_ATTRIB3_4_NV"] = { type ='value', },
       ["GL_MAP2_VERTEX_ATTRIB4_4_NV"] = { type ='value', },
       ["GL_MAP2_VERTEX_ATTRIB5_4_NV"] = { type ='value', },
       ["GL_MAP2_VERTEX_ATTRIB6_4_NV"] = { type ='value', },
       ["GL_MAP2_VERTEX_ATTRIB7_4_NV"] = { type ='value', },
       ["GL_MAP2_VERTEX_ATTRIB8_4_NV"] = { type ='value', },
       ["GL_MAP2_VERTEX_ATTRIB9_4_NV"] = { type ='value', },
       ["GL_MAP2_VERTEX_ATTRIB10_4_NV"] = { type ='value', },
       ["GL_MAP2_VERTEX_ATTRIB11_4_NV"] = { type ='value', },
       ["GL_MAP2_VERTEX_ATTRIB12_4_NV"] = { type ='value', },
       ["GL_MAP2_VERTEX_ATTRIB13_4_NV"] = { type ='value', },
       ["GL_MAP2_VERTEX_ATTRIB14_4_NV"] = { type ='value', },
       ["GL_MAP2_VERTEX_ATTRIB15_4_NV"] = { type ='value', },
       ["MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB"] = { type ='value', },
       ["GL_VIDEO_BUFFER_NV"] = { type ='value', },
       ["GL_VIDEO_BUFFER_BINDING_NV"] = { type ='value', },
       ["GL_FIELD_UPPER_NV"] = { type ='value', },
       ["GL_FIELD_LOWER_NV"] = { type ='value', },
       ["GL_NUM_VIDEO_CAPTURE_STREAMS_NV"] = { type ='value', },
       ["GL_NEXT_VIDEO_CAPTURE_BUFFER_STATUS_NV"] = { type ='value', },
       ["GL_VIDEO_CAPTURE_TO_422_SUPPORTED_NV"] = { type ='value', },
       ["GL_LAST_VIDEO_CAPTURE_STATUS_NV"] = { type ='value', },
       ["GL_VIDEO_BUFFER_PITCH_NV"] = { type ='value', },
       ["GL_VIDEO_COLOR_CONVERSION_MATRIX_NV"] = { type ='value', },
       ["GL_VIDEO_COLOR_CONVERSION_MAX_NV"] = { type ='value', },
       ["GL_VIDEO_COLOR_CONVERSION_MIN_NV"] = { type ='value', },
       ["GL_VIDEO_COLOR_CONVERSION_OFFSET_NV"] = { type ='value', },
       ["GL_VIDEO_BUFFER_INTERNAL_FORMAT_NV"] = { type ='value', },
       ["GL_PARTIAL_SUCCESS_NV"] = { type ='value', },
       ["GL_SUCCESS_NV"] = { type ='value', },
       ["GL_FAILURE_NV"] = { type ='value', },
       ["GL_YCBYCR8_422_NV"] = { type ='value', },
       ["GL_YCBAYCR8A_4224_NV"] = { type ='value', },
       ["GL_Z6Y10Z6CB10Z6Y10Z6CR10_422_NV"] = { type ='value', },
       ["GL_Z6Y10Z6CB10Z6A10Z6Y10Z6CR10Z6A10_4224_NV"] = { type ='value', },
       ["GL_Z4Y12Z4CB12Z4Y12Z4CR12_422_NV"] = { type ='value', },
       ["GL_Z4Y12Z4CB12Z4A12Z4Y12Z4CR12Z4A12_4224_NV"] = { type ='value', },
       ["GL_Z4Y12Z4CB12Z4CR12_444_NV"] = { type ='value', },
       ["GL_VIDEO_CAPTURE_FRAME_WIDTH_NV"] = { type ='value', },
       ["GL_VIDEO_CAPTURE_FRAME_HEIGHT_NV"] = { type ='value', },
       ["GL_VIDEO_CAPTURE_FIELD_UPPER_HEIGHT_NV"] = { type ='value', },
       ["GL_VIDEO_CAPTURE_FIELD_LOWER_HEIGHT_NV"] = { type ='value', },
       ["GL_VIDEO_CAPTURE_SURFACE_ORIGIN_NV"] = { type ='value', },
       ["glAccum"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum op, GLfloat value)", },
       ["glAlphaFunc"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum func, GLclampf ref)", },
       ["glAreTexturesResident"] = { type ='function',
          description = "",
          returns = "(GLboolean)",
          valuetype = nil,
          args = "(GLsizei n, const GLuint *textures, GLboolean *residences)", },
       ["glArrayElement"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint i)", },
       ["glBegin"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum mode)", },
       ["glBindTexture"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint texture)", },
       ["glBitmap"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei width, GLsizei height, GLfloat xorig, GLfloat yorig, GLfloat xmove, GLfloat ymove, const GLubyte *bitmap)", },
       ["glBlendFunc"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum sfactor, GLenum dfactor)", },
       ["glCallList"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint list)", },
       ["glCallLists"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei n, GLenum type, const GLvoid *lists)", },
       ["glClear"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLbitfield mask)", },
       ["glClearAccum"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)", },
       ["glClearColor"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha)", },
       ["glClearDepth"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLclampd depth)", },
       ["glClearIndex"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLfloat c)", },
       ["glClearStencil"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint s)", },
       ["glClipPlane"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum plane, const GLdouble *equation)", },
       ["glColor3b"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLbyte red, GLbyte green, GLbyte blue)", },
       ["glColor3bv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLbyte *v)", },
       ["glColor3d"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLdouble red, GLdouble green, GLdouble blue)", },
       ["glColor3dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLdouble *v)", },
       ["glColor3f"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLfloat red, GLfloat green, GLfloat blue)", },
       ["glColor3fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLfloat *v)", },
       ["glColor3i"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint red, GLint green, GLint blue)", },
       ["glColor3iv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLint *v)", },
       ["glColor3s"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLshort red, GLshort green, GLshort blue)", },
       ["glColor3sv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLshort *v)", },
       ["glColor3ub"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLubyte red, GLubyte green, GLubyte blue)", },
       ["glColor3ubv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLubyte *v)", },
       ["glColor3ui"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint red, GLuint green, GLuint blue)", },
       ["glColor3uiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLuint *v)", },
       ["glColor3us"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLushort red, GLushort green, GLushort blue)", },
       ["glColor3usv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLushort *v)", },
       ["glColor4b"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLbyte red, GLbyte green, GLbyte blue, GLbyte alpha)", },
       ["glColor4bv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLbyte *v)", },
       ["glColor4d"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha)", },
       ["glColor4dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLdouble *v)", },
       ["glColor4f"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)", },
       ["glColor4fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLfloat *v)", },
       ["glColor4i"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint red, GLint green, GLint blue, GLint alpha)", },
       ["glColor4iv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLint *v)", },
       ["glColor4s"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLshort red, GLshort green, GLshort blue, GLshort alpha)", },
       ["glColor4sv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLshort *v)", },
       ["glColor4ub"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha)", },
       ["glColor4ubv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLubyte *v)", },
       ["glColor4ui"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint red, GLuint green, GLuint blue, GLuint alpha)", },
       ["glColor4uiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLuint *v)", },
       ["glColor4us"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLushort red, GLushort green, GLushort blue, GLushort alpha)", },
       ["glColor4usv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLushort *v)", },
       ["glColorMask"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha)", },
       ["glColorMaterial"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum face, GLenum mode)", },
       ["glColorPointer"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer)", },
       ["glCopyPixels"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint x, GLint y, GLsizei width, GLsizei height, GLenum type)", },
       ["glCopyTexImage1D"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLint border)", },
       ["glCopyTexImage2D"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border)", },
       ["glCopyTexSubImage1D"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width)", },
       ["glCopyTexSubImage2D"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height)", },
       ["glCullFace"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum mode)", },
       ["glDeleteLists"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint list, GLsizei range)", },
       ["glDeleteTextures"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei n, const GLuint *textures)", },
       ["glDepthFunc"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum func)", },
       ["glDepthMask"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLboolean flag)", },
       ["glDepthRange"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLclampd zNear, GLclampd zFar)", },
       ["glDisable"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum cap)", },
       ["glDisableClientState"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum array)", },
       ["glDrawArrays"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum mode, GLint first, GLsizei count)", },
       ["glDrawBuffer"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum mode)", },
       ["glDrawElements"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices)", },
       ["glDrawPixels"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels)", },
       ["glEdgeFlag"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLboolean flag)", },
       ["glEdgeFlagPointer"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei stride, const GLvoid *pointer)", },
       ["glEdgeFlagv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLboolean *flag)", },
       ["glEnable"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum cap)", },
       ["glEnableClientState"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum array)", },
       ["glEnd"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(void)", },
       ["glEndList"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(void)", },
       ["glEvalCoord1d"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLdouble u)", },
       ["glEvalCoord1dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLdouble *u)", },
       ["glEvalCoord1f"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLfloat u)", },
       ["glEvalCoord1fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLfloat *u)", },
       ["glEvalCoord2d"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLdouble u, GLdouble v)", },
       ["glEvalCoord2dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLdouble *u)", },
       ["glEvalCoord2f"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLfloat u, GLfloat v)", },
       ["glEvalCoord2fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLfloat *u)", },
       ["glEvalMesh1"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum mode, GLint i1, GLint i2)", },
       ["glEvalMesh2"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum mode, GLint i1, GLint i2, GLint j1, GLint j2)", },
       ["glEvalPoint1"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint i)", },
       ["glEvalPoint2"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint i, GLint j)", },
       ["glFeedbackBuffer"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei size, GLenum type, GLfloat *buffer)", },
       ["glFinish"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(void)", },
       ["glFlush"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(void)", },
       ["glFogf"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum pname, GLfloat param)", },
       ["glFogfv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum pname, const GLfloat *params)", },
       ["glFogi"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum pname, GLint param)", },
       ["glFogiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum pname, const GLint *params)", },
       ["glFrontFace"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum mode)", },
       ["glFrustum"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar)", },
       ["glGenLists"] = { type ='function',
          description = "",
          returns = "(GLuint)",
          valuetype = nil,
          args = "(GLsizei range)", },
       ["glGenTextures"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei n, GLuint *textures)", },
       ["glGetBooleanv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum pname, GLboolean *params)", },
       ["glGetClipPlane"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum plane, GLdouble *equation)", },
       ["glGetDoublev"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum pname, GLdouble *params)", },
       ["glGetError"] = { type ='function',
          description = "",
          returns = "(GLenum)",
          valuetype = nil,
          args = "(void)", },
       ["glGetFloatv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum pname, GLfloat *params)", },
       ["glGetIntegerv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum pname, GLint *params)", },
       ["glGetLightfv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum light, GLenum pname, GLfloat *params)", },
       ["glGetLightiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum light, GLenum pname, GLint *params)", },
       ["glGetMapdv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum query, GLdouble *v)", },
       ["glGetMapfv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum query, GLfloat *v)", },
       ["glGetMapiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum query, GLint *v)", },
       ["glGetMaterialfv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum face, GLenum pname, GLfloat *params)", },
       ["glGetMaterialiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum face, GLenum pname, GLint *params)", },
       ["glGetPixelMapfv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum map, GLfloat *values)", },
       ["glGetPixelMapuiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum map, GLuint *values)", },
       ["glGetPixelMapusv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum map, GLushort *values)", },
       ["glGetPointerv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum pname, GLvoid* *params)", },
       ["glGetPolygonStipple"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLubyte *mask)", },
       ["glGetString"] = { type ='function',
          description = "",
          returns = "(GLubyte*)",
          valuetype = nil,
          args = "(GLenum s)", },
       ["glGetTexEnvfv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum pname, GLfloat *params)", },
       ["glGetTexEnviv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum pname, GLint *params)", },
       ["glGetTexGendv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum coord, GLenum pname, GLdouble *params)", },
       ["glGetTexGenfv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum coord, GLenum pname, GLfloat *params)", },
       ["glGetTexGeniv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum coord, GLenum pname, GLint *params)", },
       ["glGetTexImage"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels)", },
       ["glGetTexLevelParameterfv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLint level, GLenum pname, GLfloat *params)", },
       ["glGetTexLevelParameteriv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLint level, GLenum pname, GLint *params)", },
       ["glGetTexParameterfv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum pname, GLfloat *params)", },
       ["glGetTexParameteriv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum pname, GLint *params)", },
       ["glHint"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum mode)", },
       ["glIndexMask"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint mask)", },
       ["glIndexPointer"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum type, GLsizei stride, const GLvoid *pointer)", },
       ["glIndexd"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLdouble c)", },
       ["glIndexdv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLdouble *c)", },
       ["glIndexf"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLfloat c)", },
       ["glIndexfv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLfloat *c)", },
       ["glIndexi"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint c)", },
       ["glIndexiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLint *c)", },
       ["glIndexs"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLshort c)", },
       ["glIndexsv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLshort *c)", },
       ["glIndexub"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLubyte c)", },
       ["glIndexubv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLubyte *c)", },
       ["glInitNames"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(void)", },
       ["glInterleavedArrays"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum format, GLsizei stride, const GLvoid *pointer)", },
       ["glIsEnabled"] = { type ='function',
          description = "",
          returns = "(GLboolean)",
          valuetype = nil,
          args = "(GLenum cap)", },
       ["glIsList"] = { type ='function',
          description = "",
          returns = "(GLboolean)",
          valuetype = nil,
          args = "(GLuint list)", },
       ["glIsTexture"] = { type ='function',
          description = "",
          returns = "(GLboolean)",
          valuetype = nil,
          args = "(GLuint texture)", },
       ["glLightModelf"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum pname, GLfloat param)", },
       ["glLightModelfv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum pname, const GLfloat *params)", },
       ["glLightModeli"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum pname, GLint param)", },
       ["glLightModeliv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum pname, const GLint *params)", },
       ["glLightf"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum light, GLenum pname, GLfloat param)", },
       ["glLightfv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum light, GLenum pname, const GLfloat *params)", },
       ["glLighti"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum light, GLenum pname, GLint param)", },
       ["glLightiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum light, GLenum pname, const GLint *params)", },
       ["glLineStipple"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint factor, GLushort pattern)", },
       ["glLineWidth"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLfloat width)", },
       ["glListBase"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint base)", },
       ["glLoadIdentity"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(void)", },
       ["glLoadMatrixd"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLdouble *m)", },
       ["glLoadMatrixf"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLfloat *m)", },
       ["glLoadName"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint name)", },
       ["glLogicOp"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum opcode)", },
       ["glMap1d"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLdouble u1, GLdouble u2, GLint stride, GLint order, const GLdouble *points)", },
       ["glMap1f"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLfloat u1, GLfloat u2, GLint stride, GLint order, const GLfloat *points)", },
       ["glMap2d"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLdouble u1, GLdouble u2, GLint ustride, GLint uorder, GLdouble v1, GLdouble v2, GLint vstride, GLint vorder, const GLdouble *points)", },
       ["glMap2f"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLfloat u1, GLfloat u2, GLint ustride, GLint uorder, GLfloat v1, GLfloat v2, GLint vstride, GLint vorder, const GLfloat *points)", },
       ["glMapGrid1d"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint un, GLdouble u1, GLdouble u2)", },
       ["glMapGrid1f"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint un, GLfloat u1, GLfloat u2)", },
       ["glMapGrid2d"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint un, GLdouble u1, GLdouble u2, GLint vn, GLdouble v1, GLdouble v2)", },
       ["glMapGrid2f"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint un, GLfloat u1, GLfloat u2, GLint vn, GLfloat v1, GLfloat v2)", },
       ["glMaterialf"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum face, GLenum pname, GLfloat param)", },
       ["glMaterialfv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum face, GLenum pname, const GLfloat *params)", },
       ["glMateriali"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum face, GLenum pname, GLint param)", },
       ["glMaterialiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum face, GLenum pname, const GLint *params)", },
       ["glMatrixMode"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum mode)", },
       ["glMultMatrixd"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLdouble *m)", },
       ["glMultMatrixf"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLfloat *m)", },
       ["glNewList"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint list, GLenum mode)", },
       ["glNormal3b"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLbyte nx, GLbyte ny, GLbyte nz)", },
       ["glNormal3bv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLbyte *v)", },
       ["glNormal3d"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLdouble nx, GLdouble ny, GLdouble nz)", },
       ["glNormal3dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLdouble *v)", },
       ["glNormal3f"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLfloat nx, GLfloat ny, GLfloat nz)", },
       ["glNormal3fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLfloat *v)", },
       ["glNormal3i"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint nx, GLint ny, GLint nz)", },
       ["glNormal3iv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLint *v)", },
       ["glNormal3s"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLshort nx, GLshort ny, GLshort nz)", },
       ["glNormal3sv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLshort *v)", },
       ["glNormalPointer"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum type, GLsizei stride, const GLvoid *pointer)", },
       ["glOrtho"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar)", },
       ["glPassThrough"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLfloat token)", },
       ["glPixelMapfv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum map, GLsizei mapsize, const GLfloat *values)", },
       ["glPixelMapuiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum map, GLsizei mapsize, const GLuint *values)", },
       ["glPixelMapusv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum map, GLsizei mapsize, const GLushort *values)", },
       ["glPixelStoref"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum pname, GLfloat param)", },
       ["glPixelStorei"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum pname, GLint param)", },
       ["glPixelTransferf"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum pname, GLfloat param)", },
       ["glPixelTransferi"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum pname, GLint param)", },
       ["glPixelZoom"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLfloat xfactor, GLfloat yfactor)", },
       ["glPointSize"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLfloat size)", },
       ["glPolygonMode"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum face, GLenum mode)", },
       ["glPolygonOffset"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLfloat factor, GLfloat units)", },
       ["glPolygonStipple"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLubyte *mask)", },
       ["glPopAttrib"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(void)", },
       ["glPopClientAttrib"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(void)", },
       ["glPopMatrix"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(void)", },
       ["glPopName"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(void)", },
       ["glPrioritizeTextures"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei n, const GLuint *textures, const GLclampf *priorities)", },
       ["glPushAttrib"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLbitfield mask)", },
       ["glPushClientAttrib"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLbitfield mask)", },
       ["glPushMatrix"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(void)", },
       ["glPushName"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint name)", },
       ["glRasterPos2d"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLdouble x, GLdouble y)", },
       ["glRasterPos2dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLdouble *v)", },
       ["glRasterPos2f"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLfloat x, GLfloat y)", },
       ["glRasterPos2fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLfloat *v)", },
       ["glRasterPos2i"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint x, GLint y)", },
       ["glRasterPos2iv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLint *v)", },
       ["glRasterPos2s"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLshort x, GLshort y)", },
       ["glRasterPos2sv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLshort *v)", },
       ["glRasterPos3d"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLdouble x, GLdouble y, GLdouble z)", },
       ["glRasterPos3dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLdouble *v)", },
       ["glRasterPos3f"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLfloat x, GLfloat y, GLfloat z)", },
       ["glRasterPos3fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLfloat *v)", },
       ["glRasterPos3i"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint x, GLint y, GLint z)", },
       ["glRasterPos3iv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLint *v)", },
       ["glRasterPos3s"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLshort x, GLshort y, GLshort z)", },
       ["glRasterPos3sv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLshort *v)", },
       ["glRasterPos4d"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLdouble x, GLdouble y, GLdouble z, GLdouble w)", },
       ["glRasterPos4dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLdouble *v)", },
       ["glRasterPos4f"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLfloat x, GLfloat y, GLfloat z, GLfloat w)", },
       ["glRasterPos4fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLfloat *v)", },
       ["glRasterPos4i"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint x, GLint y, GLint z, GLint w)", },
       ["glRasterPos4iv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLint *v)", },
       ["glRasterPos4s"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLshort x, GLshort y, GLshort z, GLshort w)", },
       ["glRasterPos4sv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLshort *v)", },
       ["glReadBuffer"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum mode)", },
       ["glReadPixels"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels)", },
       ["glRectd"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLdouble x1, GLdouble y1, GLdouble x2, GLdouble y2)", },
       ["glRectdv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLdouble *v1, const GLdouble *v2)", },
       ["glRectf"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLfloat x1, GLfloat y1, GLfloat x2, GLfloat y2)", },
       ["glRectfv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLfloat *v1, const GLfloat *v2)", },
       ["glRecti"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint x1, GLint y1, GLint x2, GLint y2)", },
       ["glRectiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLint *v1, const GLint *v2)", },
       ["glRects"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLshort x1, GLshort y1, GLshort x2, GLshort y2)", },
       ["glRectsv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLshort *v1, const GLshort *v2)", },
       ["glRenderMode"] = { type ='function',
          description = "",
          returns = "(GLint)",
          valuetype = nil,
          args = "(GLenum mode)", },
       ["glRotated"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLdouble angle, GLdouble x, GLdouble y, GLdouble z)", },
       ["glRotatef"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLfloat angle, GLfloat x, GLfloat y, GLfloat z)", },
       ["glScaled"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLdouble x, GLdouble y, GLdouble z)", },
       ["glScalef"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLfloat x, GLfloat y, GLfloat z)", },
       ["glScissor"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint x, GLint y, GLsizei width, GLsizei height)", },
       ["glSelectBuffer"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei size, GLuint *buffer)", },
       ["glShadeModel"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum mode)", },
       ["glStencilFunc"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum func, GLint ref, GLuint mask)", },
       ["glStencilMask"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint mask)", },
       ["glStencilOp"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum fail, GLenum zfail, GLenum zpass)", },
       ["glTexCoord1d"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLdouble s)", },
       ["glTexCoord1dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLdouble *v)", },
       ["glTexCoord1f"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLfloat s)", },
       ["glTexCoord1fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLfloat *v)", },
       ["glTexCoord1i"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint s)", },
       ["glTexCoord1iv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLint *v)", },
       ["glTexCoord1s"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLshort s)", },
       ["glTexCoord1sv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLshort *v)", },
       ["glTexCoord2d"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLdouble s, GLdouble t)", },
       ["glTexCoord2dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLdouble *v)", },
       ["glTexCoord2f"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLfloat s, GLfloat t)", },
       ["glTexCoord2fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLfloat *v)", },
       ["glTexCoord2i"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint s, GLint t)", },
       ["glTexCoord2iv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLint *v)", },
       ["glTexCoord2s"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLshort s, GLshort t)", },
       ["glTexCoord2sv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLshort *v)", },
       ["glTexCoord3d"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLdouble s, GLdouble t, GLdouble r)", },
       ["glTexCoord3dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLdouble *v)", },
       ["glTexCoord3f"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLfloat s, GLfloat t, GLfloat r)", },
       ["glTexCoord3fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLfloat *v)", },
       ["glTexCoord3i"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint s, GLint t, GLint r)", },
       ["glTexCoord3iv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLint *v)", },
       ["glTexCoord3s"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLshort s, GLshort t, GLshort r)", },
       ["glTexCoord3sv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLshort *v)", },
       ["glTexCoord4d"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLdouble s, GLdouble t, GLdouble r, GLdouble q)", },
       ["glTexCoord4dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLdouble *v)", },
       ["glTexCoord4f"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLfloat s, GLfloat t, GLfloat r, GLfloat q)", },
       ["glTexCoord4fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLfloat *v)", },
       ["glTexCoord4i"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint s, GLint t, GLint r, GLint q)", },
       ["glTexCoord4iv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLint *v)", },
       ["glTexCoord4s"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLshort s, GLshort t, GLshort r, GLshort q)", },
       ["glTexCoord4sv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLshort *v)", },
       ["glTexCoordPointer"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer)", },
       ["glTexEnvf"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum pname, GLfloat param)", },
       ["glTexEnvfv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum pname, const GLfloat *params)", },
       ["glTexEnvi"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum pname, GLint param)", },
       ["glTexEnviv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum pname, const GLint *params)", },
       ["glTexGend"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum coord, GLenum pname, GLdouble param)", },
       ["glTexGendv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum coord, GLenum pname, const GLdouble *params)", },
       ["glTexGenf"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum coord, GLenum pname, GLfloat param)", },
       ["glTexGenfv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum coord, GLenum pname, const GLfloat *params)", },
       ["glTexGeni"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum coord, GLenum pname, GLint param)", },
       ["glTexGeniv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum coord, GLenum pname, const GLint *params)", },
       ["glTexImage1D"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels)", },
       ["glTexImage2D"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels)", },
       ["glTexParameterf"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum pname, GLfloat param)", },
       ["glTexParameterfv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum pname, const GLfloat *params)", },
       ["glTexParameteri"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum pname, GLint param)", },
       ["glTexParameteriv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum pname, const GLint *params)", },
       ["glTexSubImage1D"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels)", },
       ["glTexSubImage2D"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels)", },
       ["glTranslated"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLdouble x, GLdouble y, GLdouble z)", },
       ["glTranslatef"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLfloat x, GLfloat y, GLfloat z)", },
       ["glVertex2d"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLdouble x, GLdouble y)", },
       ["glVertex2dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLdouble *v)", },
       ["glVertex2f"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLfloat x, GLfloat y)", },
       ["glVertex2fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLfloat *v)", },
       ["glVertex2i"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint x, GLint y)", },
       ["glVertex2iv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLint *v)", },
       ["glVertex2s"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLshort x, GLshort y)", },
       ["glVertex2sv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLshort *v)", },
       ["glVertex3d"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLdouble x, GLdouble y, GLdouble z)", },
       ["glVertex3dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLdouble *v)", },
       ["glVertex3f"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLfloat x, GLfloat y, GLfloat z)", },
       ["glVertex3fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLfloat *v)", },
       ["glVertex3i"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint x, GLint y, GLint z)", },
       ["glVertex3iv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLint *v)", },
       ["glVertex3s"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLshort x, GLshort y, GLshort z)", },
       ["glVertex3sv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLshort *v)", },
       ["glVertex4d"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLdouble x, GLdouble y, GLdouble z, GLdouble w)", },
       ["glVertex4dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLdouble *v)", },
       ["glVertex4f"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLfloat x, GLfloat y, GLfloat z, GLfloat w)", },
       ["glVertex4fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLfloat *v)", },
       ["glVertex4i"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint x, GLint y, GLint z, GLint w)", },
       ["glVertex4iv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLint *v)", },
       ["glVertex4s"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLshort x, GLshort y, GLshort z, GLshort w)", },
       ["glVertex4sv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLshort *v)", },
       ["glVertexPointer"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer)", },
       ["glViewport"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint x, GLint y, GLsizei width, GLsizei height)", },
       ["glCopyTexSubImage3D"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height)", },
       ["glDrawRangeElements"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid *indices)", },
       ["glTexImage3D"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLint level, GLint internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid *pixels)", },
       ["glTexSubImage3D"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid *pixels)", },
       ["glActiveTexture"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texture)", },
       ["glClientActiveTexture"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texture)", },
       ["glCompressedTexImage1D"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const GLvoid *data)", },
       ["glCompressedTexImage2D"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid *data)", },
       ["glCompressedTexImage3D"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid *data)", },
       ["glCompressedTexSubImage1D"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid *data)", },
       ["glCompressedTexSubImage2D"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid *data)", },
       ["glCompressedTexSubImage3D"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid *data)", },
       ["glGetCompressedTexImage"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLint lod, GLvoid *img)", },
       ["glLoadTransposeMatrixd"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLdouble m[16])", },
       ["glLoadTransposeMatrixf"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLfloat m[16])", },
       ["glMultTransposeMatrixd"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLdouble m[16])", },
       ["glMultTransposeMatrixf"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLfloat m[16])", },
       ["glMultiTexCoord1d"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLdouble s)", },
       ["glMultiTexCoord1dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, const GLdouble *v)", },
       ["glMultiTexCoord1f"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLfloat s)", },
       ["glMultiTexCoord1fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, const GLfloat *v)", },
       ["glMultiTexCoord1i"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLint s)", },
       ["glMultiTexCoord1iv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, const GLint *v)", },
       ["glMultiTexCoord1s"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLshort s)", },
       ["glMultiTexCoord1sv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, const GLshort *v)", },
       ["glMultiTexCoord2d"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLdouble s, GLdouble t)", },
       ["glMultiTexCoord2dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, const GLdouble *v)", },
       ["glMultiTexCoord2f"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLfloat s, GLfloat t)", },
       ["glMultiTexCoord2fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, const GLfloat *v)", },
       ["glMultiTexCoord2i"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLint s, GLint t)", },
       ["glMultiTexCoord2iv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, const GLint *v)", },
       ["glMultiTexCoord2s"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLshort s, GLshort t)", },
       ["glMultiTexCoord2sv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, const GLshort *v)", },
       ["glMultiTexCoord3d"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLdouble s, GLdouble t, GLdouble r)", },
       ["glMultiTexCoord3dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, const GLdouble *v)", },
       ["glMultiTexCoord3f"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLfloat s, GLfloat t, GLfloat r)", },
       ["glMultiTexCoord3fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, const GLfloat *v)", },
       ["glMultiTexCoord3i"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLint s, GLint t, GLint r)", },
       ["glMultiTexCoord3iv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, const GLint *v)", },
       ["glMultiTexCoord3s"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLshort s, GLshort t, GLshort r)", },
       ["glMultiTexCoord3sv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, const GLshort *v)", },
       ["glMultiTexCoord4d"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLdouble s, GLdouble t, GLdouble r, GLdouble q)", },
       ["glMultiTexCoord4dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, const GLdouble *v)", },
       ["glMultiTexCoord4f"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q)", },
       ["glMultiTexCoord4fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, const GLfloat *v)", },
       ["glMultiTexCoord4i"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLint s, GLint t, GLint r, GLint q)", },
       ["glMultiTexCoord4iv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, const GLint *v)", },
       ["glMultiTexCoord4s"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLshort s, GLshort t, GLshort r, GLshort q)", },
       ["glMultiTexCoord4sv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, const GLshort *v)", },
       ["glSampleCoverage"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLclampf value, GLboolean invert)", },
       ["glBlendColor"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha)", },
       ["glBlendEquation"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum mode)", },
       ["glBlendFuncSeparate"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha)", },
       ["glFogCoordPointer"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum type, GLsizei stride, const GLvoid *pointer)", },
       ["glFogCoordd"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLdouble coord)", },
       ["glFogCoorddv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLdouble *coord)", },
       ["glFogCoordf"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLfloat coord)", },
       ["glFogCoordfv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLfloat *coord)", },
       ["glMultiDrawArrays"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum mode, const GLint *first, const GLsizei *count, GLsizei drawcount)", },
       ["glMultiDrawElements"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum mode, const GLsizei *count, GLenum type, const GLvoid **indices, GLsizei drawcount)", },
       ["glPointParameterf"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum pname, GLfloat param)", },
       ["glPointParameterfv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum pname, const GLfloat *params)", },
       ["glPointParameteri"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum pname, GLint param)", },
       ["glPointParameteriv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum pname, const GLint *params)", },
       ["glSecondaryColor3b"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLbyte red, GLbyte green, GLbyte blue)", },
       ["glSecondaryColor3bv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLbyte *v)", },
       ["glSecondaryColor3d"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLdouble red, GLdouble green, GLdouble blue)", },
       ["glSecondaryColor3dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLdouble *v)", },
       ["glSecondaryColor3f"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLfloat red, GLfloat green, GLfloat blue)", },
       ["glSecondaryColor3fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLfloat *v)", },
       ["glSecondaryColor3i"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint red, GLint green, GLint blue)", },
       ["glSecondaryColor3iv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLint *v)", },
       ["glSecondaryColor3s"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLshort red, GLshort green, GLshort blue)", },
       ["glSecondaryColor3sv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLshort *v)", },
       ["glSecondaryColor3ub"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLubyte red, GLubyte green, GLubyte blue)", },
       ["glSecondaryColor3ubv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLubyte *v)", },
       ["glSecondaryColor3ui"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint red, GLuint green, GLuint blue)", },
       ["glSecondaryColor3uiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLuint *v)", },
       ["glSecondaryColor3us"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLushort red, GLushort green, GLushort blue)", },
       ["glSecondaryColor3usv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLushort *v)", },
       ["glSecondaryColorPointer"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer)", },
       ["glWindowPos2d"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLdouble x, GLdouble y)", },
       ["glWindowPos2dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLdouble *p)", },
       ["glWindowPos2f"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLfloat x, GLfloat y)", },
       ["glWindowPos2fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLfloat *p)", },
       ["glWindowPos2i"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint x, GLint y)", },
       ["glWindowPos2iv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLint *p)", },
       ["glWindowPos2s"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLshort x, GLshort y)", },
       ["glWindowPos2sv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLshort *p)", },
       ["glWindowPos3d"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLdouble x, GLdouble y, GLdouble z)", },
       ["glWindowPos3dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLdouble *p)", },
       ["glWindowPos3f"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLfloat x, GLfloat y, GLfloat z)", },
       ["glWindowPos3fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLfloat *p)", },
       ["glWindowPos3i"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint x, GLint y, GLint z)", },
       ["glWindowPos3iv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLint *p)", },
       ["glWindowPos3s"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLshort x, GLshort y, GLshort z)", },
       ["glWindowPos3sv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLshort *p)", },
       ["glBeginQuery"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint id)", },
       ["glBindBuffer"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint buffer)", },
       ["glBufferData"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLsizeiptr size, const GLvoid* data, GLenum usage)", },
       ["glBufferSubData"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLintptr offset, GLsizeiptr size, const GLvoid* data)", },
       ["glDeleteBuffers"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei n, const GLuint* buffers)", },
       ["glDeleteQueries"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei n, const GLuint* ids)", },
       ["glEndQuery"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target)", },
       ["glGenBuffers"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei n, GLuint* buffers)", },
       ["glGenQueries"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei n, GLuint* ids)", },
       ["glGetBufferParameteriv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum pname, GLint* params)", },
       ["glGetBufferPointerv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum pname, GLvoid** params)", },
       ["glGetBufferSubData"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLintptr offset, GLsizeiptr size, GLvoid* data)", },
       ["glGetQueryObjectiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint id, GLenum pname, GLint* params)", },
       ["glGetQueryObjectuiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint id, GLenum pname, GLuint* params)", },
       ["glGetQueryiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum pname, GLint* params)", },
       ["glIsBuffer"] = { type ='function',
          description = "",
          returns = "(GLboolean)",
          valuetype = nil,
          args = "(GLuint buffer)", },
       ["glIsQuery"] = { type ='function',
          description = "",
          returns = "(GLboolean)",
          valuetype = nil,
          args = "(GLuint id)", },
       ["glMapBuffer"] = { type ='function',
          description = "",
          returns = "(GLvoid*)",
          valuetype = nil,
          args = "(GLenum target, GLenum access)", },
       ["glUnmapBuffer"] = { type ='function',
          description = "",
          returns = "(GLboolean)",
          valuetype = nil,
          args = "(GLenum target)", },
       ["glAttachShader"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLuint shader)", },
       ["glBindAttribLocation"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLuint index, const GLchar* name)", },
       ["glBlendEquationSeparate"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum, GLenum)", },
       ["glCompileShader"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint shader)", },
       ["glCreateProgram"] = { type ='function',
          description = "",
          returns = "(GLuint)",
          valuetype = nil,
          args = "(void)", },
       ["glCreateShader"] = { type ='function',
          description = "",
          returns = "(GLuint)",
          valuetype = nil,
          args = "(GLenum type)", },
       ["glDeleteProgram"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program)", },
       ["glDeleteShader"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint shader)", },
       ["glDetachShader"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLuint shader)", },
       ["glDisableVertexAttribArray"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint)", },
       ["glDrawBuffers"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei n, const GLenum* bufs)", },
       ["glEnableVertexAttribArray"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint)", },
       ["glGetActiveAttrib"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLuint index, GLsizei maxLength, GLsizei* length, GLint* size, GLenum* type, GLchar* name)", },
       ["glGetActiveUniform"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLuint index, GLsizei maxLength, GLsizei* length, GLint* size, GLenum* type, GLchar* name)", },
       ["glGetAttachedShaders"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLsizei maxCount, GLsizei* count, GLuint* shaders)", },
       ["glGetAttribLocation"] = { type ='function',
          description = "",
          returns = "(GLint)",
          valuetype = nil,
          args = "(GLuint program, const GLchar* name)", },
       ["glGetProgramInfoLog"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLsizei bufSize, GLsizei* length, GLchar* infoLog)", },
       ["glGetProgramiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLenum pname, GLint* param)", },
       ["glGetShaderInfoLog"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint shader, GLsizei bufSize, GLsizei* length, GLchar* infoLog)", },
       ["glGetShaderSource"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint obj, GLsizei maxLength, GLsizei* length, GLchar* source)", },
       ["glGetShaderiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint shader, GLenum pname, GLint* param)", },
       ["glGetUniformLocation"] = { type ='function',
          description = "",
          returns = "(GLint)",
          valuetype = nil,
          args = "(GLuint program, const GLchar* name)", },
       ["glGetUniformfv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLfloat* params)", },
       ["glGetUniformiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLint* params)", },
       ["glGetVertexAttribPointerv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint, GLenum, GLvoid**)", },
       ["glGetVertexAttribdv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint, GLenum, GLdouble*)", },
       ["glGetVertexAttribfv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint, GLenum, GLfloat*)", },
       ["glGetVertexAttribiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint, GLenum, GLint*)", },
       ["glIsProgram"] = { type ='function',
          description = "",
          returns = "(GLboolean)",
          valuetype = nil,
          args = "(GLuint program)", },
       ["glIsShader"] = { type ='function',
          description = "",
          returns = "(GLboolean)",
          valuetype = nil,
          args = "(GLuint shader)", },
       ["glLinkProgram"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program)", },
       ["glShaderSource"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint shader, GLsizei count, const GLchar** strings, const GLint* lengths)", },
       ["glStencilFuncSeparate"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum frontfunc, GLenum backfunc, GLint ref, GLuint mask)", },
       ["glStencilMaskSeparate"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum, GLuint)", },
       ["glStencilOpSeparate"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass)", },
       ["glUniform1f"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLfloat v0)", },
       ["glUniform1fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLsizei count, const GLfloat* value)", },
       ["glUniform1i"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLint v0)", },
       ["glUniform1iv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLsizei count, const GLint* value)", },
       ["glUniform2f"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLfloat v0, GLfloat v1)", },
       ["glUniform2fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLsizei count, const GLfloat* value)", },
       ["glUniform2i"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLint v0, GLint v1)", },
       ["glUniform2iv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLsizei count, const GLint* value)", },
       ["glUniform3f"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLfloat v0, GLfloat v1, GLfloat v2)", },
       ["glUniform3fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLsizei count, const GLfloat* value)", },
       ["glUniform3i"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLint v0, GLint v1, GLint v2)", },
       ["glUniform3iv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLsizei count, const GLint* value)", },
       ["glUniform4f"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3)", },
       ["glUniform4fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLsizei count, const GLfloat* value)", },
       ["glUniform4i"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLint v0, GLint v1, GLint v2, GLint v3)", },
       ["glUniform4iv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLsizei count, const GLint* value)", },
       ["glUniformMatrix2fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLsizei count, GLboolean transpose, const GLfloat* value)", },
       ["glUniformMatrix3fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLsizei count, GLboolean transpose, const GLfloat* value)", },
       ["glUniformMatrix4fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLsizei count, GLboolean transpose, const GLfloat* value)", },
       ["glUseProgram"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program)", },
       ["glValidateProgram"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program)", },
       ["glVertexAttrib1d"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLdouble x)", },
       ["glVertexAttrib1dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, const GLdouble* v)", },
       ["glVertexAttrib1f"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLfloat x)", },
       ["glVertexAttrib1fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, const GLfloat* v)", },
       ["glVertexAttrib1s"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLshort x)", },
       ["glVertexAttrib1sv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, const GLshort* v)", },
       ["glVertexAttrib2d"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLdouble x, GLdouble y)", },
       ["glVertexAttrib2dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, const GLdouble* v)", },
       ["glVertexAttrib2f"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLfloat x, GLfloat y)", },
       ["glVertexAttrib2fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, const GLfloat* v)", },
       ["glVertexAttrib2s"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLshort x, GLshort y)", },
       ["glVertexAttrib2sv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, const GLshort* v)", },
       ["glVertexAttrib3d"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLdouble x, GLdouble y, GLdouble z)", },
       ["glVertexAttrib3dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, const GLdouble* v)", },
       ["glVertexAttrib3f"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLfloat x, GLfloat y, GLfloat z)", },
       ["glVertexAttrib3fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, const GLfloat* v)", },
       ["glVertexAttrib3s"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLshort x, GLshort y, GLshort z)", },
       ["glVertexAttrib3sv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, const GLshort* v)", },
       ["glVertexAttrib4Nbv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, const GLbyte* v)", },
       ["glVertexAttrib4Niv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, const GLint* v)", },
       ["glVertexAttrib4Nsv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, const GLshort* v)", },
       ["glVertexAttrib4Nub"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w)", },
       ["glVertexAttrib4Nubv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, const GLubyte* v)", },
       ["glVertexAttrib4Nuiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, const GLuint* v)", },
       ["glVertexAttrib4Nusv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, const GLushort* v)", },
       ["glVertexAttrib4bv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, const GLbyte* v)", },
       ["glVertexAttrib4d"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)", },
       ["glVertexAttrib4dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, const GLdouble* v)", },
       ["glVertexAttrib4f"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)", },
       ["glVertexAttrib4fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, const GLfloat* v)", },
       ["glVertexAttrib4iv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, const GLint* v)", },
       ["glVertexAttrib4s"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLshort x, GLshort y, GLshort z, GLshort w)", },
       ["glVertexAttrib4sv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, const GLshort* v)", },
       ["glVertexAttrib4ubv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, const GLubyte* v)", },
       ["glVertexAttrib4uiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, const GLuint* v)", },
       ["glVertexAttrib4usv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, const GLushort* v)", },
       ["glVertexAttribPointer"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const GLvoid* pointer)", },
       ["glUniformMatrix2x3fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)", },
       ["glUniformMatrix2x4fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)", },
       ["glUniformMatrix3x2fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)", },
       ["glUniformMatrix3x4fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)", },
       ["glUniformMatrix4x2fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)", },
       ["glUniformMatrix4x3fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)", },
       ["glBeginConditionalRender"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint, GLenum)", },
       ["glBeginTransformFeedback"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum)", },
       ["glBindFragDataLocation"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint, GLuint, const GLchar*)", },
       ["glClampColor"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum, GLenum)", },
       ["glClearBufferfi"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum, GLint, GLfloat, GLint)", },
       ["glClearBufferfv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum, GLint, const GLfloat*)", },
       ["glClearBufferiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum, GLint, const GLint*)", },
       ["glClearBufferuiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum, GLint, const GLuint*)", },
       ["glColorMaski"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint, GLboolean, GLboolean, GLboolean, GLboolean)", },
       ["glDisablei"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum, GLuint)", },
       ["glEnablei"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum, GLuint)", },
       ["glEndConditionalRender"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(void)", },
       ["glEndTransformFeedback"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(void)", },
       ["glGetBooleani_v"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum, GLuint, GLboolean*)", },
       ["glGetFragDataLocation"] = { type ='function',
          description = "",
          returns = "(GLint)",
          valuetype = nil,
          args = "(GLuint, const GLchar*)", },
       ["glGetStringi"] = { type ='function',
          description = "",
          returns = "(const GLubyte*)",
          valuetype = nil,
          args = "(GLenum, GLuint)", },
       ["glGetTexParameterIiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum, GLenum, GLint*)", },
       ["glGetTexParameterIuiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum, GLenum, GLuint*)", },
       ["glGetTransformFeedbackVarying"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint, GLuint, GLsizei, GLsizei *, GLsizei *, GLenum *, GLchar *)", },
       ["glGetUniformuiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint, GLint, GLuint*)", },
       ["glGetVertexAttribIiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint, GLenum, GLint*)", },
       ["glGetVertexAttribIuiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint, GLenum, GLuint*)", },
       ["glIsEnabledi"] = { type ='function',
          description = "",
          returns = "(GLboolean)",
          valuetype = nil,
          args = "(GLenum, GLuint)", },
       ["glTexParameterIiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum, GLenum, const GLint*)", },
       ["glTexParameterIuiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum, GLenum, const GLuint*)", },
       ["glTransformFeedbackVaryings"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint, GLsizei, const GLchar **, GLenum)", },
       ["glUniform1ui"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint, GLuint)", },
       ["glUniform1uiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint, GLsizei, const GLuint*)", },
       ["glUniform2ui"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint, GLuint, GLuint)", },
       ["glUniform2uiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint, GLsizei, const GLuint*)", },
       ["glUniform3ui"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint, GLuint, GLuint, GLuint)", },
       ["glUniform3uiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint, GLsizei, const GLuint*)", },
       ["glUniform4ui"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint, GLuint, GLuint, GLuint, GLuint)", },
       ["glUniform4uiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint, GLsizei, const GLuint*)", },
       ["glVertexAttribI1i"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint, GLint)", },
       ["glVertexAttribI1iv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint, const GLint*)", },
       ["glVertexAttribI1ui"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint, GLuint)", },
       ["glVertexAttribI1uiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint, const GLuint*)", },
       ["glVertexAttribI2i"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint, GLint, GLint)", },
       ["glVertexAttribI2iv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint, const GLint*)", },
       ["glVertexAttribI2ui"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint, GLuint, GLuint)", },
       ["glVertexAttribI2uiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint, const GLuint*)", },
       ["glVertexAttribI3i"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint, GLint, GLint, GLint)", },
       ["glVertexAttribI3iv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint, const GLint*)", },
       ["glVertexAttribI3ui"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint, GLuint, GLuint, GLuint)", },
       ["glVertexAttribI3uiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint, const GLuint*)", },
       ["glVertexAttribI4bv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint, const GLbyte*)", },
       ["glVertexAttribI4i"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint, GLint, GLint, GLint, GLint)", },
       ["glVertexAttribI4iv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint, const GLint*)", },
       ["glVertexAttribI4sv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint, const GLshort*)", },
       ["glVertexAttribI4ubv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint, const GLubyte*)", },
       ["glVertexAttribI4ui"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint, GLuint, GLuint, GLuint, GLuint)", },
       ["glVertexAttribI4uiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint, const GLuint*)", },
       ["glVertexAttribI4usv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint, const GLushort*)", },
       ["glVertexAttribIPointer"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint, GLint, GLenum, GLsizei, const GLvoid*)", },
       ["glDrawArraysInstanced"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum, GLint, GLsizei, GLsizei)", },
       ["glDrawElementsInstanced"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum, GLsizei, GLenum, const GLvoid*, GLsizei)", },
       ["glPrimitiveRestartIndex"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint)", },
       ["glTexBuffer"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum, GLenum, GLuint)", },
       ["glFramebufferTexture"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum, GLenum, GLuint, GLint)", },
       ["glGetBufferParameteri64v"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum, GLenum, GLint64 *)", },
       ["glGetInteger64i_v"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum, GLuint, GLint64 *)", },
       ["glVertexAttribDivisor"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLuint divisor)", },
       ["glBlendEquationSeparatei"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint buf, GLenum modeRGB, GLenum modeAlpha)", },
       ["glBlendEquationi"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint buf, GLenum mode)", },
       ["glBlendFuncSeparatei"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha)", },
       ["glBlendFunci"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint buf, GLenum src, GLenum dst)", },
       ["glMinSampleShading"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLclampf value)", },
       ["glDebugMessageEnableAMD"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum category, GLenum severity, GLsizei count, const GLuint* ids, GLboolean enabled)", },
       ["glBlendEquationIndexedAMD"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint buf, GLenum mode)", },
       ["glBlendEquationSeparateIndexedAMD"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint buf, GLenum modeRGB, GLenum modeAlpha)", },
       ["glBlendFuncIndexedAMD"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint buf, GLenum src, GLenum dst)", },
       ["glBlendFuncSeparateIndexedAMD"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint buf, GLenum srcRGB, GLenum dstRGB, GLenum srcAlpha, GLenum dstAlpha)", },
       ["glVertexAttribParameteriAMD"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLenum pname, GLint param)", },
       ["glDeleteNamesAMD"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum identifier, GLuint num, const GLuint* names)", },
       ["glGenNamesAMD"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum identifier, GLuint num, GLuint* names)", },
       ["glIsNameAMD"] = { type ='function',
          description = "",
          returns = "(GLboolean)",
          valuetype = nil,
          args = "(GLenum identifier, GLuint name)", },
       ["glBeginPerfMonitorAMD"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint monitor)", },
       ["glDeletePerfMonitorsAMD"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei n, GLuint* monitors)", },
       ["glEndPerfMonitorAMD"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint monitor)", },
       ["glGenPerfMonitorsAMD"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei n, GLuint* monitors)", },
       ["glGetPerfMonitorCounterDataAMD"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint monitor, GLenum pname, GLsizei dataSize, GLuint* data, GLint *bytesWritten)", },
       ["glGetPerfMonitorCounterInfoAMD"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint group, GLuint counter, GLenum pname, void* data)", },
       ["glGetPerfMonitorCounterStringAMD"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint group, GLuint counter, GLsizei bufSize, GLsizei* length, GLchar *counterString)", },
       ["glGetPerfMonitorCountersAMD"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint group, GLint* numCounters, GLint *maxActiveCounters, GLsizei countersSize, GLuint *counters)", },
       ["glGetPerfMonitorGroupStringAMD"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint group, GLsizei bufSize, GLsizei* length, GLchar *groupString)", },
       ["glGetPerfMonitorGroupsAMD"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint* numGroups, GLsizei groupsSize, GLuint *groups)", },
       ["glSelectPerfMonitorCountersAMD"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint monitor, GLboolean enable, GLuint group, GLint numCounters, GLuint* counterList)", },
       ["glSetMultisamplefvAMD"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum pname, GLuint index, const GLfloat* val)", },
       ["glTexStorageSparseAMD"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLsizei layers, GLbitfield flags)", },
       ["glTextureStorageSparseAMD"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target, GLenum internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLsizei layers, GLbitfield flags)", },
       ["glStencilOpValueAMD"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum face, GLuint value)", },
       ["glTessellationFactorAMD"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLfloat factor)", },
       ["glTessellationModeAMD"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum mode)", },
       ["glClearDepthf"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLclampf d)", },
       ["glDepthRangef"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLclampf n, GLclampf f)", },
       ["glGetShaderPrecisionFormat"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum shadertype, GLenum precisiontype, GLint* range, GLint *precision)", },
       ["glReleaseShaderCompiler"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(void)", },
       ["glShaderBinary"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei count, const GLuint* shaders, GLenum binaryformat, const GLvoid*binary, GLsizei length)", },
       ["glDrawArraysInstancedBaseInstance"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum mode, GLint first, GLsizei count, GLsizei primcount, GLuint baseinstance)", },
       ["glDrawElementsInstancedBaseInstance"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices, GLsizei primcount, GLuint baseinstance)", },
       ["glDrawElementsInstancedBaseVertexBaseInstance"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices, GLsizei primcount, GLint basevertex, GLuint baseinstance)", },
       ["glGetImageHandleARB"] = { type ='function',
          description = "",
          returns = "(GLuint64)",
          valuetype = nil,
          args = "(GLuint texture, GLint level, GLboolean layered, GLint layer, GLenum format)", },
       ["glGetTextureHandleARB"] = { type ='function',
          description = "",
          returns = "(GLuint64)",
          valuetype = nil,
          args = "(GLuint texture)", },
       ["glGetTextureSamplerHandleARB"] = { type ='function',
          description = "",
          returns = "(GLuint64)",
          valuetype = nil,
          args = "(GLuint texture, GLuint sampler)", },
       ["glGetVertexAttribLui64vARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLenum pname, GLuint64EXT* params)", },
       ["glIsImageHandleResidentARB"] = { type ='function',
          description = "",
          returns = "(GLboolean)",
          valuetype = nil,
          args = "(GLuint64 handle)", },
       ["glIsTextureHandleResidentARB"] = { type ='function',
          description = "",
          returns = "(GLboolean)",
          valuetype = nil,
          args = "(GLuint64 handle)", },
       ["glMakeImageHandleNonResidentARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint64 handle)", },
       ["glMakeImageHandleResidentARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint64 handle, GLenum access)", },
       ["glMakeTextureHandleNonResidentARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint64 handle)", },
       ["glMakeTextureHandleResidentARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint64 handle)", },
       ["glProgramUniformHandleui64ARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLuint64 value)", },
       ["glProgramUniformHandleui64vARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei count, const GLuint64* values)", },
       ["glUniformHandleui64ARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLuint64 value)", },
       ["glUniformHandleui64vARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLsizei count, const GLuint64* value)", },
       ["glVertexAttribL1ui64ARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLuint64EXT x)", },
       ["glVertexAttribL1ui64vARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, const GLuint64EXT* v)", },
       ["glBindFragDataLocationIndexed"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLuint colorNumber, GLuint index, const GLchar * name)", },
       ["glGetFragDataIndex"] = { type ='function',
          description = "",
          returns = "(GLint)",
          valuetype = nil,
          args = "(GLuint program, const GLchar * name)", },
       ["glBufferStorage"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLsizeiptr size, const GLvoid* data, GLbitfield flags)", },
       ["glNamedBufferStorageEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint buffer, GLsizeiptr size, const GLvoid* data, GLbitfield flags)", },
       ["glCreateSyncFromCLeventARB"] = { type ='function',
          description = "",
          returns = "(GLsync)",
          valuetype = nil,
          args = "(cl_context context, cl_event event, GLbitfield flags)", },
       ["glClearBufferData"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum internalformat, GLenum format, GLenum type, const GLvoid* data)", },
       ["glClearBufferSubData"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum internalformat, GLintptr offset, GLsizeiptr size, GLenum format, GLenum type, const GLvoid* data)", },
       ["glClearNamedBufferDataEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint buffer, GLenum internalformat, GLenum format, GLenum type, const GLvoid* data)", },
       ["glClearNamedBufferSubDataEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint buffer, GLenum internalformat, GLintptr offset, GLsizeiptr size, GLenum format, GLenum type, const GLvoid* data)", },
       ["glClearTexImage"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLint level, GLenum format, GLenum type, const GLvoid* data)", },
       ["glClearTexSubImage"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid* data)", },
       ["glDispatchCompute"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint num_groups_x, GLuint num_groups_y, GLuint num_groups_z)", },
       ["glDispatchComputeIndirect"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLintptr indirect)", },
       ["glDispatchComputeGroupSizeARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint num_groups_x, GLuint num_groups_y, GLuint num_groups_z, GLuint group_size_x, GLuint group_size_y, GLuint group_size_z)", },
       ["glCopyBufferSubData"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum readtarget, GLenum writetarget, GLintptr readoffset, GLintptr writeoffset, GLsizeiptr size)", },
       ["glCopyImageSubData"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint srcName, GLenum srcTarget, GLint srcLevel, GLint srcX, GLint srcY, GLint srcZ, GLuint dstName, GLenum dstTarget, GLint dstLevel, GLint dstX, GLint dstY, GLint dstZ, GLsizei srcWidth, GLsizei srcHeight, GLsizei srcDepth)", },
       ["glDrawElementsBaseVertex"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices, GLint basevertex)", },
       ["glDrawElementsInstancedBaseVertex"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices, GLsizei primcount, GLint basevertex)", },
       ["glDrawRangeElementsBaseVertex"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid *indices, GLint basevertex)", },
       ["glMultiDrawElementsBaseVertex"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum mode, const GLsizei* count, GLenum type, const GLvoid* const *indices, GLsizei primcount, const GLint *basevertex)", },
       ["glDrawArraysIndirect"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum mode, const GLvoid *indirect)", },
       ["glDrawElementsIndirect"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum mode, GLenum type, const GLvoid *indirect)", },
       ["glFramebufferParameteri"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum pname, GLint param)", },
       ["glGetFramebufferParameteriv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum pname, GLint* params)", },
       ["glGetNamedFramebufferParameterivEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint framebuffer, GLenum pname, GLint* params)", },
       ["glNamedFramebufferParameteriEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint framebuffer, GLenum pname, GLint param)", },
       ["glBindFramebuffer"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint framebuffer)", },
       ["glBindRenderbuffer"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint renderbuffer)", },
       ["glBlitFramebuffer"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter)", },
       ["glCheckFramebufferStatus"] = { type ='function',
          description = "",
          returns = "(GLenum)",
          valuetype = nil,
          args = "(GLenum target)", },
       ["glDeleteFramebuffers"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei n, const GLuint* framebuffers)", },
       ["glDeleteRenderbuffers"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei n, const GLuint* renderbuffers)", },
       ["glFramebufferRenderbuffer"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer)", },
       ["glFramebufferTexture1D"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level)", },
       ["glFramebufferTexture2D"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level)", },
       ["glFramebufferTexture3D"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint layer)", },
       ["glFramebufferTextureLayer"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target,GLenum attachment, GLuint texture,GLint level,GLint layer)", },
       ["glGenFramebuffers"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei n, GLuint* framebuffers)", },
       ["glGenRenderbuffers"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei n, GLuint* renderbuffers)", },
       ["glGenerateMipmap"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target)", },
       ["glGetFramebufferAttachmentParameteriv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum attachment, GLenum pname, GLint* params)", },
       ["glGetRenderbufferParameteriv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum pname, GLint* params)", },
       ["glIsFramebuffer"] = { type ='function',
          description = "",
          returns = "(GLboolean)",
          valuetype = nil,
          args = "(GLuint framebuffer)", },
       ["glIsRenderbuffer"] = { type ='function',
          description = "",
          returns = "(GLboolean)",
          valuetype = nil,
          args = "(GLuint renderbuffer)", },
       ["glRenderbufferStorage"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum internalformat, GLsizei width, GLsizei height)", },
       ["glRenderbufferStorageMultisample"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height)", },
       ["glFramebufferTextureFaceARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum attachment, GLuint texture, GLint level, GLenum face)", },
       ["glGetProgramBinary"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLsizei bufSize, GLsizei* length, GLenum *binaryFormat, GLvoid*binary)", },
       ["glProgramBinary"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLenum binaryFormat, const GLvoid *binary, GLsizei length)", },
       ["glProgramParameteri"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLenum pname, GLint value)", },
       ["glGetUniformdv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLdouble* params)", },
       ["glUniform1d"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLdouble x)", },
       ["glUniform1dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLsizei count, const GLdouble* value)", },
       ["glUniform2d"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLdouble x, GLdouble y)", },
       ["glUniform2dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLsizei count, const GLdouble* value)", },
       ["glUniform3d"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLdouble x, GLdouble y, GLdouble z)", },
       ["glUniform3dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLsizei count, const GLdouble* value)", },
       ["glUniform4d"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLdouble x, GLdouble y, GLdouble z, GLdouble w)", },
       ["glUniform4dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLsizei count, const GLdouble* value)", },
       ["glUniformMatrix2dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLsizei count, GLboolean transpose, const GLdouble* value)", },
       ["glUniformMatrix2x3dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLsizei count, GLboolean transpose, const GLdouble* value)", },
       ["glUniformMatrix2x4dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLsizei count, GLboolean transpose, const GLdouble* value)", },
       ["glUniformMatrix3dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLsizei count, GLboolean transpose, const GLdouble* value)", },
       ["glUniformMatrix3x2dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLsizei count, GLboolean transpose, const GLdouble* value)", },
       ["glUniformMatrix3x4dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLsizei count, GLboolean transpose, const GLdouble* value)", },
       ["glUniformMatrix4dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLsizei count, GLboolean transpose, const GLdouble* value)", },
       ["glUniformMatrix4x2dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLsizei count, GLboolean transpose, const GLdouble* value)", },
       ["glUniformMatrix4x3dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLsizei count, GLboolean transpose, const GLdouble* value)", },
       ["glColorSubTable"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLsizei start, GLsizei count, GLenum format, GLenum type, const GLvoid *data)", },
       ["glColorTable"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid *table)", },
       ["glColorTableParameterfv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum pname, const GLfloat *params)", },
       ["glColorTableParameteriv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum pname, const GLint *params)", },
       ["glConvolutionFilter1D"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid *image)", },
       ["glConvolutionFilter2D"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *image)", },
       ["glConvolutionParameterf"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum pname, GLfloat params)", },
       ["glConvolutionParameterfv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum pname, const GLfloat *params)", },
       ["glConvolutionParameteri"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum pname, GLint params)", },
       ["glConvolutionParameteriv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum pname, const GLint *params)", },
       ["glCopyColorSubTable"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLsizei start, GLint x, GLint y, GLsizei width)", },
       ["glCopyColorTable"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width)", },
       ["glCopyConvolutionFilter1D"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width)", },
       ["glCopyConvolutionFilter2D"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height)", },
       ["glGetColorTable"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum format, GLenum type, GLvoid *table)", },
       ["glGetColorTableParameterfv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum pname, GLfloat *params)", },
       ["glGetColorTableParameteriv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum pname, GLint *params)", },
       ["glGetConvolutionFilter"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum format, GLenum type, GLvoid *image)", },
       ["glGetConvolutionParameterfv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum pname, GLfloat *params)", },
       ["glGetConvolutionParameteriv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum pname, GLint *params)", },
       ["glGetHistogram"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid *values)", },
       ["glGetHistogramParameterfv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum pname, GLfloat *params)", },
       ["glGetHistogramParameteriv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum pname, GLint *params)", },
       ["glGetMinmax"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLboolean reset, GLenum format, GLenum types, GLvoid *values)", },
       ["glGetMinmaxParameterfv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum pname, GLfloat *params)", },
       ["glGetMinmaxParameteriv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum pname, GLint *params)", },
       ["glGetSeparableFilter"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum format, GLenum type, GLvoid *row, GLvoid *column, GLvoid *span)", },
       ["glHistogram"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLsizei width, GLenum internalformat, GLboolean sink)", },
       ["glMinmax"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum internalformat, GLboolean sink)", },
       ["glResetHistogram"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target)", },
       ["glResetMinmax"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target)", },
       ["glSeparableFilter2D"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *row, const GLvoid *column)", },
       ["glMultiDrawArraysIndirectCountARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum mode, const GLvoid *indirect, GLintptr drawcount, GLsizei maxdrawcount, GLsizei stride)", },
       ["glMultiDrawElementsIndirectCountARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum mode, GLenum type, const GLvoid *indirect, GLintptr drawcount, GLsizei maxdrawcount, GLsizei stride)", },
       ["glGetInternalformativ"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum internalformat, GLenum pname, GLsizei bufSize, GLint* params)", },
       ["glGetInternalformati64v"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum internalformat, GLenum pname, GLsizei bufSize, GLint64* params)", },
       ["glInvalidateBufferData"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint buffer)", },
       ["glInvalidateBufferSubData"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint buffer, GLintptr offset, GLsizeiptr length)", },
       ["glInvalidateFramebuffer"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLsizei numAttachments, const GLenum* attachments)", },
       ["glInvalidateSubFramebuffer"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLsizei numAttachments, const GLenum* attachments, GLint x, GLint y, GLsizei width, GLsizei height)", },
       ["glInvalidateTexImage"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLint level)", },
       ["glInvalidateTexSubImage"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth)", },
       ["glFlushMappedBufferRange"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLintptr offset, GLsizeiptr length)", },
       ["glMapBufferRange"] = { type ='function',
          description = "",
          returns = "(GLvoid *)",
          valuetype = nil,
          args = "(GLenum target, GLintptr offset, GLsizeiptr length, GLbitfield access)", },
       ["glCurrentPaletteMatrixARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint index)", },
       ["glMatrixIndexPointerARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint size, GLenum type, GLsizei stride, GLvoid *pointer)", },
       ["glMatrixIndexubvARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint size, GLubyte *indices)", },
       ["glMatrixIndexuivARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint size, GLuint *indices)", },
       ["glMatrixIndexusvARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint size, GLushort *indices)", },
       ["glBindBuffersBase"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint first, GLsizei count, const GLuint* buffers)", },
       ["glBindBuffersRange"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint first, GLsizei count, const GLuint* buffers, const GLintptr *offsets, const GLsizeiptr *sizes)", },
       ["glBindImageTextures"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint first, GLsizei count, const GLuint* textures)", },
       ["glBindSamplers"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint first, GLsizei count, const GLuint* samplers)", },
       ["glBindTextures"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint first, GLsizei count, const GLuint* textures)", },
       ["glBindVertexBuffers"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint first, GLsizei count, const GLuint* buffers, const GLintptr *offsets, const GLsizei *strides)", },
       ["glMultiDrawArraysIndirect"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum mode, const GLvoid *indirect, GLsizei primcount, GLsizei stride)", },
       ["glMultiDrawElementsIndirect"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum mode, GLenum type, const GLvoid *indirect, GLsizei primcount, GLsizei stride)", },
       ["glGetProgramInterfaceiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLenum programInterface, GLenum pname, GLint* params)", },
       ["glGetProgramResourceIndex"] = { type ='function',
          description = "",
          returns = "(GLuint)",
          valuetype = nil,
          args = "(GLuint program, GLenum programInterface, const GLchar* name)", },
       ["glGetProgramResourceLocation"] = { type ='function',
          description = "",
          returns = "(GLint)",
          valuetype = nil,
          args = "(GLuint program, GLenum programInterface, const GLchar* name)", },
       ["glGetProgramResourceLocationIndex"] = { type ='function',
          description = "",
          returns = "(GLint)",
          valuetype = nil,
          args = "(GLuint program, GLenum programInterface, const GLchar* name)", },
       ["glGetProgramResourceName"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLenum programInterface, GLuint index, GLsizei bufSize, GLsizei* length, GLchar *name)", },
       ["glGetProgramResourceiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLenum programInterface, GLuint index, GLsizei propCount, const GLenum* props, GLsizei bufSize, GLsizei *length, GLint *params)", },
       ["glProvokingVertex"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum mode)", },
       ["glGetGraphicsResetStatusARB"] = { type ='function',
          description = "",
          returns = "(GLenum)",
          valuetype = nil,
          args = "(void)", },
       ["glGetnColorTableARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum format, GLenum type, GLsizei bufSize, void* table)", },
       ["glGetnCompressedTexImageARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLint lod, GLsizei bufSize, void* img)", },
       ["glGetnConvolutionFilterARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum format, GLenum type, GLsizei bufSize, void* image)", },
       ["glGetnHistogramARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLboolean reset, GLenum format, GLenum type, GLsizei bufSize, void* values)", },
       ["glGetnMapdvARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum query, GLsizei bufSize, GLdouble* v)", },
       ["glGetnMapfvARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum query, GLsizei bufSize, GLfloat* v)", },
       ["glGetnMapivARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum query, GLsizei bufSize, GLint* v)", },
       ["glGetnMinmaxARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLboolean reset, GLenum format, GLenum type, GLsizei bufSize, void* values)", },
       ["glGetnPixelMapfvARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum map, GLsizei bufSize, GLfloat* values)", },
       ["glGetnPixelMapuivARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum map, GLsizei bufSize, GLuint* values)", },
       ["glGetnPixelMapusvARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum map, GLsizei bufSize, GLushort* values)", },
       ["glGetnPolygonStippleARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei bufSize, GLubyte* pattern)", },
       ["glGetnSeparableFilterARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum format, GLenum type, GLsizei rowBufSize, void* row, GLsizei columnBufSize, GLvoid*column, GLvoid*span)", },
       ["glGetnTexImageARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLint level, GLenum format, GLenum type, GLsizei bufSize, void* img)", },
       ["glGetnUniformdvARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei bufSize, GLdouble* params)", },
       ["glGetnUniformfvARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei bufSize, GLfloat* params)", },
       ["glGetnUniformivARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei bufSize, GLint* params)", },
       ["glGetnUniformuivARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei bufSize, GLuint* params)", },
       ["glReadnPixelsARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLsizei bufSize, void* data)", },
       ["glBindSampler"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint unit, GLuint sampler)", },
       ["glDeleteSamplers"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei count, const GLuint * samplers)", },
       ["glGenSamplers"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei count, GLuint* samplers)", },
       ["glGetSamplerParameterIiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint sampler, GLenum pname, GLint* params)", },
       ["glGetSamplerParameterIuiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint sampler, GLenum pname, GLuint* params)", },
       ["glGetSamplerParameterfv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint sampler, GLenum pname, GLfloat* params)", },
       ["glGetSamplerParameteriv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint sampler, GLenum pname, GLint* params)", },
       ["glIsSampler"] = { type ='function',
          description = "",
          returns = "(GLboolean)",
          valuetype = nil,
          args = "(GLuint sampler)", },
       ["glSamplerParameterIiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint sampler, GLenum pname, const GLint* params)", },
       ["glSamplerParameterIuiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint sampler, GLenum pname, const GLuint* params)", },
       ["glSamplerParameterf"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint sampler, GLenum pname, GLfloat param)", },
       ["glSamplerParameterfv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint sampler, GLenum pname, const GLfloat* params)", },
       ["glSamplerParameteri"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint sampler, GLenum pname, GLint param)", },
       ["glSamplerParameteriv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint sampler, GLenum pname, const GLint* params)", },
       ["glActiveShaderProgram"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint pipeline, GLuint program)", },
       ["glBindProgramPipeline"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint pipeline)", },
       ["glCreateShaderProgramv"] = { type ='function',
          description = "",
          returns = "(GLuint)",
          valuetype = nil,
          args = "(GLenum type, GLsizei count, const GLchar ** strings)", },
       ["glDeleteProgramPipelines"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei n, const GLuint* pipelines)", },
       ["glGenProgramPipelines"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei n, GLuint* pipelines)", },
       ["glGetProgramPipelineInfoLog"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint pipeline, GLsizei bufSize, GLsizei* length, GLchar *infoLog)", },
       ["glGetProgramPipelineiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint pipeline, GLenum pname, GLint* params)", },
       ["glIsProgramPipeline"] = { type ='function',
          description = "",
          returns = "(GLboolean)",
          valuetype = nil,
          args = "(GLuint pipeline)", },
       ["glProgramUniform1d"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLdouble x)", },
       ["glProgramUniform1dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei count, const GLdouble* value)", },
       ["glProgramUniform1f"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLfloat x)", },
       ["glProgramUniform1fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei count, const GLfloat* value)", },
       ["glProgramUniform1i"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLint x)", },
       ["glProgramUniform1iv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei count, const GLint* value)", },
       ["glProgramUniform1ui"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLuint x)", },
       ["glProgramUniform1uiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei count, const GLuint* value)", },
       ["glProgramUniform2d"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLdouble x, GLdouble y)", },
       ["glProgramUniform2dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei count, const GLdouble* value)", },
       ["glProgramUniform2f"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLfloat x, GLfloat y)", },
       ["glProgramUniform2fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei count, const GLfloat* value)", },
       ["glProgramUniform2i"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLint x, GLint y)", },
       ["glProgramUniform2iv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei count, const GLint* value)", },
       ["glProgramUniform2ui"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLuint x, GLuint y)", },
       ["glProgramUniform2uiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei count, const GLuint* value)", },
       ["glProgramUniform3d"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLdouble x, GLdouble y, GLdouble z)", },
       ["glProgramUniform3dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei count, const GLdouble* value)", },
       ["glProgramUniform3f"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLfloat x, GLfloat y, GLfloat z)", },
       ["glProgramUniform3fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei count, const GLfloat* value)", },
       ["glProgramUniform3i"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLint x, GLint y, GLint z)", },
       ["glProgramUniform3iv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei count, const GLint* value)", },
       ["glProgramUniform3ui"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLuint x, GLuint y, GLuint z)", },
       ["glProgramUniform3uiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei count, const GLuint* value)", },
       ["glProgramUniform4d"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLdouble x, GLdouble y, GLdouble z, GLdouble w)", },
       ["glProgramUniform4dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei count, const GLdouble* value)", },
       ["glProgramUniform4f"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLfloat x, GLfloat y, GLfloat z, GLfloat w)", },
       ["glProgramUniform4fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei count, const GLfloat* value)", },
       ["glProgramUniform4i"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLint x, GLint y, GLint z, GLint w)", },
       ["glProgramUniform4iv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei count, const GLint* value)", },
       ["glProgramUniform4ui"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLuint x, GLuint y, GLuint z, GLuint w)", },
       ["glProgramUniform4uiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei count, const GLuint* value)", },
       ["glProgramUniformMatrix2dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble* value)", },
       ["glProgramUniformMatrix2fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat* value)", },
       ["glProgramUniformMatrix2x3dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble* value)", },
       ["glProgramUniformMatrix2x3fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat* value)", },
       ["glProgramUniformMatrix2x4dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble* value)", },
       ["glProgramUniformMatrix2x4fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat* value)", },
       ["glProgramUniformMatrix3dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble* value)", },
       ["glProgramUniformMatrix3fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat* value)", },
       ["glProgramUniformMatrix3x2dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble* value)", },
       ["glProgramUniformMatrix3x2fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat* value)", },
       ["glProgramUniformMatrix3x4dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble* value)", },
       ["glProgramUniformMatrix3x4fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat* value)", },
       ["glProgramUniformMatrix4dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble* value)", },
       ["glProgramUniformMatrix4fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat* value)", },
       ["glProgramUniformMatrix4x2dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble* value)", },
       ["glProgramUniformMatrix4x2fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat* value)", },
       ["glProgramUniformMatrix4x3dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLdouble* value)", },
       ["glProgramUniformMatrix4x3fv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei count, GLboolean transpose, const GLfloat* value)", },
       ["glUseProgramStages"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint pipeline, GLbitfield stages, GLuint program)", },
       ["glValidateProgramPipeline"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint pipeline)", },
       ["glGetActiveAtomicCounterBufferiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLuint bufferIndex, GLenum pname, GLint* params)", },
       ["glBindImageTexture"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint unit, GLuint texture, GLint level, GLboolean layered, GLint layer, GLenum access, GLenum format)", },
       ["glMemoryBarrier"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLbitfield barriers)", },
       ["glAttachObjectARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLhandleARB containerObj, GLhandleARB obj)", },
       ["glCreateProgramObjectARB"] = { type ='function',
          description = "",
          returns = "(GLhandleARB)",
          valuetype = nil,
          args = "(void)", },
       ["glCreateShaderObjectARB"] = { type ='function',
          description = "",
          returns = "(GLhandleARB)",
          valuetype = nil,
          args = "(GLenum shaderType)", },
       ["glDeleteObjectARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLhandleARB obj)", },
       ["glDetachObjectARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLhandleARB containerObj, GLhandleARB attachedObj)", },
       ["glGetAttachedObjectsARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLhandleARB containerObj, GLsizei maxCount, GLsizei* count, GLhandleARB *obj)", },
       ["glGetHandleARB"] = { type ='function',
          description = "",
          returns = "(GLhandleARB)",
          valuetype = nil,
          args = "(GLenum pname)", },
       ["glGetInfoLogARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLhandleARB obj, GLsizei maxLength, GLsizei* length, GLcharARB *infoLog)", },
       ["glGetObjectParameterfvARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLhandleARB obj, GLenum pname, GLfloat* params)", },
       ["glGetObjectParameterivARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLhandleARB obj, GLenum pname, GLint* params)", },
       ["glUseProgramObjectARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLhandleARB programObj)", },
       ["glShaderStorageBlockBinding"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLuint storageBlockIndex, GLuint storageBlockBinding)", },
       ["glGetActiveSubroutineName"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLenum shadertype, GLuint index, GLsizei bufsize, GLsizei* length, GLchar *name)", },
       ["glGetActiveSubroutineUniformName"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLenum shadertype, GLuint index, GLsizei bufsize, GLsizei* length, GLchar *name)", },
       ["glGetActiveSubroutineUniformiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLenum shadertype, GLuint index, GLenum pname, GLint* values)", },
       ["glGetProgramStageiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLenum shadertype, GLenum pname, GLint* values)", },
       ["glGetSubroutineIndex"] = { type ='function',
          description = "",
          returns = "(GLuint)",
          valuetype = nil,
          args = "(GLuint program, GLenum shadertype, const GLchar* name)", },
       ["glGetSubroutineUniformLocation"] = { type ='function',
          description = "",
          returns = "(GLint)",
          valuetype = nil,
          args = "(GLuint program, GLenum shadertype, const GLchar* name)", },
       ["glGetUniformSubroutineuiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum shadertype, GLint location, GLuint* params)", },
       ["glUniformSubroutinesuiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum shadertype, GLsizei count, const GLuint* indices)", },
       ["glCompileShaderIncludeARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint shader, GLsizei count, const GLchar* const *path, const GLint *length)", },
       ["glDeleteNamedStringARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint namelen, const GLchar* name)", },
       ["glGetNamedStringARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint namelen, const GLchar* name, GLsizei bufSize, GLint *stringlen, GLchar *string)", },
       ["glGetNamedStringivARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint namelen, const GLchar* name, GLenum pname, GLint *params)", },
       ["glIsNamedStringARB"] = { type ='function',
          description = "",
          returns = "(GLboolean)",
          valuetype = nil,
          args = "(GLint namelen, const GLchar* name)", },
       ["glNamedStringARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum type, GLint namelen, const GLchar* name, GLint stringlen, const GLchar *string)", },
       ["glTexPageCommitmentARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLboolean commit)", },
       ["glTexturePageCommitmentEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLboolean commit)", },
       ["glClientWaitSync"] = { type ='function',
          description = "",
          returns = "(GLenum)",
          valuetype = nil,
          args = "(GLsync GLsync,GLbitfield flags,GLuint64 timeout)", },
       ["glDeleteSync"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsync GLsync)", },
       ["glFenceSync"] = { type ='function',
          description = "",
          returns = "(GLsync)",
          valuetype = nil,
          args = "(GLenum condition,GLbitfield flags)", },
       ["glGetInteger64v"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum pname, GLint64* params)", },
       ["glGetSynciv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsync GLsync,GLenum pname,GLsizei bufSize,GLsizei* length, GLint *values)", },
       ["glIsSync"] = { type ='function',
          description = "",
          returns = "(GLboolean)",
          valuetype = nil,
          args = "(GLsync GLsync)", },
       ["glWaitSync"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsync GLsync,GLbitfield flags,GLuint64 timeout)", },
       ["glPatchParameterfv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum pname, const GLfloat* values)", },
       ["glPatchParameteri"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum pname, GLint value)", },
       ["glTexBufferRange"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size)", },
       ["glTextureBufferRangeEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target, GLenum internalformat, GLuint buffer, GLintptr offset, GLsizeiptr size)", },
       ["glGetMultisamplefv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum pname, GLuint index, GLfloat* val)", },
       ["glSampleMaski"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLbitfield mask)", },
       ["glTexImage2DMultisample"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLsizei samples, GLint internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations)", },
       ["glTexImage3DMultisample"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLsizei samples, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations)", },
       ["glTexStorage1D"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width)", },
       ["glTexStorage2D"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height)", },
       ["glTexStorage3D"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth)", },
       ["glTextureStorage1DEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width)", },
       ["glTextureStorage2DEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height)", },
       ["glTextureStorage3DEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target, GLsizei levels, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth)", },
       ["glTexStorage2DMultisample"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations)", },
       ["glTexStorage3DMultisample"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations)", },
       ["glTextureStorage2DMultisampleEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations)", },
       ["glTextureStorage3DMultisampleEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations)", },
       ["glTextureView"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target, GLuint origtexture, GLenum internalformat, GLuint minlevel, GLuint numlevels, GLuint minlayer, GLuint numlayers)", },
       ["glGetQueryObjecti64v"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint id, GLenum pname, GLint64* params)", },
       ["glGetQueryObjectui64v"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint id, GLenum pname, GLuint64* params)", },
       ["glQueryCounter"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint id, GLenum target)", },
       ["glBindTransformFeedback"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint id)", },
       ["glDeleteTransformFeedbacks"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei n, const GLuint* ids)", },
       ["glDrawTransformFeedback"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum mode, GLuint id)", },
       ["glGenTransformFeedbacks"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei n, GLuint* ids)", },
       ["glIsTransformFeedback"] = { type ='function',
          description = "",
          returns = "(GLboolean)",
          valuetype = nil,
          args = "(GLuint id)", },
       ["glPauseTransformFeedback"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(void)", },
       ["glResumeTransformFeedback"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(void)", },
       ["glBeginQueryIndexed"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, GLuint id)", },
       ["glDrawTransformFeedbackStream"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum mode, GLuint id, GLuint stream)", },
       ["glEndQueryIndexed"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index)", },
       ["glGetQueryIndexediv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, GLenum pname, GLint* params)", },
       ["glDrawTransformFeedbackInstanced"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum mode, GLuint id, GLsizei primcount)", },
       ["glDrawTransformFeedbackStreamInstanced"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum mode, GLuint id, GLuint stream, GLsizei primcount)", },
       ["glBindBufferBase"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, GLuint buffer)", },
       ["glBindBufferRange"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size)", },
       ["glGetActiveUniformBlockName"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLuint uniformBlockIndex, GLsizei bufSize, GLsizei* length, GLchar* uniformBlockName)", },
       ["glGetActiveUniformBlockiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLuint uniformBlockIndex, GLenum pname, GLint* params)", },
       ["glGetActiveUniformName"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLuint uniformIndex, GLsizei bufSize, GLsizei* length, GLchar* uniformName)", },
       ["glGetActiveUniformsiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLsizei uniformCount, const GLuint* uniformIndices, GLenum pname, GLint* params)", },
       ["glGetIntegeri_v"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, GLint* data)", },
       ["glGetUniformBlockIndex"] = { type ='function',
          description = "",
          returns = "(GLuint)",
          valuetype = nil,
          args = "(GLuint program, const GLchar* uniformBlockName)", },
       ["glGetUniformIndices"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLsizei uniformCount, const GLchar** uniformNames, GLuint* uniformIndices)", },
       ["glUniformBlockBinding"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLuint uniformBlockIndex, GLuint uniformBlockBinding)", },
       ["glBindVertexArray"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint array)", },
       ["glDeleteVertexArrays"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei n, const GLuint* arrays)", },
       ["glGenVertexArrays"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei n, GLuint* arrays)", },
       ["glIsVertexArray"] = { type ='function',
          description = "",
          returns = "(GLboolean)",
          valuetype = nil,
          args = "(GLuint array)", },
       ["glGetVertexAttribLdv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLenum pname, GLdouble* params)", },
       ["glVertexAttribL1d"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLdouble x)", },
       ["glVertexAttribL1dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, const GLdouble* v)", },
       ["glVertexAttribL2d"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLdouble x, GLdouble y)", },
       ["glVertexAttribL2dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, const GLdouble* v)", },
       ["glVertexAttribL3d"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLdouble x, GLdouble y, GLdouble z)", },
       ["glVertexAttribL3dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, const GLdouble* v)", },
       ["glVertexAttribL4d"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)", },
       ["glVertexAttribL4dv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, const GLdouble* v)", },
       ["glVertexAttribLPointer"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLint size, GLenum type, GLsizei stride, const void* pointer)", },
       ["glBindVertexBuffer"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint bindingindex, GLuint buffer, GLintptr offset, GLsizei stride)", },
       ["glVertexAttribBinding"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint attribindex, GLuint bindingindex)", },
       ["glVertexAttribFormat"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint attribindex, GLint size, GLenum type, GLboolean normalized, GLuint relativeoffset)", },
       ["glVertexAttribIFormat"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset)", },
       ["glVertexAttribLFormat"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint attribindex, GLint size, GLenum type, GLuint relativeoffset)", },
       ["glVertexBindingDivisor"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint bindingindex, GLuint divisor)", },
       ["glVertexBlendARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint count)", },
       ["glWeightPointerARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint size, GLenum type, GLsizei stride, GLvoid *pointer)", },
       ["glWeightbvARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint size, GLbyte *weights)", },
       ["glWeightdvARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint size, GLdouble *weights)", },
       ["glWeightfvARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint size, GLfloat *weights)", },
       ["glWeightivARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint size, GLint *weights)", },
       ["glWeightsvARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint size, GLshort *weights)", },
       ["glWeightubvARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint size, GLubyte *weights)", },
       ["glWeightuivARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint size, GLuint *weights)", },
       ["glWeightusvARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint size, GLushort *weights)", },
       ["glBindProgramARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint program)", },
       ["glDeleteProgramsARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei n, const GLuint* programs)", },
       ["glGenProgramsARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei n, GLuint* programs)", },
       ["glGetProgramEnvParameterdvARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, GLdouble* params)", },
       ["glGetProgramEnvParameterfvARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, GLfloat* params)", },
       ["glGetProgramLocalParameterdvARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, GLdouble* params)", },
       ["glGetProgramLocalParameterfvARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, GLfloat* params)", },
       ["glGetProgramStringARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum pname, GLvoid *string)", },
       ["glProgramEnvParameter4dARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)", },
       ["glProgramEnvParameter4dvARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, const GLdouble* params)", },
       ["glProgramEnvParameter4fARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)", },
       ["glProgramEnvParameter4fvARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, const GLfloat* params)", },
       ["glProgramLocalParameter4dARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)", },
       ["glProgramLocalParameter4dvARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, const GLdouble* params)", },
       ["glProgramLocalParameter4fARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)", },
       ["glProgramLocalParameter4fvARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, const GLfloat* params)", },
       ["glProgramStringARB"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum format, GLsizei len, const GLvoid *string)", },
       ["glColorP3ui"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum type, GLuint color)", },
       ["glColorP3uiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum type, const GLuint* color)", },
       ["glColorP4ui"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum type, GLuint color)", },
       ["glColorP4uiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum type, const GLuint* color)", },
       ["glMultiTexCoordP1ui"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texture, GLenum type, GLuint coords)", },
       ["glMultiTexCoordP1uiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texture, GLenum type, const GLuint* coords)", },
       ["glMultiTexCoordP2ui"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texture, GLenum type, GLuint coords)", },
       ["glMultiTexCoordP2uiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texture, GLenum type, const GLuint* coords)", },
       ["glMultiTexCoordP3ui"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texture, GLenum type, GLuint coords)", },
       ["glMultiTexCoordP3uiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texture, GLenum type, const GLuint* coords)", },
       ["glMultiTexCoordP4ui"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texture, GLenum type, GLuint coords)", },
       ["glMultiTexCoordP4uiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texture, GLenum type, const GLuint* coords)", },
       ["glNormalP3ui"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum type, GLuint coords)", },
       ["glNormalP3uiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum type, const GLuint* coords)", },
       ["glSecondaryColorP3ui"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum type, GLuint color)", },
       ["glSecondaryColorP3uiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum type, const GLuint* color)", },
       ["glTexCoordP1ui"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum type, GLuint coords)", },
       ["glTexCoordP1uiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum type, const GLuint* coords)", },
       ["glTexCoordP2ui"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum type, GLuint coords)", },
       ["glTexCoordP2uiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum type, const GLuint* coords)", },
       ["glTexCoordP3ui"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum type, GLuint coords)", },
       ["glTexCoordP3uiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum type, const GLuint* coords)", },
       ["glTexCoordP4ui"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum type, GLuint coords)", },
       ["glTexCoordP4uiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum type, const GLuint* coords)", },
       ["glVertexAttribP1ui"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLenum type, GLboolean normalized, GLuint value)", },
       ["glVertexAttribP1uiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLenum type, GLboolean normalized, const GLuint* value)", },
       ["glVertexAttribP2ui"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLenum type, GLboolean normalized, GLuint value)", },
       ["glVertexAttribP2uiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLenum type, GLboolean normalized, const GLuint* value)", },
       ["glVertexAttribP3ui"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLenum type, GLboolean normalized, GLuint value)", },
       ["glVertexAttribP3uiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLenum type, GLboolean normalized, const GLuint* value)", },
       ["glVertexAttribP4ui"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLenum type, GLboolean normalized, GLuint value)", },
       ["glVertexAttribP4uiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLenum type, GLboolean normalized, const GLuint* value)", },
       ["glVertexP2ui"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum type, GLuint value)", },
       ["glVertexP2uiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum type, const GLuint* value)", },
       ["glVertexP3ui"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum type, GLuint value)", },
       ["glVertexP3uiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum type, const GLuint* value)", },
       ["glVertexP4ui"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum type, GLuint value)", },
       ["glVertexP4uiv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum type, const GLuint* value)", },
       ["glDepthRangeArrayv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint first, GLsizei count, const GLclampd * v)", },
       ["glDepthRangeIndexed"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLclampd n, GLclampd f)", },
       ["glGetDoublei_v"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, GLdouble* data)", },
       ["glGetFloati_v"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, GLfloat* data)", },
       ["glScissorArrayv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint first, GLsizei count, const GLint * v)", },
       ["glScissorIndexed"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLint left, GLint bottom, GLsizei width, GLsizei height)", },
       ["glScissorIndexedv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, const GLint * v)", },
       ["glViewportArrayv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint first, GLsizei count, const GLfloat * v)", },
       ["glViewportIndexedf"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLfloat x, GLfloat y, GLfloat w, GLfloat h)", },
       ["glViewportIndexedfv"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, const GLfloat * v)", },
       ["glBindMultiTextureEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum target, GLuint texture)", },
       ["glCheckNamedFramebufferStatusEXT"] = { type ='function',
          description = "",
          returns = "(GLenum)",
          valuetype = nil,
          args = "(GLuint framebuffer, GLenum target)", },
       ["glClientAttribDefaultEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLbitfield mask)", },
       ["glCompressedMultiTexImage1DEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const GLvoid *data)", },
       ["glCompressedMultiTexImage2DEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid *data)", },
       ["glCompressedMultiTexImage3DEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid *data)", },
       ["glCompressedMultiTexSubImage1DEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid *data)", },
       ["glCompressedMultiTexSubImage2DEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid *data)", },
       ["glCompressedMultiTexSubImage3DEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid *data)", },
       ["glCompressedTextureImage1DEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const GLvoid *data)", },
       ["glCompressedTextureImage2DEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid *data)", },
       ["glCompressedTextureImage3DEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid *data)", },
       ["glCompressedTextureSubImage1DEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid *data)", },
       ["glCompressedTextureSubImage2DEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid *data)", },
       ["glCompressedTextureSubImage3DEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid *data)", },
       ["glCopyMultiTexImage1DEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border)", },
       ["glCopyMultiTexImage2DEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border)", },
       ["glCopyMultiTexSubImage1DEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width)", },
       ["glCopyMultiTexSubImage2DEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height)", },
       ["glCopyMultiTexSubImage3DEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height)", },
       ["glCopyTextureImage1DEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border)", },
       ["glCopyTextureImage2DEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border)", },
       ["glCopyTextureSubImage1DEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width)", },
       ["glCopyTextureSubImage2DEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height)", },
       ["glCopyTextureSubImage3DEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height)", },
       ["glDisableClientStateIndexedEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum array, GLuint index)", },
       ["glDisableClientStateiEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum array, GLuint index)", },
       ["glDisableVertexArrayAttribEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint vaobj, GLuint index)", },
       ["glDisableVertexArrayEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint vaobj, GLenum array)", },
       ["glEnableClientStateIndexedEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum array, GLuint index)", },
       ["glEnableClientStateiEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum array, GLuint index)", },
       ["glEnableVertexArrayAttribEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint vaobj, GLuint index)", },
       ["glEnableVertexArrayEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint vaobj, GLenum array)", },
       ["glFlushMappedNamedBufferRangeEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint buffer, GLintptr offset, GLsizeiptr length)", },
       ["glFramebufferDrawBufferEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint framebuffer, GLenum mode)", },
       ["glFramebufferDrawBuffersEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint framebuffer, GLsizei n, const GLenum* bufs)", },
       ["glFramebufferReadBufferEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint framebuffer, GLenum mode)", },
       ["glGenerateMultiTexMipmapEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum target)", },
       ["glGenerateTextureMipmapEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target)", },
       ["glGetCompressedMultiTexImageEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum target, GLint level, GLvoid *img)", },
       ["glGetCompressedTextureImageEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target, GLint level, GLvoid *img)", },
       ["glGetDoubleIndexedvEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, GLdouble* params)", },
       ["glGetFloatIndexedvEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, GLfloat* params)", },
       ["glGetMultiTexEnvfvEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum target, GLenum pname, GLfloat* params)", },
       ["glGetMultiTexEnvivEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum target, GLenum pname, GLint* params)", },
       ["glGetMultiTexGendvEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum coord, GLenum pname, GLdouble* params)", },
       ["glGetMultiTexGenfvEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum coord, GLenum pname, GLfloat* params)", },
       ["glGetMultiTexGenivEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum coord, GLenum pname, GLint* params)", },
       ["glGetMultiTexImageEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels)", },
       ["glGetMultiTexLevelParameterfvEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum target, GLint level, GLenum pname, GLfloat* params)", },
       ["glGetMultiTexLevelParameterivEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum target, GLint level, GLenum pname, GLint* params)", },
       ["glGetMultiTexParameterIivEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum target, GLenum pname, GLint* params)", },
       ["glGetMultiTexParameterIuivEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum target, GLenum pname, GLuint* params)", },
       ["glGetMultiTexParameterfvEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum target, GLenum pname, GLfloat* params)", },
       ["glGetMultiTexParameterivEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum target, GLenum pname, GLint* params)", },
       ["glGetNamedBufferParameterivEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint buffer, GLenum pname, GLint* params)", },
       ["glGetNamedBufferPointervEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint buffer, GLenum pname, void** params)", },
       ["glGetNamedBufferSubDataEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint buffer, GLintptr offset, GLsizeiptr size, GLvoid *data)", },
       ["glGetNamedFramebufferAttachmentParameterivEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint framebuffer, GLenum attachment, GLenum pname, GLint* params)", },
       ["glGetNamedProgramLocalParameterIivEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLenum target, GLuint index, GLint* params)", },
       ["glGetNamedProgramLocalParameterIuivEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLenum target, GLuint index, GLuint* params)", },
       ["glGetNamedProgramLocalParameterdvEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLenum target, GLuint index, GLdouble* params)", },
       ["glGetNamedProgramLocalParameterfvEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLenum target, GLuint index, GLfloat* params)", },
       ["glGetNamedProgramStringEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLenum target, GLenum pname, GLvoid *string)", },
       ["glGetNamedProgramivEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLenum target, GLenum pname, GLint* params)", },
       ["glGetNamedRenderbufferParameterivEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint renderbuffer, GLenum pname, GLint* params)", },
       ["glGetPointerIndexedvEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, GLvoid** params)", },
       ["glGetPointeri_vEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum pname, GLuint index, GLvoid** params)", },
       ["glGetTextureImageEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels)", },
       ["glGetTextureLevelParameterfvEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target, GLint level, GLenum pname, GLfloat* params)", },
       ["glGetTextureLevelParameterivEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target, GLint level, GLenum pname, GLint* params)", },
       ["glGetTextureParameterIivEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target, GLenum pname, GLint* params)", },
       ["glGetTextureParameterIuivEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target, GLenum pname, GLuint* params)", },
       ["glGetTextureParameterfvEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target, GLenum pname, GLfloat* params)", },
       ["glGetTextureParameterivEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target, GLenum pname, GLint* params)", },
       ["glGetVertexArrayIntegeri_vEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint vaobj, GLuint index, GLenum pname, GLint* param)", },
       ["glGetVertexArrayIntegervEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint vaobj, GLenum pname, GLint* param)", },
       ["glGetVertexArrayPointeri_vEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint vaobj, GLuint index, GLenum pname, GLvoid** param)", },
       ["glGetVertexArrayPointervEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint vaobj, GLenum pname, GLvoid** param)", },
       ["glMapNamedBufferEXT"] = { type ='function',
          description = "",
          returns = "(GLvoid *)",
          valuetype = nil,
          args = "(GLuint buffer, GLenum access)", },
       ["glMapNamedBufferRangeEXT"] = { type ='function',
          description = "",
          returns = "(GLvoid *)",
          valuetype = nil,
          args = "(GLuint buffer, GLintptr offset, GLsizeiptr length, GLbitfield access)", },
       ["glMatrixFrustumEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum matrixMode, GLdouble l, GLdouble r, GLdouble b, GLdouble t, GLdouble n, GLdouble f)", },
       ["glMatrixLoadIdentityEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum matrixMode)", },
       ["glMatrixLoadTransposedEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum matrixMode, const GLdouble* m)", },
       ["glMatrixLoadTransposefEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum matrixMode, const GLfloat* m)", },
       ["glMatrixLoaddEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum matrixMode, const GLdouble* m)", },
       ["glMatrixLoadfEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum matrixMode, const GLfloat* m)", },
       ["glMatrixMultTransposedEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum matrixMode, const GLdouble* m)", },
       ["glMatrixMultTransposefEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum matrixMode, const GLfloat* m)", },
       ["glMatrixMultdEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum matrixMode, const GLdouble* m)", },
       ["glMatrixMultfEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum matrixMode, const GLfloat* m)", },
       ["glMatrixOrthoEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum matrixMode, GLdouble l, GLdouble r, GLdouble b, GLdouble t, GLdouble n, GLdouble f)", },
       ["glMatrixPopEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum matrixMode)", },
       ["glMatrixPushEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum matrixMode)", },
       ["glMatrixRotatedEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum matrixMode, GLdouble angle, GLdouble x, GLdouble y, GLdouble z)", },
       ["glMatrixRotatefEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum matrixMode, GLfloat angle, GLfloat x, GLfloat y, GLfloat z)", },
       ["glMatrixScaledEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum matrixMode, GLdouble x, GLdouble y, GLdouble z)", },
       ["glMatrixScalefEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum matrixMode, GLfloat x, GLfloat y, GLfloat z)", },
       ["glMatrixTranslatedEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum matrixMode, GLdouble x, GLdouble y, GLdouble z)", },
       ["glMatrixTranslatefEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum matrixMode, GLfloat x, GLfloat y, GLfloat z)", },
       ["glMultiTexBufferEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum target, GLenum internalformat, GLuint buffer)", },
       ["glMultiTexCoordPointerEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLint size, GLenum type, GLsizei stride, const GLvoid *pointer)", },
       ["glMultiTexEnvfEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum target, GLenum pname, GLfloat param)", },
       ["glMultiTexEnvfvEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum target, GLenum pname, const GLfloat* params)", },
       ["glMultiTexEnviEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum target, GLenum pname, GLint param)", },
       ["glMultiTexEnvivEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum target, GLenum pname, const GLint* params)", },
       ["glMultiTexGendEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum coord, GLenum pname, GLdouble param)", },
       ["glMultiTexGendvEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum coord, GLenum pname, const GLdouble* params)", },
       ["glMultiTexGenfEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum coord, GLenum pname, GLfloat param)", },
       ["glMultiTexGenfvEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum coord, GLenum pname, const GLfloat* params)", },
       ["glMultiTexGeniEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum coord, GLenum pname, GLint param)", },
       ["glMultiTexGenivEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum coord, GLenum pname, const GLint* params)", },
       ["glMultiTexImage1DEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels)", },
       ["glMultiTexImage2DEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels)", },
       ["glMultiTexImage3DEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid *pixels)", },
       ["glMultiTexParameterIivEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum target, GLenum pname, const GLint* params)", },
       ["glMultiTexParameterIuivEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum target, GLenum pname, const GLuint* params)", },
       ["glMultiTexParameterfEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum target, GLenum pname, GLfloat param)", },
       ["glMultiTexParameterfvEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum target, GLenum pname, const GLfloat* param)", },
       ["glMultiTexParameteriEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum target, GLenum pname, GLint param)", },
       ["glMultiTexParameterivEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum target, GLenum pname, const GLint* param)", },
       ["glMultiTexRenderbufferEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum target, GLuint renderbuffer)", },
       ["glMultiTexSubImage1DEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels)", },
       ["glMultiTexSubImage2DEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels)", },
       ["glMultiTexSubImage3DEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texunit, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid *pixels)", },
       ["glNamedBufferDataEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint buffer, GLsizeiptr size, const GLvoid *data, GLenum usage)", },
       ["glNamedBufferSubDataEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint buffer, GLintptr offset, GLsizeiptr size, const GLvoid *data)", },
       ["glNamedCopyBufferSubDataEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint readBuffer, GLuint writeBuffer, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size)", },
       ["glNamedFramebufferRenderbufferEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint framebuffer, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer)", },
       ["glNamedFramebufferTexture1DEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint framebuffer, GLenum attachment, GLenum textarget, GLuint texture, GLint level)", },
       ["glNamedFramebufferTexture2DEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint framebuffer, GLenum attachment, GLenum textarget, GLuint texture, GLint level)", },
       ["glNamedFramebufferTexture3DEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint framebuffer, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset)", },
       ["glNamedFramebufferTextureEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level)", },
       ["glNamedFramebufferTextureFaceEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level, GLenum face)", },
       ["glNamedFramebufferTextureLayerEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint framebuffer, GLenum attachment, GLuint texture, GLint level, GLint layer)", },
       ["glNamedProgramLocalParameter4dEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)", },
       ["glNamedProgramLocalParameter4dvEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLenum target, GLuint index, const GLdouble* params)", },
       ["glNamedProgramLocalParameter4fEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)", },
       ["glNamedProgramLocalParameter4fvEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLenum target, GLuint index, const GLfloat* params)", },
       ["glNamedProgramLocalParameterI4iEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLenum target, GLuint index, GLint x, GLint y, GLint z, GLint w)", },
       ["glNamedProgramLocalParameterI4ivEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLenum target, GLuint index, const GLint* params)", },
       ["glNamedProgramLocalParameterI4uiEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLenum target, GLuint index, GLuint x, GLuint y, GLuint z, GLuint w)", },
       ["glNamedProgramLocalParameterI4uivEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLenum target, GLuint index, const GLuint* params)", },
       ["glNamedProgramLocalParameters4fvEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLenum target, GLuint index, GLsizei count, const GLfloat* params)", },
       ["glNamedProgramLocalParametersI4ivEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLenum target, GLuint index, GLsizei count, const GLint* params)", },
       ["glNamedProgramLocalParametersI4uivEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLenum target, GLuint index, GLsizei count, const GLuint* params)", },
       ["glNamedProgramStringEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLenum target, GLenum format, GLsizei len, const GLvoid *string)", },
       ["glNamedRenderbufferStorageEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint renderbuffer, GLenum internalformat, GLsizei width, GLsizei height)", },
       ["glNamedRenderbufferStorageMultisampleCoverageEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint renderbuffer, GLsizei coverageSamples, GLsizei colorSamples, GLenum internalformat, GLsizei width, GLsizei height)", },
       ["glNamedRenderbufferStorageMultisampleEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint renderbuffer, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height)", },
       ["glPushClientAttribDefaultEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLbitfield mask)", },
       ["glTextureBufferEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target, GLenum internalformat, GLuint buffer)", },
       ["glTextureImage1DEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels)", },
       ["glTextureImage2DEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels)", },
       ["glTextureImage3DEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid *pixels)", },
       ["glTextureParameterIivEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target, GLenum pname, const GLint* params)", },
       ["glTextureParameterIuivEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target, GLenum pname, const GLuint* params)", },
       ["glTextureParameterfEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target, GLenum pname, GLfloat param)", },
       ["glTextureParameterfvEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target, GLenum pname, const GLfloat* param)", },
       ["glTextureParameteriEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target, GLenum pname, GLint param)", },
       ["glTextureParameterivEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target, GLenum pname, const GLint* param)", },
       ["glTextureRenderbufferEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target, GLuint renderbuffer)", },
       ["glTextureSubImage1DEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels)", },
       ["glTextureSubImage2DEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels)", },
       ["glTextureSubImage3DEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid *pixels)", },
       ["glUnmapNamedBufferEXT"] = { type ='function',
          description = "",
          returns = "(GLboolean)",
          valuetype = nil,
          args = "(GLuint buffer)", },
       ["glVertexArrayColorOffsetEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint vaobj, GLuint buffer, GLint size, GLenum type, GLsizei stride, GLintptr offset)", },
       ["glVertexArrayEdgeFlagOffsetEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint vaobj, GLuint buffer, GLsizei stride, GLintptr offset)", },
       ["glVertexArrayFogCoordOffsetEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint vaobj, GLuint buffer, GLenum type, GLsizei stride, GLintptr offset)", },
       ["glVertexArrayIndexOffsetEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint vaobj, GLuint buffer, GLenum type, GLsizei stride, GLintptr offset)", },
       ["glVertexArrayMultiTexCoordOffsetEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint vaobj, GLuint buffer, GLenum texunit, GLint size, GLenum type, GLsizei stride, GLintptr offset)", },
       ["glVertexArrayNormalOffsetEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint vaobj, GLuint buffer, GLenum type, GLsizei stride, GLintptr offset)", },
       ["glVertexArraySecondaryColorOffsetEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint vaobj, GLuint buffer, GLint size, GLenum type, GLsizei stride, GLintptr offset)", },
       ["glVertexArrayTexCoordOffsetEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint vaobj, GLuint buffer, GLint size, GLenum type, GLsizei stride, GLintptr offset)", },
       ["glVertexArrayVertexAttribIOffsetEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint vaobj, GLuint buffer, GLuint index, GLint size, GLenum type, GLsizei stride, GLintptr offset)", },
       ["glVertexArrayVertexAttribOffsetEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint vaobj, GLuint buffer, GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, GLintptr offset)", },
       ["glVertexArrayVertexOffsetEXT"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint vaobj, GLuint buffer, GLint size, GLenum type, GLsizei stride, GLintptr offset)", },
       ["glDebugMessageCallback"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLDEBUGPROC callback, const GLvoid *userParam)", },
       ["glDebugMessageControl"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum source, GLenum type, GLenum severity, GLsizei count, const GLuint* ids, GLboolean enabled)", },
       ["glDebugMessageInsert"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum source, GLenum type, GLuint id, GLenum severity, GLsizei length, const GLchar* buf)", },
       ["glGetDebugMessageLog"] = { type ='function',
          description = "",
          returns = "(GLuint)",
          valuetype = nil,
          args = "(GLuint count, GLsizei bufsize, GLenum* sources, GLenum* types, GLuint* ids, GLenum* severities, GLsizei* lengths, GLchar* messageLog)", },
       ["glGetObjectLabel"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum identifier, GLuint name, GLsizei bufSize, GLsizei* length, GLchar *label)", },
       ["glGetObjectPtrLabel"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(void* ptr, GLsizei bufSize, GLsizei* length, GLchar *label)", },
       ["glObjectLabel"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum identifier, GLuint name, GLsizei length, const GLchar* label)", },
       ["glObjectPtrLabel"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(void* ptr, GLsizei length, const GLchar* label)", },
       ["glPopDebugGroup"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(void)", },
       ["glPushDebugGroup"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum source, GLuint id, GLsizei length, const GLchar * message)", },
       ["glMultiDrawArraysIndirectBindlessNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum mode, const GLvoid *indirect, GLsizei drawCount, GLsizei stride, GLint vertexBufferCount)", },
       ["glMultiDrawElementsIndirectBindlessNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum mode, GLenum type, const GLvoid *indirect, GLsizei drawCount, GLsizei stride, GLint vertexBufferCount)", },
       ["glGetImageHandleNV"] = { type ='function',
          description = "",
          returns = "(GLuint64)",
          valuetype = nil,
          args = "(GLuint texture, GLint level, GLboolean layered, GLint layer, GLenum format)", },
       ["glGetTextureHandleNV"] = { type ='function',
          description = "",
          returns = "(GLuint64)",
          valuetype = nil,
          args = "(GLuint texture)", },
       ["glGetTextureSamplerHandleNV"] = { type ='function',
          description = "",
          returns = "(GLuint64)",
          valuetype = nil,
          args = "(GLuint texture, GLuint sampler)", },
       ["glIsImageHandleResidentNV"] = { type ='function',
          description = "",
          returns = "(GLboolean)",
          valuetype = nil,
          args = "(GLuint64 handle)", },
       ["glIsTextureHandleResidentNV"] = { type ='function',
          description = "",
          returns = "(GLboolean)",
          valuetype = nil,
          args = "(GLuint64 handle)", },
       ["glMakeImageHandleNonResidentNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint64 handle)", },
       ["glMakeImageHandleResidentNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint64 handle, GLenum access)", },
       ["glMakeTextureHandleNonResidentNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint64 handle)", },
       ["glMakeTextureHandleResidentNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint64 handle)", },
       ["glProgramUniformHandleui64NV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLuint64 value)", },
       ["glProgramUniformHandleui64vNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei count, const GLuint64* values)", },
       ["glUniformHandleui64NV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLuint64 value)", },
       ["glUniformHandleui64vNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLsizei count, const GLuint64* value)", },
       ["glBlendBarrierNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(void)", },
       ["glBlendParameteriNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum pname, GLint value)", },
       ["glClearDepthdNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLdouble depth)", },
       ["glDepthBoundsdNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLdouble zmin, GLdouble zmax)", },
       ["glDepthRangedNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLdouble zNear, GLdouble zFar)", },
       ["glDrawTextureNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLuint sampler, GLfloat x0, GLfloat y0, GLfloat x1, GLfloat y1, GLfloat z, GLfloat s0, GLfloat t0, GLfloat s1, GLfloat t1)", },
       ["glEvalMapsNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum mode)", },
       ["glGetMapAttribParameterfvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, GLenum pname, GLfloat* params)", },
       ["glGetMapAttribParameterivNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, GLenum pname, GLint* params)", },
       ["glGetMapControlPointsNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, GLenum type, GLsizei ustride, GLsizei vstride, GLboolean packed, GLvoid *points)", },
       ["glGetMapParameterfvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum pname, GLfloat* params)", },
       ["glGetMapParameterivNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum pname, GLint* params)", },
       ["glMapControlPointsNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, GLenum type, GLsizei ustride, GLsizei vstride, GLint uorder, GLint vorder, GLboolean packed, const GLvoid *points)", },
       ["glMapParameterfvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum pname, const GLfloat* params)", },
       ["glMapParameterivNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum pname, const GLint* params)", },
       ["glSampleMaskIndexedNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLbitfield mask)", },
       ["glTexRenderbufferNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint renderbuffer)", },
       ["glDeleteFencesNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei n, const GLuint* fences)", },
       ["glFinishFenceNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint fence)", },
       ["glGenFencesNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei n, GLuint* fences)", },
       ["glGetFenceivNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint fence, GLenum pname, GLint* params)", },
       ["glIsFenceNV"] = { type ='function',
          description = "",
          returns = "(GLboolean)",
          valuetype = nil,
          args = "(GLuint fence)", },
       ["glSetFenceNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint fence, GLenum condition)", },
       ["glTestFenceNV"] = { type ='function',
          description = "",
          returns = "(GLboolean)",
          valuetype = nil,
          args = "(GLuint fence)", },
       ["glGetProgramNamedParameterdvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint id, GLsizei len, const GLubyte* name, GLdouble *params)", },
       ["glGetProgramNamedParameterfvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint id, GLsizei len, const GLubyte* name, GLfloat *params)", },
       ["glProgramNamedParameter4dNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint id, GLsizei len, const GLubyte* name, GLdouble x, GLdouble y, GLdouble z, GLdouble w)", },
       ["glProgramNamedParameter4dvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint id, GLsizei len, const GLubyte* name, const GLdouble v[])", },
       ["glProgramNamedParameter4fNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint id, GLsizei len, const GLubyte* name, GLfloat x, GLfloat y, GLfloat z, GLfloat w)", },
       ["glProgramNamedParameter4fvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint id, GLsizei len, const GLubyte* name, const GLfloat v[])", },
       ["glRenderbufferStorageMultisampleCoverageNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLenum internalformat, GLsizei width, GLsizei height)", },
       ["glProgramVertexLimitNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLint limit)", },
       ["glProgramEnvParameterI4iNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, GLint x, GLint y, GLint z, GLint w)", },
       ["glProgramEnvParameterI4ivNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, const GLint *params)", },
       ["glProgramEnvParameterI4uiNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, GLuint x, GLuint y, GLuint z, GLuint w)", },
       ["glProgramEnvParameterI4uivNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, const GLuint *params)", },
       ["glProgramEnvParametersI4ivNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, GLsizei count, const GLint *params)", },
       ["glProgramEnvParametersI4uivNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, GLsizei count, const GLuint *params)", },
       ["glProgramLocalParameterI4iNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, GLint x, GLint y, GLint z, GLint w)", },
       ["glProgramLocalParameterI4ivNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, const GLint *params)", },
       ["glProgramLocalParameterI4uiNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, GLuint x, GLuint y, GLuint z, GLuint w)", },
       ["glProgramLocalParameterI4uivNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, const GLuint *params)", },
       ["glProgramLocalParametersI4ivNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, GLsizei count, const GLint *params)", },
       ["glProgramLocalParametersI4uivNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, GLsizei count, const GLuint *params)", },
       ["glGetUniformi64vNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLint64EXT* params)", },
       ["glGetUniformui64vNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLuint64EXT* params)", },
       ["glProgramUniform1i64NV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLint64EXT x)", },
       ["glProgramUniform1i64vNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei count, const GLint64EXT* value)", },
       ["glProgramUniform1ui64NV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLuint64EXT x)", },
       ["glProgramUniform1ui64vNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei count, const GLuint64EXT* value)", },
       ["glProgramUniform2i64NV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLint64EXT x, GLint64EXT y)", },
       ["glProgramUniform2i64vNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei count, const GLint64EXT* value)", },
       ["glProgramUniform2ui64NV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLuint64EXT x, GLuint64EXT y)", },
       ["glProgramUniform2ui64vNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei count, const GLuint64EXT* value)", },
       ["glProgramUniform3i64NV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z)", },
       ["glProgramUniform3i64vNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei count, const GLint64EXT* value)", },
       ["glProgramUniform3ui64NV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z)", },
       ["glProgramUniform3ui64vNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei count, const GLuint64EXT* value)", },
       ["glProgramUniform4i64NV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z, GLint64EXT w)", },
       ["glProgramUniform4i64vNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei count, const GLint64EXT* value)", },
       ["glProgramUniform4ui64NV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, GLuint64EXT w)", },
       ["glProgramUniform4ui64vNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei count, const GLuint64EXT* value)", },
       ["glUniform1i64NV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLint64EXT x)", },
       ["glUniform1i64vNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLsizei count, const GLint64EXT* value)", },
       ["glUniform1ui64NV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLuint64EXT x)", },
       ["glUniform1ui64vNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLsizei count, const GLuint64EXT* value)", },
       ["glUniform2i64NV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLint64EXT x, GLint64EXT y)", },
       ["glUniform2i64vNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLsizei count, const GLint64EXT* value)", },
       ["glUniform2ui64NV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLuint64EXT x, GLuint64EXT y)", },
       ["glUniform2ui64vNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLsizei count, const GLuint64EXT* value)", },
       ["glUniform3i64NV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z)", },
       ["glUniform3i64vNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLsizei count, const GLint64EXT* value)", },
       ["glUniform3ui64NV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z)", },
       ["glUniform3ui64vNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLsizei count, const GLuint64EXT* value)", },
       ["glUniform4i64NV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z, GLint64EXT w)", },
       ["glUniform4i64vNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLsizei count, const GLint64EXT* value)", },
       ["glUniform4ui64NV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, GLuint64EXT w)", },
       ["glUniform4ui64vNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLsizei count, const GLuint64EXT* value)", },
       ["glColor3hNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLhalf red, GLhalf green, GLhalf blue)", },
       ["glColor3hvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLhalf* v)", },
       ["glColor4hNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLhalf red, GLhalf green, GLhalf blue, GLhalf alpha)", },
       ["glColor4hvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLhalf* v)", },
       ["glFogCoordhNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLhalf fog)", },
       ["glFogCoordhvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLhalf* fog)", },
       ["glMultiTexCoord1hNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLhalf s)", },
       ["glMultiTexCoord1hvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, const GLhalf* v)", },
       ["glMultiTexCoord2hNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLhalf s, GLhalf t)", },
       ["glMultiTexCoord2hvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, const GLhalf* v)", },
       ["glMultiTexCoord3hNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLhalf s, GLhalf t, GLhalf r)", },
       ["glMultiTexCoord3hvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, const GLhalf* v)", },
       ["glMultiTexCoord4hNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLhalf s, GLhalf t, GLhalf r, GLhalf q)", },
       ["glMultiTexCoord4hvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, const GLhalf* v)", },
       ["glNormal3hNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLhalf nx, GLhalf ny, GLhalf nz)", },
       ["glNormal3hvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLhalf* v)", },
       ["glSecondaryColor3hNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLhalf red, GLhalf green, GLhalf blue)", },
       ["glSecondaryColor3hvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLhalf* v)", },
       ["glTexCoord1hNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLhalf s)", },
       ["glTexCoord1hvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLhalf* v)", },
       ["glTexCoord2hNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLhalf s, GLhalf t)", },
       ["glTexCoord2hvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLhalf* v)", },
       ["glTexCoord3hNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLhalf s, GLhalf t, GLhalf r)", },
       ["glTexCoord3hvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLhalf* v)", },
       ["glTexCoord4hNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLhalf s, GLhalf t, GLhalf r, GLhalf q)", },
       ["glTexCoord4hvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLhalf* v)", },
       ["glVertex2hNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLhalf x, GLhalf y)", },
       ["glVertex2hvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLhalf* v)", },
       ["glVertex3hNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLhalf x, GLhalf y, GLhalf z)", },
       ["glVertex3hvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLhalf* v)", },
       ["glVertex4hNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLhalf x, GLhalf y, GLhalf z, GLhalf w)", },
       ["glVertex4hvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLhalf* v)", },
       ["glVertexAttrib1hNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLhalf x)", },
       ["glVertexAttrib1hvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, const GLhalf* v)", },
       ["glVertexAttrib2hNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLhalf x, GLhalf y)", },
       ["glVertexAttrib2hvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, const GLhalf* v)", },
       ["glVertexAttrib3hNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLhalf x, GLhalf y, GLhalf z)", },
       ["glVertexAttrib3hvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, const GLhalf* v)", },
       ["glVertexAttrib4hNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLhalf x, GLhalf y, GLhalf z, GLhalf w)", },
       ["glVertexAttrib4hvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, const GLhalf* v)", },
       ["glVertexAttribs1hvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLsizei n, const GLhalf* v)", },
       ["glVertexAttribs2hvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLsizei n, const GLhalf* v)", },
       ["glVertexAttribs3hvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLsizei n, const GLhalf* v)", },
       ["glVertexAttribs4hvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLsizei n, const GLhalf* v)", },
       ["glVertexWeighthNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLhalf weight)", },
       ["glVertexWeighthvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const GLhalf* weight)", },
       ["glBeginOcclusionQueryNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint id)", },
       ["glDeleteOcclusionQueriesNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei n, const GLuint* ids)", },
       ["glEndOcclusionQueryNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(void)", },
       ["glGenOcclusionQueriesNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei n, GLuint* ids)", },
       ["glGetOcclusionQueryivNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint id, GLenum pname, GLint* params)", },
       ["glGetOcclusionQueryuivNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint id, GLenum pname, GLuint* params)", },
       ["glIsOcclusionQueryNV"] = { type ='function',
          description = "",
          returns = "(GLboolean)",
          valuetype = nil,
          args = "(GLuint id)", },
       ["glProgramBufferParametersIivNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint buffer, GLuint index, GLsizei count, const GLint *params)", },
       ["glProgramBufferParametersIuivNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint buffer, GLuint index, GLsizei count, const GLuint *params)", },
       ["glProgramBufferParametersfvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint buffer, GLuint index, GLsizei count, const GLfloat *params)", },
       ["glCopyPathNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint resultPath, GLuint srcPath)", },
       ["glCoverFillPathInstancedNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei numPaths, GLenum pathNameType, const void* paths, GLuint pathBase, GLenum coverMode, GLenum transformType, const GLfloat *transformValues)", },
       ["glCoverFillPathNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint path, GLenum coverMode)", },
       ["glCoverStrokePathInstancedNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei numPaths, GLenum pathNameType, const void* paths, GLuint pathBase, GLenum coverMode, GLenum transformType, const GLfloat *transformValues)", },
       ["glCoverStrokePathNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint name, GLenum coverMode)", },
       ["glDeletePathsNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint path, GLsizei range)", },
       ["glGenPathsNV"] = { type ='function',
          description = "",
          returns = "(GLuint)",
          valuetype = nil,
          args = "(GLsizei range)", },
       ["glGetPathColorGenfvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum color, GLenum pname, GLfloat* value)", },
       ["glGetPathColorGenivNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum color, GLenum pname, GLint* value)", },
       ["glGetPathCommandsNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint name, GLubyte* commands)", },
       ["glGetPathCoordsNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint name, GLfloat* coords)", },
       ["glGetPathDashArrayNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint name, GLfloat* dashArray)", },
       ["glGetPathLengthNV"] = { type ='function',
          description = "",
          returns = "(GLfloat)",
          valuetype = nil,
          args = "(GLuint path, GLsizei startSegment, GLsizei numSegments)", },
       ["glGetPathMetricRangeNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLbitfield metricQueryMask, GLuint fistPathName, GLsizei numPaths, GLsizei stride, GLfloat* metrics)", },
       ["glGetPathMetricsNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLbitfield metricQueryMask, GLsizei numPaths, GLenum pathNameType, const void* paths, GLuint pathBase, GLsizei stride, GLfloat *metrics)", },
       ["glGetPathParameterfvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint name, GLenum param, GLfloat* value)", },
       ["glGetPathParameterivNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint name, GLenum param, GLint* value)", },
       ["glGetPathSpacingNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum pathListMode, GLsizei numPaths, GLenum pathNameType, const void* paths, GLuint pathBase, GLfloat advanceScale, GLfloat kerningScale, GLenum transformType, GLfloat *returnedSpacing)", },
       ["glGetPathTexGenfvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texCoordSet, GLenum pname, GLfloat* value)", },
       ["glGetPathTexGenivNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texCoordSet, GLenum pname, GLint* value)", },
       ["glInterpolatePathsNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint resultPath, GLuint pathA, GLuint pathB, GLfloat weight)", },
       ["glIsPathNV"] = { type ='function',
          description = "",
          returns = "(GLboolean)",
          valuetype = nil,
          args = "(GLuint path)", },
       ["glIsPointInFillPathNV"] = { type ='function',
          description = "",
          returns = "(GLboolean)",
          valuetype = nil,
          args = "(GLuint path, GLuint mask, GLfloat x, GLfloat y)", },
       ["glIsPointInStrokePathNV"] = { type ='function',
          description = "",
          returns = "(GLboolean)",
          valuetype = nil,
          args = "(GLuint path, GLfloat x, GLfloat y)", },
       ["glPathColorGenNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum color, GLenum genMode, GLenum colorFormat, const GLfloat* coeffs)", },
       ["glPathCommandsNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint path, GLsizei numCommands, const GLubyte* commands, GLsizei numCoords, GLenum coordType, const GLvoid*coords)", },
       ["glPathCoordsNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint path, GLsizei numCoords, GLenum coordType, const void* coords)", },
       ["glPathCoverDepthFuncNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum zfunc)", },
       ["glPathDashArrayNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint path, GLsizei dashCount, const GLfloat* dashArray)", },
       ["glPathFogGenNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum genMode)", },
       ["glPathGlyphRangeNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint firstPathName, GLenum fontTarget, const void* fontName, GLbitfield fontStyle, GLuint firstGlyph, GLsizei numGlyphs, GLenum handleMissingGlyphs, GLuint pathParameterTemplate, GLfloat emScale)", },
       ["glPathGlyphsNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint firstPathName, GLenum fontTarget, const void* fontName, GLbitfield fontStyle, GLsizei numGlyphs, GLenum type, const GLvoid*charcodes, GLenum handleMissingGlyphs, GLuint pathParameterTemplate, GLfloat emScale)", },
       ["glPathParameterfNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint path, GLenum pname, GLfloat value)", },
       ["glPathParameterfvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint path, GLenum pname, const GLfloat* value)", },
       ["glPathParameteriNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint path, GLenum pname, GLint value)", },
       ["glPathParameterivNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint path, GLenum pname, const GLint* value)", },
       ["glPathStencilDepthOffsetNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLfloat factor, GLfloat units)", },
       ["glPathStencilFuncNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum func, GLint ref, GLuint mask)", },
       ["glPathStringNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint path, GLenum format, GLsizei length, const void* pathString)", },
       ["glPathSubCommandsNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint path, GLsizei commandStart, GLsizei commandsToDelete, GLsizei numCommands, const GLubyte* commands, GLsizei numCoords, GLenum coordType, const GLvoid*coords)", },
       ["glPathSubCoordsNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint path, GLsizei coordStart, GLsizei numCoords, GLenum coordType, const void* coords)", },
       ["glPathTexGenNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum texCoordSet, GLenum genMode, GLint components, const GLfloat* coeffs)", },
       ["glPointAlongPathNV"] = { type ='function',
          description = "",
          returns = "(GLboolean)",
          valuetype = nil,
          args = "(GLuint path, GLsizei startSegment, GLsizei numSegments, GLfloat distance, GLfloat* x, GLfloat *y, GLfloat *tangentX, GLfloat *tangentY)", },
       ["glStencilFillPathInstancedNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei numPaths, GLenum pathNameType, const void* paths, GLuint pathBase, GLenum fillMode, GLuint mask, GLenum transformType, const GLfloat *transformValues)", },
       ["glStencilFillPathNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint path, GLenum fillMode, GLuint mask)", },
       ["glStencilStrokePathInstancedNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei numPaths, GLenum pathNameType, const void* paths, GLuint pathBase, GLint reference, GLuint mask, GLenum transformType, const GLfloat *transformValues)", },
       ["glStencilStrokePathNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint path, GLint reference, GLuint mask)", },
       ["glTransformPathNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint resultPath, GLuint srcPath, GLenum transformType, const GLfloat* transformValues)", },
       ["glWeightPathsNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint resultPath, GLsizei numPaths, const GLuint paths[], const GLfloat weights[])", },
       ["glFlushPixelDataRangeNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target)", },
       ["glPixelDataRangeNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLsizei length, GLvoid *pointer)", },
       ["glGetVideoi64vNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint video_slot, GLenum pname, GLint64EXT* params)", },
       ["glGetVideoivNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint video_slot, GLenum pname, GLint* params)", },
       ["glGetVideoui64vNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint video_slot, GLenum pname, GLuint64EXT* params)", },
       ["glGetVideouivNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint video_slot, GLenum pname, GLuint* params)", },
       ["glPresentFrameDualFillNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint video_slot, GLuint64EXT minPresentTime, GLuint beginPresentTimeId, GLuint presentDurationId, GLenum type, GLenum target0, GLuint fill0, GLenum target1, GLuint fill1, GLenum target2, GLuint fill2, GLenum target3, GLuint fill3)", },
       ["glPresentFrameKeyedNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint video_slot, GLuint64EXT minPresentTime, GLuint beginPresentTimeId, GLuint presentDurationId, GLenum type, GLenum target0, GLuint fill0, GLuint key0, GLenum target1, GLuint fill1, GLuint key1)", },
       ["glPrimitiveRestartNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(void)", },
       ["glCombinerInputNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum stage, GLenum portion, GLenum variable, GLenum input, GLenum mapping, GLenum componentUsage)", },
       ["glCombinerOutputNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum stage, GLenum portion, GLenum abOutput, GLenum cdOutput, GLenum sumOutput, GLenum scale, GLenum bias, GLboolean abDotProduct, GLboolean cdDotProduct, GLboolean muxSum)", },
       ["glCombinerParameterfNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum pname, GLfloat param)", },
       ["glCombinerParameterfvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum pname, const GLfloat* params)", },
       ["glCombinerParameteriNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum pname, GLint param)", },
       ["glCombinerParameterivNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum pname, const GLint* params)", },
       ["glFinalCombinerInputNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum variable, GLenum input, GLenum mapping, GLenum componentUsage)", },
       ["glGetCombinerInputParameterfvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum stage, GLenum portion, GLenum variable, GLenum pname, GLfloat* params)", },
       ["glGetCombinerInputParameterivNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum stage, GLenum portion, GLenum variable, GLenum pname, GLint* params)", },
       ["glGetCombinerOutputParameterfvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum stage, GLenum portion, GLenum pname, GLfloat* params)", },
       ["glGetCombinerOutputParameterivNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum stage, GLenum portion, GLenum pname, GLint* params)", },
       ["glGetFinalCombinerInputParameterfvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum variable, GLenum pname, GLfloat* params)", },
       ["glGetFinalCombinerInputParameterivNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum variable, GLenum pname, GLint* params)", },
       ["glCombinerStageParameterfvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum stage, GLenum pname, const GLfloat* params)", },
       ["glGetCombinerStageParameterfvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum stage, GLenum pname, GLfloat* params)", },
       ["glGetBufferParameterui64vNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum pname, GLuint64EXT* params)", },
       ["glGetIntegerui64vNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum value, GLuint64EXT* result)", },
       ["glGetNamedBufferParameterui64vNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint buffer, GLenum pname, GLuint64EXT* params)", },
       ["glIsBufferResidentNV"] = { type ='function',
          description = "",
          returns = "(GLboolean)",
          valuetype = nil,
          args = "(GLenum target)", },
       ["glIsNamedBufferResidentNV"] = { type ='function',
          description = "",
          returns = "(GLboolean)",
          valuetype = nil,
          args = "(GLuint buffer)", },
       ["glMakeBufferNonResidentNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target)", },
       ["glMakeBufferResidentNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLenum access)", },
       ["glMakeNamedBufferNonResidentNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint buffer)", },
       ["glMakeNamedBufferResidentNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint buffer, GLenum access)", },
       ["glProgramUniformui64NV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLuint64EXT value)", },
       ["glProgramUniformui64vNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLint location, GLsizei count, const GLuint64EXT* value)", },
       ["glUniformui64NV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLuint64EXT value)", },
       ["glUniformui64vNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint location, GLsizei count, const GLuint64EXT* value)", },
       ["glTextureBarrierNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(void)", },
       ["glTexImage2DMultisampleCoverageNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLint internalFormat, GLsizei width, GLsizei height, GLboolean fixedSampleLocations)", },
       ["glTexImage3DMultisampleCoverageNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLint internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedSampleLocations)", },
       ["glTextureImage2DMultisampleCoverageNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLint internalFormat, GLsizei width, GLsizei height, GLboolean fixedSampleLocations)", },
       ["glTextureImage2DMultisampleNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target, GLsizei samples, GLint internalFormat, GLsizei width, GLsizei height, GLboolean fixedSampleLocations)", },
       ["glTextureImage3DMultisampleCoverageNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target, GLsizei coverageSamples, GLsizei colorSamples, GLint internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedSampleLocations)", },
       ["glTextureImage3DMultisampleNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint texture, GLenum target, GLsizei samples, GLint internalFormat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedSampleLocations)", },
       ["glActiveVaryingNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, const GLchar *name)", },
       ["glBindBufferOffsetNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, GLuint buffer, GLintptr offset)", },
       ["glGetActiveVaryingNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLsizei *size, GLenum *type, GLchar *name)", },
       ["glGetVaryingLocationNV"] = { type ='function',
          description = "",
          returns = "(GLint)",
          valuetype = nil,
          args = "(GLuint program, const GLchar *name)", },
       ["glTransformFeedbackAttribsNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint count, const GLint *attribs, GLenum bufferMode)", },
       ["glVDPAUFiniNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(void)", },
       ["glVDPAUGetSurfaceivNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLvdpauSurfaceNV surface, GLenum pname, GLsizei bufSize, GLsizei* length, GLint *values)", },
       ["glVDPAUInitNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(const void* vdpDevice, const GLvoid*getProcAddress)", },
       ["glVDPAUIsSurfaceNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLvdpauSurfaceNV surface)", },
       ["glVDPAUMapSurfacesNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei numSurfaces, const GLvdpauSurfaceNV* surfaces)", },
       ["glVDPAURegisterOutputSurfaceNV"] = { type ='function',
          description = "",
          returns = "(GLvdpauSurfaceNV)",
          valuetype = nil,
          args = "(const void* vdpSurface, GLenum target, GLsizei numTextureNames, const GLuint *textureNames)", },
       ["glVDPAURegisterVideoSurfaceNV"] = { type ='function',
          description = "",
          returns = "(GLvdpauSurfaceNV)",
          valuetype = nil,
          args = "(const void* vdpSurface, GLenum target, GLsizei numTextureNames, const GLuint *textureNames)", },
       ["glVDPAUSurfaceAccessNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLvdpauSurfaceNV surface, GLenum access)", },
       ["glVDPAUUnmapSurfacesNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei numSurface, const GLvdpauSurfaceNV* surfaces)", },
       ["glVDPAUUnregisterSurfaceNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLvdpauSurfaceNV surface)", },
       ["glFlushVertexArrayRangeNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(void)", },
       ["glVertexArrayRangeNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei length, GLvoid *pointer)", },
       ["glGetVertexAttribLi64vNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLenum pname, GLint64EXT* params)", },
       ["glGetVertexAttribLui64vNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLenum pname, GLuint64EXT* params)", },
       ["glVertexAttribL1i64NV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLint64EXT x)", },
       ["glVertexAttribL1i64vNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, const GLint64EXT* v)", },
       ["glVertexAttribL1ui64NV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLuint64EXT x)", },
       ["glVertexAttribL1ui64vNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, const GLuint64EXT* v)", },
       ["glVertexAttribL2i64NV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLint64EXT x, GLint64EXT y)", },
       ["glVertexAttribL2i64vNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, const GLint64EXT* v)", },
       ["glVertexAttribL2ui64NV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLuint64EXT x, GLuint64EXT y)", },
       ["glVertexAttribL2ui64vNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, const GLuint64EXT* v)", },
       ["glVertexAttribL3i64NV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLint64EXT x, GLint64EXT y, GLint64EXT z)", },
       ["glVertexAttribL3i64vNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, const GLint64EXT* v)", },
       ["glVertexAttribL3ui64NV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z)", },
       ["glVertexAttribL3ui64vNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, const GLuint64EXT* v)", },
       ["glVertexAttribL4i64NV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLint64EXT x, GLint64EXT y, GLint64EXT z, GLint64EXT w)", },
       ["glVertexAttribL4i64vNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, const GLint64EXT* v)", },
       ["glVertexAttribL4ui64NV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, GLuint64EXT w)", },
       ["glVertexAttribL4ui64vNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, const GLuint64EXT* v)", },
       ["glVertexAttribLFormatNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLint size, GLenum type, GLsizei stride)", },
       ["glBufferAddressRangeNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum pname, GLuint index, GLuint64EXT address, GLsizeiptr length)", },
       ["glColorFormatNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint size, GLenum type, GLsizei stride)", },
       ["glEdgeFlagFormatNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei stride)", },
       ["glFogCoordFormatNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum type, GLsizei stride)", },
       ["glGetIntegerui64i_vNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum value, GLuint index, GLuint64EXT result[])", },
       ["glIndexFormatNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum type, GLsizei stride)", },
       ["glNormalFormatNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum type, GLsizei stride)", },
       ["glSecondaryColorFormatNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint size, GLenum type, GLsizei stride)", },
       ["glTexCoordFormatNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint size, GLenum type, GLsizei stride)", },
       ["glVertexAttribFormatNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride)", },
       ["glVertexAttribIFormatNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLint size, GLenum type, GLsizei stride)", },
       ["glVertexFormatNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLint size, GLenum type, GLsizei stride)", },
       ["glAreProgramsResidentNV"] = { type ='function',
          description = "",
          returns = "(GLboolean)",
          valuetype = nil,
          args = "(GLsizei n, const GLuint* ids, GLboolean *residences)", },
       ["glBindProgramNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint id)", },
       ["glDeleteProgramsNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei n, const GLuint* ids)", },
       ["glExecuteProgramNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint id, const GLfloat* params)", },
       ["glGenProgramsNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei n, GLuint* ids)", },
       ["glGetProgramParameterdvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, GLenum pname, GLdouble* params)", },
       ["glGetProgramParameterfvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, GLenum pname, GLfloat* params)", },
       ["glGetProgramStringNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint id, GLenum pname, GLubyte* program)", },
       ["glGetTrackMatrixivNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint address, GLenum pname, GLint* params)", },
       ["glLoadProgramNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint id, GLsizei len, const GLubyte* program)", },
       ["glProgramParameter4dNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)", },
       ["glProgramParameter4dvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, const GLdouble* params)", },
       ["glProgramParameter4fNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)", },
       ["glProgramParameter4fvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, const GLfloat* params)", },
       ["glProgramParameters4dvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, GLsizei num, const GLdouble* params)", },
       ["glProgramParameters4fvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint index, GLsizei num, const GLfloat* params)", },
       ["glRequestResidentProgramsNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLsizei n, GLuint* ids)", },
       ["glTrackMatrixNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLenum target, GLuint address, GLenum matrix, GLenum transform)", },
       ["glVertexAttrib4ubNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w)", },
       ["glVertexAttribs1dvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLsizei n, const GLdouble* v)", },
       ["glVertexAttribs1fvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLsizei n, const GLfloat* v)", },
       ["glVertexAttribs1svNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLsizei n, const GLshort* v)", },
       ["glVertexAttribs2dvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLsizei n, const GLdouble* v)", },
       ["glVertexAttribs2fvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLsizei n, const GLfloat* v)", },
       ["glVertexAttribs2svNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLsizei n, const GLshort* v)", },
       ["glVertexAttribs3dvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLsizei n, const GLdouble* v)", },
       ["glVertexAttribs3fvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLsizei n, const GLfloat* v)", },
       ["glVertexAttribs3svNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLsizei n, const GLshort* v)", },
       ["glVertexAttribs4dvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLsizei n, const GLdouble* v)", },
       ["glVertexAttribs4fvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLsizei n, const GLfloat* v)", },
       ["glVertexAttribs4svNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLsizei n, const GLshort* v)", },
       ["glVertexAttribs4ubvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint index, GLsizei n, const GLubyte* v)", },
       ["glBeginVideoCaptureNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint video_capture_slot)", },
       ["glBindVideoCaptureStreamBufferNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint video_capture_slot, GLuint stream, GLenum frame_region, GLintptrARB offset)", },
       ["glBindVideoCaptureStreamTextureNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint video_capture_slot, GLuint stream, GLenum frame_region, GLenum target, GLuint texture)", },
       ["glEndVideoCaptureNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint video_capture_slot)", },
       ["glGetVideoCaptureStreamdvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint video_capture_slot, GLuint stream, GLenum pname, GLdouble* params)", },
       ["glGetVideoCaptureStreamfvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint video_capture_slot, GLuint stream, GLenum pname, GLfloat* params)", },
       ["glGetVideoCaptureStreamivNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint video_capture_slot, GLuint stream, GLenum pname, GLint* params)", },
       ["glGetVideoCaptureivNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint video_capture_slot, GLenum pname, GLint* params)", },
       ["glVideoCaptureNV"] = { type ='function',
          description = "",
          returns = "(GLenum)",
          valuetype = nil,
          args = "(GLuint video_capture_slot, GLuint* sequence_num, GLuint64EXT *capture_time)", },
       ["glVideoCaptureStreamParameterdvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint video_capture_slot, GLuint stream, GLenum pname, const GLdouble* params)", },
       ["glVideoCaptureStreamParameterfvNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint video_capture_slot, GLuint stream, GLenum pname, const GLfloat* params)", },
       ["glVideoCaptureStreamParameterivNV"] = { type ='function',
          description = "",
          returns = "()",
          valuetype = nil,
          args = "(GLuint video_capture_slot, GLuint stream, GLenum pname, const GLint* params)", },
       ["glewInit"] = { type ='function',
          description = "",
          returns = "(GLenum)",
          valuetype = nil,
          args = "()", },
       ["glewIsSupported"] = { type ='function',
          description = "",
          returns = "(GLboolean)",
          valuetype = nil,
          args = "(const char* name)", },
               }
  return {
        glewgl = {
      type = 'lib',
      description = "OpenGL Wrapper with GLEW",
      childs = api,
    },
        gl = {
      type = 'lib',
      description = "OpenGL Wrapper with GLEW",
      childs = api,
    },
      }
  