--[[// glfw | GLFW window manager
enum {
    GLFW_VERSION_MAJOR         =  3,
    GLFW_VERSION_MINOR         =  0,
    GLFW_VERSION_REVISION      =  0,
    GLFW_RELEASE               =  0,
    GLFW_PRESS                 =  1,
    GLFW_KEY_SPACE             = 32,
    GLFW_KEY_APOSTROPHE        = 39, 
    GLFW_KEY_COMMA             = 44, 
    GLFW_KEY_MINUS             = 45, 
    GLFW_KEY_PERIOD            = 46, 
    GLFW_KEY_SLASH             = 47, 
    GLFW_KEY_0                 = 48,
    GLFW_KEY_1                 = 49,
    GLFW_KEY_2                 = 50,
    GLFW_KEY_3                 = 51,
    GLFW_KEY_4                 = 52,
    GLFW_KEY_5                 = 53,
    GLFW_KEY_6                 = 54,
    GLFW_KEY_7                 = 55,
    GLFW_KEY_8                 = 56,
    GLFW_KEY_9                 = 57,
    GLFW_KEY_SEMICOLON         = 59, 
    GLFW_KEY_EQUAL             = 61, 
    GLFW_KEY_A                 = 65,
    GLFW_KEY_B                 = 66,
    GLFW_KEY_C                 = 67,
    GLFW_KEY_D                 = 68,
    GLFW_KEY_E                 = 69,
    GLFW_KEY_F                 = 70,
    GLFW_KEY_G                 = 71,
    GLFW_KEY_H                 = 72,
    GLFW_KEY_I                 = 73,
    GLFW_KEY_J                 = 74,
    GLFW_KEY_K                 = 75,
    GLFW_KEY_L                 = 76,
    GLFW_KEY_M                 = 77,
    GLFW_KEY_N                 = 78,
    GLFW_KEY_O                 = 79,
    GLFW_KEY_P                 = 80,
    GLFW_KEY_Q                 = 81,
    GLFW_KEY_R                 = 82,
    GLFW_KEY_S                 = 83,
    GLFW_KEY_T                 = 84,
    GLFW_KEY_U                 = 85,
    GLFW_KEY_V                 = 86,
    GLFW_KEY_W                 = 87,
    GLFW_KEY_X                 = 88,
    GLFW_KEY_Y                 = 89,
    GLFW_KEY_Z                 = 90,
    GLFW_KEY_LEFT_BRACKET      = 91, 
    GLFW_KEY_BACKSLASH         = 92,
    GLFW_KEY_RIGHT_BRACKET     = 93, 
    GLFW_KEY_GRAVE_ACCENT      = 96,
    GLFW_KEY_WORLD_1           = 161,
    GLFW_KEY_WORLD_2           = 162,
    GLFW_KEY_ESCAPE            = 256,
    GLFW_KEY_ENTER             = 257,
    GLFW_KEY_TAB               = 258,
    GLFW_KEY_BACKSPACE         = 259,
    GLFW_KEY_INSERT            = 260,
    GLFW_KEY_DELETE            = 261,
    GLFW_KEY_RIGHT             = 262,
    GLFW_KEY_LEFT              = 263,
    GLFW_KEY_DOWN              = 264,
    GLFW_KEY_UP                = 265,
    GLFW_KEY_PAGE_UP           = 266,
    GLFW_KEY_PAGE_DOWN         = 267,
    GLFW_KEY_HOME              = 268,
    GLFW_KEY_END               = 269,
    GLFW_KEY_CAPS_LOCK         = 280,
    GLFW_KEY_SCROLL_LOCK       = 281,
    GLFW_KEY_NUM_LOCK          = 282,
    GLFW_KEY_PRINT_SCREEN      = 283,
    GLFW_KEY_PAUSE             = 284,
    GLFW_KEY_F1                = 290,
    GLFW_KEY_F2                = 291,
    GLFW_KEY_F3                = 292,
    GLFW_KEY_F4                = 293,
    GLFW_KEY_F5                = 294,
    GLFW_KEY_F6                = 295,
    GLFW_KEY_F7                = 296,
    GLFW_KEY_F8                = 297,
    GLFW_KEY_F9                = 298,
    GLFW_KEY_F10               = 299,
    GLFW_KEY_F11               = 300,
    GLFW_KEY_F12               = 301,
    GLFW_KEY_F13               = 302,
    GLFW_KEY_F14               = 303,
    GLFW_KEY_F15               = 304,
    GLFW_KEY_F16               = 305,
    GLFW_KEY_F17               = 306,
    GLFW_KEY_F18               = 307,
    GLFW_KEY_F19               = 308,
    GLFW_KEY_F20               = 309,
    GLFW_KEY_F21               = 310,
    GLFW_KEY_F22               = 311,
    GLFW_KEY_F23               = 312,
    GLFW_KEY_F24               = 313,
    GLFW_KEY_F25               = 314,
    GLFW_KEY_KP_0              = 320,
    GLFW_KEY_KP_1              = 321,
    GLFW_KEY_KP_2              = 322,
    GLFW_KEY_KP_3              = 323,
    GLFW_KEY_KP_4              = 324,
    GLFW_KEY_KP_5              = 325,
    GLFW_KEY_KP_6              = 326,
    GLFW_KEY_KP_7              = 327,
    GLFW_KEY_KP_8              = 328,
    GLFW_KEY_KP_9              = 329,
    GLFW_KEY_KP_DECIMAL        = 330,
    GLFW_KEY_KP_DIVIDE         = 331,
    GLFW_KEY_KP_MULTIPLY       = 332,
    GLFW_KEY_KP_SUBTRACT       = 333,
    GLFW_KEY_KP_ADD            = 334,
    GLFW_KEY_KP_ENTER          = 335,
    GLFW_KEY_KP_EQUAL          = 336,
    GLFW_KEY_LEFT_SHIFT        = 340,
    GLFW_KEY_LEFT_CONTROL      = 341,
    GLFW_KEY_LEFT_ALT          = 342,
    GLFW_KEY_LEFT_SUPER        = 343,
    GLFW_KEY_RIGHT_SHIFT       = 344,
    GLFW_KEY_RIGHT_CONTROL     = 345,
    GLFW_KEY_RIGHT_ALT         = 346,
    GLFW_KEY_RIGHT_SUPER       = 347,
    GLFW_KEY_MENU              = 348,
    GLFW_KEY_LAST              = GLFW_KEY_MENU,
    GLFW_MOUSE_BUTTON_1        = 0,
    GLFW_MOUSE_BUTTON_2        = 1,
    GLFW_MOUSE_BUTTON_3        = 2,
    GLFW_MOUSE_BUTTON_4        = 3,
    GLFW_MOUSE_BUTTON_5        = 4,
    GLFW_MOUSE_BUTTON_6        = 5,
    GLFW_MOUSE_BUTTON_7        = 6,
    GLFW_MOUSE_BUTTON_8        = 7,
    GLFW_MOUSE_BUTTON_LAST     = GLFW_MOUSE_BUTTON_8,
    GLFW_MOUSE_BUTTON_LEFT     = GLFW_MOUSE_BUTTON_1,
    GLFW_MOUSE_BUTTON_RIGHT    = GLFW_MOUSE_BUTTON_2,
    GLFW_MOUSE_BUTTON_MIDDLE   = GLFW_MOUSE_BUTTON_3,
    GLFW_JOYSTICK_1            = 0,
    GLFW_JOYSTICK_2            = 1,
    GLFW_JOYSTICK_3            = 2,
    GLFW_JOYSTICK_4            = 3,
    GLFW_JOYSTICK_5            = 4,
    GLFW_JOYSTICK_6            = 5,
    GLFW_JOYSTICK_7            = 6,
    GLFW_JOYSTICK_8            = 7,
    GLFW_JOYSTICK_9            = 8,
    GLFW_JOYSTICK_10           = 9,
    GLFW_JOYSTICK_11           = 10,
    GLFW_JOYSTICK_12           = 11,
    GLFW_JOYSTICK_13           = 12,
    GLFW_JOYSTICK_14           = 13,
    GLFW_JOYSTICK_15           = 14,
    GLFW_JOYSTICK_16           = 15,
    GLFW_JOYSTICK_LAST         = GLFW_JOYSTICK_16,
    GLFW_WINDOWED              = 0x00010001,
    GLFW_FULLSCREEN            = 0x00010002,
    GLFW_ACTIVE                = 0x00020001,
    GLFW_ICONIFIED             = 0x00020002,
    GLFW_ACCELERATED           = 0x00020003,
    GLFW_RED_BITS              = 0x00020004,
    GLFW_GREEN_BITS            = 0x00020005,
    GLFW_BLUE_BITS             = 0x00020006,
    GLFW_ALPHA_BITS            = 0x00020007,
    GLFW_DEPTH_BITS            = 0x00020008,
    GLFW_STENCIL_BITS          = 0x00020009,
    GLFW_REFRESH_RATE          = 0x0002000A,
    GLFW_ACCUM_RED_BITS        = 0x0002000B,
    GLFW_ACCUM_GREEN_BITS      = 0x0002000C,
    GLFW_ACCUM_BLUE_BITS       = 0x0002000D,
    GLFW_ACCUM_ALPHA_BITS      = 0x0002000E,
    GLFW_AUX_BUFFERS           = 0x0002000F,
    GLFW_STEREO                = 0x00020010,
    GLFW_WINDOW_NO_RESIZE      = 0x00020011,
    GLFW_FSAA_SAMPLES          = 0x00020012,
    GLFW_OPENGL_VERSION_MAJOR  = 0x00020013,
    GLFW_OPENGL_VERSION_MINOR  = 0x00020014,
    GLFW_OPENGL_FORWARD_COMPAT = 0x00020015,
    GLFW_OPENGL_DEBUG_CONTEXT  = 0x00020016,
    GLFW_OPENGL_PROFILE        = 0x00020017,
    GLFW_OPENGL_CORE_PROFILE   = 0x00000001,
    GLFW_OPENGL_COMPAT_PROFILE = 0x00000002,
    GLFW_OPENGL_ES2_PROFILE    = 0x00000004,
    GLFW_MOUSE_CURSOR          = 0x00030001,
    GLFW_STICKY_KEYS           = 0x00030002,
    GLFW_STICKY_MOUSE_BUTTONS  = 0x00030003,
    GLFW_SYSTEM_KEYS           = 0x00030004,
    GLFW_KEY_REPEAT            = 0x00030005,
    GLFW_PRESENT               = 0x00050001,
    GLFW_AXES                  = 0x00050002,
    GLFW_BUTTONS               = 0x00050003,
    GLFW_NO_ERROR              = 0,
    GLFW_NOT_INITIALIZED       = 0x00070001,
    GLFW_NO_CURRENT_WINDOW     = 0x00070002,
    GLFW_INVALID_ENUM          = 0x00070003,
    GLFW_INVALID_VALUE         = 0x00070004,
    GLFW_OUT_OF_MEMORY         = 0x00070005,
    GLFW_OPENGL_UNAVAILABLE    = 0x00070006,
    GLFW_VERSION_UNAVAILABLE   = 0x00070007,
    GLFW_PLATFORM_ERROR        = 0x00070008,
    GLFW_GAMMA_RAMP_SIZE       = 256
};

typedef struct _GLFWwindow* GLFWwindow;

typedef struct {
            int width;
            int height;
            int redBits;
            int blueBits;
            int greenBits;
} GLFWvidmode;

typedef struct {
            unsigned short red[GLFW_GAMMA_RAMP_SIZE];
            unsigned short green[GLFW_GAMMA_RAMP_SIZE];
            unsigned short blue[GLFW_GAMMA_RAMP_SIZE];
} GLFWgammaramp;

int         glfwInit(                 void );
void        glfwTerminate(            void );
void        glfwGetVersion(           int* major, int* minor, int* rev );
const char* glfwGetVersionString(     void );
int         glfwGetError(             void );
const char* glfwErrorString(          int error );
int         glfwGetVideoModes(        GLFWvidmode* list, int maxcount );
void        glfwGetDesktopMode(       GLFWvidmode* mode );
void        glfwSetGammaFormula(      float gamma, float blacklevel, float gain );
void        glfwGetGammaRamp(         GLFWgammaramp* ramp );
void        glfwSetGammaRamp(   const GLFWgammaramp* ramp );
GLFWwindow  glfwOpenWindow(           int width, int height, int mode, const char* title, GLFWwindow share );
void        glfwOpenWindowHint(       int target, int hint );
void        glfwMakeWindowCurrent(    GLFWwindow window );
int         glfwIsWindow(             GLFWwindow window );
GLFWwindow  glfwGetCurrentWindow(     void );
void        glfwCloseWindow(          GLFWwindow window );
void        glfwSetWindowTitle(       GLFWwindow, const char* title );
void        glfwGetWindowSize(        GLFWwindow, int* width, int* height );
void        glfwSetWindowSize(        GLFWwindow, int  width, int  height );
void        glfwGetWindowPos(         GLFWwindow, int* x, int* y );
void        glfwSetWindowPos(         GLFWwindow, int  x, int  y );
void        glfwIconifyWindow(        GLFWwindow window );
void        glfwRestoreWindow(        GLFWwindow window );
int         glfwGetWindowParam(       GLFWwindow window, int param );
void        glfwSetWindowUserPointer( GLFWwindow window, void* pointer );
void*       glfwGetWindowUserPointer( GLFWwindow window );
void        glfwPollEvents(           void );
void        glfwWaitEvents(           void );
int         glfwGetKey(               GLFWwindow window, int key );
int         glfwGetMouseButton(       GLFWwindow window, int button );
void        glfwGetMousePos(          GLFWwindow window, int* xpos, int* ypos );
void        glfwSetMousePos(          GLFWwindow window, int  xpos, int  ypos );
void        glfwGetScrollOffset(      GLFWwindow window, int* x, int* y );
int         glfwGetJoystickParam(     int joy, int param );
int         glfwGetJoystickPos(       int joy, float* pos, int numaxes );
int         glfwGetJoystickButtons(   int joy, unsigned char* buttons, int numbuttons );
double      glfwGetTime(              void );
void        glfwSetTime(              double time );
void        glfwSwapBuffers(          void );
void        glfwSwapInterval(         int interval );
int         glfwExtensionSupported(   const char* extension );
void*       glfwGetProcAddress(       const char* procname );
void        glfwGetGLVersion(         int* major, int* minor, int* rev );
void        glfwEnable(               GLFWwindow window, int token );
void        glfwDisable(              GLFWwindow window, int token );
]]  
--auto-generated api from ffi headers
local api =
  {
  ["GLFW_VERSION_MAJOR"] = { type ='value', },
  ["GLFW_VERSION_MINOR"] = { type ='value', },
  ["GLFW_VERSION_REVISION"] = { type ='value', },
  ["GLFW_RELEASE"] = { type ='value', },
  ["GLFW_PRESS"] = { type ='value', },
  ["GLFW_KEY_SPACE"] = { type ='value', },
  ["GLFW_KEY_APOSTROPHE"] = { type ='value', },
  ["GLFW_KEY_COMMA"] = { type ='value', },
  ["GLFW_KEY_MINUS"] = { type ='value', },
  ["GLFW_KEY_PERIOD"] = { type ='value', },
  ["GLFW_KEY_SLASH"] = { type ='value', },
  ["GLFW_KEY_0"] = { type ='value', },
  ["GLFW_KEY_1"] = { type ='value', },
  ["GLFW_KEY_2"] = { type ='value', },
  ["GLFW_KEY_3"] = { type ='value', },
  ["GLFW_KEY_4"] = { type ='value', },
  ["GLFW_KEY_5"] = { type ='value', },
  ["GLFW_KEY_6"] = { type ='value', },
  ["GLFW_KEY_7"] = { type ='value', },
  ["GLFW_KEY_8"] = { type ='value', },
  ["GLFW_KEY_9"] = { type ='value', },
  ["GLFW_KEY_SEMICOLON"] = { type ='value', },
  ["GLFW_KEY_EQUAL"] = { type ='value', },
  ["GLFW_KEY_A"] = { type ='value', },
  ["GLFW_KEY_B"] = { type ='value', },
  ["GLFW_KEY_C"] = { type ='value', },
  ["GLFW_KEY_D"] = { type ='value', },
  ["GLFW_KEY_E"] = { type ='value', },
  ["GLFW_KEY_F"] = { type ='value', },
  ["GLFW_KEY_G"] = { type ='value', },
  ["GLFW_KEY_H"] = { type ='value', },
  ["GLFW_KEY_I"] = { type ='value', },
  ["GLFW_KEY_J"] = { type ='value', },
  ["GLFW_KEY_K"] = { type ='value', },
  ["GLFW_KEY_L"] = { type ='value', },
  ["GLFW_KEY_M"] = { type ='value', },
  ["GLFW_KEY_N"] = { type ='value', },
  ["GLFW_KEY_O"] = { type ='value', },
  ["GLFW_KEY_P"] = { type ='value', },
  ["GLFW_KEY_Q"] = { type ='value', },
  ["GLFW_KEY_R"] = { type ='value', },
  ["GLFW_KEY_S"] = { type ='value', },
  ["GLFW_KEY_T"] = { type ='value', },
  ["GLFW_KEY_U"] = { type ='value', },
  ["GLFW_KEY_V"] = { type ='value', },
  ["GLFW_KEY_W"] = { type ='value', },
  ["GLFW_KEY_X"] = { type ='value', },
  ["GLFW_KEY_Y"] = { type ='value', },
  ["GLFW_KEY_Z"] = { type ='value', },
  ["GLFW_KEY_LEFT_BRACKET"] = { type ='value', },
  ["GLFW_KEY_BACKSLASH"] = { type ='value', },
  ["GLFW_KEY_RIGHT_BRACKET"] = { type ='value', },
  ["GLFW_KEY_GRAVE_ACCENT"] = { type ='value', },
  ["GLFW_KEY_WORLD_1"] = { type ='value', },
  ["GLFW_KEY_WORLD_2"] = { type ='value', },
  ["GLFW_KEY_ESCAPE"] = { type ='value', },
  ["GLFW_KEY_ENTER"] = { type ='value', },
  ["GLFW_KEY_TAB"] = { type ='value', },
  ["GLFW_KEY_BACKSPACE"] = { type ='value', },
  ["GLFW_KEY_INSERT"] = { type ='value', },
  ["GLFW_KEY_DELETE"] = { type ='value', },
  ["GLFW_KEY_RIGHT"] = { type ='value', },
  ["GLFW_KEY_LEFT"] = { type ='value', },
  ["GLFW_KEY_DOWN"] = { type ='value', },
  ["GLFW_KEY_UP"] = { type ='value', },
  ["GLFW_KEY_PAGE_UP"] = { type ='value', },
  ["GLFW_KEY_PAGE_DOWN"] = { type ='value', },
  ["GLFW_KEY_HOME"] = { type ='value', },
  ["GLFW_KEY_END"] = { type ='value', },
  ["GLFW_KEY_CAPS_LOCK"] = { type ='value', },
  ["GLFW_KEY_SCROLL_LOCK"] = { type ='value', },
  ["GLFW_KEY_NUM_LOCK"] = { type ='value', },
  ["GLFW_KEY_PRINT_SCREEN"] = { type ='value', },
  ["GLFW_KEY_PAUSE"] = { type ='value', },
  ["GLFW_KEY_F1"] = { type ='value', },
  ["GLFW_KEY_F2"] = { type ='value', },
  ["GLFW_KEY_F3"] = { type ='value', },
  ["GLFW_KEY_F4"] = { type ='value', },
  ["GLFW_KEY_F5"] = { type ='value', },
  ["GLFW_KEY_F6"] = { type ='value', },
  ["GLFW_KEY_F7"] = { type ='value', },
  ["GLFW_KEY_F8"] = { type ='value', },
  ["GLFW_KEY_F9"] = { type ='value', },
  ["GLFW_KEY_F10"] = { type ='value', },
  ["GLFW_KEY_F11"] = { type ='value', },
  ["GLFW_KEY_F12"] = { type ='value', },
  ["GLFW_KEY_F13"] = { type ='value', },
  ["GLFW_KEY_F14"] = { type ='value', },
  ["GLFW_KEY_F15"] = { type ='value', },
  ["GLFW_KEY_F16"] = { type ='value', },
  ["GLFW_KEY_F17"] = { type ='value', },
  ["GLFW_KEY_F18"] = { type ='value', },
  ["GLFW_KEY_F19"] = { type ='value', },
  ["GLFW_KEY_F20"] = { type ='value', },
  ["GLFW_KEY_F21"] = { type ='value', },
  ["GLFW_KEY_F22"] = { type ='value', },
  ["GLFW_KEY_F23"] = { type ='value', },
  ["GLFW_KEY_F24"] = { type ='value', },
  ["GLFW_KEY_F25"] = { type ='value', },
  ["GLFW_KEY_KP_0"] = { type ='value', },
  ["GLFW_KEY_KP_1"] = { type ='value', },
  ["GLFW_KEY_KP_2"] = { type ='value', },
  ["GLFW_KEY_KP_3"] = { type ='value', },
  ["GLFW_KEY_KP_4"] = { type ='value', },
  ["GLFW_KEY_KP_5"] = { type ='value', },
  ["GLFW_KEY_KP_6"] = { type ='value', },
  ["GLFW_KEY_KP_7"] = { type ='value', },
  ["GLFW_KEY_KP_8"] = { type ='value', },
  ["GLFW_KEY_KP_9"] = { type ='value', },
  ["GLFW_KEY_KP_DECIMAL"] = { type ='value', },
  ["GLFW_KEY_KP_DIVIDE"] = { type ='value', },
  ["GLFW_KEY_KP_MULTIPLY"] = { type ='value', },
  ["GLFW_KEY_KP_SUBTRACT"] = { type ='value', },
  ["GLFW_KEY_KP_ADD"] = { type ='value', },
  ["GLFW_KEY_KP_ENTER"] = { type ='value', },
  ["GLFW_KEY_KP_EQUAL"] = { type ='value', },
  ["GLFW_KEY_LEFT_SHIFT"] = { type ='value', },
  ["GLFW_KEY_LEFT_CONTROL"] = { type ='value', },
  ["GLFW_KEY_LEFT_ALT"] = { type ='value', },
  ["GLFW_KEY_LEFT_SUPER"] = { type ='value', },
  ["GLFW_KEY_RIGHT_SHIFT"] = { type ='value', },
  ["GLFW_KEY_RIGHT_CONTROL"] = { type ='value', },
  ["GLFW_KEY_RIGHT_ALT"] = { type ='value', },
  ["GLFW_KEY_RIGHT_SUPER"] = { type ='value', },
  ["GLFW_KEY_MENU"] = { type ='value', },
  ["GLFW_KEY_LAST"] = { type ='value', },
  ["GLFW_MOUSE_BUTTON_1"] = { type ='value', },
  ["GLFW_MOUSE_BUTTON_2"] = { type ='value', },
  ["GLFW_MOUSE_BUTTON_3"] = { type ='value', },
  ["GLFW_MOUSE_BUTTON_4"] = { type ='value', },
  ["GLFW_MOUSE_BUTTON_5"] = { type ='value', },
  ["GLFW_MOUSE_BUTTON_6"] = { type ='value', },
  ["GLFW_MOUSE_BUTTON_7"] = { type ='value', },
  ["GLFW_MOUSE_BUTTON_8"] = { type ='value', },
  ["GLFW_MOUSE_BUTTON_LAST"] = { type ='value', },
  ["GLFW_MOUSE_BUTTON_LEFT"] = { type ='value', },
  ["GLFW_MOUSE_BUTTON_RIGHT"] = { type ='value', },
  ["GLFW_MOUSE_BUTTON_MIDDLE"] = { type ='value', },
  ["GLFW_JOYSTICK_1"] = { type ='value', },
  ["GLFW_JOYSTICK_2"] = { type ='value', },
  ["GLFW_JOYSTICK_3"] = { type ='value', },
  ["GLFW_JOYSTICK_4"] = { type ='value', },
  ["GLFW_JOYSTICK_5"] = { type ='value', },
  ["GLFW_JOYSTICK_6"] = { type ='value', },
  ["GLFW_JOYSTICK_7"] = { type ='value', },
  ["GLFW_JOYSTICK_8"] = { type ='value', },
  ["GLFW_JOYSTICK_9"] = { type ='value', },
  ["GLFW_JOYSTICK_10"] = { type ='value', },
  ["GLFW_JOYSTICK_11"] = { type ='value', },
  ["GLFW_JOYSTICK_12"] = { type ='value', },
  ["GLFW_JOYSTICK_13"] = { type ='value', },
  ["GLFW_JOYSTICK_14"] = { type ='value', },
  ["GLFW_JOYSTICK_15"] = { type ='value', },
  ["GLFW_JOYSTICK_16"] = { type ='value', },
  ["GLFW_JOYSTICK_LAST"] = { type ='value', },
  ["GLFW_WINDOWED"] = { type ='value', },
  ["GLFW_FULLSCREEN"] = { type ='value', },
  ["GLFW_ACTIVE"] = { type ='value', },
  ["GLFW_ICONIFIED"] = { type ='value', },
  ["GLFW_ACCELERATED"] = { type ='value', },
  ["GLFW_RED_BITS"] = { type ='value', },
  ["GLFW_GREEN_BITS"] = { type ='value', },
  ["GLFW_BLUE_BITS"] = { type ='value', },
  ["GLFW_ALPHA_BITS"] = { type ='value', },
  ["GLFW_DEPTH_BITS"] = { type ='value', },
  ["GLFW_STENCIL_BITS"] = { type ='value', },
  ["GLFW_REFRESH_RATE"] = { type ='value', },
  ["GLFW_ACCUM_RED_BITS"] = { type ='value', },
  ["GLFW_ACCUM_GREEN_BITS"] = { type ='value', },
  ["GLFW_ACCUM_BLUE_BITS"] = { type ='value', },
  ["GLFW_ACCUM_ALPHA_BITS"] = { type ='value', },
  ["GLFW_AUX_BUFFERS"] = { type ='value', },
  ["GLFW_STEREO"] = { type ='value', },
  ["GLFW_WINDOW_NO_RESIZE"] = { type ='value', },
  ["GLFW_FSAA_SAMPLES"] = { type ='value', },
  ["GLFW_OPENGL_VERSION_MAJOR"] = { type ='value', },
  ["GLFW_OPENGL_VERSION_MINOR"] = { type ='value', },
  ["GLFW_OPENGL_FORWARD_COMPAT"] = { type ='value', },
  ["GLFW_OPENGL_DEBUG_CONTEXT"] = { type ='value', },
  ["GLFW_OPENGL_PROFILE"] = { type ='value', },
  ["GLFW_OPENGL_CORE_PROFILE"] = { type ='value', },
  ["GLFW_OPENGL_COMPAT_PROFILE"] = { type ='value', },
  ["GLFW_OPENGL_ES2_PROFILE"] = { type ='value', },
  ["GLFW_MOUSE_CURSOR"] = { type ='value', },
  ["GLFW_STICKY_KEYS"] = { type ='value', },
  ["GLFW_STICKY_MOUSE_BUTTONS"] = { type ='value', },
  ["GLFW_SYSTEM_KEYS"] = { type ='value', },
  ["GLFW_KEY_REPEAT"] = { type ='value', },
  ["GLFW_PRESENT"] = { type ='value', },
  ["GLFW_AXES"] = { type ='value', },
  ["GLFW_BUTTONS"] = { type ='value', },
  ["GLFW_NO_ERROR"] = { type ='value', },
  ["GLFW_NOT_INITIALIZED"] = { type ='value', },
  ["GLFW_NO_CURRENT_WINDOW"] = { type ='value', },
  ["GLFW_INVALID_ENUM"] = { type ='value', },
  ["GLFW_INVALID_VALUE"] = { type ='value', },
  ["GLFW_OUT_OF_MEMORY"] = { type ='value', },
  ["GLFW_OPENGL_UNAVAILABLE"] = { type ='value', },
  ["GLFW_VERSION_UNAVAILABLE"] = { type ='value', },
  ["GLFW_PLATFORM_ERROR"] = { type ='value', },
  ["GLFW_GAMMA_RAMP_SIZE"] = { type ='value', },
  ["glfwInit"] = { type ='function', 
    description = "", 
    returns = "(int)",
    valuetype = nil,
    args = "(void)", },
  ["glfwTerminate"] = { type ='function', 
    description = "", 
    returns = "(void)",
    valuetype = nil,
    args = "(void)", },
  ["glfwGetVersion"] = { type ='function', 
    description = "", 
    returns = "(void)",
    valuetype = nil,
    args = "(int* major, int* minor, int* rev)", },
  ["glfwGetVersionString"] = { type ='function', 
    description = "", 
    returns = "(const char*)",
    valuetype = "string",
    args = "(void)", },
  ["glfwGetError"] = { type ='function', 
    description = "", 
    returns = "(int)",
    valuetype = nil,
    args = "(void)", },
  ["glfwErrorString"] = { type ='function', 
    description = "", 
    returns = "(const char*)",
    valuetype = "string",
    args = "(int error)", },
  ["glfwGetVideoModes"] = { type ='function', 
    description = "", 
    returns = "(int)",
    valuetype = nil,
    args = "(GLFWvidmode* list, int maxcount)", },
  ["glfwGetDesktopMode"] = { type ='function', 
    description = "", 
    returns = "(void)",
    valuetype = nil,
    args = "(GLFWvidmode* mode)", },
  ["glfwSetGammaFormula"] = { type ='function', 
    description = "", 
    returns = "(void)",
    valuetype = nil,
    args = "(float gamma, float blacklevel, float gain)", },
  ["glfwGetGammaRamp"] = { type ='function', 
    description = "", 
    returns = "(void)",
    valuetype = nil,
    args = "(GLFWgammaramp* ramp)", },
  ["glfwSetGammaRamp"] = { type ='function', 
    description = "", 
    returns = "(void)",
    valuetype = nil,
    args = "(const GLFWgammaramp* ramp)", },
  ["glfwOpenWindow"] = { type ='function', 
    description = "", 
    returns = "(GLFWwindow)",
    valuetype = nil,
    args = "(int width, int height, int mode, const char* title, GLFWwindow share)", },
  ["glfwOpenWindowHint"] = { type ='function', 
    description = "", 
    returns = "(void)",
    valuetype = nil,
    args = "(int target, int hint)", },
  ["glfwMakeWindowCurrent"] = { type ='function', 
    description = "", 
    returns = "(void)",
    valuetype = nil,
    args = "(GLFWwindow window)", },
  ["glfwIsWindow"] = { type ='function', 
    description = "", 
    returns = "(int)",
    valuetype = nil,
    args = "(GLFWwindow window)", },
  ["glfwGetCurrentWindow"] = { type ='function', 
    description = "", 
    returns = "(GLFWwindow)",
    valuetype = nil,
    args = "(void)", },
  ["glfwCloseWindow"] = { type ='function', 
    description = "", 
    returns = "(void)",
    valuetype = nil,
    args = "(GLFWwindow window)", },
  ["glfwSetWindowTitle"] = { type ='function', 
    description = "", 
    returns = "(void)",
    valuetype = nil,
    args = "(GLFWwindow, const char* title)", },
  ["glfwGetWindowSize"] = { type ='function', 
    description = "", 
    returns = "(void)",
    valuetype = nil,
    args = "(GLFWwindow, int* width, int* height)", },
  ["glfwSetWindowSize"] = { type ='function', 
    description = "", 
    returns = "(void)",
    valuetype = nil,
    args = "(GLFWwindow, int  width, int  height)", },
  ["glfwGetWindowPos"] = { type ='function', 
    description = "", 
    returns = "(void)",
    valuetype = nil,
    args = "(GLFWwindow, int* x, int* y)", },
  ["glfwSetWindowPos"] = { type ='function', 
    description = "", 
    returns = "(void)",
    valuetype = nil,
    args = "(GLFWwindow, int  x, int  y)", },
  ["glfwIconifyWindow"] = { type ='function', 
    description = "", 
    returns = "(void)",
    valuetype = nil,
    args = "(GLFWwindow window)", },
  ["glfwRestoreWindow"] = { type ='function', 
    description = "", 
    returns = "(void)",
    valuetype = nil,
    args = "(GLFWwindow window)", },
  ["glfwGetWindowParam"] = { type ='function', 
    description = "", 
    returns = "(int)",
    valuetype = nil,
    args = "(GLFWwindow window, int param)", },
  ["glfwSetWindowUserPointer"] = { type ='function', 
    description = "", 
    returns = "(void)",
    valuetype = nil,
    args = "(GLFWwindow window, void* pointer)", },
  ["glfwGetWindowUserPointer"] = { type ='function', 
    description = "", 
    returns = "(void*)",
    valuetype = nil,
    args = "(GLFWwindow window)", },
  ["glfwPollEvents"] = { type ='function', 
    description = "", 
    returns = "(void)",
    valuetype = nil,
    args = "(void)", },
  ["glfwWaitEvents"] = { type ='function', 
    description = "", 
    returns = "(void)",
    valuetype = nil,
    args = "(void)", },
  ["glfwGetKey"] = { type ='function', 
    description = "", 
    returns = "(int)",
    valuetype = nil,
    args = "(GLFWwindow window, int key)", },
  ["glfwGetMouseButton"] = { type ='function', 
    description = "", 
    returns = "(int)",
    valuetype = nil,
    args = "(GLFWwindow window, int button)", },
  ["glfwGetMousePos"] = { type ='function', 
    description = "", 
    returns = "(void)",
    valuetype = nil,
    args = "(GLFWwindow window, int* xpos, int* ypos)", },
  ["glfwSetMousePos"] = { type ='function', 
    description = "", 
    returns = "(void)",
    valuetype = nil,
    args = "(GLFWwindow window, int  xpos, int  ypos)", },
  ["glfwGetScrollOffset"] = { type ='function', 
    description = "", 
    returns = "(void)",
    valuetype = nil,
    args = "(GLFWwindow window, int* x, int* y)", },
  ["glfwGetJoystickParam"] = { type ='function', 
    description = "", 
    returns = "(int)",
    valuetype = nil,
    args = "(int joy, int param)", },
  ["glfwGetJoystickPos"] = { type ='function', 
    description = "", 
    returns = "(int)",
    valuetype = nil,
    args = "(int joy, float* pos, int numaxes)", },
  ["glfwGetJoystickButtons"] = { type ='function', 
    description = "", 
    returns = "(int)",
    valuetype = nil,
    args = "(int joy, unsigned char* buttons, int numbuttons)", },
  ["glfwGetTime"] = { type ='function', 
    description = "", 
    returns = "(double)",
    valuetype = nil,
    args = "(void)", },
  ["glfwSetTime"] = { type ='function', 
    description = "", 
    returns = "(void)",
    valuetype = nil,
    args = "(double time)", },
  ["glfwSwapBuffers"] = { type ='function', 
    description = "", 
    returns = "(void)",
    valuetype = nil,
    args = "(void)", },
  ["glfwSwapInterval"] = { type ='function', 
    description = "", 
    returns = "(void)",
    valuetype = nil,
    args = "(int interval)", },
  ["glfwExtensionSupported"] = { type ='function', 
    description = "", 
    returns = "(int)",
    valuetype = nil,
    args = "(const char* extension)", },
  ["glfwGetProcAddress"] = { type ='function', 
    description = "", 
    returns = "(void*)",
    valuetype = nil,
    args = "(const char* procname)", },
  ["glfwGetGLVersion"] = { type ='function', 
    description = "", 
    returns = "(void)",
    valuetype = nil,
    args = "(int* major, int* minor, int* rev)", },
  ["glfwEnable"] = { type ='function', 
    description = "", 
    returns = "(void)",
    valuetype = nil,
    args = "(GLFWwindow window, int token)", },
  ["glfwDisable"] = { type ='function', 
    description = "", 
    returns = "(void)",
    valuetype = nil,
    args = "(GLFWwindow window, int token)", },
  ["GLFWvidmode"] = { type ='class', 
    description = "", 
    childs =     {
    ["width"] = { type ='value', description = "int", valuetype = nil, },
    ["height"] = { type ='value', description = "int", valuetype = nil, },
    ["redBits"] = { type ='value', description = "int", valuetype = nil, },
    ["blueBits"] = { type ='value', description = "int", valuetype = nil, },
    ["greenBits"] = { type ='value', description = "int", valuetype = nil, },
    }
  },
  ["GLFWgammaramp"] = { type ='class', 
    description = "", 
    childs =     {
    ["short"] = { type ='value', description = "unsignedred[GLFW_GAMMA_RAMP_SIZE]", valuetype = nil, },
    ["short"] = { type ='value', description = "unsignedgreen[GLFW_GAMMA_RAMP_SIZE]", valuetype = nil, },
    ["short"] = { type ='value', description = "unsignedblue[GLFW_GAMMA_RAMP_SIZE]", valuetype = nil, },
    }
  },
  }
return {
  glfw = {
    type = 'lib',
    description = "GLFW window manager",
    childs = api,
  },
}
