
if not pioneer_ui then pioneer_ui = {} end

-- Pioneer HUD. This is called after pioneer is created
function pioneer_ui.build(pioneer)

  if not pioneer then return end
  local ctrl = pioneer:GetController()
  if not ctrl then return end
		
  if not pioneer.ui then pioneer.ui = {} end
	
	ctrl:DeleteAllUIBars() -- there could be some bars from previous pioneer from which it respawns to this new pioneer
	ctrl:ResetOnRespawn()
  
	local metals = ctrl:AddUIBar()
	local metals_lab = ctrl:AddUIBar()
	local carbon = ctrl:AddUIBar()
	local carbon_lab = ctrl:AddUIBar()
	local water = ctrl:AddUIBar()
	local water_lab = ctrl:AddUIBar()
	local silicon = ctrl:AddUIBar()
	local silicon_lab = ctrl:AddUIBar()
	local aurium = ctrl:AddUIBar()
	local aurium_val = ctrl:AddUIBar()
	local charge = ctrl:AddUIBar()
	local charge_lab = ctrl:AddUIBar()
	
	-- Set them all to be invisible at first; Update will make em visible again
	metals:SetVisible(false)
	metals_lab:SetVisible(false)
	carbon:SetVisible(false)
	carbon_lab:SetVisible(false)
	water:SetVisible(false)
	water_lab:SetVisible(false)
	silicon:SetVisible(false)
	silicon_lab:SetVisible(false)
	aurium:SetVisible(false)
	aurium_val:SetVisible(false)
	charge:SetVisible(false)
	charge_lab:SetVisible(false)
	
	pioneer.ui.metals = metals:GetID()
	pioneer.ui.metals_lab = metals_lab:GetID()
	pioneer.ui.carbon = carbon:GetID()
	pioneer.ui.carbon_lab = carbon_lab:GetID()
	pioneer.ui.water = water:GetID()
	pioneer.ui.water_lab = water_lab:GetID()
	pioneer.ui.silicon = silicon:GetID()
	pioneer.ui.silicon_lab = silicon_lab:GetID()
	pioneer.ui.aurium = aurium:GetID()
	pioneer.ui.aurium_val = aurium_val:GetID()
	pioneer.ui.charge = charge:GetID()
	pioneer.ui.charge_lab = charge_lab:GetID()
	
	pioneer.ui.metals_HUD_timer = pioneer:CreateTimer()
	pioneer.ui.carbon_HUD_timer = pioneer:CreateTimer()
	pioneer.ui.water_HUD_timer = pioneer:CreateTimer()
	pioneer.ui.silicon_HUD_timer = pioneer:CreateTimer()
	pioneer.ui.aurium_HUD_timer = pioneer:CreateTimer()
	pioneer.ui.charge_HUD_timer = pioneer:CreateTimer()
	pioneer.ui.init_timer = pioneer:CreateTimer()
	
	local time_go = 0.5
	pioneer.ui.metals_HUD_timer:SetTimer(time_go, time_go)
	pioneer.ui.carbon_HUD_timer:SetTimer(time_go, time_go)
	pioneer.ui.water_HUD_timer:SetTimer(time_go, time_go)
	pioneer.ui.silicon_HUD_timer:SetTimer(time_go, time_go)
	pioneer.ui.aurium_HUD_timer:SetTimer(time_go, time_go)
	pioneer.ui.charge_HUD_timer:SetTimer(time_go, time_go)
	pioneer.ui.init_timer:SetTimeLimit(0.6)
	
	-- All the screen offsets and positions
	pioneer.ui.pos = VectorF(0.5, 1)
	pioneer.ui.shift = VectorF(0, -26)
	pioneer.ui.size = VectorF(75,6)
	pioneer.ui.init_value = 1000
	pioneer.ui.max_value = 1000
	pioneer.ui.label_pos = VectorF(0,8)
	pioneer.ui.label2_pos = VectorF(0,-10)
	pioneer.ui.label2_hud_pos_empty = VectorF(-64, -1)
	pioneer.ui.label2_hud_pos_full = VectorF(64, -1)
	pioneer.ui.displace = 86
	-- How much shifted up each bar is each frame to make a stack above the Pio when displayed in HUD mode
	pioneer.ui.hud_stack_offset = 0
	
	-- All the colors of bars
	pioneer.ui.col_metals = ColorRGBA(230,50,50,255)
	pioneer.ui.col_carbon = ColorRGBA(50,180,50,255)
	pioneer.ui.col_water = ColorRGBA(120,160,255,255)
	pioneer.ui.col_silicon = ColorRGBA(220,180,50,255)
	pioneer.ui.col_charge = ColorRGBA(200,100,200,255)
	pioneer.ui.col_aurium = ColorRGBA(200,100,200,255)
	
	pioneer.ui.col_metals_bg = ColorRGBA(200,50,50,155)
	pioneer.ui.col_carbon_bg = ColorRGBA(30,170,30,155)
	pioneer.ui.col_water_bg = ColorRGBA(80,160,255,155)
	pioneer.ui.col_silicon_bg = ColorRGBA(255,180,50,155)
	pioneer.ui.col_charge_bg = ColorRGBA(170,140,170,155)
	pioneer.ui.col_aurium_bg = ColorRGBA(170,140,170,155)
	
	-- Label colors when blinking
	pioneer.ui.col_lab2 = ColorRGBA(255,255,255,255);
	pioneer.ui.col_lab2_blink = ColorRGBA(0,0,0,0);
	pioneer.ui.col_lab2_crit = ColorRGBA(200,0,0,255);
end

function pioneer_ui.update_bar(pioneer, bar, blink_bar, bar_value, max_value, color, color_bg, label, displace_mult, empty_blink, change_blink, full_blink, blink_timer)
	if not (pioneer and pioneer.body_mo and bar and blink_bar) then return end
	
	local any_blink = empty_blink or change_blink or full_blink
	
	-- Basic params setup
	bar:SetVisible(true)
	bar:SetSize(pioneer.ui.size)
	bar:SetValue(pioneer.ui.init_value)
	bar:SetMaxValue(pioneer.ui.max_value)
	bar:SetColorBar(color)
	bar:SetColorBG(color_bg)
	bar:SetLabel(label)
	bar:SetLabelPosition(pioneer.ui.label_pos)
	bar:SetLabelColor(color)
		
	-- If bar is blinking and doing stuff, show it at HUD position for a while to grab attention
	if any_blink then blink_timer:Reset() end
	-- In HUD mode, place it above the player's head
	if not blink_timer:TimeIsUp() then
		bar:SetScreenPositioning(false)
		bar:SetUseRelativePosition(true)
		bar:SetPosition(pioneer:GetAssemblyApproxPos() + pioneer.body_mo:RotateVectorForGravity(VectorF(0,2)))
		bar:SetRelativePos(VectorF(0, pioneer.ui.hud_stack_offset))
		
		blink_bar:SetScreenPositioning(false)
		blink_bar:SetUseRelativePosition(true)
		blink_bar:SetPosition(pioneer:GetAssemblyApproxPos() + pioneer.body_mo:RotateVectorForGravity(VectorF(0,2)))
		blink_bar:SetRelativePos(VectorF(0, pioneer.ui.hud_stack_offset))
		blink_bar:SetLabelPosition(pioneer.ui.label2_hud_pos_full)
		blink_bar:SetLabelColor(pioneer.ui.col_lab2)
		blink_bar:SetBlinkColorLabel(pioneer.ui.col_lab2_blink)
		blink_bar:SetBlinkColorLabelOutline(pioneer.ui.col_lab2_blink)
		
		-- Stack these; have var that keeps track each frame of the stack end
		pioneer.ui.hud_stack_offset = pioneer.ui.hud_stack_offset + 20
	-- If NOT in HUD mode, ie nothing interesting happening with it for a while, put it at default positions at the top of screen
	else
		bar:SetScreenPositioning(true)
		bar:SetUseRelativePosition(true)
		bar:SetRelativePos(pioneer.ui.pos)
		bar:SetPosition(pioneer.ui.shift+VectorF(pioneer.ui.displace * displace_mult, 0))
		bar:SetLabelPosition(pioneer.ui.label_pos)
		
		blink_bar:SetRelativePos(pioneer.ui.pos)
		blink_bar:SetPosition(pioneer.ui.shift+VectorF(pioneer.ui.displace * displace_mult, 0))
		blink_bar:SetLabelVisible(false)
		blink_bar:SetLabelPosition(pioneer.ui.label2_pos)
		blink_bar:SetLabelColor(pioneer.ui.col_lab2)
		blink_bar:SetBlinkColorLabel(pioneer.ui.col_lab2_blink)
		blink_bar:SetBlinkColorLabelOutline(pioneer.ui.col_lab2_blink)
		blink_bar:SetBlinking(true)
	end
	-- Set value of what the bar actually displays
	bar:SetValue(bar_value)
	bar:SetMaxValue(max_value)
--	bar:SetBlinking(any_blink)
	bar:SetBlinking(empty_blink or full_blink)
	
	-- Blink label bar if full or empty
	blink_bar:SetVisible(false)
	blink_bar:SetLabelVisible(false)
	
	if full_blink then
		blink_bar:SetLabelVisible(true)
		blink_bar:SetLabelPosition(pioneer.ui.label2_hud_pos_full)
		blink_bar:SetLabel("FULL!")
	else
		if empty_blink then
			blink_bar:SetLabelVisible(true)
			blink_bar:SetLabelPosition(pioneer.ui.label2_hud_pos_empty)
			blink_bar:SetLabel("EMPTY!")
		end
	end
end

-- Pioneer HUD. This is called after each frame update
function pioneer_ui.update(pioneer)
  
  if not pioneer then return end
  local ctrl = pioneer:GetController()
  if not ctrl then return end
	-- Reset the HUD stack offset so we can stack 'em vertically nicely
	pioneer.ui.hud_stack_offset = 0
	
	-- Store the aurium charge of the pioneer so this is backwards compatible with pio scripts prior to Aurium impl
	local aurium_charge = 0
	if pioneer.aurium_charge then
		aurium_charge = pioneer.aurium_charge
	end
	local aurium_capacity = 100
	if pioneer.aurium_capacity then
		aurium_capacity = pioneer.aurium_capacity
	end
	-- Time since last aurium store change, so we can show the Aurium store thing when we are atomizing charged MOs
	local time_since_last_aurium_change = 2.0
	if pioneer.aurium_store_change_timer then
		time_since_last_aurium_change = pioneer.aurium_store_change_timer:GetTime()
	end
	local time_since_last_charge_change = 2.0
	if pioneer.aurium_charge_change_timer then
		time_since_last_charge_change = pioneer.aurium_charge_change_timer:GetTime()
	end
	local time_since_last_charge_use = 2.0
	if pioneer.no_aurium_use_timer then
		time_since_last_charge_use = pioneer.no_aurium_use_timer:GetTime()
	end
	local time_since_last_recharge = 2.0
	if pioneer.aurium_recharge_timer then
		time_since_last_recharge = pioneer.aurium_recharge_timer:GetTime()
	end

	-- UPDATE THE BARS in reverse order so we can stack them nicely on top of each other if they're in HUD mode:
	-- Charge
	
	pioneer_ui.update_bar(pioneer, ctrl:GetUIBarByID(pioneer.ui.charge), ctrl:GetUIBarByID(pioneer.ui.charge_lab), aurium_charge, aurium_capacity, pioneer.ui.col_aurium, pioneer.ui.col_aurium_bg, "CHARGE", 2.5, pioneer.ui.init_timer:TimeIsUp() and aurium_charge <= 0 and time_since_last_charge_change < 1.5, time_since_last_charge_change < 0.5, false, pioneer.ui.charge_HUD_timer)
	-- Aurium
	pioneer_ui.update_bar(pioneer, ctrl:GetUIBarByID(pioneer.ui.aurium), ctrl:GetUIBarByID(pioneer.ui.aurium_val), ctrl:GetAurium(), 1.0, pioneer.ui.col_aurium, pioneer.ui.col_aurium_bg, "AURIUM", 1.5, pioneer.ui.init_timer:TimeIsUp() and ctrl:GetAurium() < 0.5 and time_since_last_charge_change < 0.5, time_since_last_aurium_change < 0.5, false, pioneer.ui.aurium_HUD_timer)
	-- Silicon
	pioneer_ui.update_bar(pioneer, ctrl:GetUIBarByID(pioneer.ui.silicon), ctrl:GetUIBarByID(pioneer.ui.silicon_lab), ctrl:GetResSilicon(), ctrl:GetResMax(), pioneer.ui.col_silicon, pioneer.ui.col_silicon_bg, "SILICON", 0.5, ctrl:GetBlinkEmptyOfSilicon(), ctrl:GetBlinkChangeOfSilicon(), ctrl:GetBlinkFullOfSilicon(), pioneer.ui.silicon_HUD_timer)
	-- Water
	pioneer_ui.update_bar(pioneer, ctrl:GetUIBarByID(pioneer.ui.water), ctrl:GetUIBarByID(pioneer.ui.water_lab), ctrl:GetResWater(), ctrl:GetResMax(), pioneer.ui.col_water, pioneer.ui.col_water_bg, "WATER", -0.5, ctrl:GetBlinkEmptyOfWater(), ctrl:GetBlinkChangeOfWater(), ctrl:GetBlinkFullOfWater(), pioneer.ui.water_HUD_timer)
	-- Carbon
	pioneer_ui.update_bar(pioneer, ctrl:GetUIBarByID(pioneer.ui.carbon), ctrl:GetUIBarByID(pioneer.ui.carbon_lab), ctrl:GetResCarbon(), ctrl:GetResMax(), pioneer.ui.col_carbon, pioneer.ui.col_carbon_bg, "CARBON", -1.5, ctrl:GetBlinkEmptyOfCarbon(), ctrl:GetBlinkChangeOfCarbon(), ctrl:GetBlinkFullOfCarbon(), pioneer.ui.carbon_HUD_timer)
	-- Metals
	pioneer_ui.update_bar(pioneer, ctrl:GetUIBarByID(pioneer.ui.metals), ctrl:GetUIBarByID(pioneer.ui.metals_lab), ctrl:GetResMetals(), ctrl:GetResMax(), pioneer.ui.col_metals, pioneer.ui.col_metals_bg, "METALS", -2.5, ctrl:GetBlinkEmptyOfMetals(), ctrl:GetBlinkChangeOfMetals(), ctrl:GetBlinkFullOfMetals(), pioneer.ui.metals_HUD_timer)

	-- Make the special adjustments to the Aurium Store meter
	bar = ctrl:GetUIBarByID( pioneer.ui.aurium )
	if bar then
		bar:SetVisible(false)
		bar:SetBlinking(time_since_last_recharge < 0.5 and ctrl:GetAurium() > 0.5)
	end

	bar = ctrl:GetUIBarByID( pioneer.ui.aurium_val )
	if bar then
		bar:SetVisible(false)
		bar:SetLabelVisible(true)
		bar:SetLabel(tostring(math.floor(ctrl:GetAurium() + 0.5)))
		bar:SetLabelPosition(VectorF(0,-2))
		bar:SetBlinking(pioneer.ui.init_timer:TimeIsUp() and ctrl:GetAurium() < 0.5)
		-- Show red numbers if Store is low on Aurium
		if ctrl:GetAurium() < 500 then
			bar:SetLabelColor(pioneer.ui.col_lab2_crit)
		else
			bar:SetLabelColor(pioneer.ui.col_lab2)
		end
		bar:SetBlinkColorLabel(pioneer.ui.col_lab2_blink)
		bar:SetBlinkColorLabelOutline(pioneer.ui.col_lab2_blink)
		-- HUD position mode
		if not pioneer.ui.aurium_HUD_timer:TimeIsUp() then
--  		bar:SetPosition(pioneer.ui.shift+VectorF(pioneer.ui.displace*1.5, -10))
		-- Top of screen mode
		else
			bar:SetScreenPositioning(true)
			bar:SetUseRelativePosition(true)
			bar:SetRelativePos(pioneer.ui.pos)
		end
	end
	
	bar = ctrl:GetUIBarByID( pioneer.ui.charge )
	if bar then
		bar:SetBlinking(bar:GetBlinking() and pioneer.ui.init_timer:TimeIsUp() and ctrl:GetAurium() > 0.5)
	end
	
	bar = ctrl:GetUIBarByID( pioneer.ui.charge_lab )
	if bar then
		bar:SetVisible(false)
		bar:SetBlinking(bar:GetBlinking() and pioneer.ui.init_timer:TimeIsUp())
	end
	
end












































