
if not pioneer_std then pioneer_std = {} end

-- Pioneer standardized Build. This is called at beginning of Pioneer Build in its own script
function pioneer_std.build(self)
  if not self then return end

	self.capsule_break_wait_time = 2.5
	self.respawn_effect_triggered = false

	-- break capsule
	function self.break_capsule()
		-- break capsule
		local capsule = self:GetMOByName("Capsule")
		if capsule then
			capsule:BreakMOAtRandomPoint()
		end
		-- break capsule joint
		local cap_joint = self:GetJointByName("Capsule")
		if cap_joint then 
			cap_joint:BreakJoint() 
		end
	end
	
	-- delete capsule
	function self.delete_capsule()
		-- delete capsule
		scene:DeleteMO(self:GetMOByName("Capsule"))
		-- delete capsule joint
		scene:DeleteJoint(self:GetJointByName("Capsule"))
		-- delete capsle effect
		scene:DeletePS(self:GetPSByName("Respawn"))
		
	end
	
	function self.control_lights_enabled()
		local lights_on = true
		local assy = self:GetMountedToAssemblyByAT("Vehicle")
		if assy then
			if assy:HasTag("Ship") then
				lights_on = false
			end
		end
		local lig = self:GetLightByName("Spot")
		if lig then lig:SetSwitchedOn(lights_on) end
		lig = self:GetLightByName("Omni")
		if lig then lig:SetSwitchedOn(lights_on) end
	end
	

	

  ------------------------------------------------
  -- Init Constants

  ---------------------------------------------------
  -- Pose Animations Enum
  -- TODO: Get these directly from the blueprint, where they are defined in BP pose editor?

  self.poseanim = {}
  self.poseanim.none = { name = "None", intervals = { 1.0 }, fade = false, loop = false }
  self.poseanim.idle = { name = "Idle", intervals = { 0 }, fade = false, loop = true }
  self.poseanim.die = { name = "Die", intervals = { 0.3 }, fade = false, loop = false }
  self.poseanim.slack = { name = "Slack", intervals = { 0.3 }, fade = false, loop = false }
  self.poseanim.ride = { name = "Ride", intervals = { 0.3 }, fade = false, loop = false }
  self.poseanim.step = { name = "Step", intervals = { 0.15, 0.15, 0.15 }, fade = true, loop = false }
  self.poseanim.walk = { name = "Walk", intervals = { 0.15, 0.15, 0.15, 0.15, 0.15, 0.15 }, fade = true, loop = true }
  self.poseanim.run = { name = "Run", intervals = { 0.075, 0.075, 0.075, 0.075, 0.075, 0.075 }, fade = true, loop = true }
  self.poseanim.climb = { name = "Climb", intervals = { 0.15, 0.15, 0.15, 0.15, 0.15, 0.15 }, fade = true, loop = true }
  self.poseanim.crawl = { name = "Crawl", intervals = { 0.075, 0.075, 0.075, 0.075, 0.075, 0.075 }, fade = true, loop = true }
  self.poseanim.prejump = { name = "PreJump", intervals = { 0.15 }, fade = false, loop = false }
  self.poseanim.jump = { name = "Jump", intervals = { 0.25 }, fade = false, loop = false }
	self.poseanim.postjump = { name = "PostJump", intervals = { 0.30 }, fade = true, loop = false }
  self.poseanim.fall = { name = "Fall", intervals = { 0.15, 0.15, 0.15, 0.15 }, fade = true, loop = true }
  self.poseanim.fly = { name = "Fly", intervals = { 0.25 }, fade = false, loop = false }
  self.poseanim.get_up_back = { name = "Get Up Back", intervals = { 0.20 }, fade = true, loop = false }
  self.poseanim.get_up_front = { name = "Get Up Front", intervals = { 0.20 }, fade = true, loop = false }
  self.poseanim.go_prone = { name = "Go Prone", intervals = { 0.25, 0.25 }, fade = true, loop = false }
  self.poseanim.teeter = { name = "Teeter", intervals = { 0.15, 0.15, 0.15 }, fade = true, loop = true }
  self.poseanim.skid = { name = "Skid", intervals = { 0.5 }, fade = false, loop = false }
  self.poseanim.slide = { name = "Slide", intervals = { 0.05 }, fade = false, loop = true }
  self.poseanim.grab_tool = { name = "Grab Tool", intervals = { 0.25 }, fade = false, loop = false }
  self.poseanim.draw_tool = { name = "Draw Tool", intervals = { 0.25 }, fade = false, loop = false }
  self.poseanim.mounted = { name = "Mounted", intervals = { 0.25 }, fade = false, loop = false }
  self.poseanim.point_at = { name = "Point At", intervals = { 0.15 }, fade = false, loop = false }
	self.poseanim.crouch = { name = "Crouch", intervals = { 0.2 }, fade = false, loop = true }
	self.poseanim.lift = { name = "Lift", intervals =  { 0.3, 0.3, 0.3 }, fade = true, loop = false }
	self.poseanim.throw_charge = { name = "Throw Charge", intervals = { 0.15 }, fade = false, loop = false }
	self.poseanim.throw = { name = "Throw", intervals = { 0.15 }, fade = false, loop = false }


  ---------------------------------------------------
  -- Joint Group State Enumeration
  
  -- Temporary name list we'll use to create the state table
  local joint_group_state_names = {
  "IDLE",
  "DIE",
  "SLACK",
  "BRACE",
  "RIDE",
  "STEP",
  "WALK",
  "RUN",
  "CLIMB",
  "CRAWL",
  "GET_UP_BACK",
  "GET_UP_FRONT",
  "GO_PRONE",
  "TEETER",
  "PREJUMP",
  "JUMP",
  "POSTJUMP",
  "FALL",
  "FLY",
  "SKID",
  "SLIDE",
  "SHIELD",
  "GRAB_TOOL",
  "DRAW_TOOL",
  "AIM_TOOL_AT",
  "POINT_AT",
  "ATOMIZE",
  "ASSEMBLE",
	"CROUCH",
	"LIFT",
	"THROW_CHARGE",
	"THROW"
  }

  -- Create the state table for Joint Group States
  self.jgs = {}
  for i, v in ipairs(joint_group_state_names) do
    self.jgs[v] = i
  end

  ---------------------------------------------------
  -- Init State Variables

  -- Joint Groups
  self.jg = {}
  --self.jg.all = { name = "", state = self.jgs.IDLE, state_changed = true, anim = self.poseanim.idle, anim_num = 1, anim_speed = 1.0 }
  self.jg.legs = { name = "Leg", state = self.jgs.IDLE, state_changed = true,  anim = self.poseanim.idle, anim_num = 1, anim_speed = 1.0, hold_timer = self:CreateTimer(), point_target = VectorF }
  self.jg.arm_fg = { name = "Arm FG", state = self.jgs.IDLE, state_changed = true, anim = self.poseanim.idle, anim_num = 1, anim_speed = 1.0, hold_timer = self:CreateTimer(), point_target = VectorF }
  self.jg.arm_bg = { name = "Arm BG", state = self.jgs.IDLE, state_changed = true, anim = self.poseanim.idle, anim_num = 1, anim_speed = 1.0, hold_timer = self:CreateTimer(), point_target = VectorF }
  self.jg.neck = { name = "Neck", state = self.jgs.IDLE, state_changed = true, anim = self.poseanim.idle, anim_num = 1, anim_speed = 1.0, hold_timer = self:CreateTimer(), point_target = VectorF }

  -- Balance states
  self.balance = {}
  self.balance.NONE = 1
  self.balance.BIPED = 2
  self.balance.GET_UP = 3
  self.balance.GO_PRONE = 4
  self.balance.JUMPING = 5
  self.balance.FLYING = 6
  self.balance.PRONE = 7
	self.balance.LIFT = 8

  -- Misc state things

  -- Relative or Absolute flight control mode
-- TODO: Make this set by a player-specific setting the engine gives us
-- TODO: won't this break determinism if defined globally?
  self.relative_flight_control = c2d_settings.relative_flight_control
  self.is_ambulating_left = false
  self.ambulation_input = VectorF(0, 0)
  self.jetpack_input = 0
  self.sliding_input = 0
	-- Last recorded Aurium Store value in the current Controller
  self.aurium_last_store = 0
  -- Current suit Aurium charge level
  self.aurium_charge = 0
  -- Max capacity of the Aurium battery/capacitor
  self.aurium_capacity = 100
  -- How much aurium per second is recharged from Aurium store into the battery
  self.aurium_recharge_rate = 50
  -- How much of a delay (in s) after all Aurium consumption stops until recharge starts
  self.aurium_recharge_delay = 0.5
	-- How much A is consumed each s of flight
	self.flight_aurium_consumption = 125
  
  -- Current balancing state
  self.balance_state = self.balance.NONE
  -- The lean of the torso from angle 0 that the balancer tries to achieve
  self.balance_lean = 0
  self.balance_power = 6000
  self.slippery_limbs = 0.5
  self.slippery_body = 0.5
  -- Raycasting vectors
  self.raycast_legvec_right = VectorF(0.6, 0.0)
  self.raycast_legvec_left = VectorF(-0.6, 0.0)
  self.arm_fg_point_at_target = VectorF(0, 0)
  self.arm_bg_point_at_target = VectorF(0, 0)
  self.neck_look_at_target = VectorF(0, 0)
  self.tool_aim_at_target = VectorF(0, 0)
  -- Tool Mounting
  -- little radar for searching for tools nearby
  self.tool_radar = self:GetRadars():AddRadar("Tool Search")
  self.tool_radar:SetEnabled(Yes)
  self.tool_radar:SetUpCone(VectorF(0,0), 0, math.pi*2, 1.5)
  self.tool_radar:SetUpCheck(Yes, No, No, No)
  -- Vehicle Mounting
  -- here we'll store id of vehicle assembly to which we're currently entering
  self.target_approaching_id = -1
  -- here we'll store id of vehicle assembly from which we're currently escaping, so we can make pioneer automatically walk left or right away from vehicle
  self.target_escaping_id = -1
  -- if we press to escape vehicle, we need to ignore the enter/exit button pressed then until released that button
  self.ignore_approaching_target_now = No
	-- correct angle of mounted ingot
	self.correct_mount_target = false

  -- Commonly accessed MOs
  self.head_mo = self:GetMOByName("Head")
  self.body_mo = self:GetMOByName("Torso")
  self.hip_joint = self:GetJointByName("Leg FG Hip")
  if self.hip_joint == nil then self.hip_joint = self:GetJointByName("Leg BG Hip") end

  ----------------------------------------------------
  -- Timers

  -- How long ago we changed mirroring
  self.mirror_change_timer = self:CreateTimer()
  
  -- How long ago we changed aim point
  self.aim_point_change_timer = self:CreateTimer()
  
  -- How long we are dying
  self.dying_timer = self:CreateTimer()
  self.dying_timer:SetTimeLimit(1.0)

	-- Aurium charge timers
	-- How long since nothing used any aurium at all
	self.no_aurium_use_timer = self:CreateTimer()
	self.no_aurium_use_timer:SetTimeLimit(self.aurium_recharge_delay)
	self.aurium_charge_change_timer = self:CreateTimer()
	self.aurium_charge_change_timer:SetTimer(2,2)
	self.aurium_recharge_timer = self:CreateTimer()
	self.aurium_recharge_timer:SetTimer(2,2)
	-- Time since last time this' controller's A store changed value
	self.aurium_store_change_timer = self:CreateTimer()
	self.aurium_store_change_timer:SetTimer(2,2)

  -- Auto fire timer
  self.last_fire_timer = self:CreateTimer()
  self.last_fire_timer:SetTimeLimit(0.1)
  
  -- Timer since last time we lost balance
  self.regain_balance_timer = self:CreateTimer()
  -- How long it takes to fully regain balance after losing it (and being able to regain)
  self.regain_balance_timer:SetTimeLimit(0.5)
  -- Start off in balanced state
  self.regain_balance_timer:SetTime(1.1)
  -- Timer since we started climbing
  self.climbing_timer = self:CreateTimer()
  self.climbing_timer:SetTimer(0, 0.75)
  -- Timer since we started flying this burst
  self.total_flight_timer = self:CreateTimer()
  -- Timer since we stopped giving flight input
  self.flight_stop_timer = self:CreateTimer()
  -- Timer for checking how long our feet have both been on one side of CoM
  self.off_balance_timer = self:CreateTimer()
  -- Timer for shifting weight when skidding to a stop after walking
  self.counter_lean_timer = self:CreateTimer()
  -- Timer for looking for tool nearby
  self.look_for_tool_timer = self:CreateTimer()
  self.look_for_tool_timer:SetTimer(0, 1)

  -----------------------------------------------------
  -- Physics Setup

  -- for now we deny deformations on limbs completely
  self:MOSet("Leg"):SetAllowPlasticDeform(false)
  self:MOSet("Arm"):SetAllowPlasticDeform(false)

  -----------------------------------------------------
  -- Joints Setup

  -- commonly used spring powers
  self.angular_spring_power_stiff = 6000
  self.angular_spring_power_stiffer = 7000
  self.angular_spring_power_loose = 1000
  self.angular_spring_friction = 40
  
  self:SetAngularSpringPowers("Leg", self.angular_spring_power_stiff)
  self:SetAngularSpringPowers("Arm", self.angular_spring_power_stiff)
  self:SetAngularSpringPowers("Neck", self.angular_spring_power_stiff)
  self:SetAngularFrictions("Leg", self.angular_spring_friction)
  self:SetAngularFrictions("Arm", self.angular_spring_friction)
  self:SetAngularFrictions("Neck", self.angular_spring_friction)

  ------------------------------------------------------
  -- Balancer Setup

  -- so far we use self simple magic balancer to keep pioneer on legs
  self:MOSet("Head"):SetBalancer(false)
  self:MOSet("Head"):SetBalancerPower(self.balance_power * 0.80)
  self:MOSet("Torso"):SetBalancer(false)
  self:MOSet("Torso"):SetBalancerPower(self.balance_power)

  ---------------------------------------------------------
  -- Particle Systems Setup

  -- switch off jet particles
  --self:GetPSByName("Jetpack"):SwitchOFFParticleEmitting()


  --------------------------------------------------------
  -- CONTROLLER INPUT HANDLING
  --------------------------------------------------------
   
  function self.handle_input(controller)
		
    if not (controller and self.head_mo and self.body_mo) or self.is_dying() or self:IsDead() then
      return
    end
		
    -------- MOUNTING EXAMPLE CODE ----------  
    -- update tool radar pos
    if self.head_mo then
      self.tool_radar:SetConePoint(self.head_mo:GetPosition())
    end
    
    -- throw away / pick up tool  
		local carried_assy = self.get_carried_asssembly()
		if controller:Btn_Pickup_Press() then
   		local unmounted_now = No 
			if carried_assy then
				-- drop carried assembly
				if carried_assy:HasTag("Tool") then
					local tool_ass_obj = GetAssemblyLuaObj(carried_assy)
					if tool_ass_obj then 
						if tool_ass_obj.OnToolDeactivate then 
							tool_ass_obj.OnToolDeactivate() 
						end
					end
				end
				self:UnmountAssembly(carried_assy)
				self:GetController():SetCanAtomize(true)
				self:GetController():SetCanAssemble(true)
				self.idle()
        unmounted_now = Yes
				-- drop ingto
				if carried_assy:HasTag("Ingot") then
					carried_assy:GetMasterMO():SetHollownessBase(self.carried_mo_hollowness)
					local power = 300
					if self:IsMirrored() then
						power = -power
					end
					local acc = self.body_mo:RotateVectorForGravity(VectorF(power, math.abs(power)))
					carried_assy:MOSet(""):AddAcceleration(acc)
					self.throw()
				end
      end
      if not unmounted_now then
        -- set time to look for tool to grab
        self.look_for_tool_timer:Reset()
        self.look_for_tool_timer:Play()
      end
    end
    
    if self.look_for_tool_timer:GetPlaying() then
      -- pick up tool
      if (self.tool_radar:GetSignalsCount()>0) then
        if self:GetMountJointIsMounted("Tool Mount Arm FG") then
          self.look_for_tool_timer:Pause()
        else
          local mo = self.tool_radar:GetSignal(0):GetMO()
          if mo then
            -- there is some MO on the radar signal
            local found_assy = scene:GetMOLinkedAssembly(mo)
            if found_assy then
              
              -- TOOL PICKUP
              -- check if the assembly type is "Tool"
              if found_assy:HasTag("Tool") then
                -- it's a tool, let's mount it to pioneer 
                if found_assy then
                  if not found_assy:GetMountedToAssemblyByAT("Pioneer") then --if not found_assy:IsMountedToAnything() then 
                    -- we need to get tool assembly's MO that we will mount to pioneer
                    local tool_mo = found_assy:GetMasterMO() -- we choose master MO of tool assembly
                    if tool_mo then
                      -- we'll maybe need to mirror the tool, let's see
                      if found_assy:IsMirrored() ~= self:IsMirrored() then
                        found_assy:Mirror(Yes)
                      end
                      
                      --self:MountMOByJointNames(tool_mo, "Tool Mount Back")
                      if self:MountMOByJointNames(tool_mo, "Tool Mount Arm BG", Yes) 
                      and self:MountMOByJointNames(tool_mo, "Tool Mount Arm FG", Yes) then
                        self:GetController():SetCanAtomize(false)
                        self:GetController():SetCanAssemble(false)
												self.idle()
                        self.look_for_tool_timer:Pause()
                        local found_assy_obj = GetAssemblyLuaObj(found_assy)
                        if found_assy_obj then 
                          if found_assy_obj.OnToolActivate then 
                            found_assy_obj.OnToolActivate() 
                          end
                        end
                      end
                    end
                  end
                end
              end
							
            end
          end
        end
      end
    end
    
--[[ This is now used for Jetpack activation
    
    if controller:Btn_Pickup_Press() then
      -- put mounted tool from arms to back
      local something_in_hands = self:GetMountJointIsMounted("Tool Mount Arm FG")
      local something_on_back = self:GetMountJointIsMounted("Tool Mount Back")

      if something_in_hands and not something_on_back then
        -- unmount tool from arms, this equals to: self:UnmountAssembly(self.tool_mounted_to_arms)
        local found_assy = self:GetAssemblyMountedToJoint("Tool Mount Arm FG")
        if found_assy then
          -- unmount tool
          self:UnmountAssembly(found_assy)
          -- and mount it on back
          self:MountMOByJointNames(found_assy:GetMasterMO(), "Tool Mount Back", Yes)
          -- deactivate tool
          local found_assy_obj = GetAssemblyLuaObj(found_assy)
          if found_assy_obj then
            if found_assy_obj.OnToolDeactivate then 
              found_assy_obj.OnToolDeactivate() 
            end
          end
          self:GetController():SetCanAtomize(true)  
          self:GetController():SetCanAssemble(true)
        end
      else 
        if something_on_back and not something_in_hands then
          -- get mounted tool from back to arms
          local found_assy = self:GetAssemblyMountedToJoint("Tool Mount Back")
          if found_assy then
            -- unmount tool
            self:UnmountAssembly(found_assy)
            -- and mount it to hands
            self:MountMOByJointNames(found_assy:GetMasterMO(), "Tool Mount Arm BG", Yes)
            self:MountMOByJointNames(found_assy:GetMasterMO(), "Tool Mount Arm FG", Yes)
            -- activate tool
            local found_assy_obj = GetAssemblyLuaObj(found_assy)
            if found_assy_obj then 
              if found_assy_obj.OnToolActivate then 
                found_assy_obj.OnToolActivate() 
              end
            end
            self:GetController():SetCanAtomize(false)
            self:GetController():SetCanAssemble(false)
          end
        end 
      end
    end
]]--

  -------- end of MOUNTING EXAMPLE CODE ----------  


  ----------- NEW TOOL CONTROL EXAMPLE --------------------
    
    -- controling the tool, shooting, aiming, etc.
    -- first let's find tool that is ind hands
    local tool_assy = self:GetAssemblyMountedToJoint("Tool Mount Arm BG")
    if tool_assy then
      local tool_obj = GetAssemblyLuaObj(tool_assy)
      if tool_obj then 
      
        -- send events to tool assembly by controller input
        
        -- first send aim point, then the clicks
        if tool_obj.ToolAimPoint then
          tool_obj.ToolAimPoint(controller:AimPoint())
        end
        
        if controller:Btn_Tool1_Press() then
          if tool_obj.ToolLeftButtonPress then
            tool_obj.ToolLeftButtonPress()
          end
        end
        if controller:Btn_Tool1() then
          if tool_obj.ToolLeftButtonHold then
            tool_obj.ToolLeftButtonHold()
          end
        end
        if controller:Btn_Tool1_Release() then
          if tool_obj.ToolLeftButtonRelease then
            tool_obj.ToolLeftButtonRelease()
          end
        end
      
        if controller:Btn_Tool2_Press() then
          if tool_obj.ToolRightButtonPress then
            tool_obj.ToolRightButtonPress()
          end
        end
        if controller:Btn_Tool2() then
          if tool_obj.ToolRightButtonHold then
            tool_obj.ToolRightButtonHold()
          end  
        end
        if controller:Btn_Tool2_Release() then
          if tool_obj.ToolRightButtonRelease then
            tool_obj.ToolRightButtonRelease() 
          end
        end
      end
    end

  ----------- NEW VEHICLE CONTROL EXAMPLE --------------------

    -- controling the vehicle, shooting, aiming, etc.
    local vehicle_assy = self:GetMountedToAssemblyByAT("Vehicle")
    if vehicle_assy then
      
      -- the which parameter will infrom vehicle from which mount joint the pioneer controls the vehicle (because more pioneers can be mounted to one vehicle)
      local which = ""
      if self:GetMountedToJoint() then which = self:GetMountedToJoint():GetName() end 
      -- ! 'GetMountedToJoint' only finds some joint to which this assembly is mounted. however this assembly can be mounted to more mount joints. i used this only knowing that pioneer can be mounted to only one thing.
      
      local vehicle_obj = GetAssemblyLuaObj(vehicle_assy)
      if vehicle_obj then 
        
        if vehicle_obj.ControlAimPoint then
          vehicle_obj.ControlAimPoint(controller:AimPoint(), which)
        end
        
        if controller:Btn_Left_Press() then 
          if vehicle_obj.ControlLeftPress then
            vehicle_obj.ControlLeftPress(which) 
          end
        end
        if controller:Btn_Left() then 
          if vehicle_obj.ControlLeftHold then
            vehicle_obj.ControlLeftHold(which) 
          end
        end
        if controller:Btn_Left_Release() then 
          if vehicle_obj.ControlLeftRelease then
            vehicle_obj.ControlLeftRelease(which) 
          end
        end
        
        if controller:Btn_Right_Press() then 
          if vehicle_obj.ControlRightPress then
            vehicle_obj.ControlRightPress(which) 
          end
        end
        if controller:Btn_Right() then 
          if vehicle_obj.ControlRightHold then
            vehicle_obj.ControlRightHold(which) 
          end
        end
        if controller:Btn_Right_Release() then 
          if vehicle_obj.ControlRightRelease then
            vehicle_obj.ControlRightRelease(which) 
          end
        end
        
        if controller:Btn_Up_Press() then 
          if vehicle_obj.ControlUpPress then
            vehicle_obj.ControlUpPress(which) 
          end
        end
        if controller:Btn_Up() then 
          if vehicle_obj.ControlUpHold then
            vehicle_obj.ControlUpHold(which) 
          end
        end
        if controller:Btn_Up_Release() then 
          if vehicle_obj.ControlUpRelease then
            vehicle_obj.ControlUpRelease(which) 
          end
        end
        
        if controller:Btn_Down_Press() then 
          if vehicle_obj.ControlDownPress then
            vehicle_obj.ControlDownPress(which) 
          end
        end
        if controller:Btn_Down() then 
          if vehicle_obj.ControlDownHold then
            vehicle_obj.ControlDownHold(which) 
          end
        end
        if controller:Btn_Down_Release() then 
          if vehicle_obj.ControlDownRelease then
            vehicle_obj.ControlDownRelease(which) 
          end
        end
        
        if controller:Btn_Tool1_Press() then 
          if vehicle_obj.ControlShoot1Press then
            vehicle_obj.ControlShoot1Press(which) 
          end
        end
        if controller:Btn_Tool1() then 
          if vehicle_obj.ControlShoot1Hold then
            vehicle_obj.ControlShoot1Hold(which) 
          end
        end
        if controller:Btn_Tool1_Release() then 
          if vehicle_obj.ControlShoot1Release then
            vehicle_obj.ControlShoot1Release(which) 
          end
        end
        
        if controller:Btn_Tool2_Press() then 
          if vehicle_obj.ControlShoot2Press then
            vehicle_obj.ControlShoot2Press(which) 
          end
        end
        if controller:Btn_Tool2() then 
          if vehicle_obj.ControlShoot2Hold then
            vehicle_obj.ControlShoot2Hold(which) 
          end
        end
        if controller:Btn_Tool2_Release() then 
          if vehicle_obj.ControlShoot2Release then
            vehicle_obj.ControlShoot2Release(which) 
          end
        end 
        
        if controller:Btn_Shield_Press() then 
          if vehicle_obj.ControlBrakePress then
            vehicle_obj.ControlBrakePress(which) 
          end
        end
        if controller:Btn_Shield() then 
          if vehicle_obj.ControlBrakeHold then
            vehicle_obj.ControlBrakeHold(which) 
          end
        end
        if controller:Btn_Shield_Release() then 
          if vehicle_obj.ControlBrakeRelease then
            vehicle_obj.ControlBrakeRelease(which) 
          end
        end
        
      end
    end


    ------------------------------------------------------------
    -- PLAYER INPUT HANDLING
    ------------------------------------------------------------

    -- keys
    local key_left_downed = controller:Btn_Left_Press()-- or controller:MoveVector().mX < -0.5
    local key_left_upped = controller:Btn_Left_Release()-- or controller:MoveVector().mX >= -0.5
    local key_right_downed = controller:Btn_Right_Press()-- or controller:MoveVector().mY > 0.5
    local key_right_upped = controller:Btn_Right_Release()-- or controller:MoveVector().mX <= 0.5
    local no_move_input = not controller:Btn_Left() and not controller:Btn_Right() and not controller:Btn_Up() and not controller:Btn_Down()
    
    -- TODO: also look at analog move input    
--    local controller:MoveVector()

    local vehicle_assy = self:GetMountedToAssemblyByAT("Vehicle")
    if scene:GetAssemblyByID(self.target_approaching_id) then
			--ignore input while approaching target
		elseif vehicle_assy then
      -- mounted to vehicle, we stop moving and flying
      self.ride()
		else
      -- Pressed dedicated Jetpack button, OR Move Up when already airborne, so activate Jetpack then
      if controller:Btn_Jetpack() or (controller:MoveVector().mY > 0.35 and self.get_altitude(3) > 1.8) then
        self.fly(controller:MoveVector())
      else
				
				-- Regular Jump when pressing up (and below jetpack activating altitude already checked for above)
				if controller:MoveVector().mY > 0.35 then
					self.jump()
				end
				
        -- RELATIVE FLIGHT CONTROL MODE
        if self.relative_flight_control then
          if controller:Btn_Up_Release() then
            self.idle()
          end
          
          -- pressed down to go prone
          if controller:Btn_Down_Press() then
            self.go_prone()
          end
  --[[
          -- stop sliding
          if controller:Btn_Down_Release() then
            self.idle()
          end
  ]]--
          -- walking to the right
          if controller:Btn_Right() then
            self.ambulate(controller:MoveVector())
          end
          if key_right_upped then
              if controller:Btn_Down() then self.slide(controller:MoveVector().mX) else self.idle() end
          end
					
          -- walking to the left
          if controller:Btn_Left() then
            self.ambulate(controller:MoveVector())
          end
          if key_left_upped then
              if controller:Btn_Down() then self.slide(controller:MoveVector().mX) else self.idle() end
          end
          
        -- ABSOLUTE FLIGHT CONTROL MODE
        else
          if self.is_flying_now() then
            -- stop flying after a while of letting go of all controls - ABSOLUTE MODE
            if controller:Btn_Up_Release() then
              self.flight_stop_timer:Reset()
            end
            if no_move_input and self.flight_stop_timer:Elapsed(0.25) then
              self.idle()
            end
          else
          
            -- pressed down to go prone
            if controller:Btn_Down_Press() then
              self.go_prone()
            end
    --[[
            -- stop sliding
            if controller:Btn_Down_Release() then
              self.idle()
            end
    ]]--
            -- walking to the right
            if controller:Btn_Right() then
              self.ambulate(controller:MoveVector())
            end
            if key_right_upped then
              if controller:Btn_Down() then self.slide(controller:MoveVector().mX) else self.idle() end
            end
						
						-- walking to the left
            if controller:Btn_Left() then
              self.ambulate(controller:MoveVector())
            end
            if key_left_upped then
              if controller:Btn_Down() then self.slide(controller:MoveVector().mX) else self.idle() end
            end
          end
        end
      end
    end
    
    -- If not in balance and no controller input for a while, just get up and do idle
    if self.balance_state == self.balance.NONE and self.can_regain_balance_now() then
      if no_move_input then
        self.idle()
      end
    end
    
    -- tool switching
  --  if(controller:Btn_Pickup_Press()) then
  --    controller:SetPickup() 
  --  end
  --  if(controller:Btn_Jetpack_Press()) then 
  --    controller:SetJetpack()
  --  end
      
    --[[
    -- TEMP ONLY THE ATOMIZER FOR NOW
    if controller:CurrentToolIs("Rifle") then
      controller:SetPickup() 
    end
    ]]--
    
    -- switch by what is in hands so far
    --local switch_to_tool = "Atomizer"
    --if self:GetMountJointIsMounted("Tool Mount Arm BG") then
  --    switch_to_tool = "Rifle"
  --  end
    
		local carried_assy = self.get_carried_asssembly()
    if carried_assy then
			
			-- Ingot carrying mechanics
			if carried_assy:HasTag("Ingot") then
				
				local carried_mo = carried_assy:GetMasterMO()
				local balance = carried_mo:RotateAngleForGravity(carried_mo:GetOrientation()) - self.body_mo:RotateAngleForGravity(self.body_mo:GetOrientation())
				balance = math.frotate(0, math.twopi, balance + math.pi) -math.pi
				
				--turn upside down block upright
				if self.correct_mount_target then
					-- mount when 45 deg away from target angle
					if math.abs(balance) < math.halfpi/2 then 
						if self:MountMOByJointNames(carried_mo, "Tool Mount Arm BG", Yes) then
							self.lift()
						else
							-- throw away carried assy
							self:UnmountAssembly(carried_assy)
							self:GetController():SetCanAtomize(true)
							self:GetController():SetCanAssemble(true)
							carried_assy:GetMasterMO():SetHollownessBase(self.carried_mo_hollowness)
						end
						self.correct_mount_target = false
						
					elseif (self.jg.legs.state ~= self.jgs.LIFT and self.jg.legs.state ~= self.jgs.CROUCH) or (self.jg.legs.state == self.jgs.LIFT and self.jg.legs.anim_num >= 2) then
						if self:IsMirrored() then
							--rotate to left
							carried_mo:AddAngularAcceleration(-100)
						else
							--rotate to right
							carried_mo:AddAngularAcceleration(100)
						end
					end
					
				--drop assembly if joints get disconected
				elseif not (self:GetAssemblyMountedToJoint("Tool Mount Arm BG") and self:GetAssemblyMountedToJoint("Tool Mount Arm FG")) then
					self:UnmountAssembly(carried_assy)
					self:GetController():SetCanAtomize(true)
					self:GetController():SetCanAssemble(true)
					carried_assy:GetMasterMO():SetHollownessBase(self.carried_mo_hollowness)
					
				-- unmount and correct if balance is messed up
				elseif math.abs(balance) > math.halfpi/2 then 
					local jnt = self:GetJointByName("Tool Mount Arm BG")
					if jnt then 
						self.correct_mount_target = true
						self:UnmountAtJoint(jnt)
					end
				end
				
				
				if controller:Btn_Tool1() then
					--if self.is_carrying_now() then
						self.throw_charge()
					--end
					
				elseif controller:Btn_Tool1_Release() then
					-- throw away carried assy
					self:UnmountAssembly(carried_assy)
					self:GetController():SetCanAtomize(true)
					self:GetController():SetCanAssemble(true)
					self.throw()
					self.ignore_approaching_target_now = No
					
					local throw_vec = (controller:AimPoint() - carried_assy:GetApproxPos()):GetNormalizedTo(2000)
					local ang_acc = -400
					if self:IsMirrored() then ang_acc = -ang_acc end
					carried_assy:MOSet(""):AddAcceleration(throw_vec)
					carried_assy:MOSet(""):AddAngularAcceleration(ang_acc)
					carried_assy:GetMasterMO():SetHollownessBase(self.carried_mo_hollowness)
					self:MOSet("Arm"):AddAcceleration(-throw_vec)
				else
					--set pose
					self.carry()
				end
			end
    -- Atomizing/Assembling
    else
      -- Atomizing
      if controller:Btn_Tool1() then self.atomize()  end
      if controller:Btn_Tool1_Release() then self.idle() end
      -- Assembling
      if controller:Btn_Tool2() then self.assemble() end
      if controller:Btn_Tool2_Release() then self.idle() end
    end
		
		self.control_lights_enabled()
    
    -- Let spot light angle by aiming
    local light = self:GetLightByName("Spot") 
    if light then
      local vec = controller:AimPoint()
      vec = vec - light:GetPosition()
      light:SetSpotLightAngle(vec:GetAngleRad())
    end
    
		
		
    -----------------------------------------------
    -- Mirroring Control; based on aim input relative to current positionn
		
    local aim_vec = self.body_mo:UnRotateVectorForGravity(controller:AimPoint() - self:GetAssemblyApproxPos())
    local target_is_left = aim_vec.mX < 0
    -- Detect flipping event
    -- Don't allow flipping back and forth too quickly
    if ((target_is_left and not self:IsMirrored()) or (not target_is_left and self:IsMirrored())) and self.mirror_change_timer:Elapsed(0.5) then
      -- Mirror ourselves
      self:Mirror(Yes)
      -- Measure how long since this last mirroring change
      self.mirror_change_timer:Reset()
      
      -- If pointing at something, stop doing so on flip, or will just look silly
      if self.jg.arm_fg.anim == self.poseanim.point_at then
        self.set_jg_state(self.jg.arm_fg, self.jgs.IDLE)
      end
      if self.jg.arm_bg.anim == self.poseanim.point_at then
        self.set_jg_state(self.jg.arm_bg, self.jgs.IDLE)
      end
      if self.jg.neck.anim == self.poseanim.point_at then
        self.set_jg_state(self.jg.neck, self.jgs.IDLE)
      end
      
      -- If flying, the balance angle should be adjusted to not get jerked around on a flip
      if self.balance_state == self.balance.FLYING then
        if target_is_left then
          self:MOSet("Head"):SetBalanceToAngle(self.head_mo:GetBalanceToAngle() + (math.pi / 2))
        else
          self:MOSet("Head"):SetBalanceToAngle(self.head_mo:GetBalanceToAngle() - (math.pi / 2))
        end
      end
    end
		
    ----------------------------------------------------
    -- Vehicle entry and escape / Ingot lift
		
    local in_vehicle = self:GetMountedToAssemblyByAT("Vehicle")
    if in_vehicle or (self.get_carried_asssembly() and self.get_carried_asssembly():HasTag("Ingot")) then
      if in_vehicle then
				self.ignore_approaching_target_now = Yes
				self.target_approaching_id = -1
				if controller:Btn_EnterExit_Press() or in_vehicle:IsDead() then
					-- the which parameter will infrom vehicle from which mount joint the pioneer leaves the vehicle (because more pioneers can be mounted to one vehicle)
					local which = ""
					if self:GetMountedToJoint() then which = self:GetMountedToJoint():GetName() end 
					-- ! 'GetMountedToJoint' only finds some joint to which this assembly is mounted. however this assembly can be mounted to more mount joints. i used this only knowing that pioneer can be mounted to only one thing.
					
					local vehicle_obj = GetAssemblyLuaObj(in_vehicle)
					if vehicle_obj then 
						if vehicle_obj.OnVehiclePilotEscape then
							vehicle_obj.OnVehiclePilotEscape(which)
						end
					end
					
					-- escape the vehicle now
					self:UnmountFromAssembly(in_vehicle)
					self.target_escaping_id = in_vehicle:GetID()
					-- jump up
					self.body_mo:PullTest4(self.body_mo:RotateVectorForGravity(VectorF(0,10000)))
				else
					self.target_escaping_id = -1
				end
				
			elseif self.get_carried_asssembly() then
				--self.ignore_approaching_target_now = Yes
				self.target_approaching_id = -1
			end
			
			
    else
      if controller:Btn_EnterExit() and not self.ignore_approaching_target_now then
        -- find nearest vehicle to enter
        local vehicle_to_enter = scene:GetNearestAssemblyWithFreeMountJointByAT(self, "Vehicle", 10)
        if vehicle_to_enter then
					self.approaching_vehicle = true
          self.target_approaching_id = vehicle_to_enter:GetID()
          self.target_escaping_id = -1
        end
      end
      
      if controller:Btn_EnterExit_Release() then
        self.ignore_approaching_target_now = No
        
        if self.target_approaching_id >= 0 then
					self.target_escaping_id = self.target_approaching_id
					self.target_approaching_id = -1
				end
        
      end
			
			if controller:Btn_Pickup() and not self.ignore_approaching_target_now and not self.get_carried_asssembly() then
				-- find nearest object to lift
				local ingot_to_lift = scene:GetNearestAssemblyWithFreeMountJointByAT(self, "Ingot", 4) --assembly has to be not dead
				if ingot_to_lift and ingot_to_lift:GetJointByName("Tool Mount Arm FG") and ingot_to_lift:GetJointByName("Tool Mount Arm BG") then
					self.approaching_vehicle = false
          self.target_approaching_id = ingot_to_lift:GetID()
          self.target_escaping_id = -1
        end
			end
			
			if controller:Btn_Pickup_Release() then
        self.ignore_approaching_target_now = No
        
        if self.target_approaching_id >= 0 then
					self.target_escaping_id = self.target_approaching_id
					self.target_approaching_id = -1
        end
        
      end
    end
    
		--[[
		--debug
		local jnt = self:GetJointByName("Tool Mount Arm FG") or self:GetJointByName("Tool Mount Arm BG")
		pioMountPos = jnt:GetWorldPositionA()
		scene:WriteToScreenByWorldPos("O", pioMountPos, VectorF(), true)
		
		local jnt = self:GetJointByName("Tool Mount Arm BG")
		pioMountPos = jnt:GetWorldPositionA()
		scene:WriteToScreenByWorldPos("O", pioMountPos, VectorF(), true)
		]]
		
    local target_assy = scene:GetAssemblyByID(self.target_approaching_id)
		if not self.approaching_vehicle then
			if not target_assy or not (target_assy:GetJointByName("Tool Mount Arm FG") and target_assy:GetJointByName("Tool Mount Arm BG")) then
				self.target_approaching_id = -1
				target_assy = nil
			end
		end
    if target_assy then
      -- when entering the vehicle we set it to fly-out state with pioneer every frame
      self:AddFlyOutAssembly(target_assy)
      
      -- get mount position information
			local mount_joint, target_mount_pos, mount_vec, pioMountPos
			if self.approaching_vehicle then
				mount_joint = target_assy:GetNearestAndFreeMountJoint(self:GetAssemblyApproxPos())
				target_mount_pos = VectorF(0,0);
				if mount_joint and self.approaching_vehicle then
					target_mount_pos = mount_joint:GetWorldPositionA()
				else
					target_mount_pos = target_assy:GetAssemblyApproxPos()
				end
				
				-- Relative vector between position to the mount point
				mount_vec = target_mount_pos - self.body_mo:GetPosition()
				-- Un-rotate the mount point vector to gravity down so we can do proper logic on it
				mount_vec = self.body_mo:UnRotateVectorForGravity(mount_vec)
				
			else
				local jnt = self:GetJointByName("Tool Mount Arm FG") or self:GetJointByName("Tool Mount Arm BG")
				pioMountPos = jnt:GetWorldPositionA()
				jnt = target_assy:GetJointByName("Tool Mount Arm FG") or target_assy:GetJointByName("Tool Mount Arm BG")
				target_mount_pos = jnt:GetWorldPositionA()
				
				-- Relative vector between position to the mount point
				mount_vec = target_mount_pos - pioMountPos
				-- Un-rotate the mount point vector to gravity down so we can do proper logic on it
				mount_vec = self.body_mo:UnRotateVectorForGravity(mount_vec)
				
				--debug
				--[[
				scene:WriteToScreenByWorldPos("X", target_mount_pos, VectorF(), true)
				scene:WriteToScreenByWorldPos("O", pioMountPos, VectorF(), true)
				]]
			end
      
			
      -- help the pioneer to enter the vehicle
      if self.approaching_vehicle and (math.abs(mount_vec.mX) < 1.0) then
        self.body_mo:PullTest4((self.body_mo:RotateVectorForGravity(mount_vec) + self.body_mo:RotateVectorForGravity(VectorF(0, 0.8))) * 100 - self.body_mo:GetVelocity() * 30)
      end
      
			local run_speed = 1.0
			if not self.approaching_vehicle and (math.abs(mount_vec.mX) < 3) then
				run_speed = 0.5
      end
			
      -- Run to the left if mount point is in that direction
      if mount_vec.mX < 0 then
        if not self.is_flying_now() then
          if not self.is_ambulating_now() then
            self.ambulate(VectorF(-run_speed, 0))
          end
          if self.is_ambulating_now() and not self.is_ambulating_left then
            self.ambulate(VectorF(-run_speed, 0))
          end
          if mount_vec.mX > -0.7 then
            if self.unrotated_vel.mX < -1 or self.unrotated_vel.mX > 1 then
              self.idle()
            end
          end
        end
        -- Jump up to mount point if necessary
        if self.approaching_vehicle then
					if (mount_vec.mX > -0.7) and mount_vec.mY > 0 then 
						-- jump
						if self.unrotated_vel.mX > -0.5 and self.unrotated_vel.mX < 0.5 then
							--if self.hip_joint:GetAngularSpringAngleFadeFinishedNow() then
							if not self.wanna_jump_now and not self.gonna_jump_now then
	--              self:FadeAngularSpringAnglesByPose("Leg", "Jump 1", self.poseanim.jump.intervals[1])
								self.wanna_jump_now = true
								self.gonna_jump_now = false
							end
						end
					end
        end
				
      -- Run to the right if mount point is in that direction
      elseif mount_vec.mX > 0 then
        if not self.is_flying_now() then
          if not self.is_ambulating_now() then
            self.ambulate(VectorF(run_speed, 0))
          end
          if self.is_ambulating_now() and self.is_ambulating_left then
            self.ambulate(VectorF(run_speed, 0))
          end
          if mount_vec.mX < 0.7 then
            if self.unrotated_vel.mX < -1 or self.unrotated_vel.mX > 1 then
              self.idle()
            end
          end 
        end
        -- Jump up to mount point if necessary
        if self.approaching_vehicle then
					if mount_vec.mX < 0.7 and mount_vec.mY > 0 then 
						-- jump
						if self.unrotated_vel.mX > -1 and self.unrotated_vel.mX < 1 then
							--if self.hip_joint:GetAngularSpringAngleFadeFinishedNow() then
							if not self.wanna_jump_now and not self.gonna_jump_now then
	--              self:FadeAngularSpringAnglesByPose("Leg", "Jump 1", self.jg.legs.anim.jump.intervals[self.jg.legs.anim])
								self.wanna_jump_now = true
								self.gonna_jump_now = false
							end
						end
					end
				end
      end
			
      
			if self.approaching_vehicle then
				-- Enter the vehicle now if close enough to the mount point we are going for
				if mount_joint then
					if self.body_mo:GetPosition():GetLengthTo(target_mount_pos)<0.8 then
						self:MountToJoint(mount_joint, self.body_mo, VectorF(0,0), Yes)
						
						-- the which parameter will infrom vehicle from which mount joint the pioneer leaves the vehicle (because more pioneers can be mounted to one vehicle)
						local which = mount_joint:GetName()
						local vehicle_obj = GetAssemblyLuaObj(target_assy)
						if vehicle_obj then 
							if vehicle_obj.OnVehiclePilotEnter then
								vehicle_obj.OnVehiclePilotEnter(which)
							end
						end
					end
				end
				
			--not approaching vehicle
			else
				-- crouch if close to ingot and its mount jnt is low 
				local min_mount_dist = 0.4
				if math.abs(mount_vec.mX) < 0.4 and mount_vec.mY < 0 then
					self.crouch()
				-- increase grab range if mount jnt is high up
				elseif mount_vec.mY > 0.5 then
					min_mount_dist = 0.6
				end
				
				--mirror target joints if necessary
				if target_assy:IsMirrored() ~= self:IsMirrored() then
					target_assy:Mirror(Yes)
					target_assy:GetMasterMO():Mirror()
				end
				
				--lift Ingot if close enough
				--TODO: make sure pio is standing in target too or flip moutn joints for heads down target
				local joint = self:GetAnyJointByName(self.jg.arm_fg.name)
				if pioMountPos:GetLengthTo(target_mount_pos) < min_mount_dist and (self.is_crouching_now() or mount_vec.mY > 0) then
					if not target_assy:GetMountedToAssemblyByAT("Pioneer") then
						-- we need to get the assembly's MO that we will mount to pioneer
						local target_mo = target_assy:GetMasterMO() -- we choose master MO of tool assembly
						if target_mo then
							local balance = target_mo:RotateAngleForGravity(target_mo:GetOrientation())
							local mounted = false
							if math.abs(math.frotate(0, math.twopi, balance + math.pi) -math.pi) > math.halfpi then
								--if target is upside down only mount to one arm and correct angle later
								if self:MountMOByJointNames(target_mo, "Tool Mount Arm FG", Yes) then
									mounted = true
									self.correct_mount_target = true
								end
							else
								--mount both arms
								if self:MountMOByJointNames(target_mo, "Tool Mount Arm BG", Yes) 
								and self:MountMOByJointNames(target_mo, "Tool Mount Arm FG", Yes) then
									mounted = true
								end
							end
							if mounted then
								self:GetController():SetCanAtomize(false)
								self:GetController():SetCanAssemble(false)
								self.look_for_tool_timer:Pause()
								self.lift()
								self.carried_mo_hollowness = target_mo:GetHollownessBase()
								target_mo:SetHollownessBase(0.95)
							end
						end
					end
				end
			end
      
    -- Abort vehicle entry, run to the side to clear it before collisions turn on again
    else
      local escaping_vehicle = scene:GetAssemblyByID(self.target_escaping_id)
			if escaping_vehicle then
				if not self:GetFlyOutAssemblyFlag(escaping_vehicle) then --and self:GetFlyOutAssembly(escaping_vehicle)  
          -- Stop escaping vehicle when not overlapping anymore
          self.cancel_enter = true
          escaping_vehicle = nil
          self.target_escaping_id = -1
        end
      end
      -- If we are going at speed, then just go slack and let things take their course
      if escaping_vehicle and (self:GetApproxVelocity():GetLength() > 5.0 or escaping_vehicle:GetApproxVelocity():GetLength() > 8.0) then
				--self.slack()
      -- Run out from behind the vehicle we are not mounting anymore
      elseif escaping_vehicle then
        local exit_vec = escaping_vehicle:GetAssemblyApproxPos() - self:GetAssemblyApproxPos()
        -- Un-rotate the exit vector for gravity so we can do logic on it
        exit_vec = self.body_mo:UnRotateVectorForGravity(exit_vec)
        self.cancel_enter = true
        if exit_vec.mX > 0 then
          if not self.is_ambulating_now() then
            self.ambulate(VectorF(-1.0, 0))
          end
          if self.is_ambulating_now() and not self.is_ambulating_left then
            self.ambulate(VectorF(-1.0, 0))
          end
        end
        if exit_vec.mX < 0 then
          if not self.is_ambulating_now() then
            self.ambulate(VectorF(1.0, 0))
          end
          if self.is_ambulating_now() and self.is_ambulating_left then
            self.ambulate(VectorF(1.0, 0))
          end
        end
      else
        if self.cancel_enter then
          self.cancel_enter = false
          self.idle()
        end
      end
    end
  end


  --------------------------------------------------------
  -- Environment Sensing Functions
  --------------------------------------------------------

  function self.get_altitude(maxCheckDistance)
    local radar_signal = self:RayCastVector(self:GetApproxPos(), self.body_mo:RotateVectorForGravity(VectorF(0, -maxCheckDistance)), true, true, nil, self)
    -- Hit something, so return the distance to it
    if radar_signal then
      return (radar_signal:GetPoint() - self:GetApproxPos()):GetLength()
    end
    -- Did not find anyhting, so altitude is reported as what the max distance is
    return maxCheckDistance
  end
  
  function self.raycast_leg_left(leg1)
    self.body_mo = self:GetMOByName("Torso")
    if not self.body_mo then return end
    
    local leg_name = ""
    if leg1 then leg_name = "Leg FG Shin" else leg_name = "Leg BG Shin" end
    local leg = self:GetMOByName(leg_name)
    if leg then
      local ignore = self.get_carried_asssembly() or scene:GetAssemblyByID(self.target_approaching_id) or scene:GetAssemblyByID(self.target_escaping_id)
      if ignore then ignore = ignore:GetMasterMO() end --TODO: needs to ignore ingore:GetAssemblyLinked()
      return self:RayCastVector(leg:GetPosition(), self.body_mo:RotateVectorForGravity(self.raycast_legvec_left), true, true, ignore, self)
    end
    return false 
  end

  function self.raycast_leg_right(leg1)
    self.body_mo = self:GetMOByName("Torso")
    if not self.body_mo then return end
    
    local leg_name = "" 
    if leg1 then leg_name = "Leg FG Shin" else leg_name = "Leg BG Shin" end 
    local leg = self:GetMOByName(leg_name)
    if leg then 
      local ignore = self.get_carried_asssembly() or scene:GetAssemblyByID(self.target_approaching_id) or scene:GetAssemblyByID(self.target_escaping_id)
      if ignore then ignore = ignore:GetMasterMO() end --TODO: needs to ignore ingore:GetAssemblyLinked()
      return self:RayCastVector(leg:GetPosition(), self.body_mo:RotateVectorForGravity(self.raycast_legvec_right), true, true, ignore, self)
    end
    return false
  end

  ----------------------------------------------------------
  -- Pioneer State Checking Functions
  ----------------------------------------------------------

  function self.check_fatal_damage()
    -- detect if pioneer head is even there, if not then set the pioneer dead
    if not self.head_mo then
      self.kill()
    -- detect if the head has been damaged, then he's also dead
    elseif self.head_mo:GetAreaLossPerc() > 0.05 then
      self.kill()
    end
    
    -- detect if pioneer body is even there, if not then set the pioneer dead
    if not self.body_mo then
      self.kill() 
    -- detect if half or more of the body is gone, then he's pretty dead
    elseif self.body_mo:GetAreaLossPerc() > 0.5 then
      self.kill()
    end
  end

  function self.check_knockout_trauma()
    
--[[
    -- detect if pioneer head is even there, if not then set the pioneer dead
    if not self.head_mo then
      self.kill()
    -- detect if the head has been damaged, then he's also dead
    elseif self.head_mo:GetAreaLossPerc() > 0.05 then
      self.kill()
    end
    
    -- detect if pioneer body is even there, if not then set the pioneer dead
    if not self.body_mo then
      self.kill() 
    -- detect if half or more of the body is gone, then he's pretty dead
    elseif self.body_mo:GetAreaLossPerc() > 0.5 then
      self.kill()
    end
]]--
    
  end
  
  function self.is_jg_ambulating_now(jointGroup)
    return jointGroup.state ~= self.jgs.IDLE and
           (jointGroup.state == self.jgs.WALK or
            jointGroup.state == self.jgs.RUN or
            jointGroup.state == self.jgs.CLIMB or
            jointGroup.state == self.jgs.CRAWL)
  end

  function self.is_ambulating_now()
    return self.is_jg_ambulating_now(self.jg.legs)
  end

  function self.is_jumping_now()
    return self.jg.legs.state == self.jgs.PREJUMP or self.jg.legs.state == self.jgs.JUMP or self.jg.legs.state == self.jgs.POSTJUMP
  end

  function self.is_riding_now()
    return self.jg.legs.state == self.jgs.RIDE
  end
  
  function self.can_regain_balance_now()
    if not self.body_mo then return false end
    if self:GetMountedToAssemblyByAT("Vehicle") then return false end
    
    -- TODO: make this check ground speed instead of absolute speed
    if self.body_mo:GetVelocity():GetLength() < 5.0 and math.abs(self.body_mo:GetAngularVelocity()) < 4.5 and self.get_altitude(3) < 2 then
      if self.regain_balance_timer:TimeIsUp() then
        return true
      end
    else
      -- Restart timer since we don't have good conditions for getting up
      self.regain_balance_timer:Reset()
    end
    return false
  end

  function self.is_balancing_now()
    return self.balance_state == self.balance.BIPED
  end

  function self.is_sliding_now()
    return self.jg.legs.state == self.jgs.SLIDE or self.balance_state == self.balance.GO_PRONE
  end

  function self.is_crawling_now()
    return self.jg.legs.state == self.jgs.CRAWL or self.balance_state == self.balance.GO_PRONE
  end

  function self.is_prone_now()
    return self.is_sliding_now() or self.is_crawling_now()
  end

  function self.is_flying_now()
    return self.jg.legs.state == self.jgs.FLY
  end

  function self.is_planted_now()
    return not (self.balance_state == self.balance.NONE and self.get_altitude(3.0) > 1.0)
  end

  function self.is_ascending_now()
		if not self.body_mo then return false end
    return self.body_mo:UnRotateVectorForGravity(self.body_mo:GetVelocity()).mY > 0
  end

  function self.is_descending_now()
		if not self.body_mo then return false end
    return self.body_mo:UnRotateVectorForGravity(self.body_mo:GetVelocity()).mY < 0
  end

	function self.is_crouching_now()
    return self.jg.legs.state == self.jgs.CROUCH
  end
	
	function self.is_carrying_now()
    return self.jg.arm_fg.state == self.jgs.LIFT and self.jg.arm_fg.anim_num == 3
  end

  -- Whether we need to be climbing over stuff in the direction and speed we are ambulatin'
  function self.needs_to_climb()
    if not self.is_ambulating_now then return false end

    if self.is_ambulating_left then
      return self.raycast_leg_left(self.jg.legs.anim_num == 3)
    else
      return self.raycast_leg_right(self.jg.legs.anim_num == 3)
    end
    
    return false
  end
	
	function self.get_carried_asssembly()
		return self:GetAssemblyMountedToJoint("Tool Mount Arm BG") or self:GetAssemblyMountedToJoint("Tool Mount Arm FG")
	end

  ----------------------------------------------
  -- Limb collision detection

  function self.legs_colliding_with_something()
    function leg_col(leg_mo)
      if leg_mo == nil or not leg_mo:IsSomeHowJointedToMO(self.body_mo, false, false) then return false
      else return leg_mo:GetCollidedWithMOorTO() end
    end

    return leg_col(self:GetMOByName("Leg FG Thigh"))
    or leg_col(self:GetMOByName("Leg FG Shin"))
    or leg_col(self:GetMOByName("Leg BG Thigh"))
    or leg_col(self:GetMOByName("Leg BG Shin")) 
  end

  function self.arms_colliding_with_something()    
    function arm_col(arm_mo)
      if arm_mo == nil or not arm_mo:IsSomeHowJointedToMO(self.body_mo, false, false) then return false
      else return arm_mo:GetCollidedWithMOorTO()
      end
    end

    return arm_col(self:GetMOByName("Arm FG Upper"))
    or arm_col(self:GetMOByName("Arm FG Lower"))
    or arm_col(self:GetMOByName("Arm BG Upper"))
    or arm_col(self:GetMOByName("Arm BG Lower")) 
  end

  -- Is Pio standing/balancing with one foot on each side of his CoM?
  -- Returns movement input in x in the needed corrective direction, if any. If not, returns 0
  function self.get_biped_balance_input()
    if self.balance_state ~= self.balance.BIPED then return 0 end
    
    local foot_fg_joint = self:GetJointByName("Leg FG Foot")
    local foot_bg_joint = self:GetJointByName("Leg BG Foot")
    -- No feet left! no balancing to do then
    if not foot_fg_joint and not foot_bg_joint then return 0 end
    
    -- Return the unrotated vector offset to the foot vector from the center of the body
    function get_foot_offset(foot_joint)
      if not foot_joint or not foot_joint:GetMOA() or not foot_joint:GetMOA():IsSomeHowJointedToMO(self.body_mo, false, false) then return VectorF(0, 0) end
      return self.body_mo:UnRotateVectorForGravity(foot_joint:GetWorldPositionA() - self.body_mo:GetPosition())
    end
    
    -- Make him hop to keep balance if only one foot left
    if foot_fg_joint and not foot_bg_joint then
      local foot_offset = get_foot_offset(foot_fg_joint)
      if not self:IsMirrored() then
        if foot_offset.mX < -0.33 then return 0.5 end
        if foot_offset.mX > 0.33 then return -0.5 end
      else
        if foot_offset.mX < -0.33 then return 0.5 end
        if foot_offset.mX > 0.33 then return -0.5 end
      end
    end
    -- Other foot, if only one leg
    if not foot_fg_joint and foot_bg_joint then
      local foot_offset = get_foot_offset(foot_bg_joint)
      if not self:IsMirrored() then
        if foot_offset.mX < -0.33 then return 0.5 end
        if foot_offset.mX > 0.33 then return -0.5 end
      else
        if foot_offset.mX < -0.33 then return 0.5 end
        if foot_offset.mX > 0.33 then return -0.5 end
      end
    end
    
    -- We have both legs, so see if CoM is between the two
    local foot_offset_fg = get_foot_offset(foot_fg_joint)
    local foot_offset_bg = get_foot_offset(foot_bg_joint)
    -- Return corrective input if both legs are found on each side of the body
    if foot_offset_fg.mX < 0 and foot_offset_bg.mX < 0 then return 0.5 end
    if foot_offset_fg.mX > 0 and foot_offset_bg.mX > 0 then return -0.5 end
    
    -- Appears we have one foot on each side of our body, whcih is in balance
    return 0
  end


  -----------------------------------------------------------------------------------
  -- Pioneer State Changing Functions
  -----------------------------------------------------------------------------------

  -- Third param is whether to not reset the animation if this state is different
  function self.set_jg_state(joint_group, new_jg_state, do_not_reset_anim)
    -- Mark if this state is changed for this frame, also reset the animation number if requested
    if joint_group.state ~= new_jg_state then
      joint_group.state_changed = true
	
      if not do_not_reset_anim then
        joint_group.anim_num = 1
				joint_group.hold_timer:Reset()
				joint_group.hold_timer:SetTimeLimit(joint_group.anim.intervals[joint_group.anim_num])
      end
    end
    -- Set the current state
    joint_group.state = new_jg_state
  end

  function self.kill()
    -- If we're already busy dying, then don't die more
    if self.is_dying() then
      return
    end
    
    -- Turn off balance
    self.balance_state = self.balance.NONE
    
    -- Start counting down til we actually are fully dead
    self.dying_timer:Reset()

    -- Everything goes into death flail
    self.set_jg_state(self.jg.legs, self.jgs.DIE)
    self.set_jg_state(self.jg.arm_fg, self.jgs.DIE)
    self.set_jg_state(self.jg.arm_bg, self.jgs.DIE)
    self.set_jg_state(self.jg.neck, self.jgs.DIE)
  end
  
  function self.is_dying()
    return self.jg.legs.state == self.jgs.DIE
  end

  function self.set_fully_dead()
    -- Everything goes slack
    self.slack()

    -- Communicate to the engine that this thing is dead
    self:SetDead()
  end

  -----------------------------------------------------------------------
  -- Pose Animation helpers

  -- Check and advance the pose animation to the next step, if necessary
  -- If reverse is true, the next pose selected to animate to will be the previous in order (ie playing the animation backwards)
  -- Returns whether this is non-looping and has reached the end of poses to fade to
  function self.pose_anim_advance(joint_group, reverse)
    -- Don't do anything if this joint group just changed states
    if joint_group.state_changed then
			
			-- Do reset the hold timer if this is a non-fading pose
			if not joint_group.anim.fade then
				joint_group.hold_timer:Reset()
				joint_group.hold_timer:SetTimeLimit(joint_group.anim.intervals[joint_group.anim_num])
			end
			
      return false
    end
    
    -- Get any joint of this group
    local joint = self:GetAnyJointByName(joint_group.name)
    if not joint or joint_group.anim == self.poseanim.none then return false end
    
		-- If this is a non-fading state, then use the hold timer to see if we have held teh current pose it long enough
		-- OR
		-- If a looping and/or multi-pose animation, see if we have finished fading the springs to the current pose target
		if (not joint_group.anim.fade and joint_group.hold_timer:TimeIsUp())
			 or
			 (joint_group.anim.fade and joint:GetAngularSpringAngleFadeFinishedNow()) then
      -- We advance the next pose to which we should fade, depending on direction of play   
			if not reverse then
				joint_group.anim_num = joint_group.anim_num + 1
			else
				joint_group.anim_num = joint_group.anim_num - 1
			end

      -- Bounds check and loop in both directions, if looping enabled
      if joint_group.anim_num > table.getn(joint_group.anim.intervals) then
        if joint_group.anim.loop then
          -- Loop around
          joint_group.anim_num = 1
        else
          joint_group.anim_num = table.getn(joint_group.anim.intervals)
          -- Report that we have finished with the last pose of a non-looping animation now
          return true
        end
      end
      if joint_group.anim_num < 1 then
        if joint_group.anim.loop then
          -- Loop around
          joint_group.anim_num = table.getn(joint_group.anim.intervals)
        else
          joint_group.anim_num = 1
          -- Report that we have finished with the last pose of a non-looping animation now
          return true
        end
      end
			
			-- Reset the hold timer and set its new interval time if this is a non-fading pose
			if not joint_group.anim.fade then
				joint_group.hold_timer:Reset()
				joint_group.hold_timer:SetTimeLimit(joint_group.anim.intervals[joint_group.anim_num])
			end
    end
    -- We have not finished any non-looping animations
    return false
  end

  -- If not fading to a pose already, set all joints of a joint group to fade to its currently set anim_num in the pose animation series
  function self.fade_to_current_pose(joint_group)
    -- Get any joint of this group
    local joint = self:GetAnyJointByName(joint_group.name)
    if not joint or joint_group.anim == self.poseanim.none then
      return false
    end

		-- If non-fading state, don't fade the angle spring targets, just set them immediately at the target and hold there as long as interval is
		if not joint_group.anim.fade then
			self:SetAngularSpringAnglesByPose(joint_group.name, joint_group.anim.name .. " " .. joint_group.anim_num)
		-- Fading animation state, so fade between the poses
		elseif not joint:GetAngularSpringAngleFadingNow() then
      -- Put together the pose animation name, and the current pose animation number in the sequence
      self:FadeAngularSpringAnglesByPose(joint_group.name, joint_group.anim.name .. " " .. joint_group.anim_num, joint_group.anim.intervals[joint_group.anim_num] * (1 / joint_group.anim_speed))
    end
  end

  -- Aim a limb straight at a world coordinate target
  function self.aim_joint_at_target(joint, target_pos, trim_angle)
    if joint then
      local target_vec = target_pos - joint:GetWorldPositionA()
      if self:IsMirrored() then trim_angle = -trim_angle end
      joint:FadeAngularSpring(target_vec:GetAngleRad() - self.body_mo:GetOrientation() + math.halfpi + trim_angle, 0)
    end
  end

  -- Set joint stiffness on all limb joints
  function self.set_limb_joint_springs(power, friction)
    self:SetAngularSpringPowers("Leg", power)
    self:SetAngularSpringPowers("Arm", power)
    self:SetAngularSpringPowers("Neck", power)
    self:SetAngularFrictions("Leg", friction)
    self:SetAngularFrictions("Arm", friction)
    self:SetAngularFrictions("Neck", friction)
  end

  ------------------------------------------------
  -- IDLE

  function self.idle()
    self.body_mo = self:GetMOByName("Torso")
  --  self.jg.legs.anim_num = 1
    self.ambulation_input = VectorF(0, 0)
    
    -- Start falling flailing if we are too high up
    if self.get_altitude(5) > 4 then
      self.fall()
      return
    end

    -- Get up on our feet if we are not yet
    if self.balance_state ~= self.balance.BIPED then
      self.gain_balance()
      return
    end
--[[ TODO: Make this work
    -- If our legs are not on each side of our CoM, we need to take some corrective steps to get our feet under our Pio
    local balance_input = self.get_biped_balance_input()
    if math.abs(balance_input) > 0 then
      self.ambulate(VectorF(balance_input, 0))
      return
    end
]]--
    -- Turn off jetpack
    local jet = self:GetPSByName("Jetpack")
    if jet then jet:SwitchOFFParticleEmitting()  end
    
    -- Set up te joint springs
    self.set_limb_joint_springs(self.angular_spring_power_stiff * 0.8, self.angular_spring_friction)
    
    -- Set the joint groups to idle if and only if they were ambulating before
    self.set_jg_state(self.jg.legs, self.jgs.IDLE)
    
--    if self.is_jg_ambulating_now(self.jg.arm_fg) then
      self.set_jg_state(self.jg.arm_fg, self.jgs.IDLE)
--    end
--    if self.is_jg_ambulating_now(self.jg.arm_bg) then 
      self.set_jg_state(self.jg.arm_bg, self.jgs.IDLE)
--    end
--    if self.is_jg_ambulating_now(self.jg.neck) then 
      self.set_jg_state(self.jg.neck, self.jgs.IDLE)
--    end

    if not self.body_mo then return end
		
    -- If we are going fast enough, do the skidding animation
  -- TODO: make this look at ground speed instead of absolute speed, so it'll behave right when on a moving MO platform
    if math.abs(self.body_mo:UnRotateVectorForGravity(self.body_mo:GetVelocity()).mX) > 6 then
      self.skid()
    end
  end


  ------------------------------------------------
  -- SLACK

  function self.slack()
    self.body_mo = self:GetMOByName("Torso")
  --  self.jg.legs.anim_num = 1
    self.balance_state = self.balance.NONE
    self.ambulation_input = VectorF(0, 0)
    
    -- See if the conditions for regaining balance are there
    if self.can_regain_balance_now() then
      self.gain_balance()
      return
    end
    
    -- Turn off jetpack
    local jet = self:GetPSByName("Jetpack")
    if jet then  jet:SwitchOFFParticleEmitting()  end
    
    -- Set up te joint springs
    self.set_limb_joint_springs(100, 10)
    self:SetAngularFrictions("Neck", self.angular_spring_friction)
    
    -- Set the joint groups to idle if and only if they were ambulating before
    self.set_jg_state(self.jg.legs, self.jgs.SLACK)
    
--    if self.is_jg_ambulating_now(self.jg.arm_fg) then
      self.set_jg_state(self.jg.arm_fg, self.jgs.SLACK)
--    end
--    if self.is_jg_ambulating_now(self.jg.arm_bg) then 
      self.set_jg_state(self.jg.arm_bg, self.jgs.SLACK)
--    end
--    if self.is_jg_ambulating_now(self.jg.neck) then 
      self.set_jg_state(self.jg.neck, self.jgs.SLACK)
--    end
  end


  ------------------------------------------------
  -- RIDE

  function self.ride()
    self.body_mo = self:GetMOByName("Torso")
  --  self.jg.legs.anim_num = 1
    self.balance_state = self.balance.NONE
    self.ambulation_input = VectorF(0, 0)
    
    -- Turn off jetpack
    local jet = self:GetPSByName("Jetpack")
    if jet then  jet:SwitchOFFParticleEmitting()  end
    
    -- Set up te joint springs
    self.set_limb_joint_springs(100, 10)
    self:SetAngularSpringPowers("Neck", self.angular_spring_power_loose)
    self:SetAngularSpringPowers("Arm", self.angular_spring_power_stiff)
    self:SetAngularSpringPowers("Leg", self.angular_spring_power_stiff)
    self:SetAngularFrictions("Neck", self.angular_spring_friction)
        
    -- Set the joint groups to idle if and only if they were ambulating before
    self.set_jg_state(self.jg.legs, self.jgs.RIDE)
    
--    if self.is_jg_ambulating_now(self.jg.arm_fg) then
      self.set_jg_state(self.jg.arm_fg, self.jgs.RIDE)
--    end
--    if self.is_jg_ambulating_now(self.jg.arm_bg) then 
      self.set_jg_state(self.jg.arm_bg, self.jgs.RIDE)
--    end
--    if self.is_jg_ambulating_now(self.jg.neck) then 
      self.set_jg_state(self.jg.neck, self.jgs.RIDE)
--    end
  end


  ------------------------------------------------
  -- GAIN BALANCE

  function self.gain_balance()
    self.body_mo = self:GetMOByName("Torso")
    
    -- If already in balance, then just idle
    if self.balance_state == self.balance.BIPED then
      self.idle()
      return
    end
    
    -- See if the conditions for regaining balance are there
    if not self.can_regain_balance_now() then
      -- If not, then just relax on ground, to come to a halt so we can get up on our feet
      self.slack()
      return
    end
    
    -- Start balancing
    self.balance_state = self.balance.GET_UP
    self.ambulation_input = VectorF(0, 0)
    
    -- Set up te joint springs
    self.set_limb_joint_springs(self.angular_spring_power_stiff, self.angular_spring_friction)
    
    -- Get the angle of the body
    -- This gets a value between 0 and 2PI, so [0 - PI) is rotated to the left of standing, and [PI - 2PI) is right of standing
    local bodyAngle = self.body_mo:RotateAngleForGravity(self.body_mo:GetOrientation())
    
    -- Determine which animation we should use to push ourselves up, depending on facing ground or not
    local direction = self.jgs.GET_UP_BACK
    if (self:IsMirrored() and bodyAngle < math.pi) or (not self:IsMirrored() and bodyAngle > math.pi) then
      direction = self.jgs.GET_UP_FRONT
    end
    
    -- Set the joint groups to idle if and only if they were ambulating before
    self.set_jg_state(self.jg.legs, direction)
    
--    if self.is_jg_ambulating_now(self.jg.arm_fg) then
      self.set_jg_state(self.jg.arm_fg, direction)
--    end
--    if self.is_jg_ambulating_now(self.jg.arm_bg) then 
      self.set_jg_state(self.jg.arm_bg, direction)
--    end
--    if self.is_jg_ambulating_now(self.jg.neck) then 
      self.set_jg_state(self.jg.neck, direction)
--    end
  end


  ------------------------------------------------
  -- GO PRONE

  function self.go_prone()
    self.body_mo = self:GetMOByName("Torso")
    self.balance_state = self.balance.NONE
    self.ambulation_input = VectorF(0, 0)
    
    if self.jg.legs.state == self.jgs.SLIDE then
      return
    end
    
    -- Set up te joint springs
    self.set_limb_joint_springs(self.angular_spring_power_stiff, self.angular_spring_friction)
    
    -- Set the joint groups to idle if and only if they were ambulating before
    self.set_jg_state(self.jg.legs, self.jgs.GO_PRONE)
    
--    if self.is_jg_ambulating_now(self.jg.arm_fg) then
      self.set_jg_state(self.jg.arm_fg, self.jgs.GO_PRONE)
--    end
--    if self.is_jg_ambulating_now(self.jg.arm_bg) then 
      self.set_jg_state(self.jg.arm_bg, self.jgs.GO_PRONE)
--    end
--    if self.is_jg_ambulating_now(self.jg.neck) then 
      self.set_jg_state(self.jg.neck, self.jgs.GO_PRONE)
--    end
  end


  --------------------------------------------------------
  -- AMBULATE (walk, run, climb, crawl)

  -- Input is signed float scalar, -1.0 (max run to the left) to 1.0 (max run to the right)
  function self.ambulate(input)
    -- If already moving do not reset animations
    local do_not_reset_animations = self.is_ambulating_now()

    -- Start falling flailing if we are too high up
    if self.get_altitude(5) > 4 then
      self.fall()
      return
    end

    -- If flying or falling, don't ambulate
    if self.is_flying_now() or not self.is_planted_now() then
      return
    end

    -- Update the non-joint group states 
    self.ambulation_input = input
    self.is_ambulating_left = self.ambulation_input.mX < 0
    
    -- IDLE
    -- If we are not really getting any input, then don't ambulate, just go back to idle
    if math.abs(self.ambulation_input.mX) < 0.2 then
      -- Player is pressing down, stay prone
      if self.ambulation_input.mY < -0.5 then
        self.go_prone()
        return
      -- Just stand up
      else
        self.idle()
        return
      end
    end
    
    -- Set up te joint springs
    self.set_limb_joint_springs(self.angular_spring_power_stiff, self.angular_spring_friction)

    -- CRAWLING
    if self.ambulation_input.mY < -0.5 then
      -- No balance state
      self.balance_state = self.balance.PRONE
      
      -- Set the legs' state
      self.set_jg_state(self.jg.legs, self.jgs.CRAWL, do_not_reset_animations)
      -- Set the arms' and neck state, if they're not doing anything else
      -- FG
 --     if self.jg.arm_fg.state == self.jgs.IDLE or self.is_jg_ambulating_now(self.jg.arm_fg) then
        self.set_jg_state(self.jg.arm_fg, self.jgs.CRAWL, do_not_reset_animations)
 --     end
      -- BG
 --     if self.jg.arm_bg.state == self.jgs.IDLE or self.is_jg_ambulating_now(self.jg.arm_bg) then
        self.set_jg_state(self.jg.arm_bg, self.jgs.CRAWL, do_not_reset_animations)
 --     end
      -- Neck
 --     if self.jg.neck.state == self.jgs.IDLE or self.is_jg_ambulating_now(self.jg.neck) then
        self.set_jg_state(self.jg.neck, self.jgs.CRAWL, do_not_reset_animations)
 --     end
  
    -- CLIMBING
    -- Detect if we should be climbing, or if we've started climbing and we should keep doing it for a bit o avoid spazzing between running and climbing
    elseif self.needs_to_climb() or not self.climbing_timer:TimeIsUp() then
      -- No balance state
      self.balance_state = self.balance.PRONE
      
      -- Start timing how long we've been climbing
      if self.jg.legs.state ~= self.jgs.CLIMB then
        self.climbing_timer:Reset()
      end
      
      -- Set the legs' state
      self.set_jg_state(self.jg.legs, self.jgs.CLIMB, do_not_reset_animations)
      -- Set the arms' and neck state, if they're not doing anything else
      -- FG
      if self.jg.arm_fg.state == self.jgs.IDLE or self.is_jg_ambulating_now(self.jg.arm_fg) then
        self.set_jg_state(self.jg.arm_fg, self.jgs.CLIMB, do_not_reset_animations)
      end
      -- BG
      if self.jg.arm_bg.state == self.jgs.IDLE or self.is_jg_ambulating_now(self.jg.arm_bg) then
        self.set_jg_state(self.jg.arm_bg, self.jgs.CLIMB, do_not_reset_animations)
      end
      -- Neck
      if self.jg.neck.state == self.jgs.IDLE or self.is_jg_ambulating_now(self.jg.neck) then
        self.set_jg_state(self.jg.neck, self.jgs.CLIMB, do_not_reset_animations)
      end
      
    -- Not climbing; on flat enough surface
    else
    
      -- Biped balance state
      self.balance_state = self.balance.BIPED
      
      -- RUNNING
      -- Determine whether we should be walking or running with this input
      -- Also don't allow running if both legs are not present
      if math.abs(self.ambulation_input.mX) > 0.75 and self:GetMOByName("Leg FG Shin") and self:GetMOByName("Leg BG Shin") then
        -- Set the legs' state
        self.set_jg_state(self.jg.legs, self.jgs.RUN, do_not_reset_animations)
        -- Set the arms' and neck state, if they're not doing anything else
        -- FG
        if self.jg.arm_fg.state == self.jgs.IDLE or self.is_jg_ambulating_now(self.jg.arm_fg) then
          self.set_jg_state(self.jg.arm_fg, self.jgs.RUN, do_not_reset_animations)
        end
        -- BG
        if self.jg.arm_bg.state == self.jgs.IDLE or self.is_jg_ambulating_now(self.jg.arm_bg) then
          self.set_jg_state(self.jg.arm_bg, self.jgs.RUN, do_not_reset_animations)
        end
        -- Neck
        if self.jg.neck.state == self.jgs.IDLE or self.is_jg_ambulating_now(self.jg.neck) then
          self.set_jg_state(self.jg.neck, self.jgs.RUN, do_not_reset_animations)
        end
      
      -- WALKING
      else
        -- Set the legs' state
        self.set_jg_state(self.jg.legs, self.jgs.WALK, do_not_reset_animations)
        -- Set the arms' and neck state, if they're not doing anything else
        -- FG
        if self.jg.arm_fg.state == self.jgs.IDLE or self.is_jg_ambulating_now(self.jg.arm_fg) then
          self.set_jg_state(self.jg.arm_fg, self.jgs.WALK, do_not_reset_animations)
        end
        -- BG
        if self.jg.arm_bg.state == self.jgs.IDLE or self.is_jg_ambulating_now(self.jg.arm_bg) then
          self.set_jg_state(self.jg.arm_bg, self.jgs.WALK, do_not_reset_animations)
        end    
        -- Neck
        if self.jg.neck.state == self.jgs.IDLE or self.is_jg_ambulating_now(self.jg.neck) then
          self.set_jg_state(self.jg.neck, self.jgs.WALK, do_not_reset_animations)
        end   
      end
    end
  end
  
  
  ------------------------------------------------
  -- JUMP

  function self.jump()
    self.body_mo = self:GetMOByName("Torso")
    -- switch off jet particles
    local jet = self:GetPSByName("Jetpack")
    if jet then jet:SwitchOFFParticleEmitting() end
    
    -- Only proceed with jump if we're close to the ground
    if self.get_altitude(4) > 2 then
      self.idle()
      return
    end
    
    -- Set up te joint springs
    self.set_limb_joint_springs(self.angular_spring_power_stiff, self.angular_spring_friction)
    
    -- Set balance state to bipedal - TODO: Or special jumping one?
    self.balance_state = self.balance.JUMPING

    -- Set the joint groups to idle if and only if they were ambulating before
    self.set_jg_state(self.jg.legs, self.jgs.PREJUMP)
    
--    if self.is_jg_ambulating_now(self.jg.arm_fg) then
      self.set_jg_state(self.jg.arm_fg, self.jgs.PREJUMP)
--    end
--    if self.is_jg_ambulating_now(self.jg.arm_bg) then 
      self.set_jg_state(self.jg.arm_bg, self.jgs.PREJUMP)
--    end
--    if self.is_jg_ambulating_now(self.jg.neck) then 
      self.set_jg_state(self.jg.neck, self.jgs.PREJUMP)
--    end
  end
  
  
  
  ------------------------------------------------
  -- FALL

  function self.fall()
    self.body_mo = self:GetMOByName("Torso")
    self.ambulation_input = VectorF(0, 0)
    self.jetpack_input = 0
    -- switch off jet particles
    local jet = self:GetPSByName("Jetpack")
    if jet then jet:SwitchOFFParticleEmitting() end
    
    -- If we are not very high over ground, stop flailing and just go slack for impact
    if self.get_altitude(4) < 3 then
      self.slack()
      return
    end
    
    -- Set up te joint springs
    self.set_limb_joint_springs(self.angular_spring_power_loose, 10)
    
    -- Set balance state to none
    self.balance_state = self.balance.NONE

    -- Set the joint groups to idle if and only if they were ambulating before
    self.set_jg_state(self.jg.legs, self.jgs.FALL)
    
--    if self.is_jg_ambulating_now(self.jg.arm_fg) then
      self.set_jg_state(self.jg.arm_fg, self.jgs.FALL)
--    end
--    if self.is_jg_ambulating_now(self.jg.arm_bg) then 
      self.set_jg_state(self.jg.arm_bg, self.jgs.FALL)
--    end
--    if self.is_jg_ambulating_now(self.jg.neck) then 
      self.set_jg_state(self.jg.neck, self.jgs.FALL)
--    end
  end
  
  
  ------------------------------------------------
  -- FLY

  function self.fly()
    self.body_mo = self:GetMOByName("Torso")
    self.ambulation_input = VectorF(0, 0)
    self.jetpack_input = input
    
    -- Make sure we have a jetpack and Aurium charge to fly with, or go back to idle
    local jet = self:GetPSByName("Jetpack")
--[[ Lame; do proper jump animation instead
		-- If have no gas, still give a puff to give a usable jump, and to show we are out of gas
		if jet and self.aurium_charge == 0 and self.total_flight_timer:GetTime() > 0.5 then
      self.total_flight_timer:Reset()
			jet:EmitBoom()
		end
]]--
		-- If jet is out of commission or fuel, do a regular jump instead
    if not jet or self.aurium_charge <= 0 then
			if not self.is_jumping_now() then
				self.jump()
			end
--      self.idle()
			-- Still mark since last Aurium use - it was attempted
			self.aurium_charge_change_timer:Reset()
      return
    end
    
    -- Set balance state to flyin' 
    self.balance_state = self.balance.FLYING
    
    -- Start flight if we have enough Aurium charge to do so
    if not self.is_flying_now() and self.aurium_charge > 50 then
      -- Boom first when not on - and only if aurium charge is at max
--			if self.aurium_charge >= self.aurium_capacity then - nope, makes it feel like thrust is unpredicable
			-- Have a simple delay between booms so can't just peppra knappen
			if self.total_flight_timer:GetTime() > 0.5 then
				jet:EmitBoom()
			end
      -- Start timing how long we've been flying
      self.total_flight_timer:Reset()

--[[
      -- Set the initial balancing angle to be horizontal if we are in a prone position
      if self.is_prone_now() then
        if self:IsMirrored() then
          self:JointSet("Jet Nozzle"):SetAngularSpringAngle(self.body_mo:RotateAngleForGravity(-math.pi / 2))
        else
          self:JointSet("Jet Nozzle"):SetAngularSpringAngle(self.body_mo:RotateAngleForGravity(math.pi / 2))
        end
      end
]]--
      -- Set the initial balancing angle to be whatever the head is at currently
      self:MOSet("Torso"):SetBalanceToAngle(-self.body_mo:GetOrientation())
--      self:MOSet("Head"):SetBalanceToAngle(-self.head_mo:GetOrientation())
    end

    -- Switch on jet particles, only after a short period so initial boom doesn't interfere with it
    if self.total_flight_timer:Elapsed(0.05) then
      jet:SwitchONParticleEmitting()
    end

    -- Set up te joint springs
    self.set_limb_joint_springs(self.angular_spring_power_loose, self.angular_spring_friction)
    -- Neck stiff since steering/stabilizing with blaancer on head
    self:SetAngularSpringPowers("Neck", self.angular_spring_power_stiff)
    self:SetAngularFrictions("", self.angular_spring_friction)
    
    -- Set the joint groups to fly
    self.set_jg_state(self.jg.legs, self.jgs.FLY)
    
--    if self.is_jg_ambulating_now(self.jg.arm_fg) then
      self.set_jg_state(self.jg.arm_fg, self.jgs.FLY)
--    end
--    if self.is_jg_ambulating_now(self.jg.arm_bg) then 
      self.set_jg_state(self.jg.arm_bg, self.jgs.FLY)
--    end
--    if self.is_jg_ambulating_now(self.jg.neck) then 
      self.set_jg_state(self.jg.neck, self.jgs.FLY)
--    end
  end

  --------------------------------------------------------
  -- SLIDE (slide on a cushion of aurium force field)

  -- Input is signed float scalar, -1.0 (max run to the left) to 1.0 (max run to the right)
  function self.slide(input)
    -- Update the non-joint group states
    self.sliding_input = input
    self.balance_state = self.balance.NONE
    
    -- Start falling flailing if we are too high up
    if self.get_altitude(5) > 4 then
      self.fall()
      return
    end
    
--[[ Get back on feet when down is released instead
    -- If we are not really getting any input, then don't slide, just get back on our feet
    if math.abs(input) < 0.1 then
      self.gain_balance()
    end
]]--
    -- Set up te joint springs
    self.set_limb_joint_springs(self.angular_spring_power_loose, self.angular_spring_friction)
    
    -- Set the legs' state
    self.set_jg_state(self.jg.legs, self.jgs.SLIDE)
    -- Set the arms' and neck state, if they're not doing anything else
    -- FG
--    if self.jg.arm_fg.state == self.jgs.IDLE or self.is_jg_ambulating_now(self.jg.arm_fg) then
      self.set_jg_state(self.jg.arm_fg, self.jgs.SLIDE)
--    end
    -- BG
--    if self.jg.arm_bg.state == self.jgs.IDLE or self.is_jg_ambulating_now(self.jg.arm_bg) then
      self.set_jg_state(self.jg.arm_bg, self.jgs.SLIDE)
--    end
    -- Neck
--    if self.jg.neck.state == self.jgs.IDLE or self.is_jg_ambulating_now(self.jg.neck) then
      self.set_jg_state(self.jg.neck, self.jgs.SLIDE)
--    end
  end


  ------------------------------------------------------
  -- SKID

  function self.skid()
		self.balance_state = self.balance.BIPED
    
    self.body_mo = self:GetMOByName("Torso")

    -- Set up te joint springs
    self.set_limb_joint_springs(self.angular_spring_power_stiffer, self.angular_spring_friction)
    
    -- Legs
    self.set_jg_state(self.jg.legs, self.jgs.SKID)
    -- Set the arms' and neck state, if they're not doing anything else
    -- FG
--    if self.jg.arm_fg.state == self.jgs.IDLE or self.is_jg_ambulating_now(self.jg.arm_fg) then
      self.set_jg_state(self.jg.arm_fg, self.jgs.SKID)
--    end
    -- BG
--    if self.jg.arm_bg.state == self.jgs.IDLE or self.is_jg_ambulating_now(self.jg.arm_bg) then
      self.set_jg_state(self.jg.arm_bg, self.jgs.SKID)
--    end
    -- Neck
--    if self.jg.neck.state == self.jgs.IDLE or self.is_jg_ambulating_now(self.jg.neck) then
      self.set_jg_state(self.jg.neck, self.jgs.SKID)
--    end
    
    if not self.body_mo then return end
    -- Give the guy a last lil push upward so he can tuck his feet under to stop
    --self.body_mo:PullTest4(self.body_mo:RotateVectorForGravity(VectorF(0, 2000)))
  end


  ------------------------------------------------------
  -- ATOMIZE

  function self.atomize()    
    self.body_mo = self:GetMOByName("Torso")
    
    -- Does not involve Legs
--    self.set_jg_state(self.jg.legs, self.jgs.SKID)
    -- Set only the BG arm and neck's state, nothing else is involved in atomizing
    -- FG
--    if self.jg.arm_fg.state == self.jgs.IDLE or self.is_jg_ambulating_now(self.jg.arm_fg) then
--      self.set_jg_state(self.jg.arm_fg, self.jgs.SKID)
--    end
    -- BG
--    if self.jg.arm_bg.state == self.jgs.IDLE or self.is_jg_ambulating_now(self.jg.arm_bg) then
      self.set_jg_state(self.jg.arm_bg, self.jgs.ATOMIZE)
--    end
    -- Neck
--    if self.jg.neck.state == self.jgs.IDLE or self.is_jg_ambulating_now(self.jg.neck) then
      self.set_jg_state(self.jg.neck, self.jgs.ATOMIZE)
--    end
    
  end


  ------------------------------------------------------
  -- ASSEMBLE

  function self.assemble()    
    self.body_mo = self:GetMOByName("Torso")
    
    -- Does not involve Legs
--    self.set_jg_state(self.jg.legs, self.jgs.SKID)
    -- Set only the BG arm and neck's state, nothing else is involved in atomizing
    -- FG
--    if self.jg.arm_fg.state == self.jgs.IDLE or self.is_jg_ambulating_now(self.jg.arm_fg) then
        self.set_jg_state(self.jg.arm_fg, self.jgs.ASSEMBLE)
--    end
    -- BG
--    if self.jg.arm_bg.state == self.jgs.IDLE or self.is_jg_ambulating_now(self.jg.arm_bg) then
--      self.set_jg_state(self.jg.arm_bg, self.jgs.POINT_AT)
--    end
    -- Neck
    if self.jg.neck.state == self.jgs.IDLE then
      self.set_jg_state(self.jg.neck, self.jgs.ASSEMBLE)
    end
    
  end


 ------------------------------------------------------
  -- CROUCH

  function self.crouch()    
		-- Set up te joint springs
		--self.set_limb_joint_springs(self.angular_spring_power_stiffer, self.angular_spring_power_stiffer)
    
		self.set_jg_state(self.jg.legs, self.jgs.CROUCH)
    self.set_jg_state(self.jg.neck, self.jgs.CROUCH)	
		self.set_jg_state(self.jg.arm_fg, self.jgs.CROUCH)
		self.set_jg_state(self.jg.arm_bg, self.jgs.CROUCH)
		
		self.balance_state = self.balance.BIPED
	end

 ------------------------------------------------------
  -- LIFT

  function self.lift()    
		-- Set up te joint springs
		self.set_limb_joint_springs(self.angular_spring_power_stiffer, self.angular_spring_power_stiffer)
    
		-- Move arms up
		self.set_jg_state(self.jg.legs, self.jgs.LIFT)
    self.set_jg_state(self.jg.neck, self.jgs.LIFT)	
		self.set_jg_state(self.jg.arm_fg, self.jgs.LIFT)
		self.set_jg_state(self.jg.arm_bg, self.jgs.LIFT)
		
		self.balance_state = self.balance.LIFT
  end
	
	------------------------------------------------------
  -- CARRY

  function self.carry()    
		-- Set up te joint springs
		self.set_limb_joint_springs(self.angular_spring_power_stiffer, self.angular_spring_power_stiffer)
    
		-- set arms to carry pose
		self.set_jg_state(self.jg.arm_fg, self.jgs.LIFT)
		self.set_jg_state(self.jg.arm_bg, self.jgs.LIFT)
		self.jg.arm_fg.anim_num = 3
		self.jg.arm_bg.anim_num = 3
	end
	
	------------------------------------------------------
  -- THROW CHARGE

  function self.throw_charge()    
		-- Throw pose
		self.set_jg_state(self.jg.legs, self.jgs.THROW_CHARGE)
    self.set_jg_state(self.jg.neck, self.jgs.THROW_CHARGE)	
		self.set_jg_state(self.jg.arm_fg, self.jgs.THROW_CHARGE)
		self.set_jg_state(self.jg.arm_bg, self.jgs.THROW_CHARGE)
		
		self.balance_state = self.balance.BIPED
	end
	
	------------------------------------------------------
  -- THROW 

  function self.throw()    
		-- Throw charge pose
		self.set_jg_state(self.jg.legs, self.jgs.THROW)
    self.set_jg_state(self.jg.neck, self.jgs.THROW)	
		self.set_jg_state(self.jg.arm_fg, self.jgs.THROW)
		self.set_jg_state(self.jg.arm_bg, self.jgs.THROW)
		
		self.balance_state = self.balance.BIPED
	end
	

  --------------------------------------------------------
  -- Debug drawing
   
  function self.draw_raycasts()
  --[[
    local rayvec = VectorF(0,0)
    if self:IsMirrored() then rayvec = self.raycast_legvec_left else rayvec = self.raycast_legvec_right end
    local color
    if self.jg.legs.anim == self.poseanim.run then color = ColorRGBA(255,255,255,255) else color = ColorRGBA(255,55,55,255) end
    local leg = self:GetMOByName("Leg FG Shin") 
    if leg then
      local leg_pos = leg:GetPosition()
      leg:DrawWireLine(leg_pos, leg_pos + rayvec, color )
    end 
    local leg = self:GetMOByName("Leg BG Shin")
    if leg then
      local leg_pos = leg:GetPosition()
      leg:DrawWireLine(leg_pos, leg_pos + rayvec, color )
    end 
  ]]
    


    -- Draw orientation and balance target vectors so we can see what's going on
    orientationVec = VectorF(0, 1.0)
    accelerationVec = VectorF(0, -1.0)
    balanceTargetVec = VectorF(0, 1.0)

    local body = self:GetMOByName("Torso")
    if body then
      orientationVec:RotateLeft(body:GetOrientation())
      -- Get the gravity acceleration that is acting on the body right now
      body:RotateVectorForGravity(accelerationVec)
      -- Make the balance target's length correspond with the balance spring strength
      balanceTargetVec.mY = body:GetBalancerPower() / 3000;
      -- Need to rotate this the opposite way?
      balanceTargetVec:RotateRight(body:GetBalanceToAngle())
      local body_pos = body:GetPosition()
      body:DrawWireLine(body_pos, body_pos + orientationVec, ColorRGBA(255, 255, 255, 255))
      body:DrawWireLine(body_pos, body_pos + accelerationVec, ColorRGBA(255, 0, 0, 255))
      -- Only draw balance if it's active
      if body:GetBalancer() then
        body:DrawWireLine(body_pos, body_pos + balanceTargetVec, ColorRGBA(0, 255, 0, 255))
      end
    end
  end
 
  -- Build UI resource bars etc
  pioneer_ui.build(self)
	
	
end



-------------------------------------------------------------------
-------------------------------------------------------------------
-- UPDATE
-------------------------------------------------------------------
-------------------------------------------------------------------



-- Pioneer standardized Update. This is called at the beginning of each frame update in its own script
function pioneer_std.update(self)
  if not self then return end
	
	local ctrl = self:GetController()
	
	if scene:GetCurrentFrameIndex() == 1 then
		if self:IsMountedToAnything() then
			self.delete_capsule()
		end
	end
	
	if not self.capsule_broken then
		
		-- boom respawn effect
		if ctrl and not self.respawn_effect_triggered then
			self.respawn_effect_triggered = true
			local ps = self:GetPSByName("Respawn")
			if ps then ps:EmitBoom() end
		end
		
		-- check whether we wanna break the capsule now
		local break_now = false
		if ctrl then 
			if ctrl:AnyButtonPressed() then 
				break_now = true
			end
		end
		if self:IsMirrored() then
			break_now = true
		end
		-- check if the capsule was broken already
		if not break_now then
			local capsule = self:GetMOByName("Capsule")
			if (capsule and capsule:GetAreaLossPerc()>0.01)
			or not capsule then
				break_now = true;
				self.capsule_break_wait_time = 0
			end
		end
		
		-- break capsule 
		if break_now and self.capsule_break_wait_time <= 0 then
			self.break_capsule()
			self.capsule_broken = true
			if not ctrl then
				-- make this pioneer dead if capsule is broken and no controller attached yet
				self:SetDead()
				-- paint the pioneer with some mold/moss decals
				
			end			
		end
	end
 
	-- don't let pioneer to move a little while after respawned
	if ctrl and self.capsule_break_wait_time>0 then
			self.capsule_break_wait_time = self.capsule_break_wait_time - self:GetDeltaTime()
			return 
	end
	
  if not ctrl then return end
	
	if not self.ui then pioneer_ui.build(self) end

	
  --local my_table = scene:GetAlerts()
  --scene:WriteToScreen(tostring(my_table[0]['a22']), VectorF(300,300), No)
  --scene:WriteToScreen(tostring(my_table[0][1]), VectorF(300,280), No)
  --scene:WriteToScreen(tostring(my_table[1][0]), VectorF(300,260), No)
  
  --for k, v in pairs(my_table) do
  --scene:WriteToScreen(tostring(v), VectorF(300,300), No)
  --end
  --if my_table[0][0]==22 then return end
  --if my_table[0]==22 then return end
  


  --------------------------------------------------
  -- Get Frequently Used Pointers
  -- here we get fresh pointers to head, body and one leg MOs
  -- we always have to get fresh pointers to self and all its objects, because self and its objects can be brokem
  -- we assume that pointers to any self object can change in any play-frame 
  self.head_mo = self:GetMOByName("Head")
  self.body_mo = self:GetMOByName("Torso")
  self.hip_joint = self:GetJointByName("Leg FG Hip")
  if self.hip_joint == nil then self.hip_joint = self:GetJointByName("Leg BG Hip") end
  -- Also un-rotate the body velocity so we can do simple logic on it
  if self.body_mo then
    self.unrotated_vel = self.body_mo:UnRotateVectorForGravity(self.body_mo:GetVelocity())
  end


  -----------------------------------------------------
  -- Reset animation speed modifications
  self.jg.legs.anim_speed = 1.0
  self.jg.arm_fg.anim_speed = 1.0
  self.jg.arm_bg.anim_speed = 1.0
  self.jg.neck.anim_speed = 1.0
  

  ----------------------------------------------------------
  -- Debug Drawing

  -- draw raycasts
  -- self.draw_raycasts()

  -- draw vector to up and rotate it by gravity
  --local vec = VectorF(0,2)
  --vec = self.body_mo:RotateVectorForGravity(vec)
  --self.body_mo:DrawWireVector(self.body_mo:GetPosition(), vec, ColorRGBA(255,255,255,255))


  --------------------------------------------------------------
  -- Check if this is still alive and well 
  
  -- Do we have fatal damage and should start dying?
  self.check_fatal_damage()
  
  -- Check if we are dying; proceed to become fully dead
  if self.is_dying() and self.dying_timer:TimeIsUp() and self:IsAlive() then
    self.set_fully_dead()
  end
--[[
  -- If no body, then we ded
  if not (self.body_mo and self:IsAlive()) then
    return
  end
]]--
  -- Check for controller
  local controller = self:GetController()
  -- If we don't have a controller, just stand there -- improve; code below needs to run too even when no controller
  if not controller then
    if self.body_mo then
--      self:MOSet("Torso"):SetBalanceToAngle(self.body_mo:RotateAngleForGravity(self.balance_lean))
--      self:MOSet("Torso"):SetBalancerPower(self.balance_power)
      self.balance_state = self.balance.NONE
    end
  -- Handle all controller input
  elseif self:IsDead() then
    -- Do nothing?
  else
    if not controller:GetMenuVisible() and not controller:GetIsRemoteControlling() then
      -- handle input if not remote controlling something else and not in menu now
      self.handle_input(controller)
    else
      --stop ambulation and regain balance if needed
      if self.ambulation_input ~= VectorF() or self.jetpack_input ~= 0 then
        self.jetpack_input = 0
        self.idle()
      elseif self.balance_state == self.balance.NONE and self.can_regain_balance_now() then
        self.idle()
      end
    end
  end

  -----------------------------------------------------------
  -- Update animations and physics based on current states
  -----------------------------------------------------------

  ---------------------------------
  -- LEGS JOINT GROUP STATE

  -- IDLE
  if self.jg.legs.state == self.jgs.IDLE then
  
    -- Fall over if we can't be in balance due to motion
--    if not self.can_regain_balance_now() then
    if self.get_altitude(3) > 2 then
      self.fall()
    else
--[[ TODO: Make this work
      -- If our legs are not on each side of our CoM, we need to take some corrective steps to get our feet under our Pio
      local balance_input = self.get_biped_balance_input()
      if math.abs(balance_input) > 0 then
        self.regain_balance(VectorF(balance_input, 0))
      -- Ok, feet planted on steady ground.. just stand there
      else
]]--
        self.jg.legs.anim = self.poseanim.idle
        self.pose_anim_advance(self.jg.legs, false)    
        self.balance_state = self.balance.BIPED
        self.balance_lean = 0
--      end
    end
  -- DIE
  elseif self.jg.legs.state == self.jgs.DIE then
    self.jg.legs.anim = self.poseanim.die
    self.pose_anim_advance(self.jg.legs, false)
    self.set_limb_joint_springs(self.angular_spring_power_loose, self.angular_spring_friction)
    
    self.balance_state = self.balance.NONE
    self.balance_lean = 0
  -- SLACK
  elseif self.jg.legs.state == self.jgs.SLACK then
    self.jg.legs.anim = self.poseanim.slack
    self.balance_state = self.balance.NONE
  -- BRACE
  elseif self.jg.legs.state == self.jgs.BRACE then
    self.jg.legs.anim = self.poseanim.brace
    -- Animate the animation backwards if facing opposite way of last direction of travel
    if self.pose_anim_advance(self.jg.legs, (self:IsMirrored() and not self.is_ambulating_left) or (not self:IsMirrored() and self.is_ambulating_left)) then
      self.idle()
    end
    self.balance_lean = 0.15
  -- RIDE
  elseif self.jg.legs.state == self.jgs.RIDE then
    self.jg.legs.anim = self.poseanim.ride
    self.pose_anim_advance(self.jg.legs, false)
    self.balance_state = self.balance.NONE
  -- STEP
  elseif self.jg.legs.state == self.jgs.STEP then
    self.jg.legs.anim = self.poseanim.step
    -- Animate the animation backwards if facing opposite way of last direction of travel
    if self.pose_anim_advance(self.jg.legs, (self:IsMirrored() and not self.is_ambulating_left) or (not self:IsMirrored() and self.is_ambulating_left)) then
      self.idle()
    end
    self.balance_state = self.balance.BIPED
    self.balance_lean = 0.1
  -- WALK
  elseif self.jg.legs.state == self.jgs.WALK then
    self.jg.legs.anim = self.poseanim.walk
    -- Animate the animation backwards if facing opposite way of last direction of travel
    if self.pose_anim_advance(self.jg.legs, (self:IsMirrored() and not self.is_ambulating_left) or (not self:IsMirrored() and self.is_ambulating_left)) then
      self.idle()
    end
    -- forward lean when walking
    self.balance_state = self.balance.BIPED
    self.balance_lean = 0.1
  -- RUN
  elseif self.jg.legs.state == self.jgs.RUN then
    self.jg.legs.anim = self.poseanim.run
    -- Set speed when running vs going reverse
    local reverse = (self:IsMirrored() and not self.is_ambulating_left) or (not self:IsMirrored() and self.is_ambulating_left)
    if reverse then
      self.jg.legs.anim_speed = 0.5
    else
      self.jg.legs.anim_speed = 1.0
    end

			-- Pause run animation if legs are not going to make contact with anything below
		local wait_leg_run = false
		local leg_mo = nil
		-- Pick which leg is relevant in the run cycle
		if self.jg.legs.anim_num == 2 then
			leg_mo = self:GetMOByName("Leg FG Shin")
		end
		if self.jg.legs.anim_num == 5 then
			leg_mo = self:GetMOByName("Leg BG Shin")
		end
		
		-- If in the proper place in the run cycle (one leg full forward), pause if sensor shows that we're not in touch with the ground
		if leg_mo then
			local leg_radar_len = 0.4
			local pos = leg_mo:GetPosition()
			local vec = VectorF(leg_radar_len,0)
			local col = VectorF(0,0)
			local sig = false
			local i
			for i=0, 7, 1 do
				sig = sig or scene:RayCastVector(pos, vec, col, self)
				vec:RotateLeft(0.7854)
			end
			wait_leg_run = not sig
		end
		
		-- If we're not pausing mid-stride to get closer to ground, go ahead and move them legs
		if not wait_leg_run then			
			-- Animate the animation backwards if facing opposite way of last direction of travel
			if self.pose_anim_advance(self.jg.legs, reverse) then
				self.idle()
			end
		end
		
    -- Biped balanced
    self.balance_state = self.balance.BIPED
    -- forward lean when running
    self.balance_lean = 0.2
  -- CLIMB
  elseif self.jg.legs.state == self.jgs.CLIMB then
    self.jg.legs.anim = self.poseanim.climb
    -- Animate the animation backwards if facing opposite way of last direction of travel
    if self.pose_anim_advance(self.jg.legs, (self:IsMirrored() and not self.is_ambulating_left) or (not self:IsMirrored() and self.is_ambulating_left)) then
      self.idle()
    end
    -- Determine the appropriate lean based on ray casts telling us about angle of normal of MO/TO we're on
-- TODO
    self.balance_state = self.balance.BIPED
    self.balance_lean = 0.6
  -- CRAWL
  elseif self.jg.legs.state == self.jgs.CRAWL then
    self.jg.legs.anim = self.poseanim.crawl
    -- Animate the animation backwards if facing opposite way of last direction of travel
    if self.pose_anim_advance(self.jg.legs, (self:IsMirrored() and not self.is_ambulating_left) or (not self:IsMirrored() and self.is_ambulating_left)) then
      self.idle()
    end
  -- GET UP BACK
  elseif self.jg.legs.state == self.jgs.GET_UP_BACK then
    self.jg.legs.anim = self.poseanim.get_up_back
    if self.pose_anim_advance(self.jg.legs, false) then
      -- We are now in balance on our feet
      self.balance_state = self.balance.BIPED
      self.idle()
    end
  -- GET UP FRONT
  elseif self.jg.legs.state == self.jgs.GET_UP_FRONT then
    self.jg.legs.anim = self.poseanim.get_up_front
    if self.pose_anim_advance(self.jg.legs, false) then
      -- We are now in balance on our feet
      self.balance_state = self.balance.BIPED
      self.idle()
    end
  -- GO PRONE
  elseif self.jg.legs.state == self.jgs.GO_PRONE then
    -- Balancers pull down body to horizontal
    self.balance_state = self.balance.GO_PRONE

    self.jg.legs.anim = self.poseanim.go_prone
    if self.pose_anim_advance(self.jg.legs, false) then
      -- After done going prone, start sliding state
      self.slide(0)
    end
  -- TEETER
  elseif self.jg.legs.state == self.jgs.TEETER then
    self.jg.legs.anim = self.poseanim.teeter
    if self.pose_anim_advance(self.jg.legs, false) then
      self.idle()
    end
    self.balance_state = self.balance.NONE
  -- PREJUMP
  elseif self.jg.legs.state == self.jgs.PREJUMP then
    self.jg.legs.anim = self.poseanim.prejump		
		-- When detect we are ready to push off something properly after having crouched down and loaded legs, then actually do so
    if self.pose_anim_advance(self.jg.legs, false) and self.legs_colliding_with_something() then
      self.set_jg_state(self.jg.legs, self.jgs.JUMP)
		end
    self.set_limb_joint_springs(self.angular_spring_power_stiffer, self.angular_spring_friction)
    self.balance_state = self.balance.JUMPING
  -- JUMP
  elseif self.jg.legs.state == self.jgs.JUMP then
    self.jg.legs.anim = self.poseanim.jump
		-- When we start falling down again after some time of jump travel, go into landing pose
    if self.pose_anim_advance(self.jg.legs, false) and self.is_descending_now() then
			self.set_jg_state(self.jg.legs, self.jgs.POSTJUMP)
		end
    self.set_limb_joint_springs(self.angular_spring_power_stiffer, self.angular_spring_friction)
    self.balance_state = self.balance.JUMPING
  -- POSTJUMP
  elseif self.jg.legs.state == self.jgs.POSTJUMP then
    self.jg.legs.anim = self.poseanim.postjump
		-- When interval timer is up, go to idle
    if self.pose_anim_advance(self.jg.legs, false) then
      self.idle()
    end
    self.set_limb_joint_springs(self.angular_spring_power_stiff, self.angular_spring_friction)
    self.balance_state = self.balance.JUMPING
  -- FALL
  elseif self.jg.legs.state == self.jgs.FALL then
    self.jg.legs.anim = self.poseanim.fall
    self.pose_anim_advance(self.jg.legs, false)
    -- Stop falling flail when close to the ground
    if self.get_altitude(2) < 1 then
      self.idle()
    end
    self.balance_state = self.balance.NONE
  -- FLY
  elseif self.jg.legs.state == self.jgs.FLY then
    self.jg.legs.anim = self.poseanim.fly
--    if self.pose_anim_advance(self.jg.legs, false) then
--      self.idle()
--    end

		-- Note that we are using Aurium
		self.no_aurium_use_timer:Reset()

    self.balance_state = self.balance.FLYING
  -- SKID
  elseif self.jg.legs.state == self.jgs.SKID then
    self.jg.legs.anim = self.poseanim.skid
    if self.pose_anim_advance(self.jg.legs, false) then
      self.set_jg_state(self.jg.legs, self.jgs.IDLE)
    end
    if self.is_ambulating_left then
      -- Counter lean for a lil bit so we can come screetching to a halt
      self.balance_lean = 0.8
    else
      self.balance_lean = -0.8
    end
    self.balance_state = self.balance.BIPED
--    self.balance_power = 6000
  -- SLIDE
  elseif self.jg.legs.state == self.jgs.SLIDE then
    self.jg.legs.anim = self.poseanim.slide
    if self.pose_anim_advance(self.jg.legs, false) then
      self.idle()
    end
    self.balance_state = self.balance.NONE
  -- GRAB TOOL
  elseif self.jg.legs.state == self.jgs.GRAB_TOOL then
    self.jg.legs.anim = self.poseanim.none
  -- DRAW TOOL
  elseif self.jg.legs.state == self.jgs.DRAW_TOOL then
    self.jg.legs.anim = self.poseanim.none
  -- AIM TOOL AT
  elseif self.jg.legs.state == self.jgs.AIM_TOOL_AT then
    self.jg.legs.anim = self.poseanim.none
  -- POINT AT
  elseif self.jg.legs.state == self.jgs.POINT_AT then
    self.jg.legs.anim = self.poseanim.none
  -- CROUCH
	elseif self.jg.legs.state == self.jgs.CROUCH then
    self.jg.legs.anim = self.poseanim.crouch
	-- LIFT
	elseif self.jg.legs.state == self.jgs.LIFT then
    self.jg.legs.anim = self.poseanim.lift
		--self.balance_state = self.balance.LIFT
		self.pose_anim_advance(self.jg.legs, false)
	-- THROW CHARGE
	elseif self.jg.legs.state == self.jgs.THROW_CHARGE then
    self.jg.legs.anim = self.poseanim.throw_charge
	-- THROW	
	elseif self.jg.legs.state == self.jgs.THROW then
    self.jg.legs.anim = self.poseanim.throw
	end

  ---------------------------------
  -- ARM FG JOINT GROUP STATE

  -- IDLE
  if self.jg.arm_fg.state == self.jgs.IDLE then
    self.jg.arm_fg.anim = self.poseanim.idle
    -- Sync with the legs' animation
    self.jg.arm_fg.anim_num = self.jg.legs.anim_num
  -- DIE
  elseif self.jg.arm_fg.state == self.jgs.DIE then
    self.jg.arm_fg.anim = self.poseanim.die
    self.pose_anim_advance(self.jg.arm_fg, false)
  -- SLACK
  elseif self.jg.arm_fg.state == self.jgs.SLACK then
    self.jg.arm_fg.anim = self.poseanim.slack
  -- BRACE
  elseif self.jg.arm_fg.state == self.jgs.BRACE then
    self.jg.arm_fg.anim = self.poseanim.brace
    -- Sync with the legs' animation
    self.jg.arm_fg.anim_num = self.jg.legs.anim_num
  -- RIDE
  elseif self.jg.arm_fg.state == self.jgs.RIDE then
    self.jg.arm_fg.anim = self.poseanim.ride
    self.pose_anim_advance(self.jg.arm_fg, false)
  -- STEP
  elseif self.jg.arm_fg.state == self.jgs.STEP then
    self.jg.arm_fg.anim = self.poseanim.step
    -- Sync with the legs' animation
    self.jg.arm_fg.anim_num = self.jg.legs.anim_num
  -- WALK
  elseif self.jg.arm_fg.state == self.jgs.WALK then
    self.jg.arm_fg.anim = self.poseanim.walk
    -- Sync with the legs' animation
    self.jg.arm_fg.anim_num = self.jg.legs.anim_num
  -- RUN
  elseif self.jg.arm_fg.state == self.jgs.RUN then
    self.jg.arm_fg.anim = self.poseanim.run
    -- Sync with the legs' animation
    self.jg.arm_fg.anim_num = self.jg.legs.anim_num
  -- CLIMB
  elseif self.jg.arm_fg.state == self.jgs.CLIMB then
    self.jg.arm_fg.anim = self.poseanim.climb
    -- Sync with the legs' animation
    self.jg.arm_fg.anim_num = self.jg.legs.anim_num
  -- CRAWL
  elseif self.jg.arm_fg.state == self.jgs.CRAWL then
    self.jg.arm_fg.anim = self.poseanim.crawl
    -- Sync with the legs' animation
    self.jg.arm_fg.anim_num = self.jg.legs.anim_num
  -- GET UP BACK
  elseif self.jg.arm_fg.state == self.jgs.GET_UP_BACK then
    self.jg.arm_fg.anim = self.poseanim.get_up_back
    -- Sync with the legs' animation
    self.jg.arm_fg.anim_num = self.jg.legs.anim_num
  -- GET UP FRONT
  elseif self.jg.arm_fg.state == self.jgs.GET_UP_FRONT then
    self.jg.arm_fg.anim = self.poseanim.get_up_front
    -- Sync with the legs' animation
    self.jg.arm_fg.anim_num = self.jg.legs.anim_num
  -- GO PRONE
  elseif self.jg.arm_fg.state == self.jgs.GO_PRONE then
    self.jg.arm_fg.anim = self.poseanim.go_prone
    -- Sync with the legs' animation
    self.jg.arm_fg.anim_num = self.jg.legs.anim_num
  -- TEETER
  elseif self.jg.arm_fg.state == self.jgs.TEETER then
    self.jg.arm_fg.anim = self.poseanim.teeter
    -- Sync with the legs' animation
    self.jg.arm_fg.anim_num = self.jg.legs.anim_num
  -- PREJUMP
  elseif self.jg.arm_fg.state == self.jgs.PREJUMP then
    self.jg.arm_fg.anim = self.poseanim.prejump
		-- Sync with legs when they go to the next phase of jumping
    if self.jg.legs.state == self.jgs.JUMP then
      self.set_jg_state(self.jg.arm_fg, self.jgs.JUMP)
		end
  -- JUMP
  elseif self.jg.arm_fg.state == self.jgs.JUMP then
    self.jg.arm_fg.anim = self.poseanim.jump
		-- Sync with legs when they go to the next phase of jumping
    if self.jg.legs.state == self.jgs.POSTJUMP then
      self.set_jg_state(self.jg.arm_fg, self.jgs.POSTJUMP)
		end
  -- POSTJUMP
  elseif self.jg.arm_fg.state == self.jgs.POSTJUMP then
    self.jg.arm_fg.anim = self.poseanim.postjump
		-- When interval timer is up, go to idle
    if self.pose_anim_advance(self.jg.arm_fg, false) then
      self.idle()
    end
  -- FALL
  elseif self.jg.arm_fg.state == self.jgs.FALL then
    self.jg.arm_fg.anim = self.poseanim.fall
    -- Sync with the legs' animation
    self.jg.arm_fg.anim_num = self.jg.legs.anim_num
  -- FLY
  elseif self.jg.arm_fg.state == self.jgs.FLY then
    self.jg.arm_fg.anim = self.poseanim.fly
  -- SKID
  elseif self.jg.arm_fg.state == self.jgs.SKID then
    self.jg.arm_fg.anim = self.poseanim.skid
    if self.pose_anim_advance(self.jg.arm_fg, false) then
      self.set_jg_state(self.jg.arm_fg, self.jgs.IDLE)
    end
  -- SLIDE
  elseif self.jg.arm_fg.state == self.jgs.SLIDE then
    self.jg.arm_fg.anim = self.poseanim.slide
    if self.pose_anim_advance(self.jg.arm_fg, false) then
      self.set_jg_state(self.jg.arm_fg, self.jgs.IDLE)
    end
  -- GRAB TOOL
  elseif self.jg.arm_fg.state == self.jgs.GRAB_TOOL then
    self.jg.arm_fg.anim = self.poseanim.grab_tool
    if self.pose_anim_advance(self.jg.arm_fg, false) then
-- TODO: Move to the next state!
      self.set_jg_state(self.jg.arm_fg, self.jgs.IDLE)
    end
  -- DRAW TOOL
  elseif self.jg.arm_fg.state == self.jgs.DRAW_TOOL then
    self.jg.arm_fg.anim = self.poseanim.draw_tool
    if self.pose_anim_advance(self.jg.arm_fg, false) then
-- TODO: Move to the next state!
      self.set_jg_state(self.jg.arm_fg, self.jgs.IDLE)
    end
  -- AIM TOOL AT
  elseif self.jg.arm_fg.state == self.jgs.AIM_TOOL_AT then
    self.jg.arm_fg.anim = self.poseanim.none
    -- Procedurally aim
  -- POINT AT
  elseif self.jg.arm_fg.state == self.jgs.POINT_AT then
    self.jg.arm_fg.anim = self.poseanim.point_at
  -- ATOMIZE
  elseif self.jg.arm_fg.state == self.jgs.ATOMIZE then
    self.jg.arm_fg.anim = self.poseanim.point_at
    self.jg.arm_fg.point_target = self:GetAtomizedPos()
  -- ASSEMBLE
  elseif self.jg.arm_fg.state == self.jgs.ASSEMBLE then
    self.jg.arm_fg.anim = self.poseanim.point_at
    self.jg.arm_fg.point_target = self:GetAssembledPos()
	 -- CROUCH
	elseif self.jg.legs.state == self.jgs.CROUCH then
    self.jg.arm_fg.anim = self.poseanim.crouch
	-- LIFT
  elseif self.jg.arm_fg.state == self.jgs.LIFT then
    self.jg.arm_fg.anim = self.poseanim.lift
		--self.balance_state = self.balance.LIFT
		self.pose_anim_advance(self.jg.arm_fg, false)
	-- THROW CHARGE
	elseif self.jg.arm_fg.state == self.jgs.THROW_CHARGE then
    self.jg.arm_fg.anim = self.poseanim.throw_charge
	--THROW
	elseif self.jg.arm_fg.state == self.jgs.THROW then
    self.jg.arm_fg.anim = self.poseanim.throw
		if self.pose_anim_advance(self.jg.arm_fg, false) then
      self.jg.arm_fg.anim = self.poseanim.idle
    end
	end

  ---------------------------------
  -- ARM BG JOINT GROUP STATE

  -- IDLE
  if self.jg.arm_bg.state == self.jgs.IDLE then
    self.jg.arm_bg.anim = self.poseanim.idle
    -- Sync with the legs' animation
    self.jg.arm_bg.anim_num = self.jg.legs.anim_num
  -- DIE
  elseif self.jg.arm_bg.state == self.jgs.DIE then
    self.jg.arm_bg.anim = self.poseanim.die
    self.pose_anim_advance(self.jg.arm_bg, false)
  -- SLACK
  elseif self.jg.arm_bg.state == self.jgs.SLACK then
    self.jg.arm_bg.anim = self.poseanim.slack
  -- BRACE
  elseif self.jg.arm_bg.state == self.jgs.BRACE then
    self.jg.arm_bg.anim = self.poseanim.brace
    -- Sync with the legs' animation
    self.jg.arm_bg.anim_num = self.jg.legs.anim_num
  -- RIDE
  elseif self.jg.arm_bg.state == self.jgs.RIDE then
    self.jg.arm_bg.anim = self.poseanim.ride
    self.pose_anim_advance(self.jg.arm_bg, false)
  -- STEP
  elseif self.jg.arm_bg.state == self.jgs.STEP then
    self.jg.arm_bg.anim = self.poseanim.step
    -- Sync with the legs' animation
    self.jg.arm_bg.anim_num = self.jg.legs.anim_num
  -- WALK
  elseif self.jg.arm_bg.state == self.jgs.WALK then
    self.jg.arm_bg.anim = self.poseanim.walk
    -- Sync with the legs' animation
    self.jg.arm_bg.anim_num = self.jg.legs.anim_num
  -- RUN
  elseif self.jg.arm_bg.state == self.jgs.RUN then
    self.jg.arm_bg.anim = self.poseanim.run
    -- Sync with the legs' animation
    self.jg.arm_bg.anim_num = self.jg.legs.anim_num
  -- CLIMB
  elseif self.jg.arm_bg.state == self.jgs.CLIMB then
    self.jg.arm_bg.anim = self.poseanim.climb
    -- Sync with the legs' animation
    self.jg.arm_bg.anim_num = self.jg.legs.anim_num
  -- CRAWL
  elseif self.jg.arm_bg.state == self.jgs.CRAWL then
    self.jg.arm_bg.anim = self.poseanim.crawl
    -- Sync with the legs' animation
    self.jg.arm_bg.anim_num = self.jg.legs.anim_num
  -- GET UP BACK
  elseif self.jg.arm_bg.state == self.jgs.GET_UP_BACK then
    self.jg.arm_bg.anim = self.poseanim.get_up_back
    -- Sync with the legs' animation
    self.jg.arm_bg.anim_num = self.jg.legs.anim_num
  -- GET UP FRONT
  elseif self.jg.arm_bg.state == self.jgs.GET_UP_FRONT then
    self.jg.arm_bg.anim = self.poseanim.get_up_front
    -- Sync with the legs' animation
    self.jg.arm_bg.anim_num = self.jg.legs.anim_num
  -- GO PRONE
  elseif self.jg.arm_bg.state == self.jgs.GO_PRONE then
    self.jg.arm_bg.anim = self.poseanim.go_prone
    -- Sync with the legs' animation
    self.jg.arm_bg.anim_num = self.jg.legs.anim_num
  -- TEETER
  elseif self.jg.arm_bg.state == self.jgs.TEETER then
    self.jg.arm_bg.anim = self.poseanim.teeter
    -- Sync with the legs' animation
    self.jg.arm_bg.anim_num = self.jg.legs.anim_num
  -- PREJUMP
  elseif self.jg.arm_bg.state == self.jgs.PREJUMP then
    self.jg.arm_bg.anim = self.poseanim.prejump
		-- Sync with legs when they go to the next phase of jumping
    if self.jg.legs.state == self.jgs.JUMP then
      self.set_jg_state(self.jg.arm_bg, self.jgs.JUMP)
		end
  -- JUMP
  elseif self.jg.arm_bg.state == self.jgs.JUMP then
    self.jg.arm_bg.anim = self.poseanim.jump
		-- Sync with legs when they go to the next phase of jumping
    if self.jg.legs.state == self.jgs.POSTJUMP then
      self.set_jg_state(self.jg.arm_bg, self.jgs.POSTJUMP)
		end
  -- POSTJUMP
  elseif self.jg.arm_bg.state == self.jgs.POSTJUMP then
    self.jg.arm_bg.anim = self.poseanim.postjump
		-- When interval timer is up, go to idle
    if self.pose_anim_advance(self.jg.arm_bg, false) then
      self.idle()
    end
  -- FALL
  elseif self.jg.arm_bg.state == self.jgs.FALL then
    self.jg.arm_bg.anim = self.poseanim.fall
    -- Sync with the legs' animation
    self.jg.arm_bg.anim_num = self.jg.legs.anim_num
  -- FLY
  elseif self.jg.arm_bg.state == self.jgs.FLY then
    self.jg.arm_bg.anim = self.poseanim.fly
  -- SKID
  elseif self.jg.arm_bg.state == self.jgs.SKID then
    self.jg.arm_bg.anim = self.poseanim.skid
    if self.pose_anim_advance(self.jg.arm_bg, false) then
      self.set_jg_state(self.jg.arm_bg, self.jgs.IDLE)
    end
  -- SLIDE
  elseif self.jg.arm_bg.state == self.jgs.SLIDE then
    self.jg.arm_bg.anim = self.poseanim.slide
    if self.pose_anim_advance(self.jg.arm_bg, false) then
      self.set_jg_state(self.jg.arm_bg, self.jgs.IDLE)
    end
  -- GRAB TOOL
  elseif self.jg.arm_bg.state == self.jgs.GRAB_TOOL then
    self.jg.arm_bg.anim = self.poseanim.grab_tool
    if self.pose_anim_advance(self.jg.arm_bg, false) then
-- TODO: Move to the next state!
      self.set_jg_state(self.jg.arm_bg, self.jgs.IDLE)
    end
  -- DRAW TOOL
  elseif self.jg.arm_bg.state == self.jgs.DRAW_TOOL then
    self.jg.arm_bg.anim = self.poseanim.draw_tool
    if self.pose_anim_advance(self.jg.arm_bg, false) then
-- TODO: Move to the next state!
      self.set_jg_state(self.jg.arm_bg, self.jgs.IDLE)
    end
  -- AIM TOOL AT
  elseif self.jg.arm_bg.state == self.jgs.AIM_TOOL_AT then
    self.jg.arm_bg.anim = self.poseanim.none
    -- Procedurally aim
  -- POINT AT
  elseif self.jg.arm_bg.state == self.jgs.POINT_AT then
    self.jg.arm_bg.anim = self.poseanim.point_at
  -- ATOMIZE
  elseif self.jg.arm_bg.state == self.jgs.ATOMIZE then
    self.jg.arm_bg.anim = self.poseanim.point_at
    self.jg.arm_bg.point_target = self:GetAtomizedPos()
  -- ASSEMBLE
  elseif self.jg.arm_bg.state == self.jgs.ASSEMBLE then
    self.jg.arm_bg.anim = self.poseanim.point_at
    self.jg.arm_bg.point_target = self:GetAssembledPos()
	-- CROUCH
	elseif self.jg.legs.state == self.jgs.CROUCH then
    self.jg.arm_bg.anim = self.poseanim.crouch
	-- LIFT
	elseif self.jg.arm_bg.state == self.jgs.LIFT then
    self.jg.arm_bg.anim = self.poseanim.lift
		self.pose_anim_advance(self.jg.arm_bg, false)
	-- THROW CHARGE
	elseif self.jg.arm_bg.state == self.jgs.THROW_CHARGE then
    self.jg.arm_bg.anim = self.poseanim.throw_charge
	-- THROW
  elseif self.jg.arm_bg.state == self.jgs.THROW then
    self.jg.arm_bg.anim = self.poseanim.throw
		if self.pose_anim_advance(self.jg.arm_bg, false) then
			self.jg.arm_bg.anim = self.poseanim.idle
    end
	end

  ---------------------------------
  -- NECK JOINT GROUP STATE

  -- IDLE
  if self.jg.neck.state == self.jgs.IDLE then
    self.jg.neck.anim = self.poseanim.idle
    self.pose_anim_advance(self.jg.neck, false)
  -- DIE
  elseif self.jg.neck.state == self.jgs.DIE then
    self.jg.neck.anim = self.poseanim.die
    self.pose_anim_advance(self.jg.neck, false)
  -- SLACK
  elseif self.jg.neck.state == self.jgs.SLACK then
    self.jg.neck.anim = self.poseanim.slack
  -- BRACE
  elseif self.jg.neck.state == self.jgs.BRACE then
    self.jg.neck.anim = self.poseanim.brace
    -- Sync with the legs' animation
    self.jg.neck.anim_num = self.jg.legs.anim_num
  -- RIDE
  elseif self.jg.neck.state == self.jgs.RIDE then
    self.jg.neck.anim = self.poseanim.ride
    self.pose_anim_advance(self.jg.neck, false)
  -- STEP
  elseif self.jg.neck.state == self.jgs.STEP then
    self.jg.neck.anim = self.poseanim.step
    -- Sync with the legs' animation
    self.jg.neck.anim_num = self.jg.legs.anim_num
  -- WALK
  elseif self.jg.neck.state == self.jgs.WALK then
    self.jg.neck.anim = self.poseanim.walk
    -- Sync with the legs' animation
    self.jg.neck.anim_num = self.jg.legs.anim_num
  -- RUN
  elseif self.jg.neck.state == self.jgs.RUN then
    self.jg.neck.anim = self.poseanim.run
    -- Sync with the legs' animation
    self.jg.neck.anim_num = self.jg.legs.anim_num
  -- CLIMB
  elseif self.jg.neck.state == self.jgs.CLIMB then
    self.jg.neck.anim = self.poseanim.climb
    -- Sync with the legs' animation
    self.jg.neck.anim_num = self.jg.legs.anim_num
  -- CRAWL
  elseif self.jg.neck.state == self.jgs.CRAWL then
    self.jg.neck.anim = self.poseanim.crawl
    -- Sync with the legs' animation
    self.jg.neck.anim_num = self.jg.legs.anim_num
  -- GET UP BACK
  elseif self.jg.neck.state == self.jgs.GET_UP_BACK then
    self.jg.neck.anim = self.poseanim.get_up_back
    -- Sync with the legs' animation
    self.jg.neck.anim_num = self.jg.legs.anim_num
  -- GET UP FRONT
  elseif self.jg.neck.state == self.jgs.GET_UP_FRONT then
    self.jg.neck.anim = self.poseanim.get_up_front
    -- Sync with the legs' animation
    self.jg.neck.anim_num = self.jg.legs.anim_num
  -- GO PRONE
  elseif self.jg.neck.state == self.jgs.GO_PRONE then
    self.jg.neck.anim = self.poseanim.go_prone
    -- Sync with the legs' animation
    self.jg.neck.anim_num = self.jg.legs.anim_num
  -- TEETER
  elseif self.jg.neck.state == self.jgs.TEETER then
    self.jg.neck.anim = self.poseanim.teeter
    -- Sync with the legs' animation
    self.jg.neck.anim_num = self.jg.legs.anim_num
  -- PREJUMP
  elseif self.jg.neck.state == self.jgs.PREJUMP then
    self.jg.neck.anim = self.poseanim.prejump
		-- Sync with legs when they go to the next phase of jumping
    if self.jg.legs.state == self.jgs.JUMP then
      self.set_jg_state(self.jg.neck, self.jgs.JUMP)
		end
  -- JUMP
  elseif self.jg.neck.state == self.jgs.JUMP then
    self.jg.neck.anim = self.poseanim.jump
		-- Sync with legs when they go to the next phase of jumping
    if self.jg.legs.state == self.jgs.POSTJUMP then
      self.set_jg_state(self.jg.neck, self.jgs.POSTJUMP)
		end
  -- POSTJUMP
  elseif self.jg.neck.state == self.jgs.POSTJUMP then
    self.jg.neck.anim = self.poseanim.postjump
		-- When interval timer is up, go to idle
    if self.pose_anim_advance(self.jg.neck, false) then
      self.idle()
    end
  -- FALL
  elseif self.jg.neck.state == self.jgs.FALL then
    self.jg.neck.anim = self.poseanim.fall
    -- Sync with the legs' animation
    self.jg.neck.anim_num = self.jg.legs.anim_num
  -- FLY
  elseif self.jg.neck.state == self.jgs.FLY then
    self.jg.neck.anim = self.poseanim.fly
  -- SKID
  elseif self.jg.neck.state == self.jgs.SKID then 
    self.jg.neck.anim = self.poseanim.skid
    if self.pose_anim_advance(self.jg.neck, false) then
-- TODO: Sync with arm animations?
      self.set_jg_state(self.jg.neck, self.jgs.IDLE)
    end
  -- SLIDE
elseif self.jg.neck.state == self.jgs.SLIDE then
    self.jg.neck.anim = self.poseanim.slide
    if self.pose_anim_advance(self.jg.neck, false) then
-- TODO: Sync with arm animations?
      self.set_jg_state(self.jg.neck, self.jgs.IDLE)
    end
  -- GRAB TOOL
  elseif self.jg.neck.state == self.jgs.GRAB_TOOL then
    self.jg.neck.anim = self.poseanim.grab_tool
    if self.pose_anim_advance(self.jg.neck, false) then
-- TODO: Sync with arm animations?
      self.set_jg_state(self.jg.neck, self.jgs.IDLE)
    end
  -- DRAW TOOL
  elseif self.jg.neck.state == self.jgs.DRAW_TOOL then
    self.jg.neck.anim = self.poseanim.draw_tool
    if self.pose_anim_advance(self.jg.neck, false) then
-- TODO: Sync with arm animations?
      self.set_jg_state(self.jg.neck, self.jgs.IDLE)
    end
  -- AIM TOOL AT
  elseif self.jg.neck.state == self.jgs.AIM_TOOL_AT then
    self.jg.neck.anim = self.poseanim.none
    -- Procedurally aim
  -- POINT AT
  elseif self.jg.neck.state == self.jgs.POINT_AT then
    self.jg.neck.anim = self.poseanim.point_at
  -- ATOMIZE
  elseif self.jg.neck.state == self.jgs.ATOMIZE then
    self.jg.neck.anim = self.poseanim.point_at
    self.jg.neck.point_target = self:GetAtomizedPos()
  -- ASSEMBLE
  elseif self.jg.neck.state == self.jgs.ASSEMBLE then
    self.jg.neck.anim = self.poseanim.point_at
    self.jg.neck.point_target = self:GetAssembledPos()
	-- LIFT
	elseif self.jg.neck.state == self.jgs.LIFT then
    self.jg.neck.anim = self.poseanim.lift
		self.pose_anim_advance(self.jg.neck, false)
	-- THROW CHARGE
	elseif self.jg.neck.state == self.jgs.THROW_CHARGE then
    self.jg.neck.anim = self.poseanim.throw_charge
		--self.jg.neck.anim = self.poseanim.point_at
		--self.jg.neck.point_target = controller:AimPoint()
	-- THROW
  elseif self.jg.neck.state == self.jgs.THROW then
    self.jg.neck.anim = self.poseanim.throw
		if self.pose_anim_advance(self.jg.neck, false) then
			self.jg.neck.anim = self.poseanim.idle
    end
	end

  ---------------------------------------------------------------
  -- Apply friction values
  ---------------------------------------------------------------

  if self.is_ambulating_now() then
    self:MOSet("Torso"):SetSlippery(0.85);
    self:MOSet("Head"):SetSlippery(0.85);
    self:MOSet("Backpack"):SetSlippery(0.85);
    
    if (self.jg.legs.anim_num == 3) or (self.jg.legs.anim_num == 4) or (self.jg.legs.anim_num == 5) then 
      self:MOSet("Leg FG"):SetSlippery(0)
      self:MOSet("Leg BG"):SetSlippery(1)
    else 
      self:MOSet("Leg FG"):SetSlippery(1)
      self:MOSet("Leg BG"):SetSlippery(0)
    end
    self:MOSet("Arm FG"):SetSlippery(1);
    self:MOSet("Arm BG"):SetSlippery(1);
  -- When just standing with balance
  elseif self.is_balancing_now() then
    self:MOSet("Torso"):SetSlippery(self.slippery_body);
    self:MOSet("Head"):SetSlippery(self.slippery_body);

    self:MOSet("Leg FG"):SetSlippery(self.slippery_limbs);
    self:MOSet("Leg BG"):SetSlippery(self.slippery_limbs);
    self:MOSet("Arm FG"):SetSlippery(self.slippery_limbs);
    self:MOSet("Arm BG"):SetSlippery(self.slippery_limbs);
  -- Sliding or flying now
  elseif self.is_sliding_now() or self.is_flying_now() or self.is_crawling_now() then
    self:MOSet(""):SetSlippery(0.85)
  -- Slack and in a heap, high friction so comes to stop fast
  else
    self:MOSet(""):SetSlippery(0.25)
  end


  -----------------------------------------------------------
  -- Apply the currently selected poses to the joint groups
  -----------------------------------------------------------

  self.fade_to_current_pose(self.jg.legs)
  self.fade_to_current_pose(self.jg.arm_fg)
  self.fade_to_current_pose(self.jg.arm_bg)
  self.fade_to_current_pose(self.jg.neck)


  -----------------------------------------------------------
  -- Make arms and head point at set targets, if applicable
  -----------------------------------------------------------

  if self.jg.arm_fg.anim == self.poseanim.point_at then
    -- Turn the shoulder joint so the arm aims at target
    self.aim_joint_at_target(self:GetJointByName("Arm FG Shoulder"), self.jg.arm_fg.point_target, math.pi / 10)
  end
  if self.jg.arm_bg.anim == self.poseanim.point_at then
    -- Turn the shoulder joint so the arm aims at target
    self.aim_joint_at_target(self:GetJointByName("Arm BG Shoulder"), self.jg.arm_bg.point_target, math.pi / 10)
  end
  if self.jg.neck.anim == self.poseanim.point_at then
-- TODO: FIX that head orientation all round the planetoid
    -- Turn the neck joint so the head looks at target 
    local joint = self:GetJointByName("Neck")
    if joint then
      local target_vec = self.jg.neck.point_target - joint:GetWorldPositionA()
      target_vec = self.body_mo:UnRotateVectorForGravity(target_vec)
      -- Don't crane neck to look for a thing behind the player
      if (self:IsMirrored() and target_vec.mX < 0) or (not self:IsMirrored() and target_vec.mX > 0) then
        local trim_angle = 0
        if self:IsMirrored() then trim_angle = math.pi * 1.0 end
        joint:FadeAngularSpring(-target_vec:GetAngleRad() + trim_angle, 0)
      end
    end
  end
  

  -----------------------------------------------------------
  -- Apply balancers to body
  -----------------------------------------------------------
    
  -- Balacing on two legs
  if self.balance_state == self.balance.BIPED then
    -- Activate balancing
    self:MOSet("Torso"):SetBalancer(true)
    self:MOSet("Head"):SetBalancer(self.jg.neck.anim ~= self.poseanim.point_at)
    -- Set the power
    self:MOSet("Torso"):SetBalancerPower(self.balance_power * 1.0)
		-- Head should have no balancer in idle balance mode
    self:MOSet("Head"):SetBalancerPower(0)
    
    -- Set angle
    
    -- Ambulating lean
    if self.is_ambulating_now() then
      if self.is_ambulating_left then
        if self:IsMirrored() then
          self:MOSet("Torso"):SetBalanceToAngle(self.body_mo:RotateAngleForGravity(-self.balance_lean)) 
        else
          self:MOSet("Torso"):SetBalanceToAngle(self.body_mo:RotateAngleForGravity(0))
        end
      else
        if not self:IsMirrored() then
          self:MOSet("Torso"):SetBalanceToAngle(self.body_mo:RotateAngleForGravity(self.balance_lean))
        else
          self:MOSet("Torso"):SetBalanceToAngle(self.body_mo:RotateAngleForGravity(0))
        end
      end
    -- Simple lean
    else
      self:MOSet("Torso"):SetBalanceToAngle(self.body_mo:RotateAngleForGravity(self.balance_lean))
    end
		
  -- Get up off the deck
  elseif self.balance_state == self.balance.GET_UP then
    self:MOSet("Torso"):SetBalancer(true)
    self:MOSet("Head"):SetBalancer(self.jg.neck.anim ~= self.poseanim.point_at)
    self:MOSet("Torso"):SetBalancerPower(self.balance_power * 0.2)
    self:MOSet("Head"):SetBalancerPower(self.balance_power * 0.25)
    
    
  -- Pull body down to the deck
  elseif self.balance_state == self.balance.GO_PRONE and self.get_altitude(2) < 1.5 then
    self:MOSet("Torso"):SetBalancer(true)
    self:MOSet("Head"):SetBalancer(false)
    self:MOSet("Torso"):SetBalancerPower(self.balance_power)
    self:MOSet("Head"):SetBalancerPower(self.balance_power * 0.8)
    
    if self:IsMirrored() then
      self:MOSet("Torso"):SetBalanceToAngle(self.body_mo:RotateAngleForGravity(-math.pi / 2))
    else
      self:MOSet("Torso"):SetBalanceToAngle(self.body_mo:RotateAngleForGravity(math.pi / 2))
    end
  
  -- Jumping control
	elseif self.balance_state == self.balance.JUMPING then
		-- Only balance on the pre-jump crouch
		if self.jg.legs.state == self.jgs.PREJUMP then
-- TODO: Angular control here?
			self:MOSet("Torso"):SetBalancer(true)
			self:MOSet("Head"):SetBalancer(true)		
		else
			self:MOSet("Torso"):SetBalancer(false)
			self:MOSet("Head"):SetBalancer(false)
		end
	
  -- Flight control magical spring assistance
	elseif self.balance_state == self.balance.FLYING then
    self:MOSet("Torso"):SetBalancer(true)
--    self:MOSet("Head"):SetBalancer(self.jg.neck.anim ~= self.poseanim.point_at)
    self:MOSet("Head"):SetBalancer(false)
		
		
    -- Have a stronger spring on body in beginning of boost, to counter the lean by Jet PS boom
--    if not self.total_flight_timer:Elapsed(0.25) then
      self:MOSet("Torso"):SetBalancerPower(self.balance_power * 10.0)
--    else
--      self:MOSet("Torso"):SetBalancerPower(self.balance_power * 0.25)
--    end
    self:MOSet("Head"):SetBalancerPower(self.balance_power)
    
    -- Look at player input and get the vector to alter the balance vector by
    local controlVector = controller:MoveVector()
		-- If there's no movememnt analog input (f e jetpack flight activated on separate button), make it not 0
		if controlVector:GetLength() < 0.05 then controlVector = VectorF(0, 1.0) end
    controlVector:Invert()
    local target_angle = self.body_mo:GetBalanceToAngle()
    
    
    -- RELATIVE CONTROL
    if self.relative_flight_control then
      -- The speed at which input affects the target angle
      local input_speed = 0.05
      -- Retard the input speed when in beginning of flight
--      if not self.total_flight_timer:Elapsed(0.5) then
--        input_speed = 0
--      elseif not self.total_flight_timer:Elapsed(1.0) then
        input_speed = input_speed * 0.6
--      end
      target_angle = self.body_mo:GetBalanceToAngle() + ((-controlVector:GetAngleRad() - math.halfpi) * input_speed)
    else
      -- ABSOLUTE CONTROL
      -- The extra fourthpi needed because head tilt
      if controlVector:GetLength() > 0.1 and self.total_flight_timer:Elapsed(0.5) then
        local flip_head_adjust = -math.fourthpi
        if self:IsMirrored() then flip_head_adjust = math.fourthpi end
        target_angle = self.body_mo:RotateAngleForGravity(-controlVector:GetAngleRad() - math.halfpi + flip_head_adjust)
      end
    end
    
--[[
    -- Don't let the target angle get too far away from the actual angle of the body orientation    
--    local head_angle = math.frotate(-math.pi, math.pi, self.head_mo:GetOrientation())
--    target_angle = math.frotate(-math.pi, math.pi, target_angle)
    local head_angle = self.head_mo:GetOrientation() - math.halfpi
    
    local angle_delta = head_angle - target_angle
    if angle_delta > math.halfpi then 
      target_angle = head_angle + math.halfpi
    elseif angle_delta < -math.halfpi then
      target_angle = head_angle - math.halfpi
    end
]]--
    -- Note that in the flipping handling in input handling the BalanceToAngle gets adjusted on flip to match what it was before the flip
    self:MOSet("Torso"):SetBalanceToAngle(target_angle)
    self:MOSet("Head"):SetBalanceToAngle(target_angle)
    
--    self:MOSet("Torso"):SetBalanceToAngle(self.body_mo:RotateAngleForGravity(-controlVector:GetAngleRad() - (math.pi / 2)))
--    self:MOSet("Head"):SetBalanceToAngle(self.body_mo:RotateAngleForGravity(-controlVector:GetAngleRad() - (math.pi / 2)))
    
    -- TEMP DEBUG
    local balance_vector = VectorF(2.0, 0)
    balance_vector:RotateRight(self.head_mo:GetBalanceToAngle() - math.halfpi)
    self.head_mo:DrawWireVector(self:GetApproxPos(), balance_vector, ColorRGBA(100,255,100,255))
		
		local body_vector = VectorF(2.0, 0)
    body_vector:RotateLeft(self.body_mo:GetOrientation() + math.halfpi)
    self.body_mo:DrawWireVector(self:GetApproxPos(), body_vector, ColorRGBA(100,100,255,255)) 
  
--    local head_vector = VectorF(2 .0, 0)
--    head_vector:RotateLeft(self.head_mo:GetOrientation() + math.halfpi)
--    self.head_mo:DrawWireVector(self:GetApproxPos(), head_vector, ColorRGBA(100,100,255,255))
    
    
  -- Crawling or climbing
  elseif self.balance_state == self.balance.PRONE then
    self:MOSet("Torso"):SetBalancer(false)
    self:MOSet("Head"):SetBalancer(false)
    self:MOSet("Torso"):SetBalancerPower(self.balance_power * 0.5)
    self:MOSet("Head"):SetBalancerPower(self.balance_power * 0.25)
    
    if self:IsMirrored() then
      self:MOSet("Torso"):SetBalanceToAngle(self.body_mo:RotateAngleForGravity(-math.pi / 2))
    else
      self:MOSet("Torso"):SetBalanceToAngle(self.body_mo:RotateAngleForGravity(math.pi / 2))
    end
		
		
	-- carrying
	elseif self.balance_state == self.balance.LIFT then
    self:MOSet("Torso"):SetBalancer(true)
    self:MOSet("Head"):SetBalancer(true)
    self:MOSet("Torso"):SetBalancerPower(self.balance_power * 10)
    self:MOSet("Head"):SetBalancerPower(self.balance_power * 1)
    
		self:MOSet("Torso"):SetBalanceToAngle(self.body_mo:RotateAngleForGravity(0))
    
  -- Not balancing! 
  else
    self:MOSet("Torso"):SetBalancer(false)
    self:MOSet("Head"):SetBalancer(false)
  end

--[[
  -- TODO: CLEAN UP BELOW
  -- At which velocity we lose our footing
  local lose_balance_velocity = 10

  if self.body_mo then
    -- Check if we should still be in balance - can't lose balance due to mirroring velocities
    if not self.mirror_change_timer:Elapsed(0.1) or
       (math.abs(self.body_mo:GetVelocity().mX) < lose_balance_velocity and
        math.abs(self.body_mo:GetVelocity().mY) < lose_balance_velocity) or
       self.flying_now then
      -- Yep, we can be balanced now
      self:MOSet("Torso"):SetBalancer(self.is_ambulating_now())
    else
      -- Lose balance
      self.idle()
    --    self.body_mo:SetSlippery(0.25)
    end
  end

]]--
  -----------------------------------------------------------
  -- Apply locomotion forces to body
  -----------------------------------------------------------

  if self.is_ambulating_now() then -- and self.balance_state == self.balance.BIPED then  
    if self.legs_colliding_with_something() or self.arms_colliding_with_something() then -- now touching the ground
      -- Left/right push force
      local push_lr = 300
      -- Push upward to get over obstacles and to just stay on the feet
      local push_up = 200
      -- Max running speed
      local max_run_vel = 7
      -- Max climbing speed
      local max_climb_vel = 2
      
      -- If moving backwards, push a lot less so the feet can keep up
      if (self.is_ambulating_left and not self:IsMirrored()) or (not self.is_ambulating_left and self:IsMirrored()) then
        push_lr = 150
        max_run_vel = 5
      end
            
      -- If body is tilted over a lot from the upright 'balanced state' then make the push less powerful, so he can't lay on his back or belly and run forward at top speed
  --[[      local tilt_angle = math.abs(self.body_mo:GetOrientation() - self.body_mo:GetBalanceToAngle())
      -- If we're beyond fallen over, don't push at all
      if tilt_angle > (math.pi / 2) then
        push_lr = 0
      -- If we're not quite horizontal, then retard the psuh forces according to how close we are to horizontal
      else
        if tilt_angle > 0.5 then push_lr = push_lr * (1.0 - ((tilt_angle - 0.5) / ((math.pi / 2) - 0.5))) end
      end
  ]]
      -- If RUNNING, don't push up quite as much
      if self.jg.legs.anim == self.poseanim.run then
        push_up = 100
        max_climb_vel = 1
      -- If WALKING, don't go as fast
      elseif self.jg.legs.anim == self.poseanim.walk then
        push_lr = 175
        max_run_vel = 2.5
        push_up = 130
        max_climb_vel = 1.5
      -- If CLIMBING or CRAWLING, don't push sideways so much
			elseif self.jg.legs.anim == self.poseanim.climb then
        push_lr = 150
        max_run_vel = 3.5
        push_up = 100
        max_climb_vel = 1.0
      elseif self.jg.legs.anim == self.poseanim.crawl then
        push_lr = 150
        max_run_vel = 3.5
        push_up = 100
        max_climb_vel = 1.0
      end
      
      -- Actually apply the forces, but only if we're going under the top speed both forward and up
      if self.is_ambulating_left then
        if self.unrotated_vel.mX > -max_run_vel then
          self.body_mo:PullTest4(self.body_mo:RotateVectorForGravity(VectorF(-push_lr, 0)))
        end
      else 
        if self.unrotated_vel.mX < max_run_vel then
          self.body_mo:PullTest4(self.body_mo:RotateVectorForGravity(VectorF(push_lr, 0)))
        end
      end
      -- Pull up too to keep him from dragging on ground
      if self.unrotated_vel.mY < max_climb_vel then
        self.body_mo:PullTest4(self.body_mo:RotateVectorForGravity(VectorF(0, push_up)))
      end
    end
  end


  -----------------------------------------------------------
  -- Update particle systems
  -----------------------------------------------------------

  -----------------------------------------------------------
  -- Jetpack


  -----------------------------------------------------------
  -- Skimming effects


  -----------------------------------------------------------
  -- Shield effects
  
  -------------------------------------------------------------
  -- Clear the Joint Group flags showing their state was changed this frame
  
  for name, joint_group in pairs(self.jg) do
    joint_group.state_changed = false
  end
  
	------------------------------------------------------------
	-- Aurium use and recharge updates
	
	-- Aurium use
	if self.is_flying_now() then
-- TODO: Figure out some procedural and understandable way to know what an appropriate amount of A charge a specfic thing uses
		self.aurium_charge = self.aurium_charge - (self.flight_aurium_consumption * scene:GetDeltaTime())
		-- Reset the timer since last A change
		self.aurium_charge_change_timer:Reset()
		-- Cap at 0
		if self.aurium_charge < 0 then self.aurium_charge = 0 end
	end
	
	-- Recharge if last Aurium use was past the required delay
	if self.no_aurium_use_timer:TimeIsUp() and self.aurium_charge < self.aurium_capacity then
		-- How much we want to try to consume from the Aurium store in the Controller
		local charge_consumption = self.aurium_recharge_rate * scene:GetDeltaTime()
		-- Don't try to consume more than we have room for in this battery
		if self.aurium_capacity - self.aurium_charge < charge_consumption then charge_consumption = self.aurium_capacity - self.aurium_charge end
		-- Ask to consume and also check how much we actually got to consume from the Controller
		charge_consumption = controller:ConsumeAurium(charge_consumption)
		-- Only add to charge if we actually had anything to consume from the Aurium Store in the Controller
		if charge_consumption > 0 then
			-- Add the consumed Aurium charge from the Store to this Assembly
			self.aurium_charge = self.aurium_charge + charge_consumption
			-- Reset the timer since last A change
			self.aurium_charge_change_timer:Reset()
			-- Also reset timer since last A recharge
			self.aurium_recharge_timer:Reset()
			-- Cap at max
			if self.aurium_charge > self.aurium_capacity then self.aurium_charge = self.aurium_capacity end
		end
	end

	-- Detect and time since last Controller's Aurium Store value change
	if self.aurium_last_store ~= controller:GetAurium() then 
		self.aurium_store_change_timer:Reset()
	end
	-- Store last recorded Aurium store value
	self.aurium_last_store = controller:GetAurium()
	
  ------------------------------------------------------------
  -- Debug draw the JGSs above the head

  if not self.body_mo or not self.head_mo then return end
	
	if false then
  -- Joint group states
  local textPos = self:GetApproxPos() + self.body_mo:RotateVectorForGravity(VectorF(0, 5))
  scene:WriteToScreenByWorldPos("Legs: " .. self.jg.legs.anim.name, textPos, VectorF(0,0), Yes, ColorRGBA(100,255,100,255))
  textPos = textPos - self.body_mo:RotateVectorForGravity(VectorF(0, 0.25))
  scene:WriteToScreenByWorldPos("Arm FG: " .. self.jg.arm_fg.anim.name, textPos, VectorF(0,0), Yes, ColorRGBA(100,255,100,255))
  textPos = textPos - self.body_mo:RotateVectorForGravity(VectorF(0, 0.25))
  scene:WriteToScreenByWorldPos("Arm BG: " .. self.jg.arm_bg.anim.name, textPos, VectorF(0,0), Yes, ColorRGBA(100,255,100,255))
  textPos = textPos - self.body_mo:RotateVectorForGravity(VectorF(0, 0.25))
  scene:WriteToScreenByWorldPos("Neck: " .. self.jg.neck.anim.name, textPos, VectorF(0,0), Yes, ColorRGBA(100,255,100,255))
  
  -- Leg anim number
  textPos = textPos - self.body_mo:RotateVectorForGravity(VectorF(0, 0.25))
  scene:WriteToScreenByWorldPos("Legs anim number: " .. self.jg.legs.anim_num, textPos, VectorF(0,0), Yes, ColorRGBA(100,255,100,255))
  
  -- Biped balancing state
  textPos = textPos - self.body_mo:RotateVectorForGravity(VectorF(0, 0.35))
  if self.balance_state == self.balance.BIPED then
    scene:WriteToScreenByWorldPos("Biped Balance!", textPos, VectorF(0,0), Yes, ColorRGBA(100,255,100,255))
	elseif self.balance_state == self.balance.LIFT then
    scene:WriteToScreenByWorldPos("Lift Balance", textPos, VectorF(0,0), Yes, ColorRGBA(100,255,100,255))
  else
    scene:WriteToScreenByWorldPos("No Balance!", textPos, VectorF(0,0), Yes, ColorRGBA(255,100,100,255))
  end
  
  -- Slippery of legs
  textPos = textPos - self.body_mo:RotateVectorForGravity(VectorF(0, 0.35))
  scene:WriteToScreenByWorldPos("Body slippery: " .. tostring(self.body_mo:GetSlippery()), textPos, VectorF(0,0), Yes, ColorRGBA(100,255,100,255))
  
  -- Slippery of head
  textPos = textPos - self.body_mo:RotateVectorForGravity(VectorF(0, 0.35))
  scene:WriteToScreenByWorldPos("Head slippery: " .. tostring(self.head_mo:GetSlippery()), textPos, VectorF(0,0), Yes, ColorRGBA(100,255,100,255))
  

  -- Altitude
  textPos = textPos - self.body_mo:RotateVectorForGravity(VectorF(0, 0.35))
  local altitude = self.get_altitude(10)
  if altitude then
    scene:WriteToScreenByWorldPos("Altitude: " .. tostring(altitude), textPos, VectorF(0,0), Yes, ColorRGBA(100,255,100,255))
  else
    scene:WriteToScreenByWorldPos("Altitude over 100m!", textPos, VectorF(0,0), Yes, ColorRGBA(100,255,100,255))
  end
--[[
  -- Angle of the move vector
  local moveAngle = controller:MoveVector():GetAngleRad()--self.body_mo:UnRotateAngleForGravity(self.body_mo:GetOrientation())
  textPos = textPos - self.body_mo:RotateVectorForGravity(VectorF(0, 0.35))
  scene:WriteToScreenByWorldPos("Move input angle: " .. tostring(moveAngle), textPos, VectorF(0,0), Yes, ColorRGBA(100,255,100,255))
 
  -- Angle of the torso
  local bodyAngle = self.body_mo:RotateAngleForGravity(self.body_mo:GetOrientation())
  textPos = textPos - self.body_mo:RotateVectorForGravity(VectorF(0, 0.35))
  scene:WriteToScreenByWorldPos("Body angle: " .. tostring(bodyAngle), textPos, VectorF(0,0), Yes, ColorRGBA(100,255,100,255))
]]--
end
  -- Update resource bars etc in UI
  pioneer_ui.update(self)
	
	
	
end












































